/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.timedio;

import com.sybase.jdbc2.timedio.URLDbio;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;

public class TDSTunnellingIS
extends InputStream {
    private URLDbio _dbio;
    private InputStream _is = null;
    private URLConnection _urlC = null;
    private int _length = -1;
    private long _timeout = 0L;

    public TDSTunnellingIS(URLDbio dbio) {
        this._dbio = dbio;
    }

    public int available() throws IOException {
        Debug.assert(this, false);
        return 0;
    }

    private void getIS() throws IOException {
        Debug.assert(this, this._length <= 0);
        while (true) {
            this._urlC = this._dbio.getURLC(this._timeout);
            this._length = this._urlC.getContentLength();
            if (this._length > 0) break;
            Debug.println(this, "Ignoring HTTP response of length = " + this._length);
        }
        this._is = this._urlC.getInputStream();
    }

    public int read() throws IOException {
        Debug.assert(this, false);
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        Debug.println(this, "read(), need = " + len);
        if (this._length <= 0) {
            Debug.println(this, "getting a new InputStream");
            this.getIS();
            Debug.assert(this, this._length >= 0);
        }
        int numToCopy = len > this._length ? this._length : len;
        int numRead = 0;
        while (numRead < numToCopy) {
            int thisRead = this._is.read(b, off + numRead, numToCopy);
            if (thisRead < 1) break;
            numToCopy -= thisRead;
            numRead += thisRead;
        }
        this._length -= numRead;
        if (this._length == 0) {
            this._is.close();
            this._urlC = null;
        }
        Debug.println(this, "read(), bytes read = " + numRead);
        return numRead;
    }

    protected synchronized int read(byte[] b, int off, int len, long timeout) throws IOException {
        this._timeout = timeout;
        Debug.println(this, "read(), timeout = " + timeout);
        return this.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        Debug.assert(this, false);
        return 0L;
    }
}

