/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.Protocol;
import com.sybase.jdbc2.jdbc.SybResultSet;
import com.sybase.jdbc2.tds.DoneToken;
import com.sybase.jdbc2.tds.PduInputFormatter;
import com.sybase.jdbc2.tds.RowFormatToken;
import com.sybase.jdbc2.tds.Tds;
import com.sybase.jdbc2.tds.TdsCursor;
import com.sybase.jdbc2.tds.TdsDataInputStream;
import com.sybase.jdbc2.tds.TdsEventContext;
import com.sybase.jdbc2.tds.TdsParamSet;
import com.sybase.jdbc2.tds.TdsResultSet;
import com.sybase.jdbc2.tds.Token;
import com.sybase.jdbc2.timedio.InStreamMgr;
import com.sybase.jdbc2.timedio.OutStreamMgr;
import com.sybase.jdbc2.timedio.StreamContext;
import com.sybase.jdbc2.utils.BufferInterval;
import com.sybase.jdbc2.utils.CacheManager;
import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbc2.utils.SyncObj;
import java.io.IOException;
import java.sql.SQLException;

public class TdsProtocolContext
extends StreamContext {
    protected static final int COLUMN_CHUNK_SIZE = 256;
    protected static final int LOW_BYTE = 255;
    protected static final int DONE_PACKET_SIZE = 17;
    protected static final int PDU_TAIL_SIZE = 8;
    protected Token _tdsToken;
    protected boolean _haveDone;
    protected int _lastResult;
    protected int _ungotResult;
    protected int _maxRows;
    protected int _lastTds;
    protected RowFormatToken _paramFmts;
    protected RowFormatToken _dynamicFmts;
    protected boolean _rereadable;
    protected TdsResultSet _trs;
    protected CacheManager _cm;
    protected PduInputFormatter _inFormat;
    protected TdsDataInputStream _in;
    public SQLException _chainedSqe;
    protected boolean _eed = false;
    protected TdsCursor _cursor;
    boolean _bigEndian = true;
    private byte[] _endOfLastPDU = null;

    public TdsProtocolContext(Protocol p, InStreamMgr inMgr, OutStreamMgr outMgr) {
        super(p, inMgr, outMgr);
        Debug.println(this, "Constructor");
        this._inFormat = new PduInputFormatter(this);
        Tds tds = (Tds)p;
        try {
            this._in = new TdsDataInputStream(tds, this._inFormat);
        }
        catch (IOException iOException) {
            Debug.assert(this, false);
        }
        this._bigEndian = tds._bigEndian;
        this._in.setBigEndian(this._bigEndian);
        this._is = this._in;
        this.clear(true);
        this._pduState = 0;
    }

    protected int available() {
        Debug.println(this, "available()");
        return this._responseQue.available(8);
    }

    protected void beginRequest() {
        Debug.println(this, "beginRequest(), _state = " + this._state);
        this.close(true);
        this._pduState = 5;
        if (this._state != 4) {
            this.setState(2);
        }
    }

    protected synchronized void cancelled() {
        Debug.println(this, "cancelled() _state = " + this._state);
        switch (this._state) {
            case 2: 
            case 3: {
                this.setState(5);
            }
            case 5: 
            case 6: {
                this._responseQue.release();
                break;
            }
        }
    }

    protected void chainException(SQLException sqe) {
        if (this._chainedSqe == null) {
            Debug.println(this, ">>> First Exception: " + sqe);
            this._chainedSqe = sqe;
        } else {
            Debug.println(this, ">>> chaining exceptions");
            if (sqe.getSQLState() != null && sqe.getSQLState().equals("JZ0F2")) {
                sqe.setNextException(this._chainedSqe);
                this._chainedSqe = sqe;
            } else {
                this._chainedSqe.setNextException(sqe);
            }
        }
    }

    protected boolean checkBufStat(int status) {
        if ((status & 8) != 0) {
            this._pduState = 3;
            return true;
        }
        return false;
    }

    private void clear(boolean all) {
        Debug.println(this, "clear(" + all + ")");
        this._chainedSqe = null;
        this._lastResult = -1;
        this._ungotResult = -1;
        this._tdsToken = null;
        this._haveDone = false;
        this._eed = false;
        this._paramFmts = null;
        this._trs = null;
        Debug.assert(this, this._state != 6);
        if (this._state != 4) {
            if (all) {
                BufferInterval bi;
                while ((bi = this._responseQue.pop()) != null) {
                    bi.free();
                }
            }
            this.setState(1);
        }
        if (this._cm != null) {
            this._cm.allDead();
        }
    }

    protected void close(boolean all) {
        Debug.println(this, "close() " + this + " _state = " + this._state);
        SQLException saveSqe = this._chainedSqe;
        this._inFormat.close();
        this.clear(all);
        this._chainedSqe = saveSqe;
    }

    public void drop() {
        this.close(true);
    }

    protected void dump(SyncObj sendOwner, SyncObj readOwner) {
    }

    public BufferInterval getChunk() throws IOException {
        Debug.println(this, "getChunk() " + this + " _state = " + this._state);
        switch (this._state) {
            case 1: {
                Debug.assert(this, false);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                while (true) {
                    BufferInterval bi = null;
                    TdsProtocolContext tdsProtocolContext = this;
                    synchronized (tdsProtocolContext) {
                        bi = this._responseQue.pop();
                        if (bi == null) {
                            if (this._state == 5 || this._state == 6) {
                                ErrorMessage.raiseIOException("JZ0PA");
                            }
                            if (this._state == 3) {
                                ErrorMessage.raiseIOException("JZ0EM");
                            }
                        } else if (this._state != 5 && this._state != 6) {
                            BufferInterval bufferInterval = bi;
                            Object var4_4 = null;
                            return bufferInterval;
                        }
                    }
                    if (bi == null) {
                        this._inMgr.doRead(this);
                        continue;
                    }
                    bi.free();
                    ErrorMessage.raiseIOException("JZ0PA");
                }
            }
        }
        return null;
    }

    protected SybResultSet getParams() {
        Debug.println(this, "getParams()");
        SybResultSet params = null;
        int nextRes = 0;
        SQLException saveSqe = this._chainedSqe;
        this._chainedSqe = null;
        try {
            block21: {
                try {
                    while (true) {
                        nextRes = this._protocol.nextResult(this);
                        block2 : switch (nextRes) {
                            case 3: {
                                switch (this._lastTds) {
                                    case 32: 
                                    case 236: {
                                        if (this._lastTds == 236) {
                                            Debug.println(this, "See param fmt");
                                        } else {
                                            Debug.println(this, "See param fmt2");
                                        }
                                        this._trs = new TdsParamSet(this, false);
                                        params = new SybResultSet(null, this._trs);
                                        this._trs._needNext = false;
                                        this._lastResult = -1;
                                        break block2;
                                    }
                                    case 215: {
                                        Debug.println(this, "See params");
                                        this._lastResult = -1;
                                        break;
                                    }
                                    default: {
                                        Debug.assert(this, false);
                                        this._protocol.ungetResult(this, this._lastTds);
                                        break;
                                    }
                                }
                                break block21;
                            }
                            case 0: {
                                Debug.println(this, "Got Done result");
                                Debug.assert(this, this._tdsToken != null);
                                Debug.assert(this, this._tdsToken instanceof DoneToken);
                                Debug.assert(this, (((DoneToken)this._tdsToken)._status & 0x40) == 64);
                                this._protocol.ungetResult(this, nextRes);
                                break block21;
                            }
                            default: {
                                this._protocol.ungetResult(this, nextRes);
                                break;
                            }
                        }
                    }
                }
                catch (SQLException sqle) {
                    this.chainException(sqle);
                }
            }
            Object var5_5 = null;
            if (this._chainedSqe != null) {
                if (saveSqe != null) {
                    saveSqe.setNextException(this._chainedSqe);
                } else {
                    saveSqe = this._chainedSqe;
                }
            }
            this._chainedSqe = saveSqe;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (this._chainedSqe != null) {
                if (saveSqe != null) {
                    saveSqe.setNextException(this._chainedSqe);
                } else {
                    saveSqe = this._chainedSqe;
                }
            }
            this._chainedSqe = saveSqe;
            throw throwable;
        }
        return params;
    }

    protected synchronized boolean isCancelNeeded() {
        Debug.println(this, "IsCancelNeeded() _state = " + this._state + ", " + this);
        if (this._state == 2) {
            return true;
        }
        this.cancelled();
        return false;
    }

    public boolean isProcDone() {
        return (((DoneToken)this._tdsToken)._status & 8) == 8;
    }

    protected SybResultSet makeEmptyParams() {
        Debug.println(this, "makeEmptyParams()");
        SybResultSet params = null;
        try {
            this._paramFmts = new RowFormatToken();
            this._trs = new TdsParamSet(this, true);
            params = new SybResultSet(null, this._trs);
        }
        catch (SQLException sQLException) {}
        return params;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected BufferInterval queueData(BufferInterval bi) {
        Debug.println(this, "queueData: " + bi._buf + ", offset =  " + bi._offset + ", length = " + bi._length);
        this._pduState = 1;
        int offset = bi._offset;
        int nBytes = bi._length;
        byte[] buf = bi._buf;
        int type = 0;
        int status = 0;
        int packetLen = 0;
        while (true) {
            block41: {
                if (nBytes <= 0) {
                    return bi;
                }
                int pos = offset;
                if (this._state == 5) {
                    this._pduState = 0;
                    this._responseQue.release();
                    return bi;
                }
                if (nBytes < 8) {
                    this._pduState = 2;
                    return bi;
                }
                pos = offset;
                type = buf[pos++] & 0xFF;
                status = buf[pos++] & 0xFF;
                if (nBytes < (packetLen = ((buf[pos++] & 0xFF) << 8) + (0xFF & buf[pos++]))) {
                    this._pduState = 2;
                    return bi;
                }
                nBytes -= packetLen;
                offset += packetLen;
                Debug.println(this, "type = " + type + ", status = " + status + ", length = " + packetLen);
                if (this.checkBufStat(status)) return bi;
                boolean done = (status & 1) != 0;
                boolean slurp = false;
                boolean gotAttnAck = false;
                TdsProtocolContext tdsProtocolContext = this;
                synchronized (tdsProtocolContext) {
                    block39: {
                        boolean gotCancelAck;
                        block40: {
                            block32: {
                                block36: {
                                    block38: {
                                        Tds tds;
                                        block37: {
                                            block33: {
                                                block35: {
                                                    block34: {
                                                        if ((status & 2) != 0) {
                                                            Debug.println(this, "BUFSTAT_ATTNACK received!");
                                                            done = true;
                                                            gotAttnAck = true;
                                                            if (this._state != 5 && this._state != 4) {
                                                                this.cancelled();
                                                            }
                                                        }
                                                        gotCancelAck = gotAttnAck;
                                                        if (!done) break block32;
                                                        int doneStatusOffset = DoneToken.getStatusOffset(this._bigEndian);
                                                        if (packetLen >= 9 - doneStatusOffset && !gotCancelAck) {
                                                            gotCancelAck = (buf[offset - 9 + doneStatusOffset] & 0x20) != 0;
                                                            Debug.println(this, "CANCEL ACK at end of current packet? " + gotCancelAck);
                                                        }
                                                        tds = (Tds)this._protocol;
                                                        if (this._state != 4) break block33;
                                                        if (packetLen >= 17 || gotAttnAck) break block34;
                                                        if (this._endOfLastPDU == null) {
                                                            slurp = true;
                                                            break block35;
                                                        } else {
                                                            int doneStart = 8 - (9 - (packetLen - 8));
                                                            if (doneStart + doneStatusOffset < 8 && !gotAttnAck) {
                                                                gotCancelAck = (this._endOfLastPDU[doneStart + doneStatusOffset] & 0x20) != 0;
                                                            }
                                                            Debug.println(this, "split DONE : " + this + ", length = " + packetLen + ", state = " + this._state + " gotCancelAck = " + gotCancelAck);
                                                            if (gotCancelAck) {
                                                                BufferInterval endBI = this._inMgr.getBI();
                                                                pos = endBI._offset;
                                                                endBI._buf[pos++] = (byte)(type & 0xFF);
                                                                endBI._buf[pos++] = (byte)(status & 0xFF);
                                                                endBI._buf[pos++] = 0;
                                                                endBI._buf[pos++] = 17;
                                                                endBI._buf[pos++] = 0;
                                                                endBI._buf[pos++] = 0;
                                                                endBI._buf[pos++] = 0;
                                                                endBI._buf[pos++] = 0;
                                                                int lenInLastPDU = 8 - doneStart;
                                                                System.arraycopy(this._endOfLastPDU, doneStart, endBI._buf, pos, lenInLastPDU);
                                                                System.arraycopy(bi._buf, offset - (9 - lenInLastPDU), endBI._buf, pos += lenInLastPDU, 9 - lenInLastPDU);
                                                                endBI._length = 17;
                                                                bi.free();
                                                                bi = endBI;
                                                                packetLen = 17;
                                                                this._endOfLastPDU = null;
                                                            }
                                                        }
                                                        break block35;
                                                    }
                                                    if (packetLen > 17 && gotCancelAck) {
                                                        pos = offset - 17;
                                                        buf[pos++] = (byte)(type & 0xFF);
                                                        buf[pos++] = (byte)(status & 0xFF);
                                                        buf[pos++] = 0;
                                                        buf[pos++] = 17;
                                                        Debug.println(this, "trim packet: " + this + ", length = " + packetLen + ", state = " + this._state);
                                                        BufferInterval junk = bi.divide(packetLen - 17);
                                                        junk.free();
                                                        packetLen = 17;
                                                    }
                                                }
                                                if (!gotCancelAck) {
                                                    slurp = true;
                                                }
                                                break block36;
                                            }
                                            if (this._state != 6) break block37;
                                            this.setState(5);
                                            slurp = true;
                                            break block36;
                                        }
                                        if (!gotCancelAck || !tds._gotCancelAck) break block38;
                                        BufferInterval junk = null;
                                        if (packetLen < bi._length) {
                                            junk = bi.divide(packetLen);
                                        } else {
                                            junk = bi;
                                            bi = null;
                                        }
                                        junk.free();
                                        break block39;
                                    }
                                    this.setState(3);
                                }
                                if (!(this instanceof TdsEventContext)) {
                                    tds._gotCancelAck = gotCancelAck;
                                }
                                break block40;
                            }
                            if (this._state == 4) {
                                if (this._endOfLastPDU == null) {
                                    this._endOfLastPDU = new byte[8];
                                }
                                Debug.assert(this, bi._length > 8);
                                System.arraycopy(bi._buf, bi._offset + packetLen - 8, this._endOfLastPDU, 0, 8);
                            }
                            boolean bl = slurp = this._state == 6 || this._state == 4;
                        }
                        if (done && (this._state != 4 || gotCancelAck)) {
                            this._pduState = 0;
                            if (!(this instanceof TdsEventContext)) {
                                this._inMgr.setCurrentContextNull();
                            }
                        }
                        bi = this.makeChunk(bi, packetLen, slurp);
                        if (!done) break block41;
                        if (this._state == 4 && gotCancelAck) {
                            this._responseQue.release();
                        } else if (gotCancelAck) {
                            this._pduState = 0;
                            this._responseQue.release();
                        }
                    }
                    Object var13_21 = null;
                    break;
                }
            }
        }
        return bi;
    }

    protected void refreshYourself(Protocol p, InStreamMgr inMgr, OutStreamMgr outMgr) {
        Debug.println(this, "Refreshing Myself");
        super.refreshYourself(p, inMgr, outMgr);
        this._inFormat = new PduInputFormatter(this);
        Tds tds = (Tds)p;
        try {
            this._in = new TdsDataInputStream(tds, this._inFormat);
        }
        catch (IOException iOException) {
            Debug.assert(this, false);
        }
        this._bigEndian = tds._bigEndian;
        this._in.setBigEndian(this._bigEndian);
        this.clear(true);
        this._pduState = 0;
    }

    protected void setRereadable() {
        this._cm = new CacheManager(this._in);
        this._cm.setReReadable(true);
        this._cm.setCacheSize(-1);
        this._cm.setChunkSize(256);
        this._cm.setAbortOnCacheOverflow(true);
    }

    protected void setState(int newState) {
        super.setState(newState);
    }
}

