/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.DateObject;
import com.sybase.jdbc2.utils.Debug;
import java.sql.SQLException;
import java.util.Calendar;

public class TdsDateTime {
    private static final int BASEBIAS = 53690;
    private static final int BASEYEAR = 1753;
    private static final int CENTURY_ADJUST = 52;
    private static final int TIMEMASK = 0x1FFFFFF;
    private static final int C300TH_P_HOUR = 1080000;
    private static final int C300TH_P_MIN = 18000;
    private static final int[] MONTHDAYS = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] LMONTHDAYS = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int YEAR = 0;
    private static final int MONTH = 1;
    private static final int DAY = 2;
    private static final int HOUR = 3;
    private static final int MINUTE = 4;
    private static final int SECS = 5;
    int[] _timestamp = new int[6];
    long _nano = 0L;
    DateObject _dateObj = null;

    public TdsDateTime(int dayNum, int timeNum) {
        Debug.println(null, "timestampValue(" + dayNum + ", " + timeNum);
        TdsDateTime.numToYearMonthDay(dayNum, this._timestamp);
        this._timestamp[3] = (timeNum &= 0x1FFFFFF) / 1080000;
        this._timestamp[4] = timeNum / 18000 % 60;
        this._timestamp[5] = timeNum / 300 % 60;
        this._nano = (long)timeNum % 300L * 10000000L / 3L;
        Debug.println(null, "creating timestamp\n    year = " + this._timestamp[0] + "\n    month = " + this._timestamp[2] + "\n    day = " + this._timestamp[1] + "\n    hour = " + this._timestamp[3] + "\n    minute = " + this._timestamp[4] + "\n    second = " + this._timestamp[5] + "\n    nano = " + this._nano);
    }

    public TdsDateTime(int dayNum, int timeNum, int dummy) {
        TdsDateTime.numToYearMonthDay(dayNum, this._timestamp);
        this._timestamp[3] = timeNum / 60;
        this._timestamp[4] = timeNum % 60;
        Debug.println(null, "creating timestamp\n    year = " + this._timestamp[0] + "\n    month = " + this._timestamp[1] + "\n    day = " + this._timestamp[2] + "\n    hour = " + this._timestamp[3] + "\n    minute = " + this._timestamp[4]);
    }

    private DateObject convertToDateObject(Calendar userCal) throws SQLException {
        DateObject dateObj = null;
        dateObj = new DateObject(userCal);
        Calendar cal = dateObj.getCalendar();
        cal.set(1, this._timestamp[0]);
        cal.set(2, this._timestamp[1]);
        cal.set(5, this._timestamp[2]);
        cal.set(11, this._timestamp[3]);
        cal.set(12, this._timestamp[4]);
        cal.set(13, this._timestamp[5]);
        dateObj.setNanos((int)this._nano);
        return dateObj;
    }

    public DateObject dateObjectValue() throws SQLException {
        return this.dateObjectValue(null);
    }

    public DateObject dateObjectValue(Calendar cal) throws SQLException {
        if (this._dateObj == null) {
            this._dateObj = this.convertToDateObject(cal);
        }
        return this._dateObj;
    }

    private static int leapcnt(int year) {
        int century = (year + 52) / 100;
        int leaps = year / 4 - century + (century + 1) / 4;
        Debug.println(null, "leapcnt(" + year + ") = " + leaps);
        return leaps;
    }

    private static boolean leapyear(int year) {
        boolean retval = (year += 1753) % 4 == 0 && year % 100 != 0 || year % 400 == 0;
        Debug.println(null, "leapyear(" + year + ") = " + retval);
        return retval;
    }

    private static void numToYearMonthDay(int dayNum, int[] ymd) {
        int leapYears;
        int dayInYear;
        int year = (dayNum += 53690) / 365;
        while ((dayInYear = dayNum - (year * 365 + (leapYears = TdsDateTime.leapcnt(year)))) < 0) {
            --year;
        }
        int[] lp = MONTHDAYS;
        if (TdsDateTime.leapyear(year)) {
            lp = LMONTHDAYS;
        }
        year += 1753;
        int day = dayInYear;
        int month = 0;
        while (day >= lp[month]) {
            day -= lp[month];
            ++month;
        }
        ymd[0] = year;
        ymd[1] = month;
        ymd[2] = day + 1;
    }

    protected String stringValue() throws SQLException {
        String nanoS;
        StringBuffer s = new StringBuffer(26);
        double nanod = (double)this._nano / 1.0E9;
        if (nanod == 0.0) {
            nanoS = "0.0";
        } else {
            nanoS = String.valueOf(nanod);
            if (nanoS.length() > 5) {
                nanoS = nanoS.substring(0, 5);
            }
        }
        s.append(this._timestamp[0]);
        s.append('-');
        if (this._timestamp[1] < 9) {
            s.append('0');
        }
        s.append(this._timestamp[1] + 1);
        s.append('-');
        if (this._timestamp[2] < 10) {
            s.append('0');
        }
        s.append(this._timestamp[2]);
        s.append(' ');
        if (this._timestamp[3] < 10) {
            s.append('0');
        }
        s.append(this._timestamp[3]);
        s.append(':');
        if (this._timestamp[4] < 10) {
            s.append('0');
        }
        s.append(this._timestamp[4]);
        s.append(':');
        if (this._timestamp[5] < 10) {
            s.append('0');
        }
        s.append(this._timestamp[5]);
        s.append('.');
        s.append(nanoS.substring(2));
        return s.toString();
    }

    public static int[] tdsDateTime(DateObject dateObj) {
        int[] dt = new int[2];
        Calendar cal = dateObj.getCalendar();
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5) - 1;
        int hour = cal.get(11);
        int minutes = cal.get(12);
        int seconds = cal.get(13);
        double nanos = dateObj.getNanos();
        dt[0] = TdsDateTime.ymdToNum(year, month, day);
        int roundedNanos = (int)Math.round(nanos * 3.0 / 1.0E7);
        dt[1] = ((hour * 60 + minutes) * 60 + seconds) * 300 + roundedNanos;
        if (nanos != 0.0 && roundedNanos == 300) {
            dt[1] = dt[1] - 1;
        }
        Debug.println(null, "Converting calendar " + cal + " to Datetime " + year + "/" + month + "/" + day + " as " + dt[0] + "," + dt[1]);
        return dt;
    }

    private static int ymdToNum(int year, int month, int day) {
        int dayNum = (year -= 1753) * 365 + TdsDateTime.leapcnt(year);
        int[] lp = MONTHDAYS;
        if (TdsDateTime.leapyear(year)) {
            lp = LMONTHDAYS;
        }
        int i = 0;
        while (i < month) {
            dayNum += lp[i];
            ++i;
        }
        dayNum += day;
        return dayNum -= 53690;
    }
}

