/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.TdsDataOutputStream;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.tds.TdsJdbcInputStream;
import com.sybase.jdbc2.tds.TdsOutputStream;
import com.sybase.jdbc2.tds.TdsParam;
import com.sybase.jdbc2.tds.Token;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.sql.SQLException;

public class DataFormat
extends Token {
    public static final int MAX_DATAFMT_LENGTH = 136;
    protected String _name;
    protected int _status;
    protected int _usertype;
    protected int _datatype;
    protected int _length;
    protected int _precision;
    protected int _scale;
    protected String _locale;
    protected int _localeLen;
    protected int _nameLen;
    protected String _tableName;
    protected String _className = null;
    protected int _blobType;
    protected int _classIdLen;

    protected DataFormat() {
    }

    public DataFormat(TdsInputStream in) throws IOException {
        this.newDataFormat(in, true);
    }

    public DataFormat(TdsInputStream in, boolean locale) throws IOException {
        this.newDataFormat(in, locale);
    }

    public DataFormat(TdsParam p, TdsOutputStream tos) throws IOException {
        Debug.println(this, "In the DataFormat (TdsParam, TdsOutputStream) constructor");
        this._nameLen = 0;
        this._name = p._name;
        if (this._name != null) {
            this._nameLen = this._name.length();
        }
        this._status = p._inValue == null ? 32 : 0;
        this._status |= p._regType != -999 ? 1 : 0;
        this._usertype = 0;
        this._locale = null;
        int[] dataInfo = new int[4];
        ((TdsDataOutputStream)tos).dataTypeInfo(p, dataInfo);
        this._datatype = dataInfo[0];
        switch (this._datatype) {
            case 9217: {
                this._datatype = 36;
                this._blobType = 1;
                if (p._inValue != null) {
                    this._className = p._outParamClassName != null ? p._outParamClassName : p._inValue.getClass().getName();
                } else {
                    this._className = p._outParamClassName != null ? p._outParamClassName : "";
                    Debug.println(this, "_className is " + this._className);
                }
                this._classIdLen = this._className.length();
                break;
            }
            case 9220: {
                this._datatype = 36;
                this._blobType = 4;
                break;
            }
            case 9219: {
                this._datatype = 36;
                this._blobType = 3;
                break;
            }
            case 225: {
                if (!p._parameterHoldsUnicharData) break;
                this._usertype = 35;
                break;
            }
        }
        this._length = DataFormat.maxLength(p, this._datatype, dataInfo[1]);
        this._precision = dataInfo[2];
        this._scale = dataInfo[3];
    }

    public static String getDataTypeString(int datatype) {
        switch (datatype) {
            case 34: {
                return "IMAGE";
            }
            case 35: {
                return "TEXT";
            }
            case 37: {
                return "VARBINARY";
            }
            case 38: {
                return "INTN";
            }
            case 45: {
                return "BINARY";
            }
            case 47: {
                return "CHAR";
            }
            case 50: {
                return "BIT";
            }
            case 61: {
                return "DATETIM";
            }
            case 58: {
                return "SHORTDATE";
            }
            case 111: {
                return "DATETIMN";
            }
            case 106: {
                return "DECN";
            }
            case 59: {
                return "FLT4";
            }
            case 62: {
                return "FLT8";
            }
            case 109: {
                return "FLTN";
            }
            case 48: {
                return "INT1";
            }
            case 52: {
                return "INT2";
            }
            case 56: {
                return "INT4";
            }
            case 225: {
                return "LONGBINARY";
            }
            case 175: {
                return "LONGCHAR";
            }
            case 60: {
                return "MONEY";
            }
            case 122: {
                return "SHORTMONEY";
            }
            case 110: {
                return "MONEYN";
            }
            case 108: {
                return "NUMN";
            }
            case 103: {
                return "SENSITIVITY";
            }
            case 104: {
                return "BOUNDARY";
            }
            case 39: {
                return "VARCHAR";
            }
            case 36: {
                return "BLOB";
            }
            case 31: {
                return "VOID";
            }
            case 255: {
                return "UNKNOWN";
            }
        }
        return "<unrecognized>";
    }

    public int length() {
        int sum = 8 + (this._name == null ? 0 : this._name.length()) + DataFormat.lengthSize(this._datatype) + (this._locale == null ? 0 : this._locale.length());
        block0 : switch (this._datatype) {
            case 106: 
            case 108: {
                sum += 2;
                break;
            }
            case 36: 
            case 9217: {
                switch (this._blobType) {
                    case 1: 
                    case 3: 
                    case 4: {
                        sum += 3 + this._classIdLen;
                        break block0;
                    }
                }
                Debug.assert(this, false);
                break;
            }
            case 34: 
            case 35: {
                sum += 2 + (this._name == null ? 0 : this._name.length());
                break;
            }
        }
        return sum;
    }

    protected static int lengthSize(int tdsType) {
        switch (tdsType) {
            case 36: 
            case 48: 
            case 50: 
            case 52: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 122: 
            case 9219: 
            case 9220: {
                return 0;
            }
            case 37: 
            case 38: 
            case 39: 
            case 45: 
            case 47: 
            case 103: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                return 1;
            }
            case 34: 
            case 35: 
            case 175: 
            case 225: {
                return 4;
            }
            case 31: 
            case 255: {
                Debug.notImplemented(null, "lengthSize() for type " + tdsType);
                break;
            }
            default: {
                Debug.assert(null, false, "Invalid TDS-datatype seen" + tdsType);
            }
        }
        return -1;
    }

    protected static int maxLength(TdsParam p, int datatype, int length) {
        switch (datatype) {
            case 48: 
            case 50: {
                return 1;
            }
            case 52: {
                return 2;
            }
            case 56: 
            case 58: 
            case 59: 
            case 122: {
                return 4;
            }
            case 38: 
            case 60: 
            case 61: 
            case 62: {
                return length > 0 ? length : 4;
            }
            case 110: 
            case 111: {
                return length > 0 ? length : 8;
            }
            case 109: {
                if (length > 0) {
                    return length;
                }
                if (p._sqlType == 7) {
                    return 4;
                }
                return 8;
            }
            case 37: 
            case 39: 
            case 45: 
            case 47: 
            case 103: 
            case 104: {
                return 255;
            }
            case 106: 
            case 108: {
                return 33;
            }
            case 34: 
            case 35: 
            case 36: 
            case 175: 
            case 225: 
            case 9219: 
            case 9220: {
                return Integer.MAX_VALUE;
            }
            case 31: 
            case 255: {
                Debug.notImplemented(null, "maxLength(dataLength) for type " + datatype);
                break;
            }
            default: {
                Debug.assert(null, false, "Invalid TDS-datatype seen " + datatype);
            }
        }
        return 0;
    }

    protected void newDataFormat(TdsInputStream in, boolean hasLocale) throws IOException {
        try {
            this.readMetaInfo(in);
            this.readStatus(in);
            this._usertype = in.readInt();
            this._datatype = in.readUnsignedByte();
            this._precision = 0;
            this._scale = 0;
            this._length = 0;
            Debug.println(this, "creating new dataformat for" + this._name + " " + this._status + " " + this._usertype + " " + this._datatype);
            block2 : switch (this._datatype) {
                case 48: 
                case 50: {
                    this._length = 1;
                    break;
                }
                case 52: {
                    this._length = 2;
                    break;
                }
                case 56: 
                case 58: 
                case 59: 
                case 122: {
                    this._length = 4;
                    break;
                }
                case 60: 
                case 61: 
                case 62: {
                    this._length = 8;
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 47: 
                case 103: 
                case 104: 
                case 109: 
                case 110: 
                case 111: {
                    this._length = in.readUnsignedByte();
                    break;
                }
                case 106: 
                case 108: {
                    this._length = in.readUnsignedByte();
                    this._precision = in.readUnsignedByte();
                    this._scale = in.readUnsignedByte();
                    break;
                }
                case 175: 
                case 225: {
                    this._length = in.readInt();
                    break;
                }
                case 34: 
                case 35: {
                    this._length = in.readInt();
                    this._tableName = in.readString(in.readUnsignedShort());
                    break;
                }
                case 36: {
                    this._blobType = in.readUnsignedByte();
                    this._classIdLen = in.readShort();
                    Debug.println(this, " blob subtype = " + this._blobType + " and classIDLen = " + this._classIdLen);
                    switch (this._blobType) {
                        case 1: {
                            this._className = in.readString(this._classIdLen);
                            Debug.println(this, "classname = " + this._className);
                            break block2;
                        }
                        case 3: 
                        case 4: {
                            Debug.assert(this, this._classIdLen == 0);
                            in.skip(this._classIdLen);
                            break block2;
                        }
                    }
                    in.skip(this._classIdLen);
                    Debug.assert(this, false, "Invalid TDS-datatype seen");
                    break;
                }
                case 31: 
                case 255: {
                    Debug.notImplemented(this, "columnInfo(dataLength) for type " + this._datatype);
                    break;
                }
                default: {
                    Debug.assert(this, false, "Invalid TDS-datatype: " + this._datatype);
                }
            }
            if (this._className == null) {
                try {
                    this._className = TdsJdbcInputStream.getObjectClassName(this._datatype, this._blobType, this._length);
                }
                catch (SQLException sqe) {
                    throw new IOException(sqe.getMessage());
                }
            }
            if (hasLocale) {
                int localeLen = in.readUnsignedByte();
                this._locale = localeLen > 0 ? in.readString(localeLen) : "";
            }
            switch (this._datatype) {
                case 60: 
                case 110: 
                case 122: {
                    this._scale = 4;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (IOException ioe) {
            Token.readSQE(ioe);
        }
    }

    protected void readMetaInfo(TdsInputStream in) throws IOException {
        try {
            this._nameLen = in.readUnsignedByte();
            this._name = this._nameLen > 0 ? in.readString(this._nameLen) : "";
        }
        catch (IOException ioe) {
            Token.readSQE(ioe);
        }
    }

    protected void readStatus(TdsInputStream in) throws IOException {
        Debug.println(this, "Reading unsigned byte for status");
        this._status = in.readUnsignedByte();
    }

    public void send(TdsOutputStream out) throws IOException {
        this.sendMetaInfo(out);
        this.sendStatus(out);
        out.writeInt(this._usertype);
        switch (this._datatype) {
            case 9219: {
                this._blobType = 3;
                out.writeByte(36);
                break;
            }
            case 9220: {
                this._blobType = 4;
                out.writeByte(36);
                break;
            }
            default: {
                out.writeByte(this._datatype);
            }
        }
        block4 : switch (this._datatype) {
            case 37: 
            case 38: 
            case 39: 
            case 45: 
            case 47: 
            case 103: 
            case 104: 
            case 109: 
            case 110: 
            case 111: {
                out.writeByte(this._length);
                break;
            }
            case 106: 
            case 108: {
                out.writeByte(this._length);
                out.writeByte(this._precision);
                out.writeByte(this._scale);
                break;
            }
            case 175: 
            case 225: {
                out.writeInt(this._length);
                break;
            }
            case 36: 
            case 9219: 
            case 9220: {
                out.writeByte(this._blobType);
                switch (this._blobType) {
                    case 1: {
                        byte[] cvtClassName = out.stringToByte(this._className);
                        if (cvtClassName == null) {
                            out.writeShort(0);
                            break block4;
                        }
                        out.writeShort(cvtClassName.length);
                        out.write(cvtClassName);
                        break block4;
                    }
                    case 3: 
                    case 4: {
                        out.writeShort(0);
                        break block4;
                    }
                }
                Debug.assert(this, false);
                break;
            }
            case 34: 
            case 35: {
                out.writeInt(this._length);
                byte[] cvtString = out.stringToByte(this._name);
                out.writeShort(cvtString.length);
                out.write(cvtString);
                break;
            }
            case 31: 
            case 255: {
                Debug.notImplemented(this, "send(dataLength) for type " + this._datatype);
                break;
            }
            default: {
                Debug.assert(this, false, "Invalid TDS-datatype seen");
            }
            case 48: 
            case 50: 
            case 52: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 122: 
        }
        if (this._locale == null) {
            out.writeByte(0);
        } else {
            byte[] localeBytes = out.stringToByte(this._locale);
            int localeLen = localeBytes.length > 255 ? 255 : localeBytes.length;
            out.writeByte(localeLen);
            out.write(localeBytes, 0, localeLen);
        }
    }

    protected void sendMetaInfo(TdsOutputStream out) throws IOException {
        byte[] cvtString = out.stringToByte(this._name);
        if (cvtString == null) {
            out.writeByte(0);
        } else {
            out.writeByte(cvtString.length);
            out.write(cvtString);
        }
    }

    protected void sendStatus(TdsOutputStream out) throws IOException {
        out.writeByte(this._status);
    }
}

