/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.TdsCursor;
import com.sybase.jdbc2.tds.TdsDataOutputStream;
import com.sybase.jdbc2.tds.TdsResultSet;
import com.sybase.jdbc2.tds.Token;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;

public class CurUpdateToken
extends Token {
    private TdsCursor _cursor;
    private TdsResultSet _trs;
    private String _setClause;
    protected int _status;

    protected CurUpdateToken() {
    }

    public CurUpdateToken(TdsCursor cursor, TdsResultSet trs, String setClause, boolean hasArgs) {
        this._cursor = cursor;
        this._trs = trs;
        this._setClause = setClause;
        this._status = hasArgs ? 1 : 0;
    }

    public void send(TdsDataOutputStream out) throws IOException {
        Debug.println(this, "send " + this.toString());
        int length = 8;
        Object cvtName = null;
        boolean nameLen = false;
        byte[] cvtTable = null;
        int tableLen = 0;
        if (this._cursor._table != null) {
            cvtTable = out.stringToByte(this._cursor._table);
            tableLen = cvtTable.length;
            length += tableLen;
        }
        byte[] cvtSetClause = out.stringToByte(this._setClause);
        int setClauseLen = cvtSetClause.length;
        length += setClauseLen;
        try {
            out.writeByte(133);
            out.writeShort(length);
            out.writeInt(this._cursor._id);
            out.writeByte(this._status);
            out.writeByte(tableLen);
            if (this._cursor._table != null) {
                out.write(cvtTable);
            }
            out.writeShort(setClauseLen);
            out.write(cvtSetClause);
        }
        catch (IOException ioe) {
            Token.writeSQE(ioe);
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer("CurUpdateToken: ");
        s.append(this._cursor._id == 0 ? "curId= " + this._cursor._id : "name= " + this._cursor.getName());
        s.append(", status= " + this._status);
        s.append(", table= " + this._cursor._table);
        s.append(", setClause= " + this._setClause);
        return s.toString();
    }
}

