/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.SybProperty;
import com.sybase.jdbc2.tds.CapabilitySet;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.tds.TdsOutputStream;
import com.sybase.jdbc2.tds.Token;
import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbc2.utils.HexConverts;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;

public class CapabilityToken
extends Token {
    protected CapabilitySet _reqCaps;
    protected CapabilitySet _respCaps;
    protected Vector _allCapSets = new Vector();
    protected int _totalLen;
    protected int _capsTry = 0;
    protected boolean _wideTableOn = false;
    protected static final String[] REQUEST_LABELS = new String[]{"NONE", "REQ_LANG", "REQ_RPC", "REQ_EVT", "REQ_MSTMT", "REQ_BCP", "REQ_CURSOR", "REQ_DYNF", "REQ_MSG", "REQ_PARAM", "DATA_INT1", "DATA_INT2", "DATA_INT4", "DATA_BIT", "DATA_CHAR", "DATA_VCHAR", "DATA_BIN", "DATA_VBIN", "DATA_MNY8", "DATA_MNY4", "DATA_DATE8", "DATA_DATE4", "DATA_FLT4", "DATA_FLT8", "DATA_NUM", "DATA_TEXT", "DATA_IMAGE", "DATA_DEC", "DATA_LCHAR", "DATA_LBIN", "DATA_INTN", "DATA_DATETIMEN", "DATA_MONEYN", "CSR_PREV", "CSR_FIRST", "CSR_LAST", "CSR_ABS", "CSR_REL", "CSR_MULTI", "CON_OOB", "CON_INBAND", "CON_LOGICAL", "PROTO_TEXT", "PROTO_BULK", "REQ_URGEVT", "DATA_SENSITIVITY", "DATA_BOUNDARY", "PROTO_DYNAMIC", "PROTO_DYNPROC", "DATA_FLTN", "DATA_BITN", "DATA_INT8", "DATA_VOID", "DOL_BULK", "OBJECT_JAVA1", "OBJECT_CHAR", "DATA_ZEROLEN", "OBJECT_BINARY", "REQ_RESERVED1", "WIDETABLE", "REQ_RESERVED2", "DATA_UINT2", "DATA_UINT4", "DATA_UINT8", "DATA_UINTN", "CUR_IMPLICIT", "DATA_NLBIN", "IMAGE_NCHAR", "BLOB_NCHAR_16", "BLOB_NCHAR_8", "BLOB_NCHAR_SCSU"};
    protected static final String[] RESPONSE_LABELS = new String[]{"NONE", "RES_NOMSG", "RES_NOEED", "RES_NOPARAM", "DATA_NOINT1", "DATA_NOINT2", "DATA_NOINT4", "DATA_NOBIT", "DATA_NOCHAR", "DATA_NOVCHAR", "DATA_NOBIN", "DATA_NOVBIN", "DATA_NOMNY8", "DATA_NOMNY4", "DATA_NODATE8", "DATA_NODATE4", "DATA_NOFLT4", "DATA_NOFLT8", "DATA_NONUM", "DATA_NOTEXT", "DATA_NOIMAGE", "DATA_NODEC", "DATA_NOLCHAR", "DATA_NOLBIN", "DATA_NOINTN", "DATA_NODATETIMEN", "DATA_NOMONEYN", "CON_NOOOB", "CON_NOINBAND", "PROTO_NOTEXT", "PROTO_NOBULK", "DATA_NOSENSITIVITY", "DATA_NOBOUNDARY", "RES_NOTDSDEBUG", "RES_NOSTRIPBLANKS", "DATA_NOINT8", "OBJECT_NOJAVA1", "OBJECT_NOCHAR", "DATA_NOZEROLEN", "OBJECT_NOBINARY", "RES_RESERVED1", "DATA_NOUNIT2", "DATA_NOUNIT4", "DATA_NOUNIT8", "DATA_NOUNITN", "NO_WIDETABLES", "DATA_NONLBIN", "IMAGE_NONCHAR", "BLOB_NONCHAR_16", "BLOB_NONCHAR_8", "BLOB_NONCHAR_SCSU"};

    public CapabilityToken() {
        CapabilitySet cs;
        int maskLen = 9;
        this._reqCaps = cs = new CapabilitySet(1, maskLen);
        this._allCapSets.addElement(cs);
        maskLen = 9;
        this._respCaps = cs = new CapabilitySet(2, maskLen);
        this._allCapSets.addElement(cs);
        this._totalLen = this._reqCaps._maskLen + this._respCaps._maskLen + 4;
        Debug.println(this, this.toString());
    }

    public CapabilityToken(TdsInputStream in) throws IOException, SQLException {
        try {
            int length = in.readShort();
            this._totalLen = length;
            while (length > 0) {
                int type = in.readUnsignedByte();
                int maskLen = in.readUnsignedByte();
                if (maskLen == 0) {
                    Debug.println(this, "aborting connection -- buggy capabilities");
                    ErrorMessage.raiseWarning("010SM");
                }
                Debug.println(this, "Capability: length = " + length + " type = " + type + " maskLen = " + maskLen);
                CapabilitySet cs = new CapabilitySet(type, maskLen);
                this._allCapSets.addElement(cs);
                int i = 1;
                while (i <= maskLen) {
                    int value = in.readUnsignedByte();
                    int j = 7;
                    while (j >= 0) {
                        if ((value & 1 << j) == 0) {
                            cs.clear(8 * (maskLen - i) + j);
                        } else {
                            cs.set(8 * (maskLen - i) + j);
                        }
                        --j;
                    }
                    ++i;
                }
                int lastKnownCap = 1;
                switch (type) {
                    case 1: {
                        lastKnownCap += 70;
                        this._reqCaps = cs;
                        break;
                    }
                    case 2: {
                        lastKnownCap += 50;
                        this._respCaps = cs;
                        break;
                    }
                }
                int i2 = lastKnownCap;
                while (i2 < 8 * maskLen) {
                    cs.clear(i2);
                    ++i2;
                }
                length -= 2 + maskLen;
            }
        }
        catch (IOException ioe) {
            Token.readSQE(ioe);
        }
    }

    protected String maskToVerboseString(CapabilitySet cs) {
        String answer = "\n";
        boolean reqCaps = cs._type == 1;
        String[] labels = reqCaps ? REQUEST_LABELS : RESPONSE_LABELS;
        String bitSymbols = "";
        int byteValue = 0;
        int j = cs._bits - 1;
        while (j >= 0) {
            if (j < labels.length) {
                if (bitSymbols.length() > 0) {
                    bitSymbols = String.valueOf(bitSymbols) + ", ";
                }
                if (!cs.get(j)) {
                    bitSymbols = String.valueOf(bitSymbols) + "(";
                }
                bitSymbols = String.valueOf(bitSymbols) + labels[j];
                if (!cs.get(j)) {
                    bitSymbols = String.valueOf(bitSymbols) + ")";
                }
            }
            if (cs.get(j)) {
                byteValue |= 1 << j % 8;
            }
            if (j % 8 == 0) {
                answer = String.valueOf(answer) + "0x" + HexConverts.hexConvert(byteValue, 1) + " (" + HexConverts.binaryConvert(byteValue, 1) + "): " + bitSymbols + " \n";
                bitSymbols = "";
                byteValue = 0;
            }
            --j;
        }
        return answer;
    }

    protected void printMask() {
        int i = 0;
        while (i < this._allCapSets.size()) {
            CapabilitySet cs = (CapabilitySet)this._allCapSets.elementAt(i);
            Debug.println(this.maskToVerboseString(cs));
            ++i;
        }
        Debug.println(" ");
    }

    public void send(TdsOutputStream out) throws IOException {
        try {
            out.writeByte(226);
            out.writeShort(this._totalLen);
            int i = 0;
            while (i < this._allCapSets.size()) {
                CapabilitySet cs = (CapabilitySet)this._allCapSets.elementAt(i);
                out.writeByte(cs._type);
                out.writeByte(cs._maskLen);
                int byteValue = 0;
                int j = cs._bits - 1;
                while (j >= 0) {
                    if (cs.get(j)) {
                        byteValue |= 1 << j % 8;
                    }
                    if (j % 8 == 0) {
                        out.writeByte(byteValue);
                        byteValue = 0;
                    }
                    --j;
                }
                ++i;
            }
        }
        catch (IOException ioe) {
            Token.writeSQE(ioe);
        }
    }

    protected void setCapabilities(SybProperty info) throws SQLException {
        ++this._capsTry;
        switch (this._capsTry) {
            case 1: {
                int numResCapabilityBits;
                int numReqCapabilityBits;
                int jConnVers = info.getInteger(22);
                if (jConnVers >= 6) {
                    numReqCapabilityBits = 70;
                    numResCapabilityBits = 50;
                } else if (jConnVers >= 4) {
                    numReqCapabilityBits = 57;
                    numResCapabilityBits = 39;
                    Debug.println(this, "shrinking capability list to medium level");
                    int maskLen = (numReqCapabilityBits + 7) / 8;
                    this._reqCaps.setMaskSize(maskLen);
                    this._respCaps.setMaskSize(maskLen);
                    this._totalLen = 2 * maskLen + 4;
                } else {
                    numReqCapabilityBits = 57;
                    numResCapabilityBits = 39;
                }
                int i = 1;
                while (i <= numReqCapabilityBits) {
                    this._reqCaps.set(i);
                    ++i;
                }
                this._reqCaps.clear(0);
                this._reqCaps.clear(3);
                this._reqCaps.clear(5);
                this._reqCaps.clear(33);
                this._reqCaps.clear(34);
                this._reqCaps.clear(35);
                this._reqCaps.clear(36);
                this._reqCaps.clear(37);
                this._reqCaps.clear(39);
                this._reqCaps.clear(41);
                this._reqCaps.clear(43);
                this._reqCaps.clear(44);
                this._reqCaps.clear(52);
                if (numReqCapabilityBits == 70) {
                    Debug.println(this, "jConnect version of " + jConnVers + " means we're using the long " + "capability request mask, and we're turning on " + "widetable and unichar support.");
                    this._reqCaps.clear(58);
                    this._reqCaps.clear(60);
                    this._reqCaps.clear(61);
                    this._reqCaps.clear(62);
                    this._reqCaps.clear(63);
                    this._reqCaps.clear(64);
                    this._reqCaps.clear(65);
                }
                this._reqCaps.clear(47);
                i = 0;
                while (i <= numResCapabilityBits) {
                    this._respCaps.clear(i);
                    ++i;
                }
                this._respCaps.set(27);
                this._respCaps.set(30);
                this._respCaps.set(33);
                this._respCaps.set(34);
                this._respCaps.set(3);
                Debug.println(this, this.toString());
                if (numResCapabilityBits != 50) break;
                Debug.println(this, "Using the long capability mask to set the capability response bits");
                this._respCaps.set(40);
                this._respCaps.set(41);
                this._respCaps.set(42);
                this._respCaps.set(43);
                this._respCaps.set(44);
                break;
            }
            case 2: {
                Debug.println(this, "shrinking capability list");
                int maskLen = 7;
                this._reqCaps.setMaskSize(maskLen);
                this._respCaps.setMaskSize(maskLen);
                this._totalLen = 2 * maskLen + 4;
                break;
            }
            default: {
                Debug.assert(this, false);
            }
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("Request capabilities:\n");
        int i = 1;
        while (i < REQUEST_LABELS.length) {
            s.append(String.valueOf(REQUEST_LABELS[i]) + ": " + this._reqCaps.get(i) + "\n");
            ++i;
        }
        s.append("\nResponse capabilities:\n");
        int i2 = 1;
        while (i2 < RESPONSE_LABELS.length) {
            s.append(String.valueOf(RESPONSE_LABELS[i2]) + ": " + this._respCaps.get(i2) + "\n");
            ++i2;
        }
        return s.toString();
    }
}

