/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.DateObject;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbc2.utils.HexConverts;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class Convert {
    private static final long LOW_BYTE = 255L;

    private Convert() {
    }

    public static double bufToDouble(byte[] buf) throws SQLException {
        double retVal = 0.0;
        switch (buf.length) {
            case 4: {
                retVal = (0xFFL & (long)buf[0]) << 24 | (0xFFL & (long)buf[1]) << 16 | (0xFFL & (long)buf[2]) << 8 | 0xFFL & (long)buf[3];
                break;
            }
            case 8: {
                retVal = (0xFFL & (long)buf[0]) << 56 | (0xFFL & (long)buf[1]) << 48 | (0xFFL & (long)buf[2]) << 40 | (0xFFL & (long)buf[3]) << 32 | (0xFFL & (long)buf[4]) << 24 | (0xFFL & (long)buf[5]) << 16 | (0xFFL & (long)buf[6]) << 8 | 0xFFL & (long)buf[7];
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0TC");
            }
        }
        return retVal;
    }

    public static long bufToLong(byte[] buf) throws SQLException {
        long retVal = 0L;
        switch (buf.length) {
            case 1: {
                retVal = 0xFFL & (long)buf[0];
                break;
            }
            case 2: {
                retVal = (0xFFL & (long)buf[0]) << 8 | 0xFFL & (long)buf[1];
                break;
            }
            case 4: {
                retVal = (0xFFL & (long)buf[0]) << 24 | (0xFFL & (long)buf[1]) << 16 | (0xFFL & (long)buf[2]) << 8 | 0xFFL & (long)buf[3];
                break;
            }
            case 8: {
                retVal = (0xFFL & (long)buf[0]) << 56 | (0xFFL & (long)buf[1]) << 48 | (0xFFL & (long)buf[2]) << 40 | (0xFFL & (long)buf[3]) << 32 | (0xFFL & (long)buf[4]) << 24 | (0xFFL & (long)buf[5]) << 16 | (0xFFL & (long)buf[6]) << 8 | 0xFFL & (long)buf[7];
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0TC");
            }
        }
        return retVal;
    }

    public static void checkByteOflo(long value) throws SQLException {
        if (value < -128L || value > 127L) {
            ErrorMessage.raiseError("JZ00B");
        }
    }

    public static void checkIntOflo(long value) throws SQLException {
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            ErrorMessage.raiseError("JZ00B");
        }
    }

    public static void checkLongOflo(double value) throws SQLException {
        if (value < -9.223372036854776E18 || value > 9.223372036854776E18) {
            ErrorMessage.raiseError("JZ00B");
        }
    }

    public static void checkShortOflo(long value) throws SQLException {
        if (value < -32768L || value > 32767L) {
            ErrorMessage.raiseError("JZ00B");
        }
    }

    public static byte hexToDecimal(char c) throws SQLException {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        ErrorMessage.raiseError("JZ0HC", String.valueOf(c));
        return 0;
    }

    public static String numString(Object in) throws SQLException {
        String s = Convert.objectToString(in);
        int len = s.length();
        int start = 0;
        block6: while (start < len) {
            switch (s.charAt(start)) {
                case '\t': 
                case '\n': 
                case ' ': 
                case '+': {
                    ++start;
                    continue block6;
                }
            }
        }
        --len;
        block7: while (len > start) {
            switch (s.charAt(len)) {
                case '\t': 
                case '\n': 
                case ' ': {
                    --len;
                    continue block7;
                }
            }
        }
        Debug.println(null, "numString(" + s + ") --> " + s.substring(start, len + 1));
        return s.substring(start, len + 1);
    }

    public static BigDecimal objectToBigDecimal(Object in) throws SQLException {
        if (in == null) {
            return null;
        }
        if (in instanceof BigDecimal) {
            return (BigDecimal)in;
        }
        if (in instanceof String || in instanceof Long) {
            try {
                return new BigDecimal(Convert.numString(in));
            }
            catch (NumberFormatException e) {
                ErrorMessage.raiseError("JZ009", e.toString());
            }
        }
        return new BigDecimal(Convert.objectToDoubleValue(in));
    }

    public static Boolean objectToBoolean(Object in) throws SQLException {
        if (in != null) {
            Debug.println(null, "input to objectToBoolean is " + in.toString());
        }
        if (in == null) {
            return null;
        }
        if (in instanceof String) {
            return new Boolean((String)in);
        }
        double d = Convert.objectToDoubleValue(in);
        return new Boolean(d != 0.0);
    }

    public static byte[] objectToBytes(Object in) throws SQLException {
        String s;
        int len;
        Debug.println(null, "input to objectToBytes is '" + in + "'");
        if (in == null) {
            return null;
        }
        if (in instanceof byte[]) {
            return (byte[])in;
        }
        if (in instanceof String && ((len = (s = (String)in).length()) & 1) == 0) {
            byte[] newBytes = new byte[s.length() / 2 - 1];
            int i = 2;
            int j = 0;
            while (i < s.length()) {
                newBytes[j] = (byte)(16 * Convert.hexToDecimal(s.charAt(i)) + Convert.hexToDecimal(s.charAt(i + 1)));
                i += 2;
                ++j;
            }
            return newBytes;
        }
        ErrorMessage.raiseError("JZ0TE", "Double, Float, BigDecimal, Integer, Long");
        return null;
    }

    public static Calendar objectToCalendar(Object in, Calendar cal) throws SQLException {
        if (in == null) {
            return null;
        }
        if (in instanceof Calendar) {
            return (Calendar)in;
        }
        Calendar retCal = cal;
        if (retCal == null) {
            retCal = Calendar.getInstance();
        }
        cal.clear();
        if (in instanceof Date) {
            cal.setTime((java.util.Date)in);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        } else if (in instanceof Time) {
            cal.setTime((java.util.Date)in);
            cal.set(6, 1);
            cal.set(1, 1970);
        } else if (in instanceof Timestamp) {
            cal.setTime((java.util.Date)in);
            cal.set(14, ((Timestamp)in).getNanos() / 1000000);
        } else {
            ErrorMessage.raiseError("JZ0TC");
        }
        return cal;
    }

    public static Date objectToDate(Object in) throws SQLException {
        if (in == null) {
            return null;
        }
        if (in instanceof Date) {
            return (Date)in;
        }
        if (in instanceof String) {
            String stringValue = Convert.numString(in);
            int space = stringValue.indexOf(" ");
            if (space > 0) {
                stringValue = stringValue.substring(0, space);
            }
            try {
                return Date.valueOf(stringValue);
            }
            catch (IllegalArgumentException iae) {
                ErrorMessage.raiseError("JZ009", iae.toString());
            }
        }
        if (in instanceof DateObject) {
            Calendar cal = (Calendar)((DateObject)in).getCalendar().clone();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            return new Date(cal.getTime().getTime());
        }
        ErrorMessage.raiseError("JZ0TC");
        return null;
    }

    public static DateObject objectToDateObject(Object in, int targetType, Calendar cal) throws SQLException {
        Object conObj = in;
        if (conObj == null) {
            return null;
        }
        if (in instanceof DateObject) {
            return (DateObject)in;
        }
        if (conObj instanceof String) {
            switch (targetType) {
                case 91: {
                    conObj = Convert.objectToDate(conObj);
                    break;
                }
                case 92: {
                    conObj = Convert.objectToTime(conObj);
                    break;
                }
                case 93: {
                    conObj = Convert.objectToTimestamp(conObj);
                    break;
                }
                default: {
                    ErrorMessage.raiseError("JZ0TC");
                    break;
                }
            }
        } else if (!(conObj instanceof Date || conObj instanceof Time || conObj instanceof Timestamp || conObj instanceof Calendar)) {
            ErrorMessage.raiseError("JZ0TC");
        }
        return new DateObject(conObj, cal);
    }

    public static DateObject objectToDateObject(Object in, Calendar cal) throws SQLException {
        return Convert.objectToDateObject(in, 93, cal);
    }

    public static Double objectToDouble(Object in) throws SQLException {
        if (in == null) {
            return null;
        }
        if (in instanceof Double) {
            return (Double)in;
        }
        return new Double(Convert.objectToDoubleValue(in));
    }

    public static double objectToDoubleValue(Object in) throws SQLException {
        if (in instanceof Double) {
            return (Double)in;
        }
        if (in instanceof Float) {
            return ((Float)in).doubleValue();
        }
        if (in instanceof BigDecimal) {
            return ((BigDecimal)in).doubleValue();
        }
        if (in instanceof Boolean) {
            return (Boolean)in != false ? 1 : 0;
        }
        if (in instanceof Integer) {
            return ((Integer)in).doubleValue();
        }
        if (in instanceof Long) {
            return ((Long)in).doubleValue();
        }
        if (in instanceof byte[]) {
            return Convert.bufToDouble((byte[])in);
        }
        if (in instanceof String) {
            try {
                return new Double(Convert.numString(in));
            }
            catch (NumberFormatException e) {
                ErrorMessage.raiseError("JZ009", e.toString());
            }
        }
        ErrorMessage.raiseError("JZ0TE", "Double, Float, BigDecimal, Boolean, Integer, Long, byte[], String");
        return 0.0;
    }

    public static Float objectToFloat(Object in) throws SQLException {
        if (in == null) {
            return null;
        }
        if (in instanceof Float) {
            return (Float)in;
        }
        return new Float(Convert.objectToDoubleValue(in));
    }

    public static Integer objectToInt(Object in) throws SQLException {
        boolean intValue = false;
        if (in == null) {
            return null;
        }
        if (in instanceof Integer) {
            return (Integer)in;
        }
        long l = Convert.objectToLongValue(in);
        Convert.checkIntOflo(l);
        return new Integer((int)l);
    }

    public static long objectToLongValue(Object in) throws SQLException {
        if (in instanceof Integer) {
            return ((Integer)in).longValue();
        }
        if (in instanceof Long) {
            return (Long)in;
        }
        if (in instanceof Double) {
            return ((Double)in).longValue();
        }
        if (in instanceof Float) {
            return ((Float)in).longValue();
        }
        if (in instanceof BigDecimal) {
            return ((BigDecimal)in).longValue();
        }
        if (in instanceof Boolean) {
            return (Boolean)in != false ? 1 : 0;
        }
        if (in instanceof byte[]) {
            return Convert.bufToLong((byte[])in);
        }
        if (in instanceof String) {
            try {
                return new Long(Convert.numString(in));
            }
            catch (NumberFormatException e) {
                ErrorMessage.raiseError("JZ009", e.toString());
            }
        }
        ErrorMessage.raiseError("JZ0TE", "Double, Float, BigDecimal, Boolean, Integer, Long, byte[], String");
        return 0L;
    }

    public static final Reader objectToReader(Object in) throws SQLException {
        if (in == null) {
            return null;
        }
        if (in instanceof String) {
            return new StringReader((String)in);
        }
        if (in instanceof byte[]) {
            return new InputStreamReader(new ByteArrayInputStream((byte[])in));
        }
        if (in instanceof InputStream) {
            return new InputStreamReader((InputStream)in);
        }
        if (in instanceof Reader) {
            ErrorMessage.raiseError("JZ0IS");
        }
        ErrorMessage.raiseError("JZ0TC");
        return null;
    }

    public static final InputStream objectToStream(Object in) throws SQLException {
        if (in == null) {
            return null;
        }
        if (in instanceof String) {
            return new StringBufferInputStream((String)in);
        }
        if (in instanceof byte[]) {
            return new ByteArrayInputStream((byte[])in);
        }
        if (in instanceof InputStream) {
            ErrorMessage.raiseError("JZ0IS");
        }
        ErrorMessage.raiseError("JZ0TE", "String, byte[]");
        return null;
    }

    public static final String objectToString(Object in) throws SQLException {
        if (in == null) {
            return null;
        }
        if (in instanceof String) {
            return (String)in;
        }
        if (in instanceof byte[]) {
            return HexConverts.hexConvert((byte[])in);
        }
        return in.toString();
    }

    public static Time objectToTime(Object in) throws SQLException {
        if (in == null) {
            return null;
        }
        if (in instanceof Time) {
            return (Time)in;
        }
        if (in instanceof String) {
            String stringValue = Convert.numString(in);
            int space = stringValue.indexOf(" ");
            if (space > 0) {
                stringValue = stringValue.substring(space + 1, space + 9);
            }
            try {
                return Time.valueOf(stringValue);
            }
            catch (IllegalArgumentException iae) {
                ErrorMessage.raiseError("JZ009", iae.toString());
            }
        }
        if (in instanceof DateObject) {
            Calendar cal = (Calendar)((DateObject)in).getCalendar().clone();
            cal.set(6, 1);
            cal.set(1, 1970);
            return new Time(cal.getTime().getTime());
        }
        ErrorMessage.raiseError("JZ0TE", "java.sql.Time, java.sql.Timestamp, String");
        return null;
    }

    public static Timestamp objectToTimestamp(Object in) throws SQLException {
        if (in == null) {
            return null;
        }
        if (in instanceof Timestamp) {
            return (Timestamp)in;
        }
        if (in instanceof String) {
            try {
                return Timestamp.valueOf(Convert.numString(in));
            }
            catch (IllegalArgumentException iae) {
                ErrorMessage.raiseError("JZ009", iae.toString());
            }
        }
        if (in instanceof DateObject) {
            return ((DateObject)in).toSybTimestamp();
        }
        ErrorMessage.raiseError("JZ0TC");
        return null;
    }

    public static BigDecimal setScale(BigDecimal bd, int scale) throws SQLException {
        block2: {
            if (bd == null || scale < 0) break block2;
            try {
                bd = bd.setScale(scale, 4);
                Debug.println(null, "After scaling, scale = " + bd.scale() + " (" + bd.toString() + ")");
            }
            catch (ArithmeticException ae) {
                ErrorMessage.raiseError("JZ009", ae.getMessage());
            }
        }
        return bd;
    }
}

