/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.dom.Property;
import com.steadystate.css.parser.CSSOMParser;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Vector;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSStyleDeclarationImpl
implements CSSStyleDeclaration,
Serializable {
    private CSSRule _parentRule;
    private Vector _properties = new Vector();

    public CSSStyleDeclarationImpl(CSSRule parentRule) {
        this._parentRule = parentRule;
    }

    public String getCssText() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        int i = 0;
        while (i < this._properties.size()) {
            Property p = (Property)this._properties.elementAt(i);
            if (p != null) {
                sb.append(p.toString());
            }
            if (i < this._properties.size() - 1) {
                sb.append("; ");
            }
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }

    public void setCssText(String cssText) throws DOMException {
        try {
            InputSource is = new InputSource(new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            this._properties.removeAllElements();
            parser.parseStyleDeclaration(this, is);
        }
        catch (Exception e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public String getPropertyValue(String propertyName) {
        Property p = this.getPropertyDeclaration(propertyName);
        return p != null ? p.getValue().toString() : "";
    }

    public CSSValue getPropertyCSSValue(String propertyName) {
        Property p = this.getPropertyDeclaration(propertyName);
        return p != null ? p.getValue() : null;
    }

    public String removeProperty(String propertyName) throws DOMException {
        int i = 0;
        while (i < this._properties.size()) {
            Property p = (Property)this._properties.elementAt(i);
            if (p.getName().equalsIgnoreCase(propertyName)) {
                this._properties.removeElementAt(i);
                return p.getValue().toString();
            }
            ++i;
        }
        return "";
    }

    public String getPropertyPriority(String propertyName) {
        Property p = this.getPropertyDeclaration(propertyName);
        if (p != null) {
            return p.isImportant() ? "important" : "";
        }
        return "";
    }

    public void setProperty(String propertyName, String value, String priority) throws DOMException {
        try {
            boolean important;
            InputSource is = new InputSource(new StringReader(value));
            CSSOMParser parser = new CSSOMParser();
            CSSValue expr = parser.parsePropertyValue(is);
            Property p = this.getPropertyDeclaration(propertyName);
            boolean bl = important = priority != null ? priority.equalsIgnoreCase("important") : false;
            if (p == null) {
                p = new Property(propertyName, expr, important);
                this.addProperty(p);
            } else {
                p.setValue(expr);
                p.setImportant(important);
            }
        }
        catch (Exception e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public int getLength() {
        return this._properties.size();
    }

    public String item(int index) {
        Property p = (Property)this._properties.elementAt(index);
        return p != null ? p.getName() : "";
    }

    public CSSRule getParentRule() {
        return this._parentRule;
    }

    public void addProperty(Property p) {
        this._properties.addElement(p);
    }

    private Property getPropertyDeclaration(String name) {
        int i = 0;
        while (i < this._properties.size()) {
            Property p = (Property)this._properties.elementAt(i);
            if (p.getName().equalsIgnoreCase(name)) {
                return p;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        return this.getCssText();
    }
}

