/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.objectweb.asm.tree;

import com.eg.org.objectweb.asm.AnnotationVisitor;
import com.eg.org.objectweb.asm.tree.Util;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationNode
extends AnnotationVisitor {
    public String desc;
    public List<Object> values;

    public AnnotationNode(String string) {
        this(589824, string);
        if (this.getClass() != AnnotationNode.class) {
            throw new IllegalStateException();
        }
    }

    public AnnotationNode(int n2, String string) {
        super(n2);
        this.desc = string;
    }

    AnnotationNode(List<Object> list) {
        super(589824);
        this.values = list;
    }

    @Override
    public void visit(String string, Object object) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(string);
        }
        if (object instanceof byte[]) {
            this.values.add(Util.asArrayList((byte[])object));
        } else if (object instanceof boolean[]) {
            this.values.add(Util.asArrayList((boolean[])object));
        } else if (object instanceof short[]) {
            this.values.add(Util.asArrayList((short[])object));
        } else if (object instanceof char[]) {
            this.values.add(Util.asArrayList((char[])object));
        } else if (object instanceof int[]) {
            this.values.add(Util.asArrayList((int[])object));
        } else if (object instanceof long[]) {
            this.values.add(Util.asArrayList((long[])object));
        } else if (object instanceof float[]) {
            this.values.add(Util.asArrayList((float[])object));
        } else if (object instanceof double[]) {
            this.values.add(Util.asArrayList((double[])object));
        } else {
            this.values.add(object);
        }
    }

    @Override
    public void visitEnum(String string, String string2, String string3) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(string);
        }
        this.values.add(new String[]{string2, string3});
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, String string2) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(string);
        }
        AnnotationNode annotationNode = new AnnotationNode(string2);
        this.values.add(annotationNode);
        return annotationNode;
    }

    @Override
    public AnnotationVisitor visitArray(String string) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(string);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.values.add(arrayList);
        return new AnnotationNode(arrayList);
    }

    @Override
    public void visitEnd() {
    }

    public void check(int n2) {
    }

    public void accept(AnnotationVisitor annotationVisitor) {
        if (annotationVisitor != null) {
            if (this.values != null) {
                int n2 = this.values.size();
                for (int i2 = 0; i2 < n2; i2 += 2) {
                    String string = (String)this.values.get(i2);
                    Object object = this.values.get(i2 + 1);
                    AnnotationNode.accept(annotationVisitor, string, object);
                }
            }
            annotationVisitor.visitEnd();
        }
    }

    static void accept(AnnotationVisitor annotationVisitor, String string, Object object) {
        if (annotationVisitor != null) {
            if (object instanceof String[]) {
                String[] stringArray = (String[])object;
                annotationVisitor.visitEnum(string, stringArray[0], stringArray[1]);
            } else if (object instanceof AnnotationNode) {
                AnnotationNode annotationNode = (AnnotationNode)object;
                annotationNode.accept(annotationVisitor.visitAnnotation(string, annotationNode.desc));
            } else if (object instanceof List) {
                AnnotationVisitor annotationVisitor2 = annotationVisitor.visitArray(string);
                if (annotationVisitor2 != null) {
                    List list = (List)object;
                    int n2 = list.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        AnnotationNode.accept(annotationVisitor2, null, list.get(i2));
                    }
                    annotationVisitor2.visitEnd();
                }
            } else {
                annotationVisitor.visit(string, object);
            }
        }
    }
}

