/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.joran.spi;

import com.eg.ch.qos.logback.core.joran.event.BodyEvent;
import com.eg.ch.qos.logback.core.joran.event.EndEvent;
import com.eg.ch.qos.logback.core.joran.event.SaxEvent;
import com.eg.ch.qos.logback.core.joran.event.StartEvent;
import com.eg.ch.qos.logback.core.joran.spi.Interpreter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventPlayer {
    final Interpreter interpreter;
    List<SaxEvent> eventList;
    int currentIndex;

    public EventPlayer(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    public List<SaxEvent> getCopyOfPlayerEventList() {
        return new ArrayList<SaxEvent>(this.eventList);
    }

    public void play(List<SaxEvent> list) {
        this.eventList = list;
        this.currentIndex = 0;
        while (this.currentIndex < this.eventList.size()) {
            SaxEvent saxEvent = this.eventList.get(this.currentIndex);
            if (saxEvent instanceof StartEvent) {
                this.interpreter.startElement((StartEvent)saxEvent);
                this.interpreter.getInterpretationContext().fireInPlay(saxEvent);
            }
            if (saxEvent instanceof BodyEvent) {
                this.interpreter.getInterpretationContext().fireInPlay(saxEvent);
                this.interpreter.characters((BodyEvent)saxEvent);
            }
            if (saxEvent instanceof EndEvent) {
                this.interpreter.getInterpretationContext().fireInPlay(saxEvent);
                this.interpreter.endElement((EndEvent)saxEvent);
            }
            ++this.currentIndex;
        }
    }

    public void addEventsDynamically(List<SaxEvent> list, int n2) {
        this.eventList.addAll(this.currentIndex + n2, list);
    }
}

