var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import React, { Component } from "react";
import { Dimensions, View, Image } from "react-native";
var Styles = {
    container: {
        position: "absolute",
        left: 0,
        top: 0,
        right: 0,
        bottom: 0,
        zIndex: 1000,
        opacity: 0.25,
    },
};
/** An overlay for showing an image to help with layout.
 *
 * @class FullScreenOverlay
 * @extends {Component}
 */
var FullScreenOverlay = /** @class */ (function (_super) {
    __extends(FullScreenOverlay, _super);
    function FullScreenOverlay(props) {
        var _this = _super.call(this, props) || this;
        _this.state = {
            opacity: Styles.container.opacity,
            uri: null,
            justifyContent: "center",
            alignItems: "center",
        };
        // when the server sends stuff
        props.emitter.on("overlay", function (payload) {
            _this.setState(__assign(__assign({}, _this.state), payload));
        });
        return _this;
    }
    FullScreenOverlay.prototype.createContainerStyle = function () {
        var _a = this.state, opacity = _a.opacity, justifyContent = _a.justifyContent, alignItems = _a.alignItems;
        var _b = Dimensions.get("window"), width = _b.width, height = _b.height;
        var containerStyle = __assign(__assign({}, Styles.container), { opacity: opacity,
            width: width,
            height: height,
            justifyContent: justifyContent,
            alignItems: alignItems });
        return containerStyle;
    };
    /**
     * Draw.
     */
    FullScreenOverlay.prototype.render = function () {
        var _a = this.state, uri = _a.uri, width = _a.width, height = _a.height, growToWindow = _a.growToWindow, resizeMode = _a.resizeMode, _b = _a.marginLeft, marginLeft = _b === void 0 ? 0 : _b, _c = _a.marginRight, marginRight = _c === void 0 ? 0 : _c, _d = _a.marginTop, marginTop = _d === void 0 ? 0 : _d, _e = _a.marginBottom, marginBottom = _e === void 0 ? 0 : _e;
        var imageStyle = { width: width, height: height, marginTop: marginTop, marginRight: marginRight, marginBottom: marginBottom, marginLeft: marginLeft };
        if (growToWindow) {
            var windowSize = Dimensions.get("window");
            imageStyle.width = windowSize.width;
            imageStyle.height = windowSize.height;
        }
        var image = uri ? (<Image source={{ uri: uri }} style={imageStyle} resizeMode={growToWindow ? resizeMode : null}/>) : (<View />);
        return (<View style={this.createContainerStyle()} pointerEvents="none">
        {image}
      </View>);
    };
    return FullScreenOverlay;
}(Component));
export default FullScreenOverlay;
