/**
 * Runs small high-unscientific benchmarks for you.
 */
export default (function () { return function (eg) {
    var startTimer = eg.startTimer;
    var benchmark = function (title) {
        var steps = [];
        var elapsed = startTimer();
        var step = function (stepTitle) {
            var previousTime = steps.length === 0 ? 0 : steps[steps.length - 1].time;
            var nextTime = elapsed();
            steps.push({ title: stepTitle, time: nextTime, delta: nextTime - previousTime });
        };
        steps.push({ title: title, time: 0, delta: 0 });
        var stop = function (stopTitle) {
            step(stopTitle);
            // eg.send("benchmark.report", { title, steps })
        };
        return { step: step, stop: stop, last: stop };
    };
    return {
        features: { benchmark: benchmark },
    };
}; });
