import { NativeModules } from "react-native";
export function getReactNativeVersionWithModules(nativeModules) {
    try {
        // dodge some bullets
        if (!nativeModules.PlatformConstants)
            return null;
        if (!nativeModules.PlatformConstants.reactNativeVersion)
            return null;
        // grab the raw numbers
        var major = nativeModules.PlatformConstants.reactNativeVersion.major;
        var minor = nativeModules.PlatformConstants.reactNativeVersion.minor;
        var patch = nativeModules.PlatformConstants.reactNativeVersion.patch;
        var prerelease = nativeModules.PlatformConstants.reactNativeVersion.prerelease;
        // check the major or jet
        if (typeof major !== "number")
            return null;
        // assemble!
        var vParts = [];
        vParts.push(major + "." + minor + "." + patch);
        if (prerelease)
            vParts.push("-" + prerelease);
        return vParts.join("");
    }
    catch (_a) { }
    return null;
}
export default function getReactNativeVersion() {
    return getReactNativeVersionWithModules(NativeModules);
}
