var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { Dimensions } from "react-native";
export function getReactNativeDimensionsWithDimensions(screen, win) {
    try {
        var screenInfo = {};
        var windowInfo = {};
        if (screen) {
            screenInfo = {
                screenWidth: Math.ceil(screen.width),
                screenHeight: Math.ceil(screen.height),
                screenScale: screen.scale,
                screenFontScale: screen.fontScale,
            };
        }
        if (win) {
            windowInfo = {
                windowWidth: Math.ceil(win.width),
                windowHeight: Math.ceil(win.height),
                windowScale: win.scale,
                windowFontScale: win.fontScale,
            };
        }
        return __assign(__assign({}, screenInfo), windowInfo);
    }
    catch (e) { }
    return null;
}
export default function getReactNativeDimensions() {
    var screen = null;
    var win = null;
    try {
        screen = Dimensions.get("screen");
    }
    catch (_a) { }
    try {
        win = Dimensions.get("window");
    }
    catch (_b) { }
    return getReactNativeDimensionsWithDimensions(screen, win);
}
