<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:d="http://www.lotus.com/dxl">
	<xsl:variable name="uid">
		<xsl:value-of select="/d:document/d:noteinfo/@unid"/>
	</xsl:variable>

	<xsl:variable name="pname">
		<xsl:value-of select="/d:document/d:item[@name='DocTitle']"/>
	</xsl:variable>

	<xsl:variable name="skipplain" select="contains(/d:document/d:item[@name='$FILE']/d:object/d:file[@hosttype='stream']/@name, 'mime.htm')"/>

	<xsl:template match="/">
		<xsl:apply-templates select="/d:document"/>
	</xsl:template>
	<xsl:template match="d:document">
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<style type="text/css">
		
			BODY, TD {
			    font-family: Arial;
				color: black;
				font-size: 9pt;
				font-weight: normal;
				text-decoration: none; }

			UL > UL { list-style-type: circle }
			UL > UL > UL { list-style-type: square }

			TABLE.tablestyle1 TD, TABLE.tablestyle1 TD { border: 1 solid black; }
			TABLE.tablestyle1 { border-collapse: collapse; border-spacing: 0px 0px; empty-cells: show }
			
			<xsl:for-each select="/d:document/d:item/d:richtext/d:pardef">
				.par_<xsl:value-of select="$uid"/>_<xsl:value-of select="@id"/> {
				<xsl:if test="@align">
				text-align: <xsl:choose>
						<xsl:when test="contains(@align,'full')">justify; width: 100%;</xsl:when>
						<xsl:otherwise><xsl:value-of select="@align"/>;</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
				<xsl:if test="@leftmargin">
				margin-left: <xsl:value-of select="@leftmargin"/>;
				</xsl:if>
				<!-- xsl:if test="contains(@newpage,'true')">page-break-before: always; </xsl:if -->
				}
			</xsl:for-each>
			<xsl:for-each select="/d:document/d:item/d:richtext/d:pardef[@newpage='true']">
				<xsl:if test="position() &gt; 1">
				.par_<xsl:value-of select="$uid"/>_<xsl:value-of select="@id"/> { page-break-before: always; }
				</xsl:if>
			</xsl:for-each>
		</style>
	</head>
<body>
<pd4ml-page-footer>
<table width="100%">
		<tr>
		<td>Page $[page] of $[total]</td>
		</tr>
</table>
</pd4ml-page-footer>

<xsl:if test="/d:document/d:item/@name='From' or /d:document/d:item/@name='SendTo' or /d:document/d:item/@name='Subject' or /d:document/d:item/@name='CopyTo' or /d:document/d:item/@name='PostedDate'">

	<div>
	<table width="100%" style="border-bottom: 1 solid gray; margin-bottom: 8px;">
	
	<!-- 7 TYPE_NOTELINK_LIST (1)
	c TYPE_HIGHLIGHTS
	16 TYPE_SCHED_LIST (2)
	100 TYPE_ERROR
	300 TYPE_NUMBER (1)
	301 TYPE_NUMBER_RANGE (1)
	400 TYPE_TIME (1)
	401 TYPE_TIME_RANGE (1)
	501 TYPE_TEXT_LIST (1)
	502 TYPE_RFC822_TEXT
	700 TYPE_USERID (3) -->
	
			<xsl:for-each select="/d:document/d:item/d:rawitemdata[@type='502']">
			<xsl:if test="../@name='From' or ../@name='SendTo' or ../@name='Subject' or ../@name='CopyTo' ">
			<tr>
			<td valign="top"><xsl:value-of select="../@name"/>:</td><td><span style="text-transform: base64"><xsl:copy-of select="text()"/></span></td>
			</tr>
			</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="/d:document/d:item/d:text">
			<xsl:if test="text() and (../@name='From' or ../@name='SendTo' or ../@name='Subject' or ../@name='CopyTo' )">
			<tr>
			<td valign="top"><xsl:value-of select="../@name"/>:</td><td><xsl:copy-of select="text()"/></td>
			</tr>
			</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="/d:document/d:item/d:textlist/d:text">
			<xsl:if test="text() and (../../@name='From' or ../../@name='SendTo' or ../../@name='Subject' or ../../@name='CopyTo')">
			<tr>
			<td valign="top"><xsl:value-of select="../../@name"/>:</td><td><xsl:copy-of select="text()"/></td>
			</tr>
			</xsl:if>
			</xsl:for-each>
	
			<xsl:for-each select="/d:document/d:item[@name='PostedDate']">
			<tr>
			<td valign="top"><xsl:value-of select="@name"/>:</td>
				<xsl:if test="d:datetimelist/d:datetime">
				<td><xsl:call-template name="format-date-time">
	    			<xsl:with-param name="date" select="d:datetimelist/d:datetime"/>
				</xsl:call-template></td>

				<xsl:if test="d:datetime">
				<td><xsl:call-template name="format-date-time">
	    			<xsl:with-param name="date" select="d:datetime"/>
				</xsl:call-template></td>
				</xsl:if>

				</xsl:if>
				<xsl:if test="d:rawitemdata">
				<td><span style="text-transform: base64; date-format: MM/dd/yyyy"><xsl:copy-of select="."/></span></td><!-- date-format corresponds SimpleDateFormat of Java -->
				</xsl:if>
			</tr>
			</xsl:for-each>
	
	</table>
	</div>

</xsl:if>


<div style="width: 100%; text-align: right">
		<xsl:for-each select="/d:document/d:item/d:object/d:file">
			<xsl:variable name="attkey"><xsl:value-of select="@name"/></xsl:variable>
			<xsl:if test="not(contains($attkey, 'mime.txt')) and not(contains($attkey, 'mime.htm')) and not(contains($attkey, '$MIME_PART_')) and not(//d:attachmentref[@name=$attkey])">
				<pd4ml-attachment icon="Area">
					<xsl:attribute name="skipplain"><xsl:value-of select="$skipplain"/></xsl:attribute>
					<xsl:attribute name="compression"><xsl:value-of select="@compression"/></xsl:attribute>

					<xsl:choose>
					<xsl:when test="@displayname">
						<xsl:attribute name="description"><xsl:value-of select="@displayname"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="description"><xsl:value-of select="@name"/></xsl:attribute>
					</xsl:otherwise>
					</xsl:choose>

					<xsl:attribute name="height"><xsl:value-of select="d:picture/@height"/></xsl:attribute>
					<xsl:attribute name="width"><xsl:value-of select="d:picture/@width"/></xsl:attribute>

					<xsl:if test="not(d:picture)">
						<xsl:attribute name="icon">paperclip</xsl:attribute>
					</xsl:if>

					<xsl:call-template name="getbody">
						<xsl:with-param name="p1" select="$attkey"/>
					</xsl:call-template>

				</pd4ml-attachment>

				<xsl:if test="not(d:picture)">
					<xsl:value-of select="@name"/>
				</xsl:if>

				<xsl:if test="d:picture">
					<img border="5">
						<xsl:attribute name="height"><xsl:value-of select="d:picture/@height"/></xsl:attribute>
						<xsl:attribute name="width"><xsl:value-of select="d:picture/@width"/></xsl:attribute>
						<xsl:attribute name="src">data:image/gif;base64,<xsl:value-of
						select="normalize-space(d:picture/d:gif)" disable-output-escaping="yes"/><xsl:value-of
						select="normalize-space(d:picture/d:notesbitmap)" disable-output-escaping="yes"/></xsl:attribute>
						<xsl:attribute name="border">0</xsl:attribute>
					</img>
				</xsl:if>
			</xsl:if>
		</xsl:for-each>

</div>
		<xsl:if test="not(contains(/d:document/d:item[@name='$FILE']/d:object/d:file[@hosttype='stream']/@name, '$MIME_PART_'))">
        	<xsl:for-each select="/d:document/d:item[@name='Body']/d:itemdata[@type='19']">
                <pd4ml-include  encoding="qp" debug="false"><xsl:attribute name="skipplain"><xsl:value-of
                	select="$skipplain"/></xsl:attribute><xsl:copy-of select="text()"/></pd4ml-include>
        	</xsl:for-each>
        	<!--   xsl:for-each select="/d:document/d:item[@name='Body']/d:rawitemdata[@type='1']">
                <pd4ml-include  encoding="bin" debug="false"><xsl:attribute name="skipplain"><xsl:value-of
                	select="$skipplain"/></xsl:attribute><xsl:copy-of select="text()"/></pd4ml-include>
        	</xsl:for-each>
        	<xsl:for-each select="/d:document/d:item[@name='PD4MLBody']/d:rawitemdata[@type='1']">
                <pd4ml-include  encoding="bin" debug="false"><xsl:attribute name="skipplain"><xsl:value-of
                	select="$skipplain"/></xsl:attribute><xsl:copy-of select="text()"/></pd4ml-include>
        	</xsl:for-each -->
			<xsl:for-each select="/d:document/d:item/d:rawitemdata[@type='19']"><div style="width: 1000; word-wrap: break-word">
				<pd4ml-include encoding="qp" debug="false"><xsl:attribute name="skipplain"><xsl:value-of
                	select="$skipplain"/></xsl:attribute><xsl:copy-of select="text()"/></pd4ml-include></div><!-- change xdiv to div not to let content to spill out the given width  -->
			</xsl:for-each>
		</xsl:if>

		<xsl:for-each select="/d:document/d:item[@name='$FILE']/d:object/d:file[@name='mime.htm']/d:filedata">
			<pd4ml-include charset="UTF-8" rfc822="decode" debug="false"><xsl:attribute name="encoding"><xsl:value-of select="../@encoding"/></xsl:attribute>
			<xsl:copy-of select="text()"/></pd4ml-include>
		</xsl:for-each>

		<xsl:for-each select="/d:document/d:item[@name='$FILE']/d:object/d:file[@name='mime.htm']/d:tmpfilereference">
			<pd4ml-include encoding="qptxt" charset="UTF-8" rfc822="decode" debug="false"> <!--  option: rfc822="ignore" -->
				<xsl:attribute name="src"><xsl:copy-of select="text()"/></xsl:attribute>
			</pd4ml-include>
		</xsl:for-each>

		<xsl:apply-templates select="d:item"/>

		<xsl:if test="contains(/d:document/d:item[@name='$FILE']/d:object/d:file[@hosttype='stream']/@name, '$MIME_PART_')">
         	<xsl:for-each select="/d:document/d:item[@name='Body']/d:itemdata[@type='19']">
                <pd4ml-include  encoding="qp" debug="false" skipplain="true"><xsl:copy-of select="text()"/></pd4ml-include>
        	</xsl:for-each>

			<xsl:for-each select="/d:document/d:item/d:rawitemdata[@type='19']">
				<pd4ml-include encoding="qp" debug="false" skipplain="true"><xsl:copy-of select="text()"/></pd4ml-include>
			</xsl:for-each>

			<xsl:for-each select="/d:document/d:item[@name='$FILE']/d:object/d:file[@hosttype='stream']/d:filedata">
				<pd4ml-include encoding="mimebody" charset="UTF-8" debug="false" skipplain="true">
				<xsl:copy-of select="text()"/></pd4ml-include>
			</xsl:for-each>

			<xsl:for-each select="/d:document/d:item[@name='$FILE']/d:object/d:file[@hosttype='stream']/d:tmpfilereference">
				<pd4ml-include encoding="mimebody" charset="UTF-8" debug="false" skipplain="true">
					<xsl:attribute name="src"><xsl:copy-of select="text()"/></xsl:attribute>
				</pd4ml-include>
			</xsl:for-each>
		</xsl:if>

		<xsl:if test="not(/d:document/d:item[@name='$FILE']/d:object/d:file[@name='mime.htm']/d:tmpfilereference)">
			<xsl:for-each select="/d:document/d:item[@name='$FILE']/d:object/d:file[@name='mime.txt']/d:tmpfilereference">
				<pd4ml-include encoding="qptxt" charset="UTF-8" rfc822="decode" debug="false"> <!--  option: rfc822="ignore" -->
					<xsl:attribute name="src"><xsl:copy-of select="text()"/></xsl:attribute>
				</pd4ml-include>
			</xsl:for-each>
		</xsl:if>

		<xsl:if test="not(/d:document/d:item[@name='$FILE']/d:object/d:file[@name='mime.htm']/d:filedata)">
			<xsl:for-each select="/d:document/d:item[@name='$FILE']/d:object/d:file[@name='mime.txt']/d:filedata">
				<pd4ml-include charset="UTF-8" rfc822="decode" encoding="qptxt" debug="false"><xsl:copy-of select="text()"/></pd4ml-include>
			</xsl:for-each>
		</xsl:if>

		<!--  copy-pasted MIME images; needs to be refined -->
		<xsl:for-each select="/d:document/d:item[@name='$FILE']/d:object/d:file[contains(@name,'mime.gif')]/d:filedata">
				<img>
					<xsl:attribute name="src">data:image/gif;base64,<xsl:value-of select="normalize-space(.)" disable-output-escaping="yes"/></xsl:attribute>
					<xsl:attribute name="border">0</xsl:attribute>
				</img>
		</xsl:for-each>

</body>
</html>
	</xsl:template>


	<xsl:template match="d:compositedata" />
	<xsl:template match="d:item">
		<xsl:apply-templates select="d:richtext"/>
	</xsl:template>
	<xsl:template match="d:compositedata">
	</xsl:template>
	<xsl:template match="d:richtext">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="d:horizrule">
		<hr>
			<xsl:attribute name="width"><xsl:value-of select="@width"/></xsl:attribute>
			<xsl:attribute name="height"><xsl:value-of select="@height"/></xsl:attribute>
		</hr>
	</xsl:template>
	<xsl:template match="d:table">
		<!--  &#160; -->
		<table width="100%" ZZZ="aaa" cellspacing="0" xcellpadding="0">

			<xsl:if test="@rowspacing"><xsl:attribute name="cellpadding"><xsl:value-of select="@rowspacing"/></xsl:attribute></xsl:if>
			<xsl:if test="@refwidth"><xsl:attribute name="width"><xsl:value-of select="@refwidth"/></xsl:attribute></xsl:if>
			<xsl:if test="@widthtype='fitmargins'"><xsl:attribute name="width">100%</xsl:attribute></xsl:if>
			<xsl:if test="not(string(@cellborderstyle))">
				<xsl:attribute name="class">tablestyle1</xsl:attribute>
			</xsl:if>
			<xsl:attribute name="style"><xsl:if
			    test="d:tablerow/d:tablecell/@borderwidth='0px'">border-width: 0;</xsl:if><xsl:if
				test="string(@leftmargin)">margin-left: <xsl:value-of select="@leftmargin"/>;</xsl:if><xsl:if
				test="string(@rightmargin)">margin-right: <xsl:value-of select="@rightmargin"/>;</xsl:if><xsl:if
				test="string(d:border/@width)">border-width: <xsl:value-of select="d:border/@width"/>;</xsl:if><xsl:if
				test="string(d:border/@style)"> border-style: <xsl:choose><xsl:when
					test="d:border/@style='dot'">dotted</xsl:when><xsl:when
					test="d:border/@style='dash'">dashed</xsl:when><xsl:otherwise><xsl:value-of
					select="d:border/@style"/></xsl:otherwise></xsl:choose>;</xsl:if><xsl:choose><xsl:when
						test="string(d:border/@color)"> border-color: <xsl:value-of
						select="d:border/@color"/>;</xsl:when><xsl:otherwise><xsl:if
				test="not(string(@cellborderstyle))">border-color: black;</xsl:if></xsl:otherwise></xsl:choose></xsl:attribute>
			<xsl:if test="string(@cellborderstyle)"><xsl:choose><xsl:when
						test="string(d:border/@width)"><xsl:attribute name="border"><xsl:value-of
						select="d:border/@width"/></xsl:attribute></xsl:when><xsl:otherwise><xsl:attribute
						name="border">1</xsl:attribute><xsl:attribute name="cellspacing">1</xsl:attribute></xsl:otherwise></xsl:choose>
			</xsl:if>

			<xsl:for-each select="d:tablecolumn">
				<col>
					<xsl:attribute name="width"><xsl:value-of select="@width"/></xsl:attribute>
				</col>
			</xsl:for-each>

			<xsl:apply-templates/>
		</table>
	</xsl:template>
	<xsl:template match="d:code">
	</xsl:template>
	<xsl:template match="d:tablerow">
		<tr>
			<xsl:apply-templates/>
		</tr>
	</xsl:template>
	<xsl:template match="d:tablecell">
		<td valign="top">


			<xsl:attribute name="style"><xsl:choose>
				<xsl:when test="../../@cellborderstyle"></xsl:when>
				<xsl:otherwise><xsl:choose>
					<xsl:when test="string(../../@cellbordercolor)">border-color: <xsl:value-of select="../../@cellbordercolor"/>;</xsl:when>
					<xsl:otherwise>border-color: black;</xsl:otherwise>
				</xsl:choose></xsl:otherwise>
			</xsl:choose><xsl:if test="string(@borderwidth)">border-width: <xsl:value-of select="@borderwidth"/>;</xsl:if><xsl:choose><xsl:when
			test="string(@bgcolor)"> background-color: <xsl:value-of select="@bgcolor"/>;</xsl:when>
				</xsl:choose></xsl:attribute>
			<xsl:if test="@columnspan"><xsl:attribute name="colspan"><xsl:value-of select="@columnspan"/></xsl:attribute></xsl:if>
			<xsl:if test="@rowspan"><xsl:attribute name="rowspan"><xsl:value-of select="@rowspan"/></xsl:attribute></xsl:if>
			<xsl:apply-templates/>
		</td>
	</xsl:template>

	<xsl:template match="d:pardef">
	</xsl:template>

	<xsl:template match="d:par">
		<xsl:choose>
		<xsl:when test="@def">
			<xsl:variable name="defnum" select="@def"/>
			<xsl:call-template name="processpar"><xsl:with-param
			name="defnum" select="$defnum"/></xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:variable name="defnum" select="preceding-sibling::d:par[@def][1]/@def"/>
			<xsl:call-template name="processpar"><xsl:with-param
			name="defnum" select="$defnum"/></xsl:call-template>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="processpar">
		<xsl:param name="defnum"/>
		<xsl:choose>
			<xsl:when test="contains(//d:pardef[@id=$defnum]/@list, 'number')">

				<xsl:variable name="pxid" select="preceding-sibling::d:par[1]/@def"/>
				<xsl:choose>
				<xsl:when test="not($pxid) or not(//d:pardef[@id=$pxid]/@list)">
					<xsl:text disable-output-escaping='yes'><![CDATA[<ol>]]></xsl:text>
				</xsl:when>
				<xsl:when test="$pxid and $pxid != $defnum and not(preceding-sibling::d:par[@def=$defnum])">
					<xsl:text disable-output-escaping='yes'><![CDATA[<ol>]]></xsl:text>
				</xsl:when>
				</xsl:choose>


				<li>
					<xsl:attribute name="class">par_<xsl:value-of select="$uid"/>_<xsl:value-of select="$defnum"/></xsl:attribute>
					<xsl:apply-templates/>
				</li>

				<xsl:choose>
					<xsl:when test="following-sibling::d:par[1]/@def">
							<xsl:variable name="xid" select="following-sibling::d:par[1]/@def"/>
							<xsl:if test="$xid != $defnum">
								<xsl:choose>
								<xsl:when test="//d:pardef[@id=$xid]/@list">
									<xsl:if test="preceding-sibling::d:par[@def=$xid]">
										<xsl:text disable-output-escaping='yes'><![CDATA[</ol>]]></xsl:text>
									</xsl:if>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="close-list">
									<xsl:with-param name="newpardef" select="following-sibling::d:par[1]/@def"/>
									</xsl:call-template>
								</xsl:otherwise>
								</xsl:choose>
							</xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="not(name(following-sibling::*[1]) = 'pardef')">
							<xsl:text disable-output-escaping='yes'><![CDATA[</ol>]]></xsl:text>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>

			<xsl:when test="contains(//d:pardef[@id=$defnum]/@list, 'bullet')">

				<xsl:variable name="pxid" select="preceding-sibling::d:par[1]/@def"/>
				<xsl:choose>
				<xsl:when test="not($pxid) or not(//d:pardef[@id=$pxid]/@list)">
					<xsl:text disable-output-escaping='yes'><![CDATA[<ul>]]></xsl:text>
				</xsl:when>
				<xsl:when test="$pxid and $pxid != $defnum and not(preceding-sibling::d:par[@def=$defnum])">
					<xsl:text disable-output-escaping='yes'><![CDATA[<ul>]]></xsl:text>
				</xsl:when>
				</xsl:choose>

				<li>
					<xsl:attribute name="class">par_<xsl:value-of select="$uid"/>_<xsl:value-of select="$defnum"/></xsl:attribute>
					<xsl:apply-templates/>
				</li>

				<xsl:choose>
					<xsl:when test="following-sibling::d:par[1]/@def">
							<xsl:variable name="xid" select="following-sibling::d:par[1]/@def"/>
							<xsl:if test="$xid != $defnum">
								<xsl:choose>
								<xsl:when test="//d:pardef[@id=$xid]/@list">
									<xsl:if test="preceding-sibling::d:par[@def=$xid]">
										<xsl:text disable-output-escaping='yes'><![CDATA[</ul>]]></xsl:text>
									</xsl:if>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="close-list">
									<xsl:with-param name="newpardef" select="following-sibling::d:par[1]/@def"/>
									</xsl:call-template>
								</xsl:otherwise>
								</xsl:choose>
							</xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="not(name(following-sibling::*[1]) = 'pardef')">
							<xsl:text disable-output-escaping='yes'><![CDATA[</ul>]]></xsl:text>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>

			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="normalize-space(.) = ''">
						<div><xsl:attribute name="class">par_<xsl:value-of select="$uid"/>_<xsl:value-of select="$defnum"/></xsl:attribute>&#160;</div>
					</xsl:when>
					<xsl:otherwise>
						<div>
							<xsl:attribute name="class">par_<xsl:value-of select="$uid"/>_<xsl:value-of select="$defnum"/></xsl:attribute>
							<xsl:apply-templates/>
							<xsl:if test="normalize-space(.) = ''"><!--  &#160; --> </xsl:if>
						</div>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
			</xsl:choose>
	</xsl:template>

	<xsl:template name="close-list">
		<xsl:param name="newpardef"/>
			<xsl:for-each select=". | preceding-sibling::d:par">
			<xsl:sort select="position()" data-type="number" order="descending"/>
				<xsl:variable name="xid" select="@def"/>
				<xsl:variable name="def" select="//d:pardef[@id=$xid]/@list"/>
				<xsl:if test="$def">
					<xsl:if test="contains($def, 'number')">
						<xsl:text disable-output-escaping='yes'><![CDATA[</ol>]]></xsl:text>
					</xsl:if>
					<xsl:if test="contains($def, 'bullet')">
						<xsl:text disable-output-escaping='yes'><![CDATA[</ul>]]></xsl:text>
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
	</xsl:template>

	<xsl:template match="d:run"><font><xsl:attribute
		name="style"><xsl:call-template name="build-style"><xsl:with-param
		name="el" select="."/></xsl:call-template></xsl:attribute><xsl:apply-templates/><xsl:if test="normalize-space(.) = ''"><!--  &#160; --> </xsl:if></font></xsl:template>

	<xsl:template match="d:break">
		<br/>
	</xsl:template>

	<xsl:template match="d:button">
		<input type="button">
			<xsl:attribute name="value"><xsl:value-of select="normalize-space(.)"/></xsl:attribute>
		</input>
	</xsl:template>

	<xsl:template match="d:embeddedcontrol">
		<xsl:choose>
			<xsl:when test="@type = 'edit'">
				<div>
				<xsl:attribute name="style">border: 1 inset; padding: 2; <xsl:if test="@widthtype = 'fitwindow'">width: 100%;</xsl:if><xsl:call-template
				name="build-style"><xsl:with-param name="el" select="."/></xsl:call-template></xsl:attribute><xsl:apply-templates/>&#160;
				</div>
			</xsl:when>
			<xsl:otherwise>
				<div xwidth="10">
				<xsl:if test="string(@borderstyle)"><xsl:attribute name="style">border-width: 1; border-style: <xsl:value-of select="@borderstyle"/>;</xsl:attribute></xsl:if>
				<xsl:if test="@widthtype = 'fitwindow'"><xsl:attribute name="style">width: 100%;</xsl:attribute></xsl:if>
				<xsl:apply-templates/>
				</div>
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	<xsl:template match="d:embeddedkeywords">
		<xsl:for-each select="d:keyword">
			<input type="radio"><xsl:if test="@on = 'true'"><xsl:attribute name="checked">true</xsl:attribute></xsl:if></input><xsl:value-of select="text()"/><br/>
		</xsl:for-each>
	</xsl:template>

	<xsl:template match="d:urllink">
		<a><xsl:attribute name="href"><xsl:value-of select="@href"/></xsl:attribute><xsl:apply-templates/></a>
	</xsl:template>

	<xsl:template match="d:attachmentref">
		<xsl:variable name="attkey"><xsl:value-of select="@name"/></xsl:variable>
		<pd4ml-attachment icon="Area">
			<xsl:attribute name="skipplain"><xsl:value-of select="$skipplain"/></xsl:attribute>
			<xsl:attribute name="description"><xsl:value-of select="@displayname"/></xsl:attribute>
			<xsl:attribute name="height"><xsl:value-of select="d:picture/@height"/></xsl:attribute>
			<xsl:attribute name="width"><xsl:value-of select="d:picture/@width"/></xsl:attribute>

			<xsl:call-template name="getbody">
				<xsl:with-param name="p1" select="$attkey"/>
			</xsl:call-template>

		</pd4ml-attachment>
		<img>
			<xsl:attribute name="height"><xsl:value-of select="d:picture/@height"/></xsl:attribute>
			<xsl:attribute name="width"><xsl:value-of select="d:picture/@width"/></xsl:attribute>
			<xsl:if test="d:picture/d:notesbitmap">
				<xsl:attribute name="src">data:image/bmp;base64,<xsl:value-of
				select="normalize-space(d:picture/d:notesbitmap)" disable-output-escaping="yes"/></xsl:attribute>
				<xsl:attribute name="border">0</xsl:attribute>
			</xsl:if>
			<xsl:if test="d:picture/d:gif">
				<xsl:attribute name="src">data:image/gif;base64,<xsl:value-of
				select="normalize-space(d:picture/d:gif)" disable-output-escaping="yes"/></xsl:attribute>
				<xsl:attribute name="border">0</xsl:attribute>
			</xsl:if>
			<xsl:if test="d:picture/d:jpeg">
				<xsl:attribute name="src">data:image/jpeg;base64,<xsl:value-of
				select="normalize-space(d:picture/d:jpeg)" disable-output-escaping="yes"/></xsl:attribute>
				<xsl:attribute name="border">0</xsl:attribute>
			</xsl:if>
		</img>
		<xsl:if test="d:picture/d:caption"><div><xsl:value-of select="d:picture/d:caption"/></div></xsl:if>
	</xsl:template>
	<xsl:template match="d:picture">
		<xsl:choose>
			<xsl:when test="child::d:gif[1]">
				<img>
					<xsl:attribute name="height"><xsl:value-of select="@height"/></xsl:attribute>
					<xsl:attribute name="width"><xsl:value-of select="@width"/></xsl:attribute>
					<xsl:attribute name="src">data:image/gif;base64,<xsl:value-of select="normalize-space(d:gif)" disable-output-escaping="yes"/></xsl:attribute>
					<xsl:attribute name="border">0</xsl:attribute>
				</img>
			</xsl:when>
			<xsl:when test="child::d:jpeg[1]">
				<img>
					<xsl:attribute name="height"><xsl:value-of select="@height"/></xsl:attribute>
					<xsl:attribute name="width"><xsl:value-of select="@width"/></xsl:attribute>
					<xsl:attribute name="src">data:image/jpeg;base64,<xsl:value-of select="normalize-space(d:jpeg)" disable-output-escaping="yes"/></xsl:attribute>
					<xsl:attribute name="border">0</xsl:attribute>
				</img>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="getbody">
		<xsl:param name="p1"/>

		<xsl:for-each select="/d:document/d:item/d:object/d:file">
			<xsl:if test="contains( @name, $p1 )">

			<xsl:attribute name="compression"><xsl:value-of select="@compression"/></xsl:attribute>

			<xsl:choose>
				<xsl:when test="d:tmpfilereference">
					<xsl:value-of select="normalize-space(d:tmpfilereference/text())" disable-output-escaping="yes"/>
				</xsl:when>
				<xsl:otherwise>data:image/gif;base64,<xsl:copy-of select="d:filedata/text()"/></xsl:otherwise>
			</xsl:choose>

			</xsl:if>
		</xsl:for-each>

		<xsl:for-each select="/d:document/d:item/d:object/d:tmpfilereference">
			<xsl:if test="contains( @name, $p1 )">
				<xsl:value-of select="normalize-space(d:filedata/text())" disable-output-escaping="yes"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="get-value">
		<xsl:param name="reference"/>
		<xsl:param name="default"/>
		<xsl:choose>
			<xsl:when test="count(whatever) &gt; 0">
				<xsl:value-of select="whatever"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$default"/>
				<!-- xsl:call-template name="get-value"><xsl:with-param name="reference" select=""/><xsl:with-param name="default">inherit</xsl:with-param></xsl:call-template -->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="build-style">
		<xsl:param name="el"/><xsl:if
			test="d:font/@name"> font-family: <xsl:value-of select="d:font/@name"/>;</xsl:if><xsl:if
			test="d:font/@size"> font-size: <xsl:value-of select="d:font/@size"/>;</xsl:if><xsl:if
			test="contains(d:font/@style, 'bold')"> font-weight: bold;</xsl:if><xsl:if
			test="contains(d:font/@style, 'italic')"> font-style: italic;</xsl:if><xsl:if
			test="contains(d:font/@style, 'superscript')"> vertical-align: super;</xsl:if><xsl:if
			test="contains(d:font/@style, 'subscript')"> vertical-align: sub;</xsl:if><xsl:if
			test="contains(d:font/@style, 'underline')"> text-decoration: underline;</xsl:if><xsl:if
			test="contains(d:font/@style, 'strikethrough')"> text-decoration: line-through;</xsl:if><xsl:if
			test="string(d:font/@color)"> color: <xsl:value-of select="d:font/@color"/>;</xsl:if></xsl:template>

	<xsl:template name="format-date-time"> <!--  20130328T163613,18-05 -->
	    <xsl:param name="date" select="'%Y%m%dT%H%M%S,%z'"/>
	    <xsl:value-of select="substring($date, 5, 2)"/>
	    <xsl:text>/</xsl:text>
	    <xsl:value-of select="substring($date, 7, 2)"/>
	    <xsl:text>/</xsl:text>
	    <xsl:value-of select="substring($date, 1, 4)"/>
	    <xsl:text> </xsl:text>
	    <xsl:value-of select="substring($date, 10, 2)"/>
	    <xsl:text>:</xsl:text>
	    <xsl:value-of select="substring($date, 12, 2)"/>
	    <xsl:text>:</xsl:text>
	    <xsl:value-of select="substring($date, 14, 2)"/>
	</xsl:template>

</xsl:stylesheet>
