/*
 * Generated by the Jasper component of Apache Tomcat
 * Version: JspC/ApacheTomcat10
 * Note: The last modified time of this file was set to
 *       the last modified time of the source file after
 *       generation to assist with modification tracking.
 */
package org.apache.jsp.admin.AgentStatus.data;

import jakarta.servlet.*;
import jakarta.servlet.http.*;
import jakarta.servlet.jsp.*;
import com.egurkha.*;
import java.util.*;
import com.eg.EgDbAdapterTypeUI;
import egurkha.EgDbAdapterUI;
import egurkha.reporter.*;
import com.eg.*;
import java.util.*;
import com.egurkha.EgUserPermission;
import com.egurkha.EgUserRole;
import com.eg.EgDateInfo;
import com.eg.EgMappingInfo;
import com.eg.IniFile;
import com.eg.EgInstallInfo;
import egurkha.UserBean;
import com.eg.EgUsersInfo;
import com.eg.EgLicenseInfo;
import com.eg.EgRoleInfo;
import com.eg.EgServerList;
import com.eg.IniFile;
import com.egurkha.util.StringUtils;
import java.util.*;
import java.io.*;
import java.text.*;
import org.json.simple.JSONObject;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;

public final class EgServerListJson_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent,
                 org.apache.jasper.runtime.JspSourceImports {


	public boolean isNullOrEmpty(Object object)
	{
		try
		{
			if(object == null)
			{
				return true;
			}
			else if(object instanceof java.lang.String)
			{
				String string = (String) object;
				if (string.equals("") || string.equalsIgnoreCase("null"))
				{
					return true;
				}
				return false;
			}
			else if(object instanceof java.lang.StringBuffer)
			{
				String stringBuffer = (String)object.toString();
				if (stringBuffer.equals("") || stringBuffer.equals("null"))
				{
					return true;
				}
				return false;
			}
			else if(object instanceof java.util.StringTokenizer)
			{
				StringTokenizer st = (StringTokenizer) object;
				if (!st.hasMoreTokens())
				{
					return true;
				}
				return false;
			}
			else if(object instanceof java.util.List)
			{
				List list =(List)object;
				if (list.isEmpty())
				{
					return true;
				}
				return false;
			}
			else if(object instanceof java.util.Map)
			{
				Map map =(Map)object;
				if (map.isEmpty())
				{
					return true;
				}
				return false;
			}
			else if(object instanceof java.util.Set)
			{
				Set set =(Set)object;
				if (set.isEmpty())
				{
					return true;
				}
				return false;
			}
			else
			{
				return false;
			}
		}
		catch (Exception e)
		{
			System.out.println("Execption in the method isNullOrEmpty @ /final/admin/EgTrackerA.jsp :"+e);
		}
		return false;
	}

	public boolean isNull(Object object)
	{
		if(object == null)
		{
			return true;
		}
		return false;
	}


	String USER_COMP_AGENTS = "Agents for user licensed types";
	String[] agentTypes = {"BasicAgents","PremiumAgents", "ExternalAgents", "RemoteAgents","Agents with no license",USER_COMP_AGENTS};
	String[] agentStatus = {"All","Running","NotRunning"};


	public String getAssignedHostsForExternalAgent(String agentName,ArrayList allNicks)
	{
		IniFile extIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_external.ini");
		String[] vars = extIni.getVariables("Test_Mapping_Section");
		String res="";
		if (vars == null)
			return res;
		List tmpList = new ArrayList();
		com.eg.EgDiscInfo discInfoObj = new com.eg.EgDiscInfo("manager");
		String rumServerList[] = discInfoObj.getAllServersOfType("Real_user_monitor");
		ArrayList varsList = new ArrayList(Arrays.asList(vars));
		boolean isRUMCompExists = false;
		try{
			if (rumServerList != null ) {
				for (int a=0;a<rumServerList.length;a++) {
					String serverName = (String)rumServerList[a];
					if (serverName != null && serverName.startsWith("Real_user_monitor")) {
						try{
							serverName = serverName.substring(serverName.indexOf(":")+1,serverName.lastIndexOf(":"));
							isRUMCompExists = true;
						} catch(Exception ex){
							serverName = serverName;
						}
						varsList.remove(serverName);
					}
				}
			}
		}
		catch(Exception ex){
			ex.printStackTrace();
		}
		if (isRUMCompExists){
			vars = (String[])varsList.toArray(new String[varsList.size()]);
		}
		int nickSize = allNicks.size();
		for (int n=0; n<nickSize; n++)
		{
			String host = (String)allNicks.get(n);
			String agents = extIni.getValue("Test_Mapping_Section",host);
			if(agents != null && !agents.equals(""))
			{					
				StringTokenizer stt = new StringTokenizer(agents,",");
				while (stt.hasMoreTokens())
				{
					if (agentName.equals(stt.nextToken()))
					{
						//res += host+", ";
						tmpList.add(host);
						break;
					}
				}
			}
		}
		Collections.sort(tmpList, String.CASE_INSENSITIVE_ORDER);
		for (int t=0; t < tmpList.size(); t++)
		{
			String tmp = tmpList.get(t).toString();
			res += tmp+",";
		}
		res = res.trim();
		if (res.endsWith(","))
			res = res.substring(0,res.length()-1);
		return res;
	}

	public String getAssignedHostsForRemoteAgent(String agentName,ArrayList allNicks)
	{
		IniFile extIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_external.ini");
		String[] vars = extIni.getVariables("Remote_Agent_Mapping_Section");
		String res="";
		if (vars == null)
			return res;
		List tmpList = new ArrayList();
		int nickSize = allNicks.size();
		for (int n=0; n<nickSize; n++)
		{
			String host = (String)allNicks.get(n);
			String agent = extIni.getValue("Remote_Agent_Mapping_Section",host);
			if(agent != null && !agent.equals(""))
			{			
				if (agent.equals(agentName))
				{
					//res += host+", ";
					tmpList.add(host);
				}
			}
		}
		Collections.sort(tmpList, String.CASE_INSENSITIVE_ORDER);
		for (int t=0; t < tmpList.size(); t++)
		{
			String tmp = tmpList.get(t).toString();
			res += tmp+",";
		}
		res = res.trim();
		if (res.endsWith(","))
			res = res.substring(0,res.length()-1);
		return res;
	}

	/*
	 * This method is used to get shared agent(s) among users
	 *
	 * [SHARED AGENT - component monitoring by an agent which are assigned by more than one limited admin user]
	 *
	 * 1. get all managed variables from eg_discover.ini by passing nicks and
	 * 2. compare it with managed variables(for single user) at 'user_serv' table
	 * 3. if 'user_serv' contains all the eg_discover.ini variables then no shared agents found
	 * 4. otherwise shared agents found.
	 *
	 */
	public ArrayList getUsersSharedAgents(ArrayList agentList, EgRoleInfo egRoleInfo, boolean ExtAgent, boolean RemAgent)
	{
		ArrayList userWiseCompList = egRoleInfo.getAllServers(); //Userwise managed components list
		ArrayList allCompNicks = egRoleInfo.getAllServerNicks();
		ArrayList userCompList = new ArrayList();
		ArrayList sharedAgents = new ArrayList();

		if(ExtAgent || RemAgent)
		{
			ArrayList usersNicks = new ArrayList();
			for(int a=0; a<agentList.size(); a++)
			{
				String temp = "";
				if(ExtAgent)
					temp = getAssignedHostsForExternalAgent((String)agentList.get(a),allCompNicks);
				else if(RemAgent)
					temp = getAssignedHostsForRemoteAgent((String)agentList.get(a),allCompNicks);
				if(temp.trim().length() > 0)
				{
					StringTokenizer tmpStrTknzr = new StringTokenizer(temp,",");
					while(tmpStrTknzr.hasMoreTokens())
					{
						String st = (String)tmpStrTknzr.nextToken();
						if(!usersNicks.contains(st))
						{
							usersNicks.add(st); //External/Remote Agent's all assigned hosts of corresponding user
						}
					}
				}
			}
			userCompList = getAllManagedComponents(usersNicks);
		}
		else
		{
			userCompList = getAllManagedComponents(agentList);
		}
		if(userCompList != null && userCompList.size() > 0)
		{
			for (int m=0; m<userCompList.size(); m++)
			{
				String host = (String)userCompList.get(m);
				if(userWiseCompList.contains(host))
					continue;
				else
				{
					host = host.substring(host.indexOf(":")+1);
					host = host.substring(0,host.indexOf(":"));
					if(!sharedAgents.contains(host))
					{
						sharedAgents.add(host);
					}
				}
			}
		}
		return sharedAgents;
	}

	/*
	 * This method is used to get all managed components from eg_discover.ini (from all users)
	 */
	public ArrayList getAllManagedComponents(ArrayList usersNicks)
	{
		com.eg.EgDiscInfo discInfoObj = new com.eg.EgDiscInfo("manager");
		ArrayList usersAllCompList = new ArrayList();

		if(usersNicks != null && usersNicks.size() > 0)
		{
			for(int r=0; r<usersNicks.size(); r++)
			{
				String tempHost = (String)usersNicks.get(r);
				ArrayList userComps = discInfoObj.getServersForHost(tempHost, true);
				usersAllCompList.addAll(userComps);
			}
		}
		return usersAllCompList;
	}

	/*
	 * This method is used to check whether the assigned host for external/remote agents shared among users or not
	 */
	public boolean isAssignedHostShared(boolean isNickShared, ArrayList sharedAgents, String hosts)
	{
		boolean isAssignedHostShared = false;
		if(sharedAgents != null)
		{
			int sharedAgentsSize = sharedAgents.size();
			if(isNickShared && sharedAgentsSize > 0)
			{
				ArrayList hostList = new ArrayList();
				StringTokenizer hostTknzr = new StringTokenizer(hosts, ",");
				while (hostTknzr.hasMoreTokens())
				{
					hostList.add(hostTknzr.nextToken());
				}
				sharedAgents.removeAll(hostList);
				if(sharedAgentsSize != sharedAgents.size())
				{
					isAssignedHostShared = true;
				}
			}
		}
		return isAssignedHostShared;
	}

	private ArrayList getSearchData(ArrayList usersList,String searchStr, boolean isSubstring)
	{
		ArrayList resultList = new ArrayList();
		int size = usersList.size();
		if (com.egurkha.util.StringUtils.isNull(searchStr))
		{
			return usersList;
		}

		ArrayList searchList = new ArrayList();
		if (searchStr.indexOf(" ") != -1)
		{
			searchList = com.egurkha.util.StringUtils.egTokenizer(searchStr, " ");
		}
		else
		{
			searchList.add(searchStr);
		}

		if (searchList != null && !searchList.isEmpty())
		{
			ArrayList tmpSrchList = new ArrayList();
			int count = searchList.size();
			for (int c=0;c<count;c++)
			{
				String strSearch = (String) searchList.get(c);
				if (com.egurkha.util.StringUtils.isNull(strSearch))
				{
					continue;
				}
				tmpSrchList.add(strSearch);
			}
			searchList = new ArrayList();
			searchList.addAll(tmpSrchList);
		}

		for (int s=0;s<size;s++)
		{
			String strValue = usersList.get(s).toString();
			String tmpUser = strValue;
			if (searchList != null && searchList.size() > 0)
			{
				int searchCnt = searchList.size();
				if (searchCnt == 1)
				{
					if (isMatch(tmpUser,searchList.get(0).toString(),true))
					{
						resultList.add(strValue);
					}
				}
				else
				{
					for (int i=0;i<searchCnt;i++)
					{
						String strSearchVal = searchList.get(i).toString();
						if (isMatch(tmpUser,strSearchVal,true))
						{
							resultList.add(strValue);
						}
					}
				}
			}
			else
			{
				resultList.add(strValue);
			}
		}
		return resultList;
	}

	public static boolean isMatch(String o,String ss,boolean isNotCaseSensitive)
	{
		String valueString=o;
		String searchString=ss;
		if ((o == null) && (ss == null))
			return true;

		if(isNotCaseSensitive)
		{
			valueString = o.toLowerCase();
			searchString = ss.toLowerCase();
		}
		boolean flag = false;
		if (valueString.indexOf(searchString) != -1)
		{
			flag = true;
		}

		return(flag);
	}

	private ArrayList getCSVData(Map allAgentsMap, ArrayList allCompNicks, String agentType, EgMappingInfo _mapping, Hashtable nick_ip_map, Hashtable debug_status,Vector compNickList,boolean autoIpNameCheck)
	{
		List assignHostList = new ArrayList();
		ArrayList csvData = new ArrayList();
		if(!allAgentsMap.isEmpty())
		{
			String agentIPNick = _mapping.getTextDescription("admin.agents.Agent IP/Nickname");
			String install = _mapping.getTextDescription("admin.agents.Installed");
			String status = _mapping.getTextDescription("admin.agents.Status");
			String outputEnabled = _mapping.getTextDescription("admin.agents.Output Logging Enabled");

			csvData.add(agentIPNick+","+install+","+status+","+outputEnabled);
			Iterator itr = allAgentsMap.keySet().iterator();
			while(itr.hasNext())
			{
				String agentIP = (String)itr.next();
				String agent_state = (String)allAgentsMap.get(agentIP);
				String installed = agent_state.substring(0,agent_state.indexOf("-"));
				String running = agent_state.substring(agent_state.indexOf("-")+1);

				JSONObject obj = new JSONObject();
				if(agentType.equalsIgnoreCase("ExternalAgents"))
				{
					String hosts = getAssignedHostsForExternalAgent(agentIP,allCompNicks);
					if(hosts.trim().equals(""))
					{
						hosts = "- No assigned hosts found -";
					}
					assignHostList.add(agentIP+"#@#"+hosts);
				}
				else if (agentType.equalsIgnoreCase("RemoteAgents"))
				{
					String hosts = getAssignedHostsForRemoteAgent(agentIP,allCompNicks);
					if(hosts.trim().equals(""))
					{
						hosts = "- No assigned hosts found -";
					}
					assignHostList.add(agentIP+"#@#"+hosts);
				}
				boolean statusNotFound=true;
				boolean output = false;
				String agent_ip_address=null;
				String agent_ip_address_arr[]=null;
				String debugStatus=null;
				if(nick_ip_map.containsKey(agentIP))
				{
					agent_ip_address = (String)nick_ip_map.get(agentIP);
					if(agent_ip_address != null)
					{
						agent_ip_address_arr = StringUtils.getTokens(agent_ip_address,":");
					}
				}
				if(autoIpNameCheck)
				{
					if(agent_ip_address_arr != null)
					{
						int ipsCount=agent_ip_address_arr.length;
						for(int j=0;j<ipsCount;j++)
						{
							agent_ip_address=agent_ip_address_arr[j];
							if(debug_status.containsKey(agent_ip_address))
							{
								debugStatus = (String)debug_status.get(agent_ip_address);
								statusNotFound=false;
								break;
							}
							else if(debug_status.containsKey(agent_ip_address.toUpperCase()))
							{
								debugStatus = (String)debug_status.get(agent_ip_address.toUpperCase());
								statusNotFound=false;
								break;
							}
							else if(debug_status.containsKey(agent_ip_address.toLowerCase()))
							{
								debugStatus = (String)debug_status.get(agent_ip_address.toLowerCase());
								statusNotFound=false;
								break;
							}
							else if(compNickList != null && (compNickList.contains(agentIP) || compNickList.contains(agentIP.toLowerCase()) || compNickList.contains(agentIP.toUpperCase())))
							{
								debugStatus = "yes";
								statusNotFound=false;
								break;
							}
						}
					}
				}
				if(statusNotFound)
				{
					if(agentIP != null && debug_status.containsKey(agentIP))
					{
						debugStatus = (String)debug_status.get(agentIP);
					}
					else if(agentIP != null && debug_status.containsKey(agentIP.toUpperCase()))
					{
						debugStatus = (String)debug_status.get(agentIP.toUpperCase());
					}
					else if(agentIP != null && debug_status.containsKey(agentIP.toLowerCase()))
					{
						debugStatus = (String)debug_status.get(agentIP.toLowerCase());
					}
					else if(compNickList != null && (compNickList.contains(agentIP) || compNickList.contains(agentIP.toLowerCase()) || compNickList.contains(agentIP.toUpperCase())))
					{
						debugStatus = "yes";
					}
				}
				if(debugStatus != null && debugStatus.equalsIgnoreCase("yes"))
				{
					output=true;
				}
				else
				{
					output=false;
				}

				String tempInstalled = "Yes";
				if (installed.equalsIgnoreCase("Not Installed"))
				{
					tempInstalled = "No";
				}

				String csvOutput = "No";
				if (output)
					csvOutput = "Yes";

				String installMapping = _mapping.getTextDescription("admin.common."+tempInstalled);
				String runMapping = _mapping.getTextDescription("admin.agents."+running);
				String outputMapping = _mapping.getTextDescription("admin.common."+csvOutput);
				csvData.add(agentIP+","+installMapping+","+runMapping+","+outputMapping);
			}
		}
		
		if (!assignHostList.isEmpty())
		{
			String agentIPs = "";
			int big = 0;
			ArrayList allAssignHosts = new ArrayList();
			for (int c=0; c<assignHostList.size(); c++)
			{
				String hostStr = assignHostList.get(c).toString();
				String agent = hostStr.substring(0,hostStr.indexOf("#@#"));
				String assignHosts = hostStr.substring(hostStr.indexOf("#@#")+3);
				ArrayList assignHostsList = StringUtils.egTokenizer(assignHosts,",");
				int size = 0;
				if (!assignHosts.equals("- No assigned hosts found -"))
				{
					size = assignHostsList.size();
				}
				agentIPs += agent +" ("+size+")"+",";
				if(size > big)
					big = size;

				allAssignHosts.add(assignHostsList);
			}
			csvData.add("");
			csvData.add("");
			csvData.add("Assigned Hosts");
			csvData.add("");
			csvData.add(agentIPs);
			csvData.add("");

			for (int b=0; b<big; b++)
			{
				String row = "";
				for(int a=0; a<allAssignHosts.size(); a++)
				{
					ArrayList tmpList = (ArrayList)allAssignHosts.get(a);
					if(b < tmpList.size())
					{
						row += tmpList.get(b).toString()+",";
					}
					else
					{
						row += ""+",";
					}
				}
				csvData.add(row);
			}
		}
		return csvData;
	}

	Vector disableIPList()
	{
		Vector ipList = new Vector();
		ipList.addAll(getAgentDebug("AGENT_DEBUG_OPERATION_DISABLED").keySet());
		Vector disableIps = new Vector();
		if(ipList == null && ipList.size() == 0)
			return disableIps;
		EgDiscInfo discInfo = new EgDiscInfo("manager");
		Hashtable ipNickMap = discInfo.getIpNickMap();
		Hashtable nickIpMap = discInfo.getNickIpMap(true);
		for(int j=0;j<ipList.size();j++)
		{
			String ip = (String)ipList.get(j);
			String nick = (String)ipNickMap.get(ip);
			String nickIp = (String)nickIpMap.get(ip);
			if(!disableIps.contains(ip))
			{
				disableIps.add(ip);
			}
			if(nickIp != null && !disableIps.contains(nickIp))
			{
				disableIps.add(nickIp);
			}
			if(nick == null)
				continue;
			if(nick.indexOf(":") >-1)
			{
				String[] nicks = StringUtils.getTokens(nick,":");
				for(int k=0;k<nicks.length;k++)
				{
					String nick1 = nicks[k];
					nickIp = (String)nickIpMap.get(nick1);
					if(!disableIps.contains(nick1))
					{
						disableIps.add(nick1);
					}
					if(nickIp != null && !disableIps.contains(nickIp))
					{
						disableIps.add(nickIp);
					}
				}
			}
			else
			{
				nickIp = (String)nickIpMap.get(nick);
				if(!disableIps.contains(nick))
				{
					disableIps.add(nick);
				}
				if(nickIp != null && !disableIps.contains(nickIp))
				{
					disableIps.add(nickIp);
				}
			}
		}
		return disableIps;
	}

	public ArrayList getAgentsBasedOnStatus(ArrayList agentList, String agentState, EgServerList serverList)
	{
		ArrayList resultAgentsList = new ArrayList();
		ArrayList totalAgents = null;

		ArrayList aList = serverList.getAgentListFromDB();
		String currList[] = serverList.getTargetNames();
		totalAgents = serverList.getAgentList(agentList,aList,currList);
		int size = totalAgents.size();

		if (size > 0)
		{
			for(int j=0;j<size;j=j+4)
			{
				String agentIP = (String)totalAgents.get(j);
				String message = (String)totalAgents.get(j+1);
				if (agentState.equalsIgnoreCase("NotRunning"))
				{
					if (message.equals("Not Installed-Not Running") || message.equals("Installed-Not Running"))
					{
						resultAgentsList.add(agentIP);
					}
				}
				else if (agentState.equalsIgnoreCase("Running"))
				{
					if(message.equals("Installed-Running"))
					{
						resultAgentsList.add(agentIP);
					}
				}
			}
		}

		return resultAgentsList;
	}

	public Hashtable getAgentDebug(String subject)
	{
		IniFile agentStatus_ini =  new IniFile(EgInstallInfo.getInstallDir() + 
			"/manager/config/eg_agentoutputstatus.ini");
		Hashtable agentDebugMap = new Hashtable();
		String[] ipStrAry = agentStatus_ini.getVariables(subject);
		if(ipStrAry != null && ipStrAry.length>0)
		{
			for(int i=0;i<ipStrAry.length;i++)
			{
				String delimiter = ":";
				if(ipStrAry[i].indexOf(com.eg.EgInstallInfo.ipV6Sep)>=0)
				{
					delimiter = com.eg.EgInstallInfo.ipV6Sep;
				}
				String[] ips = StringUtils.getTokens(ipStrAry[i],delimiter);
				if(ips == null || ips.length == 0)
					continue;
				for(int j=0;j<ips.length;j++)
				{
					agentDebugMap.put(ips[j],agentStatus_ini.getValue(subject,ipStrAry[i]));
				}
			}
		}
		return agentDebugMap;
	}

	public synchronized void logToErrorFile(String msg)
	{
		String agentStatusLogFile = EgInstallInfo.getInstallDir() + "/manager/logs/AgentStatusLogFile";
		File ff = new File(agentStatusLogFile);
		long fileLimit = 5 * 1024 * 1024;
		if(ff != null && ff.length() >= fileLimit)
		{
			try
			{
				EgInstallInfo.fileRename(agentStatusLogFile,agentStatusLogFile+"1");
			}
			catch (Exception grr)
			{
				grr.printStackTrace();
			}
		}
		ff = null;
		PrintWriter logWriter;
		try
		{
			logWriter = new PrintWriter(new FileWriter(agentStatusLogFile, true));
		}
		catch (Exception e)
		{
			System.err.println("Cannot open log file " + agentStatusLogFile);
			return;
		}
		if(msg == null || msg.trim().length()==0)
		{
			logWriter.println(" ");
		}
		else
		{
			logWriter.println(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(new java.util.Date()) + " " + msg);
		}
		logWriter.close();
	}

  private static final jakarta.servlet.jsp.JspFactory _jspxFactory =
          jakarta.servlet.jsp.JspFactory.getDefaultFactory();

  private static java.util.Map<java.lang.String,java.lang.Long> _jspx_dependants;

  static {
    _jspx_dependants = new java.util.HashMap<java.lang.String,java.lang.Long>(1);
    _jspx_dependants.put("/admin/AgentStatus/data/../../EgTrackerAJSON.jsp", Long.valueOf(1673538584195L));
  }

  private static final java.util.Set<java.lang.String> _jspx_imports_packages;

  private static final java.util.Set<java.lang.String> _jspx_imports_classes;

  static {
    _jspx_imports_packages = new java.util.HashSet<>();
    _jspx_imports_packages.add("com.eg");
    _jspx_imports_packages.add("java.util");
    _jspx_imports_packages.add("java.text");
    _jspx_imports_packages.add("jakarta.servlet");
    _jspx_imports_packages.add("egurkha.reporter");
    _jspx_imports_packages.add("java.io");
    _jspx_imports_packages.add("jakarta.servlet.http");
    _jspx_imports_packages.add("jakarta.servlet.jsp");
    _jspx_imports_packages.add("com.egurkha");
    _jspx_imports_classes = new java.util.HashSet<>();
    _jspx_imports_classes.add("com.eg.EgDateInfo");
    _jspx_imports_classes.add("org.json.simple.parser.JSONParser");
    _jspx_imports_classes.add("egurkha.UserBean");
    _jspx_imports_classes.add("com.eg.EgServerList");
    _jspx_imports_classes.add("com.eg.EgDbAdapterTypeUI");
    _jspx_imports_classes.add("com.egurkha.util.StringUtils");
    _jspx_imports_classes.add("com.eg.IniFile");
    _jspx_imports_classes.add("org.json.simple.JSONArray");
    _jspx_imports_classes.add("com.eg.EgMappingInfo");
    _jspx_imports_classes.add("egurkha.EgDbAdapterUI");
    _jspx_imports_classes.add("com.egurkha.EgUserRole");
    _jspx_imports_classes.add("com.eg.EgLicenseInfo");
    _jspx_imports_classes.add("com.eg.EgUsersInfo");
    _jspx_imports_classes.add("com.eg.EgInstallInfo");
    _jspx_imports_classes.add("org.json.simple.JSONObject");
    _jspx_imports_classes.add("com.egurkha.EgUserPermission");
    _jspx_imports_classes.add("com.eg.EgRoleInfo");
  }

  private volatile jakarta.el.ExpressionFactory _el_expressionfactory;
  private volatile org.apache.tomcat.InstanceManager _jsp_instancemanager;

  public java.util.Map<java.lang.String,java.lang.Long> getDependants() {
    return _jspx_dependants;
  }

  public java.util.Set<java.lang.String> getPackageImports() {
    return _jspx_imports_packages;
  }

  public java.util.Set<java.lang.String> getClassImports() {
    return _jspx_imports_classes;
  }

  public jakarta.el.ExpressionFactory _jsp_getExpressionFactory() {
    if (_el_expressionfactory == null) {
      synchronized (this) {
        if (_el_expressionfactory == null) {
          _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
        }
      }
    }
    return _el_expressionfactory;
  }

  public org.apache.tomcat.InstanceManager _jsp_getInstanceManager() {
    if (_jsp_instancemanager == null) {
      synchronized (this) {
        if (_jsp_instancemanager == null) {
          _jsp_instancemanager = org.apache.jasper.runtime.InstanceManagerFactory.getInstanceManager(getServletConfig());
        }
      }
    }
    return _jsp_instancemanager;
  }

  public void _jspInit() {
  }

  public void _jspDestroy() {
  }

  public void _jspService(final jakarta.servlet.http.HttpServletRequest request, final jakarta.servlet.http.HttpServletResponse response)
      throws java.io.IOException, jakarta.servlet.ServletException {

    if (!jakarta.servlet.DispatcherType.ERROR.equals(request.getDispatcherType())) {
      final java.lang.String _jspx_method = request.getMethod();
      if ("OPTIONS".equals(_jspx_method)) {
        response.setHeader("Allow","GET, HEAD, POST, OPTIONS");
        return;
      }
      if (!"GET".equals(_jspx_method) && !"POST".equals(_jspx_method) && !"HEAD".equals(_jspx_method)) {
        response.setHeader("Allow","GET, HEAD, POST, OPTIONS");
        response.sendError(HttpServletResponse.SC_METHOD_NOT_ALLOWED, "JSPs only permit GET, POST or HEAD. Jasper also permits OPTIONS");
        return;
      }
    }

    final jakarta.servlet.jsp.PageContext pageContext;
    jakarta.servlet.http.HttpSession session = null;
    final jakarta.servlet.ServletContext application;
    final jakarta.servlet.ServletConfig config;
    jakarta.servlet.jsp.JspWriter out = null;
    final java.lang.Object page = this;
    jakarta.servlet.jsp.JspWriter _jspx_out = null;
    jakarta.servlet.jsp.PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html; charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;


/*
 *	Name		:	EgServerListJSON.jsp
 *	Purpose		:	To view all agents' current status
 *	Navigation	:	Home > [Click here to get the license details] > [Agent Status]
 */

      out.write("\r\n\r\n");

/*****************************************************************************************************
 *	Name			:	EgTrackerAJSON.jsp
 *	Version			:	eG 3.1.6
 *	Purpose			:	
 *	Creation Date	:	01-03-2005.
 *	Author			:	Bala Murali
 *	Last Modified	:	
 *****************************************************************************************************/

      out.write("\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n");

	IniFile controlModeUIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String RightClikMode = controlModeUIni.getValue("MODE_OF_OPERATION","rightClick");
	String SelectionMode = controlModeUIni.getValue("MODE_OF_OPERATION","selection");
	EgDbAdapterUI egDbTracker = EgDbAdapterTypeUI.getObject();
	String dbTrackerStatus =egDbTracker.setConnection();
	if(dbTrackerStatus == null)
	{
		egDbTracker.releaseConnection(false);
		EgDbAdapterTypeUI.releaseObject(egDbTracker);
		throw new Exception("<customerror>user-session-invalid</customerror>");
	}
	else if(dbTrackerStatus != null && !dbTrackerStatus.equals("CONNECTED"))
	{
		egDbTracker.releaseConnection(false);
		EgDbAdapterTypeUI.releaseObject(egDbTracker);
		throw new Exception("<customerror>user-session-invalid</customerror>");
	}
	egDbTracker.releaseConnection(false);
	EgDbAdapterTypeUI.releaseObject(egDbTracker);
	com.egurkha.ini.IniUI trackerUI = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String trackerLanguage = trackerUI.getDefaultLanguage();
	ErUserData UBean = null;
	String sessionID = null;
	UserRegistry registry = null;
	User _user = null;
	boolean id_u = false;
	String u_rs = null;
	long u_v_till = 0L;
	long l_accessed = 0L;
	String admin_Skin = null;
	String throughSchedule = request.getParameter("throughSchedule");
	if(throughSchedule == null) {
		throughSchedule = "";
	}
	if(throughSchedule.equalsIgnoreCase("true"))
	{
		String usr_Id_proc = request.getParameter("er_userid");
		String usr_Id = request.getParameter("eruserid");
		String userID = request.getParameter("userID");
		if(session!=null)
		{
			 UBean = (ErUserData) session.getAttribute("UBean");
			 if(throughSchedule.equalsIgnoreCase("true")) {
				 try
				 {
					if(UBean == null)
					{
						if(usr_Id !=null && !usr_Id.equalsIgnoreCase("null"))
						{
							UBean = new ErUserData(usr_Id,false);
							usr_Id_proc = usr_Id;
						}
						else if(userID != null)
						{
							UBean = new ErUserData(userID,false);
							usr_Id_proc = userID;
						}
						else if(usr_Id_proc == null || usr_Id_proc.equalsIgnoreCase("null"))
						{
							UBean = new ErUserData(usr_Id_proc,false);
						}
						else
						{
							UBean = new ErUserData(usr_Id_proc,false);
						}

					}
				}
				catch(Throwable t)
				{
					t.printStackTrace();
				}
			}
			if(UBean != null)
			{
				registry = UserRegistry.getInstance();
				_user= registry.getUser(session.getId(),true);
				if(_user!=null)
				{
					id_u = _user.isIdDeletedWhileLoggedIn();
					if(id_u==false )
					{
						u_rs = _user.getLoginID();
						if(!User.isDefaultUser(u_rs))
						{
							u_v_till = UBean.getUserValidtill();
							l_accessed = session.getLastAccessedTime();
						}
					}
				}
				if(throughSchedule.equalsIgnoreCase("true"))
				{
					if((_user.getLoginID() == null || _user.getLoginID().equals("")) && usr_Id_proc!= null)
					{
						try
						{
							_user = UBean.getUser(usr_Id_proc);
							registry.setUser(session.getId(), _user, false);
						}
						catch(Exception ex)
						{
							ex.printStackTrace();
						}
					}
				}
				if(_user == null && usr_Id_proc!= null ) {
					try {
						_user = UBean.getUser(usr_Id_proc);
						registry.setUser(session.getId(), _user, false);
						System.out.println("Setting user object. user admin skin : " + _user.getAdminSkin());
					} catch(Exception ex) {
						System.out.println("Setting user object failed");
						ex.printStackTrace();
					}
				}
			}
		}
	}
	else
	{
		String reqFrom = request.getServletPath();
		if(session!=null)
		{
			boolean isTimeBarJsonReq = false;
			if (reqFrom != null && reqFrom.endsWith("admin/EgTimeBarJson.jsp"))
			{
				isTimeBarJsonReq = true;
			}

			sessionID = session.getId();
			registry = UserRegistry.getInstance();
			if (isTimeBarJsonReq)
			{
				_user = registry.getUser(sessionID);
			}
			else
			{
				_user = registry.getUser(sessionID,true);
			}
			if(_user!=null)
			{
				id_u = _user.isIdDeletedWhileLoggedIn();
				if(id_u == false)
				{
					u_rs =  _user.getLoginID();
					if(!User.isDefaultUser(u_rs))
					{
						ErUserData er = _user.getReporterData();
						u_v_till = er.getUserValidtill();
						l_accessed = session.getLastAccessedTime();
					}
				}
			}
		}
	}

	if(session == null || _user == null)
	{
		throw new Exception("<customerror>user-session-invalid</customerror>");
	}
	else if(id_u== true)
	{
		throw new Exception("<customerror>user-deleted</customerror>");
	}
	else if (u_v_till < l_accessed)
	{
		throw new Exception("<customerror>user-timedout</customerror>");
	}
	else
	{
		if(request.getQueryString()!=null)
		{
			String Module_Name=request.getParameter("moduleName");
			if(Module_Name!=null && Module_Name.equalsIgnoreCase("ADMIN"))
			{
				String strQueryURI = request.getRequestURI();
				String strQueryString = request.getQueryString();
				if ((strQueryURI.indexOf("/EgNotificationManagerJson.jsp") == -1) && 
					(strQueryURI.indexOf("/EgDashboardAlertsJson.jsp") == -1))
				{
					session.setAttribute("Page_IdentifierA",strQueryURI+"?"+strQueryString);
				}
			}
			else if(Module_Name!=null && Module_Name.equalsIgnoreCase("MONITOR"))
			{
				session.setAttribute("Page_IdentifierM",request.getRequestURI()+"?"+request.getQueryString());
			}
			else if(Module_Name!=null && Module_Name.equalsIgnoreCase("REPORTER"))
			{
				session.setAttribute("Page_IdentifierM",request.getRequestURI()+"?"+request.getQueryString());
			}
			else if(Module_Name!=null && Module_Name.equalsIgnoreCase("CONFIGURATION"))
			{
				session.setAttribute("Page_IdentifierC",request.getRequestURI()+"?"+request.getQueryString());
			}
			else
			{
				String strQueryURI = request.getRequestURI();
				String strQueryString = request.getQueryString();
				if ((strQueryURI.indexOf("/EgNotificationManagerJson.jsp") == -1) && 
					(strQueryURI.indexOf("/EgDashboardAlertsJson.jsp") == -1) &&
					(strQueryURI.indexOf("/uploadWrapperJSONp.jsp") == -1))
				{
					session.setAttribute("Page_IdentifierA",strQueryURI+"?"+strQueryString);
				}
			}
		}
		else
		{
			String strQueryURI = request.getRequestURI();
			String strQueryString = request.getQueryString();
			if ((strQueryURI.indexOf("/EgNotificationManagerJson.jsp") == -1) && 
				(strQueryURI.indexOf("/EgDashboardAlertsJson.jsp") == -1) && 
				(strQueryURI.indexOf("/EgTimeBarJson.jsp") == -1) && 
				(strQueryURI.indexOf("/uploadWrapperJSONp.jsp") == -1))
			{
				session.setAttribute("Page_IdentifierA",strQueryURI+"?"+strQueryString);
			}
		}
	}

	String imgName = "";
	if (_user!=null)
	{
		String trackerUserLang = _user.getLanguage();
		if (trackerUserLang!=null && !trackerUserLang.equalsIgnoreCase("NULL"))
		{
			trackerLanguage=trackerUserLang;
		}
		_user.setUserLanguageAndSkins();
		admin_Skin = _user.getAdminSkin();
		trackerUI.set_userLogo(_user.getUserLogo());
		trackerUI.set_loginID(_user.getLoginID());
		imgName = trackerUI.getReporterHomeLogo();
	}
	if(trackerUI.isHKTThemeEnabled())
	{
		imgName = trackerUI.getHKTReporterLogo();
	}

	String script_src = "script_item_"+trackerLanguage+".js";
	EgMappingInfo _mapping = new EgMappingInfo(trackerLanguage);

      out.write("\r\n\r\n");
      out.write("\r\n\r\n\r\n");
      out.write("\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n");

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

      out.write('\r');
      out.write('\n');
      out.write('\r');
      out.write('\n');

	EgRoleInfo roleInfo = EgRoleInfo.getInstance(sessionID,_user.getLoginID());
	EgUsersInfo usersInfo = new EgUsersInfo();
	boolean isUserBasedCert = false;
	if (usersInfo.getUserAllowedCount() > 0)
	{
		isUserBasedCert = true;
	}
	ArrayList noLiceList = EgInstallInfo.getCertCheckList();
	boolean agentsWithNoLicense = (noLiceList != null && noLiceList.size() > 0);
	JSONObject rootJSON = new JSONObject();
	JSONArray agentTypesAry = new JSONArray();
	for (int a=0; a<agentTypes.length; a++)
	{
		String agentType = agentTypes[a];
		if (!isUserBasedCert && agentType.equals(USER_COMP_AGENTS))
		{
			continue;
		}
		
		if (!agentsWithNoLicense && agentType.equals("Agents with no license"))
		{
			continue;
		}
		
		JSONObject obj = new JSONObject();
		obj.put("valueField",agentType);
		obj.put("displayField",_mapping.getTextDescription("admin.agents."+agentType));
		agentTypesAry.add(obj);
	}
	rootJSON.put("agentTypes",agentTypesAry);
	//For CSV
	List csvData = new ArrayList();

	boolean agentStatusLog = false;
	IniFile serviceIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
	String agentStLog = serviceIni.getValue("MISC_ARGS","AgentStatusLog"); 
	if(agentStLog != null && (agentStLog.equalsIgnoreCase("yes") || agentStLog.equalsIgnoreCase("true")))
	{
		agentStatusLog = true;
	}

	String start = request.getParameter("start");
	String pageLimit = request.getParameter("limit");
	String pageNo = request.getParameter("page");
	String filter = request.getParameter("filter");
	boolean isSearchEnable = false;
	String searchStr = "";

	if(!StringUtils.isNull(filter))
	{
		//JSONParser parser = new JSONParser();
		//JSONArray jsonArr = (JSONArray) parser.parse(filter);
		//JSONObject jsonObj = (JSONObject) jsonArr.get(0);
		//searchStr = jsonObj.get("value").toString();

		searchStr = StringUtils.decodeSecurityChar(filter);
		if ((!StringUtils.isNull(searchStr)))
		{
			isSearchEnable = true;
		}
	}

	int maxPageItems = 50;
	if (!StringUtils.isNull(pageLimit))
	{
		maxPageItems = Integer.parseInt(pageLimit);
	}

	csvData.add(_mapping.getTextDescription("admin.agents.Agents Status Report"));
	csvData.add("");

	String agentType = request.getParameter("agent"); // Agent Type
	if (StringUtils.isNull(agentType))
	{
		agentType = agentTypes[0];
	}
	rootJSON.put("agentType",agentType);
	String mappingType = _mapping.getTextDescription("admin.agents."+agentType);
	csvData.add(_mapping.getTextDescription("admin.agents.Agent type")+","+mappingType);
	JSONArray agentsSts = new JSONArray();
	for (int s=0;s<agentStatus.length;s++)
	{
		String status = agentStatus[s];
		JSONObject obj = new JSONObject();
		obj.put("valueField",status);
		obj.put("displayField",_mapping.getTextDescription("admin.agents."+status));
		agentsSts.add(obj);
	}
	rootJSON.put("agentStatus",agentsSts);

	String agentState=request.getParameter("status"); // Agent status
	if (StringUtils.isNull(agentState))
	{
		agentState = agentStatus[0];
	}
	rootJSON.put("agentState",agentState);

	String mappingStatus = _mapping.getTextDescription("admin.agents."+agentState);
	csvData.add(_mapping.getTextDescription("admin.agents.Agent status")+","+mappingStatus);
	csvData.add("");
	//Only when search option is enabled, 'hostname' & 'search'
	//will be obtained
	String hostname = request.getParameter("hostname");
	if(hostname == null)
		hostname = "";
	String search = request.getParameter("search");
	if(search == null)
		search = "false";

	rootJSON.put("hostname",hostname);
	rootJSON.put("search",search);
	EgLicenseInfo licInfo = new EgLicenseInfo();
	UserBean userBean = new UserBean();
	boolean hasAllCompAccess = roleInfo.hasAllComponentAccess(); // For Limited admin
	boolean isLimitedAdmin = !hasAllCompAccess;
	
	boolean isRCDashboardEnabled = true;
	if(isLimitedAdmin)
	{
		com.egurkha.EgUserPermission userPerm = com.egurkha.EgUserPermission.getInstance();
		isRCDashboardEnabled = userPerm.checkPermission("/monitor/ControlAgents.jsp","",_user.getUserRole());
	}

	EgServerList serverList = new EgServerList();
	int totalAgentCount = 0;
	if (hasAllCompAccess)
	{
		totalAgentCount = (licInfo.getExternalAgents()).size() + (licInfo.getBasicAgents()).size() + (licInfo.getPremiumAgents()).size() + (licInfo.getRemoteAgents()).size();
	}
	else
	{
		totalAgentCount = (roleInfo.getExternalAgents()).size() + (roleInfo.getBasicAgents()).size() + (roleInfo.getPremiumAgents()).size() + (roleInfo.getRemoteAgents()).size();
	}
	rootJSON.put("totalAgentCount",totalAgentCount);

	ArrayList agentList = new ArrayList();
	ArrayList sharedAgents = new ArrayList();
	ArrayList allAgents = roleInfo.getTotalAgents();
	ArrayList srchTokens = new ArrayList();
	ArrayList noLicenseAgentList = userBean.getAgentsWithNoLicense();

	if(agentType.equalsIgnoreCase("ExternalAgents"))
	{
			agentList = hasAllCompAccess ? licInfo.getExternalAgents() : roleInfo.getExternalAgents();
	}
	else if(agentType.equalsIgnoreCase("BasicAgents"))
	{
		agentList = hasAllCompAccess ? licInfo.getBasicAgents() : roleInfo.getBasicAgents();
	}
	else if(agentType.equalsIgnoreCase("PremiumAgents"))
	{
		agentList = hasAllCompAccess ? userBean.getPremiumAgents() : roleInfo.getPremiumAgents();
	}
	else if(agentType.equalsIgnoreCase("RemoteAgents"))
	{
		agentList = hasAllCompAccess ? licInfo.getRemoteAgents() : roleInfo.getRemoteAgents();
	}
	else if (agentType.equalsIgnoreCase(USER_COMP_AGENTS))
	{
		agentList = hasAllCompAccess ? userBean.getPremiumAgents(true) : roleInfo.getPremiumAgents(true);
		if (noLicenseAgentList != null && noLicenseAgentList.size() > 0)
		{
			agentList.removeAll(noLicenseAgentList);
		}
		ArrayList basicAgentList = hasAllCompAccess ? licInfo.getBasicAgents() : roleInfo.getBasicAgents();
		if (basicAgentList != null && basicAgentList.size() > 0)
		{
			agentList.removeAll(basicAgentList);
		}
	}
	else if (agentType.equalsIgnoreCase("Agents with no license"))
	{
		if(hasAllCompAccess)
		{
			agentList.addAll(noLicenseAgentList);
		}
		else
		{
			ArrayList tmpListCertCheckList = EgInstallInfo.getCertCheckList();
			ArrayList noLicenseComTypes  = new ArrayList();
			if (tmpListCertCheckList != null)
			{
				int size = tmpListCertCheckList.size();
				for (int t=0; t<size; t++)
				{
					String compType = (String)tmpListCertCheckList.get(t);
					compType = EgCrypt.decrypt(compType);
					noLicenseComTypes.add(compType);
				}
			}

			ArrayList allServersList = roleInfo.getAllServers();
			int allServerListSize = allServersList.size();
			for(int i = 0; i<allServerListSize; i++)
			{
				String temp = (String)allServersList.get(i);
				int cmpInd = temp.indexOf(":");
				String s_compType = temp.substring(0,cmpInd);
				if(noLicenseComTypes.contains(s_compType))
				{
					temp = temp.substring(cmpInd+1);
					String s_compNick = temp.substring(0,temp.indexOf(":"));
					agentList.add(s_compNick);
				}
			}
			agentList.retainAll(noLicenseAgentList);
		}
	}

	if(search.equals("true"))
	{
		StringTokenizer st1 = new StringTokenizer(hostname);
		while (st1.hasMoreTokens())
		{
			String Token = st1.nextToken().trim();
			if (Token.equals("") || Token.length() == 0)
				continue;
			srchTokens.add(Token);
		}
	}

	int eventCount = 0;
	int offsetCount = 0;

	List csvAssignHosts = new ArrayList();
	if(agentList == null || agentList.size() == 0)
	{
		rootJSON.put("noManagedHostsFound",true);
		csvData.add("-No Agents Found-");
	}
	else
	{
		ArrayList aList = serverList.getAgentListFromDB();
		String currList[] = serverList.getTargetNames();
		Map allAgentsMap = serverList.getAgentList(agentList,aList,currList,agentState);
		agentList = new ArrayList(allAgentsMap.keySet());
		eventCount = agentList.size();
		rootJSON.put("totalProperty",eventCount);
		rootJSON.put("selectedUserCount",eventCount);

		boolean isNickShared = false;
		if(agentType.equalsIgnoreCase("ExternalAgents"))
		{
			sharedAgents = getUsersSharedAgents(agentList,roleInfo,true,false);
		}
		else if(agentType.equalsIgnoreCase("RemoteAgents"))
		{
			sharedAgents = getUsersSharedAgents(agentList,roleInfo,false,true);
		}
		else
		{
			sharedAgents = getUsersSharedAgents(agentList,roleInfo,false,false);
		}

		if(isLimitedAdmin && sharedAgents != null && sharedAgents.size() > 0)
		{
			isNickShared = true;
		}
		boolean autoIpNameCheck = (new EgServicesInfo("manager")).autoIpNameCheck();
		ArrayList allCompNicks = roleInfo.getAllServerNicks(); // For Limited admin
		EgDiscInfo discInfo = new EgDiscInfo("manager");
		Set dockerList = new TreeSet();
		String docker[] = discInfo.getAllServersOfType("Docker_server",true);
		if(docker != null)
		{
			int icount=docker.length;
			for(int i=0;i<icount;i++)
			{
				String dock = docker[i];
				dock = dock.substring(dock.indexOf(":")+1,dock.lastIndexOf(":"));
				dockerList.add(dock);
			}
		}
		Hashtable nick_ip_map = discInfo.getNickIpMap();
		if(nick_ip_map == null)
		{
			nick_ip_map = new Hashtable();
		}

		Hashtable debug_status = getAgentDebug("AGENT_OUTPUT_STATUS");
		Vector compNickList = disableIPList();
		JSONArray disabledIpObj = new JSONArray();
		for(int i=0;i<compNickList.size();i++)
		{
			String nick = (String)compNickList.get(i);
			disabledIpObj.add(nick);
		}
		rootJSON.put("disabledIpList",disabledIpObj);

		if (isSearchEnable)
		{
			agentList = getSearchData(agentList,searchStr,true);
			rootJSON.put("totalProperty",agentList.size());
		}

		csvData.add(_mapping.getTextDescription("admin.agents.Total number of agents")+","+agentList.size());
		csvData.add("");

		ArrayList dataForCsv = new ArrayList();
		dataForCsv.addAll(agentList);
		ArrayList csvList = getCSVData(allAgentsMap, allCompNicks, agentType, _mapping, nick_ip_map, debug_status,compNickList,autoIpNameCheck);
		if (csvList != null && csvList.size() > 0)
		{
			csvData.addAll(csvList);
		}

		JSONArray agentsDetails = new JSONArray();
		if(!allAgentsMap.isEmpty())
		{
			ArrayList containerAgentsNick = new ArrayList();
			IniFile inifile = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_containerapps.ini");
			if(inifile != null)
			{
				String contApps[]=inifile.getVariables("Container_Applications");
				if(contApps != null)
				{
					int caCount=contApps.length;
					for(int i=0;i<caCount;i++)
					{
						String caNick=contApps[i];
						caNick=caNick.substring(caNick.indexOf(":")+1);
						caNick=caNick.substring(caNick.indexOf("_")+1);
						caNick=caNick.substring(0,caNick.indexOf(":"));
						containerAgentsNick.add(caNick);
					}
				}
			}
			inifile=null;
			if(agentType.equalsIgnoreCase(USER_COMP_AGENTS))
			{
				Hashtable dummyHt = new Hashtable();
				Hashtable hostnames = new com.egurkha.admin.WVDHostnames().getWVDHostnames();
				Set keys=hostnames.keySet();
				if(!keys.isEmpty())
				{
					Iterator hitr=keys.iterator();
					while(hitr.hasNext())
					{
						String key=(String)hitr.next();
						ArrayList alist = (ArrayList)hostnames.get(key);
						if(allAgentsMap.containsKey(key))
						{
							String val=(String)allAgentsMap.remove(key);
							if(alist != null)
							{
								for(int n=0;n<alist.size();n++)
								{
									String host_name=(String)alist.get(n);
									dummyHt.put(key+" - "+host_name+"",val);
								}
							}
						}
					}
				}
				if(!dummyHt.isEmpty())
				{
					allAgentsMap.putAll(dummyHt);
				}
			}
			boolean proceed = false;
			boolean isAssignedHostShared = false;
			boolean setDisableOutputLogging = false;
			//To display Total Number of Agents in Agent Status Page.
			rootJSON.put("totalNoAgent",allAgentsMap.size());

			String agentIPNick = _mapping.getTextDescription("admin.agents.Agent IP/Nickname");
			String install = _mapping.getTextDescription("admin.agents.Installed");
			String status = _mapping.getTextDescription("admin.agents.Status");
			String outputEnabled = _mapping.getTextDescription("admin.agents.Output Logging Enabled");
			//csvData.add(agentIPNick+","+install+","+status+","+outputEnabled);
			rootJSON.put("enableSearch",true);
			rootJSON.put("managedHostsFoundForSearch",true);
			boolean showMonitorRC=com.eg.EgMemInfo.remoteEnabled && _user.getLoginRCEnabled();
			rootJSON.put("showMonitorRC",showMonitorRC);
			
			Object selectedAgentObj=session.getAttribute("RC_AgentID");
			String selectedAgentId=null;
			if(selectedAgentObj != null)
			{
				selectedAgentId=(String)selectedAgentObj;
			}
			Iterator itr = allAgentsMap.keySet().iterator();
			while(itr.hasNext())
			{
				String agentIP = (String)itr.next();
				String agent_state = (String)allAgentsMap.get(agentIP);
				String installed = agent_state.substring(0,agent_state.indexOf("-"));
				String running = agent_state.substring(agent_state.indexOf("-")+1);
				boolean showDebugInfo=false;
				if(selectedAgentId != null && selectedAgentId.equalsIgnoreCase(agentIP))
				{
					showDebugInfo=true;
					if(agentStatusLog)
					{
						logToErrorFile("EgServerListJson agentIP is " + agentIP);
						logToErrorFile("EgServerListJson agent_state is " + agent_state);
						logToErrorFile("EgServerListJson installed is " + installed);
						logToErrorFile("EgServerListJson running is " + running);
					}
				}
				showDebugInfo = showDebugInfo && agentStatusLog;
				JSONObject obj = new JSONObject();
				if(agentType.equalsIgnoreCase("ExternalAgents"))
				{
					EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
					ArrayList internalTestsAloneNicks = egSpecs.getInternalTestsAloneCompNicks();
					allCompNicks.removeAll(internalTestsAloneNicks);
					String hosts = getAssignedHostsForExternalAgent(agentIP,allCompNicks);
					if(hosts.trim().equals(""))
					{
						hosts = "- No assigned hosts found -";
					}
					else
					{
						isAssignedHostShared = isAssignedHostShared(isNickShared,sharedAgents,hosts);
					}
					obj.put("AssignedHosts",hosts);
					//csvAssignHosts.add(agentIP+"#@#"+hosts);
				}
				else if (agentType.equalsIgnoreCase("RemoteAgents"))
				{
					String hosts = getAssignedHostsForRemoteAgent(agentIP,allCompNicks);
					if(hosts.trim().equals(""))
					{
						hosts = "- No assigned hosts found -";
					}
					else
					{
						isAssignedHostShared = isAssignedHostShared(isNickShared,sharedAgents,hosts);
					}
					obj.put("AssignedHosts",hosts);
					//csvAssignHosts.add(agentIP+"#@#"+hosts);
				}

				if(isNickShared && (sharedAgents.contains(agentIP) || isAssignedHostShared))
				{
					proceed = true;
				}
				else
				{
					proceed = false;
				}

				String restartFlg = "No";
				if(installed != null && (installed.equals("Not Installed") || running.equals("Not Running")))
				{
					restartFlg = "No";
				}
				else
				{
					if(proceed)
						restartFlg = "No";
					else
						restartFlg = "Yes";
				}
				//String onSelected="";
				//String offSelected="";
				boolean output = false;
				String agent_ip_address=null;
				String agent_ip_address_arr[]=null;
				String debugStatus=null;
				if(showDebugInfo)
				{
					logToErrorFile("EgServerListJson autoIpNameCheck is " + autoIpNameCheck);
					logToErrorFile("EgServerListJson nick_ip_map is " + nick_ip_map);
				}
				if(nick_ip_map.containsKey(agentIP))
				{
					agent_ip_address = (String)nick_ip_map.get(agentIP);
					if(showDebugInfo)
					{
						logToErrorFile("EgServerListJson agent_ip_address is " + agent_ip_address + " for agentIP " + agentIP);
					}
					if(agent_ip_address != null)
					{
						agent_ip_address_arr = StringUtils.getTokens(agent_ip_address,":");
					}
				}
				else if(showDebugInfo)
				{
					logToErrorFile("EgServerListJson could not find agent_ip_address (???) for agentIP " + agentIP);
				}
				boolean statusNotFound=true;
				if(autoIpNameCheck)
				{
					if(showDebugInfo)
					{
						logToErrorFile("EgServerListJson autoIpNameCheck is " + autoIpNameCheck);
						logToErrorFile("EgServerListJson agent_ip_address is " + agent_ip_address);
					}
					if(agent_ip_address_arr != null)
					{
						int ipsCount=agent_ip_address_arr.length;
						for(int j=0;j<ipsCount;j++)
						{
							agent_ip_address=agent_ip_address_arr[j];
							if(debug_status.containsKey(agent_ip_address))
							{
								debugStatus = (String)debug_status.get(agent_ip_address);
								statusNotFound=false;
								if(showDebugInfo)
								{
									logToErrorFile("EgServerListJson debug_status for agent_ip_address is " + agent_ip_address + " " + debugStatus);
								}
								break;
							}
							else if(debug_status.containsKey(agent_ip_address.toUpperCase()))
							{
								debugStatus = (String)debug_status.get(agent_ip_address.toUpperCase());
								statusNotFound=false;
								if(showDebugInfo)
								{
									logToErrorFile("EgServerListJson debug_status for agent_ip_address.toUpperCase() is " + agent_ip_address.toUpperCase() + " " + debugStatus);
								}
								break;
							}
							else if(debug_status.containsKey(agent_ip_address.toLowerCase()))
							{
								debugStatus = (String)debug_status.get(agent_ip_address.toLowerCase());
								statusNotFound=false;
								if(showDebugInfo)
								{
									logToErrorFile("EgServerListJson debug_status for agent_ip_address.toLowerCase() is " + agent_ip_address.toLowerCase() + " " + debugStatus);
								}
								break;
							}
							else if(compNickList != null && (compNickList.contains(agentIP) || compNickList.contains(agentIP.toLowerCase()) || compNickList.contains(agentIP.toUpperCase())))
							{
								debugStatus = "yes";
								statusNotFound=false;
								if(showDebugInfo)
								{
									if(agentStatusLog)
									{
										logToErrorFile("EgServerListJson compNickList(1) is " + compNickList);
									}
									if(compNickList.contains(agentIP))
									{
										if(agentStatusLog)
										{
											logToErrorFile("EgServerListJson debug_status for compNickList.contains(agentIP) is " + debugStatus);
										}
									}
									else if(compNickList.contains(agentIP))
									{
										if(agentStatusLog)
										{
											logToErrorFile("EgServerListJson debug_status for compNickList.contains(agentIP.toLowerCase()) is " + debugStatus);
										}
									}
									else if(compNickList.contains(agentIP))
									{
										if(agentStatusLog)
										{
											logToErrorFile("EgServerListJson debug_status for compNickList.contains(agentIP.toUpperCase()) is " + debugStatus);
										}
									}
								}
								break;
							}
						}
					}
					else
					{
						int wvd_idx = agentIP.indexOf(" - ");
						if(wvd_idx>0)
						{
							String wvdHostname=agentIP.substring(wvd_idx+3);
							debugStatus = (String)debug_status.get(wvdHostname);
							statusNotFound=false;
							if(showDebugInfo)
							{
								logToErrorFile("EgServerListJson debug_status for wvd hostname is " + wvdHostname + " " + debugStatus);
							}
						}
					}
					if(statusNotFound)
					{
						String agent_IPAddress =(String)nick_ip_map.get(agentIP);
						if (agent_IPAddress != null && debug_status.containsKey(agent_IPAddress))
						{
							statusNotFound = false;
							debugStatus = (String)debug_status.get(agent_IPAddress);
							if(showDebugInfo)
							{
								logToErrorFile("EgServerListJson statusNotFound debug_status for agent_IPAddress " + agent_IPAddress + " is " + debugStatus);
							}
						}
					}
					if(statusNotFound)
					{
						String agent_IPAddress =(String)nick_ip_map.get(agentIP);
						if (agent_IPAddress != null)
						{
							if(debug_status.containsKey(agent_IPAddress))
							{
								statusNotFound = false;
								debugStatus = (String)debug_status.get(agent_IPAddress);
								if(showDebugInfo)
								{
									logToErrorFile("EgServerListJson statusNotFound debug_status for agent_IPAddress is " + agent_IPAddress + " is " + debugStatus);
								}
							}
							else if(debug_status.containsKey(agent_IPAddress.toUpperCase()))
							{
								statusNotFound = false;
								debugStatus = (String)debug_status.get(agent_IPAddress.toUpperCase());
								if(showDebugInfo)
								{
									logToErrorFile("EgServerListJson statusNotFound debug_status for agent_IPAddress.toUpperCase() is " + agent_IPAddress.toUpperCase() + " is " + debugStatus);
								}
							}
							else if(debug_status.containsKey(agent_IPAddress.toLowerCase()))
							{
								statusNotFound = false;
								debugStatus = (String)debug_status.get(agent_IPAddress.toLowerCase());
								if(showDebugInfo)
								{
									logToErrorFile("EgServerListJson statusNotFound debug_status for agent_IPAddress.toLowerCase() is " + agent_IPAddress.toLowerCase() + " is " + debugStatus);
								}
							}
						}
					}
				}
				if(statusNotFound)
				{
					if(agentIP != null && debug_status.containsKey(agentIP))
					{
						debugStatus = (String)debug_status.get(agentIP);
						if(showDebugInfo)
						{
							logToErrorFile("EgServerListJson statusNotFound debug_status for agentIP " + agentIP + " is " + debugStatus);
						}
					}
					else if(agentIP != null && debug_status.containsKey(agentIP.toUpperCase()))
					{
						debugStatus = (String)debug_status.get(agentIP.toUpperCase());
						if(showDebugInfo)
						{
							logToErrorFile("EgServerListJson statusNotFound debug_status for agentIP.toUpperCase() " + agentIP.toUpperCase() + " is " + debugStatus);
						}
					}
					else if(compNickList != null && (compNickList.contains(agentIP) || compNickList.contains(agentIP.toLowerCase()) || compNickList.contains(agentIP.toUpperCase())))
					{
						debugStatus = "yes";
						if(showDebugInfo)
						{
							if(agentStatusLog)
							{
								logToErrorFile("EgServerListJson compNickList(2) is " + compNickList);
							}
							if(compNickList.contains(agentIP))
							{
								if(agentStatusLog)
								{
									logToErrorFile("EgServerListJson statusNotFound debug_status for compNickList.contains(agentIP) is " + debugStatus);
								}
							}
							else if(compNickList.contains(agentIP.toLowerCase()))
							{
								if(agentStatusLog)
								{
									logToErrorFile("EgServerListJson statusNotFound debug_status for compNickList.contains(agentIP.toLowerCase()) is " + debugStatus);
								}
							}
							else if(compNickList.contains(agentIP.toUpperCase()))
							{
								if(agentStatusLog)
								{
									logToErrorFile("EgServerListJson statusNotFound debug_status for compNickList.contains(agentIP.toUpperCase()) is " + debugStatus);
								}
							}
						}
					}
				}
				if(debugStatus != null && debugStatus.equalsIgnoreCase("yes"))
				{
					//onSelected = "selected";
					//offSelected = "";
					output=true;
				}
				else
				{
					//onSelected = "";
					//offSelected = "selected";
					output=false;
				}//AgentIP/Nickname-Installed-Status-Output-Restart-Logs

				if(showDebugInfo)
				{
					logToErrorFile("EgServerListJson OUTPUT is " + output + " and AGENT IP is " + agentIP);
					logToErrorFile("");
				}
				String tempInstalled = "Yes";
				if (installed.equalsIgnoreCase("Not Installed"))
				{
					tempInstalled = "No";
				}
				if(containerAgentsNick.contains(agentIP))
				{
					restartFlg = "No";
					setDisableOutputLogging = true;
				}
				else if (tempInstalled.equalsIgnoreCase("No") && running.equalsIgnoreCase("Not Running"))
				{
					setDisableOutputLogging = true;
				}
				else if(tempInstalled.equalsIgnoreCase("Yes") && running.equalsIgnoreCase("Running"))
				{
					if(proceed)
						setDisableOutputLogging = true;
					else
						setDisableOutputLogging = false;
				}
				obj.put("AgentIP",agentIP+'~'+tempInstalled);
				obj.put("Installed",tempInstalled);
				obj.put("Status",running);
				obj.put("Output",output);
				obj.put("Restart",restartFlg+"~"+agentIP);
				String csvOutput = "No";
				if (output)
					csvOutput = "Yes";
				String installMapping = _mapping.getTextDescription("admin.common."+tempInstalled);
				String runMapping = _mapping.getTextDescription("admin.agents."+running);
				String outputMapping = _mapping.getTextDescription("admin.common."+csvOutput);
				//csvData.add(agentIP+","+installMapping+","+runMapping+","+outputMapping);
				if(containerAgentsNick.contains(agentIP))
				{
					obj.put("Logs","DoNotShow");
					obj.put("Xmx","DoNotShow");
				}
				else if(installed.equalsIgnoreCase("Not Installed") || running.equalsIgnoreCase("Not Running") || containerAgentsNick.contains(agentIP))
				{
					obj.put("Logs","DoNotShow");
					obj.put("Xmx","DoNotShow");
				}
				else
				{
					if(proceed)
					{
						obj.put("Logs","DoNotShow");
						obj.put("Xmx","DoNotShow");
					}
					else
					{
						obj.put("Logs","Show");
						if(dockerList.contains(agentIP))
						{
							obj.put("Xmx","DoNotShow");
						}
						else
						{
							obj.put("Xmx","Show");
						}
					}
				}
				obj.put("StopAgent",restartFlg+"~"+agentIP);
				obj.put("isAgentShared",proceed+"~"+setDisableOutputLogging);
				if(containerAgentsNick.contains(agentIP))
				{
					obj.put("RemoteControl","no~"+agentIP+"~no");
				}
				else if (showMonitorRC && isRCDashboardEnabled)
				{
					/*String s_mode = com.egurkha.monitor.remotecontrol.PreAgentInfo.getAgentMode(agentIP);
					if(s_mode.equalsIgnoreCase("CRITICAL_MODE"))
					{
						s_mode="Critical";
					}
					else if(s_mode.equalsIgnoreCase("WAITING_MODE"))
					{
						s_mode="Waiting";
					}
					else
					{
						s_mode="Normal";
					}*/
					//obj.put("RemoteControl",restartFlg+"~"+agentIP+"~"+s_mode);
					obj.put("RemoteControl",restartFlg+"~"+agentIP+"~Normal");
				}
				else
				{
					obj.put("RemoteControl","no~"+agentIP+"~no");
				}
				if(agent_ip_address == null)
				{
					obj.put("IP_Address","");
				}
				else
				{
					obj.put("IP_Address",agent_ip_address);
				}
				agentsDetails.add(obj);
			}
		}
		else
		{
			rootJSON.put("enableSearch",false);
			rootJSON.put("managedHostsFoundForSearch",false);
		}
		rootJSON.put("agentDetails",agentsDetails);
	}

	session.setAttribute("list",csvData);
	session.setAttribute("isAuditlogCSV","true");
	out.println(rootJSON);

      out.write('\r');
      out.write('\n');
      out.write("\r\n\r\n\r\n\r\n\r\n");
    } catch (java.lang.Throwable t) {
      if (!(t instanceof jakarta.servlet.jsp.SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try {
            if (response.isCommitted()) {
              out.flush();
            } else {
              out.clearBuffer();
            }
          } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
        else throw new ServletException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
