<%
/*******************************************************************************
*	File name			:	ErVDIResourceUsageJson.jsp
*	Purpose				:	Main Page For Virtual Desktop Insight - VDI Assessment Resource								Usage
*	Author				:	A.MuraliKanth
*	Creation Date		:	27/11/2012 - (dd/mm/yyyy)
********************************************************************************/
%>
<%@ include file="ErReporterTracker.jsp" %>
<%@ page import = "com.eg.EgServicesInfo" %>
<%@ page import = "com.eg.EgReportInfo"%>
<%@ page import = "com.eg.EgTestInfo"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "com.eg.EgDateInfo" %>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import = "egurkha.reporter.*" %>
<%@ page import = "egurkha.reporter.*" %>
<%@ page import = "java.net.URLEncoder" %>
<%@ page import="net.sf.json.*"%>
<%@ page import = "com.eg.EgMappingInfo" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%
	try
	{

	EgMappingInfo intlmp=new EgMappingInfo(thisuser.getLanguage());	
	response.setContentType("application/json");

	JSONObject json = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject hiddenFields=new JSONObject();

	String er_bgreportfrom = "VDIAssessment_Resource_Usage";
	String subject="Desktop_Insight_Resource_Usage";
	String subForChart="Desktop_Insight_Resource_Usage_Chart_Details";
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
	String thisLanguage="";
	ErEsxVMutils erEsxUtils = new ErEsxVMutils();
	if (thisuser != null)
	{
		erEsxUtils.setUser(thisuser);
		String userLang = thisuser.getLanguage();
		if (userLang != null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage = userLang;
		}
	}
	/** result data getting starts **/
	HashMap chartAttributeMaps=(HashMap)session.getAttribute("chartMaps");
	ArrayList DataAvailableMeasureGroup=(ArrayList)session.getAttribute("DataAvailableMeasureGroup");
	HashMap backreqMap = (HashMap)session.getAttribute("backQuery");
	/**ends **/
	EgServicesInfo serviceInfo = new EgServicesInfo("manager");
	EgReportInfo reportInfo = new EgReportInfo("manager");
	EgTestInfo testInfo = new EgTestInfo("manager");
	EgDateInfo dateInfo = new EgDateInfo();
	EgDateInfo egDt = new EgDateInfo();
	MappingNameSorter sorter = new MappingNameSorter(thisLanguage);
	ErUtils erUtils = new ErUtils();	
	ErInfo erInfo = new ErInfo(true);
	ErHelperUtils erhelputils = null;
	ErReportHelper er_helper = new ErReportHelper();
	ErComponentsUtils compUtils=new ErComponentsUtils(thisuser.getEncodedLoginID());
	Hashtable allUnManagedComp = compUtils.getUserUnManagedComponents();
	Hashtable allUserUnManagedComponent_Type = compUtils.getUserUnManagedComponent_Type();
	ErFusionChartBean fusionChartBean=new ErFusionChartBean();
	IniUI ui = IniUI.getInstance();
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String selectedDateFormat=egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	String currentDateFormat = strUserDateFormat;
	String confrimation = reportInfo.getValue("BACKGROUND_PROCESS","NeedConfirmation");
	String isbgEnabled = reportInfo.getValue("BACKGROUND_PROCESS","EnableBackgroundReport");
	String limitforbg = reportInfo.getValue("BACKGROUND_PROCESS","MinDurationForReport");
	String[] options= new String[]{"Any","1 hour", "3 hours", "6 hours", "9 hours", "12 hours", "15 hours", "18 hours", "21 hours","1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks","3 weeks","4 weeks","1 month"};

	HashMap mappedtimeline = erEsxUtils.getTimeline();
	HashMap FushionchartAttributes=new HashMap();
	Map reqParamMap = new HashMap(request.getParameterMap());
	Vector v_time = (Vector)mappedtimeline.get("timehour");
	Vector v_min = (Vector)mappedtimeline.get("timemin");
	Vector v_compList=new Vector();
	ArrayList arr_supportedcompTypes=reportInfo.getComponent(subject,false);
	ArrayList arr_groups=new ArrayList();
	ArrayList arr_compTypes=new ArrayList();
	ArrayList arr_relativeCompTypes=new ArrayList();
	ArrayList arr_compTypes_sorted=new ArrayList();
	ArrayList arr_listelements=new ArrayList();
	ArrayList arr_selectedComponents=new ArrayList();
	ArrayList arr_compList=new ArrayList();
	ArrayList colorList=new ArrayList();
	ArrayList labelList=new ArrayList();
	ArrayList listbackvar = new  ArrayList();
	List allUserCompTypes = compUtils.getAllComponentType();

	String bggroundStr = (String)request.getAttribute("bggroundStr");
	String status = (String)request.getAttribute("status");

	String s_reporttype=request.getParameter("reporttype");
	String s_subtype=request.getParameter("subtype");
	String s_compType=request.getParameter("er_componentType");
	String s_group=request.getParameter("er_group");
	String s_group_name=request.getParameter("group_name");
	String s_view=request.getParameter("er_view");
	String analyseDataBy=request.getParameter("analyseDataBy");
	String[] selected_Components=request.getParameterValues("er_component");
	String[] er_poolType=request.getParameterValues("er_poolType");
	String needToSelectAllServ=request.getParameter("SelectedAllComp");
	String includeSubZone=request.getParameter("includeSubZone");
	String chartMode=request.getParameter("er_mode");
	String hasFormSubmitted=request.getParameter("isSubmit");
	String schedule_id = request.getParameter("schedule_id");
	String reqFromSchedule = request.getParameter("fromSchedule");
	String fromScheduleModify = request.getParameter("fromScheduleModify");
	String fromFavoriteModify = request.getParameter("fromFavoriteModify");
	String favorite_id = request.getParameter("id");
	String er_favorite = request.getParameter("er_favorite");
	String excludeweekend = request.getParameter("er_excwe");
	
	String er_timeline = request.getParameter("er_timeline");
	String s_st_time = request.getParameter("startdate");
	String s_en_time = request.getParameter("enddate");
	String s_st_hr = request.getParameter("starthr");
	String s_en_hr = request.getParameter("endhr");
	String strmin = request.getParameter("startmin");
	String enmin  = request.getParameter("endmin");
	String Hourfrom = request.getParameter("timefrom");
	String Minfrom = request.getParameter("minfrom");
	String Hourto = request.getParameter("timeto");
	String Minto = request.getParameter("minto");

	String backQnumber = request.getParameter("backQnumber");
	String servlet2 = request.getParameter("backServletName");
	String onlyCompType = request.getParameter("onlyCompType");
	boolean enableBack=false;
	String trendTimeLine="No";
	String dispDate = null;
	String comFormat  = null;
	String stsec = "";
	String ensec = "";
	String str_selected="";
	String startDate="";
	String endDate="";
	String disable="";
	String printQueryString="";
	String encodedQueryString="";
	String QStringForBackButton="";
	String strAutoRangeCount="";
	int rangeDivided = 4;
	strAutoRangeCount=reportInfo.getValue(subject,"AutoRangeCount");
	try
	{
		rangeDivided = Integer.parseInt(strAutoRangeCount);
	}
	catch(Exception e){}

	//prakash
	String colorScheme=reportInfo.getValue(subject,"ChartColor");
	if(rangeDivided<=4)
	{
		colorScheme=reportInfo.getValue(subject,"PieChartColorScheme");
	}
	StringTokenizer st_color=new StringTokenizer(colorScheme,",");

	//BACK button starts
	if( servlet2!=null && !servlet2.equals(""))
		erhelputils = new ErHelperUtils(backreqMap,backQnumber,servlet2);
	else
		erhelputils = new ErHelperUtils(backreqMap,backQnumber);
	enableBack=erhelputils.isBackButtonEnable();
	json.put("ID","backQnumber="+erhelputils.getBackID()+"&"+erhelputils.getQueryString());
	//Back Button - End

	arr_groups=erEsxUtils.getVmGroups("All ComponentTypes",subject,thisuser,onlyCompType);
	Collections.sort(arr_groups,String.CASE_INSENSITIVE_ORDER);
	if(s_group==null &&(arr_groups!=null && arr_groups.size()>0))
	{
		s_group=(String)arr_groups.get(0);
	}
	if(includeSubZone==null)
	{
		includeSubZone="Yes";
	}
	if (excludeweekend==null || excludeweekend.equals(""))
		excludeweekend="No";
	String Days = "";
	String MappedExcludeDays=(er_helper.getExcludeWeekends("EXCLUDE_WEEKEND","Days")==null) ? "Saturday,Sunday" :er_helper.getExcludeWeekends("EXCLUDE_WEEKEND","Days");
	if("Yes".equalsIgnoreCase(excludeweekend))
		Days=(er_helper.getExcludeWeekends("EXCLUDE_WEEKEND","Days")==null) ? "Saturday,Sunday" :er_helper.getExcludeWeekends("EXCLUDE_WEEKEND","Days");
	else
		Days="No";
	request.setAttribute("Weekends",Days);
	if(er_timeline == null  || er_timeline.equals(" ")|| er_timeline.equals(""))
	{
		er_timeline="1 day";
	}
	if(Hourfrom==null && Minfrom==null && Hourto==null && Hourto==null)
	{
		String defaultFromTime = reportInfo.getTimeFrame(subject,"FROM");
		String defaultToTime = reportInfo.getTimeFrame(subject,"TO");
		StringTokenizer st = new StringTokenizer(defaultFromTime,":");
		if(st.hasMoreTokens())
		{
			Hourfrom = st.nextToken();
			Minfrom = st.nextToken();
		}
		st=new StringTokenizer(defaultToTime,":");
		if(st.hasMoreTokens())
		{
			Hourto = st.nextToken();
			Minto = st.nextToken();
		}
	}
	if(onlyCompType!=null && !onlyCompType.equalsIgnoreCase("null") && !onlyCompType.equalsIgnoreCase("undefined"))
	{
		ArrayList onlyCompTypeLst=erUtils.egTokenizer(onlyCompType, ",");
		if(onlyCompTypeLst != null && onlyCompTypeLst.size() > 0)
		{
			arr_supportedcompTypes=new ArrayList();
			allUserCompTypes=new ArrayList();
			arr_supportedcompTypes.addAll(onlyCompTypeLst);
			allUserCompTypes.addAll(onlyCompTypeLst);
		}
		hiddenFields.put("onlyCompType",onlyCompType);
	}
	else
	{
		String seperateMenuComps = reportInfo.getValue("MISC","SeperateMenuComponent");
		ArrayList seperateMenuCompsLst=erUtils.egTokenizer(seperateMenuComps, ",");
		if(seperateMenuCompsLst != null && seperateMenuCompsLst.size() > 0 && arr_supportedcompTypes != null && arr_supportedcompTypes.size() > 0)
		{
			for(int i=0;i<seperateMenuCompsLst.size();i++)
			{
				String eachComp = (String)seperateMenuCompsLst.get(i);
				if(arr_supportedcompTypes.contains(eachComp))
				{
					arr_supportedcompTypes.remove(eachComp);
				}
			}
		}
	}
	for(int j=0;arr_supportedcompTypes.size()>j;j++)
	{
		String cmptype_tmp=(String)arr_supportedcompTypes.get(j);
		if(allUserCompTypes.contains(cmptype_tmp))
		{
			arr_relativeCompTypes.add(cmptype_tmp);
		}
	}

	if(s_group!=null)
	{
		arr_listelements = erEsxUtils.getEsxElements(thisuser,"All ComponentTypes",s_group,true,subject,onlyCompType);
		if(!s_group.equalsIgnoreCase("Component"))
		{
			if(s_group!=null && s_group_name!=null && !s_group_name.equalsIgnoreCase("-1") )
			{
				arr_compList=erEsxUtils.getChosenGroupComponents(arr_relativeCompTypes,s_group_name,s_group,thisuser.getEncodedLoginID(),includeSubZone,new String[0]);
			}
		}
		else
		{
			arr_compList.addAll(arr_listelements);
		}
		if(s_group.equalsIgnoreCase("Service") || s_group.equalsIgnoreCase("Segment") || (s_group_name != null && s_group.equalsIgnoreCase("Zone") && s_group_name.equalsIgnoreCase("--Default--" )))
		{
				ArrayList arr_tmp=new ArrayList(arr_compList);
				arr_compList=new ArrayList();
				arr_compList.addAll(compUtils.getTypeModifyComponents(new Vector(arr_tmp),2));	
		}
	}

	Vector tmp_comptypes = compUtils.getComponentType(new Vector(arr_compList),1);
	for(int jk=0;arr_relativeCompTypes.size()>jk;jk++)
	{
		String Looptmp_type=(String)arr_relativeCompTypes.get(jk);
		if(tmp_comptypes.contains(Looptmp_type))
			arr_compTypes.add(Looptmp_type);
	}
	
	arr_compTypes_sorted=sorter.getSortedCompTypeList(arr_compTypes);
	if((s_compType==null || s_compType.equals(" ")|| s_compType.equals("")) && arr_compTypes.size()>0 )
	{
		
		s_compType=((EgName)arr_compTypes_sorted.get(0)).getActualName();
		
	}

	if(s_compType!=null && !s_compType.equalsIgnoreCase("all"))
	{
		arr_compList = compUtils.getServerForTypes(arr_compList,s_compType);
	}
	
	if(selected_Components!=null &&(needToSelectAllServ==null || !needToSelectAllServ.equals("yes")))
	{
		arr_selectedComponents=new ArrayList(Arrays.asList(selected_Components));
	}
	else
	{
		arr_selectedComponents=new ArrayList(arr_compList);
	}

	Collections.sort(arr_listelements,String.CASE_INSENSITIVE_ORDER);
	if(er_timeline.indexOf("days")>-1 || er_timeline.indexOf("week")>-1 || er_timeline.indexOf("month")>-1)
	{
		trendTimeLine="Yes";
	}
	
	if(er_timeline != null && !er_timeline.equals("Any"))
	{
		disable ="disabled";
		s_st_time = "";
		s_en_time = "";
		HashMap mapTimeLine = erEsxUtils.getDateTime(er_timeline,trendTimeLine);
 		startDate = (String)mapTimeLine.get("dbstartdate");
		endDate = (String)mapTimeLine.get("dbenddate");
		s_st_time = (String)mapTimeLine.get("calStartDate");
		s_en_time = (String)mapTimeLine.get("calEndDate");
		s_st_hr = (String)mapTimeLine.get("startHour");
		s_en_hr = (String)mapTimeLine.get("endHour");
		strmin = (String)mapTimeLine.get("startMin");
		enmin = (String)mapTimeLine.get("endMin");
		stsec = (String)mapTimeLine.get("startSec");
		ensec = (String)mapTimeLine.get("endSec");
		s_st_time = DateUtil.changeDateFormat(s_st_time,selectedDateFormat,"MM/dd/yyyy");
		s_en_time = DateUtil.changeDateFormat(s_en_time,selectedDateFormat,"MM/dd/yyyy");
	}
	else if(er_timeline != null && er_timeline.equals("Any"))
	{
		String StrDate = "";
		try
		{
			java.text.SimpleDateFormat df = new java.text.SimpleDateFormat("MM/dd/yyyy k 'at' hh:mm");
			 StrDate = df.format(dateInfo.egetRealDate());	
		}
		catch(Exception ee)
		{
			System.out.println("Exception is"+ee);
		}
		String SDate = StrDate.substring(0,StrDate.indexOf(" "));
		String shour = StrDate.substring(StrDate.indexOf(" "),StrDate.lastIndexOf(""));
		shour = shour.substring(0,3);
		if(s_st_time == null)
		{
			s_st_time = SDate;
		}
		if(s_en_time == null)
		{
			s_en_time = SDate;
		}
		if(s_st_hr == null)
		{
			shour =shour.trim();
			int starthr = Integer.parseInt(shour);
			starthr = starthr-1;
			s_st_hr = String.valueOf(starthr);
		}
		if(s_en_hr==null)
		{
			shour = shour.trim();
			s_en_hr =shour;
		}
		startDate = DateUtil.changeDateFormat(s_st_time.trim(),currentDateFormat,"dd-MM-yyyy");
		endDate = DateUtil.changeDateFormat(s_en_time.trim(),currentDateFormat,"dd-MM-yyyy");
	}
	while(st_color.hasMoreTokens())
	{
		String s_tok=st_color.nextToken();
		if(s_tok.indexOf(":")>-1)
		{
			String label=s_tok.substring(0,s_tok.indexOf(":"));
			String color=s_tok.substring(s_tok.indexOf(":")+1);
			colorList.add(color);
			labelList.add(label);
		}
		else
		{
			colorList.add(s_tok);	
		}
	}
	if(reqParamMap!=null)
	{
		Iterator reqParamMapItr=reqParamMap.keySet().iterator();
		while(reqParamMapItr.hasNext())
		{
			String value="";
			String reqKey=(String)reqParamMapItr.next();
			Object reqValue=reqParamMap.get(reqKey);
			if(reqKey!=null && reqKey.equals("er_component"))
			{
				if(reqValue instanceof String[])
				{
					String[] selectedComp=(String[])reqValue;
					for(int i=0;selectedComp.length>i;i++)
					{
						encodedQueryString+=reqKey+"="+EgURLEncoder.encode(selectedComp[i],"UTF-8")+"&";
						QStringForBackButton+=reqKey+"="+selectedComp[i]+"&";
					}
				}
				else
				{
					encodedQueryString+=reqKey+"="+EgURLEncoder.encode((String)reqValue,"UTF-8")+"&";
					QStringForBackButton+=reqKey+"="+reqValue+"&";
				}
				continue;
			}
			try
			{
				value=(String)reqValue;
			}
			catch(ClassCastException e)
			{
				value=((String[])reqValue)[0];
			}
			printQueryString+=reqKey+"="+URLEncoder.encode(value)+"&";
			encodedQueryString+=reqKey+"="+URLEncoder.encode(value)+"&";
			QStringForBackButton+=reqKey+"="+value+"&";
		}
	}

	hiddenFields.put("reporttype",s_reporttype);
	hiddenFields.put("subtype",s_subtype);
	hiddenFields.put("currentDateFormat",currentDateFormat);
	hiddenFields.put("inidate",currentDateFormat);
	hiddenFields.put("bgenabled",isbgEnabled);
	hiddenFields.put("limitforbg",limitforbg);
	//hiddenFields.put("startdate",s_st_time);
	hiddenFields.put("beanstartdate",startDate);
	hiddenFields.put("beanenddate",endDate);
	//hiddenFields.put("enddate",s_en_time);
	//hiddenFields.put("starthr",s_st_hr);
	//hiddenFields.put("endhr",s_en_hr);
	//hiddenFields.put("startmin",strmin);
	//hiddenFields.put("endmin",enmin);
	hiddenFields.put("startsec",stsec);
	hiddenFields.put("endsec",ensec);
	hiddenFields.put("getMaxDaysInMonth",String.valueOf(ErUtils.getMaxDaysInMonth()));
	hiddenFields.put("er_excweekend",request.getParameter("er_excwe"));
	hiddenFields.put("userID",urs);
	hiddenFields.put("fromSchedule",reqFromSchedule);
	if(fromScheduleModify!=null)
		hiddenFields.put("fromScheduleModify",fromScheduleModify);
	else
		hiddenFields.put("fromScheduleModify","null");

	if(fromFavoriteModify!=null)
		hiddenFields.put("fromFavoriteModify",fromFavoriteModify);
	else
		hiddenFields.put("fromFavoriteModify","null");
	hiddenFields.put("favorite_id", favorite_id);
	hiddenFields.put("er_favorite", er_favorite);

	hiddenFields.put("schedule_id",schedule_id);
	hiddenFields.put("er_bgreportfrom",er_bgreportfrom);
	hiddenFields.put("ReportFrom",er_bgreportfrom);
	hiddenFields.put("servletName","com.eg.ErVDIAssessmentController");
	hiddenFields.put("forwardto","ErVDIResourceUsageJson");
	hiddenFields.put("er_ViewName","ErVDIResourceUsage.jsp");
	hiddenFields.put("savereport","save");
	json.put("fromFavSch",reqFromSchedule);
	json.put("reportTitle",intlmp.getTextDescription("reporter.common.Virtual Desktop Insight")+"-"+intlmp.getTextDescription("reporter.common.Resource Usage"));

	if(backreqMap != null && backreqMap.size() > 0 &&  enableBack && request.getParameter("enableBack")!=null && request.getParameter("enableBack").equalsIgnoreCase("true"))
	{
		json.put("ID","backQnumber="+erhelputils.getBackID()+"&"+erhelputils.getQueryString());
	}

	screenLabels.put("reporter.common.Analyze By",intlmp.getTextDescription("reporter.common.Analyze by"));
	JSONArray grpArray = new JSONArray();	
	JSONObject loopJsonObj 	= new JSONObject();
	if(arr_groups!=null && !arr_groups.isEmpty())
	{
		for(int i=0;arr_groups.size()>i;i++)
		{
			str_selected="";
			String str_group=(String)arr_groups.get(i);
			if(s_group!=null && s_group.equalsIgnoreCase(str_group))
			{
				str_selected="SELECTED";
				json.put("er_group",s_group);
			}
			loopJsonObj = new JSONObject();
			loopJsonObj.put("displayField",intlmp.getTextDescription("reporter.common."+str_group));
			loopJsonObj.put("valueField",str_group);
			grpArray.add(loopJsonObj);
			
				
		}
	}
	else
	{
		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmp.getTextDescription("reporter.common.Not Applicable"));
		loopJsonObj.put("valueField","notapplicable");
		grpArray.add(loopJsonObj);

	}
	json.put("analysisByArray",grpArray);

	if(s_group!=null && (s_group.equalsIgnoreCase("Service") || s_group.equalsIgnoreCase("Segment")))
	{

		screenLabels.put("reporter.common."+s_group,intlmp.getTextDescription("reporter.common."+s_group));		
		grpArray = new JSONArray();
		if(arr_listelements!=null && !arr_listelements.isEmpty())
		{
			loopJsonObj = new JSONObject();
			loopJsonObj.put("displayField",intlmp.getTextDescription("reporter.common.Please choose a "+s_group));
			loopJsonObj.put("valueField","-1");
			grpArray.add(loopJsonObj);
			for(int i=0;arr_listelements.size()>i;i++)
			{
				str_selected="";
				String str_group_name=(String)arr_listelements.get(i);
				if(s_group_name!=null && str_group_name.equals(s_group_name))
				{
					str_selected="SELECTED";
					json.put("group_name",str_group_name);			
				}
				loopJsonObj = new JSONObject();
				loopJsonObj.put("displayField",intlmp.getTextDescription("reporter.common."+str_group_name));
				loopJsonObj.put("valueField",str_group_name);
				grpArray.add(loopJsonObj);
			}
		}
		else
		{
			loopJsonObj = new JSONObject();
			loopJsonObj.put("displayField",intlmp.getTextDescription("reporter.common.Not Applicable"));
			loopJsonObj.put("valueField","notapplicable");
			grpArray.add(loopJsonObj);		
		}
		json.put("elementsArray",grpArray);
	}
	else if(s_group!=null &&s_group.equalsIgnoreCase("Zone"))
	{
		screenLabels.put("reporter.thin.Include subzone",intlmp.getTextDescription("reporter.thin.Include subzone"));
		String subzoneYes="";
		String subzoneNo="";
		if(includeSubZone.equals("No"))
		{
			subzoneNo="SELECTED";
			json.put("includeSubZone","No");	
		}
		else
		{
			subzoneYes="SELECTED";
			json.put("includeSubZone","Yes");
		}
		grpArray = new JSONArray();
		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmp.getTextDescription("reporter.common.Yes"));
		loopJsonObj.put("valueField","Yes");
		grpArray.add(loopJsonObj);
		loopJsonObj.put("displayField",intlmp.getTextDescription("reporter.common.No"));
		loopJsonObj.put("valueField","No");
		grpArray.add(loopJsonObj);
	}
	else
	{
		
	}
	json.put("includeSubZoneArray",grpArray);		
	if(s_group!=null &&s_group.equalsIgnoreCase("Zone"))
	{

		screenLabels.put("reporter.common.Zone",intlmp.getTextDescription("reporter.common.Zone"));
		grpArray = new JSONArray();	
		if(arr_listelements!=null && !arr_listelements.isEmpty())
		{
			screenLabels.put("reporter.common.Please choose a "+s_group,intlmp.getTextDescription("reporter.common.Please choose a "+s_group));
			loopJsonObj = new JSONObject();
			loopJsonObj.put("displayField",intlmp.getTextDescription("reporter.common.Please choose a "+s_group));
			loopJsonObj.put("valueField","-1");
			grpArray.add(loopJsonObj);
			for(int i=0;arr_listelements.size()>i;i++)
			{
				str_selected="";
				String str_group_name=(String)arr_listelements.get(i);
				if(s_group_name!=null && str_group_name.equals(s_group_name))
				{
					str_selected="SELECTED";
					json.put("group_name",str_group_name);
				}
				loopJsonObj = new JSONObject();
				loopJsonObj.put("displayField",intlmp.getTextDescription("reporter.common."+str_group_name));
				loopJsonObj.put("valueField",str_group_name);
				grpArray.add(loopJsonObj);			
			}
		}
		else
		{
			loopJsonObj = new JSONObject();
			loopJsonObj.put("displayField",intlmp.getTextDescription("reporter.common.Not Applicable"));
			loopJsonObj.put("valueField","notapplicable");
			grpArray.add(loopJsonObj);				
		}
	}

	json.put("elementsArray",grpArray);		
	screenLabels.put("reporter.common.Component Type",intlmp.getTextDescription("reporter.common.Component Type"));
	grpArray = new JSONArray();
	if(arr_compTypes_sorted!=null && arr_compTypes_sorted.size()>0)
	{
		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmp.getTextDescription("reporter.common.Please choose a component type"));
		loopJsonObj.put("valueField","-1");
		grpArray.add(loopJsonObj);	

		if(arr_compTypes_sorted.size()>1 )
		{
			str_selected="";
			if(s_compType==null || s_compType.equals("") || s_compType.equals("all"))
			{
				str_selected="SELECTED";

				loopJsonObj = new JSONObject();
				loopJsonObj.put("displayField",intlmp.getTextDescription("reporter.common.All"));
				loopJsonObj.put("valueField","all");
				grpArray.add(loopJsonObj);
			}
		}
		for(int i=0;arr_compTypes_sorted.size()>i;i++)
		{
			str_selected="";
			EgName EgObj=(EgName)arr_compTypes_sorted.get(i);
			String actual_CompType = EgObj.getActualName();
			if(actual_CompType.equalsIgnoreCase(s_compType))
			{
				str_selected="SELECTED";
				json.put("er_componentType",actual_CompType);
			}
			loopJsonObj = new JSONObject();
			loopJsonObj.put("displayField",EgObj.getLocalName());
			loopJsonObj.put("valueField",actual_CompType);
			grpArray.add(loopJsonObj);
		}
	}
	else
	{
		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmp.getTextDescription("reporter.common.Not Applicable"));
		loopJsonObj.put("valueField","notapplicable");
		grpArray.add(loopJsonObj);					
	}

	json.put("componentTypeArray",grpArray);					
	screenLabels.put("reporter.common.Component",intlmp.getTextDescription("reporter.common.Component"));
	grpArray = new JSONArray();
	JSONArray unmanagegrpArray = new JSONArray();
	v_compList=compUtils.getIntnlSupportComponent(new Vector(arr_compList),"#",2);
	JSONArray selectedComboJArray=new JSONArray(); 
	boolean haveUnmanagedComp=false;
	if(v_compList!=null && !v_compList.isEmpty())
	{
		for(int j=0;v_compList.size()>j;j++)
		{
			str_selected="";
			String tmp_component=(String)v_compList.get(j);
			ArrayList arr_tok = testInfo.egTokenizer(tmp_component,"#");
			String comp_disp=(String)arr_tok.get(0);
			if (comp_disp.indexOf(":") > -1)
			{
				comp_disp = comp_disp.substring(0,comp_disp.indexOf(":"));
			}
			String comp_actualValue=(String)arr_tok.get(1);
			if(arr_selectedComponents.contains(comp_actualValue))
			{
				str_selected="SELECTED";
				json.put("er_component",comp_actualValue);
				selectedComboJArray.add(comp_actualValue);
			}

			loopJsonObj = new JSONObject();
			loopJsonObj.put("displayField",comp_disp);
			loopJsonObj.put("valueField",comp_actualValue);
			if(allUserUnManagedComponent_Type!=null && allUserUnManagedComponent_Type.get(comp_actualValue)!=null)
			{
				haveUnmanagedComp=true;
				loopJsonObj.put("groupField",intlmp.getTextDescription("reporter.common.UnManaged/Deleted Components"));
				unmanagegrpArray.add(loopJsonObj);
			}
			else
			{
				//loopJsonObj.put("groupField",intlmp.getTextDescription("reporter.common.Managed Components"));
				grpArray.add(loopJsonObj);
			}						
		}
		if(haveUnmanagedComp && grpArray!=null)
		{
			for(int u=0;u<grpArray.size();u++)
			{
				JSONObject loopJsonObJ = (JSONObject)grpArray.get(u);
				if(loopJsonObJ.get("groupField")==null)
				{
					loopJsonObJ.put("groupField",intlmp.getTextDescription("reporter.common.Managed Components"));
				}
			}
		}
		grpArray.addAll(unmanagegrpArray);
		if(selectedComboJArray.size()==0 && v_compList.size()>0)
		{
			String tmp_component=(String)v_compList.get(0);
			ArrayList arr_tok = testInfo.egTokenizer(tmp_component,"#");
			selectedComboJArray.add((String)arr_tok.get(1));
		}
	}
	else
	{
		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmp.getTextDescription("reporter.common.Not Applicable"));
		loopJsonObj.put("valueField","notapplicable");
		grpArray.add(loopJsonObj);						
	}

	session.setAttribute("component",grpArray);							
	json.put("componentArray",grpArray);										
	screenLabels.put("reporter.comparison.Components",intlmp.getTextDescription("reporter.comparison.Components"));
	System.out.println("s_compType_______ "+selectedComboJArray);
	if(s_compType!=null && (s_compType.equalsIgnoreCase("Horizon_Pod") || s_compType.equalsIgnoreCase("Citrix_XcXenDesktop_server")))
	{
		String unmanagedFlag =reportInfo.getValue("MISC", "showUnmanagedComp");
		ArrayList testList = new ArrayList();
		testList.add("METATEST");
		if(unmanagedFlag!=null && unmanagedFlag.equalsIgnoreCase("Yes"))
			testList.add("UNMANAGEDMETATEST");
		String queryComp = "";
		String queryCompType = "";
		Vector desktopsList = null;
		if(selectedComboJArray!=null && selectedComboJArray.size()>0)
		{
			for(int v=0;v<selectedComboJArray.size();v++)
			{
				String temp = (String)selectedComboJArray.get(v);
				if(temp!=null && temp.indexOf(":")>-1)
				{
					queryCompType = temp.substring(0,temp.indexOf(":"));
					queryComp+="'"+temp.substring(temp.indexOf(":")+1)+"',";
				}
			}
			if(queryComp.endsWith(","))
			{
				queryComp = queryComp.substring(0,queryComp.length()-1);
			}
		
			StringBuffer sb_query = new StringBuffer();
			sb_query.append(" comp_name  in (" + queryComp + ") AND ");
			sb_query.append(" comp_type in ('" + queryCompType + "','Host_system') AND ");
			if(queryCompType.equalsIgnoreCase("Horizon_Pod"))
			{
				sb_query.append(" test_name ='HrznPODPoolTest'");
			}
			else
			{
				sb_query.append(" test_name ='CtxXcXDCGroupTest'");
				sb_query.append(" AND INFO LIKE '+Desktop OS Machines%'");
			}
			desktopsList = erInfo.getDistinctDataForReport(testList,"INFO", null, false, 0, sb_query.toString(),null, null, null, null, "No", null);
		}
		System.out.println("desktopsList "+desktopsList);
		JSONArray iterateJArray=new JSONArray();
		JSONObject iterateJObject=new JSONObject();
		List templist = new ArrayList();
		if(desktopsList==null || desktopsList.size()==0)
		{
			iterateJObject=new JSONObject();
			iterateJObject.put("displayField",intlmp.getTextDescription("reporter.common.Not Applicable"));
			iterateJObject.put("valueField","-1");
			iterateJArray.add(iterateJObject);
			templist.add("-1");
		}
		else
		{
			if(er_poolType!=null&&er_poolType.length>0)
			{
				templist = Arrays.asList(er_poolType);
			}
			else
			{
				templist.add("all");
			}
			iterateJObject=new JSONObject();
			iterateJObject.put("displayField",intlmp.getTextDescription("reporter.common.All Desktops pools"));
			iterateJObject.put("valueField","all");
			iterateJArray.add(iterateJObject);
			for(int v=0;v<desktopsList.size();v++)
			{
				String desktopsListStr = (String)desktopsList.get(v);
				if(s_compType.equalsIgnoreCase("Citrix_XcXenDesktop_server") && desktopsListStr.indexOf(":")>-1)
				{
					desktopsListStr = desktopsListStr.substring(desktopsListStr.indexOf(":")+1);
				}
				if(desktopsListStr!=null && (desktopsListStr.equalsIgnoreCase("Total")||desktopsListStr.equalsIgnoreCase("All")))
				{
					continue;
				}
				iterateJObject=new JSONObject();
				iterateJObject.put("displayField",desktopsListStr);
				iterateJObject.put("valueField",desktopsListStr);
				iterateJArray.add(iterateJObject);
			}
		}
		json.put("poolTypeCombo",iterateJArray);
		json.put("poolTypeSelected",templist);
		screenLabels.put("poolTypeLabel",intlmp.getTextDescription("reporter.thin.Desktops pools"));
		s_view = "InsideView";
	}

	v_compList=compUtils.getIntnlSupportComponent(new Vector(arr_compList),"#",2);
	if(v_compList!=null && !v_compList.isEmpty())
	{
		grpArray = new JSONArray();
		for(int j=0;v_compList.size()>j;j++)
		{
			str_selected="";
			String tmp_component=(String)v_compList.get(j);
			ArrayList arr_tok = testInfo.egTokenizer(tmp_component,"#");
			String comp_disp=(String)arr_tok.get(0);
			if (comp_disp.indexOf(":") > -1)
			{
				comp_disp = comp_disp.substring(0,comp_disp.indexOf(":"));
			}
			String comp_actualValue=(String)arr_tok.get(1);
			if(arr_selectedComponents.contains(comp_actualValue))
			{
				str_selected="SELECTED";
				json.put("selectedPopUpComp",comp_actualValue);
			}

			loopJsonObj = new JSONObject();
			loopJsonObj.put("displayField",comp_disp);
			loopJsonObj.put("valueField",comp_actualValue);
			grpArray.add(loopJsonObj);													
		}
	}
	else
	{
		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmp.getTextDescription("reporter.common.Not Applicable"));
		loopJsonObj.put("valueField","notapplicable");
		grpArray.add(loopJsonObj);													
	}

	json.put("popUpCompArray",grpArray);														
	screenLabels.put("admin.common.Select",intlmp.getTextDescription("admin.common.Select"));
			
	screenLabels.put("reporter.common.Show",intlmp.getTextDescription("reporter.common.Show"));
	grpArray = new JSONArray();
	String insideChecked="";
	String outsideChecked="";
	if(s_view.equals("InsideView"))
	{
		insideChecked="checked";
		json.put("er_view","InsideView");
		
	}
	else
	{
		if(!(s_compType!=null && (s_compType.equalsIgnoreCase("Cloud_VMs") || s_compType.equalsIgnoreCase("Physical_Desktops"))))
		{
			outsideChecked="checked";
			json.put("er_view","OutsideView");
		}
	}
	loopJsonObj = new JSONObject();
	loopJsonObj.put("displayField","InsideView");
	loopJsonObj.put("valueField","InsideView");
	grpArray.add(loopJsonObj);
	if(!(s_compType!=null && (s_compType.equalsIgnoreCase("Cloud_VMs") || s_compType.equalsIgnoreCase("Physical_Desktops"))))
	{
		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField","OutsideView");
		loopJsonObj.put("valueField","OutsideView");
		grpArray.add(loopJsonObj);
	}
	json.put("showArray",grpArray);

	screenLabels.put("reporter.common.Aggregate Data By",intlmp.getTextDescription("reporter.common.Aggregate Data By"));
	grpArray = new JSONArray();
	String desktopChecked="";
	String userChecked="";
	String analyseDataForUI="";
	if(analyseDataBy!=null && analyseDataBy.equals("user"))
	{
		userChecked="checked";
		analyseDataForUI="user";
		
		
	}
	else
	{
		desktopChecked="checked";
		analyseDataForUI="desktop";
		
	}
	loopJsonObj = new JSONObject();
	loopJsonObj.put("displayField","User");
	loopJsonObj.put("valueField","user");
	grpArray.add(loopJsonObj);
	loopJsonObj = new JSONObject();
	loopJsonObj.put("displayField","Desktop");
	loopJsonObj.put("valueField","desktop");
	grpArray.add(loopJsonObj);
	json.put("aggregateDataByArray",grpArray);
	json.put("analyseDataBy",analyseDataForUI);

	screenLabels.put("MappedExcludeDays", intlmp.getTextDescription("reporter.common.Excludes")+" "+MappedExcludeDays);	
	if(excludeweekend.equalsIgnoreCase("Yes") )
	{
		json.put("excludeWeek","Yes");
	}
	else
	{
		json.put("excludeWeek","No");
	}
	screenLabels.put("reporter.common.Exclude Weekends",intlmp.getTextDescription("reporter.common.Exclude Weekends"));
	grpArray = new JSONArray();
	loopJsonObj = new JSONObject();
	loopJsonObj.put("displayField",intlmp.getTextDescription("reporter.common.No"));
	loopJsonObj.put("valueField", "No");
	grpArray.add( loopJsonObj );
	loopJsonObj = new JSONObject();
	loopJsonObj.put("displayField",intlmp.getTextDescription("reporter.common.Yes")+" ("+MappedExcludeDays+") ");
	loopJsonObj.put("valueField", "Yes");
	grpArray.add( loopJsonObj );
	json.put("excludeArray", grpArray);

	screenLabels.put("reporter.common.Time period",intlmp.getTextDescription("reporter.common.Time period"));
	screenLabels.put("reporter.common.Hrs",intlmp.getTextDescription("reporter.common.Hrs"));
	screenLabels.put("reporter.common.Mins",intlmp.getTextDescription("reporter.common.Mins"));

	grpArray = new JSONArray();
	for(int jk=0;v_time.size()>jk;jk++)
	{
		String tmp_hr=(String)v_time.get(jk);

		loopJsonObj=new JSONObject();
		loopJsonObj.put("displayField", tmp_hr);
		loopJsonObj.put("valueField", tmp_hr);
		grpArray.add(loopJsonObj);
	}
	json.put("timeFromArray",grpArray);

	loopJsonObj=new JSONObject();
	loopJsonObj.put("displayField", "24");
	loopJsonObj.put("valueField", "24");
	grpArray.add(loopJsonObj);

	json.put("timeToArray",grpArray);

	grpArray = new JSONArray();
	for(int jk=0;v_min.size()>jk;jk++)
	{
		String tmp_min=(String)v_min.get(jk);

		loopJsonObj=new JSONObject();
		loopJsonObj.put("displayField", tmp_min);
		loopJsonObj.put("valueField", tmp_min);
		grpArray.add(loopJsonObj);
	}

	json.put("timePeriodMinsArray",grpArray);

	json.put("timefrom",Hourfrom);
	json.put("minfrom",Minfrom);
	json.put("timeto",Hourto);
	json.put("minto",Minto);
%>
	<%@  include file ="ErTimeFormatJSON.jsp"%>
<%

	hiddenFields.put("userTimeline",strUsrTimeline);
	screenLabels.put("reporter.common.Timeline", intlmp.getTextDescription("reporter.common.Timeline"));
	screenLabels.put("reporter.common.From", intlmp.getTextDescription("reporter.common.From"));
	screenLabels.put("reporter.common.To", intlmp.getTextDescription("reporter.common.To"));
	screenLabels.put("reporter.common.Hr", intlmp.getTextDescription("reporter.common.Hr"));
	screenLabels.put("reporter.common.Graph", intlmp.getTextDescription("reporter.common.Graph"));

	json.put("timelineCombo",timelineComboArray);
	json.put("timelineHourCombo",timelineHourComboArray);
	json.put("selectedTimeline",er_timeline);
	json.put("startDate",startDateJSON);
	json.put("endDate",endDateJSON);
	json.put("startHour",startHourJSON);
	json.put("endHour",endHourJSON);
	json.put("startmin",strmin);
	json.put("endmin",enmin);
	//json.put("selectedGraphMode",selectedGraphMode);

	json.put("startDateForDisplay",startDateForDisplay);
	json.put("startHourForDisplay",startHourForDisplay);
	json.put("startMinForDisplay",startMinForDisplay);
	json.put("endDateForDisplay",endDateForDisplay);
	json.put("endHourForDisplay",endHourForDisplay);
	json.put("endMinForDisplay",endMinForDisplay);

	if(trackerLanguage!=null && (trackerLanguage.equals("en_US") || trackerLanguage.equals("ch_CH") || trackerLanguage.equals("ja_JP") || trackerLanguage.equals("ko_KR")) || trackerLanguage.equals("th_TH"))
	{

	}
	else if(trackerLanguage!=null && (trackerLanguage.equals("fr_FR") || trackerLanguage.equals("de_DE") || trackerLanguage.equals("es_ES") || trackerLanguage.equals("it_IT") || trackerLanguage.equals("pt_BR")))
	{

	}
	if (Hourto.equals("24"))
	{

	}
	else
	{

	}

	if(isbgEnabled != null && isbgEnabled.equalsIgnoreCase("Yes"))
	{

		screenLabels.put("reporter.consolidated.Report Generation", intlmp.getTextDescription("reporter.consolidated.Report Generation"));
		screenLabels.put("reporter.consolidated.Report Name", intlmp.getTextDescription("reporter.consolidated.Report Name"));
		grpArray =  new JSONArray();
		loopJsonObj=new JSONObject();
		loopJsonObj.put("displayField", strbackground);
		loopJsonObj.put("valueField", "background");
		grpArray.add(loopJsonObj);
		loopJsonObj=new JSONObject();
		loopJsonObj.put("displayField", strforeground);
		loopJsonObj.put("valueField", "foreground");
		grpArray.add(loopJsonObj);
		json.put("reportGenerationArray",grpArray);

		String er_reportgenration = request.getParameter("er_reportgenration");
		String er_background ="";
		String er_foreground ="";
		if (er_reportgenration != null && er_reportgenration.equals("background"))
		{
			er_background = "selected";
			er_foreground = "";
			json.put("reportGeneration","background");
		}
		else
		{
			er_background = "";
			er_foreground = "selected";
			json.put("reportGeneration","foreground");
		}
		String bg_reportname = request.getParameter("bg_reportname");
		if(bg_reportname == null)
		{
			bg_reportname = "";
		}

		if (er_reportgenration != null && er_reportgenration.equals("background"))
		{

		}
		else
		{

		}
		json.put("backgroundReportStatus",status);
	}

	if(reqFromSchedule!=null && reqFromSchedule.equalsIgnoreCase("Yes"))
	{

	}
	else
	{

	}

	if(bggroundStr != null && !bggroundStr.equals(""))
	{
		if(status != null && (status.equalsIgnoreCase("duplicate") || status.equalsIgnoreCase("exceedLimit")))
		{
			er_bgreportfrom="All Report Types";
		}
		if(er_bgreportfrom!=null && er_bgreportfrom.indexOf(" ") > -1)
		{
			er_bgreportfrom = com.eg.EgURLEncoder.encode(er_bgreportfrom, "UTF-8");
		}
		String bgroundResponseTxt=bggroundStr;
		if(status != null && !status.equalsIgnoreCase("exceedLimit"))
		{
			bgroundResponseTxt=erbgreport.getlangsupportedString(bggroundStr,bgString,urs);
		}
		json.put("bgroundResponseTxt",bgroundResponseTxt);
		json.put("bgroundReportsURL","/final/servlet/com.eg.ErStartBackGroundReportC?back=true&er_bgreportfrom="+er_bgreportfrom+"&userID="+com.eg.EgURLEncoder.encode(urs, "UTF-8")+"&savereport=search&er_filterby=Report_Name&forwardto=ErBackGoundProcess");
	}

	json.put("backgroundAnchor", intlmp.getTextDescription("reporter.common.Click here to see a list of generated and processing reports"));
	String  Mail_Qry_String = "";
	String success = (String)request.getAttribute("success");
	if((hasFormSubmitted!=null && hasFormSubmitted.equalsIgnoreCase("true")) || success!=null && success.equals("success"))
	{
		JSONObject selectionDetails=new JSONObject();
		JSONArray chartData = new JSONArray();
		JSONObject chartObj = new JSONObject();
		if(DataAvailableMeasureGroup!=null && !DataAvailableMeasureGroup.isEmpty())
		{
			int noOfCharts=DataAvailableMeasureGroup.size();
			int chartCount=0;
			String swfpath = "/final/FusionCharts/swf/Pie" +  (chartMode != null && chartMode.equalsIgnoreCase("2D") ? "2" : "3" ) + "D.swf";
			//String dispStartDate=s_st_time+" "+s_st_hr+" Hrs "+strmin+" Mins ";
			//String dispEndDate=s_en_time+" "+s_en_hr+" Hrs "+enmin+" Mins ";
			
			String st_dateTime="";
	        String en_dateTime="";

			EgTimeZoneConverter converterStart=null;
			EgTimeZoneConverter converterEnd=null;
			
			if(s_st_time!=null)
			{
				if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
				{
					comFormat = currentDateFormat;
					s_st_time = DateUtil.changeDateFormat(s_st_time,"MM/dd/yyyy",comFormat);
				}
				converterStart = new EgTimeZoneConverter(s_st_time+" "+s_st_hr+":"+strmin,thisuser);
				st_dateTime = converterStart.getDateTime();
			}
			if(s_en_time!=null)
			{
				if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
				{
					comFormat = currentDateFormat;
					s_en_time = DateUtil.changeDateFormat(s_en_time,"MM/dd/yyyy",comFormat);
				}
				converterEnd = new EgTimeZoneConverter(s_en_time+" "+s_en_hr+":"+enmin,thisuser);
				en_dateTime = converterEnd.getDateTime();
			}



			String dispStartDate=st_dateTime;
			String dispEndDate=en_dateTime;


			String timfrom=Hourfrom+":"+Minfrom;
			String timto=Hourto+":"+Minto;
			String pieRadius = "";
			String chartDivHeight="";

			JSONObject colorCoding = new JSONObject();
			JSONArray colorArray = new JSONArray();
			if(chartMode != null && chartMode.equalsIgnoreCase("3D"))
			{
				pieRadius = "100";
				chartDivHeight="250";
			}
			else
			{
				pieRadius = "70";
				chartDivHeight="270";
			}
			json.put("selectionDetailstitle", intlmp.getTextDescription("reporter.common.Selection Details for")+" "+intlmp.getComponentTypeDescription(s_compType));

			selectionDetails.put(intlmp.getTextDescription("reporter.common.Analyze by"),intlmp.getTextDescription("reporter.common."+s_group));
			selectionDetails.put(intlmp.getTextDescription("reporter.common.Component Type"),intlmp.getComponentTypeDescription(s_compType));
			
		
			selectionDetails.put(intlmp.getTextDescription("reporter.common.Aggregate Data By"),intlmp.getTextDescription("reporter.common."+analyseDataForUI));

			selectionDetails.put(intlmp.getTextDescription("reporter.common.Time Period"),"<span class='font_bold'></span>  "+ timfrom+"<span class='font_bold'>  "+intlmp.getTextDescription("reporter.common.to")+"</span> "+timto);

			selectionDetails.put(intlmp.getTextDescription("reporter.common.Timeline"), "<span class='font_bold'> </span>  "+dispStartDate+" "+intlmp.getTextDescription("reporter.common.hrs")+" <span class='font_bold'> "+intlmp.getTextDescription("reporter.common.to")+" </span> "+dispEndDate+" "+intlmp.getTextDescription("reporter.common.hrs"));
		
			json.put("selectionDetails",selectionDetails);
			if(labelList!=null )
			{
				for(int n=0;labelList.size()>n;n++)
				{
					colorCoding = new JSONObject();
					String label=(String)labelList.get(n);
					String colorcode=(String)colorList.get(n);
					colorCoding.put("label",label);
					colorCoding.put("colorcode",colorcode);
					colorArray.add(colorCoding);
					

				}
			}
			// Always comment the because of Boss suggesstion 
			//if(rangeDivided<=4)
				//json.put("colorCodingArray",colorArray);
			if(DataAvailableMeasureGroup.size()>1)
			{

			}
			for(int i=0;DataAvailableMeasureGroup.size()>i;i++)
			{
				String measureGroup=(String)DataAvailableMeasureGroup.get(i);
				HashMap chartAttributes=(HashMap)chartAttributeMaps.get(measureGroup);
				if(chartAttributes == null || chartAttributes.size()==0)
					continue;
				ArrayList sampleLabels=(ArrayList)chartAttributes.get("sampleLabels");
				ArrayList DataSet=(ArrayList)chartAttributes.get("sampleValues");
				String dynamicDivName="chart"+chartCount+"div";
				String chartTitle=(String)chartAttributes.get("chartTitle");
			
				String XMLdata=fusionChartBean.getXmlDataForVDIAssessmentPie(chartAttributes,pieRadius);

				String drillDownQstring ="/final/reporter/ErVDIAssessmentDrillDown.jsp?" +"reporttype="+s_reporttype+"&subtype="+s_subtype+"&er_view="+s_view+"&group_name="+s_group_name+"&er_group="+s_group+"&er_componentType="+s_compType+"&analyseDataBy="+analyseDataBy+"&includeSubZone="+includeSubZone+"&er_mode="+chartMode+"&startdate="+s_st_time+"&enddate="+s_en_time+"&starthr="+s_st_hr+"&startmin="+strmin+"&endmin="+enmin+"&endhr="+s_en_hr+"&measureGroup="+measureGroup;
				JSONArray legendArray = new JSONArray();
				JSONArray aListJsonArray = new JSONArray(); //..prakash
				String custom_chartType = reportInfo.getValue("Desktop_Insight_Resource_Usage","chartType");
				JSONArray dataSet = fusionChartBean.getPieDataSet();
				JSONArray aListJsonBarArray = new JSONArray();
				String manualLabelForBar="";

				if(custom_chartType!=null && custom_chartType.equalsIgnoreCase("bar"))
				{
					for(int jk=0;sampleLabels.size()>jk;jk++)
					{
						String manualLabel=(String)sampleLabels.get(jk);  
						String manualLabelTemp = manualLabel;
						Integer vmCount=(Integer)DataSet.get(jk);
						if(vmCount.intValue()!=0)
						{
							legendArray.add(manualLabel);	
						}
						if(manualLabelTemp!=null && manualLabelTemp.indexOf("&lt;")>-1)
							manualLabelTemp = StringUtils.replace(manualLabelTemp,"&lt;","<");
						else if(manualLabelTemp.indexOf("&gt;")>-1)
							manualLabelTemp = StringUtils.replace(manualLabelTemp,"&gt;",">");
						else if(manualLabelTemp.indexOf("to")>-1)
							manualLabelTemp = StringUtils.replace(manualLabelTemp,"to","-");
						
						if(vmCount.intValue()!=0)
						{
							aListJsonBarArray.add(manualLabelTemp);
						}
					}
					if(dataSet!=null && dataSet.size()>0)
					{
						for(int di=0;di<dataSet.size();di++)
						{
							JSONObject jobj = (JSONObject)dataSet.get(di);
							String strRange = (String)jobj.get("name");
							//jobj.put("url",drillDownQstring+"&er_ranage="+aListJsonBarArray.get(di));
							jobj.put("url",drillDownQstring+"&er_ranage="+erUtils.specialCharEncode((String)aListJsonBarArray.get(di)));
						}
					}
				}
				chartObj = new JSONObject();
				chartObj.put("resultTitle",dynamicDivName);
				chartObj.put("chartTitle",chartTitle);

				chartObj.put("swfpath",swfpath);
				chartObj.put("drillDownQstring",drillDownQstring);

				if(XMLdata!=null && XMLdata.trim().length()>0)
				{
					chartObj.put("XMLData",XMLdata);

					// high chart pie

					JSONObject legendObj = new JSONObject();
					JSONArray jarr = new JSONArray();
					JSONObject obj = new JSONObject();

					/*obj.put("data",dataSet);
					jarr.add(obj);
					chartObj.put("DataSet",jarr);  */

					chartObj.put("showInLegend", new Boolean(false));
					chartObj.put("title","");

					chartObj.put("chartHeight",fusionChartBean.getPieChartHeight());
					chartObj.put("chartWidth",fusionChartBean.getPieChartWidth());
					chartObj.put("drildown","newtab");

					if(custom_chartType!=null && custom_chartType.equalsIgnoreCase("bar"))
					{
						chartObj.put("chartType","bar");
						chartObj.put("xAxisLabel",legendArray);
						if(analyseDataBy!=null && analyseDataBy.equals("user"))
						{
							chartObj.put("yAxisLabel","Number of Users");
						}
						else
						{
							chartObj.put("yAxisLabel","Number of VDIs");
						}
						chartObj.put("xAxisLabelText",chartAttributes.get("rangeAxisLabel"));
						chartObj.put("noNeedUnit","yes");
					}
					else
					{
						chartObj.put("chartType","pie");
						for(int jk=0;sampleLabels.size()>jk;jk++)
						{
							String manualLabel=(String)sampleLabels.get(jk);
							String manualLabel_temp=manualLabel;
							String colorForLegend=(String)colorList.get(jk);
							Integer vmCount=(Integer)DataSet.get(jk);
							if(vmCount.intValue()!=0)
							{
								
								legendObj.put("colorForLegend",colorForLegend);
								legendObj.put("manualLabel",manualLabel);
								legendArray.add(legendObj);	

								if(manualLabel_temp!=null && manualLabel_temp.indexOf("&lt;")>-1)
									manualLabel_temp = StringUtils.replace(manualLabel_temp,"&lt;","<");
								else if(manualLabel_temp.indexOf("&gt;")>-1)
									manualLabel_temp = StringUtils.replace(manualLabel_temp,"&gt;",">");
								else if(manualLabel_temp.indexOf("to")>-1)
									manualLabel_temp = StringUtils.replace(manualLabel_temp,"to","-");
								aListJsonArray.add(manualLabel_temp);   //prakash
							}
						}
						//prakash
						if(dataSet!=null && dataSet.size()>0)
						{
							for (int kk=0;kk<dataSet.size();kk++)
							{
								JSONObject aListObj = (JSONObject)dataSet.get(kk);
								//aListObj.put("url",drillDownQstring+"&er_ranage="+aListJsonArray.get(kk));
								aListObj.put("url",drillDownQstring+"&er_ranage="+erUtils.specialCharEncode((String)aListJsonArray.get(kk)));
									
							}
						}	
						//
						
						chartObj.put("legends",legendArray);
					}
					obj.put("data",dataSet);
					jarr.add(obj);
					chartObj.put("DataSet",jarr);
				}
				else
				{
					chartObj.put("XMLData","-");
				}
				chartObj.put("chartHeight",chartDivHeight);
				//chartData.add(chartObj);
				
				if(noOfCharts%2>0 && noOfCharts==chartCount+1)
				{

				}
				if(chartCount!=0 && chartCount%2>0)
				{

				}
				chartCount++;
				
				chartData.add(chartObj);
				
			}
			json.put("chartData",chartData);
		}
		else
		{
			chartObj.put("XMLData","-");
			chartData.add(chartObj);
			json.put("chartData",chartData);	
		}
		Mail_Qry_String=mngrIProc+"/final/reporter/ErVDIAssessmentPrint.jsp;jsessionid="+ session.getId()+"?";
		session.setAttribute("MAIL_URL",Mail_Qry_String+printQueryString+"pdfSave=yes&isPdf=yes");

		session.setAttribute("PDF_URL", mngrIProc+"/final/reporter/ErVDIAssessmentPrint.jsp");

		/** file name for saved pdf **/
		HashMap param=new HashMap();
		param.put("fileName","VDIAssessmentReport");
		session.setAttribute("parameters",param);
		/**ends**/
	}
	if(hasFormSubmitted!=null && hasFormSubmitted.equalsIgnoreCase("true"))
	{
		session.setAttribute("reportLastAccessedURL","/final/reporter/ErVDIResourceUsage.jsp?"+"enableBack=false&"+encodedQueryString);
		listbackvar.add("/servlet/com.eg.ErVDIAssessmentController?");
		listbackvar.add("status="+status+"&bggroundStr="+bggroundStr+"&"+QStringForBackButton);
		session.setAttribute("favSchBackDisplay","Yes");
	}
	else
	{
		session.setAttribute("reportLastAccessedURL","/final/reporter/ErVDIResourceUsage.jsp?"+encodedQueryString);
		listbackvar.add("ErVDIResourceUsage.jsp?");
		listbackvar.add(QStringForBackButton);
		session.setAttribute("favSchBackDisplay","No");
	}
	String mailQueryString = mngrIProc+"/final/servlet/com.eg.ErVDIAssessmentController;jsessionid="+ session.getId()+"?isSubmit=true&"+printQueryString.toString();

	String backadded = erhelputils.getBackID();
	backreqMap = erhelputils.setBackQueryMap(backreqMap,backadded,listbackvar);
	session.setAttribute("backQuery",backreqMap);
	json.put("saveQString",printQueryString.toString());
	json.put("mailQString",mailQueryString);
	json.put("hiddenFields",hiddenFields);
	json.put("screenLabels",screenLabels);

	out.println(json);
	}
	catch(Exception e)
	{
		e.printStackTrace();
	}
%>




