<%
/**
 * Shows the topology for the selected segment or services in serviceDashboard.
 *	Name        serviceTopology
 *	@author		Balamurugan.V
 *	@created	03-08-2000
 *	@version	4.0
 *
 *	Modyfied	Vijaykumar 3.4.2007
 *  Modified    S.Saravanan 28-11-2011 for version 5.4
 */
%>
<%@ include file = "EgMonitorTracker.jsp" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page errorPage = "EgProbsM.jsp" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgTopoInfo" %>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgStateZone" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "com.eg.EgDbAdapterTypeUI"%>
<%@ page import = "egurkha.EgDbAdapterUI"%>
<%@ page import="com.egurkha.monitor.*" %>
<%@ page import = "com.eg.EgAlarmTable" %>
<%@ page import = "com.egurkha.monitor.alarms.AlarmPriorities"%>
<%@ page import = "java.sql.*" %>

<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.egurkha.ini.*" %>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "egurkha.EgCrawler" %>
<%@ page import = "java.io.*" %>
<%@ page import="net.sf.json.*"%>
<%@ page import="egurkha.ConfigSiteBean"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>
<%@ page import = "com.eg.supermanager.*" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%
try
{
	if(EgInstallInfo.isSuperManager)
	{
		String currentSession = session.getId();
		String selected_Param = request.getParameter("selectedParam");
		if(selected_Param != null && (selected_Param=selected_Param.trim()).length()>0)
		{
			String current_thread_name = Thread.currentThread().getName();
			ArrayList managerIDs = EgElementInfo.getInstance().getManagerIDs("service",selected_Param);
			if(managerIDs != null && !managerIDs.isEmpty())
			{
				SmSessionData smsData = new SmSessionData(currentSession,managerIDs);
				EgThreadLocal egtl = new EgThreadLocal();
				egtl.set(smsData);
				new SMDateTimeConverter(managerIDs);				
			}
		}
	}
	EgTopoInfo topoinfo = new EgTopoInfo("manager");
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	response.setContentType("application/json");
	request.setCharacterEncoding("UTF-8");
	
	String site=request.getParameter("site");
	site = (site==null)?"":site;
	String service=request.getParameter("service");
	String segState=request.getParameter("segState");
	String fromPage=request.getParameter("fromPage");
	String treeFlag=request.getParameter("treeFlag");
	String zoneName=request.getParameter("iszoneName");
	String currentTab=request.getParameter("iscurrentTab");
	String aggregateTab=request.getParameter("isaggregateTab");
	String openNode=request.getParameter("isopenNode");
	//String treeFlag=request.getParameter("treeFlag");
	String fromHomepage=request.getParameter("fromHomepage");
	fromHomepage = (fromHomepage!=null && !fromHomepage.equalsIgnoreCase("") && !fromHomepage.equalsIgnoreCase("null") && !fromHomepage.equalsIgnoreCase("undefined"))?fromHomepage:"";
	String transactionsFlag=request.getParameter("transactionsFlag");
	String action=request.getParameter("action");
	String serviceGroup=request.getParameter("serviceGroup");
	String iszoneName = request.getParameter("iszoneName")!=null?request.getParameter("iszoneName"):"";
	String isFromZone = request.getParameter("isFromZone"); 
	String parentZone = request.getParameter("parentZone");
	String parentZoneCheck = parentZone;
	if(parentZoneCheck != null && parentZoneCheck.trim().length() >0)
		parentZoneCheck = EgURLEncoder.encode(parentZoneCheck,"UTF-8");
	String topoSegCombo = request.getParameter("topoSegCombo");

	JSONObject json  = new JSONObject();
	JSONObject selectFieldData  = new JSONObject();
	JSONArray  selectOptions = new JSONArray();

	request.setAttribute("jsonObject",json);
	request.setAttribute("category","service");
	request.setAttribute("itemName",site);

	%>
		<%@ include file="aggregateTabHandler.jsp" %>
	<%
	
	IniUI iniUI = IniUI.getInstance();
	String thisLanguage = iniUI.getDefaultLanguage();
	//EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	
	if(fromPage==null)
	{
		fromPage="";
	}
	String ua = request.getHeader( "User-Agent" );
	boolean isMSIE = ( ua != null && ua.indexOf( "MSIE" ) != -1 );

	if(service==null || service.equals(""))
	{
		if(site!=null || !site.equals(""))
			service = site;
	}
	String from=request.getParameter("from");
	String fromSuper = (String)session.getAttribute("fromSuper");
	String s_qrstring="";
	String Qstring="";
	s_qrstring=request.getQueryString();
	if(s_qrstring!=null)
	{
			StringTokenizer strtok = new StringTokenizer(s_qrstring,"&");
			while(strtok.hasMoreTokens())
			{
					String param = strtok.nextToken();
					String reqparam =param.substring(0,param.indexOf("="));
					String value = param.substring(param.indexOf("=")+1,param.length());
					
					if(reqparam.equals("ptype"))
					{
							value=request.getParameter(reqparam) ;
					}
					if(reqparam.equals("site"))
					{
							//value=request.getParameter(reqparam) ;
							if(request.getParameter(reqparam)!=null)
							{
								value=com.eg.EgURLEncoder.encode(request.getParameter(reqparam), "UTF-8"); 
							}
							else
							{
								value=request.getParameter(reqparam);
							}
					}
					if(reqparam.equals("segment"))
					{
							//value=request.getParameter(reqparam) ;
							if(request.getParameter(reqparam)!=null)
							{
								value=com.eg.EgURLEncoder.encode(request.getParameter(reqparam), "UTF-8"); 
							}
							else
							{
								value=request.getParameter(reqparam);
							}
							
					}
					if(reqparam.equals("seglist"))
					{
						if(request.getParameter(reqparam)!=null)
						{
							value=com.eg.EgURLEncoder.encode(request.getParameter(reqparam), "UTF-8"); 
						}
						else
						{
							value=request.getParameter(reqparam);
						}
							
					}

				Qstring=Qstring+reqparam+"="+value+"&";
		}

	}

	if(Qstring.endsWith("&"))
	Qstring=Qstring.substring(0,Qstring.lastIndexOf("&"));
	String s_conn = null;
	String s_tlist = "";
	EgDbAdapterUI egDb;
	ResultSet rs=null;
	List transactionList = new LinkedList();
	egDb=EgDbAdapterTypeUI.getObject();
	try
	{
		s_conn=egDb.setConnection();
		if(EgInstallInfo.isSuperManager)
		{
			ArrayList managerIDs = EgElementInfo.getInstance().getManagerIDs("service",site.trim());
			if(managerIDs != null && !managerIDs.isEmpty())
			{
				SmSessionData smsData = new SmSessionData(session.getId(),managerIDs);
				EgThreadLocal egtl = new EgThreadLocal();
				egtl.set(smsData);
			}
		}
		rs = egDb.SelectEgAddMonTrans(site.trim());

		while(rs.next())
		{
			transactionList.add(rs.getString("trans_name"));
			transactionList.add(rs.getString("user_id"));
			s_tlist = s_tlist + rs.getString("trans_name") + ";";
		}

		rs.close();
		egDb.releaseConnection(false);
		EgDbAdapterTypeUI.releaseObject(egDb);
	}
	catch(Exception e)
	{
		if(!s_conn.equals("CONNECTED"))
		{
			json.put("error",mappingInfo.getTextDescription("monitor.addnewtransaction.Connection could not be establised&#46"));
			response.getWriter().write(json.toString());
		}
		if (rs != null)
		{
			try
			{
				rs.close();
			}
			catch (Exception bug123)
			{
			}
		}
		try
		{
			egDb.releaseConnection(true);
			EgDbAdapterTypeUI.releaseObject(egDb);
		}
		catch(Exception ex)
		{
		}
	}
	ConfigSiteBean sitebean= new ConfigSiteBean();
	
	boolean isJS = false;
	//IniUI iniUI = IniUI.getInstance();
	String jsOption = 	iniUI.getValue("TOPOLOGY_OPTIONS","Javascript");
	if(jsOption!=null && jsOption.length() > 0)
	{
		if(jsOption.equalsIgnoreCase("yes") || jsOption.equalsIgnoreCase("true"))
		isJS = true;
	}

	String s_seglist = request.getParameter("seglist");
	//out.println(s_seglist);
	
	String segment = request.getParameter("segment");
	if(segment==null || segment.trim().length()==0)
		segment = request.getParameter("segmentVal");

	segment=(segment==null)?"":segment;
	String isSite = request.getParameter("isSite");
	if(segment!=null && segment.indexOf(",")>-1)
		segment = segment.substring(0,segment.indexOf(","));

	Vector v_seg = new Vector();
	String segmentList = "";
	segmentList = topoinfo.getValue("WEB_SITE_SEGMENTS","Web_site:" + site.trim());
	if(s_seglist==null || s_seglist.equals("") || s_seglist.equalsIgnoreCase("null"))
		s_seglist = segmentList;
	boolean isAService = sitebean.isAService(site);

	List v_segment_state = new LinkedList();
	Vector vec_seg = new Vector();
	if(s_seglist != null && s_seglist.indexOf(",") > -1)
	{
		StringTokenizer st = new StringTokenizer(s_seglist,",");
		while(st.hasMoreTokens())
		{
			vec_seg = new Vector();
			List row = new LinkedList();
			String thisSeg = st.nextToken().trim();
			if(thisSeg != null)
			{
				row.add(thisSeg);
				if(EgInstallInfo.isSuperManager)
				{
					ArrayList managerIDs = EgElementInfo.getInstance().getManagerIDs("service",service.trim());
					if(managerIDs != null && !managerIDs.isEmpty())
					{
						SmSessionData smsData = new SmSessionData(session.getId(),managerIDs);
						EgThreadLocal egtl = new EgThreadLocal();
						egtl.set(smsData);
					}
				}
				String thisSegState = (String)getStateForSegment(service.trim(),"SEG:"+thisSeg);
				if(thisSegState!=null)
					row.add(thisSegState);
			}
			v_segment_state.add(row);
			Object[] segments = v_segment_state.toArray();
			Arrays.sort(segments, new Sorter(AlarmPriorities.getStatesOrder(), true));
			for (int a=0; a<segments.length; a++)
			{
				List lis = (List)segments[a];
				String segmentName = (String)lis.get(0);
				if(segmentName!=null)
				{
					if(!vec_seg.contains(segmentName.trim()))
					{
						vec_seg.add(segmentName);
					}
				}
			}
		}
		if(vec_seg!=null && vec_seg.size()>0)
		{
			v_seg = new Vector();
			v_seg.addAll(vec_seg);
		}
	}
	int v_seg_size=(v_seg!=null)?v_seg.size():0;
	boolean trans_List=false;
	if(transactionList!=null && transactionList.size()<=0)
	{
		trans_List=true;
	}
	
	String serviceState="service20New_"+EgStateZone.getState("Service:"+site+":NULL");
	//json.put("serviceClass","state_footer_"+EgStateZone.getState("Service:"+site+":NULL"));
	json.put("serviceClass",serviceState);
	json.put("serviceName","Service : "+site);

	
	if((segment==null || segment.trim().length()==0) && segmentList!=null && segmentList.trim().length()>0)
	{
		segment=segmentList;
	}

	if(segment!=null && segment.indexOf(",")>0)
	{
		segment=segment.substring(0,segment.indexOf(","));
	}
	if(v_seg!=null && v_seg.size() > 0 && segment!=null && segment.trim().length()>0){
		selectFieldData.put("selectLabel",mappingInfo.getTextDescription("monitor.topology.Select a Segment"));
		boolean isSelect=false;
		for(int i=0;i<v_seg.size();i++){
			if(segment!=null && segment.trim().equals((String)v_seg.get(i)))
			{
				selectFieldData.put("selectedValue",(String)v_seg.get(i));
				isSelect = true;
			}
			JSONObject option  = new JSONObject();
			option.put("value",(String)v_seg.get(i));
			option.put("name",(String)v_seg.get(i));
			selectOptions.add(option);
		}

		if(!isSelect && v_seg.size()>0)
		{
			selectFieldData.put("selectedValue",(String)v_seg.get(0));
		}

		selectFieldData.put("serviceName",(String)service.trim());
		
		selectFieldData.put("selectOptions",selectOptions);
		json.put("selectFieldData",selectFieldData);
	}
	
	com.eg.EgAggregateInfo aggInfo = new com.eg.EgAggregateInfo("manager");

	if(isSite!=null && isSite.equalsIgnoreCase("true") && transactionList!=null && transactionList.size()<=0 && !aggInfo.isAggregateSite(site) && !EgInstallInfo.isClusterSupported){

		boolean isSiteConfirm = true;
		String selected_Param = request.getParameter("selectedParam");
		try{
			if(selected_Param != null && selected_Param.trim().length()>0){
				Vector componenetsByService = topoinfo.getComponentsForSite(selected_Param);
				if(componenetsByService != null && componenetsByService.size() > 0){
					for(int p=0;p<componenetsByService.size();p++){
						String acheck = (String)componenetsByService.get(p);
						if(acheck != null && acheck.endsWith(":Real_user_monitor")){
							isSiteConfirm = false;
						}else{
							isSiteConfirm = true;
							break;
						}
					}
				}
			}
		}catch(Exception  ee){
			ee.printStackTrace();
		}

		if(isSiteConfirm)
		{
			json.put("site",site);
			if(!EgInstallInfo.isSuperManager)
			{
				//Configure transaction button in not allowed in Supermanager.
				json.put("transactionLink","true");
			}
		}
	}
	json.put("transactionConfigLabel",mappingInfo.getTextDescription("monitor.topology.Configure Transactions"));
	if(isJS)
	{
		StringBuffer frameSrc = new StringBuffer(); 
		
		/**
		* final/monitor/EgServiceTopologyJS.jsp for Raphael JS Library
		* final/monitor/EgServiceTopologyD3JS.jsp for D3JS
		*/
		frameSrc.append("/final/monitor/EgServiceTopologyD3JS.jsp?2=2&physical_topology=0&type=monitor&treeFlag="+treeFlag+"&zoneName="+EgURLEncoder.encode(zoneName,"UTF-8")+"&currentTab="+currentTab+"&aggregateTab="+aggregateTab+"&openNode="+openNode+"&treeFlag="+treeFlag+"&fromHomepage="+fromHomepage+"&serviceGroup="+serviceGroup+"&iszoneName="+EgURLEncoder.encode(iszoneName,"UTF-8")+"&isFromZone="+isFromZone+"&parentZone="+parentZoneCheck+"&action="+action+"&serviceState="+serviceState);

		if(fromSuper!=null)
		{
			frameSrc.append("&fromSuper=yes&sessionId=");
			frameSrc.append(session.getId());
		}
		if(service!=null && !service.equals(""))
		{
			frameSrc.append("&service="+EgURLEncoder.encode(service.trim(),"UTF-8"));
		}

		if(topoSegCombo != null && topoSegCombo.length() > 0)
			frameSrc.append("&segment="+EgURLEncoder.encode(topoSegCombo.trim(),"UTF-8"));
		else if(segment!=null && segment.length() > 0)
			frameSrc.append("&segment="+EgURLEncoder.encode(segment.trim(),"UTF-8"));
		if(site!=null && site.length() > 0)
			frameSrc.append("&site="+EgURLEncoder.encode(site.trim(),"UTF-8"));
		    String graphData="<iframe id='serviceTopoIframeId' width='100%' height='100%' src='"+frameSrc+"' border='0' scrolling='no' marginwidth='0px' marginheight='0px' frameborder='0' color='blue' style='border-width:0px; border-style:solid; border-color:red;'></iframe>";
			json.put("graphData",graphData);			
	}
	else
	{
	String appletStr="<applet code='com.egurkha.EgTopology.class' codebase='/final/topology' align='center' id='my_applet' class='topoGraphAppDiv' width='935' height='480'>";
	       appletStr+="<param name='fromSuper' value='"+fromSuper+"'/>";
	       appletStr+="<param name='sessionId' value='"+session.getId()+"' />";
	       appletStr+="<param name='urlPrefix' value='"+EgInstallInfo.getUrlPrefix()+"' />";

			if(segment!=null && !segment.equals(""))
			{
				  appletStr+="<param name='segment' value='"+segment+"' />";
			}
	     
	       appletStr+="<param name='site' value='"+site+"' />";
		   appletStr+="<param name='serviceState' value='"+serviceState+"' />";
	       appletStr+="<param name='segList' value='"+segmentList+"' />";
	       if(service!=null && !service.equals(""))
			{
	    	   appletStr+="<param name='service' value='"+service+"' />";
			}
	       if(from!=null&&from.equals("layerModel"))
			{
	    	   appletStr+="<param name='r_uri' value='/final/monitor/EgTopoGraphApp.jsp'/>";
			}else
			{
				appletStr+="<param name='r_uri' value='/final/monitor/EgSiteInfraView.jsp'/>";
			}
	       appletStr+="<param name='r_port' value='"+request.getServerPort()+"' />";
	       appletStr+="<param name='r_host' value='"+request.getServerName()+"' />";
	       appletStr+="<param name='r_protocol' value='"+request.getProtocol()+"' />";
	       appletStr+="<param name='canvasType' value='monitor' />";
	       appletStr+="<param name='fromPage' value='serviceDashboard' />";
	       appletStr+="<param name='frameName' value='_parent' />";
	       appletStr+="<param name='urlFinal' value = '"+request.getScheme()+":"+request.getServerPort()+""+request.getContextPath()+"' />";
	       appletStr+="<param name='border' value='yes'>";
	       appletStr+="<param name='border_color' value='000000'>";
	       appletStr+="</applet>";
		   json.put("graphData",appletStr);
	}
		String qString=request.getQueryString();
	if(qString!=null)
	{
		/*if(null!=transactionsFlag && transactionsFlag.equals("true")){
			qString+="&outsideService=true&serviceFromZone="+site+"&showDashboard='3'";
		}else{
			qString+="&outsideService=true&serviceFromZone="+site+"&showDashboard='2'";
		}*/
		if(qString.indexOf("action")>-1)
		{
			session.setAttribute("monitorLastSession","/final/monitor/serviceDashboard.jsp?monCmd=serviceList&from=MainDashboard&"+qString);
		}
		else
		{
			session.setAttribute("monitorLastSession","/final/monitor/serviceDashboard.jsp?monCmd=serviceList&from=MainDashboard&refresh=true&action=service&"+qString);
		}
	}
	else
	{
		session.setAttribute("monitorLastSession","/final/monitor/serviceDashboard.jsp?monCmd=serviceList&from=MainDashboard& outsideService=true&serviceFromZone=AllComponentsService");
	}
	response.getWriter().write(json.toString());
}
catch(Exception e)
{
	response.getWriter().write("Exception in egTopographApp..:"+e);
	//response.getWriter().write(e.printStackTrace());
}
%>
<%!
	public String getStateForSegment(String serviceName, String segmentName)
	{
		ServiceDAO dao = MonitorDAOFactory.getInstance().getServiceDAO();
		return dao.getStateForSegment(serviceName, segmentName);
	}
%>


