<%
/*****************************************************************************************************
 *	Name			:	EgQInsightHome.jsp
 *	Version			:	eG 3.1
 *	Purpose			:	Display tier,server and metric information and values.
 *	Creation Date	:	19-01-2004.
 *	Author			:	Bala Murali
 *	Last Modified	:	
 *****************************************************************************************************/
%>
<%@ include file="EgTrackerJSON.jsp" %>
<%@ page import = "java.util.*" %>
<%@ page import = "net.sf.json.*" %>
<%@ page import = "com.egurkha.User" %>
<%@ page import = "com.egurkha.UserRegistry" %>
<%@ page import = "com.egurkha.monitor.EgQInsightView" %>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	JSONObject rootJSON = new JSONObject();
	
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String s_insightName = request.getParameter("view_name");
	if(s_insightName != null)
	{
		 s_insightName=com.egurkha.util.StringUtils.replace(s_insightName,"'","~#~");		  s_insightName=com.egurkha.util.StringUtils.replace(s_insightName,"&","|amp|");
	}
	int tierPos = Integer.parseInt(request.getParameter("tier_position")) - 1 ;
	int serverPos = Integer.parseInt(request.getParameter("server_position")) - 1;
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");

	User user = UserRegistry.getInstance().getUser(session.getId());
	EgQInsightView insightView = user.getQInsightView(s_insightName);
	int noOfServers = insightView.getNoOfServersPerTier();
	int noOfMetrics = insightView.getNoOfMetricsPerServer();
	String arr_metrics[] = request.getParameterValues("metric_list");
	String arr_servers[] = request.getParameterValues("server_list");
	Object arr_metricInfo[] = new Object[arr_metrics.length];
	int arr_metricIdx[] = new int[arr_metrics.length];

	for(int i=0;i<arr_metrics.length;i++)
	{		
		int index = insightView.getMetricIndex(tierPos,serverPos,arr_metrics[i]);
		arr_metricIdx [i] = index;
		arr_metricInfo[i] = insightView.getMetricInfo(tierPos,serverPos,index);
	}
	String tierName=request.getParameter("hidPreTierName");
	tierName=(tierName==null)?"":tierName;
	String serverName=request.getParameter("hidPreServerName");
	serverName=(serverName==null)?"":serverName;

	for(int i=0;i<arr_servers.length;i++)
	{
		int serverIdx = insightView.getServerIndex(tierPos,arr_servers[i]);
		String s_compTy =insightView.getServerInfo(tierPos,serverIdx)[insightView.SERVER_COMP_IDX];
		s_compTy = s_compTy.substring(s_compTy.lastIndexOf(":")+1);
		for(int j=0;j<arr_metrics.length;j++)
		{			
			String s_metricName = arr_metrics[j];			
			String  metricInfo[] =(String[])arr_metricInfo[j];
			String s_testName = metricInfo[insightView.METRIC_TEST_IDX];
			String s_measName = metricInfo[insightView.METRIC_MEASURE_IDX];
			String s_info = metricInfo[insightView.METRIC_INFO_IDX];
			String s_site = metricInfo[insightView.METRIC_SITE_IDX];
			if(!specsInfo.isTestRelevantForServer(s_compTy,s_testName))
				continue;
			if(s_metricName.length()>64)
				s_metricName = s_metricName.substring(0,64);
			int metricIdx = insightView.getMetricIndex(tierPos,serverIdx,s_metricName);
			if(metricIdx !=-1 && metricIdx != arr_metricIdx[j])
			{
				int suffix = 0;
				//if(s_metricName.length()>12)
					//s_metricName = s_metricName.substring(0,12);
				do
				{
					s_metricName += "_" + (++suffix) ;
					metricIdx = insightView.getMetricIndex(tierPos,serverIdx,s_metricName);
				}while(metricIdx !=-1 && metricIdx != arr_metricIdx[j]);
			}			
			insightView.setMetric(tierPos,serverIdx,arr_metricIdx[j],s_metricName,s_testName,s_measName,s_info,s_site);
			AuditLogThread auditLogThread = new AuditLogThread();	
			auditLogThread.setValue("User_id",user.getLoginID());
			auditLogThread.setValue("Host_ip",user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Category","Monitor");
			auditLogThread.setValue("Module","Quick Insight");
			auditLogThread.setValue("Activity","Quick Insight Copy Metrics");

			if(s_insightName != null)
			{
				 s_insightName=com.egurkha.util.StringUtils.replace(s_insightName,"~#~","'");
				 s_insightName=com.egurkha.util.StringUtils.replace(s_insightName,"|amp|","&");
			}
			auditLogThread.setCurrentValue("01~~View Name",s_insightName.trim());
			auditLogThread.setCurrentValue("02~~Tier Name",tierName.trim());
			auditLogThread.setCurrentValue("03~~Server Name",serverName.trim());
			auditLogThread.setCurrentValue("04~~Server",arr_servers[i].trim());
			auditLogThread.setCurrentValue("05~~Metric",arr_metrics[j].trim());

			auditLogThread.setValue("Description","Quick Insight Metrics Copied");
			auditLogThread.sendItToDB();
			rootJSON.put("result","success");
		}
	}
	out.println(rootJSON.toString());
%>
