<%
/********************************************************************************
FileName	:egUptimeSummary.jsp
Purpose		:This is created for Uptime Summary for Systems/Network Devices
Created by	:Rajesh.P
Created on	:09/07/2009
**********************************************************************************/
%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EgServerDashboardTracker.jsp"%>
<%@ page errorPage = "EgProbsM.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="egurkha.reporter.uptime.*" %>
<%@ page import="java.util.*"%>
<%@ page import="java.text.*"%>
<%@ page import = "egurkha.reporter.ErUtils"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import = "com.egurkha.util.DateTimeTokenizer"%>
<%@ page import = "com.eg.EgDateInfo"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String hostName=request.getParameter("hostName");
	String upTimeType=request.getParameter("upTimeType");
	String s_iniFile_dir=EgInstallInfo.getInstallDir()+"/manager/config/";


	String compType=request.getParameter("compType");

	String dashboardIni = "eg_serverdashboard.ini";
	if(compType!=null && compType.startsWith("Agg_"))
	{
		dashboardIni = "eg_aggregateserverdashboard.ini";
	}

	IniFile iniObj=new IniFile(s_iniFile_dir+dashboardIni);

	java.util.Date endDate=new java.util.Date();
	java.util.Date uptimeStartDate=new java.util.Date(endDate.getTime()-(24*60*60*1000));

	String timeline=iniObj.getValue("Default_UpTimeSummary_Duration","duration");
	if(timeline==null && timeline.equals(""))
	{
		timeline="24 hours";
	}
	int value=0;
	int timeValue=0;

	String unit="";

	String uptimeStartTime=request.getParameter("uptimeStartTime");
	String uptimeEndTime=request.getParameter("uptimeEndTime");

	if(timeline!=null && !timeline.equals("") && !timeline.equalsIgnoreCase("any"))
	{
		timeline=timeline.trim();
		int blankSpaceIndex = timeline.indexOf(DateTimeTokenizer.BLANK_SPACE);
		
		EgDateInfo edi = new EgDateInfo();
		Date today = edi.egetRealDate();
		Date start = edi.egetRealDate();

		if (blankSpaceIndex > 0)
		{
			SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
			SimpleDateFormat dateFormat=new SimpleDateFormat("MM/dd/yyyy");
			value = Integer.parseInt(timeline.substring(0, blankSpaceIndex));
			timeValue=Integer.parseInt(timeline.substring(0, blankSpaceIndex));
			unit = timeline.substring(blankSpaceIndex+1).toLowerCase();
			if (unit.startsWith("h"))
			{//hours
				value *= 3600;
			}
			else if (unit.startsWith("d"))
			{//days
				value *= (24 * 3600);
			}
			else if (unit.startsWith("w"))
			{//weeks
				value *= (7 * 24 * 3600);
			}
			else if (unit.startsWith("mo"))
			{//months
				value *= (30 * 24 * 3600);
			}
			long longValue=value;

			start.setTime(today.getTime() - (longValue * 1000));

			uptimeEndTime=sdf.format(today);
			uptimeStartTime=sdf.format(start);
		}
	}

	String componentlist[]={hostName};
	String shr="00";
	String enhr="24";
	String stmin="00";
	String enmin="00";
	ErUptimeReportBean repoterBean=new ErUptimeReportBean();
	ErUptimeDowntimeBean uptimeBean = repoterBean.getUptimeDownDetails(componentlist,uptimeStartTime,uptimeEndTime,shr,enhr,stmin,enmin,upTimeType);
	String totalUptime=uptimeBean.getUpTime();
	if(totalUptime!=null && !totalUptime.equals("") && !totalUptime.equalsIgnoreCase("null"))
	{
	/*	totalUptime=com.egurkha.util.StringUtils.replace(totalUptime," s "," Seconds(s) ");
		totalUptime=com.egurkha.util.StringUtils.replace(totalUptime," h "," Hour(s) ");
		totalUptime=com.egurkha.util.StringUtils.replace(totalUptime," d "," Day(s) ");
		totalUptime=com.egurkha.util.StringUtils.replace(totalUptime," M "," Month(s) ");
		totalUptime=com.egurkha.util.StringUtils.replace(totalUptime," m "," Min(s) ");*/
	}
	else
	{
		totalUptime="-";

	}
	String upTimePercent=uptimeBean.getPerUpTime();
	if(upTimePercent==null || (upTimePercent!=null && (upTimePercent.equals("") || upTimePercent.equalsIgnoreCase("null"))))
	{
		upTimePercent="-";
	}
	String downTime=uptimeBean.getDownTime();
	if(downTime!=null && !downTime.equals("") && !downTime.equalsIgnoreCase("null"))
	{
	/*	downTime=com.egurkha.util.StringUtils.replace(downTime,"s","Seconds(s)");
		downTime=com.egurkha.util.StringUtils.replace(downTime,"h","Hour(s)");
		if(downTime!=null && downTime.indexOf("d")>0)
		{
			downTime=com.egurkha.util.StringUtils.replace(downTime,"d","Day(s)");
		}
		else if(downTime!=null && downTime.indexOf("D")>0)
		{
			downTime=com.egurkha.util.StringUtils.replace(downTime,"D","Day(s)");
		}
		downTime=com.egurkha.util.StringUtils.replace(downTime,"M","Month(s)");
		downTime=com.egurkha.util.StringUtils.replace(downTime,"m","Min(s)");*/
		
	}
	else
	{
		downTime="-";
	}
	String downTimePercent=uptimeBean.getPerDownTime();
	if(downTimePercent==null || (downTimePercent!=null && (downTimePercent.equals("") || downTimePercent.equalsIgnoreCase("null"))))
	{
		downTimePercent="-";
	}
	int noOfReboots=uptimeBean.getNoOfReboots();
	boolean isShowDetails=uptimeBean.isShowDetails();
	List uptimeData = uptimeBean.getRebootHistoryForMonitor();
	ErUptimeData data = null;
	boolean compFound = false;
	for(int i=0; i<uptimeData.size(); i++) {
		data = (ErUptimeData)uptimeData.get(i);
		if(data.getTrgtHost().equals(hostName)) {
			compFound = true;
			break;
		}
	}
	List shutdownList = new ArrayList();
	List rebootList = new ArrayList();
	List durationList = new ArrayList();
	if(compFound) {
		rebootList = data.getFilteredReboot();
		shutdownList = data.getFilteredShutdown();
		durationList = data.getFilteredDuration();
	}
%>
	<table border="0" cellspacing="0" cellpadding="0" valign="top" >
		<tr>
			<td>
				<div style="width:49%;float:left;border:0px red solid;padding:2px">
					<table border="0" cellspacing="0" cellpadding="0" valign="top"  width="100%" height="100%">
						<tr>
							<td class="gradient_header">
								<table border="0" cellspacing="0" cellpadding="4" width="100%" >
									<tr>
										<td style="padding-left:4px"  class="eg_75bold " width="100%" ><egui:intnl text="monitor.dashboard.Uptime"/>/<egui:intnl text="monitor.dashboard.Downtime Summary"/> - <egui:intnl text="monitor.dashboard.Last"/> <%=timeline%></td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td valign="top"class="eg_whitebg vmborder">
								<table border="0"class="tableborder_jvm"  cellspacing="0" cellpadding="4" width="100%"  valign="top">
									<tr>
										<td valign="top" class="tdborder_jvm"><egui:intnl text="monitor.dashboard.Total Uptime"/></td>
										<td valign="top" class="tdborder_jvm" ><%=totalUptime%></td>
									</tr>
									<tr>
										<td valign="top" class="tdborder_jvm" ><egui:intnl text="monitor.dashboard.Total Uptime"/> (%)</td>
										<td valign="top" class="tdborder_jvm" ><%=upTimePercent%></td>
									</tr>
									<tr>
										<td valign="top" class="tdborder_jvm" ><egui:intnl text="monitor.dashboard.Total Downtime"/></td><td valign="top" class="tdborder_jvm" ><%=downTime%></td>
									</tr>
									<tr>
										<td valign="top" class="tdborder_jvm" ><egui:intnl text="monitor.dashboard.Total Downtime"/> (%)</td><td valign="top" class="tdborder_jvm" ><%=downTimePercent%></td>
									</tr>
									<tr>
										<td valign="top" class="tdborder_jvm" ><egui:intnl text="monitor.dashboard.No Of Reboots"/></td><td valign="top" class="tdborder_jvm" ><%=noOfReboots%></td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</div>
				<div style="width:49%;float:left;border:0px red solid;padding:2px">
					<table border="0" cellspacing="0" cellpadding="0" valign="top"  width="100%" >
						<tr>
							<td class="gradient_header">
								<table border="0" cellspacing="0" cellpadding="4" width="100%">
									<tr>
										<td class="eg_75bold " style="padding-left:4px"><egui:intnl text="monitor.dashboard.Reboot Summary"/> - <egui:intnl text="monitor.dashboard.Last"/> <%=timeline%></td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td valign="top" class="eg_whitebg vmborder" height="106px">
								
<%
		if(isShowDetails)
		{
%>
								<div id="div_scroll" style="border:0px solid #ff0000;height:106px">
									<table border="0"  cellspacing="0" cellpadding="4" width="100%"  style="table-layout:fixed" valign="top" class="tableborder_jvm">
										<tr>
											<td  align="center" class="tdborder2_jvm eg_75bold" ><egui:intnl text="monitor.dashboard.Shutdowned At"/></td>
											<td  align="center" class="tdborder2_jvm eg_75bold" ><egui:intnl text="monitor.dashboard.Rebooted At"/></td>
											<td  align="center" class="tdborder2_jvm eg_75bold" ><egui:intnl text="monitor.dashboard.Duration"/></td>
										</tr>
<%
			String uiFile = "eg_ui.ini";
			com.eg.IniFile egUI = new com.eg.IniFile(s_iniFile_dir + uiFile);
			String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
			SimpleDateFormat rsdf = new SimpleDateFormat(currentDateFormat+" HH:mm:ss");

			for(int i=0; i<shutdownList.size(); i++) 
			{
				String shutTime = rsdf.format(((Calendar)shutdownList.get(i)).getTime());
				String rebootTime = rsdf.format(((Calendar)rebootList.get(i)).getTime());
%>
										<tr>
											<td valign="top" class="tdborder_jvm"><%=shutTime%> </td>
											<td valign="top" class="tdborder_jvm"><%=rebootTime%> </td>
											<td valign="top" class="tdborder_jvm"><%=durationList.get(i) + " Mins"%> </td>
										</tr>
<%
			}
		%>
									</table>
								</div>
		<%
		}
		else
		{
		%>
								<div style="border:0px solid #ff0000;height:106px">
									<table  border="0"  cellspacing="0" cellpadding="4" width="100%" height="100%">
										<tr>
											<td align="center" style="width:450px;padding:2 2 2 2" class="eg_errorsmall"  valign="middle"><img src="/final/monitor/eg_images/exclamation-icon.gif"><br ><egui:intnl text="monitor.common.No Reboots Done"/>!</td>
										</tr>
									</table>
								</div>
		<%
		}
		%>
							</td>
						</tr>
					</table>
				</div>
			</td>
		</tr>
	</table>