<%
/*******************************************************************************
*	File name		: egSummaryView.jsp
*	Purpose			: To display Summary Data for Application
*	Version			: eG 4.3
*	Creation Date	: 20/03/2009
*	Authtor			: Antony
******************************************************************************/
%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EgLoginTracker.jsp"%>
<%@ page errorPage = "EgProbsM.jsp"%>
<%@ page import="com.egurkha.monitor.*"%>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import="com.eg.*" %>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String s_iniFile_dir=EgInstallInfo.getInstallDir()+"/manager/config/";

	IniFile iniObj=new IniFile(s_iniFile_dir+"eg_dashboard.ini");
	IniUI ui = IniUI.getInstance();

	String compName=request.getParameter("hostName");
	String compType=request.getParameter("compType");
	String  module=request.getParameter("subsystem");

	MonitorDAOFactory	monitorDaoFactory = MonitorDAOFactory.getInstance();
	EgDashBoardDAO dashboardDAO=monitorDaoFactory.getDashBoardDAO();
	EgDashBoardModel  egDashboard=new  EgDashBoardModel();

	EgExternalInfo egExternalInfo=new EgExternalInfo("manager");
	EgDbInfo dbInfo=new EgDbInfo("manager");
	EgTesterInfo testerInfo=new EgTesterInfo("manager");

	EgDashboardMGraphModel measureGraph=new EgDashboardMGraphModel();

	String subject=compType;
	String hostName="";
	String portNo="";
	String sid="";

	if(compName!=null && !compName.equals(""))
	{
		StringTokenizer st=new StringTokenizer(compName,":");

		if(st.hasMoreTokens())
			hostName=st.nextToken();

		if(st.hasMoreTokens())
			portNo=st.nextToken();

		if(st.hasMoreTokens())
			sid=st.nextToken();
	}

	String msmtHost="";
	String siteName="NULL";
	String testName="ProcessTest";

	Vector measures=new Vector();
	measures.add("Num_procs_running");
	measures.add("Cpu_util");
	measures.add("Memory_util");

	List agents=egExternalInfo.getAgentsFor(testName,compType,hostName);
	if(agents!=null && agents.size()>0)
		msmtHost=(String)agents.get(0);
	else
		msmtHost=hostName;

%>
	<div class="div_scroll" style="height:103px;border:0px solid #ff0000;" >
	<table cellspacing="0" cellpadding="2" class="tableborder_jvm"  border="0" ><col width="160px"><col width="50px"><col width="120px"><col width="120">
<%
	Vector allInfos=measureGraph.getAllInfoForTest(compType,compName,testName);
	if(allInfos!=null && allInfos.size()>0)
	{
%>
		<tr>
			<td class="eg_75bold tdborder" style="padding-top:0px;padding-bottom:0px"><egui:intnl text ="monitor.dashboard.Process"/></td>
			<td class="eg_75bold tdborder"><egui:intnl text ="monitor.dashboard.Count"/></td>
			<td class="eg_75bold tdborder">% <egui:intnl text ="monitor.dashboard.CPU"/></td>
			<td class="eg_75bold tdborder">% <egui:intnl text ="monitor.dashboard.Memory"/></td>
		</tr>

<%
	for(int i=0;i<allInfos.size();i++)
	{
		String info=(String)allInfos.get(i);
		info=com.egurkha.util.StringUtils.replace(info,"*","+");
		info=com.egurkha.util.StringUtils.replace(info,"|plus|","+");

		String infoForDisp=com.egurkha.util.StringUtils.replace(info,"+","");
		infoForDisp=com.egurkha.util.StringUtils.replace(info,"*","");
		infoForDisp=infoForDisp.substring(1,infoForDisp.length());
			String tmpMeasure=(String)measures.get(i);
			String layerName=dashboardDAO.getLayerForTest(compType,testName,tmpMeasure);
			String priority=dashboardDAO.getMeasurePriority(hostName, compType, layerName,testName,info,tmpMeasure,msmtHost);
			String url="/final/monitor/egDashBoardLayers.jsp?qctr=2&fromalarm=1&host="+compName+"&comptype="+compType+"&layer="+layerName+"&site=NULL&test="+testName+"-+"+info+"&tstate="+priority+"&msmt_host="+msmtHost;
%>
		<tr>
			<td class="tdborder_jvm" valign="top"><a class = "eg_monlink" href ='javascript:goToLayerModel("<%=url%>");'><%=infoForDisp%></a></td>
<%
		for(int j=0;j<measures.size();j++)
		{
			String measure=(String)measures.get(j);
				String measureForDB=dbInfo.getColumnForMeasure(testName,measure);
				String currentValue=dashboardDAO.getCurrentMeasure(hostName,compType,portNo,info,testName,measureForDB,msmtHost);

			if(!measure.equals("NUM_PROC"))
			{
				double currentValueInDouble=Double.parseDouble(currentValue);
				if(currentValueInDouble>0)
				{
%>
		
			<td class="tdborder_jvm" valign="top">
				<table cellspacing="0" cellpadding="0"  border="0" width="100%">
					<tr>
						<td style="width:35px"><a class = "eg_monlink" href ='javascript:goToLayerModel("<%=url%>");'><%=currentValue%></a></td>

						<td align="left" style="width:85px">
							<table width="85px" cellpadding="0" cellspacing="0" border="0"  height="8" class="prog_border">
								<tr>
									<td align="left" width="100%" height="8" class="cpu_free">
										<table width="<%=currentValue%>%" height="8"  cellpadding="0" cellspacing="0" border="0">
											<tr>
												<td class="cpu_usuage" width="100%"><img src="/final/monitor/eg_images/spacer.gif" alt="<%=currentValue%>"></td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
<%
				}
				else
				{
%>
			<td class="tdborder_jvm">-</td>
<%
					}
				}
			else
			{
				if(!testerInfo.getAllowNegativeValues(testName,measure) && currentValue!=null && currentValue.startsWith("-"))
				{
					currentValue = "-";
				}
%>
			<td class="tdborder_jvm" valign="top"><a class = "eg_monlink" href ='javascript:goToLayerModel("<%=url%>");'><%=currentValue%></a></td>
<%
				}
			}
%>
		</tr>
<%
		}
	}
	else
	{
%>
		<tr>
			<td colspan="4" align="center" height="97px" valign="middle" style="width:450px">
				<table border="0" cellpadding="0" cellspacing="0" width="100%" height="100%">
					<tr>
						<td align="center" height="100%"  width="100%" valign="middle"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"><br > <egui:intnl text="monitor.dashboard.No process configured"/>!</td>
					</tr>
				</table>
			</td>
		</tr>
<%
	}
%>
	</table>
</div>