
<%
   /*******************************************************************************
   *	File name			:	dispComponentGraphs.jsp
   *	Purpose				:	This program gets the site,host and test names as parameters and
								   returns the measurements and states
   *	Version				:	eG 3.0
   *	Creation Date		:	17-07-2000
   *	Last Modified		:	27-08-2003	-	John Williams		-	eG 3.0 Modifications
   *	Design Changes		:	Jaiwin (11th June 2008)
   *								26-09-2003	-	John Williams		-	Footer Page Include
			   					20/12/2011  Sri Devi G User - VM Changes
   *	Authtor				:	Balamurugan V
   ******************************************************************************/
%>
<%@ include file = "EgMonitorTracker.jsp"%> 
<%@ page errorPage = "EgProbsM.jsp" %>
<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ page import = "com.egurkha.ini.*"%>
<%@ page import = "com.egurkha.monitor.alarms.AlarmPriorities"%>
<%@ page import = "java.sql.*"%>
<%@ page import = "java.util.*"%>
<%@ page import = "java.io.*"%>
<%@ page import = "java.net.*"%>
<%@ page import = "java.text.SimpleDateFormat"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.eg.EgLastMeasureThread"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "egurkha.reporter.ErUtils" %>
<%@ page session = "true"%>
<%@ page import = "com.eg.EgTablesInfo" %>
<%@ page import = "com.eg.EgMappingInfo" %>
<%@ page import = "com.egurkha.util.DateTimeTokenizer" %>
<%@ page import = "com.egurkha.EgMeasureGraphExt" %>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import ="com.egurkha.monitor.*"%>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import="egurkha.TestStatusInfo"%>
<%@ page import="com.eg.SidCheck" %>
<%@ page import="com.egurkha.*" %>
<%@page import = "egurkha.reporter.*"%>
<%@ page import="net.sf.json.*"%>
<%
try
{
	/* This is for SuperManager - starts */
	if(com.eg.EgInstallInfo.isSuperManager)
	{
		String hostname = request.getParameter("host");
		if(hostname != null)
		{
			if(hostname.indexOf(":")>-1)
			{
				hostname = hostname.substring(0,hostname.indexOf(":"));
			}
			ArrayList managerIds = EgElementInfo.getInstance().getManagerIDs("component",hostname);
			if(managerIds != null && !managerIds.isEmpty())
			{
				SmSessionData smsData = new SmSessionData(session.getId(),managerIds);
				EgThreadLocal egtl = new EgThreadLocal();
				egtl.set(smsData);
			}
		}
	}
	/* This is for SuperManager - ends */

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	response.setContentType("application/json");

	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI ui = IniUI.getInstance();
	String isCsrfPreventionEnabled = ui.getValue("Security_Filters","CSRFPreventionFilter");

	String s_sid = null;
	String thisLanguage =ui.getDefaultLanguage();
	if (user!=null)
	{
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	String userFormat=user.getUserDateFormat();
	boolean isUserLanguageEnglish=true;
	if(thisLanguage!=null && !thisLanguage.equals("en_US"))
	{
		isUserLanguageEnglish=false;
	}
	//User u_ser = null;
	//boolean from_sm = false;
	//String sessionId_sm = null;
	//String u_rs = null;
	//long u_v_till = 0L;
	//long l_accessed = 0L;
	//boolean id_u = false;
	if(session.getAttribute("sessionId_SM") != null)
	{
		from_sm = true;
		sessionId_sm = (String)session.getAttribute("sessionId_SM");
	}
	if(session!=null)
	{
		if(from_sm)
		{
			u_ser = UserRegistry.getInstance().getUser(sessionId_sm,true);
		}
		else
		{
			u_ser = UserRegistry.getInstance().getUser(session.getId(),true);
		}
		if(u_ser!=null)
		{
			id_u = u_ser.isIdDeletedWhileLoggedIn();
			if(id_u == false)
			{
				u_rs =  u_ser.getLoginID();
				if(!User.isDefaultUser(u_rs))
				{
					ErUserData er = u_ser.getReporterData();
					u_v_till = er.getUserValidtill();
					l_accessed = session.getLastAccessedTime();
				}
			}
		}
	}
	//EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	EgTablesInfo TableData = new EgTablesInfo("manager");
	EgDbInfo MeasureDisplay = new EgDbInfo("manager");
	ErUtils erUtils = new ErUtils();

	EgTimeZoneConverter timeZoneConverterStart=null;
	EgTimeZoneConverter timeZoneConverterEnd=null;
	EgTimeZoneConverter timeZoneConverter = null;
	String startDateForDisplay = null;
	String startHourForDisplay = null;
	String endDateForDisplay = null;
	String endHourForDisplay = null;
	String startMinForDisplay=null;
	String endMinForDisplay=null;

	String str_site, str_host, str_port, str_layer, str_test, str_info, str_hst_info, str_time, s_definfo, s_glink, s_aglink, s_mes, s_st_time, s_st_hr, s_en_time, s_en_hr;
	StringTokenizer st = null;
	String [] str_mes_list = null;
	String s_qstr      = null;
	String s_qstr_state = null;
	Vector v_mes = new Vector();
	Vector v_mes_case = new Vector();
	String timeLine ="";
	String comFormat = "";
	String s_vm = "";
	String dateFormatForDatePick = (String)user.getUserDateFormat();
	//String[] options = {"Any","1 hour", "2 hours", "3 hours", "6 hours", "12 hours", "18 hours", "24 hours", "2 days", "3 days", "4 days", "5 days", "6 days"};

	//String[] options = {"Any","1 hour", "2 hours", "3 hours", "6 hours", "12 hours","15 hours", "18 hours","21 hours","24 hours", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks","3 weeks","1 month","2 months"};
	String[] options = {"Any","1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","21 hours","24 hours","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","3 weeks","4 weeks","1 month","2 months"};
	
	Vector time_line=new Vector();
	time_line.addAll(Arrays.asList(options));

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	boolean isGraph = false;
	String fromPage=request.getParameter("fromPage");
	fromPage=(fromPage==null || fromPage.trim().length()==0)?"":fromPage;
	
	String dashConfigFile = "eg_dashboardConfig.ini";
	IniFile dashConfigIniFile = new IniFile(s_iniFile_dir + dashConfigFile);

	//MeasureDisplay.checkForUpdate();
	str_site = request.getParameter("site");
	if(str_site == null)
	{
		str_site = request.getParameter("siteReuse");
	}
	str_port = request.getParameter("port");
	str_test = request.getParameter("test");
	str_layer = request.getParameter("layer");
	str_info = request.getParameter("info");
	str_info=com.egurkha.util.StringUtils.replace(str_info,"|dot|",".");
	str_info=com.egurkha.util.StringUtils.replace(str_info,"|bslash|","/");

	str_info = com.egurkha.util.StringUtils.decodeSecurityChar(str_info);
	str_host = request.getParameter("host");
	s_st_time = request.getParameter("starttime");
	s_en_time = request.getParameter("endtime");
	s_st_hr = request.getParameter("starthr");
	s_en_hr = request.getParameter("endhr");
	String s_st_min = request.getParameter("startmin");
	String s_end_min = request.getParameter("endmin");
	timeLine = request.getParameter("timeLine");
	String compType=request.getParameter("comptype");
	String	comp_name_withPort="";
	String tabSetPage = request.getParameter("tabSetPage");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	boolean portRelevantForTest=true;
	if(str_test != null && str_test.trim().length()>0)
	{
		portRelevantForTest = specsInfo.isPortRelevantForTest(str_test);
	}
	boolean isVM = false;
	s_vm = request.getParameter("isVM");
	if(s_vm!=null) //modified by Satheesh on 17/04/2012
		isVM = (new Boolean(s_vm)).booleanValue();

	//For Range selection
	String rangech="";
	String  sd_min="";
	String  sd_max="";
	Double r_min=null;
	Double r_max=null;

	String showrange=request.getParameter("showRange");
		if(showrange==null)
			 showrange="Range";
	if(request.getParameter("maxrange")!=null && request.getParameter("minrange")!=null && showrange!=null && showrange.equalsIgnoreCase("RANGE"))
	{
		rangech="CHECKED";
		{
			sd_min=request.getParameter("minrange");
			sd_max=request.getParameter("maxrange");
		}
	}
	else if(r_min!=null  && r_max!=null)
	{
		sd_min="";
		sd_max="";
	}
	String selectedTimeline ="";
	if(timeLine==null)//modified by stalin on 07/01/08
	{
		selectedTimeline= iniFile.getValue("GRAPHS","DATA_DISPLAY");
		if(selectedTimeline.equals("1"))
			timeLine =selectedTimeline+" "+"hour";
		else
			timeLine =selectedTimeline+" "+"hours";
	}

	// To get test frequency
	TestStatusInfo testtnfo=new TestStatusInfo();
	String s_frequencyOfTest = null;
	
	if(compType != null && compType.equalsIgnoreCase("Oracle_server")){
		if(compType != null && compType.trim().length() > 0 && str_host != null && str_host.trim().length() > 0 && str_port != null && str_port.trim().length() > 0 && str_test != null && str_test.trim().length() > 0 )
		{
			String tempInfo = str_info;
			if(tempInfo != null && tempInfo.trim().length() > 0)
			{
				if(tempInfo.indexOf("*")>0)
				{
					tempInfo = tempInfo.substring(0,tempInfo.indexOf("*"));

					s_frequencyOfTest = testtnfo.frequencyOfTest(compType,str_host +":"+str_port+":"+tempInfo,str_test);
				}
				else
				{
					s_frequencyOfTest = testtnfo.frequencyOfTest(compType,str_host + ":" + str_port,str_test);
				}
			}
		}
	}
	else
	{
		if(compType != null && compType.trim().length() > 0 && str_host != null && str_host.trim().length() > 0 && str_port != null && str_port.trim().length() > 0 && str_test != null && str_test.trim().length() > 0 )
		{
			s_frequencyOfTest = testtnfo.frequencyOfTest(compType,str_host + ":" + str_port,str_test);
		}
	}
	
	String initime[]= iniFile.getVariables("GRAPH_TIMELINE_SETTINGS");
	int largetst = 0;
	int fre = 0;
	int frehours = 0;
	int stime=0;
	String sliderchange = request.getParameter("sliderchange");
	boolean sliderchangetime = ( sliderchange != null && sliderchange.trim().length() > 0 && sliderchange.equalsIgnoreCase("true") )?true:false;
	if(s_frequencyOfTest!=null && !s_frequencyOfTest.equalsIgnoreCase("Not Applicable"))
	{
		try
		{
			fre=Integer.parseInt(s_frequencyOfTest);
		}
		catch(Exception ee)
		{
			fre=0;
		}
	
		if(fre > 0)
		{
			frehours = fre / 3600;
		}
	}

	if(initime!=null && initime.length>0)
	{
		largetst = Integer.parseInt(initime[0]);
		for(int j=0;j<initime.length;j++)
		{
			if(Integer.parseInt(initime[j])>largetst)
			{
				largetst=Integer.parseInt(initime[j]);
			}
		}
	}
	else
	{
		largetst=18;
		String[] initime1 = new String[]{"1", "3", "9","18"};
		for(int i=0;i<initime1.length;i++)
		{
			if(Integer.parseInt(initime1[i])>=frehours)
			{
				if(initime1[i].equalsIgnoreCase("1"))
				{
					timeLine ="3 hours";
				}
				else if(initime1[i].equalsIgnoreCase("3"))
				{
					timeLine ="6 hours";
				}
				else if(initime1[i].equalsIgnoreCase("9"))
				{
					timeLine ="12 hours";
				}
				else if(initime1[i].equalsIgnoreCase("18"))
				{
					timeLine ="1 day";
				}
				break;
			}
		}
	}

	if(timeLine != null && timeLine.trim().length() > 0 && !timeLine.equalsIgnoreCase("Any"))
	{
		if(s_frequencyOfTest!=null && !s_frequencyOfTest.equalsIgnoreCase("Not Applicable"))
		{
			int blankSpaceIndex = timeLine.indexOf(DateTimeTokenizer.BLANK_SPACE);
			if (blankSpaceIndex > 0)
			{
				int digit = Integer.parseInt(timeLine.substring(0, blankSpaceIndex));
				String letter = timeLine.substring(blankSpaceIndex+1).toLowerCase();
				if (letter.startsWith("h"))
				{
					digit *= 3600;
				}
				else if (letter.startsWith("d"))
				{
					digit *= (24 * 3600);
				}
				else if (letter.startsWith("w"))
				{
					digit *= (7 * 24 * 3600);
				}
				else if (letter.startsWith("mo"))
				{
					//value *= (30 * 24 * 3600);
					digit *=((ErUtils.getMaxDaysInMonth()) * 24 * 3600);
				}
				stime=digit/3600;
			}

			if(frehours<stime)
			{
				if(selectedTimeline!=null && selectedTimeline.trim().length()>0)
				{
					if(selectedTimeline.equals("1"))
						timeLine =selectedTimeline+" "+"hour";
					else
						timeLine =selectedTimeline+" "+"hours";
				}
			}
			else
			{
				if(fre>=1800 && frehours<1)
				{
					if(!sliderchangetime)
					{
						timeLine="3 hours";
					}
				}
				else if(frehours>=1 && frehours<=largetst)
				{
					if(!sliderchangetime)
					{
						if(initime!=null && initime.length>0)
						{
							for(int i=0;i<initime.length;i++)
							{
								if(Integer.parseInt(initime[i])>=frehours)
								{
									String ti=iniFile.getValue("GRAPH_TIMELINE_SETTINGS",initime[i]);
									timeLine =ti;
									break;
								}
							}
						}
						else
						{
							String[] initime1 = new String[]{"1", "3", "9","18"};
							for(int i=0;i<initime1.length;i++)
							{
								if(Integer.parseInt(initime1[i])>=frehours)
								{
									if(initime1[i].equalsIgnoreCase("1"))
									{
										timeLine ="3 hours";
									}
									else if(initime1[i].equalsIgnoreCase("3"))
									{
										timeLine ="6 hours";
									}
									else if(initime1[i].equalsIgnoreCase("9"))
									{
										timeLine ="12 hours";
									}
									else if(initime1[i].equalsIgnoreCase("18"))
									{
										timeLine ="1 day";
									}
									break;
								}
							}
						}
					}
				}
				else if(frehours>largetst)
				{
					if(!sliderchangetime)
					{
						timeLine="1 month";
					}
				}
			}
		}
	}
	

	EgDateInfo edi = new EgDateInfo();
	java.util.Date local_date = new java.util.Date(edi.egetUTCDate());
	Calendar cal = Calendar.getInstance();
	cal.setTime(local_date);
	cal.setTimeZone(edi.getRealTimeZone());

	String disabled ="";
	if(timeLine!=null && timeLine.equals("Any"))
	{
		String StrDate="";
		try
		{
			java.text.SimpleDateFormat df=new java.text.SimpleDateFormat("MM/dd/yyyy k 'at' hh:mm");
			 StrDate =df.format(edi.egetRealDate());	//----modified on 22/11/07stalin-----------------------
		}
		catch(Exception ee)
		{
			System.out.println("Exception is"+ee);
		}
		String SDate =StrDate.substring(0,StrDate.indexOf(" "));
		String shour =StrDate.substring(StrDate.indexOf(" "),StrDate.lastIndexOf(""));
		shour = shour.substring(0,3);
		String smin =StrDate.substring(StrDate.indexOf(":")+1);
		if (s_st_time== null || s_st_time.equalsIgnoreCase("null") || s_st_time.equals(""))
		{
			s_st_time= SDate;
		}
		if(s_en_time == null || s_en_time.equalsIgnoreCase("null") || s_en_time.equals(""))
		{
			s_en_time=SDate;
		}
		if(s_st_hr==null)
		{
			shour =shour.trim();
			int starthr = Integer.parseInt(shour);
			starthr = starthr-1;
			s_st_hr=String.valueOf(starthr);
		}
		if(s_st_min == null)
		{
			s_st_min = smin;
		}
		if(s_en_hr==null)
		{
			shour =shour.trim();
			s_en_hr =shour;
		}		
		if(s_end_min == null)
		{
			s_end_min = smin;
		}
		//sess_st_time = s_st_time;
		//sess_end_time = s_en_time;
		if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
		{
			comFormat = "MM/dd/yyyy";
		}
		else
		{
			comFormat = currentDateFormat;
		}
		s_st_time = DateUtil.changeDateFormat(s_st_time,comFormat,"MM/dd/yyyy");
		if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
		{
			comFormat = "MM/dd/yyyy";
		}
		else
		{
			comFormat = currentDateFormat;
		}
		s_en_time = DateUtil.changeDateFormat(s_en_time,comFormat,"MM/dd/yyyy");
	}
	else
	{
		disabled = "disabled";
		String startDateTime="";
		String endDateTime="";
		int blankSpaceIndex = timeLine.indexOf(DateTimeTokenizer.BLANK_SPACE);
		if (blankSpaceIndex > 0)
		{
			SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
			java.util.Date tmpday = edi.egetRealDate();
			endDateTime = sdf.format(tmpday);
			int value = Integer.parseInt(timeLine.substring(0, blankSpaceIndex));
			//long value = Integer.parseInt(timeLine.substring(0, blankSpaceIndex));

			String unit = timeLine.substring(blankSpaceIndex+1).toLowerCase();
			if (unit.startsWith("h"))
			{//hours
				value *= 3600;
			}
			else if (unit.startsWith("d"))
			{//days
				value *= (24 * 3600);
			}
			else if (unit.startsWith("w"))
			{//weeks
				value *= (7 * 24 * 3600);
			}
			else if (unit.startsWith("mo"))
			{//months
				//value *= (30 * 24 * 3600);
				value *=((ErUtils.getMaxDaysInMonth()) * 24 * 3600);
			}
			long valueToLong=value;
			java.util.Date start = edi.egetRealDate();
			start.setTime(tmpday.getTime() - (valueToLong * 1000));
			startDateTime = sdf.format(start);
		}
		if ((startDateTime != null) && (endDateTime != null))
		{
			int shr = Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":")));  
			if(fromPage!=null && fromPage.equalsIgnoreCase("EgAlarms"))
			{
				shr=shr-1;
			}
			int en_hr = Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":")));
			s_en_time=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
			s_st_time=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
			s_st_hr = String.valueOf(shr);
			s_en_hr = String.valueOf(en_hr);

			int smin = Integer.parseInt(startDateTime.substring(startDateTime.lastIndexOf(":")+1));
			int emin = Integer.parseInt(endDateTime.substring(endDateTime.lastIndexOf(":")+1));
			s_st_min = String.valueOf(smin);
			s_end_min = String.valueOf(emin);
			if(fromPage!=null && fromPage.equalsIgnoreCase("EgAlarms"))
			{
				s_en_hr=String.valueOf(cal.get(cal.HOUR_OF_DAY));
				String  s_yr = String.valueOf(cal.get(cal.YEAR));
				String s_mon = String.valueOf(cal.get(cal.MONTH)+1);
				String s_day = String.valueOf(cal.get(cal.DAY_OF_MONTH));
				String temp_hourYear=s_day+"/"+s_mon+"/"+s_yr;
				String dateAndMonth=DateUtil.changeDateFormat(temp_hourYear,"dd/MM/yyyy",currentDateFormat);
				s_en_time=dateAndMonth;
			}
		}
		//sess_st_time = s_st_time;
		//sess_end_time = s_en_time;
	}
	if (s_st_time == null || s_en_time == null)
	{
		s_st_time = "";
		s_en_time = "";
	}

	if (s_st_hr == null || s_en_hr == null)
	{
		s_st_hr = "0";
		s_en_hr = "0";
	}

	if (s_st_min==null || s_st_min.equals("")) s_st_min = "0";
	if (s_end_min==null || s_end_min.equals("")) s_end_min = "0";

	if(str_layer==null ||str_layer.equals(""))
	{
		str_layer=TableData.getLayerForTest (str_test);
	}

	str_mes_list = MeasureDisplay.getColumnNamesForTest(str_test, str_layer);
	s_mes = request.getParameter("measure");

	if (s_mes.startsWith(","))
	{
		s_mes = s_mes.substring(1, s_mes.length());
	}

	if (s_mes.indexOf(",") > 0)
	{
		st = new StringTokenizer(s_mes, ",");
		while (st.hasMoreTokens())
		{
			String tmp_meas_str = st.nextToken();
			v_mes.addElement(tmp_meas_str.trim());
			v_mes_case.addElement(tmp_meas_str.trim().toUpperCase());
		}
	}
	else
	{
		v_mes.addElement(s_mes);
		v_mes_case.addElement(s_mes.toUpperCase());
	}
	HashSet  optVec = new HashSet ();
	String chartOption = iniFile.getValue("CHART_TYPE","ChartOption");
	String chartTimeline = iniFile.getValue("CHART_TYPE","Timeline");
	String showOnlyHighchart = iniFile.getValue("CHART_TYPE","ShowHighchartAlways");
	String tabsetChartType = iniFile.getValue("CHART_TYPE","TabsetChartType");
	String s_gformat = "easychart";
	chartTimeline = (chartTimeline != null && !chartTimeline.equals(""))?chartTimeline:"1 hour";
	chartOption=(chartOption==null || chartOption =="")?"easycharts":chartOption;
	chartOption = chartOption.toLowerCase();
	boolean isArea = ( tabsetChartType != null && tabsetChartType.trim().length() > 0 && tabsetChartType.equalsIgnoreCase("area") )?true:false;

	boolean isTabSetPage = (tabSetPage != null && tabSetPage.trim().length() > 0 && ( tabSetPage.equalsIgnoreCase("true") || tabSetPage.equalsIgnoreCase("yes")) )?true:false;
	boolean alwaysHighchart = (showOnlyHighchart != null && showOnlyHighchart.trim().length() > 0 && ( showOnlyHighchart.equalsIgnoreCase("true") || showOnlyHighchart.equalsIgnoreCase("yes")) )?true:false;
	if( isTabSetPage && ( isArea || alwaysHighchart ) )
		s_gformat = "highcharts";
	else
	{
		if(chartOption != null && !chartOption.equalsIgnoreCase("") && chartOption.indexOf("easy") == -1)
		{
			s_gformat = chartOption;
			String tline = request.getParameter("timeLine");;
			if(tline == null || tline.equals(""))
				tline = "1 hour";

			SimpleDateFormat sdfin = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
			String temp_start_time = "";
			String temp_end_time = "";
			try
			{
				String startDate = request.getParameter("starttime");
				if(!DateUtil.isDate(startDate,"MM/dd/yyyy"))
				{
					startDate = DateUtil.changeDateFormat(startDate,currentDateFormat,"MM/dd/yyyy");
				}

				String endDate = request.getParameter("endtime");
				if(!DateUtil.isDate(endDate,"MM/dd/yyyy"))
				{
					endDate = DateUtil.changeDateFormat(endDate,currentDateFormat,"MM/dd/yyyy");
				}
				temp_start_time = startDate + " " + request.getParameter("starthr")+":00";
				temp_end_time = endDate + " " + request.getParameter("endhr")+":00";
				s_gformat = HighChartTimeline.getChartOption(tline,currentDateFormat,temp_start_time,temp_end_time);
			}
			catch(Exception e)
			{
				System.out.println("Exception  :"+e);
				e.printStackTrace();
			}
			s_gformat = HighChartTimeline.getChartOption(tline,currentDateFormat,temp_start_time,temp_end_time);
		}
		else
		{
			s_gformat = "easychart";
		}
	}
	String s_qrstring = request.getQueryString();
	if(s_qrstring.indexOf("&gtype=") != -1 )
		s_qrstring = s_qrstring.substring(0, s_qrstring.indexOf("&gtype="));
	else if(s_qrstring.indexOf("&s_gtype=") != -1 )
		s_qrstring = s_qrstring.substring(0, s_qrstring.indexOf("&s_gtype="));
	s_qrstring = StringUtils.replace(s_qrstring, "\\", "\\\\");

	if(str_info!=null)
	{
		str_info=com.egurkha.util.StringUtils.replace(str_info,"|plus|","+");
	
		str_info=com.egurkha.util.StringUtils.replace(str_info,"|amp|","&");
	
		str_info=com.egurkha.util.StringUtils.replace(str_info,"|pct|","%");
	
		str_info=com.egurkha.util.StringUtils.replace(str_info,"|hash|","#");
	}
	
	Hashtable vmHistMap = new Hashtable();
	boolean vmHistExists = false;
	ArrayList hosts = new ArrayList();
	if(isVM)
	{
		
		String tempInfo = str_info;
		String l_tempInfo = str_info;
		vmHistMap = EgLastMeasureThread.vmMapDbForHistory;
		if(l_tempInfo.startsWith("*") || l_tempInfo.startsWith("+"))
			l_tempInfo = l_tempInfo.substring(1);
		if(l_tempInfo.indexOf(":") >0)
			l_tempInfo = l_tempInfo.substring(0,l_tempInfo.indexOf(":"));
		
		String user_vm_host = user.getVMHost(l_tempInfo);
		ArrayList user_vm_host_list = user.getVMHostHistory(l_tempInfo);
		if(user_vm_host != null && user_vm_host.trim().length() > 0)
		{
			hosts.add(user_vm_host);
		}
		else if(user_vm_host_list != null && user_vm_host_list.size() > 0)
		{
			hosts.addAll(user_vm_host_list);
		}
		else if(tempInfo.startsWith("*") || tempInfo.startsWith("+"))
		{
			tempInfo = tempInfo.substring(1);
			if(tempInfo.indexOf(":") >0)
				tempInfo = tempInfo.substring(0,tempInfo.indexOf(":"));
			hosts = (ArrayList)vmHistMap.get(tempInfo);
		}
		else
		{
			if(tempInfo.indexOf(":")>0)
			{
				tempInfo = str_info.substring(0, tempInfo.indexOf(":"));
				hosts = (ArrayList)vmHistMap.get(tempInfo);
			}
			else
				hosts = (ArrayList)vmHistMap.get(tempInfo);
		}
	
		
		
		
		if(hosts!=null && hosts.size() > 0)
		{
			vmHistExists = true;
		}
	}
	String reversedInfo = ui.getReverseLookedupString(str_info);
	String temp_info="";
	if(reversedInfo.indexOf("*")>-1 && reversedInfo.startsWith("*"))
	{
		temp_info="+"+reversedInfo.substring(1);
		if(!portRelevantForTest)
		{
			comp_name_withPort = str_host+":NULL";
		}
		else
		{
			if(str_port!=null && str_port.trim().length()>0)
			{
				comp_name_withPort = str_host + ":" + str_port;
			}
			else
			{
				comp_name_withPort = str_host + ":NULL";
			}
		}
	}
	else if(reversedInfo.indexOf("*")>-1 && !reversedInfo.startsWith("*"))
	{
		String first_in=reversedInfo.substring(0,reversedInfo.indexOf("*"));
		String sec_in=reversedInfo.substring(reversedInfo.indexOf("*")+1);
		temp_info="+"+sec_in;

		if(!portRelevantForTest)
		{
			comp_name_withPort = str_host+":NULL";
		}
		else
		{
			if(first_in!=null && first_in.trim().length()>0)
			{
				comp_name_withPort = str_host + ":" + str_port + ":" + first_in;
			}
			else
			{
				comp_name_withPort = str_host + ":" + str_port;
			}
		}
	}

	int indexValue=-1;
	if(temp_info!=null && temp_info.indexOf("+")>-1)
		indexValue=temp_info.indexOf("+");
	if(indexValue>-1)
	{
		temp_info=temp_info.substring(indexValue+1);
	}

	if(reversedInfo!=null && reversedInfo.startsWith("*"))
		reversedInfo = reversedInfo.substring(1);

	//String uiFile = "eg_ui.ini";
	/*String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	*/
	String dispDate = null;
	comFormat = null;

	boolean isModify = true;
	String s_modify=request.getParameter("modify");
	if(s_modify!=null && s_modify.equalsIgnoreCase("false"))
		isModify=false;
	String lback = request.getParameter("l_back");
	String s_lback = request.getParameter("l_back");
	s_lback = (lback!=null && lback.equalsIgnoreCase("true"))?lback:s_lback;
	int l_times = 1;
	String lTimes = request.getParameter("l_times");
	l_times = (lTimes ==null)?l_times:Integer.parseInt(lTimes);
	String look_back = "60";
	String linterval = request.getParameter("l_interval");
	linterval = (linterval ==null)?look_back:linterval;
	String otherTimeline = request.getParameter("otherTimeline");
	String otherTimeInterval = request.getParameter("otherTimeInterval");
	String [] lookbk_arr = {"Hour","Day","Week","Month","Others"};
	String [] lookbk_valarr = {1*60+"",1*24*60+"",1*24*7*60+"",(1*24*(ErUtils.getMaxDaysInMonth())*60)+"",3*60+""};
	String [] other_tline_valarr = {"3 hrs", "6 hrs", "9 hrs", "12 hrs", "15 hrs", "18 hrs"};

	String wname = ""; 
	
	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	boolean isChrome = ( ua != null && ua.indexOf( "Chrome/" ) != -1 );
	boolean isMSIE6 = ( ua != null && ua.indexOf( "MSIE 6.0" ) != -1 );
	boolean isMSIE7 = ( ua != null && ua.indexOf( "MSIE 7.0" ) != -1 );

	JSONObject json = new JSONObject();
	JSONObject hiddenFields = new JSONObject();
	JSONObject formLabels = new JSONObject();
	JSONObject formFields = new JSONObject();
	JSONObject gridData = new JSONObject();
	JSONArray formArray = new JSONArray();

	hiddenFields.put("hidCurrentDateTime", (cal.get(cal.MONTH)+1)+"/"+cal.get(cal.DAY_OF_MONTH)+"/"+cal.get(cal.YEAR));
	hiddenFields.put("hidCurrentDateHour", cal.get(cal.HOUR_OF_DAY));
	hiddenFields.put("hidCurrentDateMin", cal.get(cal.MINUTE));
	hiddenFields.put("isVM", isVM);
	hiddenFields.put("rangeval", showrange);
	hiddenFields.put("hidd_s_mes", s_mes);
	hiddenFields.put("siteReuse", str_site);
	
	JSONObject measurecombo = new JSONObject();
	measurecombo.put("Label",mappingInfo.getTextDescription("monitor.common.Measure"));
	measurecombo.put("type","combo");
	measurecombo.put("name","measurelist");
	
	String sizeOfMeasureList="4";
	String msmt_hostForList=request.getParameter("msmt_host");
	if(msmt_hostForList==null || (msmt_hostForList!=null && msmt_hostForList.trim().equals("")))
	{
		sizeOfMeasureList="4";
	}
	ArrayList hideMeasure = new ArrayList();
	String hide_Meas = dashConfigIniFile.getValue("Hide_Measures_UI",str_test);	
	if(hide_Meas!= null && hide_Meas.trim().length() > 0 && !hide_Meas.equalsIgnoreCase("All"))
	{
		hideMeasure = com.egurkha.util.StringUtils.egTokenizer(hide_Meas, ",", false,true,false);
	}
	JSONArray measureListArray = new JSONArray();
	ArrayList measuresList = new ArrayList();
	String selectVal="";
	//Sorting depends the display names
	List al = new ArrayList();
	for (int i = 0; i < str_mes_list.length; i = i+2)
	{
		String disMeasure = MeasureDisplay.getMeasureForColumn(str_test,str_mes_list[i]);
		String dispMea = (String)mappingInfo.getMeasureDescription(str_test,disMeasure);
		if(hideMeasure != null && hideMeasure.size()>0)
		{
			if(disMeasure != null && !hideMeasure.contains(disMeasure)) 
			{
				al.add(dispMea+"\t"+str_mes_list[i]);
			}
		}
		else if(hideMeasure != null && hideMeasure.size()==0)
		{
			al.add(dispMea+"\t"+str_mes_list[i]);
		}
	}
	Collections.sort(al,String.CASE_INSENSITIVE_ORDER);
	Iterator iterate = al.iterator();
	while(iterate.hasNext())
	{
		JSONObject measures = new JSONObject();
		String value = (String)iterate.next();
		String measureOriginal = null;
		String measureDisp = null;
		if(value!=null && value.indexOf("\t") > -1)
		{
			measureDisp = value.substring(0,value.indexOf("\t"));
			measureOriginal = value.substring(value.indexOf("\t")+1,value.length());
			if(measureDisp!=null && measureOriginal!=null)
			{
				measures.put("name",measureDisp);
				measures.put("value",measureOriginal);
				measureListArray.add(measures);
			}
		}
	}
	//ends
	for (int i = 0; i < str_mes_list.length; i = i+2)
	{
		//JSONObject measures = new JSONObject();
		if (v_mes.contains(str_mes_list[i]) || v_mes_case.contains(str_mes_list[i].toUpperCase()))
		{
			String disMeasure=MeasureDisplay.getMeasureForColumn(str_test,str_mes_list[i]);
			//measures.put("name",mappingInfo.getMeasureDescription(str_test,disMeasure));
			//measures.put("value",str_mes_list[i]);
			selectVal+=str_mes_list[i]+",";
			String unit = TableData.getUnitForMeasure(str_test,disMeasure);
			disMeasure = disMeasure+" ("+unit+")";
			measuresList.add(disMeasure);
		}
		else
		{
			String disMeasure=MeasureDisplay.getMeasureForColumn(str_test,str_mes_list[i]);
			//measures.put("name",mappingInfo.getMeasureDescription(str_test,disMeasure));
			//measures.put("value",str_mes_list[i]);
		}
		//measureListArray.add(measures);
	}
	if(selectVal != null && selectVal.trim().length() > 0)
		selectVal=selectVal.substring(0,selectVal.length()-1);
	measurecombo.put("selectvalue",selectVal);	
	measurecombo.put("items",measureListArray);	
	formArray.add(measurecombo);

	if(temp_info != null && !temp_info.equalsIgnoreCase("NONE") && !temp_info.equals("+") &&  temp_info.length() != 0)
	{
		ErInfo erInfo = new ErInfo();
		String temp_site=str_site;

		if(temp_site==null || (temp_site.equalsIgnoreCase("NULL") || temp_site.equals("egurkha.physical.topology")))
		{
			temp_site = "NONE";
		}
		Vector info_list = erInfo.getInfosForTest(temp_site,str_test,comp_name_withPort+":"+compType);
		
		if(info_list==null || info_list.size()==0)
		{
			comp_name_withPort = URLDecoder.decode(comp_name_withPort);
			info_list = erInfo.getInfosForTest(temp_site,str_test,comp_name_withPort+":"+compType);
			if(info_list.size()>0)
				str_host = URLDecoder.decode(str_host);
		}

		String comp_sid=null;
		if(str_host!=null)
		{
			ArrayList comp_split_list = com.egurkha.util.StringUtils.egTokenizer(comp_name_withPort, ":",false,false,true);//3-->includeEmpty,4-->unique,5-->trim
			if(comp_split_list!=null && comp_split_list.size()>2)
			{
				comp_sid=(String)comp_split_list.get(2);
				s_sid = comp_sid;
			}
		}
		JSONObject descombo = new JSONObject();
		descombo.put("DescriptionFlag","flagtrue");
		descombo.put("Label",mappingInfo.getTextDescription("monitor.common.Descriptor"));											
		descombo.put("name","infolist");
		descombo.put("type","combo");
		
		JSONArray descriptionsArray = new JSONArray();
		String only_vm = temp_info;
		if(only_vm.indexOf(":") != -1)
			only_vm = only_vm.substring(0, only_vm.indexOf(":"));
		if(info_list!=null && info_list.size()>0)
		{
			for(int k=0; k<info_list.size(); k++)
			{
				JSONObject descriptions = new JSONObject();
				String s_list_info = (String)info_list.get(k);
				String temp_info_value=s_list_info;
				String vmInfo = "";
				String vm = "";
				if(isVM)
				{

					temp_info_value=s_list_info.substring(1);
						
					vmInfo = "";
					if(temp_info_value.indexOf(":")>-1)
					{
						vm = temp_info_value.substring(0, temp_info_value.indexOf(":"));
						vmInfo = temp_info_value.substring(temp_info_value.indexOf(":")+1);
					}
					else
					{
						vm = temp_info_value;
					}
					///if(vmInfo!=null && temp_info.indexOf(vm)<0)
					if(vmInfo!=null && !only_vm.startsWith(vm))
					{
						continue;
					}
				}
				if(s_list_info!=null && s_list_info.startsWith("+"))
				{
					temp_info_value=s_list_info.substring(1);
					if(comp_sid!=null && comp_sid.trim().length()>0)
					{
						s_list_info=comp_sid+"*"+temp_info_value;
					}
					else
					{
						s_list_info="*"+temp_info_value;
					}
				}
				s_list_info=com.egurkha.util.StringUtils.encodeSecurityChar(s_list_info);
				vmInfo=com.egurkha.util.StringUtils.encodeSecurityChar(vmInfo);
				temp_info_value = com.egurkha.util.StringUtils.replace(temp_info_value,"&#39;","'");
				temp_info = com.egurkha.util.StringUtils.replace(temp_info,"&#39;","'");
				if(temp_info_value!=null && temp_info!=null && temp_info_value.equals(temp_info))
				{
					if(isVM)
					{
						if(vmInfo!=null && vmInfo.length() ==0)
						{
							vmInfo = "Not Applicable";
						}
						descriptions.put("name", vmInfo);
						descriptions.put("value", s_list_info);
						descombo.put("selectvalue", s_list_info);
					}
					else
					{
						descriptions.put("name", temp_info_value);
						descriptions.put("value", s_list_info);
						descombo.put("selectvalue", s_list_info);
					}
				}
				else if(temp_info_value!=null && temp_info!=null && temp_info_value.equalsIgnoreCase(temp_info))
				{
					String selInfo = temp_info_value;
					if(!selInfo.startsWith("*"))
						selInfo = "*"+selInfo;
					selInfo=com.egurkha.util.StringUtils.encodeSecurityChar(selInfo);
					if(isVM)
					{
						if(vmInfo!=null && vmInfo.length() ==0)
						{
							vmInfo = "Not Applicable";
						}
						descriptions.put("name", vmInfo);
						descriptions.put("value", selInfo);
						descombo.put("selectvalue", selInfo);
					}
					else
					{
						descriptions.put("name", temp_info_value);
						descriptions.put("value", selInfo);
						descombo.put("selectvalue", selInfo);
					}
				}
				else if(temp_info_value!=null && temp_info_value.trim().length()>0)
				{
					if(isVM)
					{
						descriptions.put("name", vmInfo);
						descriptions.put("value", s_list_info);
					}
					else
					{
						descriptions.put("name", temp_info_value);
						descriptions.put("value", s_list_info);
					}
				}
				descriptionsArray.add(descriptions);
			}
		}
		else
		{
			JSONObject descriptions = new JSONObject();
			descriptions.put("name", mappingInfo.getTextDescription("monitor.detaileddiagnosis.No Description found"));
			descriptions.put("value", "-1");
			descriptionsArray.add(descriptions);
		}
		JSONObject triggerFilterObj  = new JSONObject();
		triggerFilterObj.put("type","trigger");
		triggerFilterObj.put("name","Search");
		triggerFilterObj.put("id","trigger");
		formArray.add(triggerFilterObj);
		descombo.put("items",descriptionsArray);
		formArray.add(descombo);
	}
	
	JSONObject timelinecombo = new JSONObject();
	timelinecombo.put("Label",mappingInfo.getTextDescription("monitor.common.Timeline"));			
	timelinecombo.put("name","timeline");
	timelinecombo.put("type","combo");
	
	JSONArray timelinesArray = new JSONArray();
	if(fromPage!=null && fromPage.equalsIgnoreCase("EgAlarms"))
	{
		timeLine="Any";
	}
	for(int e_ctr=0; e_ctr < options.length;e_ctr++)
	{
		JSONObject timelines = new JSONObject();
		if(timeLine!=null&&timeLine.equals((String)options[e_ctr]))
		{
			String tempOptions="";
			if(timeLine.indexOf(" ")>-1)
			{
				
				tempOptions=timeLine.substring(0,timeLine.indexOf(" "))+" " +timeLine.substring(timeLine.indexOf(" ")+1);	
			}
			else
			{
				tempOptions=timeLine;
			}
			timelines.put("name", mappingInfo.getTextDescription("monitor.common."+tempOptions));
			timelines.put("value", timeLine);
			timelinecombo.put("selectvalue",timeLine);
		}
		else
		{
			String tempOptions="";
			if(options[e_ctr].indexOf(" ")>-1)
			{
				tempOptions=options[e_ctr].substring(0,options[e_ctr].indexOf(" "))+" " +options[e_ctr].substring(options[e_ctr].indexOf(" ")+1);	
			}
			else
			{
				tempOptions=options[e_ctr];
			}
			timelines.put("name", mappingInfo.getTextDescription("monitor.common."+tempOptions));
			timelines.put("value", options[e_ctr]);
		}
		timelinesArray.add(timelines);
	}
	timelinecombo.put("items",timelinesArray);		
	formArray.add(timelinecombo); 
	
	if(timeLine!=null && timeLine.equals("Any"))
	{
		JSONObject fromDateFilter = new JSONObject();
		fromDateFilter.put("type","date");
		fromDateFilter.put("Label",mappingInfo.getTextDescription("monitor.common.From"));	
		fromDateFilter.put("name","FromDate");
		
		if(s_st_time!=null && !s_st_time.equals(""))
		{
			if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
		
			//dispDate = DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat);
			dispDate = DateUtil.changeDateFormat(s_st_time,comFormat,userFormat);
		}
		else
		{
			dispDate = "";
		}
		
		//fromDateFilter.put("format",currentDateFormat);
		fromDateFilter.put("format",userFormat);
		fromDateFilter.put("time",s_st_time);
		fromDateFilter.put("selectedValue",dispDate);
		formArray.add(fromDateFilter);
		
		JSONObject hrcombo = new JSONObject();
		hrcombo.put("Label",mappingInfo.getTextDescription("monitor.common.Hr"));
		hrcombo.put("name","starthr");
		hrcombo.put("type","combo");

		JSONArray starthoursArray = new JSONArray();
		int startRealMin = Integer.parseInt(s_st_min);
		JSONObject mincombo = new JSONObject();
		mincombo.put("Label",mappingInfo.getTextDescription("monitor.common.Min"));
		mincombo.put("name","startmin");
		mincombo.put("type","combo");
		JSONArray startMinutesArray = new JSONArray();


		for(int c_min=0;c_min<60;c_min++){
			JSONObject startmins = new JSONObject();
			if(startRealMin==60)
				startRealMin =0;
			if (c_min == startRealMin){
				
				startmins.put("name", c_min);
				startmins.put("value", c_min);
				mincombo.put("selectvalue",c_min);
			}
			else
			{
				startmins.put("name", c_min);
				startmins.put("value", c_min);
			}
			    startMinutesArray.add(startmins);
		}
		mincombo.put("items",startMinutesArray);
		
		
		timeZoneConverter = new EgTimeZoneConverter(dispDate+" "+s_st_hr+":"+s_st_min,user);

		String realstartselectvalue = timeZoneConverter.getHour();
		int startRealValue = 0;
		try
		{
			startRealValue = Integer.parseInt(realstartselectvalue);
		}catch(Exception e)
		{
			System.out.println("Conversion Exception =============>"+e);
		}
		
		for (int s_ctr = 0; s_ctr < 24; s_ctr++)
		{
			JSONObject starthours = new JSONObject();
			if(startRealValue==24)
				startRealValue = 0;
			if (s_ctr == Integer.parseInt(s_st_hr))
			{
				starthours.put("name", s_ctr);
				starthours.put("value", s_ctr);
				hrcombo.put("selectvalue",s_ctr);			
			}
			else
			{
				starthours.put("name", s_ctr);
				starthours.put("value", s_ctr);
			}
			starthoursArray.add(starthours);
		}
		hrcombo.put("items",starthoursArray);
		formArray.add(hrcombo);
		formArray.add(mincombo);

		if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
		{
			s_st_time = DateUtil.changeDateFormat(s_st_time,"MM/dd/yyyy",dateFormatForDatePick);
		}
	
		EgTimeZoneConverter startConverter = new EgTimeZoneConverter(s_st_time+" "+s_st_hr+":"+s_st_min+":00",user,true);		
		s_st_time = (String)startConverter.getDate(false);
		s_st_hr = startConverter.getHour();
		s_st_min = startConverter.getMinute();
		s_st_time = DateUtil.changeDateFormat(s_st_time,dateFormatForDatePick,"MM/dd/yyyy");
	
		JSONObject toDateFilter = new JSONObject();
		toDateFilter.put("type","date");
		toDateFilter.put("Label",mappingInfo.getTextDescription("monitor.common.To"));
		toDateFilter.put("name","todate");			
		if(s_en_time!=null && !s_en_time.equals(""))
		{
			if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
			//dispDate = DateUtil.changeDateFormat(s_en_time,comFormat,currentDateFormat);
			dispDate = DateUtil.changeDateFormat(s_en_time,comFormat,userFormat);
		}
		else
		{
			dispDate = "";
		}
		//toDateFilter.put("format",currentDateFormat);
		toDateFilter.put("format",userFormat);
		toDateFilter.put("time",s_en_time);
		toDateFilter.put("selectedValue",dispDate);
		formArray.add(toDateFilter);
		
		
		JSONObject tohrcombo = new JSONObject();
		tohrcombo.put("Label",mappingInfo.getTextDescription("monitor.common.Hr"));															
		tohrcombo.put("name","endhr");
		tohrcombo.put("type","combo");

		
		JSONArray endhoursArray = new JSONArray();
		timeZoneConverter = new EgTimeZoneConverter(dispDate+" "+s_en_hr+":"+s_end_min,user);
		String realendselectvalue = timeZoneConverter.getHour();
		int endRealValue = 0;
		try
		{
			endRealValue = Integer.parseInt(realendselectvalue);
		}catch(Exception e)
		{
			System.out.println("Conversion Exception =============>"+e);
		}
		
		int endRealValueMin =Integer.parseInt(s_end_min);
		JSONObject tomincombo = new JSONObject();
		tomincombo.put("Label",mappingInfo.getTextDescription("monitor.common.Min"));
		tomincombo.put("name","endmin");
		tomincombo.put("type","combo");
		JSONArray toMinutesArray = new JSONArray();


		for(int c_min=0;c_min<60;c_min++){
			JSONObject tomins = new JSONObject();
			if(endRealValueMin==60)
				endRealValueMin =0;
			if (c_min == endRealValueMin){
				tomins.put("name", c_min);
				tomins.put("value", c_min);
				tomincombo.put("selectvalue",c_min);
			}
			else
			{
				tomins.put("name", c_min);
				tomins.put("value", c_min);
			}
			    toMinutesArray.add(tomins);
		}
		tomincombo.put("items",toMinutesArray);
		

		for (int e_ctr = 0; e_ctr < 24; e_ctr++)
		{
			if(endRealValue==24)
				endRealValue = 0;
			JSONObject endhours = new JSONObject();
			if (e_ctr == Integer.parseInt(s_en_hr))
			{
				endhours.put("name", e_ctr);
				endhours.put("value", e_ctr);
				tohrcombo.put("selectvalue",e_ctr);
			}
			else
			{
				endhours.put("name", e_ctr);
				endhours.put("value", e_ctr);
			}
			endhoursArray.add(endhours);
		}
		tohrcombo.put("items",endhoursArray);
		formArray.add(tohrcombo);
		formArray.add(tomincombo);

		if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
		{
			s_en_time = DateUtil.changeDateFormat(s_en_time,"MM/dd/yyyy",dateFormatForDatePick);
		}

		EgTimeZoneConverter endConverter = new EgTimeZoneConverter(s_en_time+" "+s_en_hr+":"+s_end_min+":00",user,true);
		s_en_time = (String)endConverter.getDate(false);
		s_en_hr = endConverter.getHour();
		s_end_min = endConverter.getMinute();
		s_en_time = DateUtil.changeDateFormat(s_en_time,dateFormatForDatePick,"MM/dd/yyyy");

	}
	else
	{
		JSONObject fromDateFilter = new JSONObject();
		fromDateFilter.put("type","date");
		fromDateFilter.put("Label",mappingInfo.getTextDescription("monitor.common.From"));	
		fromDateFilter.put("name","FromDate");
		if(s_st_time!=null && !s_st_time.equals(""))
		{
			if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
	
	
			//dispDate = DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat);
			dispDate = DateUtil.changeDateFormat(s_st_time,comFormat,userFormat);	
		
			timeZoneConverter = new EgTimeZoneConverter(dispDate+" "+s_st_hr+":"+s_st_min+":00",user);
			
			startDateForDisplay = (String) timeZoneConverter.getDate(false);	
			
			//dispDate = DateUtil.changeDateFormat(startDateForDisplay,dateFormatForDatePick,currentDateFormat);//by ramesh
			//dispDate = DateUtil.changeDateFormat(startDateForDisplay,dateFormatForDatePick,userFormat);
			dispDate = 	startDateForDisplay;

		}
		else
		{
			dispDate = "";
		}
		

		timeZoneConverter = new EgTimeZoneConverter(dispDate+" "+s_st_hr+":"+s_st_min+":00",user);

		String realstartselectvalue = timeZoneConverter.getHour();
		String realstartselectMin = timeZoneConverter.getMinute();

		int startRealMin = 0;
		try
		{
			startRealMin = Integer.parseInt(realstartselectMin);
		}catch(Exception e)
		{
			System.out.println("Conversion Exception =============>"+e);
		}

		//fromDateFilter.put("format",currentDateFormat);
		fromDateFilter.put("format",userFormat);
		fromDateFilter.put("time",s_st_time);
		fromDateFilter.put("selectedValue",dispDate);
		formArray.add(fromDateFilter);
		
		JSONObject hrcombo = new JSONObject();
		hrcombo.put("Label",mappingInfo.getTextDescription("monitor.common.Hr"));
		hrcombo.put("name","starthr");
		hrcombo.put("type","combo");

		JSONArray starthoursArray = new JSONArray();
		
		JSONObject mincombo = new JSONObject();
		mincombo.put("Label",mappingInfo.getTextDescription("monitor.common.Min"));
		mincombo.put("name","startmin");
		mincombo.put("type","combo");
		JSONArray startMinutesArray = new JSONArray();


		for(int c_min=0;c_min<=59;c_min++){
			JSONObject startmins = new JSONObject();
			if(startRealMin==60)
				startRealMin =0;
			if (c_min == startRealMin){
				
				startmins.put("name", c_min);
				startmins.put("value", c_min);
				mincombo.put("selectvalue",c_min);
			}
			else
			{
				startmins.put("name", c_min);
				startmins.put("value", c_min);
			}
			    startMinutesArray.add(startmins);
		}
		mincombo.put("items",startMinutesArray);
		
		
		int startRealValue = 0;
		try
		{
			startRealValue = Integer.parseInt(realstartselectvalue);
		}catch(Exception e)
		{
			System.out.println("Conversion Exception =============>"+e);
		}
		
		for (int s_ctr = 0; s_ctr < 24; s_ctr++)
		{
			if(startRealValue==24)
				startRealValue =0;
			JSONObject starthours = new JSONObject();
			if (s_ctr == startRealValue)
			{
				starthours.put("name", s_ctr);
				starthours.put("value", s_ctr);
				hrcombo.put("selectvalue",s_ctr);			
			}
			else
			{
				starthours.put("name", s_ctr);
				starthours.put("value", s_ctr);
			}
			starthoursArray.add(starthours);
		}
		hrcombo.put("items",starthoursArray);
		formArray.add(hrcombo);
		formArray.add(mincombo);
		
		JSONObject toDateFilter = new JSONObject();
		toDateFilter.put("type","date");
		toDateFilter.put("Label",mappingInfo.getTextDescription("monitor.common.To"));
		toDateFilter.put("name","todate");
		if(s_en_time!=null && !s_en_time.equals(""))
		{
			if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}

			//dispDate = DateUtil.changeDateFormat(s_en_time,comFormat,currentDateFormat);
			dispDate = DateUtil.changeDateFormat(s_en_time,comFormat,userFormat);
			
			timeZoneConverter = new EgTimeZoneConverter(dispDate+" "+s_en_hr+":"+s_end_min,user);//by ramesh
			endDateForDisplay = (String) timeZoneConverter.getDate(false);	
			//dispDate = DateUtil.changeDateFormat(endDateForDisplay,dateFormatForDatePick,currentDateFormat);//by ramesh
		
			dispDate = endDateForDisplay;


		}
		else
		{
			dispDate = "";
		}
		//toDateFilter.put("format",currentDateFormat);
		toDateFilter.put("format",userFormat);
		toDateFilter.put("time",s_en_time);
		toDateFilter.put("selectedValue",dispDate);
		formArray.add(toDateFilter);
		
		JSONObject tohrcombo = new JSONObject();
		tohrcombo.put("Label",mappingInfo.getTextDescription("monitor.common.Hr"));															
		tohrcombo.put("name","endhr");
		tohrcombo.put("type","combo");
		JSONArray endhoursArray = new JSONArray();

		String realendselectvalue = timeZoneConverter.getHour();
		String realendselectvaluetoMin = timeZoneConverter.getMinute();
		
	
		int endRealValueMin = 0;
		try
		{
			endRealValueMin = Integer.parseInt(realendselectvaluetoMin);
		}catch(Exception e)
		{
			System.out.println("Conversion Exception =============>"+e);
		}
	
		JSONObject tomincombo = new JSONObject();
		tomincombo.put("Label",mappingInfo.getTextDescription("monitor.common.Min"));
		tomincombo.put("name","endmin");
		tomincombo.put("type","combo");
		JSONArray toMinutesArray = new JSONArray();


		for(int c_min=0;c_min<=59;c_min++){
			JSONObject tomins = new JSONObject();
			if(endRealValueMin==60)
				endRealValueMin =0;
			if (c_min == endRealValueMin){
				tomins.put("name", c_min);
				tomins.put("value", c_min);
				tomincombo.put("selectvalue",c_min);
			}
			else
			{
				tomins.put("name", c_min);
				tomins.put("value", c_min);
			}
			    toMinutesArray.add(tomins);
		}
		tomincombo.put("items",toMinutesArray);
		
		int endRealValue = 0;
		try
		{
			endRealValue = Integer.parseInt(realendselectvalue);
		}catch(Exception e)
		{
			System.out.println("Conversion Exception =============>"+e);
		}
		
		for (int e_ctr = 0; e_ctr < 24; e_ctr++)
		{
			if(endRealValue==24)
				endRealValue = 0;
			JSONObject endhours = new JSONObject();
			if (e_ctr == endRealValue)
			{
				//endhours.put("name", e_ctr);
				endhours.put("name", e_ctr);
				endhours.put("value", e_ctr);
				tohrcombo.put("selectvalue",e_ctr);
			}
			else
			{
				//endhours.put("name", e_ctr);
				endhours.put("name", endRealValue);
				endhours.put("value", e_ctr);
			}
			//endRealValue++;
			endhoursArray.add(endhours);
		}
		tohrcombo.put("items",endhoursArray);
		formArray.add(tohrcombo);
		formArray.add(tomincombo);
	}
	
	JSONObject viewcombo = new JSONObject();
	viewcombo.put("Label",mappingInfo.getTextDescription("monitor.common.View"));
	viewcombo.put("name","mode");
	viewcombo.put("type","combo");
	
	JSONObject views = new JSONObject();
	JSONArray viewsArray = new JSONArray();
	String mode = request.getParameter("mode");
	String select2d="";
	String select3d="";
	boolean use3DGraphs = ui.use3DGraphs(IniUI.MONITOR);
	if(mode!=null&&!mode.equals(""))
	{
		if(mode.equals("2D")){
			select2d="selected";
			viewcombo.put("selectvalue","2D");
		}
		if(mode.equals("3D")){
			select3d="selected";
			viewcombo.put("selectvalue","3D");
		}
	}
	else
	{
		if(use3DGraphs){
			select3d="selected";
			viewcombo.put("selectvalue","3D");
		}
		else{
			select2d="selected";
			viewcombo.put("selectvalue","2D");
		}
	}
	
	views.put("name", mappingInfo.getTextDescription("monitor.common.2D"));
	views.put("value", "2D");
	viewsArray.add(views);
	views.put("name", mappingInfo.getTextDescription("monitor.common.3D"));
	views.put("value", "3D");	
	viewsArray.add(views);
	viewcombo.put("items",viewsArray);
	formArray.add(viewcombo);
	
	JSONObject lookbacklabel = new JSONObject();
	lookbacklabel.put("Label",mappingInfo.getTextDescription("monitor.livegraph.Lookback"));
	lookbacklabel.put("name","er_history");
	lookbacklabel.put("type","checkbox");
	
	
	String hist = "";
	boolean checked=false;
	if(s_lback!=null && s_lback.equalsIgnoreCase("true"))
	{	
		hist = "checked";
		checked=true;
	}
	lookbacklabel.put("checked",checked);
	formArray.add(lookbacklabel);
	hiddenFields.put("hidPreviousLookback", hist);
	
	JSONObject intervalcombo = new JSONObject();
	intervalcombo.put("Label",mappingInfo.getTextDescription("monitor.livegraph.Interval"));
	intervalcombo.put("name","er_interval");
	intervalcombo.put("type","combo");
	
	JSONArray intervalsArray = new JSONArray();
	String lb_interval = "";

	if(linterval!=null)
	{
		lb_interval = linterval;
	}

	for(int i=0;i<lookbk_arr.length;i++)
	{
		JSONObject intervals = new JSONObject();
		if(lb_interval.equals(lookbk_valarr[i]))
		{
			String chk1="selected";
			intervals.put("name", mappingInfo.getTextDescription("monitor.livegraph."+lookbk_arr[i]));
			intervals.put("value", lb_interval);
			intervalcombo.put("selectvalue",lb_interval);
			chk1 = "";
		}
		else if(otherTimeline!=null && otherTimeline.equalsIgnoreCase("true") && otherTimeInterval!=null && lookbk_valarr[i].equals("180"))
		{
			String chk1="selected";
			intervals.put("name", mappingInfo.getTextDescription("monitor.livegraph."+lookbk_arr[i]));
			intervals.put("value", "180");
			intervalcombo.put("selectvalue","180");
			chk1 = "";
		}
		else
		{
			intervals.put("name", mappingInfo.getTextDescription("monitor.livegraph."+lookbk_arr[i]));
			intervals.put("value", lookbk_valarr[i]);
		}
		intervalsArray.add(intervals);
	}
	intervalcombo.put("items",intervalsArray);
	formArray.add(intervalcombo);
	hiddenFields.put("hidPreviousOtherTime", otherTimeline);
	
	JSONObject timescombo = new JSONObject();
	timescombo.put("Label",mappingInfo.getTextDescription("monitor.livegraph.No&#46; of times"));
	timescombo.put("name","er_integrate");
	timescombo.put("type","combo");

	JSONArray noOfTimesArray = new JSONArray();
	for(int i=1;i<=7;i++)
	{
		JSONObject noOfTimes = new JSONObject();
		if(isModify)
		{
			if(l_times==i)
			{
				String chk1="selected";
				noOfTimes.put("name", i);
				noOfTimes.put("value", String.valueOf(l_times));
				timescombo.put("selectvalue",String.valueOf(l_times));
				chk1 = "";
			}
			else
				noOfTimes.put("name", i);
				noOfTimes.put("value", String.valueOf( i));
		}
		else
		{
			noOfTimes.put("name", i);
			noOfTimes.put("value", String.valueOf( i));
		}
		noOfTimesArray.add(noOfTimes);
	}
	timescombo.put("items",noOfTimesArray);
	formArray.add(timescombo);
	
	JSONObject otherintervalcombo = new JSONObject();
	otherintervalcombo.put("Label","");
	otherintervalcombo.put("name","er_otherTime");
	otherintervalcombo.put("type","combo");
	JSONObject newSelection = new JSONObject();
	JSONArray newSelectionArray = new JSONArray();
	
	String dispOtherTimeInterval = "";
	if(otherTimeInterval!=null && otherTimeInterval.equals("180"))
		dispOtherTimeInterval = "3 hrs";
	else if(otherTimeInterval!=null && otherTimeInterval.equals("360"))
		dispOtherTimeInterval = "6 hrs";
	else if(otherTimeInterval!=null && otherTimeInterval.equals("540"))
		dispOtherTimeInterval = "9 hrs";
	else if(otherTimeInterval!=null && otherTimeInterval.equals("720"))
		dispOtherTimeInterval = "12 hrs";
	else if(otherTimeInterval!=null && otherTimeInterval.equals("900"))
		dispOtherTimeInterval = "15 hrs";
	else if(otherTimeInterval!=null && otherTimeInterval.equals("1080"))
		dispOtherTimeInterval = "18 hrs";
	
	for(int ot=0; ot<other_tline_valarr.length; ot++)
	{
		if(dispOtherTimeInterval!=null && dispOtherTimeInterval.equalsIgnoreCase(other_tline_valarr[ot]))
		{
			String oTime="selected";
			newSelection.put("name", mappingInfo.getTextDescription("monitor.livegraph."+other_tline_valarr[ot]));
			newSelection.put("value", dispOtherTimeInterval);
			otherintervalcombo.put("selectvalue",dispOtherTimeInterval);
			oTime = "";
		}
		else
		{
			newSelection.put("name", mappingInfo.getTextDescription("monitor.livegraph."+other_tline_valarr[ot]));
			newSelection.put("value", other_tline_valarr[ot]);
		}
		newSelectionArray.add(newSelection);
	}
	
	otherintervalcombo.put("items",newSelectionArray);
	formArray.add(otherintervalcombo);
	
	String msmt_host=request.getParameter("msmt_host");
	if(!msmt_host.equals("null")&& msmt_host!=null && !msmt_host.equals("") && !msmt_host.equals("undefined"))
	{
		JSONObject mesinfo = new JSONObject();
		mesinfo.put("type","label");
		mesinfo.put("Label",mappingInfo.getTextDescription("monitor.common.Measured By"));
		mesinfo.put("measureValue",com.egurkha.util.StringUtils.egSubString(msmt_host,isUserLanguageEnglish,12,8));
		mesinfo.put("measureValueTooltip",msmt_host);
		formArray.add(mesinfo);
	}
	
	//if(showrange!=null && showrange.equalsIgnoreCase("RANGE") && !(s_lback!=null && s_lback.equalsIgnoreCase("true")))
	if(showrange!=null && showrange.equalsIgnoreCase("RANGE"))
	{		
		JSONObject datarange = new JSONObject();
		datarange.put("type","slider");
		datarange.put("Label",mappingInfo.getTextDescription("monitor.measureGraph.Data Range"));
		datarange.put("minvalue",sd_min);
		datarange.put("maxvalue",sd_max);
		formArray.add(datarange);								
	}
	else
	{

	}

	JSONObject ckbbuttoninfo = new JSONObject();
	ckbbuttoninfo.put("type","checkboxgroup");
	ckbbuttoninfo.put("name","showLegend");
	ckbbuttoninfo.put("text",mappingInfo.getTextDescription("monitor.common.Show Legends"));
	formArray.add(ckbbuttoninfo);
	
	JSONObject graphbuttoninfo = new JSONObject();	
	graphbuttoninfo.put("type","button");
	graphbuttoninfo.put("name","graph");
	graphbuttoninfo.put("text",mappingInfo.getTextDescription("monitor.common.Graph"));
	formArray.add(graphbuttoninfo);

	
	JSONObject databuttoninfo = new JSONObject();	
	databuttoninfo.put("type","button");
	databuttoninfo.put("name","data");
	databuttoninfo.put("text",mappingInfo.getTextDescription("monitor.common.Data"));
	formArray.add(databuttoninfo);
	
	JSONObject printbuttoninfo = new JSONObject();	
	printbuttoninfo.put("type","tool");
	printbuttoninfo.put("name","print");
	printbuttoninfo.put("text",mappingInfo.getTextDescription("monitor.common.PRINT"));
	formArray.add(printbuttoninfo);
	
	JSONObject savebuttoninfo = new JSONObject();	
	savebuttoninfo.put("type","tool");
	savebuttoninfo.put("name","save");
	savebuttoninfo.put("text",mappingInfo.getTextDescription("monitor.common.SAVE"));
	formArray.add(savebuttoninfo);
	
	EgMeasureGraphExt measureGraphInfo = new EgMeasureGraphExt();

	if (!EgInstallInfo.isConfigTest((String)request.getParameter("test")))
	{
		String var ="";
		String val="";
		Enumeration enumeration = request.getParameterNames();
		HashMap qs = new HashMap();
		while(enumeration.hasMoreElements())
		{
			var = (String)enumeration.nextElement();
			val = request.getParameter(var);
			qs.put(var,val);
		}
		if(timeLine!=null && !timeLine.equals("Any"))
		{
			qs.put("starttime",s_st_time);
			qs.put("endtime",s_en_time);
			qs.put("starthr",s_st_hr);
			qs.put("endhr",s_en_hr);
		}
		else
		{
			qs.put("starttime",s_st_time);
			qs.put("endtime",s_en_time);
			qs.put("starthr",s_st_hr);
			qs.put("endhr",s_en_hr);
			qs.put("mgstmin",s_st_min);
			qs.put("mgendmin",s_end_min);
		}
		Iterator keys= (qs.keySet()).iterator();
		var ="";
		val ="";
		String qStr = "";
		while (keys.hasNext())
		{
			var = (String)keys.next();
			val = (String)qs.get(var);
			if(var.equals("info"))
			{
				val=request.getParameter(var) ;
				if(val!=null && val.length()>0 && !val.equals("+"))
				{
					if(!(val.indexOf("*")>-1))
					val="*"+val;
				}
				if(val!=null && val.indexOf("*")>-1)
				{
					if(val.equals("*+"))
					{
						val="*";
					}
				}
			}
			if(var.equals("host"))
			{
				val=URLDecoder.decode(request.getParameter(var)) ;
			}
			if(var.equals("comptype"))
			{
				val=request.getParameter(var) ;
			}
			if(var.equals("layer"))
			{
				val=request.getParameter(var) ;
			}
			if(var.equals("msmt_host"))
			{
				val=request.getParameter(var) ;
			}
			qStr += var+"="+EgURLEncoder.encode(val,"UTF-8")+"&";
		}
		qStr =qStr+"gformat=graph";
		String lbackStr = request.getParameter("l_back");
		boolean lbackVal = ( lbackStr != null && ( lbackStr.toLowerCase().equals("true") || lbackStr.toLowerCase().equals("yes") ))?true:false;
		if(!lbackVal)
		{
			if( v_mes.size() == 1 )
			{
				String dispTestName = mappingInfo.getTestDescription(str_test);
				String disMeasure=MeasureDisplay.getMeasureForColumn(str_test,(String)v_mes.get(0));
				String displayMeasure =mappingInfo.getMeasureDescription(str_test,disMeasure);
				String unit = TableData.getUnitForMeasure(str_test,disMeasure);
				if( unit != null && !unit.equals("") )
					displayMeasure = displayMeasure+" ("+unit+")";
				displayMeasure = dispTestName+"/"+displayMeasure;
				hiddenFields.put("chartPanelTitle",displayMeasure);
			}
			else
			{
				String dispTestName = mappingInfo.getTestDescription(str_test);
				hiddenFields.put("chartPanelTitle",dispTestName);
			}
		}
		
		//For Chart Title Ending...................

		if(s_lback!=null && s_lback.equalsIgnoreCase("true"))
		{
			if(s_mes!=null)	// if 2
			{
				StringTokenizer tok = new StringTokenizer(s_mes, ",");	// while
				{					
					JSONArray MultipleGridArray = new JSONArray();
					JSONArray GraphsArray = new JSONArray();
					String displayMeasure = "";
					while(tok.hasMoreTokens())
					{
						JSONObject graphUrl = new JSONObject();
						JSONObject multiplegrid = new JSONObject(); 
						JSONObject multipleGridColumns = new JSONObject();						
						String tempMeasure = tok.nextToken();
						String measValue = "";
						measValue = tempMeasure;

						String dispTestName = mappingInfo.getTestDescription(str_test);
						String disMeasure=MeasureDisplay.getMeasureForColumn(str_test,measValue);
						String titleDisplayMeasure = mappingInfo.getMeasureDescription(str_test,disMeasure);
						String unit = TableData.getUnitForMeasure(str_test,disMeasure);
						if( unit != null && !unit.equals("") )
							titleDisplayMeasure = titleDisplayMeasure+" ("+unit+")";
						titleDisplayMeasure = dispTestName+"/"+titleDisplayMeasure;
						displayMeasure = displayMeasure+titleDisplayMeasure+"^sep^";
						
						hiddenFields.put("measure", request.getParameter("measure"));
						String t_gtype = request.getParameter("gtype");
						if(t_gtype == null)
							t_gtype = request.getParameter("s_gtype");
						hiddenFields.put("gtype", t_gtype);
						hiddenFields.put("msmt_host", request.getParameter("msmt_host"));
						graphUrl.put("Graphs","/final/servlet/com.egurkha.LookBackTimelineMeasures?"+qStr+"&l_back="+hist+"&l_times="+l_times+"&l_interval="+linterval+"&measureValue="+measValue+"&otherTimeline="+otherTimeline+"&otherTimeInterval="+otherTimeInterval+"&title=yes");						
						
						Enumeration testMeasures = null;
						boolean showdata = false;
						ArrayList availMeasures = new ArrayList();
						if(str_site.equals("null"))
						{
							//str_site = "-1";
							str_site = "NULL";
						}
						String msmtHost = request.getParameter("msmt_host");
						ArrayList measureData1 = new ArrayList();
						ArrayList legendsList = new ArrayList();
						if(str_info!=null && str_info.length()>0)
						{
							if(!(str_info.indexOf("*")>-1)) str_info="*"+str_info;
							if(str_info.equals("*+"))
							{
								str_info="*";
							}
						}
						Hashtable avgMinMaxData = new Hashtable();
						if(isVM)
						{
							if(vmHistExists)
							{
								
								for(int h=0; h < hosts.size();h++)
								{
									String host = (String)hosts.get(h);
									String st_host = host.substring(0,host.lastIndexOf(":"));
									String ss_host = st_host.substring(0, st_host.indexOf(":"));
									String ss_port = st_host.substring(st_host.indexOf(":")+1);
									avgMinMaxData = measureGraphInfo.getAvgMaxMinData(measValue, str_test, str_host, str_port, str_site, str_test, str_info, s_st_time, s_en_time, msmtHost, request.getParameter("comptype"), timeLine, s_st_hr, s_en_hr, sd_min, sd_max, u_ser, l_times, linterval, otherTimeline, otherTimeInterval, currentDateFormat,isVM);
									
								}
								
							}
						}
						else
						{
							avgMinMaxData = measureGraphInfo.getAvgMaxMinData(measValue, str_test, str_host, str_port, str_site, str_test, str_info, s_st_time, s_en_time, msmtHost, request.getParameter("comptype"), timeLine, s_st_hr, s_en_hr, sd_min, sd_max, u_ser, l_times, linterval, otherTimeline, otherTimeInterval, currentDateFormat);
						}
						testMeasures = avgMinMaxData.keys();
						while(testMeasures.hasMoreElements())
						{
							String meas = (String)testMeasures.nextElement();
							availMeasures.add(meas);
						}
						Comparator comparator = Collections.reverseOrder();
						Collections.sort(availMeasures,comparator);
						Collections.sort(measuresList,String.CASE_INSENSITIVE_ORDER);
						
						
						if(availMeasures!=null && avgMinMaxData.size()>0)
						{
							String temp_mes = MeasureDisplay.getMeasureForColumn(str_test,measValue);
							String measureDisp = mappingInfo.getMeasureDescription(str_test,temp_mes);

							String unitForMeasure = TableData.getUnitForMeasure(str_test, temp_mes.trim());

							if(unitForMeasure!=null)
								measureDisp = measureDisp + " (" + unitForMeasure + ")";
																
							multipleGridColumns.put("MeasureLabel", measureDisp);
							multipleGridColumns.put("MeasureAvgLabel", mappingInfo.getTextDescription("monitor.measure.Avg"));
							multipleGridColumns.put("MeasureMaxLabel", mappingInfo.getTextDescription("monitor.measure.Max"));
							multipleGridColumns.put("MeasureMinLabel", mappingInfo.getTextDescription("monitor.common.Min"));
							multiplegrid.put("MeasureGridColumns",multipleGridColumns);
							if(avgMinMaxData!=null && avgMinMaxData.size()>0)
							{
								if(availMeasures!=null && availMeasures.size()>0)
								{
									JSONArray dataArray = new JSONArray();
									for(int a=0; a<availMeasures.size();a++)
									{
										String legendName   = (String)availMeasures.get(a);
										ArrayList measureData = (ArrayList) avgMinMaxData.get(legendName);
										String avgValue =(String) measureData.get(0);
										String maxValue =(String) measureData.get(1);
										String minValue =(String) measureData.get(2);
										if(avgValue.equals("-")&&minValue.equals("-"))
										{
											maxValue="-";
										}
										JSONObject multipleGridData = new JSONObject();
										multipleGridData.put("MeasuresDisplay", legendName);
										multipleGridData.put("MeasureAvgDisplay", MeasureDisplay.formatValue(avgValue));
										multipleGridData.put("MeasureMaxDisplay", MeasureDisplay.formatValue(maxValue));
										multipleGridData.put("MeasureMinDisplay", MeasureDisplay.formatValue(minValue));
										dataArray.add(multipleGridData);
									}
									multiplegrid.put("MeasureGridData",dataArray);
								}
							}
						}
						GraphsArray.add(graphUrl);
						MultipleGridArray.add(multiplegrid);
					}
					displayMeasure = (displayMeasure.endsWith("^sep^"))?displayMeasure.substring(0,(displayMeasure.length()-5)):"";
					hiddenFields.put("chartPanelTitle",displayMeasure);
					json.put("MultipleGraphsUrl",GraphsArray);
					gridData.put("MultipleMeasureGridData",MultipleGridArray);
				}
			}
			else
			{
				hiddenFields.put("measure", request.getParameter("measure"));
				String t_gtype = request.getParameter("gtype");
				if(t_gtype == null)
					t_gtype = request.getParameter("s_gtype");
				hiddenFields.put("gtype", t_gtype);
				hiddenFields.put("msmt_host", request.getParameter("msmt_host"));
				
				json.put("GraphUrl", "/final/servlet/com.egurkha.LookBackTimelineMeasures?qStr&l_back="+hist+"&l_times="+l_times+"&l_interval="+linterval+"&otherTimeline="+otherTimeline+"&otherTimeInterval="+otherTimeInterval+"&title=yes");

				Enumeration testMeasures = null;
				boolean showdata = false;
				ArrayList availMeasures = new ArrayList();
				if(str_site.equals("null"))
				{
					//str_site = "-1";
					str_site = "NULL";
				}
				String msmtHost = request.getParameter("msmt_host");
				ArrayList measureData1 = new ArrayList();
				ArrayList legendsList = new ArrayList();
				if(str_info!=null && str_info.length()>0)
				{
					if(!(str_info.indexOf("*")>-1)) str_info="*"+str_info;
					if(str_info.equals("*+"))
					{
						str_info="*";
					}
				}
				Hashtable avgMinMaxData = new Hashtable();
				if(isVM)
				{
					if(vmHistExists)
					{
						for(int h=0; h < hosts.size();h++)
						{
							String host = (String)hosts.get(h);
							String st_host = host.substring(0,host.lastIndexOf(":"));
							String ss_host = st_host.substring(0, st_host.indexOf(":"));
							String ss_port = st_host.substring(st_host.indexOf(":")+1);
							avgMinMaxData = measureGraphInfo.getAvgMaxMinData(s_mes, str_test, str_host, str_port, str_site, str_test, str_info, s_st_time, s_en_time, msmtHost, request.getParameter("comptype"), timeLine, s_st_hr, s_en_hr, sd_min, sd_max, u_ser, l_times, linterval, otherTimeline, otherTimeInterval, currentDateFormat,isVM);
						}
					}

				}
				else
				{
					avgMinMaxData = measureGraphInfo.getAvgMaxMinData(s_mes, str_test, str_host, str_port, str_site, str_test, str_info, s_st_time, s_en_time, msmtHost, request.getParameter("comptype"), timeLine, s_st_hr, s_en_hr, sd_min, sd_max, u_ser, l_times, linterval, otherTimeline, otherTimeInterval, currentDateFormat);
				}
				testMeasures = avgMinMaxData.keys();
				while(testMeasures.hasMoreElements())
				{
					String meas = (String)testMeasures.nextElement();
					availMeasures.add(meas);
				}
				Comparator comparator = Collections.reverseOrder();
				Collections.sort(availMeasures,comparator);
				Collections.sort(measuresList,String.CASE_INSENSITIVE_ORDER);
				
				if(availMeasures!=null && avgMinMaxData.size()>0)
				{
					String temp_mes = MeasureDisplay.getMeasureForColumn(str_test,s_mes);
					String measureDisp = mappingInfo.getMeasureDescription(str_test,temp_mes);

					String unitForMeasure = TableData.getUnitForMeasure(str_test, temp_mes.trim());

					if(unitForMeasure!=null)
						measureDisp = measureDisp + " (" + unitForMeasure + ")";
					
					JSONObject MeasureGridColumns = new JSONObject();
					MeasureGridColumns.put("MeasureLabel", measureDisp);
					MeasureGridColumns.put("MeasureAvgLabel", mappingInfo.getTextDescription("monitor.measure.Avg"));
					MeasureGridColumns.put("MeasureMaxLabel", mappingInfo.getTextDescription("monitor.measure.Max"));
					MeasureGridColumns.put("MeasureMinLabel", mappingInfo.getTextDescription("monitor.common.Min"));
					gridData.put("MeasureGridColumns",MeasureGridColumns);
					
					if(avgMinMaxData!=null && avgMinMaxData.size()>0)
					{
						if(availMeasures!=null && availMeasures.size()>0)
						{
							JSONArray dataArray= new JSONArray();
							for(int a=0; a<availMeasures.size();a++)
							{
								String legendName   = (String)availMeasures.get(a);
								ArrayList measureData = (ArrayList) avgMinMaxData.get(legendName);
								String avgValue =(String) measureData.get(0);
								String maxValue =(String) measureData.get(1);
								String minValue =(String) measureData.get(2);
								if(avgValue.equals("-")&&minValue.equals("-"))
								{
									maxValue="-";
								}
								JSONObject MeasureGridData = new JSONObject();
								MeasureGridData.put("MeasuresDisplay", legendName);
								MeasureGridData.put("MeasureAvgDisplay", MeasureDisplay.formatValue(avgValue));
								MeasureGridData.put("MeasureMaxDisplay", MeasureDisplay.formatValue(maxValue));
								MeasureGridData.put("MeasureMinDisplay", MeasureDisplay.formatValue(minValue));
								dataArray.add(MeasureGridData);
								try
								{
									if(maxValue!=null && !maxValue.equals("-"))
									{
										hiddenFields.put("maxValue",MeasureDisplay.formatValue(new Double(maxValue)+1));
									}
									if(minValue!=null && !minValue.equals("-"))
									{
										if(new Double(minValue) < 0)
											hiddenFields.put("minValue",MeasureDisplay.formatValue(new Double(minValue)-1));
										else
											hiddenFields.put("minValue",new Double("0"));
									}
								}catch(Exception e){System.out.println("Number Format------------------->"+e);}
							}
							gridData.put("MeasureGridData",dataArray);
						}
					}
				}
			}
		}
		else
		{
			hiddenFields.put("measure", request.getParameter("measure"));
			String t_gtype = request.getParameter("gtype");
			if(t_gtype == null)
				t_gtype = request.getParameter("s_gtype");
			hiddenFields.put("gtype", t_gtype);
			hiddenFields.put("msmt_host", request.getParameter("msmt_host"));
			String tmpGraphUrl = "";
			if(isCsrfPreventionEnabled!=null && isCsrfPreventionEnabled.equalsIgnoreCase("Yes"))
			{
				tmpGraphUrl = response.encodeURL("/final/servlet/com.egurkha.TimelineMeasures?")+"&"+qStr+"&title=yes";
			}else{
				tmpGraphUrl = response.encodeURL("/final/servlet/com.egurkha.TimelineMeasures?")+qStr+"&title=yes";
			}

			json.put("GraphUrl",tmpGraphUrl);
			Enumeration testMeasures = null;
			

			boolean showdata = false;
			ArrayList availMeasures = new ArrayList();
			if(str_site.equals("null"))
			{
				//str_site = "-1";
				str_site = "NULL";
			}
			String msmtHost = request.getParameter("msmt_host");
			ArrayList measureData1 = new ArrayList();
			ArrayList legendsList = new ArrayList();
			if(str_info!=null && str_info.length()>0)
			{
				if(!(str_info.indexOf("*")>-1)) str_info="*"+str_info;
				if(str_info.equals("*+"))
				{
					str_info="*";
				}
			}
			Hashtable avgMinMaxData = new Hashtable();
			if(isVM)
			{
				if(vmHistExists)
				{
					
					for(int h=0; h < hosts.size();h++)
					{
						String host = (String)hosts.get(h);
						String st_host = host.substring(0,host.lastIndexOf(":"));
						String ss_host = st_host.substring(0, st_host.indexOf(":"));
						String ss_port = st_host.substring(st_host.indexOf(":")+1);
						avgMinMaxData = measureGraphInfo.getAvgMaxMinData(s_mes, str_test, str_host, str_port, str_site, str_test, str_info, s_st_time, s_en_time, msmtHost, request.getParameter("comptype"), timeLine, s_st_hr, s_en_hr, sd_min, sd_max, u_ser,isVM);
					}
					
				}
			}
			else
			{
				avgMinMaxData = measureGraphInfo.getAvgMaxMinData(s_mes, str_test, str_host, str_port, str_site, str_test, str_info, s_st_time, s_en_time, msmtHost, request.getParameter("comptype"), timeLine, s_st_hr, s_en_hr, sd_min, sd_max, u_ser,s_st_min,s_end_min);
			}

			testMeasures = avgMinMaxData.keys();
			while(testMeasures.hasMoreElements())
			{
				String meas = (String)testMeasures.nextElement();
				if(measuresList!=null&&measuresList.contains(meas))
				{
					showdata= true;
				}
				availMeasures.add(meas);
			}
			Collections.sort(measuresList,String.CASE_INSENSITIVE_ORDER);
			
			if(availMeasures!=null&&avgMinMaxData.size()>0&&showdata)
			{
				JSONObject MeasureGridColumns = new JSONObject();
				MeasureGridColumns.put("MeasureLabel", mappingInfo.getTextDescription("monitor.measure.Measurement Name"));
				MeasureGridColumns.put("MeasureAvgLabel", mappingInfo.getTextDescription("monitor.measure.Avg"));
				MeasureGridColumns.put("MeasureMaxLabel", mappingInfo.getTextDescription("monitor.measure.Max"));
				MeasureGridColumns.put("MeasureMinLabel", mappingInfo.getTextDescription("monitor.common.Min"));
				gridData.put("MeasureGridColumns",MeasureGridColumns);
				JSONArray dataArray= new JSONArray();
				for(int k=0;k<measuresList.size();k++)
				{
					String measureName = (String)measuresList.get(k);
					ArrayList measureData = (ArrayList) avgMinMaxData.get(measureName);
					if(measureData == null || measureData.size() == 0)
						continue;
					//String temp = str_test +  ":" + measureName.substring(0,measureName.indexOf("(")-1);
					String temp =  measureName.substring(0,measureName.indexOf("(")-1);
					String unitTemp = measureName.substring(measureName.indexOf("("),measureName.length());
					String avgValue =(String) measureData.get(0);
					String maxValue =(String) measureData.get(1);
					String minValue =(String) measureData.get(2);
					if(avgValue.equals("-")&&minValue.equals("-"))
					{
						maxValue="-";
					}
					try
					{
						if(maxValue!=null && !maxValue.equals("-"))
						{
							hiddenFields.put("maxValue",MeasureDisplay.formatValue(new Double(maxValue)+1));
						}
						if(minValue!=null && !minValue.equals("-"))
						{
							if(new Double(minValue) < 0)
								hiddenFields.put("minValue",MeasureDisplay.formatValue(new Double(minValue)-1));
							else
								hiddenFields.put("minValue",new Double("0"));
						}
					}catch(Exception e){System.out.println("Number Format------------------->"+e);}
					if(!legendsList.contains(measureName))
					{
						JSONObject MeasureGridData = new JSONObject();
						MeasureGridData.put("MeasuresDisplay",mappingInfo.getMeasureDescription(str_test,temp));
						MeasureGridData.put("MeasuresDisplayUnit", unitTemp);
						MeasureGridData.put("MeasureAvgDisplay", MeasureDisplay.formatValue(avgValue));
						MeasureGridData.put("MeasureMaxDisplay", MeasureDisplay.formatValue(maxValue));
						MeasureGridData.put("MeasureMinDisplay", MeasureDisplay.formatValue(minValue));
						dataArray.add(MeasureGridData);	
					}
				}
				gridData.put("MeasureGridData",dataArray);
			}
		}
		
	}
	else
	{
		isGraph = true;
		hiddenFields.put("measure", request.getParameter("measure"));
		String t_gtype = request.getParameter("gtype");
		if(t_gtype == null)
			t_gtype = request.getParameter("s_gtype");
		hiddenFields.put("gtype", t_gtype);
		hiddenFields.put("msmt_host", request.getParameter("msmt_host"));
		
		json.put("error",mappingInfo.getTextDescription("monitor.measureGraph.There is no Graph for this test&#46 Please select DATA to view the previous Data"));
	}	
	String showLegStr = request.getParameter("showLegend");
	if(showLegStr == null || showLegStr.equals(""))
	{
		showLegStr = iniFile.getValue("CHART_TYPE","showLegendsInCharts");
		
	}
	json.put("showLegend",request.getParameter("showLegend"));
	json.put("LegendInChart",showLegStr);
	json.put("ChartType",s_gformat);
	json.put("CurrentDateError",mappingInfo.getTextDescription("monitor.common.From and To Date should be lesser than Current date"));
	json.put("MeasureErrormsg",mappingInfo.getTextDescription("monitor.measureGraph.Please select atleast one measure"));
	json.put("DateErrormsg",mappingInfo.getTextDescription("monitor.common.From date should be lesser than To date"));
	json.put("DataRangeError", mappingInfo.getTextDescription("monitor.measureGraph.From value should be less than To value"));
	json.put("HiddenFields",hiddenFields);
	json.put("FormFields",formArray);
	json.put("GridData",gridData);
	v_mes.clear(); 
	v_mes_case.clear(); 
	session.setAttribute("curTabQS",request.getQueryString());
	
	response.getWriter().write(json.toString());
}
catch(Exception t){
	response.getWriter().write(t.toString());
}
%>			
