<%
/************************************************************************************************************
*	Name				:	EgDispCompLayers.jsp
*	Version				:	eG 3.0
*	Purpose				:	Component Layers Status that is displayed in the right iframe of Layers Page
*	Creation Date			:	?????
*	Author				:	Arun / John Williams
*	Last Modified			:	14/10/2003	John	eG 3.0 Modifications
*						23/10/2003	John	Adjusted the height of Component Layers for giving more
*									space/height to Measurements
*						02/12/2003	Arun	Fixed a problem where Printer server type showed a HOST 
*									layer while in GOOD state
************************************************************************************************************/
%>
<%@ include file = "EgLoginTracker.jsp" %>
<%@ page import = "com.eg.EgDbAdapterTypeUI" %>
<%@ page import = "com.eg.EgDiscInfo" %>
<%@ page import = "com.eg.EgGroupInfo" %>
<%@ page import = "com.eg.EgTablesInfo" %>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.egurkha.monitor.*" %>
<%@ page import = "com.egurkha.monitor.alarms.*" %>
<%@ page import = "egurkha.*" %>
<%@ page import = "java.sql.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "com.eg.EgTopoInfo" %>
<%@ page errorPage="EgErrorLayersSmall.jsp" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%!
	EgDiscInfo discInfo = new EgDiscInfo("manager");
%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	EgDbAdapterUI egDb;
%>
	
<jsp:useBean id="sitebean" scope="page" class="egurkha.ConfigSiteBean" />
<html>
<head>
<egui:skin ui="monitor"/>
<script language="JavaScript1.2" src="eg_scripts/eg_validate.js"></script>
</head>
<body>

<table align="center" cellspacing="0" cellpadding="2" width="100%" border="0">
<tr>
	<td align="center" valign="middle" height="240">
<%
	EgGroupInfo groupinfo = new EgGroupInfo();
	//out.println("The Query String is " + request.getQueryString());
	AlarmPriorities ap = AlarmPriorities.getInstance();
	
	Vector v_comp = new Vector();
	Vector v = new Vector();
	Vector v_servers_nosites = new Vector();

	String str_hostimg = null;
	String str_image = null;
	String str_comp_topo_layer = null;
	String str_conn = null;
	String s_tmp_layer = request.getParameter("layer");
	String s_test = request.getParameter("test");
	String str_site = request.getParameter("site");
	String str_host = request.getParameter("host");
	String str_host_type = request.getParameter("comptype");
	String s_flagalarm = request.getParameter("fromalarm");
	String flag_state = AlarmPriorities.GOOD_STATE;
	String flag_state_host="";
	String serverType = "";
	
	EgTopoInfo topo = new EgTopoInfo("manager");
	boolean isThisCompAssociatedToSite = false;
	if(str_site != null && !str_site.equals(""))
	{
		String[] mappedComps = topo.getMappingForWebSite(str_site);
		if(mappedComps != null && mappedComps.length > 0)
		{
			for(int x=0;x<mappedComps.length;x++)
			{
				String thisComp = mappedComps[x];
				if (!thisComp.startsWith("Group"))
				{
					if(mappedComps[x].equals(str_host_type+":"+str_host))
						isThisCompAssociatedToSite = true;
				}else{
					String thisGrp = thisComp.substring(thisComp.indexOf(":")+1, thisComp.lastIndexOf(":"));
					ArrayList grpCmps = groupinfo.getAllComponentsUnderGroup(thisGrp);
					if(grpCmps.contains(str_host_type+":"+str_host))
						isThisCompAssociatedToSite = true;
				}
			}
		}
	}
	
	ResultSet rs_comp_topo = null;
	ResultSet rs_report = null;
	
	egDb = EgDbAdapterTypeUI.getObject();
	try
	{
		str_conn = egDb.setConnection();
		if (str_conn != null && str_conn.equalsIgnoreCase("CONNECTED"))
		{
			rs_comp_topo = egDb.SelectDispLayers_1(str_host,str_host_type);
			String[] s_servers_nosites = discInfo.getAllServersOfType("Site_servers");
			for(int a=0; a<s_servers_nosites.length; a++)
			{
				v_servers_nosites.add(s_servers_nosites[a]);
			}

			while(rs_comp_topo != null && rs_comp_topo.next())
			{
				String s_tmp = rs_comp_topo.getString("layer_name");
				if (s_tmp == null)
					continue;
				if(v_servers_nosites.contains(str_host_type) && str_site.equals("NULL")&& (s_tmp.equals("WEB_TRANSACTIONS") || s_tmp.equals("WEB_SITE")))
				{
					continue;
				}
				else if(sitebean.isAService(str_site) && ((s_tmp.equals("WEB_TRANSACTIONS")) || (s_tmp.equals("WEB_SITE"))))
				{
					continue;
				}
				else if(!isThisCompAssociatedToSite && ((s_tmp.equals("WEB_TRANSACTIONS")) || (s_tmp.equals("WEB_SITE"))))
				{
					continue;
				}
				else
				{
					v_comp.addElement(s_tmp);
				}
			}
			if (rs_comp_topo != null)
				rs_comp_topo.close();
			rs_comp_topo = null;
			
			//Removal of unwanted same level layers
			if(s_tmp_layer != null)
			{
				if(v_comp.contains("TCP") && v_comp.contains("UDP"))
				{
					if(!s_tmp_layer.equals("UDP"))
					{
						v_comp.removeElement("UDP");
					}
					else
					{
						v_comp.removeElement("TCP");
					}
				}
			}

			//New code
			//To fix the foll bug: If there is an alarm with a Network_node, the alarm shows up as being for Host_system. If there is a problem with this node, when you click Host_system, we see Tcp and Host layers. These layers may not be relevant for a Network_node. NETWORK layer alone is relevant for Network_node.
			String tname = "";
			String sType = "";
			
			String variables[];
			StringTokenizer st;
			
			if(str_host_type.equalsIgnoreCase(Server.HOST_SYSTEM))
			{
				//out.println("test is " + s_test);
				if(s_test != null && s_test.indexOf("-") > -1)
				{
					s_test = s_test.substring(0,s_test.indexOf("-"));
				}
				String cname = str_host;
				cname = cname.substring(0,cname.indexOf(":"));
					
				serverType = discInfo.getTypeForHostTest
						(cname, s_test);
				EgTablesInfo tablesInfo = new EgTablesInfo("manager");
				v_comp = tablesInfo.getLayersRelevantForHost_system(serverType,v_comp);
				tablesInfo = null;
			}
			//End of new code

			rs_report=egDb.SelectDispLayers_2(str_site, s_flagalarm, str_host_type, str_host);
			while(rs_report != null && rs_report.next())
			{
				String str_layer=rs_report.getString("layer_name");
				String str_state=rs_report.getString("priority");
				v.addElement(str_layer + ";" + str_state);
			}
			if (rs_report != null)
				rs_report.close();
			rs_report = null;
			egDb.releaseConnection(false);
		}
		EgDbAdapterTypeUI.releaseObject(egDb);
	}
	catch(Exception e)
	{
		e.printStackTrace();
		String s_errmsg = "";
		if(!str_conn.equals("CONNECTED"))
		{
			s_errmsg = "Connection could not be established with the database";
		}
		else
		{
			s_errmsg = e.toString();
		}
		if (rs_comp_topo != null)
		{
			try
			{
				rs_comp_topo.close();
			}
			catch (Exception bug123)
			{
			}
		}
		if (rs_report != null)
		{
			try
			{
				rs_report.close();
			}
			catch (Exception bug123)
			{
			}
		}
		try
		{
			egDb.releaseConnection(true);
		}
		catch(Exception ex)
		{
		}
		EgDbAdapterTypeUI.releaseObject(egDb);
		s_errmsg = "EgErrorLayersSmall.jsp?msg=" + s_errmsg;

		//Forwarding to the errorhandler
%>
		<jsp:forward page="<%=s_errmsg %>" />
<%
		return;
	}
	
	
	
	/*
	 * v : Vector of non-GOOD layers with states, in the form Layer:State
	 *
	 * v_comp : Vector of all layers for this server type
	 *
	 * By default, the flag for the HOST layer is set to NO. Depending on the 
	 * conditions, the HOST layer will be displayed by setting the state value
	 */

	flag_state_host = "NO";
	
	if(v.size() == 0 || v.contains("HOST;GOOD") || v_comp.contains("HOST"))
	{
		flag_state_host = AlarmPriorities.GOOD_STATE;
		str_hostimg = "GOOD";
	}

	if(v.contains("HOST;HIGH"))
	{
		flag_state_host = "HIGH";
		str_hostimg = "HIGH";
	}
	else if(v.contains("HOST;INTERMEDIATE"))
	{
		flag_state_host = "INTERMEDIATE";
		str_hostimg = "INTERMEDIATE";
	}
	else if(v.contains("HOST;LOW"))
	{
		flag_state_host = "LOW";
		str_hostimg = "LOW";
	}
	else if(v.contains("HOST;UNKNOWN"))
	{
		flag_state_host = AlarmPriorities.UNKNOWN_STATE;
		str_hostimg = "UNKNOWN";
	}
	
	
	//Check HOST layer validity for Server Type
	
	LayerBean layerBean = new LayerBean();
	ArrayList a_server_layers = layerBean.getLayersForServer(str_host_type);
	if(a_server_layers != null && !a_server_layers.contains("HOST"))
	{
			flag_state_host = "NO";
	}
	
	
	// This condition is for filtering the HOST Layer for NETWORK Node
	
	if(v != null && v.size() == 0 && v_comp != null && v_comp.size() == 1 && v_comp.contains("NETWORK"))
	{
		flag_state_host = "NO";
	}
	
	
	
//	System.out.println("The Value of flag_state_hist is " + flag_state_host);
%>

		<table width="290" align="center" cellspacing="0" cellpadding="0" border="0">
			<tr>
				<td width="36" height="20" nowrap><img src="eg_images/eg_layout/LayersTopLeft.gif" width="36" height="20" /></td>
				<td width="234" height="20" id="eg_blankspace" background="eg_images/eg_layout/LayersTop.gif" nowrap>&nbsp;</td>
				<td width="20" height="20" nowrap><img src="eg_images/eg_layout/LayersTopRight.gif" width="20" height="20" /></td>
			</tr>
		</table>
<%
//		System.out.println("V_COMP is " + v_comp);
//		System.out.println("V is " + v);
		for (int c_ctr = 0;c_ctr<v_comp.size();c_ctr++)
		{
			flag_state = AlarmPriorities.GOOD_STATE;
			str_comp_topo_layer=(String)v_comp.elementAt(c_ctr);
			if(str_comp_topo_layer.equals("HOST"))
			{
				continue;
			}
			for(int i=0; i<v.size();i++)
			{
				String temp =(String) v.elementAt(i);
				if(temp.equals(str_comp_topo_layer+";HIGH"))
				{
					flag_state = "HIGH";
				}
				else if(temp.equals(str_comp_topo_layer+";INTERMEDIATE"))
				{
					flag_state = "INTERMEDIATE";
				}
				else if(temp.equals(str_comp_topo_layer+";LOW"))
				{
					flag_state = "LOW";
				}
				else if(temp.equals(str_comp_topo_layer+";UNKNOWN"))
				{
					flag_state = "UNKNOWN";
				}
			}
			//str_image = "host"+flag_state+".gif";
			String qryString = "site="+str_site+"&host="+str_host+"&qctr=1&layer="+str_comp_topo_layer+"&comptype="+str_host_type+"&fromalarm="+s_flagalarm+"&layerpriority="+flag_state+"&test="+s_test+"&faketype="+serverType;
%>
		<!-- Topmost Layer -->
		<table width="290" align="center" cellspacing="0" cellpadding="0" border="0">
			<tr>
				<td width="36" height="26" valign="top" background="eg_images/eg_layout/LayersLeft.gif">
					<a target="main" onClick="javascript:openRequest('<%=qryString %>');" id="leftmouse">
						<img src="eg_images/eg_layout/LayersL<%=flag_state%>.gif" width="36" height="26" border="0" />
					</a>
				</td>
				<td class="eg_darktextbold" align="center" height="26" background="eg_images/eg_layout/Layers<%=flag_state%>.gif">
					<a target="main" onClick="javascript:openRequest('<%=qryString %>');" id="leftmouse">
						<%=str_comp_topo_layer%>
					</a>
				</td>
				<td width="20" height="26" valign="top" background="eg_images/eg_layout/LayersRight.gif"><a target="main" onClick="javascript:openRequest('<%=qryString %>');" id="leftmouse"><img src="eg_images/eg_layout/LayersR<%=flag_state%>.gif" width="20" height="26" border="0" /></a></td>
			</tr>
		</table>
<%
		}
		//cleanup
		v_comp.removeAllElements();
		v.removeAllElements();
		v_servers_nosites.removeAllElements();

		if(flag_state_host.equals("NO"))
		{
%>
		<table width="290" align="center" cellspacing="0" cellpadding="0" border="0">
			<tr>
				<td width="36" height="20" nowrap><img src="eg_images/eg_layout/LayersBotLeft.gif" width="36" height="20" /></td>
				<td width="234" height="20" id="eg_blankspace" background="eg_images/eg_layout/LayersBot.gif" nowrap>&nbsp;</td>
				<td width="20" height="20" nowrap><img src="eg_images/eg_layout/LayersBotRight.gif" width="20" height="20" /></td>
			</tr>
		</table>
<%
		}
		else
		{
			String qryString = "site="+str_site+"&host="+str_host+"&qctr=1&layer=HOST&comptype="+str_host_type+"&fromalarm="+s_flagalarm+"&layerpriority="+str_hostimg+"&test="+s_test+"&faketype="+serverType;
%>
		<!-- This layer will show the host condition -->
			<table width="290" align="center" cellspacing="0" cellpadding="0" border="0">
				<tr>
					<td width="36" height="20" nowrap valign="top"><img src="eg_images/eg_layout/LayersBotLeft.gif" width="36" height="20" border="0" /></td>
					<td width="234" height="20" id="eg_blankspace" background="eg_images/eg_layout/LayersBot.gif" valign="top">
						<table align="center" cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td width="27" height="36" nowrap valign="top"><a target="main" onClick="javascript:openRequest('<%=qryString%>');" id="leftmouse"><img src="eg_images/eg_layout/Host<%=str_hostimg%>.gif" width="27" height="30" border="0" /></a></td>
								<td class="eg_darktextbold" align="center" nowrap background="eg_images/eg_layout/HostBG.gif"> &nbsp; <a target="main" onClick="javascript:openRequest('<%=qryString%>');" id="leftmouse">HOST</a> &nbsp; </td>
							</tr>
						</table>
					</td>
					<td width="20" height="20" nowrap valign="top"><img src="eg_images/eg_layout/LayersBotRight.gif" width="20" height="20" border="0" /></td>
				</tr>
			</table>
		<!-- Host ends here -->
<%
		}
%>
<!-- Layers Table ends here -->
		</td>
	</tr>
</table>
<%!
	public String checkForNULL(String str)
	{
		if(str != null && str.equals("NULL"))
		{
			return "NONE";
		}
		else
		{
			return str;
		}
	}
%>