<%
/*****************************************************************************************************************
*	Name			:	makeSeparateInis.jsp
*	Purpose			:	Used for putting all newly created default aggregate test entries into corresponding ini files
*	Version			:	5.7
*	Creation Date	:	28th March 2013
*	Author			:	James Thomas P
/*****************************************************************************************************************/
%>
<%@ page import="com.eg.*"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="java.util.*"%>
<%@ page import="java.io.*"%>

<%
	String miscDir = EgInstallInfo.getInstallDir()+"/manager/tomcat/webapps/final/misc";
	String filename = null;
	File dir = new File(miscDir);
	String allFiles[] = dir.list();
	ArrayList files = new ArrayList();
	for(int i=0;i<allFiles.length;i++)
	{
		filename = allFiles[i];
		if(filename.endsWith("_ag.ini"))
		{
			files.add(filename);
		}
	}
	int size = files.size();
	if(size>0)
	{

		String inifilenames[] = {"eg_aggregate.ini","eg_tables.ini","eg_thresholds.ini","eg_specs.ini","eg_testparam.ini","eg_ui.ini"};
		String newAggTests[] = (String[])files.toArray(new String[size]);

		String test_mapping = null;
		String default_test_mapping = null;

		for(int i=0;i<inifilenames.length;i++)
		{
			String inifilename = inifilenames[i];
			IniFile writeObject = new IniFile((miscDir + "/" + inifilename),true);

			String subjects[] = null;
			if(inifilename.equals("eg_specs.ini"))
			{
				subjects = new String[]{"TEST_MAPPING","TEST_SPECIFICATION","DEFAULT_TEST_MAPPING","AGGREGATE_TESTS"};
			}
			else if(inifilename.equals("eg_tables.ini"))
			{
				subjects = new String[]{"MEASUREMENT_LAYER_TABLE","MEASUREMENT_UNITS_TABLE"};
			}
			else if(inifilename.equals("eg_aggregate.ini"))
			{
				subjects = new String[]{"AGGREGATE_TEST","PRE_DEFINED_AGGREGATE_TEST","AGGREGATE_FUNCTION","COLUMN_NAME_MAPPING","XXX_Template","DEFAULT_ENABLED_TEMPLATES"};
			}
			else if(inifilename.equals("eg_thresholds.ini"))
			{
				subjects = new String[]{"DEFAULT_THRESHOLDS"};
			}
			else if(inifilename.equals("eg_testparam.ini"))
			{
				subjects = new String[]{"RADIO"};
			}
			else if(inifilename.equals("eg_ui.ini"))
			{
				subjects = new String[]{"Measure_value_display"};
			}
			for(int j=0;j<newAggTests.length;j++)
			{
				String newAggTest = newAggTests[j];
				IniFile readObject = new IniFile((miscDir + "/" + newAggTest));
				for(int k=0;k<subjects.length;k++)
				{
					String thisSubject = subjects[k];
					Vector vars = readObject.getVariables(thisSubject,true);
					Vector vals = readObject.getAllValues(thisSubject);
					if(vars != null && vals != null && vars.size()>0 && vars.size() == vals.size())
					{
						if(k==0 && inifilename.equals("eg_aggregate.ini"))
						{
							subjects[4] = (String)vals.get(0) + "_Template";
						}
						if(inifilename.equals("eg_specs.ini") && (thisSubject.equals("TEST_MAPPING") || thisSubject.equals("DEFAULT_TEST_MAPPING")))
						{
							if(thisSubject.equals("TEST_MAPPING"))
							{
								if(test_mapping == null)
								{
									test_mapping = (String)vals.get(0);
								}
								else
								{
									test_mapping += (String)vals.get(0);
								}
							}
							if(thisSubject.equals("DEFAULT_TEST_MAPPING"))
							{
								if(default_test_mapping == null)
								{
									default_test_mapping = (String)vals.get(0);
								}
								else
								{
									default_test_mapping += (String)vals.get(0);
								}
							}
						}
						else
						{
							for(int l=0;l<vals.size();l++)
							{
								writeObject.setValue(thisSubject,(String)vars.get(l),(String)vals.get(l));
							}
						}
					}
				}
			}
			if(inifilename.equals("eg_specs.ini"))
			{
				if(test_mapping != null)
				{
					writeObject.setValue("TEST_MAPPING","Host_system",test_mapping);
				}
				if(default_test_mapping != null)
				{
					writeObject.setValue("DEFAULT_TEST_MAPPING","Host_system",default_test_mapping);
				}
			}
			writeObject.saveFile();
		}
	}
%>