<%
/*
 *   File					:	EcOswiseComponentStatus.jsp
 *   Purpose				:	Displays distribution of systems across operating environment and version
 *   Creation Date			:	24/07/2006
 *   Author					:	Balasigamani
 *   UI Design				:	Jaiwin
 */
%>

<%@ include file = "EcTracker.jsp" %>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import = "java.net.URLEncoder" %>
<%@ page import="java.util.*" %>
<%@ page import="com.egurkha.User" %>
<%@ page import="com.egurkha.UserRegistry" %>
<%@ page import="com.egurkha.EgUserRole" %>
<%@ page import="com.egurkha.EgObject" %>
<%@ page import="egurkha.config.EcProcessData" %>
<%@ page import="com.eg.EgConfigTestsInfo" %>
<%@ page import="com.eg.EgConfigConstants"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="egurkha.config.ConfigDbSetting"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import="egurkha.config.EcFusionChartBean" %>
<%@ page import = "com.eg.EgURLEncoder"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<script type="text/javascript" src="/final/FusionCharts/scripts/FusionCharts.js"></script>
<%!
	int displayLength=40;
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	EgConfigTestsInfo configTestsInfo=new EgConfigTestsInfo("manager");
	String countSort=configTestsInfo.getServerDisplayValue("SORT_BY_COUNT","InventoryByOperatingSystemVersion");
	String showVersion=request.getParameter("version");
	String countValue="";
	String countName="";
	String colorValue="";
	String barLabelColor="";
	String osSelected = "";
	String osvSelected = "";
	int pieChartLimitStr = configTestsInfo.getPieChartSamplesLimit();
	//boolean sorting=(countSort.equalsIgnoreCase("true"))?true:false;
	boolean sorting = false;
	if (countSort != null && countSort.equalsIgnoreCase("true"))
	{
		sorting = true;
	}

	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	EgUserRole myrole = user.getUserRole();
	String userLanguage = user.getLanguage();
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	EcProcessData processData=new EcProcessData();
	processData.setUserObject(user);
	ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");
	processData.setAssociatedComponents(aListAssociatedComponents);
	Map hostAgentsMapping = (Map)session.getAttribute("hostAgentsMapping");
	processData.setHostAgentsMapping(hostAgentsMapping);

	//Map dashboardSetting = (Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.USER_COMMON_SETTING);
	String barColor = configTestsInfo.getServerDisplayValue("MISC_ARGS","ChartColor");
	String chartDataRepresentation = configTestsInfo.getServerDisplayValue("MISC_ARGS","ChartDataRepresentation");

	Map dashboardSetting = (Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.DASHBOARD_SETTING);
	if(showVersion==null)
	{
		if(dashboardSetting !=null && dashboardSetting.size()>0)
		{
			String versionFlag=(String)dashboardSetting.get(EgConfigConstants.OS_VERSION);
			if(versionFlag != null && versionFlag.equalsIgnoreCase("No"))
				showVersion="Yes";
		}
	}
	if(showVersion!=null && showVersion.equalsIgnoreCase("Yes"))
	{
		processData.setVersion(true);
		osvSelected = "selected";
	}
	else
	{
		osSelected = "selected";
	}

	Map resultData = new TreeMap();

	String ec_criteria = request.getParameter("ec_criteria");
	String ec_userOption = request.getParameter("ec_userOption");
	String machines = request.getParameter("machines");
	String nwDevSelected = "";
	String virtuSelected = "";
	String linkURL = "../servlet/com.eg.EcConfigurationServlet?cmd=OSInventory&request_from=HomePage &ec_criteria="+ec_criteria+"&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"");
	String linkURLCaption = "Machines";
	boolean isNWDevices = false;
	boolean isVirtualization = false;
	if (machines != null && machines.length() > 0)
	{
		showVersion="No";
		if (machines.equals("NetworkDevices"))
		{
			nwDevSelected = "selected";
			osvSelected = "";
			osSelected = "";
			isNWDevices = true;
			resultData = (TreeMap)processData.getNetworkDevicesMap(userLanguage);
			linkURLCaption = "Components";
			linkURL = "../servlet/com.eg.EcConfigurationServlet?cmd=ComponentsView&selectedType=External&componentType=All&requestFrom=HomePage&ec_criteria="+ec_criteria+"&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"");
		}
		else if (machines.equals("Virutualization"))
		{
			virtuSelected = "selected";
			osvSelected = "";
			osSelected = "";
			isVirtualization = true;
			resultData = (TreeMap)processData.getVirtualServersMap(userLanguage);
			linkURLCaption = "Components";
			linkURL = "../servlet/com.eg.EcConfigurationServlet?cmd=ComponentsView&selectedType=Virtual&componentType=All&requestFrom=HomePage&ec_criteria="+ec_criteria+"&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"");
		}
	}
	else
	{
		resultData =(TreeMap)processData.getOSDetails("HomePage");
	}
%>
<html>
<head>
<title>
	<egui:intnl text="configmgmt.dashboard.eG Configuration" /> : <egui:intnl text="configmgmt.dashboard.Machines By OS and OS Version" />
</title>
<egui:skin ui="config"/>
</head>
<body leftmargin="0" topmargin="0" marginheight="0" marginwidth="0" bgcolor="#FFFFFF" >
<!-- <form name="OSWise" method="POST">  -->
<INPUT TYPE="hidden" name="version" value="<%=showVersion%>">

<table width="100%" align="center" border="0" cellpadding="0" cellspacing="0" id="innertable" style="table-layout:auto"><col width="60%"><col width="40%">

	<tr>
		<td class="tdbackcolortop pLeft4"><a href="<%=linkURL%>" target="" class="eg_headlink_white"><b><egui:intnl text='<%="configmgmt.dashboard."+linkURLCaption%>'/></b></a>
		</td>
		<td width="40%" class="tdbackcolortop" align="right">
			<table width="100%" align="right" border="0" cellpadding="0" cellspacing="0">
				<tr>
					<td class="tdbackcolortop" align="right" nowrap>
						<select name="ec_osOption" onChange="javascript:getOSwiseMachineStatus()" style="width:120px">
							<option value="OS" <%=osSelected%>><egui:intnl text="configmgmt.dashboard.By OS"/></option>
							<option value="OSVersion" <%=osvSelected%>><egui:intnl text="configmgmt.dashboard.By OS Version"/></option>
							<option value="NetworkDevices" <%=nwDevSelected%>><egui:intnl text="configmgmt.dashboard.Network Devices"/></option>
							<option value="Virutualization" <%=virtuSelected%>><egui:intnl text="configmgmt.dashboard.Virtual Platforms"/></option>
						</select>
					</td>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td width="100%" colspan="2" valign="top" align="center" id="body_text">
<%
	if(resultData==null || resultData.size()==0)
	{
		if(myrole.hasAllComponentAccess())
		{
%>
			<table border="0" cellspacing="0" cellpadding="0" height="100%">
				<tr>
					<td align="center" colspan="2" height="150px" valign="middle">
						<table border="0" cellspacing="0" cellpadding="0" class="body_text" height="100%">
							<tr>
								<td align="center" height="80" valign="bottom">
									<img src="/final/config/images/unavailable-data.gif" alt='<egui:intnl text="configmgmt.common.No Data" />' >
								</td>
							</tr>
							<tr>
								<td align="center" valign="top" height="60">
									<egui:intnl text="configmgmt.dashboard.No components have been enabled for configuration" />
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
<%
		}
		else
		{
%>
			<table border="0" cellspacing="0" cellpadding="0" height="100%">
				<tr>
					<td align="center" colspan="2" height="150px" valign="middle">
						<table border="0" cellspacing="0" cellpadding="0" class="body_text" height="100%">
							<tr>
								<td align="center" height="80px" valign="bottom">
									<img src="/final/config/images/unavailable-data.gif" alt='<egui:intnl text="configmgmt.common.No Data" />' >
								</td>
							</tr>
							<tr>
								<td align="center" valign="top" height="60px">
									<egui:intnl text="configmgmt.dashboard.No components have been associated for this user" />
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
<%
		}
	}
	else if(showVersion!=null && showVersion.equalsIgnoreCase("Yes"))
	{
		Map osData=new TreeMap();
		Iterator osVersion=resultData.keySet().iterator();
		while(osVersion.hasNext())
		{
			String osWithVersion=(String)osVersion.next();
			Hashtable sysName=(Hashtable)resultData.get(osWithVersion);
			StringTokenizer st=new StringTokenizer(osWithVersion,"#");
			String osName=st.nextToken();
			String version=st.nextToken();
			Hashtable h=(Hashtable)osData.get(osName);
			if(h==null || h.size()==0)
			{
				Hashtable ver=new Hashtable();
				ver.put(version,sysName);
				osData.put(osName,ver);
			}
			else if(h!=null && h.contains(version))
			{
				Hashtable strVer=(Hashtable)h.get(version);
				strVer.putAll(sysName);
				h.put(version,strVer);
				osData.put(osName,h);
			}
			else
			{
				h.put(version,sysName);
				osData.put(osName,h);
			}
		}

		int maxCount = 0;
		Object[] keySet2 = osData.keySet().toArray();
		Map osCount = new TreeMap();
		ArrayList os_Name=new ArrayList();
		ArrayList countVal=new ArrayList();

		int systemCount = 0;

		for (int a=0; a<keySet2.length; a++)
		{
			String osName = (String)keySet2[a];
			Hashtable VersionStatus = (Hashtable)osData.get(osName);
			Iterator it1=VersionStatus.keySet().iterator();
			int size=0;
			while(it1.hasNext())
			{
				String versionName=(String)it1.next();
				Hashtable sysName=(Hashtable)VersionStatus.get(versionName);
				int thisCount = sysName.size();
				size+=thisCount;
				systemCount+=thisCount;
			}
			os_Name.add(osName);
			countVal.add(new Integer(size));
			osCount.put(osName,new Integer(size));
			maxCount = Math.max(maxCount, size);
		}

		Object[] displayData = osData.keySet().toArray();
		if (displayData.length > 0)
		{
			Arrays.sort(displayData);
		}
		if(sorting)
		{
			Object [] tmpArray = countVal.toArray();
			int [] valueArray = new int[tmpArray.length];
			for (int i=0; i<tmpArray.length; i++)
			{
				valueArray[i] = ((Integer)tmpArray[i]).intValue();
			}
			Arrays.sort(valueArray);
			for (int i=valueArray.length-1; i>=0; i--)
			{
				int thisIndex = countVal.indexOf(new Integer(valueArray[i]));
				tmpArray[i] = (String)os_Name.get(thisIndex);
				displayData[valueArray.length-1-i] = tmpArray[i];
				os_Name.remove(tmpArray[i]);
				countVal.remove(new Integer(valueArray[i]));
			}
		}
%>
			<div id="div_scroll" style="width:100%;height:150px;border:0px solid #ff0000">
			<table width="100%" border="0" cellpadding="0" valign="top" cellspacing="0" class="body_text" style="table-layout:fixed"><col width="65%"><col width="35%">

				<tr>
					<td align="center" width="100%" colspan="2">
						<table width="100%" border="0" cellpadding="0" valign="top" cellspacing="0" height="18px">
							<tr>
								<td align="center" width="100%"  class="text_bold" id="tdbacklightcolor3">
									<egui:intnl text="configmgmt.dashboard.Total Systems" /> : <%=systemCount%>
								</td>
							</tr>
						</table>
					</td>
				</tr>

				<tr>
					<td nowrap height="20px" width="65%" align="center" class="table_header_dash">
						&nbsp;<egui:intnl text="configmgmt.dashboard.Operating system" />
					</td>
					<td align="center" width="35%">
						<table width="100%" border="0" cellpadding="0" valign="top" cellspacing="0" class="body_text" height="15" style="table-layout:fixed"><col width="50%"><col width="50%">
							<tr>
								<td align="center" width="50%" class="table_header_dash" height="20px">
									&nbsp;<egui:intnl text="configmgmt.dashboard.Version" />
								</td>
								<td  nowrap width="50%" align="center" class="table_header_dash" style="border-right-width:0px">
									&nbsp;<egui:intnl text="configmgmt.dashboard.Count" />
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
		for(int n=0;n<displayData.length;n++)
		{
			String displayOsName="";
			String osystemName=(String)displayData[n];
			Hashtable osDetail=(Hashtable)osData.get(osystemName);
			int size=((Integer)osCount.get(osystemName)).intValue();
			int tableWidth = size*100/maxCount;
			tableWidth = tableWidth<1?1:tableWidth;

			if(osystemName.indexOf("Microsoft")>-1)
				displayOsName=osystemName.substring(osystemName.indexOf(' ')+1);
			else
				displayOsName=osystemName;

			if(displayOsName.indexOf(',')>-1)
				displayOsName=displayOsName.replace(',',' ');
%>
				<tr>
					<td nowrap width="65%" align="left" valign="top" class="cell_border" id="tdbacklightcolor2" style="padding:2px">
						<a href="/final/servlet/com.eg.EcConfigurationServlet?cmd=OSInventory&request_from=OSVersion&osName=<%=osystemName%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=(ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""%>" target="" class="eg_monlink" title="<%=displayOsName%>">
							&nbsp;<egui:display name="<%=displayOsName%>" length='<%=displayLength+""%>'/>&nbsp;(<%=size%>)
						</a>
					</td>

					<td align="center" width="35%" style="padding:0px">
						<table width="100%" border="0" cellspacing="0" cellpadding="0" style="table-layout:fixed"><col width="50%"><col width="50%">
<%
			Object[] keyValue = osDetail.keySet().toArray();
			if (keyValue.length > 0)
			{
				Arrays.sort(keyValue);
			}
			for (int j=0; j<keyValue.length;j ++)
			{
				String versionName=(String)keyValue[j];
				Hashtable h=(Hashtable)osDetail.get(versionName);
				String linkOsName=osystemName+"#"+versionName;
%>
							<tr>
								<td align="left" width="50%" id="cell_border" valign="top" style="padding:2px;">
<%
				if (versionName.length()>10)
				{
%>
								<a href="/final/servlet/com.eg.EcConfigurationServlet?cmd=OSInventory&request_from=OSVersion&osName=<%=URLEncoder.encode(linkOsName)%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=(ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""%>" class="eg_monlink" title="<%=versionName%>">&nbsp;<%=versionName.substring(0,10)+"..."%></a>
<%
				}
				else
				{
%>
								<a href="/final/servlet/com.eg.EcConfigurationServlet?cmd=OSInventory&request_from=OSVersion&osName=<%=URLEncoder.encode(linkOsName)%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=(ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""%>" class="eg_monlink">&nbsp;<%=versionName%></a>
<%
				}
%>
								</td>
								<td align="center" width="50%"  valign="top" id="tdbacklightcolor2" style="border-right-width:0px" style="padding:2px">
									<a href="/final/servlet/com.eg.EcConfigurationServlet?cmd=OSInventory&request_from=OSVersion&osName=<%=URLEncoder.encode(linkOsName)%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=(ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""%>" class="eg_monlink">
										<%=h.size()%>
									</a>
								</td>
							</tr>
<%
			}
%>
						</table>
					</td>
				</tr>
<%
		}
%>
			</table>
			</div>
<%
	}
	else
	{
		if (isNWDevices || isVirtualization) // Network Devices or Virtual Servers
		{
			int totalCount = 0;
			String sampleValue = "";
			List typeList = new ArrayList();
			TreeMap tempData = new TreeMap(resultData);
			Object[] keySetArr =  tempData.keySet().toArray();
			String color = "color";
			int colorCount = 0;
			int arrLen = keySetArr.length;
			int endLimit = 0;
			int pieChartLimit = configTestsInfo.getPieChartSamplesLimit();
			String sortByCountFlag = configTestsInfo.getSortTypeForComponentsView();
			boolean sortByCount = false;
			if (sortByCountFlag != null && sortByCountFlag.equalsIgnoreCase("true") || sortByCountFlag.equalsIgnoreCase("yes"))
			{
				sortByCount = true;
			}

			ArrayList pieDataList = new ArrayList();//for legend
			ArrayList piecolorList = new ArrayList();//for legend colorlist
			String legendLabel = "";
			String legendColor = "";
			String linkUrl = " ";
			String type = "External";
			if (isVirtualization)
			{
				type = "Virtual";
			}
			if (sortByCount)
			{
				if (processData.isPieChartLimitCrossed())
				{
					endLimit = arrLen-pieChartLimit;
				}
				for (int m = arrLen-1; m >= endLimit; m--)
				{
					String deviceType =(String) keySetArr[m];
					ArrayList tmpList = (ArrayList)tempData.get(deviceType);
					deviceType = deviceType.substring(deviceType.indexOf("#@#")+3);
					totalCount += tmpList.size();
					sampleValue += tmpList.size()+",";
					colorCount++;
					colorValue += configTestsInfo.getServerDisplayValue("DASHBOARD_OS_COLOR",color+colorCount)+",";
					countName += deviceType + ",";
					typeList.add(deviceType);
					linkUrl += "../servlet/com.eg.EcConfigurationServlet?cmd=ComponentsView&requestFrom=Devices&ec_criteria="+ec_criteria+"&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")+"&clickOn=pie&selectedType="+type+"&componentType="+deviceType+",";
				}
			}
			else
			{
				ArrayList resultForPie = (ArrayList)resultData.get("result");
				endLimit = resultForPie.size();
				if (processData.isPieChartLimitCrossed())
					endLimit = pieChartLimit;

				for (int j=0; j < endLimit; j++)
				{
					Hashtable ht = (Hashtable)resultForPie.get(j);
					Iterator htIt = ht.keySet().iterator();
					if (htIt.hasNext())
					{
						String compType = (String)htIt.next();
						ArrayList compsList = (ArrayList)ht.get(compType);
						colorCount++;
						colorValue += configTestsInfo.getServerDisplayValue("DASHBOARD_OS_COLOR",color+colorCount)+",";
						sampleValue += compsList.size()+",";
						countName += compType+",";
						totalCount += compsList.size();
						linkUrl += "../servlet/com.eg.EcConfigurationServlet?cmd=ComponentsView&requestFrom=Devices&ec_criteria="+ec_criteria+"&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")+"&clickOn=pie&selectedType="+type+"&componentType="+compType+",";
					}
				}
			}
			if (sampleValue.endsWith(","))
			{
				sampleValue = sampleValue.substring(0,sampleValue.length()-1);
			}
			if (colorValue.endsWith(","))
			{
				colorValue = colorValue.substring(0,colorValue.length()-1);
			}
			if (countName.endsWith(","))
			{
				countName = countName.substring(0,countName.length()-1);
			}

			if (linkUrl.endsWith(","))
			{
				linkUrl = linkUrl.substring(0,linkUrl.length()-1);
			}

			StringTokenizer strColor =  new StringTokenizer(colorValue,",");
			while (strColor.hasMoreTokens())
			{
				String temp_pieColor = strColor.nextToken();
				piecolorList.add(temp_pieColor.substring(temp_pieColor.indexOf("#")+1,temp_pieColor.length()));
			}

			StringTokenizer strToken = new StringTokenizer(countName,",");
			while (strToken.hasMoreTokens())
			{
				String strOs = strToken.nextToken();
				pieDataList.add(strOs);
			}

			//Fusion Pie Chart Data for network and virtual starts--Rekha
			HashMap mapChartAttributes = new HashMap();//map for chart attributes
			mapChartAttributes.put("bgcolor","FFFFFF");
			mapChartAttributes.put("enableSmartLabels","0");
			mapChartAttributes.put("showToolTip","0");
			mapChartAttributes.put("showPercentValues","0");
			if (chartDataRepresentation != null && chartDataRepresentation.equalsIgnoreCase("3D"))
			{
				mapChartAttributes.put("pieRadius","80");
			}
			else
			{
				mapChartAttributes.put("pieRadius","57");
			}
			mapChartAttributes.put("showBorder","0");
			mapChartAttributes.put("unescapeLinks","0");

			HashMap mapChartData = new HashMap();//map for chart data
			mapChartData.put("pieLabels",countName);
			mapChartData.put("pieValues",sampleValue);
			mapChartData.put("pieColors",colorValue);
			mapChartData.put("pieLinks",linkUrl);

			HashMap mapProperties = new HashMap();//map for misc properties
			mapProperties.put("showLabels","false");
			mapProperties.put("showColors","true");
			mapProperties.put("enableLinks","true");

			EcFusionChartBean chartbean = new EcFusionChartBean();
			String xmlString = chartbean.getXMLDataForPieChart(mapChartAttributes,mapChartData,mapProperties);
			//Fusion Pie Chart Data for network and virtual ends
%>
			<div style="width:100%;height:150px">
			<table width="100%" border="0" cellpadding="0" valign="top" cellspacing="0" class="body_text" height="20px">
				<tr>
					<td colspan="2" align="center" width="100%">
						<b>
<%
			if (isNWDevices)
			{
				if (processData.isPieChartLimitCrossed())
				{
%>
							<egui:intnl text="configmgmt.inventory.view.Total Network Devices" />&nbsp;(<egui:intnl text="configmgmt.inventory.view.Top"/>&nbsp;<%=pieChartLimitStr%>)
<%
				}
				else
				{
%>
							<egui:intnl text="configmgmt.inventory.view.Total Network Devices" />
<%
				}
			}
			else
			{
%>
							<egui:intnl text="configmgmt.inventory.view.Total Virtual Platforms" />
<%
			}
%>
						 : <%=totalCount%></b>
					</td>
				</tr>
			</table>
			<table border="0">
				<tr>
					<td align="center" valign="top" class="white_bg">
<%
			boolean flag = false;
			if (chartDataRepresentation != null && chartDataRepresentation.equalsIgnoreCase("3D"))
			{
				flag = true;
			}
			if (flag)
			{
%>
						<table align="center" cellspacing="0" cellpadding="0" border="0" height="20px" width="100%" bgcolor="#FFFFFF" valign="center">
							<tr>
								<td align="center" width="40%" bgcolor="white">
									<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="250" height="115" id="Pie3D">
										<param name="movie" value="/final/FusionCharts/swf/Pie3D.swf" />
										<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=300&chartHeight=115" />
										<param name="quality" value="high" />
										<param name="WMode" value="Transparent">
										<embed src="/final/FusionCharts/swf/Pie3D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=250&chartHeight=115" quality="high" width="250" height="115" WMode="Transparent" name="Pie3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
									</object> -->
									<div id="chartPie3DContainer"  style="height:100%;"></div>
									<script type="text/javascript">
										if  ( FusionCharts( "myPie3DChartId" ) )
												FusionCharts( "myPie3DChartId" ).dispose();
										var myChart = new FusionCharts( "/final/FusionCharts/swf/Pie3D.swf","myPie3DChartId", "250", "115","0","1");
										myChart.setXMLData("<%=xmlString%>");
										myChart.setTransparent(true);
										myChart.render("chartPie3DContainer");
									</script>
								</td>
								<td width="60%" align="left" valign="middle">
									<table border="0" width="100%" cellspacing="1" cellpadding="1">
<%
				String dispLabel = "";
				for(int k = 0; k < pieDataList.size(); k++)
				{
					legendLabel = (String)pieDataList.get(k);
					legendLabel = legendLabel.trim();
					dispLabel = mappingInfo.getComponentTypeDescription(legendLabel);
					legendColor = (String)piecolorList.get(k);
%>
										<tr>
											<td width="20%">
												<table cellpadding="0" cellspacing="0" border="0">
													<tr>
														<td align="right" valign="middle" height="5px" width="5px" class="border" style="background-color:<%=legendColor%>"><img src="/final/config/images/spacer.gif" border="0" height="5"></td>
													</tr>
												</table>
											</td>
											<td align="left" nowrap valign="top" width="80%"> <a style="font-name:Verdana;font-size:9;font-weight:plain" class="mousehand" onClick="javascript:legendCompData('<%=type%>','<%=legendLabel%>');"><%=dispLabel%></a></td>
										</tr>
<%
				}
%>
									</table>
								</td>
							</tr>
						</table>
<%
			}
			else
			{
%>
						<table align="center" cellspacing="0" cellpadding="0" border="0" height="20px" width="100%" bgcolor="#FFFFFF" valign="center">
							<tr>
								<td align="center" width="40%" bgcolor="white">
									<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="250" height="115" id="Pie2D">
										<param name="movie" value="/final/FusionCharts/swf/Pie2D.swf" />
										<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=300&chartHeight=115" />
										<param name="quality" value="high" />
										<param name="WMode" value="Transparent">
										<embed src="/final/FusionCharts/swf/Pie2D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=250&chartHeight=115" quality="high" width="250" height="115" name="Pie2D" type="application/x-shockwave-flash" WMode="Transparent" pluginspage="//www.macromedia.com/go/getflashplayer" />
									</object> -->
									<div id="chartPie2DContainer"  style="height:100%;"></div>
									<script type="text/javascript">
										if  ( FusionCharts( "myPie2DChartId" ) )
												FusionCharts( "myPie2DChartId" ).dispose();
										var myChart = new FusionCharts( "/final/FusionCharts/swf/Pie2D.swf","myPie2DChartId", "250", "115","0","1");
										myChart.setXMLData("<%=xmlString%>");
										myChart.setTransparent(true);
										myChart.render("chartPie2DContainer");
									</script>
								</td>
								<td width="60%" align="left" valign="middle">
									<table border="0" width="100%" cellspacing="1" cellpadding="1">
<%
				String dispLabel = "";
				for(int k = 0; k < pieDataList.size(); k++)
				{
					legendLabel = (String)pieDataList.get(k);
					legendLabel = legendLabel.trim();
					dispLabel = mappingInfo.getComponentTypeDescription(legendLabel);
					legendColor = (String)piecolorList.get(k);
%>
										<tr>
											<td width="20%">
												<table cellpadding="0" cellspacing="0" border="0">
													<tr>
														<td align="right" valign="middle" height="5px" width="5px" class="border" style="background-color:<%=legendColor%>"><img src="/final/config/images/spacer.gif" border="0" height="5"></td>
													</tr>
												</table>
											</td>
											<td align="left" nowrap valign="top" width="80%"> <a style="font-name:Verdana;font-size:9;font-weight:plain" class="mousehand" onClick="javascript:legendCompData('<%=type%>','<%=legendLabel%>');"><%=dispLabel%></a></td>
										</tr>
<%
				}
%>
									</table>
								</td>
							</tr>
						</table>
<%
			}
%>
					</td>
				</tr>
			</table>
			<!-- Fusion pie chart as drill down ends-->
			</div>
<%
		}
		else
		{
			String sort=configTestsInfo.getServerDisplayValue("SORT_BY_COUNT","InventoryByOperatingSystem");
			boolean isSortByCount =sort.equalsIgnoreCase("true")?true:false;
			List tmpOsNames = new ArrayList();
			if (isSortByCount)
			{
				TreeMap tmpResultData = new TreeMap(resultData);
				int[] counts = new int[tmpResultData.size()];
				List osNames = new ArrayList();
				
				List countsList = new ArrayList();
				int i = 0;
				Iterator ite = tmpResultData.keySet().iterator();
				while (ite.hasNext())
				{
					String osName = (String)ite.next();
					Hashtable osList  = (Hashtable)tmpResultData.get(osName);
					Integer size = new Integer(osList.size());
					counts[i++] = osList.size();
					countsList.add(new Integer(osList.size()));
					osNames.add(osName);
				}
				Arrays.sort(counts);
				for (int ii=(counts.length)-1; ii >= 0; ii--)
				{
					int index = countsList.indexOf(new Integer(counts[ii]));
					String tmpOS = (String)osNames.get(index); 
					tmpOsNames.add(tmpOS);
					osNames.remove(tmpOS);
					countsList.remove(new Integer(counts[ii]));
				}
			}
			else
			{
				tmpOsNames = new ArrayList(resultData.keySet());
			}

			int totalCount=0;
			ArrayList osNameList=new ArrayList();

			ArrayList pieDataList = new ArrayList();//for legend
			ArrayList piecolorList = new ArrayList(); //color list for legend
			String legendLabel = "";
			String legendColor = "";
			String linkUrl = "";
			ArrayList aListColors = new ArrayList();
			StringTokenizer stTokColors = new StringTokenizer(barColor,",");
			while (stTokColors.hasMoreTokens())
			{
				String chartColor = stTokColors.nextToken();
				aListColors.add(chartColor);
			}
			String strColors = " ";
			int colorIdx = 0;
			int i_max = 7;
			int i_start = 0;
			int i_count = 0;

			for (int j=0; j< tmpOsNames.size();j++)
			{
				String displayOsName="";
				String osName=(String)tmpOsNames.get(j);
				osNameList.add(osName);
				if(osName.indexOf(',')>-1)
					displayOsName=osName.replace(',',' ');
				else
					displayOsName=osName;
				Hashtable sysName=(Hashtable)resultData.get(osName);
				int count=sysName.size();

				totalCount=totalCount+count;
				//if(displayOsName.indexOf("Microsoft")>-1)
				//	displayOsName=displayOsName.substring(displayOsName.indexOf(' ')+1);

				String temp_getOsColor = configTestsInfo.getServerDisplayValue("DASHBOARD_OS_COLOR",osName);

				i_start = i_start + 1;
				if (i_start <= i_max)
				{
					if(countValue==" " && countName==" ")
					{
						countValue=" "+count;
						countName=displayOsName;
						if (temp_getOsColor == null || temp_getOsColor.length() == 0)
						{
							strColors = (String)aListColors.get(colorIdx);
							colorValue = strColors;
							colorIdx++;
							if (colorIdx >= aListColors.size())
							{
								colorIdx = 0;
							}
						}
						else
						{
							colorValue = temp_getOsColor;
						}
						linkUrl = "../servlet/com.eg.EcConfigurationServlet?cmd=OSInventory&request_from=OS&osName="+EgURLEncoder.encode(osName,"UTF-8")+"&ec_criteria="+ec_criteria+"&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"");
					}
					else
					{
						countValue=countValue+","+count;
						countName=countName+","+displayOsName;
						if (temp_getOsColor == null || temp_getOsColor.length() == 0)
						{
							strColors = (String)aListColors.get(colorIdx);
							colorValue = colorValue + "," + strColors;
							colorIdx++;
							if (colorIdx >= aListColors.size())
							{
								colorIdx = 0;
							}
						}
						else
						{
							colorValue = colorValue + "," + temp_getOsColor;
						}
						linkUrl = linkUrl + "," + "../servlet/com.eg.EcConfigurationServlet?cmd=OSInventory&request_from=OS&osName="+EgURLEncoder.encode(osName,"UTF-8")+"&ec_criteria="+ec_criteria+"&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"");
					}
				}
				else
				{
					i_count = i_count + count;
				}
			}

			if (i_start > i_max)
			{
				countValue = countValue + "," + i_count;
				colorValue = colorValue + ",#848484";
				countName = countName + ",Others";
				linkUrl = linkUrl + "," + "../servlet/com.eg.EcConfigurationServlet?cmd=OSInventory&request_from=OS&osName=All&category=Others&ec_criteria="+ec_criteria+"&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"");
			}

			StringTokenizer strColor =  new StringTokenizer(colorValue,",");
			while (strColor.hasMoreTokens())
			{
				String temp_pieColor = strColor.nextToken();
				piecolorList.add(temp_pieColor.substring(temp_pieColor.indexOf("#")+1,temp_pieColor.length()));
				//piecolorList.add(temp_pieColor);
			}

			StringTokenizer stToken = new StringTokenizer(countName,",");
			while (stToken.hasMoreTokens())
			{
				String strOS = stToken.nextToken();
				pieDataList.add(strOS);
			}

			//Fusion Pie Chart Data for os starts--Rekha
			HashMap mapChartAttributes = new HashMap();//map for chart attributes
			mapChartAttributes.put("bgcolor","FFFFFF");
			mapChartAttributes.put("enablesmartLabels","0");
			mapChartAttributes.put("showToolTip","0");
			mapChartAttributes.put("showPercentValues","0");
			if (chartDataRepresentation != null && chartDataRepresentation.equalsIgnoreCase("3D"))
			{
				mapChartAttributes.put("pieRadius","80");
			}
			else
			{
				mapChartAttributes.put("pieRadius","57");
			}
			mapChartAttributes.put("showBorder","0");
			mapChartAttributes.put("unescapeLinks","0");

			HashMap mapChartData = new HashMap();//map for chart data
			mapChartData.put("pieLabels",countName);
			mapChartData.put("pieValues",countValue);
			mapChartData.put("pieColors",colorValue);
			mapChartData.put("pieLinks",linkUrl);

			HashMap mapProperties = new HashMap();//map for misc properties
			mapProperties.put("showLabels","false");
			mapProperties.put("showColors","true");
			mapProperties.put("enableLinks","true");

			EcFusionChartBean chartbean = new EcFusionChartBean();
			String xmlString = chartbean.getXMLDataForPieChart(mapChartAttributes,mapChartData,mapProperties);
			//Fusion Pie Chart Data for os ends
%>
			<table border="0">
				<tr>
					<td align="center" valign="top" class="white_bg">
<%
			boolean flag = false;
			if (chartDataRepresentation != null && chartDataRepresentation.equalsIgnoreCase("3D"))
			{
				flag = true;
			}
			if (flag)
			{
%>
						<table align="center" cellspacing="0" cellpadding="0" border="0" height="20px" width="50%" bgcolor="#FFFFFF" valign="center">
							<tr>
								<td colspan="2" align="center" width="100%">
									<b><egui:intnl text="configmgmt.dashboard.Total Systems" /> : </b><%=totalCount%>
								</td>
							</tr>
							<tr>
								<td align="left" width="30%" bgcolor="white">
								<!--  <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="250" height="115" id="Pie3D">
										<param name="movie" value="/final/FusionCharts/swf/Pie3D.swf" />
										<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=250&chartHeight=115" />
										<param name="quality" value="high" />
										<param name="WMode" value="Transparent">
										<embed src="/final/FusionCharts/swf/Pie3D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=250&chartHeight=115" quality="high" width="250" height="115" name="Pie3D" type="application/x-shockwave-flash" WMode="Transparent" pluginspage="//www.macromedia.com/go/getflashplayer" />
									</object> -->
									<div id="chartPie3D2Container"  style="height:100%;"></div>
									<script type="text/javascript">
										if  ( FusionCharts( "myPie3D2ChartId" ) )
												FusionCharts( "myPie3D2ChartId" ).dispose();
										var myChart = new FusionCharts( "/final/FusionCharts/swf/Pie3D.swf","myPie3D2ChartId", "250", "115","0","1");
										myChart.setXMLData("<%=xmlString%>");
										myChart.setTransparent(true);
										myChart.render("chartPie3D2Container");
									</script>
								</td>
								<td width="70%" align="center" valign="middle">
									<table border="0" width="100%" cellspacing="1" cellpadding="1">
<%
				for( int k = 0;k < pieDataList.size();k++)
				{
					legendLabel = (String)pieDataList.get(k);
					legendLabel = legendLabel.trim();
					String dispLabel = legendLabel;
					if (legendLabel.indexOf("Microsoft")>-1)
					{
						dispLabel = legendLabel.substring(legendLabel.indexOf(' ')+1);
					}
					legendColor = (String)piecolorList.get(k);
%>
										<tr>
											<td width="20%">
												<table cellpadding="0" cellspacing="0" border="0">
													<tr>
														<td align="right" valign="middle" height="5px" width="5px" class="border" style="background-color:<%=legendColor%>"><img src="/final/config/images/spacer.gif" border="0" height="5"></td>
													</tr>
												</table>
											</td>
											<td align="left" nowrap valign="top" width="80%"> <a style="font-name:Verdana;font-size:9;font-weight:plain" class="mousehand" onClick="javascript:legendData('<%=legendLabel%>');"><%=dispLabel%></a></td>
										</tr>
<%
				}
%>
									</table>
								</td>
							</tr>
						</table>
<%
			}
			else
			{
%>
						<table align="center" cellspacing="0" cellpadding="0" border="0" height="20px" width="50%" bgcolor="#FFFFFF" valign="center">
							<tr>
								<td colspan="2" align="center" width="100%">
									<b><egui:intnl text="configmgmt.dashboard.Total Systems" /> : </b><%=totalCount%>
								</td>
							</tr>
							<tr>
								<td align="left" width="30%" bgcolor="white">
									<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="250" height="140" id="Pie2D">
										<param name="movie" value="/final/FusionCharts/swf/Pie2D.swf" />
										<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=250&chartHeight=140" />
										<param name="quality" value="high" />
										<param name="WMode" value="Transparent">
										<embed src="/final/FusionCharts/swf/Pie2D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=250&chartHeight=140" quality="high" width="250" height="140" name="Pie2D" type="application/x-shockwave-flash" WMode="Transparent" pluginspage="//www.macromedia.com/go/getflashplayer" />
									</object> -->
									<div id="chartPie2D2Container"  style="height:100%;"></div>
									<script type="text/javascript">
										if  ( FusionCharts( "myPie2D2ChartId" ) )
												FusionCharts( "myPie2D2ChartId" ).dispose();
										var myChart = new FusionCharts( "/final/FusionCharts/swf/Pie2D.swf","myPie2D2ChartId", "250", "115","0","1");
										myChart.setXMLData("<%=xmlString%>");
										myChart.setTransparent(true);
										myChart.render("chartPie2D2Container");
									</script>
								</td>
								<td width="70%" align="center" valign="middle">
									<table border="0" width="100%" cellspacing="1" cellpadding="1">
<%
				for( int k = 0;k < pieDataList.size();k++)
				{
					legendLabel = (String)pieDataList.get(k);
					legendLabel = legendLabel.trim();
					String dispLabel = legendLabel;
					if (legendLabel.indexOf("Microsoft")>-1)
					{
						dispLabel = legendLabel.substring(legendLabel.indexOf(' ')+1);
					}
					legendColor = (String)piecolorList.get(k);
%>
										<tr>
											<td width="20%">
												<table cellpadding="0" cellspacing="0" border="0">
													<tr>
														<td align="right" valign="middle" height="5px" width="5px" class="border" style="background-color:<%=legendColor%>"><img src="/final/config/images/spacer.gif" border="0" height="5"></td>
													</tr>
												</table>
											</td>
											<td align="left" nowrap valign="top" width="80%"> <a style="font-name:Verdana;font-size:9;font-weight:plain" class="mousehand" onClick="javascript:legendData('<%=legendLabel%>');"><%=dispLabel%></a></td>
										</tr>
<%
				}
%>
									</table>
								</td>
							</tr>
						</table>
<%
			}
%>
					</td>
				</tr>
			</table>
<%
		}
	}
%>
		</td>
	</tr>
</table>
<!-- </form> -->
</body>
</html>



