
<%@ include file="EcTracker.jsp" %>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import="com.eg.EgSpecsInfo"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.User"%>
<%@ page import="com.egurkha.UserRegistry"%>
<%@ page import="java.util.*"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "egurkha.config.EcUtils"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%!
	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String queryString = EcUtils.prepareQueryString(request.getParameterMap());
	if (queryString == null) queryString = "";

	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");

	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	String componentType = request.getParameter("componentType");
	String o_componentType = request.getParameter("old_comptype");
	String[] s_selectedInformations = request.getParameterValues("tests");
	String referenceComponent = request.getParameter("referenceComponent");
	String o_referenceComponent = request.getParameter("old_referenceComponent");
	String[] s_otherComponents = request.getParameterValues("otherComponents");

	String requestFrom = (String)request.getParameter("request_from");
	if (requestFrom != null && requestFrom.equalsIgnoreCase("CompareComponentConfigPage"))
	{
		componentType = (String)request.getAttribute("componentType");
		o_componentType = (String)request.getAttribute("old_comptype");
		s_selectedInformations = (String[])request.getAttribute("tests");
		referenceComponent = (String)request.getAttribute("referenceComponent");
		o_referenceComponent = (String)request.getAttribute("old_referenceComponent");
		s_otherComponents = (String[])request.getAttribute("otherComponents");
	}
	String ec_criteria = (String)session.getAttribute("ec_criteria");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");

	if (ec_criteria != null && 
		ec_criteriaPrevious != null && 
		!ec_criteriaPrevious.equals(ec_criteria))
	{
		componentType = null;
		s_selectedInformations = null;
	}

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");

	if (ec_userOption != null && 
		ec_userOptionPrevious != null && !ec_userOptionPrevious.equals(ec_userOption) && 
		ec_criteria != null && ec_criteriaPrevious != null)
	{
		componentType = null;
		s_selectedInformations = null;
	}
	ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");

	ArrayList serverList = new ArrayList();
	ArrayList sortedTestList = new ArrayList();
	Vector vecComponentTypes = new Vector();
	//Vector vec_ctypes = new Vector(user.getServerTypes());
	Vector vec_ctypes = new Vector();
	vec_ctypes.addAll(aListAssociatedComponents);
	for (int i=0; i<vec_ctypes.size(); i++)
	{
		String str = (String) vec_ctypes.get(i);
		String component_type = str.substring(0,str.indexOf(":"));
		//String component_type = (String)vec_ctypes.get(i);
		boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
		if (!isConfigTestEnabled) continue;
		if (!vecComponentTypes.contains(component_type))
		{
			vecComponentTypes.add(component_type);
		}
	}
	if (vecComponentTypes.contains("Host_system"))
	{
		vecComponentTypes.remove("Host_system");
	}

	ArrayList al_components = null;
	if (componentType != null && !componentType.equals("-1"))
	{
		al_components = new ArrayList();
		ArrayList aListTemp = aListAssociatedComponents;
		for (int k=0;k<aListTemp.size();k++)
		{
			String strComp = (String)aListTemp.get(k);
			String component_type = strComp.substring(0,strComp.indexOf(":"));
			if (!component_type.equals(componentType)) continue;
			boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
			if (!isConfigTestEnabled) continue;
			String component_name = strComp.substring(strComp.indexOf(":")+1);
			al_components.add(component_name+":"+component_type);
		}
	}

	if (componentType != null && !componentType.equalsIgnoreCase(o_componentType))
	{
		s_selectedInformations = null;
		referenceComponent = null;
		s_otherComponents = null;
	}

	if (referenceComponent == null || referenceComponent.equals("-1"))
	{
		if (al_components != null && !al_components.isEmpty())
		{
			referenceComponent = (String)al_components.get(0);
		}
	}

	ArrayList aListEnabledConfigTests = null;
	if (componentType != null && !componentType.equals("-1"))
	{
		aListEnabledConfigTests = specsInfo.getEnabledTests(componentType,true);
		if (aListEnabledConfigTests != null)
		{
			sortedTestList = sorter.getSortedTestList(aListEnabledConfigTests);
		}
	}

	List l_selectedInformations = null;
	if (s_selectedInformations != null && !s_selectedInformations[0].equals("-1"))
	{
		l_selectedInformations = Arrays.asList(s_selectedInformations);

		if (aListEnabledConfigTests != null)
		{
			sortedTestList = sorter.getSortedTestList(aListEnabledConfigTests);
		}
	}

	if (referenceComponent != null && !referenceComponent.equalsIgnoreCase(o_referenceComponent))
	{
		s_otherComponents = null;
	}

	List l_otherComponents = null;
	if (s_otherComponents != null && !s_otherComponents[0].equals("-1"))
	{
		l_otherComponents = Arrays.asList(s_otherComponents);
	}
	else if (s_otherComponents == null || s_otherComponents[0].equals("-1"))
	{
		if (al_components != null && al_components.size() > 1)
		{
			ArrayList aList_temp = new ArrayList();
			for (int i=0;i<al_components.size();i++)
			{
				String strComp = (String)al_components.get(i);
				if (strComp.equals(referenceComponent)) continue;
				aList_temp.add(strComp);
				break;
			}
			l_otherComponents = aList_temp;
		}
	}

	ArrayList aListSimilarComponents = (ArrayList)request.getAttribute("aListSimilarComponents");
	ArrayList aListDissimilarComponents = (ArrayList)request.getAttribute("aListDissimilarComponents");


	//if (queryString == null ) queryString = "cmd=CompareConfig";
	if (requestFrom != null && requestFrom.equalsIgnoreCase("CompareComponentConfigPage"))
	{
		queryString += "&ec_rtype=Comparison";
	}

%>

<html>
<head>
	<meta charset="utf-8">

	<!--Skin color--------->
	<egui:skin ui = "configindex"/>

	<script type="text/javascript" src="../extjs/ext-all.js"></script>

	<!-- Fancy Scroll-->
	<script src="/final/jquery/jquery.js"></script>
	<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
	<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
	<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>
	<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>

	<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
	
	<script language="JavaScript1.2" src="/final/scripts/eg_DateUtil.js"></script>
	<script language="Javascript1.2" src="/final/config/scripts/ec_validate.js"></script>
	<script language="Javascript1.2" src="/final/config/scripts/ec_date.js"></script>


	<!-- Utilities File -->
	<script language="Javascript1.2" src="/final/config/utilities/Schedule.js"></script> 
	<script language="Javascript1.2" src="/final/config/utilities/Common.js"></script> 


	<script language="javascript">
	var publicJSON = '';
	var queryString = '<%=queryString%>';
	var ec_criteriaTxt = '<%=ec_criteria%>';
	var userOptionTxt = '<%=ec_userOption%>';
	var strRequestFrom = '<%=requestFrom%>';
	var hiddenFieldsKeys = '';
	var printQueryStr = '';
	var probsErrorMessage = '<egui:intnl text="config.error.Problem encountered while loading the user interface"/>';
	var requestTimeOut = '<egui:intnl text="config.error.Response timed out"/>';
	var errorTitle = '<egui:intnl text="config.user.Error"/>';

	var config = {
		title : {
			mainPageTitle : '<egui:intnl text="configmgmt.compare.COMPARE COMPONENT CONFIGURATION" />',
			viewByTitle : '<egui:intnl text="configmgmt.common.View By" />',
			compTypeTitle : '<egui:intnl text="configmgmt.compare.Component Type" />',
			infoTitle : '<egui:intnl text="configmgmt.compare.Information" />',
			refrenceCompTitle : '<egui:intnl text="configmgmt.compare.Reference Component" />',
			otherCompTitle : '<egui:intnl text="configmgmt.compare.Other Components" />',
			submitTitle : '<egui:intnl text="configmgmt.common.Submit" />',
			backTitle : '<egui:intnl text="configmgmt.common.Back" />',
			fieldIntnlLb1 : '<egui:intnl text="configmgmt.compare.SIMILAR COMPONENTS" />',
			fieldIntnlLb2 : '<egui:intnl text="configmgmt.compare.DISSIMILAR COMPONENTS" />'
		},
		urls : {
			initialURL : "../config/CompareConfiguration/data/EcCompareConfigurationJson.jsp",
			servletURL : "../servlet/com.eg.EcConfigurationServletNew"
		},
		msgs : {
			error1 : '<egui:intnl text="configmgmt.common.Please select a Component" />',
			errorZone : '<egui:intnl text="configmgmt.common.Please select a Zone" />',
			errorService : '<egui:intnl text="configmgmt.common.Please select a Service" />',
			errorSegment : '<egui:intnl text="configmgmt.common.Please select a Segment" />',
			errorCompType : '<egui:intnl text="configmgmt.common.Please select a Component type" />',
			errorInfo : '<egui:intnl text="configmgmt.common.Please select atleast one Information for the choosen component type" />',
			errorRefComp : '<egui:intnl text="configmgmt.common.Please select atleast one component for comparison with reference component" />',
			errorFrSpclChar : '<egui:intnl text="configmgmt.compare.The special characters are not allowed &#61; &#37; &#38; &#40; &#41; &#34; &#39; &#91; &#93; &#59; &#92; &#47;" />',
			errorInfoAndOtr : '<egui:intnl text="configmgmt.compare.in Information and Other Components fields" />',
			errorInfo : '<egui:intnl text="configmgmt.compare.in Information field" />',
			errorOthr : '<egui:intnl text="configmgmt.compare.in Other Components field" />'
		}
	};

	</script>
	<script src="../config/CompareConfiguration/app/app.js"></script>
	<script language="javascript">
		Ext.onReady(function(){
			Ext.Ajax.on('requestexception', function (conn, response, options) {
				var errorStr = response.responseText;
				if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
				{
					if (errorStr.indexOf("user-session-invalid") != -1)
					{
						callWindow(1);
					}
					else if (errorStr.indexOf("user-deleted") != -1)
					{
						callWindow(2);
					}
					else if (errorStr.indexOf("user-timedout") != -1)
					{
						callWindow(3);
					}
				}
				else
				{
					if (response.status == 302 || (response.timedout != undefined && response.timedout == true))
					{
						Ext.Msg.show({
							title : errorTitle,
							msg : requestTimeOut,
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
					else
					{
						Ext.Msg.show({
							title : errorTitle,
							msg : probsErrorMessage,
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
				}
			});
		});
	</script>
	<style>
	.ux-grow-action-text {
		 padding: 0 ! important;
		 margin:0 ! important;
		background:transparent none ! important;
		float:left;
	}  
	</style>
</head>

<body>
<div id="loadmask" class="x-mask-msg x-layer x-mask-msg-default" style="z-index: 19001;left:45%;top:35%;">
	<div class="x-mask-loading" style="position:relative">
		Loading...
	</div>
</div>
</body>

</html>



