<%
/*
*File				:	EcBoxView.jsp
*Purpose			:	List the system & the associated components
*Creation Date		:	15-11-2006
*Author				:	Balasigamani,Krishnamurthi
*UI Design			:	Krishnamurthi
*UI Design Changes	:	Jaiwin
*/
%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EcTracker.jsp" %>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import="com.egurkha.User" %>
<%@ page import="com.egurkha.UserRegistry" %>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgConfigTestsInfo" %>
<%@ page import="egurkha.config.EcBoxView" %>
<%@ page import="com.eg.EgConfigConstants" %>
<%@ page import = "com.egurkha.pdfmaker.*"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="egurkha.config.EcSystemInformation" %>
<%@ page import="com.eg.EgBoxView" %>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "java.text.*"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.eg.EgInstallInfo" %>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%!
	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<%
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (user!=null)
	{
		userLanguage= user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);

	EgConfigTestsInfo configTest=new EgConfigTestsInfo("manager");

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K Starts */
	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateString,user);
	dateString = timeZoneConverter.getDateTime();
	/* Added by Prakash.K Ends */

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");

	Map systemData =new TreeMap();
	Map commonInformation=new TreeMap();
	Map individualInformation=new TreeMap();
	ArrayList systemDetailData= new ArrayList();

	String userName = user.getLoginID();
	String configSkin = user.getConfigSkin();
	String system = request.getParameter("systemName");
	String search = request.getParameter("searchValue");
	String selectedInformation[] = (String[]) request.getAttribute("Selected Informations");
	String searchValueArr[] = (String[]) request.getAttribute("searching");
	String strsubmitClicked = request.getParameter("submitClicked");

	if (selectedInformation != null)
	{
		system = (String) selectedInformation[0];
	}
	if (searchValueArr != null)
	{
		search = (String) searchValueArr[0];
	}

	String requestFrom = request.getParameter("request_from");
	String submitOrNot = (String) request.getAttribute("isSubmit");
	Map scheduleDetails = (Map) request.getAttribute("ScheduleDetails");

	boolean isDisplay = true;

	if (scheduleDetails != null && requestFrom != null && requestFrom.equalsIgnoreCase("saveSchedule"))
	{
		ec_criteria = (String)scheduleDetails.get("ec_criteria");
		ec_criteriaPrevious = (String)scheduleDetails.get("ec_criteriaPrevious");
	}

	if (scheduleDetails != null && requestFrom != null && requestFrom.equalsIgnoreCase("saveSchedule"))
	{
		vecUserOptions = (Vector) scheduleDetails.get("vecUserOptions");
		system = (String) scheduleDetails.get("system");
		search = (String) scheduleDetails.get("searchName");
		submitOrNot = "false";
		ec_userOption = (String) scheduleDetails.get("ec_userOption");
		ec_userOptionPrevious = (String) scheduleDetails.get("ec_userOptionPrevious");
	}
	if (submitOrNot == null || "null".equals(submitOrNot))
	{
		submitOrNot = "true";
	}
	if (requestFrom != null && requestFrom.equalsIgnoreCase("saveSchedule"))
	{
		isDisplay = false;
	}

	system = (system==null || system.equals(""))?null:system.trim();
	search = (search==null || search.equals(""))?"":search.trim();

	systemData = (TreeMap)request.getAttribute("BoxData");
	EcBoxView boxView=(EcBoxView)request.getAttribute("boxObject");

	ArrayList aListTestnames = null;
	TreeMap testMeasureMapping = null;
	TreeMap tmapSystemInformationDetails = null;
	int measureCount = 0;

	if(system!=null && system.length()>0)
	{
		if (system.equalsIgnoreCase("All")) //krishnamurthi
		{
			//Vector vecUserAssociatedComponents = new Vector(user.getServers(false));
			EgBoxView egBoxView = new EgBoxView();
			//egBoxView.setUserComponents(vecUserAssociatedComponents);
			egBoxView.setUserComponents(aListAssociatedComponents);
			Map systemComponentMapping = egBoxView.getSystemComponentMapping();
			Map componentSystemMapping = egBoxView.getComponentSystemMapping();

			EcSystemInformation ecSystemInformation = new EcSystemInformation();
			ecSystemInformation.setSearchValue(search);
			ecSystemInformation.setComponentSystemMapping(componentSystemMapping);
			ecSystemInformation.setSystemComponentMapping(systemComponentMapping);
			aListTestnames = ecSystemInformation.getSystemInformationTest();
			testMeasureMapping = (TreeMap)ecSystemInformation.getTestMeasureMap();
			measureCount = ecSystemInformation.getMeasureCount();
			tmapSystemInformationDetails = (TreeMap)ecSystemInformation.getSystemData();
			session.setAttribute("Testnames",aListTestnames);
			session.setAttribute("TestMeasureMap",testMeasureMapping);
			session.setAttribute("measureCount",new Integer(measureCount));
			session.setAttribute("SystemInformationDetails",tmapSystemInformationDetails);
		}
		else
		{
			boxView.init(request);
			ArrayList tmpList = (ArrayList)systemData.get(system); 
			if (tmpList != null && tmpList.size() > 0)
			{
				for (int i=0;i<tmpList.size();i++)
				{
					String comp = (String)tmpList.get(i);
					if (!systemDetailData.contains(comp))
					{
						systemDetailData.add(comp);
					}
				}
			}
			boxView.setComponentName(systemDetailData);
			commonInformation=(TreeMap)boxView.getBoxInformation();
			Map printData=new TreeMap(commonInformation);
			session.setAttribute("CommonData",printData);
			session.setAttribute("SpecificData",systemDetailData);
		}
	}

	boolean requestFromIBCT = false;
	boolean requestFromIBOS = false;
	boolean requestFromSearchPage = false;
	if (requestFrom == null)
	{
		requestFrom = "BoxView";
	}
	else if (requestFrom != null && "InventoryByCompType".equalsIgnoreCase(requestFrom))
	{
		requestFromIBCT = true;
	}
	else if (requestFrom != null && "IBOS".equalsIgnoreCase(requestFrom))
	{
		requestFromIBOS = true;
	}
	else if (requestFrom != null && "SearchPage".equalsIgnoreCase(requestFrom))
	{
		requestFromSearchPage = true;
	}

	boolean requestFromHomePage = false;
	if (requestFrom != null && "HomePage".equalsIgnoreCase(requestFrom))
	{
		requestFromHomePage = true;
	}

	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");

	String id = request.getParameter("id");
	String strBackRequest = request.getParameter("back_request");
	if (strBackRequest != null && strBackRequest.equalsIgnoreCase("ScheduleConfig") && strsubmitClicked != null && strsubmitClicked.equalsIgnoreCase("false"))
	{
		submitOrNot = "false";
	}
%>

<html>
<egui:skin ui="config"/>
<script language="JavaScript1.2" src="../config/scripts/ec_validate.js"></script>
<script language="JavaScript1.2" src="/../final/scripts/screen_display.js"></script>
<script language="JavaScript1.2">

function SearchName()
{
	var thisForm = document.BoxView;
	var name = thisForm.searchName.value;

	var tempCriteria = "";
	var tempUserOption = "";
	if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
	{
		tempCriteria = thisForm.ec_criteria.value;
	}
	if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
	{
		tempUserOption = thisForm.ec_userOption.value;
	}

	var sub = checkspecial(thisForm.searchName,"`~!@#$%^&*()+={}[]|\\;\"\'<>,?\/");
	if(!sub)
	{
		thisForm.searchName.focus();
		return;
	}
	window.location.href="../servlet/com.eg.EcConfigurationServlet?cmd=BoxView&searchValue="+encodeURIComponent(name)+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&request_from=<%=requestFrom%>&id=<%=id%>";
}

function getSystemDetails(systemName,calledBy)
{
	var thisForm = document.BoxView;
	var name = thisForm.searchName.value;

	var tempCriteria = "";
	var tempUserOption = "";
	if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
	{
		tempCriteria = thisForm.ec_criteria.value;
	}
	if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
	{
		tempUserOption = thisForm.ec_userOption.value;
	}

	if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
	{
		if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
		{
			if (tempCriteria == "Zone")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
				return false;
			}
			else if (tempCriteria == "Service")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
				return false;
			}
			else if (tempCriteria == "Segment")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
				return false;
			}
		}
	}

	//var systemName= thisForm.system.value;
	var sub = checkspecial(thisForm.searchName,"`~!@#$%^&*()+={}[]|\\;\"\'<>,?\/");
	if(!sub)
	{
		thisForm.searchName.focus();
		return false;
	}
	if(systemName==-1)
	{
		alert('<egui:intnl text="configmgmt.inventory.view.Please select system name" />');
		return false;
	}

	if(systemName==-1 && calledBy == 'Schedule')
	{
		alert('<egui:intnl text="configmgmt.inventory.view.Please select system name" />');
		return false;
	}

	if (calledBy != "SUBMIT" && calledBy != "Schedule")
	{
		window.location.href="../servlet/com.eg.EcConfigurationServlet?cmd=BoxView&request_from=<%=requestFrom%>&searchValue="+encodeURIComponent(name)+"&systemName="+encodeURIComponent(systemName)+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption);
	}
	else if (calledBy != "Schedule")
	{
		window.location.href="../servlet/com.eg.EcConfigurationServlet?cmd=BoxView&searchValue="+encodeURIComponent(name)+"&systemName="+encodeURIComponent(systemName)+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&request_from=<%=requestFrom%>";
		document.BoxView.secsubmt.value='<egui:intnl text="configmgmt.common.Loading" />'+'...';
		document.BoxView.secsubmt.disabled=true;
	}
}

function printData()
{
<%
	if((systemDetailData== null || systemDetailData.size() == 0) && (commonInformation==null || commonInformation.size() == 0) && (tmapSystemInformationDetails == null || tmapSystemInformationDetails.isEmpty()))
	{
%>
		alert('<egui:intnl text="configmgmt.common.No data available" />');
		return;
<%
	}

	StringBuffer printQS = new StringBuffer();
	printQS.append("ec_type=INVENTORY");
	printQS.append("&selection_check=System");
	printQS.append("&ec_trgttype=REPORT_BY_SYSTEM");
	if (request.getParameter("systemName") != null)
	{
		printQS.append("&ec_system="+EgURLEncoder.encode(request.getParameter("systemName"),"UTF-8"));
		printQS.append("&systemName="+EgURLEncoder.encode(request.getParameter("systemName"),"UTF-8"));
	}
	if (request.getParameter("searchValue") != null)
	{
		printQS.append("&searchValue="+EgURLEncoder.encode(request.getParameter("searchValue"),"UTF-8"));
	}
	printQS.append("&printData=yes");
	printQS.append("&userName="+EgURLEncoder.encode(userName,"UTF-8"));
	printQS.append("&user_language="+userLanguage);
	printQS.append("&ec_criteria="+ec_criteria);
	printQS.append("&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""));
%>
	var s_qryString= "../servlet/com.eg.EcRepoLiteC?<%=printQS.toString()%>&ec_forPDF=No";
	print(s_qryString);
}

function goToSearch()
{
	var thisForm = document.BoxView;
	thisForm.action = "../servlet/com.eg.EcConfigurationServlet?ec_rtype=Search&request_from=SystemPage";
	thisForm.submit();
}

function goToInventoryByCompType()
{
	var thisForm = document.BoxView;
	thisForm.action = '../servlet/com.eg.EcConfigurationServlet?cmd=CompTypeInventory&componentType=<%=request.getParameter("componentType")%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
	thisForm.submit();
}

function goToInventoryByOS()
{
	var thisForm = document.BoxView;
	thisForm.action = '../servlet/com.eg.EcConfigurationServlet?cmd=OSInventory&componentType=<%=request.getParameter("componentType")%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
	thisForm.submit();
}

function savePdf()
{
<%
	if( (systemDetailData== null || systemDetailData.size() == 0) && (commonInformation==null || commonInformation.size() == 0) && (tmapSystemInformationDetails == null || tmapSystemInformationDetails.isEmpty()))
	{
%>
		alert('<egui:intnl text="configmgmt.common.No data available" />');
		return;
<%
	}
	session.setAttribute("PDF_URL",mngrIProc+"/final/servlet/com.eg.EcRepoLiteC;jsessionid="+session.getId()+"?"+printQS.toString()+"&ec_forPDF=Yes");
	session.setAttribute("REPORT_NAME","InventoryReportBySystem");
	session.setAttribute("REPORT_LAYOUT","Portrait");
	session.setAttribute("PAGE_WIDTH_PDF","1100");
	session.setAttribute("PAGE_WIDTH_MAIL_IMAGE","1300");
	session.setAttribute("PAGE_HEIGHT_MAIL_IMAGE","768");
%>
	getPdf('<%=configSkin%>');
}

function mail()
{
<%
	if( (systemDetailData== null || systemDetailData.size() == 0) && (commonInformation==null || commonInformation.size() == 0) && (tmapSystemInformationDetails == null || tmapSystemInformationDetails.isEmpty()))
	{
%>
		alert('<egui:intnl text="configmgmt.common.No data available" />');
		return;
<%
	}
%>
	sendMail();
}

function getInformations()
{
	var thisForm = document.BoxView;
	thisForm.action = "../servlet/com.eg.EcConfigurationServlet?cmd=BoxView&request_from=<%=requestFrom%>&id=<%=id%>";
	thisForm.submit();
}

function csv()
{
	thisForm = document.forms[0];
<%
	if( (systemDetailData== null || systemDetailData.size() == 0) && (commonInformation==null || commonInformation.size() == 0) && (tmapSystemInformationDetails == null || tmapSystemInformationDetails.isEmpty()))
	{
%>
		alert('<egui:intnl text="configmgmt.common.No data available" />');
		return;
<%
	}
%>
	thisForm.action = '../servlet/com.eg.EcCSVController?ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
	thisForm.submit();
}

function schedule(op)
{
	var checkFlag = getSystemDetails(document.BoxView.system.value,'Schedule')
	if(checkFlag == false) 
	{
		return;
	}
	var thisForm = document.BoxView;
	if (op == "schedule")
	{
<%
		if (requestFrom != null && requestFrom.equalsIgnoreCase("saveSchedule"))
		{
%>
			thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>";
<%
		}
		else
		{
%>
			thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>&request_from=BoxView";
<%
		}
%>
	}
	else if (op =="favorite")
		thisForm.action = "/final/config/EcSaveFavorite.jsp";
	else
	{
		alert('<egui:intnl text="configmgmt.common.Illegal Access" />');
		return;
	}
	thisForm.submit();
}

function goBackToSaveSchedule()
{
	var thisForm = document.forms[0];
	thisForm.action = "/final/config/EcSaveSchedule.jsp?request_from=<%=requestFrom%>&id=<%=id%>";
	thisForm.submit();
}
</script>

<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" style="overflow:auto" onLoad="bigScreen();">
<form name="BoxView" method="post" style="margin:0px">
<input type="hidden" name="ec_rtype" value="BoxView">
<input type="hidden" name="ec_trgttype" value="Configuration_Report">
<input type="hidden" name="systemName" value="<%=system%>">
<input type="hidden" name="ec_criteriaPrevious" value="<%=ec_criteria%>">
<input type="hidden" name="ec_userOptionPrevious" value="<%=ec_userOption%>">

<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%">

	<tr>
		<td align="right" valign="middle" id="layer_headbg" height="18" width="100%" style="padding:0px;border-left-width:0px;border-right-width:0px">
			<div style="border:0px blue solid;height:24px">
				<div style="border:0px solid;float:left;padding:5px" class="main_head_top">
					&nbsp;<b><egui:intnl text="configmgmt.inventory.view.INVENTORY BY SYSTEM" /></b>
				</div>
				<div style="border:0px solid red;float:right;height:22px;">
<%
	if (requestFromHomePage || requestFromIBCT || requestFromIBOS || requestFromSearchPage)
	{
%>
					<div style="border:0px solid red;height:22px;float:right;position:relative;margin-top:2px">
						<table cellspacing="0" cellpadding="0" border="0" height="20">
							<tr>
								<td width="50" align="center" id="leftcurve" > <img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>

								<td width="2" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="2" > </td>

								<td align="center"  id="leftcurvebg" > <img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="printData()">  </td>

								<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif" width="13" > </td>

								<td width="13" align="center"  id="leftcurvebg" > <img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"> </td>

								<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="13"> </td>

								<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"></td>

								<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="13"> </td>

								<td width="13" align="center" id="leftcurvebg"><img class="mouse" src="../config/images/csv.gif" border="0" title='<egui:intnl text="configmgmt.common.CSV" />' onClick="javascript:csv()"> </td>

								<td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"></td>

							</tr>
						</table>
					</div>
<%
	}
%>
					<div style="border:0px solid;float:right;padding:5px">
<%
	if (requestFrom != null && requestFrom.equalsIgnoreCase("SearchPage"))
	{
%>
						<a id='mousehand' onClick="javascript:goToSearch();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;
						</a>
<%
	}
	else if (requestFrom != null && requestFrom.equalsIgnoreCase("InventoryByCompType"))
	{
%>
						<a id='mousehand' onClick="javascript:goToInventoryByCompType();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;
						</a>
<%
	}
	else if (requestFrom != null && requestFrom.equalsIgnoreCase("IBOS"))
	{
%>
						<a id='mousehand' onClick="javascript:goToInventoryByOS();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;
						</a>
<%
	}
	else if (requestFrom != null && requestFrom.equalsIgnoreCase("saveSchedule"))
	{
%>
						<a id='mousehand' onClick="goBackToSaveSchedule();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;&nbsp;
						</a>
<%
	}
	else if (requestFrom != null && !requestFrom.equalsIgnoreCase("SearchPage") && !requestFrom.equalsIgnoreCase("BoxView"))
	{
%>
						<a id='mousehand' onClick="javascript:history.back();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;
						</a>
<%
	}
%>
					</div>
				</div>
			</div>
		</td>
	</tr>

<%
	if (requestFromHomePage || requestFromIBCT || requestFromIBOS || requestFromSearchPage)
	{
%>
	<tr>
		<td valign="top" id="bgmedium" width="100%" height="5px" class="eg_blankspace">&nbsp;</td>
	</tr>
<%
	}
%>

	<tr>
		<td valign="top" id="bgmedium" width="100%" height="100%">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
			<!-- new tab start here -->
<%
	if (!requestFromHomePage && !requestFromIBCT && !requestFromIBOS && !requestFromSearchPage)
	{
%>
				<tr>
					<td id="padding6" style="padding-bottom:0px">
						<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" id="toptable" style="table-layout:fixed">
							<col width="55"><col width="10"><col width="170">
							<col width="150"><col width="10"><col width="350">
							<tr>
								<td align="right" nowrap><b><egui:intnl text="configmgmt.common.View By" /></b></td>
								<td align="center"><b>:</b></td>
								<td valign="middle">
									<select name="ec_criteria" style="width:170px;" onChange='javascript:getInformations()'>
<%
		if (vecCriterias != null && !vecCriterias.isEmpty())
		{
			for(int i=0; i<vecCriterias.size(); i++)
			{
				String selected = "";
				String strCriteria = (String)vecCriterias.get(i);
				if(ec_criteria != null && strCriteria.equals(ec_criteria))
				{
					selected = "selected";
				}
%>
				<option value="<%=strCriteria%>" <%=selected%>>
					<egui:intnl text='<%="configmgmt.common."+strCriteria%>' />
				</option>
<%
			}
		}
		else
		{
%>
			<option value="-1">
				<egui:intnl text="configmgmt.common.Not Applicable" />
			</option>
<%
		}
%>
									</select>
								</td>
<%
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
%>
								<td align="right" nowrap>
<%
			if (ec_criteria.equalsIgnoreCase(criterias[0]))
			{
%>
				<b><egui:intnl text='<%="configmgmt.common."+criterias[0]%>' /></b>
<%
			}
			else if (ec_criteria.equalsIgnoreCase(criterias[1]))
			{
%>
				<b><egui:intnl text='<%="configmgmt.common."+criterias[1]%>' /></b>
<%
			}
			else
			{
%>
				<b><egui:intnl text='<%="configmgmt.common."+criterias[2]%>' /></b>
<%
			}
%>
								</td>
								<td align="center"><b>:</b></td>
								<td>
									<select name="ec_userOption" style="width: 250px;" onChange='javascript:getInformations()'>
<%
			if (vecUserOptions != null && !vecUserOptions.isEmpty())
			{
				for(int i=0; i<vecUserOptions.size(); i++)
				{
					String selected = "";
					String strUserOption = (String)vecUserOptions.get(i);
					if(ec_userOption != null && strUserOption.equals(ec_userOption))
					{
						selected = "selected";
					}
%>
					<option value="<%=strUserOption%>" <%=selected%>>
						<%=strUserOption%>
					</option>
<%
				}
			}
			else
			{
%>
				<option value="-1">
					<egui:intnl text="configmgmt.common.Not Applicable" />
				</option>
<%
			}
%>
									</select>
								</td>
<%
		}
		else
		{
%>
								<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
<%
		}
%>
							</tr>
						</table>
					</td>
				</tr>
				<!-- new tab end here -->

				<tr>
					<td id="padding6">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="toptable" >
							<tr>
								<td>
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table-layout:auto" id="text_bold"> <col width="130"><col width="130"><col width="10"><col width="140"><col width="80"><col width="10"><col width="220"><col width="130">
										<tr>
											<td colspan="8" height="5" id="blank">&nbsp;</td>
										</tr>
										<tr height="20">
											<td align="center">&nbsp;</td>
											<td align="right" ><egui:intnl text="configmgmt.inventory.view.Search System(s)" /></td>
											<td align="center">:</td>
											<td align="left">
												<table cellspacing="0" cellpadding="0" width="100%" border="0">
													<tr>
														<td style="width:120px"><input type="text" name="searchName" value="<%=search%>" style="width:120px"></td>
														<td>&nbsp;<img class="mouse" src=" /final/config/images/gray/arrow_1.gif" title="<egui:intnl text='monitor.common.GO'/>" onClick="javascript:SearchName()" border="0"></td>
													</tr>
												</table>
											</td>
											<td align="right"><egui:intnl text="configmgmt.inventory.view.System" /></td>
											<td align="center">:</td>
											<td align="left">
												<select name="system" style="width: 250px;">
<%
		if (systemData != null && systemData.size() > 0)
		{
%>
													<option value="-1"><egui:intnl text="configmgmt.inventory.view.Please select a system" /></option>
<%
		}
		else
		{
%>
													<option value="-1"><egui:intnl text="configmgmt.inventory.view.Not Applicable" /></option>
<%
		}

		if (systemData != null && systemData.size()>0)
		{
			if (systemData.size() > 1)
			{
%>
													<option value="All" <%=(system != null && system.equalsIgnoreCase("All"))?"selected":""%>>
														<egui:intnl text="configmgmt.inventory.view.All" />
													</option>
<%
			}
			Iterator iteration = systemData.keySet().iterator();
			while (iteration.hasNext())
			{
				String nickName = (String)iteration.next();
%>
													<option value="<%=nickName%>" <%=nickName.equalsIgnoreCase(system)?"selected":""%>>
														<%=nickName%>
													</option>
<%
			}
		}
%>
												</select>
											</td>
											<td  align="center">&nbsp;</td>
										</tr>
										<tr>
											<td colspan="8" height="10" id="blank">&nbsp;</td>
										</tr>
										<tr>
<%
		if (requestFrom != null && requestFrom.equalsIgnoreCase("saveSchedule"))
		{
%>
											<td  align="center">&nbsp;</td>
											<td align="center" colspan="6" valign="middle" height="20"> 
											<input type="button" name="btnsubmit" value='<egui:intnl text="configmgmt.common.SAVE" />' id="darkbutton" style="width: 75px; height: 20px;" href="" onClick="schedule('schedule');">
											</td>
<%
		}
		else
		{
%>

											<td  align="center">&nbsp;</td>
											<td align="center" colspan="6" valign="middle" height="20">  <input type="button"  name="secsubmt" value='<egui:intnl text="configmgmt.common.SUBMIT" />' id="darkbutton" style="width: 75px; height: 20px;" onClick="javascript:getSystemDetails(document.BoxView.system.value,'SUBMIT')">
											</td>
<%
		}
%>
											<td align="right"  colspan="1" rowspan="2" style="height:24" valign="bottom">
												<table align="right" cellspacing="0" cellpadding="0" border="0" height="20"> 
													<tr>
														<td width="50" align="center" id="leftcurve" ><img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>

														<td width="2" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="2" ></td>

														<td align="center"  id="leftcurvebg" > <img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="javascript:printData()">  </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif" width="13" > </td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"> </td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"> </td>

														<td width="13" align="center" id="leftcurvebg"><img class="mouse" src="../config/images/csv.gif" border="0" title='<egui:intnl text="configmgmt.common.CSV" />' onClick="javascript:csv()"> </td>

														<td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"></td>

														<td align="center" id="leftcurvebg"><img class="mouse" src="../config/images/schedules.gif" border="0" title='<egui:intnl text="configmgmt.common.ADD TO SCHEDULES" />' onClick="javascript:schedule('schedule')"> </td>

														<td width="12" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="12"></td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td colspan="7" height="5" id="blank">&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
	}

	if (system!=null && system.length()>0 && submitOrNot.equals("true") && isDisplay)
	{
%>
				<input type="hidden" name="submitClicked" value="true">
<%
		if (system.equalsIgnoreCase("All"))
		{
			if (tmapSystemInformationDetails != null && !tmapSystemInformationDetails.isEmpty())
			{
				// Pdf work
				ArrayList aListPdfData = new ArrayList();
				EgPdfData pdfData = new EgPdfData();

				EgReportAttributes reportAttributes = new EgReportAttributes();
				String pdfTitle = "";
				if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
				{
					pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.INVENTORY REPORT BY SYSTEM") + " IN" + " '" + ec_userOption + "' "  +  ec_criteria + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
				}
				else
				{
					pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.INVENTORY REPORT BY SYSTEM") + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
				}
				reportAttributes.setMainTitle(pdfTitle);

				String pdfSubTitle = "";
				reportAttributes.setSubTitle(pdfSubTitle);
				reportAttributes.setReportName("SystemInventory");
				reportAttributes.setModule("CONFIG");
				reportAttributes.setPortrait(false);
				pdfData.setAttributes(reportAttributes);

				ArrayList aListData = new ArrayList();
				ArrayList aListColumnNames = new ArrayList();
				ArrayList userColumnNames = new ArrayList();

				for (int k=0; k<measureCount+1; k++)
				{
					aListColumnNames.add("C"+k);
				}
%>
				<tr>
					<td id="padding6" height="100%" width="100%" style="padding-top:0px">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" id="bottomtable">
							<tr>
								<td colspan="7" height="5" id="blank">&nbsp;</td>
							</tr>
							<tr>
								<td align="center" width="100%" height="100%" valign="top" class="bgwhite">
									<table align="center" cellspacing="0" cellpadding="0" width="99%" border="0" id="bottomtable">
										<tr>
											<td colspan="<%=measureCount+1%>" height="20" id="bgdark" class="whitefont">&nbsp;<b><egui:intnl text="configmgmt.inventory.view.System Information" /></b></td>
										</tr>
										<tr>
											<td height="20" id="cell_header" style="text-align:center" valign="top"><egui:intnl text="configmgmt.inventory.view.System" /></td>
<%
				userColumnNames.add(mappingInfo.getTextDescription("configmgmt.inventory.view.System"));
				for (int k=0; k<aListTestnames.size(); k++)
				{
					String testname = (String)aListTestnames.get(k);
					ArrayList aListMeasures = (ArrayList)testMeasureMapping.get(testname);
					for (int m=0; m<aListMeasures.size(); m++)
					{
						String measure = (String)aListMeasures.get(m);
						String measureForDisplay = mappingInfo.getMeasureDescription(testname,measure);
						userColumnNames.add(measureForDisplay);
%>
											<td height="20" id="cell_header" style="text-align:center" valign="top">
												<%=measureForDisplay%>
											</td>
<%
					}
				}
%>
										</tr>
<%
				Iterator system_keys = tmapSystemInformationDetails.keySet().iterator();
				while (system_keys.hasNext())
				{
%>
										<tr>
<%
					String key_system = (String)system_keys.next();
					aListData.add(key_system);
%>
											<td id="cell_bg1" valign="top" style="text-align:left"><a class="eg_monlink" href="#" onClick="javascript:getSystemDetails('<%=key_system%>','SYSTEM')"><%=key_system%></a></td>
<%
					TreeMap tmapTestDetails = (TreeMap)tmapSystemInformationDetails.get(key_system);
					for (int i=0; i<aListTestnames.size(); i++)
					{
						String testname = (String)aListTestnames.get(i);
						ArrayList aListMeasures = (ArrayList)testMeasureMapping.get(testname);
						TreeMap tmapMeasureDetails = (TreeMap)tmapTestDetails.get(testname);
						if (tmapMeasureDetails == null)
						{
							for (int j=0; j<aListMeasures.size(); j++)
							{
								aListData.add("-");
%>
											<td id="cell_bg1" style="text-align:center" valign="top">&nbsp;-&nbsp;</td>
<%
							}
						}
						else
						{
							for (int j=0; j<aListMeasures.size(); j++)
							{
								String measure = (String)aListMeasures.get(j);
								ArrayList aListMeasureValue = (ArrayList)tmapMeasureDetails.get(measure);
								String measureValue = "-";
								if (aListMeasureValue != null)
								{
									if (testname.equalsIgnoreCase("DiskCapacity_cf") && measure.equalsIgnoreCase("Capacity"))
									{
										int i_size = aListMeasureValue.size()-1;
										measureValue = (String)aListMeasureValue.get(i_size);
									}
									else
									{
										measureValue = aListMeasureValue.toString();
										measureValue = measureValue.substring(1,measureValue.length()-1);
									}
								}
								aListData.add(measureValue);

								if (measureValue.equals("-"))
								{
%>
											<td id="cell_bg1" valign="top" style="text-align:center"><%=measureValue%></td>
<%
								}
								else
								{
%>
											<td id="cell_bg1" valign="top"><%=measureValue%></td>
<%
								}
							}
						}
					}
%>
										</tr>
<%
				}
%>
									</table>
								</td>
							</tr>
							<tr>
								<td colspan="7" height="5" id="blank">&nbsp;</td>
							</tr>
						</table>
					</td>
				</tr>
<%
				EgTableAttributes egTableAttributes = new EgTableAttributes();
				egTableAttributes.setTitle(mappingInfo.getTextDescription("configmgmt.inventory.view.System Information"));
				egTableAttributes.setColumnNames(userColumnNames);

				EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
				EgTable egTable = new EgTable();
				egTable.setModel(egTableModel);
				egTable.setAttributes(egTableAttributes);
				aListPdfData.add(egTable);

				pdfData.setData(aListPdfData);
				session.setAttribute("pdfData",pdfData);
			}
			else
			{
%>
				<tr>
					<td id="padding6" height="100%" width="100%" style="padding-top:0px">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" id="bottomtable">
							<tr>
								<td align="center" width="100%" height="100%" valign="top" class="bgwhite">
									<table border="0" cellspacing="0" cellpadding="0" width="100%" class="body_text">
										<tr>
											<td height="180" id="blank">&nbsp;</td>
										</tr>
										<tr>
											<td align="center" valign="middle">
												<table border="0" align="center" width="100%" height="100%">
													<tr>
														<td align="center">
															<table border="0" align="center" width="100%" class="body_text">
																<tr>
																	<td align="center"> <img src="/final/config/images/unavailable-data.gif" alt='<egui:intnl text="configmgmt.common.No Data" />'></td>
																</tr>
																<tr>
																	<td align="center"><b><egui:intnl text="configmgmt.inventory.view.No data found for the selected system/combination" /></b></td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
			}
		}
		else
		{
%>
				<tr>
					<td id="padding6" height="100%" width="100%" style="padding-top:0px">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" id="bottomtable">
							<tr>
								<td align="center" width="100%" height="100%" valign="top" class="bgwhite">
<%
			ArrayList aListPdfData = new ArrayList();
			EgPdfData pdfData = new EgPdfData();

			if((systemDetailData!= null && systemDetailData.size()>0) || (commonInformation!=null && commonInformation.size()>0))
			{
				// Pdf work
				EgReportAttributes reportAttributes = new EgReportAttributes();
				String pdfTitle = "";
				if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
				{
					pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.INVENTORY REPORT BY SYSTEM") + " IN" + " '" + ec_userOption + "' "  +  ec_criteria + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
				}
				else
				{
					pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.INVENTORY REPORT BY SYSTEM") + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
				}
				reportAttributes.setMainTitle(pdfTitle);
				String pdfSubTitle = "Managed Components and Basic Configuration for system";
				pdfSubTitle = mappingInfo.getTextDescription("configmgmt.inventory.view."+pdfSubTitle);
				reportAttributes.setSubTitle(pdfSubTitle+" : "+system);

				reportAttributes.setReportName("SystemInventory");
				reportAttributes.setModule("CONFIG");
				reportAttributes.setPortrait(true);
				pdfData.setAttributes(reportAttributes);
			}

			if (systemDetailData!= null && systemDetailData.size()>0)
			{
				// pdf work
				ArrayList aListData = new ArrayList();
%>
									<table border="0" cellspacing="0" cellpadding="0" width="100%" class="body_text">
										<tr>
											<td colspan="3" height="5" id="blank">&nbsp;</td>
										</tr>
									</table>

									<table border="0" cellspacing="0" cellpadding="0" width="99%" class="body_text" id="bottomtable">
										<tr>
											<td colspan="3" height="20" id="bgdark" class="whitefont">&nbsp;<b><egui:intnl text="configmgmt.inventory.view.Components managed on" />&nbsp;<%=system%></b></td>
										</tr>
<%
				int count = systemDetailData.size();
				int j=0;
				if (count <=3)
				{
					count = 3;
				}
				else if(count % 3 != 0)
				{
					count = count +3- count % 3;
				}
				for (j=0; (j<systemDetailData.size() || j < count); j++)
				{
					if (j%3 == 0)
					{
%>
										<tr>
<%
					}
					if ( j <systemDetailData.size())
					{
						String componentName=(String)systemDetailData.get(j);
						StringTokenizer st=new StringTokenizer(componentName,":");
						String subNickName=st.nextToken();
						String displayName="";
						String port=st.nextToken();
						if(componentName.endsWith("Oracle_server"))
							port+=":"+st.nextToken();
						String type=st.nextToken();

						if(!port.equalsIgnoreCase("NULL"))
							displayName=subNickName+":"+port;
						else
							displayName=subNickName;

						String compType = mappingInfo.getComponentTypeDescription(type);

						String strComp = displayName+":"+compType;

						//pdf work
						aListData.add(strComp);
%>
											<td width="30%" id="cell_bg1">
												<a href="/final/servlet/com.eg.EcConfigurationServlet?ec_rtype=Current&request_from=<%=requestFrom%>&old_comptype=<%=componentName.substring(componentName.lastIndexOf(':')+1)%>&ec_comptype=<%=componentName.substring(componentName.lastIndexOf(':')+1)%>&ec_component=<%=EgURLEncoder.encode(componentName,"UTF-8")%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="_self" class="eg_monlink" title="<%=strComp%>"><%=(strComp.length()>=40)?strComp.substring(0,40)+"...":strComp%></a>
											</td>
<%
					}
					else
					{
						//pdf work
						aListData.add("");
%>
											<td width="30%" id="cell_bg1">&nbsp;</td>
<%
					}

					if (j%3 == 2)
					{
%>
										</tr>
<%
					}
				}

				//pdf work
				ArrayList userColumnNames = new ArrayList();
				userColumnNames.add("C1");
				userColumnNames.add("C2");
				userColumnNames.add("C3");

				ArrayList aListColumnNames = new ArrayList();
				aListColumnNames.add(mappingInfo.getTextDescription("configmgmt.inventory.view.Components"));
				aListColumnNames.add("");
				aListColumnNames.add("");

				EgTableAttributes egTableAttributes = new EgTableAttributes();
				egTableAttributes.setTitle(mappingInfo.getTextDescription("configmgmt.inventory.view.Managed Components"));
				egTableAttributes.setColumnNames(aListColumnNames);
				egTableAttributes.setStartX(0);

				EgTableModel egTableModel = new EgTableModel(aListData,userColumnNames);
				EgTable egTable = new EgTable();
				egTable.setModel(egTableModel);
				egTable.setAttributes(egTableAttributes);
				aListPdfData.add(egTable);
%>
									</table>
<%
			}
%>

									<table border="0" cellspacing="0" cellpadding="0" width="100%" class="body_text">
										<tr>
											<td colspan="3" height="5" id="blank">&nbsp;</td>
										</tr>
									</table>

<%
			if(commonInformation!=null && commonInformation.size()>0)
			{
				//pdf work
				ArrayList aListData = new ArrayList();
				EgTableAttributes egTableAttributes = new EgTableAttributes();
				String tableTitle = "Basic Configuration";
				tableTitle = mappingInfo.getTextDescription("configmgmt.inventory.view."+tableTitle);
				egTableAttributes.setTitle(tableTitle);
				ArrayList aListColumnNames = new ArrayList();
				ArrayList userColumnNames = new ArrayList();

				ArrayList details=new ArrayList();
				int count=0;
				String serverName="";
				String boxName=system+":NULL:Win_generic_server";
				ArrayList alist=new ArrayList();

				Iterator iterat = commonInformation.keySet().iterator();
				while(iterat.hasNext())
				{
					String svalue=(String)iterat.next();
					details=(ArrayList)commonInformation.get(svalue);
					if(details==null || details.size()==0)
						continue;
					alist.add(svalue);
				}
				details=new ArrayList();
				ArrayList comDetails=(ArrayList)commonInformation.get(boxName);
				if(comDetails==null || comDetails.size()==0)
				{
					boxName=system+":NULL:Generic_server";
					details=(ArrayList)commonInformation.get(boxName);
					if(details==null || details.size()==0)
					{
						if(alist!=null && alist.size()>0)
						{
							boxName=(String)alist.get(0);
							details=(ArrayList)commonInformation.get(boxName);
						}
					}
				}
				else
					details=comDetails;

				commonInformation.remove(boxName);
				int loopCount=commonInformation.size();
%>
									<table border="0" cellspacing="0" cellpadding="0" width="100%" class="body_text">
<%
				Iterator iteration = commonInformation.keySet().iterator();
				do
				{
					if(count==0)
					{
						serverName=boxName;
					}
					else
					{
						serverName=(String)iteration.next();
						details=(ArrayList)commonInformation.get(serverName);
					}
					if (details==null || details.size()==0)
						continue;

					ArrayList title= (ArrayList)details.get(0);
%>
										<tr>
											<td colspan="3" width="100%" align="center">
												<table width="99%" border="0" cellspacing="0" cellpadding="0" class="body_text" id="bottomtable">
													<tr>
														<td width="20%" align="left" id="bgdarkimg" height="20">
															<b><egui:intnl text="configmgmt.inventory.view.Basic Configuration for" /> <%=system%></b>
														</td>
													</tr>
<%
					for(int m=1;m<details.size();m++)
					{
						if (m >= 2) continue;
						ArrayList testWiseInfo = (ArrayList)details.get(m); 
						ArrayList testName = (ArrayList)testWiseInfo.get(0);
						ArrayList flag= (ArrayList)testWiseInfo.get(1);
						ArrayList columnNames = (ArrayList)testWiseInfo.get(2);
						TreeMap data = (TreeMap)testWiseInfo.get(3);
						ArrayList flagRow = (ArrayList)flag.get(0);
						ArrayList flagColumn = (ArrayList)flag.get(1);
						int columnCount = columnNames.size();
%>
													<tr>
														<td align="center">
															<table width="100%" border="0" cellspacing="0" cellpadding="0">
<%
						if(count!=0)
						{
%>

																<tr>
																	<td class="table_header" id="white_content" height="20">&nbsp;<%=testName.get(0)%></td>
																</tr>
<%
						}
%>

																<tr>
																	<td width="100%" id="form_border">
																		<table border="0" width="100%" cellspacing="0" cellpadding="0" class="body_text">
<%
						Iterator iterate =data.keySet().iterator();
						boolean colHeading_flag = false;
						boolean fieldFlag = true;
						int f = 0;
						while(iterate.hasNext())
						{
							String info = (String)iterate.next();
							ArrayList infoDetails = (ArrayList)data.get(info);
							if (info.equals("+"))//Show row-wise data - Non-Info based - Don't show Descriptor
							{
								//pdf work
								aListColumnNames.add("C1");
								aListColumnNames.add("C2");

								userColumnNames.add(mappingInfo.getTextDescription("configmgmt.configuration.Attribute"));
								userColumnNames.add(mappingInfo.getTextDescription("configmgmt.configuration.Value"));
%>
																<tr>
																	<td width="100%">
																		<table border="0" cellspacing="0" cellpadding="0" class="body_text" width="100%">
<%
								for(int x=1;x<columnCount;x++)
								{
									String flagValue = (String)flagColumn.get(x);
									if (flagValue.equals("true"))
									{
										String colName = (String)columnNames.get(x);
										//pdf work
										aListData.add(colName);
										aListData.add(infoDetails.get(x-1));
%>
																			<tr>
																				<td id="cell_header_single" width="50%">
																				<%=(String)columnNames.get(x)%>
																				</td>
																				<td id="cell_bg1" width="50%">
																					<%=infoDetails.get(x-1)%>
																				</td>
																			</tr>
<%
									}
								}
%>
																		</table>
																	</td>
																</tr>
<%
							}
							else //Info-Based
							{
								//pdf work
								if (columnCount <= 5)
									egTableAttributes.setDataGrouping(false);
								else
									egTableAttributes.setDataGrouping(true);

								if (columnCount <=5) //Column-wise
								{
									if (!colHeading_flag)
									{
%>
																<tr>
<%
										for(int n=0;n<columnCount;n++)
										{
											String flagValue = (String)flagColumn.get(n);
											if(flagValue!=null && flagValue.equals("true"))
											{
												String columnName = (String)columnNames.get(n);

												//pdf work
												aListColumnNames.add("C"+n);
												userColumnNames.add(columnName);

												if (columnCount == 2)
												{
%>
																	<td id="cell_header" width="50%"> <%=(String)columnNames.get(n)%> </td>
<%
												}
												else if (columnCount == 3)
												{
%>
																	<td id="cell_header" width="33%"> <%=(String)columnNames.get(n)%> </td>
<%
												}
												else if (columnCount == 4)
												{
%>
																	<td id="cell_header" width="25%"> <%=(String)columnNames.get(n)%> </td>
<%
												}
												else if (columnCount == 5)
												{
%>
																	<td id="cell_header" width="20%"> <%=(String)columnNames.get(n)%> </td>
<%
												}
											}
										}
%>
																</tr>
<%
										colHeading_flag = true;
									}
									String flagValue = (String)flagRow.get(f);
									if (flagValue.equals("true"))
									{
										if (info.indexOf('>') != -1) //Present... Tree form
											info = info.substring(info.lastIndexOf('>')+1);

										// pdf work
										aListData.add(info);
%>
																<tr>
																	<td id="cell_bg1"><%=info.trim()%></td>
<%
										for(int z=0;z<columnCount-1;z++)
										{
											String displayName= (String)flagColumn.get(z+1);
											if (displayName.equals("true"))
											{
												String value = (String)infoDetails.get(z);
												if (value.equalsIgnoreCase(EgConfigConstants.CF_YES))
												{
													//pdf work
													aListData.add(mappingInfo.getTextDescription("configmgmt.common.Yes"));
%>
																	<td id="cell_bg1" wrap><egui:intnl text="configmgmt.common.Yes"/></td>
<%
												}
												else
												{
													//pdf work
													aListData.add(value);

%>
																	<td id="cell_bg1" wrap><%=value%>&nbsp;</td>
<%
												}
											}
										}
									}
%>
																</tr>
<%
								}
								else
								{
									//Row-wise
									String flagValue = (String)flagRow.get(f);
									if (flagValue.equals("true"))
									{
										if (info.indexOf('>') != -1) //Present... Tree form
											info = info.substring(info.lastIndexOf('>')+1);
%>
																<tr>
																	<td class="bglightimg" height="20" colspan="2"><%=info.trim()%>
																	</td>
																</tr>
																<tr>
																	<td width="90%">
																		<table border="0" cellspacing="0" cellpadding="0" class="body_text" width="100%">
<%
										if(fieldFlag)
										{
											aListColumnNames.add("C1");
											aListColumnNames.add("C2");
											aListColumnNames.add("C3");

											userColumnNames.add(mappingInfo.getTextDescription("configmgmt.configuration.Descriptor"));
											userColumnNames.add(mappingInfo.getTextDescription("configmgmt.configuration.Attribute"));
											userColumnNames.add(mappingInfo.getTextDescription("configmgmt.configuration.Value"));
											egTableAttributes.setDataGroupingField(0);
											fieldFlag=false;
										}

										for(int p=1;p<columnCount;p++)
										{
											flagValue = (String)flagColumn.get(p);
											if (flagValue.equals("true"))
											{
												aListData.add(info);
												aListData.add((String)columnNames.get(p));
%>
																			<tr>
																				<td id="cell_header_single" width="50%">
																					<%=(String)columnNames.get(p)%>
																				</td>
<%
												String value = (String)infoDetails.get(p-1);
												if (value.equalsIgnoreCase(EgConfigConstants.CF_YES))
												{
													aListData.add(mappingInfo.getTextDescription("configmgmt.common.Yes"));
%>
																				<td id="cell_bg1" width="50%"><egui:intnl text="configmgmt.common.Yes" />&nbsp;</td>
<%
												}
												else
												{
													aListData.add(value);
%>
																				<td id="cell_bg1" width="50%"><%=value%>&nbsp;</td>
																			</tr>
<%
												}
											}
										}
%>
																		</table>
																	</td>
																</tr>
<%
									}
								}
							}
							f++;
						}
%>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
<%
					}   // Finishing  ArrayList Heading Value

					count++;
				}
				while (false);

				//pdf work
				EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
				egTableAttributes.setColumnNames(userColumnNames);
				EgTable egTable = new EgTable();
				egTable.setModel(egTableModel);
				egTable.setAttributes(egTableAttributes);
				aListPdfData.add(egTable);
%>
									</table>
									<table>
										<tr>
											<td height="5" id="blank">&nbsp;</td>
										</tr>
									</table>
<%
			}

			if((systemDetailData!= null && systemDetailData.size()>0) || (commonInformation!=null && commonInformation.size()>0))
			{
				//pdf work
				pdfData.setData(aListPdfData);
				session.setAttribute("pdfData",pdfData);
			}
			else
			{
				if(system!=null)
				{
%>
									<table border="0" cellspacing="0" cellpadding="0" width="100%" class="body_text">
										<tr>
											<td height="180" id="blank">&nbsp;</td>
										</tr>
										<tr>
											<td align="center" valign="middle">
												<table border="0" align="center" width="100%" height="100%">
													<tr>
														<td align="center">
															<table border="0" align="center" width="100%" class="body_text">
																<tr>
																	<td align="center"> <img src="/final/config/images/unavailable-data.gif" alt='<egui:intnl text="configmgmt.common.No Data" />'></td>
																</tr>
																<tr>
																	<td align="center"><b><egui:intnl text="configmgmt.inventory.view.No data found for the selected system/combination" /></b></td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
<%
				}
			}
%>
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
		}
	}
	else
	{
%>
				<input type="hidden" name="submitClicked" value="false">
				<tr>
					<td id="padding6" height="100%" width="100%" style="padding-top:0px">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" id="bottomtable">
							<tr>
								<td align="center" width="100%" height="100%" valign="top" class="bgwhite">
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
	}
%>
			</table>
		</td>
	</tr>
</table>
</form>
</body>
</html>



