<%
/******************************************************************************
*	Name			:	updateTestPeriod.jsp
*	Purpose			:	modify eg_agents.ini to have atleast minimum test frequency
						to run a test at proper time interval
*	Version			:	5.0
*	Creation Date	:	9/1/2009
*	Author			:	James Thomas P
******************************************************************************/
%>
<%@ include file = "EgTrackerA.jsp" %>
<%@ page errorPage = "EgProbs.jsp"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.EgUtils"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgExternalInfo"%>
<%@ page import = "com.eg.EgAggregateInfo"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.egurkha.EgConstants"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "java.util.List"%>
<%@ page import = "java.util.TreeMap"%>
<%@ page import = "java.util.ArrayList"%>
<%@ page import = "java.util.Hashtable"%>
<%@ page import = "java.util.StringTokenizer"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.admin.UpdateTestPeriod"%>
<%@ page import = "com.eg.EgRoleInfo"%>

<%@ taglib prefix = "egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language = "java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<%
	if(!EgInstallInfo.isAggregationSupported())
	{
		Vector errors = new Vector();
		errors.addElement(_mapping.getTextDescription("admin.error.Admin Home"));
		errors.addElement("EgAdminOperations.jsp");
		errors.addElement(_mapping.getTextDescription("admin.error.Possible Reason"));
		errors.addElement(_mapping.getTextDescription("admin.error.Your license does not allow you to use this feature")+".");
		errors.addElement(_mapping.getTextDescription("admin.error.Please contact") + " <a href='mailTo:license@eginnovations.com' target='_parent' class='dash_link'><b>license@eginnovations.com</b></a> " + _mapping.getTextDescription("admin.error.for more details")+".");
		session.putValue("vec_Errors", errors);
%>
	<jsp:forward page="EgErrors.jsp" />
<%
	}
	IniFile uiIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String[] testFormatPeriod = uiIni.getVariables("TEST_FREQUENCY");
	TreeMap reversePeriodMap = new TreeMap();
	if(!EgUtils.isNull((Object) testFormatPeriod))
	{
		for (int i=0;i<testFormatPeriod.length;i++)
		{
			String secondsStr = uiIni.getValue("TEST_FREQUENCY", testFormatPeriod[i]);
			reversePeriodMap.put(secondsStr, testFormatPeriod[i]);
		}
	}
	String operation = request.getParameter("operation");
	operation = "update";
	if(!StringUtils.isNull(operation) && operation.equalsIgnoreCase("update"))
	{
		String selectedTests = request.getParameter("selectedTests");
		if(!StringUtils.isNull(selectedTests))
		{
			/* code for auditlog starts */
			AuditLogThread auditLogThread = new AuditLogThread();
			auditLogThread.setValue("Category","Admin");
			auditLogThread.setValue("User_id",_user.getLoginID());
			auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Module","Aggregate Test Period");
			auditLogThread.setValue("Activity","Update Test Period");
			/* code for auditlog ends */
			StringTokenizer tokens = new StringTokenizer(selectedTests,"$");
			TreeMap map = new TreeMap();
			while(tokens.hasMoreTokens())
			{
				String information = (String) tokens.nextToken();
				String testPeriod = information.substring(information.lastIndexOf(":")+1);
				String previousTestPeriod = testPeriod.substring(testPeriod.lastIndexOf("|")+1);
				testPeriod = testPeriod.substring(0,testPeriod.lastIndexOf("|"));
				information = information.substring(0,information.lastIndexOf(":"));
				String testName = information.substring(information.lastIndexOf(":")+1);
				String componentName = information.substring(0,information.lastIndexOf(":"));
				if(map.containsKey(componentName))
				{
					TreeMap imap = (TreeMap) map.get(componentName);
					imap.put(testName,testPeriod);
					if(componentName.endsWith(":NULL"))
						componentName = componentName.substring(0,componentName.lastIndexOf(":"));
					auditLogThread.setCurrentValue("$test$:"+testName+EgConstants.BLANK_SPACE+"($ctype$:"+componentName+")",(String)reversePeriodMap.get(testPeriod));
					auditLogThread.setPreviousValue("$test$:"+testName+EgConstants.BLANK_SPACE+"($ctype$:"+componentName+")",(String)reversePeriodMap.get(previousTestPeriod));
				}
				else
				{
					TreeMap imap = new TreeMap();
					imap.put(testName,testPeriod);
					map.put(componentName,imap);
					if(componentName.endsWith(":NULL"))
						componentName = componentName.substring(0,componentName.lastIndexOf(":"));					
					auditLogThread.setCurrentValue("$test$:"+testName+EgConstants.BLANK_SPACE+"($ctype$:"+componentName+")",(String)reversePeriodMap.get(testPeriod));
					auditLogThread.setPreviousValue("$test$:"+testName+EgConstants.BLANK_SPACE+"($ctype$:"+componentName+")",(String)reversePeriodMap.get(previousTestPeriod));
				}
			}
%>
			<jsp:useBean id="serviceBean" scope="request" class="egurkha.ServiceBean"/>
<%
			serviceBean.stopDiscovery();
			UpdateTestPeriod updateTestPeriod = new UpdateTestPeriod();
			updateTestPeriod.updateTestPeriod(map);
			serviceBean.startDiscovery("1");

			/* code for auditlog starts */
			auditLogThread.setValue("Description","Aggregate tests periods have been updated");
			auditLogThread.sendItToDB();
			/* code for auditlog ends */
		}
	}
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
	Vector serverTypes = aggregateInfo.getAggregateTypes();
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	List listComponentTypes = Arrays.asList(ri.getServerTypes());
	Iterator itr1 = serverTypes.iterator();
	while(itr1.hasNext())
	{
		if(!listComponentTypes.contains(itr1.next()))
		{
			itr1.remove();
		}
	}
	for(int i=serverTypes.size()-1;i>=0;i--)
		if(discInfo.getAllServersOfType((String) serverTypes.get(i)).length==0)
			serverTypes.remove(i);
	String selectedServer = request.getParameter("selectedServer");
	if(StringUtils.isNull(selectedServer))
		selectedServer = "-1";
	TreeMap periodMap = new TreeMap();
	if(!EgUtils.isNull((Object) testFormatPeriod))
	{
		for (int i=0;i<testFormatPeriod.length;i++)
		{
			String secondsStr = uiIni.getValue("TEST_FREQUENCY", testFormatPeriod[i]);
			long seconds = Long.parseLong(secondsStr);
			periodMap.put(new Long(seconds), testFormatPeriod[i]);
		}
	}

	TreeMap localSettings = new TreeMap();
	String selectedComponent = request.getParameter("selectedComponent");
	if(StringUtils.isNull(selectedComponent))
		selectedComponent = "-1";
	String userLanguage = _user.getLanguage();
	if(userLanguage == null)
		userLanguage = IniUI.getInstance().getDefaultLanguage();
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	ArrayList serverList = new ArrayList(serverTypes);
	serverList = sorter.getSortedCompTypeList(serverList);
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);

	String test_component = request.getParameter("test_component");
	String selectedTest = null;
	if(!StringUtils.isNull(test_component))
	{
		selectedTest = test_component.substring(0,test_component.indexOf(":"));
		selectedComponent = test_component.substring(test_component.indexOf(":")+1);
		selectedServer = selectedComponent.substring(0,selectedComponent.indexOf(":"));
	}
%>
<html>
<head>
	<egui:skin ui = "admin"/>
	<script language="javascript">
	var selectedTests = "";
	function selectAType()
	{
		var thisForm = document.list;
		var serverType = thisForm.servertypes.options[thisForm.servertypes.selectedIndex].value;
		if(serverType == -1)
			window.location.href = "updateTestPeriod.jsp";
		else
			window.location.href = "updateTestPeriod.jsp?selectedServer=" +encodeURI(serverType);
	}
	function selectAComponent()
	{
		var thisForm = document.list;
		var serverType = thisForm.servertypes.options[thisForm.servertypes.selectedIndex].value;
		var component = thisForm.components.options[thisForm.components.selectedIndex].value;
		if(serverType == -1)
			window.location.href = "updateTestPeriod.jsp";
		else
			window.location.href = "updateTestPeriod.jsp?selectedServer=" +encodeURI(serverType)+"&selectedComponent=" +encodeURI(component);
	}
	function update()
	{
		var thisForm = window.document.list;
		var server_type = window.document.list.servertypes.value;
		var component = thisForm.components.options[thisForm.components.selectedIndex].value;
		var a = new Array();
		for(i=0;i<thisForm.elements.length;i++)
		{
			if(thisForm[i].type=="checkbox" && thisForm[i].checked && thisForm[i].value != "selectAll")
			{
				component_test_pair = thisForm[i].value;
				if(thisForm[i].name.indexOf("parent_")==0)
					continue;
				test_period = document.getElementById(component_test_pair).value;
				a.push(component_test_pair+':'+test_period);
			}
		}
		if(a.length==0)
		{
			alert('<egui:intnl text="No tests selected" />');
			return;
		}
		else
		{
			for(i=0;i<a.length;i++)
			{
				selectedTests += a[i] + "$"; // dont use # symbol instead of $
			}
			selectedTests = selectedTests.substring(0,selectedTests.lastIndexOf('$'));
			url = "updateTestPeriod.jsp?operation=update&selectedTests="+selectedTests+'&selectedServer='+server_type+'&selectedComponent='+component;
			thisForm.action = url;
			thisForm.submit();
		}
	}
	function checkOrUncheckParentCheckbox(checkboxObject)
	{
		var thisForm = window.document.list;
		component_name = checkboxObject.name;
		component_name = component_name.substring(component_name.indexOf("_")+1);
		for(i=0;i<thisForm.elements.length;i++)
		{
			if(thisForm[i].type=="checkbox" && parseInt(thisForm[i].value.indexOf(component_name))==0)
				thisForm[i].checked = checkboxObject.checked;
		}
		setCheckedStatusOfHeaderCheckbox();
	}
	function checkOrUncheckSiblingCheckbox(checkboxObject)
	{
		var thisForm = window.document.list;
		component_name = checkboxObject.name;
		search_string = checkboxObject.name.substring(0,component_name.lastIndexOf(":"));
		parentCheckboxName = "parent_"+search_string.substring(search_string.indexOf("_")+1);
		checkParent = true;
		for(i=0;i<thisForm.elements.length;i++)
		{
			if(thisForm[i].type=="checkbox" && parseInt(thisForm[i].name.indexOf(search_string))==0 && !thisForm[i].checked)
			{
				checkParent = false;
				break;
			}
		}
		for(i=0;i<thisForm.elements.length;i++)
		{
			if(thisForm[i].type=="checkbox" && thisForm[i].name==parentCheckboxName)
			{
				thisForm[i].checked = checkParent;
				setCheckedStatusOfHeaderCheckbox();
				break;
			}
		}
	}

	function setCheckedStatusOfHeaderCheckbox()
	{
		var thisForm = window.document.list;
		var checkboxStatus = true;
		for(i=0;i<thisForm.elements.length;i++)
		{
			if(thisForm[i].type=="checkbox" && thisForm[i].name.indexOf("parent_")==0)
			{
				checkboxStatus = checkboxStatus && thisForm[i].checked;
				if(!checkboxStatus)
					break;
			}
		}
		document.getElementById("selectAll").checked = checkboxStatus;
	}

	function checkOrUncheckHeaderCheckbox(checkboxObject)
	{
		var thisForm = window.document.list;
		for(i=0;i<thisForm.elements.length;i++)
		{
			if(thisForm[i].type=="checkbox")
				thisForm[i].checked = checkboxObject.checked;
		}
	}
	</script>
</head>
<body style="overflow:auto" leftmargin="0" topmargin="0" marginwidth="0" marginheight="0">
	<form name="list" method="post" action="updateTestPeriod.jsp" style="margin:0px">
<%
	session.setAttribute("egPageDesc","updateTestPeriod.jsp");
	String tmpUrl = "listSearch.jsp?title=Update Aggregate Test Period&leftString=&subtitle=false&searchBox=false";
	String fromUnconfigTest = request.getParameter("reqfrom");
	if (fromUnconfigTest != null)
	{
		if (fromUnconfigTest.equalsIgnoreCase("UnconfigTests"))
		{
			tmpUrl = tmpUrl + "&backButton=true";
		}
	}
%>
	<jsp:include page="<%=tmpUrl%>"/>
		<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
			<tr>
				<td width="100%" id="eg_whitebg" align="center" height="100%" valign="middle">
					<table align="center" cellspacing="0" cellpadding="0" width="75%" border="0">
						<tr>
							<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							<td height="6" id="eg_subcontentbg" width="100%" colspan="6"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
							<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
						</tr>
						<tr>
							<td class="eg_subcontentbg" id="form_spacing">&nbsp;</td>
							<td align="left" width="130" class="eg_subcontentbg" nowrap height="20" id="form_spacing">&nbsp;<egui:intnl text="admin.threshold.Component type"/></td>
							<td width="5" class="eg_subcontentbg" id="form_spacing">:</td>
							<td class="eg_subcontentbg" id="form_spacing" style="padding-left:10px;"><select name="servertypes" onChange ='javascript:selectAType()' style='width:220px;'>
								<option value="-1"><egui:intnl text="admin.common.Choose a component type"/></option>

<%
								if(serverList != null && serverList.size()>1)
								{
%>
									<option value="all" <%=(selectedServer.equalsIgnoreCase("all"))?"selected":""%>><egui:intnl text="admin.common.ALL"/></option>
<%
								}
								for(int i=0;i<serverList.size();i++)
								{
									EgName nameObj = (EgName)serverList.get(i);
									String serverName = nameObj.getActualName();
									String displayName = nameObj.getLocalName();
									localSettings.put(serverName,displayName);
%>
									<option value="<%=serverName%>" <%=(serverName.equals(selectedServer))?"selected":""%>><%=displayName%></option>
<%
								}
%>
							</select>
							</td>
							<td align="left" class="eg_subcontentbg" nowrap height="20" id="form_spacing" width="130">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<egui:intnl text="admin.threshold.Component name"/></td>
							<td class="eg_subcontentbg" id="form_spacing">:</td>
							<td class="eg_subcontentbg" id="v" style="padding-left:10px;">
							<select name="components" style='width:220px;' onChange ="javascript:selectAComponent()">
								<option value="-1"><egui:intnl text="admin.common.Choose a component name"/></option>
<%
									String componentNames[] = null;
									if(selectedServer.equalsIgnoreCase("all"))
									{
										Vector allComponents = new Vector();
										for(int i=serverTypes.size()-1;i>=0;i--)
										{
											String components[] = discInfo.getAllServersOfType(serverTypes.get(i).toString());
											if(components != null && components.length>0)
												allComponents.addAll(java.util.Arrays.asList(components));
										}
										Collections.sort(allComponents);
										componentNames = (String[])allComponents.toArray(new String[allComponents.size()]);
									}
									else
										componentNames = discInfo.getAllServersOfType(selectedServer);
									if(componentNames != null && componentNames.length>1)
									{
%>
									<option value="all" <%=(selectedComponent.equalsIgnoreCase("all"))?"selected":""%>><egui:intnl text="admin.common.ALL"/></option>
<%
									}
									for(int i=0;i<componentNames.length;i++)
									{
										String componentName = componentNames[i];
										String display = componentName.substring(componentName.indexOf(":")+1,componentName.lastIndexOf(":"));
										if(selectedServer.equalsIgnoreCase("all"))
										{
%>
									<option value="<%=componentName%>" <%=(componentName.equals(selectedComponent))?"selected":""%>><%=display%>:<egui:intnl type='<%=componentName.substring(0,componentName.indexOf(":"))%>'/></option>
<%
										}
										else
										{
%>
									<option value="<%=componentName%>" <%=(componentName.equals(selectedComponent))?"selected":""%>><%=display%></option>
<%
										}
									}
%>
							</select>
							</td>
							<td class="eg_subcontentbg" id="form_spacing">&nbsp;</td>
						</tr>
						<tr>
							<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
							<td id="eg_subcontentbg"  width="100%" colspan="6" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
							<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td id="eg_blankspace" height="10">&nbsp;</td>
			</tr>
<%
			boolean showUpdateButton = false;
			if(!selectedComponent.equals("-1"))
			{
				UpdateTestPeriod updateTestPeriod = new UpdateTestPeriod();
				TreeMap details = new TreeMap();
				if(selectedComponent.equalsIgnoreCase("all"))
					updateTestPeriod.setComponentTestMapping(selectedServer,"all");
				else
					updateTestPeriod.setComponentTestMapping(selectedServer,selectedComponent);
				details = updateTestPeriod.getComponentTestMapping();
				Iterator detailsItr = details.keySet().iterator();
				int i=0;
				while(detailsItr.hasNext())
				{
					showUpdateButton = true;
					String component = (String) detailsItr.next();
					String displayComponent = component.substring(component.indexOf(":")+1,component.lastIndexOf(":"));
					String localStr = (String) localSettings.get((String)component.substring(0,component.indexOf(":")));
		if(i==0)
		{
			i=1;
%>
			<tr>
				<td>
					<table align="center" cellspacing="0" cellpadding="0" width="60%" border="0" style="table-layout:fixed">
						<tr>
							<td id="table_border" class="eg_morelight">
								<table align="center" width="100%" cellspacing="0" cellpadding="3" border="0" id="cell_border1"><col width="3%"><col width="60%"><col width="37%">
									<tr>
										<td id="table_head" style="padding-left:6px;padding-right:6px" align="right" height="20"><input class="eg_input" style="border:0px" type="checkbox" id="selectAll" name="selectAll" value="selectAll" onClick="checkOrUncheckHeaderCheckbox(this);"></td>
										<td id="table_head"><b><egui:intnl text="admin.common.Tests running below recommended test period"/></b></td>
										<td id="table_head" align="center"><b><egui:intnl text="admin.common.Recommended Test Period"/></b></td>
									</tr>
								</table>
							</td>
						</tr>
<%
		}
%>
						<tr>
							<td id="table_border" class="padding6 eg_morelight">
								<table align="center" width="100%" cellspacing="0" cellpadding="3" border="0" id="cell_border1"><col width="2%"><col width="60%"><col width="38%">
									<tr>
										<td id="table_head" align="left" height="20"><input class="eg_input" style="border:0px" type="checkbox" name="<%="parent_"+component%>" value="<%=component%>" onClick="checkOrUncheckParentCheckbox(this);"></td>
										<td id="table_head" class="lineleft" align="left" colspan="2"><b><%=displayComponent%></b></td>
									</tr>
<%
										TreeMap innerDetails = (TreeMap) details.get(component);
										Iterator innerDetailsItr = innerDetails.keySet().iterator();
										ArrayList testList = new ArrayList(innerDetails.keySet());
										testList = sorter.getSortedTestList(testList);
										for(int c=0;c<testList.size();c++)
										{
											EgName nameObj = (EgName)testList.get(c);
											String testName = nameObj.getActualName();
											String displayName = nameObj.getLocalName();
											String frequencyStr = (String) innerDetails.get(testName);
											String perviousFrequency = "";
											if(frequencyStr != null && frequencyStr.indexOf("#") > 0)
											{
												perviousFrequency= frequencyStr.substring(0,frequencyStr.indexOf("#"));	
												frequencyStr = frequencyStr.substring(frequencyStr.indexOf("#")+1);
											}
											long frequency = Integer.parseInt(frequencyStr);

											String status = (selectedTest != null && testName.equals(selectedTest))?"checked":"";
%>
									<tr>
										<td id="<%=(c%2==0)?"cell_border3":"cell_border4"%>" height="22" class="space3"><input class="eg_input" style="border:0px" type='checkbox' name='<%="sibling_"+component+":"+testName%>' value='<%=component+":"+testName%>' onClick="checkOrUncheckSiblingCheckbox(this);" <%=status%>></td>
										<td id="<%=(c%2==0)?"cell_border3":"cell_border4"%>" class="space3"><%=displayName%></td>
										<td align="center" id="<%=(c%2==0)?"cell_border3":"cell_border4"%>" class="space3">
											<select id='<%=component+":"+testName%>' style="width:75px">
<%
											Iterator itr = periodMap.keySet().iterator();
											while(itr.hasNext())
											{
												Long seconds = (Long) itr.next();
												String display = (String) periodMap.get(seconds);
												String numeric = display.substring(0,display.indexOf(EgConstants.BLANK_SPACE));
												String str = "admin.common."+display.substring(display.indexOf(EgConstants.BLANK_SPACE)+1);
												if(seconds.longValue()<frequency)
													continue;
%>
												<option value="<%=seconds.toString()%>|<%=perviousFrequency%>"><%=numeric%>&nbsp;<egui:intnl text="<%=str%>"/></option>
<%
											}
%>
											</select>
										</td>
									</tr>
<%
										}
%>
								</table>
							</td>
						</tr>
<%
				}
if(i==1)
{
%>
						<tr>
							<td id="eg_blnkspace" height="10">&nbsp;</td>
						</tr>
					</table>
				</td>
			</tr>

<%

}

			}
			if(showUpdateButton)
			{
%>
			<tr>
				<td align="center">
					<input type="button" value='<egui:intnl text="admin.common.Update"/>' style="width:80px" class="eg_darkbutton" onClick="javascript:update();">
				</td>
			</tr>
<%
			}
%>
			<tr>
				<td id="eg_blnkspace" height="10">&nbsp;</td>
			</tr>
		</table>
<%
			if(!showUpdateButton && !selectedComponent.equals("-1"))
			{
%>
			<table align="center" cellspacing="0" cellpadding="0" width="60%" height="50%" border="0">
<%
	String strComponent = null;
	if (!selectedComponent.equals("all"))
	{
		strComponent = selectedComponent.substring(selectedComponent.indexOf(":")+1);
	}

	if(selectedServer.equalsIgnoreCase("all"))
	{
		if (strComponent == null)
		{
%>
				<tr>
					<td id="inner_top_left" align="center" height="100%"><center><img src="eg_images/<%=admin_Skin%>/exclamation-icon.gif"></center><br><egui:intnl text="admin.common.Aggregate tests are running with recommended test period"/><br><br>
					<a class="body_link" href="EgConfigureComponentTests.jsp?componentType=&componentName=-1&reqfrom=aggTestPeriod&showPopup=false"><egui:intnl text="admin.common.Click here"/>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a>&nbsp;<egui:intnl text="admin.common.to reconfigure tests"/></td>
				</tr>
<%
		}
		else
		{
			String strCompType = selectedComponent.substring(0,selectedComponent.indexOf(":"));
%>
				<tr>
					<td id="inner_top_left" align="center" height="100%"><center><img src="eg_images/<%=admin_Skin%>/exclamation-icon.gif"></center><br><egui:intnl text="admin.common.Aggregate tests are running with recommended test period"/><br><br>
					<a class="body_link" href="EgConfigureComponentTests.jsp?componentType=<%=strCompType%>&componentName=<%=strComponent%>&testType=PerformanceTest&reqfrom=aggTestPeriod&showPopup=false"><egui:intnl text="admin.common.Click here"/>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a>&nbsp;<egui:intnl text="admin.common.to reconfigure tests"/></td>
				</tr>
<%
		}
	}
	else
	{
		String comps[] = discInfo.getAllServersOfType(selectedServer);
		strComponent="-1";
		if(comps != null && comps.length>0)
		{
			strComponent = comps[0].substring(comps[0].indexOf(":")+1);
		}
%>
				<tr>
					<td id="inner_top_left" align="center" height="100%"><center><img src="eg_images/<%=admin_Skin%>/exclamation-icon.gif"></center><br><egui:intnl text="admin.common.Aggregate tests are running with recommended test period"/><br><br>
					<a class="body_link" href="EgConfigureComponentTests.jsp?componentType=<%=selectedServer%>&componentName=<%=strComponent%>&testType=PerformanceTest&reqfrom=aggTestPeriod&showPopup=false"><egui:intnl text="admin.common.Click here"/>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a>&nbsp;<egui:intnl text="admin.common.to reconfigure tests of type"/>&nbsp;<%=localSettings.get(selectedServer)%></td>
				</tr>
<%
	}
%>
			</table>
<%
			}
%>
	</form>
</body>
</html>
<%
		if(request.getQueryString() != null)
			session.setAttribute("adminLastAccessedURL","/final/admin/updateTestPeriod.jsp?"+request.getQueryString());
		else
			session.setAttribute("adminLastAccessedURL","/final/admin/updateTestPeriod.jsp");
%>
