<%
/***********************************************************************************************************
*	Name			:	Rename.jsp
*	Purpose			:	To rename zones/services/segments/groups
*	Version			:	5.5
*	CreationDate	:	17-Feb-2012
*	Author			:	James Thomas P
***********************************************************************************************************/
%>
<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgTopoInfo"%>
<%@ page import = "com.eg.EgGroupInfo"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires",-1);

	String from = request.getParameter("from");
	String old_name = request.getParameter("old_name");
	if(StringUtils.isNull(old_name))
	{
		old_name="";
	}
	String url = null;
	String oldLabel = "";
	String newLabel = "";
	String doUpdateCheck = "false";
	IniFile servicesIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_services.ini");
	doUpdateCheck = servicesIni.getValue("MISC_ARGS","AllowMeasurementAndReportTableUpdation");
	if(StringUtils.isNull(doUpdateCheck))
	{
		doUpdateCheck="false";
	}
	else if(doUpdateCheck.equalsIgnoreCase("t") || doUpdateCheck.equalsIgnoreCase("true") || 
		doUpdateCheck.equalsIgnoreCase("y") || doUpdateCheck.equalsIgnoreCase("yes"))
	{
		doUpdateCheck="true";
	}
	if(from.equalsIgnoreCase("Group"))
	{
		url = "listSearch.jsp?title=RENAMING GROUP&backButton=true&subtitle=false";
		oldLabel="admin.common.Current name of the selected group";
		newLabel="admin.common.New name for the selected group";
	}
	else if(from.equalsIgnoreCase("Segment"))
	{
		url = "listSearch.jsp?title=RENAMING SEGMENT&backButton=true&subtitle=false";
		oldLabel="admin.common.Current name of the selected segment";
		newLabel="admin.common.New name for the selected segment";
	}
	else if(from.equalsIgnoreCase("Service"))
	{
		url = "listSearch.jsp?title=RENAMING SERVICE&backButton=true&subtitle=false";
		oldLabel="admin.common.Current name of the selected service";
		newLabel="admin.common.New name for the selected service";
	}
	else if(from.equalsIgnoreCase("Zone"))
	{
		url = "listSearch.jsp?title=RENAMING ZONE&backButton=true&subtitle=false";
		oldLabel="admin.common.Current name of the selected zone";
		newLabel="admin.common.New name for the selected zone";
	}
	else if(from.equalsIgnoreCase("Service Group"))
	{
		url = "listSearch.jsp?title=RENAMING SERVICE GROUP&backButton=true&subtitle=false";
		oldLabel="admin.common.Current name of the selected service group";
		newLabel="admin.common.New name for the selected service group";
	}
	boolean doubleByteEnabled=EgDbInfo.doubleByteEnabled;
	String existing_names[] = existing_names = new String[0];
	Object obj = session.getAttribute("existing_names");
	if(obj != null && obj instanceof String[])
	{
		String tmp[] = (String[])obj;
		if(tmp != null && tmp.length>0)
		{
			Vector v = new Vector(Arrays.asList(tmp));
			v.remove(old_name);
			if(v.size()>0)
			{
				existing_names = (String[])v.toArray(new String[v.size()]);
				v.clear();
			}
			v=null;
		}
	}
%>

<html>
<head>
<title>Rename</title>
<egui:skin ui="admin"/>
<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script language="JavaScript1.2">
function call_renaming()
{
	var thisForm = document.rename;
	var s_oldname = thisForm.old_name.value;
	var s_new_name = thisForm.new_name.value;
	var doubleByteName=true;
	if('<%=doubleByteEnabled%>'=='false')
	{
		doubleByteName = validateSingleByte(thisForm.new_name.value);
	}
	if(!checkblank(thisForm.new_name))
	{
		alert('<egui:intnl text="admin.common.Field value cannot be blank"/>');
		thisForm.new_name.focus();
		return;
	}
	else if(!checkspace(thisForm.new_name))
	{
		thisForm.new_name.focus();
		return;
	}
	else if(!checkspecial(thisForm.new_name,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/"))
	{
		thisForm.new_name.focus();
		return;
	}
	else if(!doubleByteName)
	{
		alert('<egui:intnl text="admin.zone.Zone name is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"/>');
		thisForm.new_name.focus();
		return;
	}
	else if(s_oldname==s_new_name)
	{
		alert('<egui:intnl text="admin.common.Current and new names are same"/>. <egui:intnl text="admin.common.Please use differnt name for New name"/>.');
		return;
	}
	else
	{
		var allow = true;
<%
		for(int i=0;i<existing_names.length;i++)
		{
%>
			if(s_new_name.toLowerCase()=='<%=existing_names[i].toLowerCase()%>')
			{
				allow=false;
			}
<%
		}
%>
		if(allow)
		{
			var result = "true";
			/*if('<%=doUpdateCheck%>'=="true")
			{
				result = confirm('<egui:intnl text="admin.common.Do you want to update measurement tables"/>?');
			}*/
			if(!confirm('<egui:intnl text="admin.common.This may take some time"/>. <egui:intnl text="admin.common.Do you want to continue"/>?'))
			{
				return;
			}
			else
			{
				thisForm.r_name.value='<egui:intnl text="admin.text.Renaming"/>';
				thisForm.r_name.disabled = true;
				thisForm.action = "renamep.jsp?rename=<%=from%>&old_name="+encodeURI(s_oldname)+
				"&new_name="+encodeURI(s_new_name)+"&update_msmt_table="+result;
				thisForm.submit();
			}
		}
		else
		{
			alert('<egui:intnl text="admin.common.New name is already assigned"/>. <egui:intnl text="admin.common.Please select some other name"/>.');
		}
	}
}
function setFocus()
{
	document.rename.new_name.focus();
}
</script>
</head>
<body style="overflow:auto" id="space6" onload="javascript:setFocus();">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
	<jsp:include page="<%=url%>"/>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
			<form name="rename" method="post" style="margin:0px">
				<table align="center" width="85%" cellspacing="0" cellpadding="0" border="0">
					<tr>
						<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
						<td height="6" id="eg_subcontentbg" width="100%" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
						<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					</tr>
					<tr>
						<td align="center" valign="top" class="eg_subcontentbg" colspan="5" id="form_spacing">
							<table align="center" cellspacing="0" cellpadding="3" width="100%" border="0">	
								<tr>
									<td colspan="3" id="eg_subcontentbg" style="padding:0px">
										<table border="0" cellpadding="0" cellspacing="0" width="100%">
											<tr>
												<th id="eg_subcontentbg" class="form_border" width="297" nowrap valign="top"><egui:intnl text="<%=oldLabel%>"/></th>
												<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap valign="top">:</td>
												<td id="eg_subcontentbg" class="form_border" nowrap height="21">
													<input type="text" <%=from.equalsIgnoreCase("Service")?"maxlength=\"64\"":"maxlength=\"32\""%> name="old_name" value ="<%=old_name%>" readonly style="width:370px">
												</td>
											</tr>
										</table>
									</td>
								</tr>
								<tr>
									<td colspan="3" id="eg_subcontentbg" class="form_spacing">
										<table border="0" cellpadding="0" cellspacing="0" width="100%">
											<tr>
												<th id="eg_subcontentbg" class="form_spacing" width="297" nowrap><egui:intnl text="<%=newLabel%>"/></th>
												<td id="eg_subcontentbg" class="form_spacing" width="20" align="center" nowrap valign="top">:</td>
												<td id="eg_subcontentbg" class="form_spacing" nowrap><input type="text" <%=from.equalsIgnoreCase("Service")?"maxlength=\"64\"":"maxlength=\"32\""%>  name="new_name" style="width:370px" onkeydown="if (event.keyCode == 13) call_renaming();"></td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
						<td id="eg_subcontentbg" width="100%" colspan="3" valign="top"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
						<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
					</tr>
					<tr>
						<td height="30" valign="bottom" colspan="5" align="center">&nbsp;<input type="button" name="r_name" value='<egui:intnl text="admin.common.Rename"/>' style="width:90px;" class="eg_back" onClick="javascript:call_renaming()"></td>
					</tr>
				</table>
			</form>
		</td>
	</tr>
</table>
</body>
</html>
