<%
/**********************************************************************************
*   Name            :   egDeleteAllPolicyGroups.jsp
*   Purpose         :   to Delete Policies and Policy Groups.
*   Last Modified   :   Nov-22-2008
*   Author          :   Rajesh.P
***********************************************************************************/
%>
<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import = "com.egurkha.admin.EgMaintenanceUtility" %>
<%@ page import = "com.egurkha.admin.EgMaintenanceTree" %>
<%@ page import="java.util.ArrayList" %>
<%@ page import="java.util.Collections" %>
<%@ page import="java.io.File"%>
<%@ page import = "com.eg.EgRoleInfo"%>
<%@ page import = "egurkha.reporter.ErUtils" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ taglib prefix = "egui" uri ="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
response.setHeader("Cache-Control","no-store");
response.setHeader("Pragma","no-cache");
response.setDateHeader("Expires", -1);
try
{
	String from=request.getParameter("from");
	String operation=request.getParameter("op");
	String pagesub=request.getParameter("pagesub");
	String deletedPolicyNames[] = request.getParameterValues("mpolicies");
	EgMaintenanceUtility egM=new EgMaintenanceUtility();
	EgMaintenanceTree  maintenanceTree=new EgMaintenanceTree();
	String userName = _user.getLoginID();
	EgRoleInfo roleInfo = EgRoleInfo.getInstance(session.getId(),userName);
	boolean isLimitedAdmin = !roleInfo.hasAllComponentAccess();
	Vector data=new Vector();
	ArrayList displayList = new ArrayList();
	String disptitle="",errrmsg="",divtitle="";
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	String MaintenanceViewSrc="/final/admin/egUnplannedMaintenancePolicyList.jsp";
	if(operation!=null && operation.equals("delete"))
	{
		if(from!=null && from.equals("deleteallpolicies"))
		{
			if(deletedPolicyNames!=null && deletedPolicyNames.length > 0)
			{
				String deletedpolicies="";
				auditLogThread.setValue("Module","Maintenance Periods");
				auditLogThread.setValue("Activity","Define Policy");
				for(int j=0;j<deletedPolicyNames.length;j++)
				{
					egM.deletePolicy(deletedPolicyNames[j]);
					if(deletedpolicies!=null && deletedpolicies.equals(""))
					{
						deletedpolicies=deletedPolicyNames[j];
					}
					else
					{
						deletedpolicies=deletedpolicies+","+deletedPolicyNames[j];
					}
				}
				if(deletedpolicies!=null && !deletedpolicies.equals(""))
				{
					auditLogThread.setValue("Description","Maintenance policies has been deleted");
					auditLogThread.setCurrentValue("Deleted Policies",deletedpolicies);
					auditLogThread.sendItToDB();
				}
			}
			MaintenanceViewSrc="/final/admin/egUnassociatedPolicyList.jsp";
		}
		else if(from!=null &&   from.equals("deleteallpolicygroups"))
		{
			if(deletedPolicyNames!=null && deletedPolicyNames.length > 0)
			{
				auditLogThread.setValue("Module","Maintenance Periods");
				auditLogThread.setValue("Activity","Define Groups");
				String deletedpolicygrps="";
				for(int j=0;j<deletedPolicyNames.length;j++)
				{
					egM.deletePolicyGroup(deletedPolicyNames[j]);
					if(deletedpolicygrps!=null && deletedpolicygrps.equals(""))
					{
						deletedpolicygrps=deletedPolicyNames[j];
					}
					else
					{
						deletedpolicygrps=deletedpolicygrps+","+deletedPolicyNames[j];
					}
				}
				if(deletedpolicygrps!=null && !deletedpolicygrps.equals(""))
				{
					auditLogThread.setValue("Description","Policy Groups has been deleted");
					auditLogThread.setCurrentValue("Deleted Policy Groups",deletedpolicygrps);
					auditLogThread.sendItToDB();
				}
			}
			MaintenanceViewSrc="/final/admin/egMaintenancePolicygroupList.jsp";
		}
		else if(from!=null && from.equals("deleteallunplannedpolicies"))
		{
			if(deletedPolicyNames!=null && deletedPolicyNames.length > 0)
			{
				auditLogThread.setValue("Module","Quick Maintenance Policies");
				auditLogThread.setValue("Activity","Define and Associate Policies");
				String deletedpolicies="";
				for(int j=0;j<deletedPolicyNames.length;j++)
				{
					egM.deleteUnplannedMaintenancePolicy(deletedPolicyNames[j]);
					if(deletedpolicies!=null && deletedpolicies.equals(""))
					{
						deletedpolicies=deletedPolicyNames[j];
					}
					else
					{
						deletedpolicies=deletedpolicies+","+deletedPolicyNames[j];
				
					}
				}
				if(deletedpolicies!=null && !deletedpolicies.equals(""))
				{
					auditLogThread.setValue("Description","Quick Maintenance Policies has been deleted");
					auditLogThread.setCurrentValue("Deleted Quick Maintenance Policies ",deletedpolicies);
					auditLogThread.sendItToDB();
				}
			}
			MaintenanceViewSrc="/final/admin/egUnplannedMaintenancePolicyList.jsp";
		}
	}
	if(from!=null && from.equals("deleteallpolicies"))
	{
		data=(Vector)maintenanceTree.getUnassociatedPolicy();
		Collections.sort(data,String.CASE_INSENSITIVE_ORDER);
		displayList = new ArrayList(data);
		disptitle="admin.mpolicy.Independent Policies";
		errrmsg="admin.mib.There are no policies available currently!";
		divtitle="DELETE ALL POLICIES";
	}
	else if(from!=null &&   from.equals("deleteallpolicygroups"))
	{
		data=(Vector)egM.getAllGroups();
		data.remove("default");
		displayList = new ArrayList(data);
		disptitle="admin.mpolicy.Policy Groups";
		errrmsg="admin.mib.There are no policy groups available currently!";
		divtitle="DELETE ALL POLICY GROUPS";
	}
	else if(from!=null && from.equals("deleteallunplannedpolicies"))
	{
		data=(Vector)maintenanceTree.getAllUnplannedMaintenancePolicies();
		Collections.sort(data,String.CASE_INSENSITIVE_ORDER);
		if (isLimitedAdmin)
		{
			Vector userPolicies = new Vector();
			for (int d=0; d < data.size(); d++)
			{
				String policy = (String)data.get(d);
				int index = policy.indexOf("|$|");
				if (index > -1)
				{
					String policyUser = policy.substring(index+3);
					if (policyUser.toLowerCase().equals(userName.toLowerCase()))
					{
						userPolicies.add(policy);
					}
				}				
			}
			data.retainAll(userPolicies);
		}
		
		displayList = new ArrayList(data);
		for (int d=0;d < displayList.size(); d++)
		{
			String dispPolicy = displayList.get(d).toString();
			int index = dispPolicy.indexOf("|$|");
			if (index  > -1)
			{
				if (isLimitedAdmin)
				{
					dispPolicy = dispPolicy.substring(0,index);
				}
				else
				{
					dispPolicy = dispPolicy.substring(0,index)+" ("+dispPolicy.substring(index+3)+")";
				}
				displayList.remove(d);
				displayList.add(d,dispPolicy);
			}			
		}
		disptitle="admin.mpolicy.Quick Maintenance Policies";
		errrmsg="admin.mib.There are no quick maintenance policy available currently!";
		divtitle="DELETE ALL QUICK MAINTENANCE POLICIES";
	}
%>
<html>
	<head>
		<title>Delete All Policies or Policy Groups </title>
		<egui:skin ui = "admin"/>
		<script language="JavaScript">
function valform()
{
	var thisForm = document.deletepolicies;
	var typ='<%=from%>';
	if(thisForm.mpolicies.options.selectedIndex == -1)
	{
		if(typ!=null && typ!="" && typ=="deleteallpolicies")
		{
			alert('<egui:intnl text="admin.mib.Please select a policy"/>')
		}
		else if(typ!=null && typ!="" && typ=="deleteallpolicygroups")
		{
			alert('<egui:intnl text="admin.mib.Please select a policy group"/>')
		}

	}
	else if(confirm('<egui:intnl text="admin.user.Are you sure you want to delete the selected policy(s)?"/>'))
	{
		var typ='<%=from%>';
		thisForm.op.value="delete";
		thisForm.from.value=typ;
		thisForm.pagesub.value="true";
		thisForm.action="egDeleteAllPolicyGroups.jsp";
		thisForm.submit();
	}
}
function updateTree()
{
	var MaintananceTree=window.parent.document.getElementById("MaintananceTree");
	var MaintananceView=window.parent.document.getElementById("MaintananceView");
	if(MaintananceTree!=null)
	{
	MaintananceTree.src="/final/admin/egMaintenanceTreeUI.jsp";
	}
	if(MaintananceView!=null)
	{
		var MaintenanceViewSrc='<%=MaintenanceViewSrc%>';
		MaintananceView.src=MaintenanceViewSrc;
	}
	var opera='<%=operation%>';
	if(opera!=null && opera=="delete")
	{
		closeDeletePolicyDiv();
	}

}

function closeDeletePolicyDiv()
{
	var deletepolicyDiv=window.parent.document.getElementById("deleteAllPolicyDiv");
	
	if(deletepolicyDiv!=null)
	{
		deletepolicyDiv.style.display="none";

	}
}
</script>
</head>
<%
	if(pagesub!=null && pagesub.equals("true"))
		{
%>
<body onload="updateTree();" leftmargin="0" topmargin="0" >
<%
		}
		else
		{
%>
<body leftmargin="0" topmargin="0" >
<%
		}
%>
		<form name="deletepolicies" method="get" style="padding:0px; margin:0px">
<table width="100%" cellpadding="0" cellspacing="0" border="0" height="100%">
	<tr>
		<td style="padding:0px" id="tree_bgdark">
			<table width="100%" cellpadding="0" cellspacing="0" border="0" id="tree_bgdark" >
				<tr>
					<td align="center" width="100%" class="eg_white"></td>
					<td style="padding:2px" align="center" valign="middle"><a onClick="javascript:closeDeletePolicyDiv()"><img src="/final/monitor/eg_images/winclose.gif" border="1" class="mouse" title="close"></a></td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td width="100%">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0"  class="eg_lightlight" id="alarmborder" height="100%">
				<%  if(data!=null && data.size()>0)
						{
				%>
				<tr>
					<td   width="100%" align="center" valign="top" class="eg_blankspace" height="10px">&nbsp;</td>
				</tr>
				<tr>
					<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
						<table align="center" cellspacing="0" cellpadding="0" width="85%" border="0">
							<tr>
								<td colspan="5" width="100%" height="22">
									<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" id="eg_subcontentbg" height="22">
										<tr>
											<td id="subhead_left" width="7">
												<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
											</td>
											<td width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px">
												<strong><egui:intnl text="<%=disptitle%>" /></strong>
											</td>
											<td id="subhead_right" width="7">
												<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td id="eg_subcontentbg"  width="100%" align="center" valign="top" colspan="3" class="eg_blankspace" height="10px">&nbsp;&nbsp;</td>
							</tr>
							<tr>
								<td id="eg_subcontentbg"  width="100%" align="center" valign="top" colspan="3" class="form_spacing">&nbsp;&nbsp;
									<select name="mpolicies" id="mpolicies" multiple size="25" style="width:350px" >
<%
										for(int i=0;i<data.size();i++)
										{
											String tmpVal=(String)data.get(i);
											String dispVal = (String)displayList.get(i);
										%>
										<option value=<%=tmpVal%> selected><%=dispVal%></option>
										<%
										}
%>
									</select>
								</td>
							</tr>
							<tr>
								<td id="eg_blankspace" height="10" nowrap colspan="3" class="eg_subcontentbg">&nbsp;</td>
							</tr>
							<tr>
								<td height="6" class="inner_bott_left" width="7" > <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  width="100%" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" class="inner_bott_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
							
							<tr>
								<td id="eg_blankspace" height="10" nowrap colspan="4">&nbsp;</td>
							</tr>
							<tr>
								<td width="100%" align="center" colspan="4">
									<input type="button" name="deleteuser" value='<egui:intnl text="admin.common.Delete" />' style="width: 80px;" class="eg_darkbutton" onClick="javascript:valform()" />
								</td>
							</tr>
							<input type='hidden' name='op' id='op'>
							<input type='hidden' name='from' id='from'>
							<input type='hidden' name='pagesub' id='pagesub'>
<%
							}
							else
							{
%>
							<tr>
								<td id="eg_whitebg" colspan="3" height="400">
									<table border="0" cellspacing="0" cellpadding="4" width="100%" >
										<tr> 
											<td width="100%" align="center">
												<img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br>
											</td>
										</tr>
										<tr>
											<td width="100%" align="center" id="eg_errorsmall">
												<egui:intnl text="<%=errrmsg%>"/>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
							}
%>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
		</form>
	</body>
</html>
<%
}
catch(Exception e)
{
e.printStackTrace();
}
%>

