<%
/*
	Author			:	James Thomas P.
	Creation Date	:	22nd Nov 2007
	Purpose			:	to print auditlog reports (for logons.jsp and failedLogons.jsp)
*/
%>
<%@ include file = "EgTrackerA.jsp" %>
<%@ page errorPage = "EgProbs.jsp" %>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.admin.AuditLogDatabag"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.egurkha.EgConstants" %>
<%@ page import = "com.eg.EgDnsManager"%>
<%@ page import = "com.eg.EgDbInfo"%>

<%@ taglib prefix = "egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	Map egUserInfo = (Map)session.getAttribute("egUserDetails");
	int wrapLengthInt = 35;
	int commaCount = 10;

	boolean showBoth = true;
	String comFormat = null;
	String displaydate = null;

	IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_ui.ini");
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	String wrapLengthStr = iniFile.getValue("AUDIT_LOG_SETTINGS","Wrap_length");
	int wrapLength = 16;
	if(wrapLengthStr != null && (wrapLengthStr=wrapLengthStr.trim()).length()>0)
	{
		try
		{
			wrapLength = Integer.parseInt(wrapLengthStr);
		}
		catch(Exception e)
		{
			wrapLength = 16;
		}
	}
	String showCurrentAndPrevious = iniFile.getValue("AUDIT_LOG_SETTINGS","ShowChanges");	
	if(showCurrentAndPrevious != null && showCurrentAndPrevious.trim().equalsIgnoreCase("false"))
		showBoth = false;

	EgDnsManager dnsManager = EgDnsManager.getInstance();
	boolean displayHostname = false;
	String showHostname = iniFile.getValue("AUDIT_LOG_SETTINGS","DisplayHostname");
	if(showHostname != null && (showHostname.trim().equalsIgnoreCase("true") || showHostname.trim().equalsIgnoreCase("yes")))
		displayHostname = true;
	com.egurkha.ini.IniUI ui = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	UserRegistry aregistry = UserRegistry.getInstance();
	User user = aregistry.getUser(session.getId());
	String loginid = user.getLoginID();
	String thisLanguage = ui.getDefaultLanguage();
	if (user!=null)
	{
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	boolean isClusterSupported = EgInstallInfo.isAggregationSupported();
	IniFile servicesIniFile = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_services.ini");
	String auditlogForCLI = servicesIniFile.getValue("MISC_ARGS","AuditlogForCLI");
	boolean auditLogEnabledForCLI = !StringUtils.isNull(auditlogForCLI) && (auditlogForCLI.equalsIgnoreCase("true") || auditlogForCLI.equalsIgnoreCase("yes"))?true:false;
	String fontStyle = "";
	String pdfpage = request.getParameter("pdfpage");
	pdfpage = StringUtils.isNull(pdfpage)?"false":pdfpage.trim();
	if(pdfpage.equalsIgnoreCase("true"))
	{
		EgDbInfo dbInfo = new EgDbInfo("manager");
		if (dbInfo.doubleByteEnabled)
		{
			fontStyle = "multi_font";
		}
	}
	String category = request.getParameter("category");
	if(StringUtils.isNull(category))
	{
		category="ADMIN";
	}
	else
	{
		category = category.toUpperCase();
	}
%>
<html> 
<head>
<title>Audit Log Print</title>
<egui:skin ui="admin"/>
<script language="JavaScript">	
	function printPage()
	{
		window.print();
	}
	function callPrint()
	{
		document.forms[0].submit();
	}
</script>
</head>
<body style="overflow:auto" id="space6" scroll="auto">
<%
if(request.getParameter("reloaded") !=null && request.getParameter("reloaded").equals("true"))
{
%>
<form action='auditlogPrint.jsp'>
<%
	AuditLogDatabag databagObj = new AuditLogDatabag();
	databagObj.setLanguage(thisLanguage);

	AuditLogDatabag databag = null;
	Iterator itr = null;
	List result = null;
	
	if (request.getAttribute("tableData")!= null)
	{
		Object tableData = request.getAttribute("tableData");
		if(tableData != null)
		{
			databag = (AuditLogDatabag)tableData;
			result = databag.getResult();
		}
	}

	if(request.getAttribute("AuditUserdetails")!= null)
	{
		Object tableData = request.getAttribute("AuditUserdetails");
		if(tableData != null)
		{
			databag = (AuditLogDatabag) tableData;
			result = databag.getResult();
		}
	}
	List printList = (List) session.getAttribute("printList");
	String headingStr = request.getParameter("heading");
	if(printList != null && !StringUtils.isNull(headingStr) && !headingStr.equals("undefined"))
	{
		printList.set(0,request.getParameter("heading"));
	}
	else
	{
		printList.set(0,category+" AUDITLOG REPORT DETAILS");
	}
	String imageName = trackerUI.getMonitorHomeLogo();
%>
<table border="0" cellspacing="0" cellpadding="2" width="100%" style="table-layout:fixed">
	<tr>
		<td width="100%" align="center" height="100%" valign="top">
			<table width="90%" border="0" cellspacing="0" cellpadding="0">
				<tr>
<%
		if(StringUtils.isNull(imageName))
		{
%>
					<td align="left" width="30%"><img src="../monitor/eg_images/eG_logomonitor.gif" border="0"></td>
<%
		}
		else
		{
%>
					<td align="left" width="30%"><img src="<%=imageName%>" border="0"></td>
<%
		}
%>
					<td width="70%" align="right" valign="bottom">
						<table width="100%" border="0" cellspacing="0" cellpadding="0">

<%
							if(printList != null)
							{
								String realUser = (String)printList.get(1);
								realUser = (realUser==null)?"":realUser;
								if (realUser != null && realUser.indexOf("/Grp/") != -1)
								{
									if (egUserInfo != null && egUserInfo.size() > 0)
									{
										realUser = (String)egUserInfo.get(realUser);
									}
								}
								String temp_Usr = iniFile.getValue("DBUSER_USER_MAP",realUser);
								if (temp_Usr != null && temp_Usr.length() > 0)
								{
									realUser = temp_Usr;
								}

								String tempRealUser = StringUtils.replace(realUser,"<","&lt;");
								tempRealUser = StringUtils.replace(tempRealUser,">","&gt;");

								if(printList.contains("basedOnSession"))
								{
%>
								<tr>
									<td class="<%=fontStyle%>" align='right'><b><%=_mapping.getTextDescription("admin.logins.print."+printList.get(0))%></b></td>
								</tr>
								<tr>
									<td>
										<img src="/final/config/images/spacer.gif" border="0">
									</td>
								</tr>
								<tr>
									<td class="<%=fontStyle%>" align='right'><b><egui:intnl text="admin.common.User"/></b>&nbsp;:&nbsp;<%=tempRealUser%></td>
								</tr>
								<tr>
									<td>
										<img src="/final/config/images/spacer.gif" border="0">
									</td>
								</tr>
								<tr>
									<td class="<%=fontStyle%>" align='right'><b><egui:intnl text="admin.common.Session Period"/></b>&nbsp;:&nbsp;<%=printList.get(2)%></td>
								</tr>
<%
								}
								else
								{
%>
								<tr>
									<td class="<%=fontStyle%>" align='right'><b><%=_mapping.getTextDescription("admin.logins.print."+printList.get(0))%></b></td>
								</tr>
								<tr>
									<td>
										<img src="/final/config/images/spacer.gif" border="0">
									</td>
								</tr>
								<tr>
									<td class="<%=fontStyle%>" align='right'><b><egui:intnl text="admin.common.User"/></b>&nbsp;:&nbsp;<%=tempRealUser%></td>
								</tr>
								<tr>
									<td>
										<img src="/final/config/images/spacer.gif" border="0">
									</td>
								</tr>
								<tr>
									<td class="<%=fontStyle%>" align='right'><b><egui:intnl text="admin.common.Timeline"/></b>&nbsp;:&nbsp;<%=printList.get(2)%></td>
								</tr>
<%
								}
							}
%>
								
								<tr>
									<td><img src="/final/config/images/spacer.gif" border="0" height="2"></td>
								</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
<table align = "center" cellspacing = "0" cellpadding = "0" width = "100%" border = "0">
	<tr>
		<td width = "100%" id = "eg_whitebg" align = "center" height = "100%" valign = "top">
			<table align = "center" border = "0" cellspacing = "0" cellpadding = "0" width="100%">
				<tr>
					<td>
						<table cellpadding='0' cellspacing='0' border='0' align='center' width = "100%">
							<tr>
								<td>
									<table cellpadding='0' cellspacing='0' border='0' align='center' width = "90%">
<%
result = (List)session.getAttribute("auditResult");
if(result != null)
{
	itr = result.iterator();
}
if (itr != null && itr.hasNext())
{
%>
										<tr>
											<td id="linesquare2">
												<table width="100%" border="0" cellspacing = "0" cellpadding = "4" style="table-layout:fixed">
												<col width="90"><col width="125"><col width="110">
												<col width="130"><col width="145"><col width="260">
													<tr>
														<td id="eg_subheadbg" class="<%=fontStyle%>"><egui:intnl text="admin.common.Date"/></td>
														<td id="eg_subheadbg" class="<%=fontStyle%>"><egui:intnl text="admin.auditlog.User Name"/></td>
														<td id="eg_subheadbg" class="<%=fontStyle%>"><egui:intnl text="admin.auditlog.Host Name"/></td>
														<td id="eg_subheadbg" class="<%=fontStyle%>"><egui:intnl text="admin.auditlog.Module"/></td>
														<td id="eg_subheadbg" class="<%=fontStyle%>"><egui:intnl text="admin.auditlog.Activity"/></td>
														<td id="eg_subheadbg" class="<%=fontStyle%>"><egui:intnl text="admin.auditlog.Description"/></td>
													</tr>
<%
	int slCount = 15;
	ArrayList auditModules = new ArrayList();
	auditModules.add("User Management");
	auditModules.add("User Profile");

	ArrayList auditActivities = new ArrayList();
	auditActivities.add("Add User");
	auditActivities.add("Delete User");
	auditActivities.add("Modify User");
	auditActivities.add("Clone User");
	auditActivities.add("Update Profile");

	while(itr != null && itr.hasNext())
	{
		AuditLogDatabag thisEntry = (AuditLogDatabag) itr.next();
		StringTokenizer updat=new StringTokenizer(thisEntry.getUpdateTime());
		while(updat.hasMoreTokens())
		{
			String dispdat = updat.nextToken();
			String disphr = updat.nextToken();
			if(DateUtil.isDate(dispdat.trim(), "MM/dd/yyyy"))
				comFormat = "MM/dd/yyyy";
			else
				comFormat = currentDateFormat;
			String dispdate = DateUtil.changeDateFormat(dispdat.trim(),comFormat, currentDateFormat);
			displaydate = dispdate + " "+ disphr.trim();
			EgTimeZoneConverter egt = new EgTimeZoneConverter(displaydate, user);
			displaydate = egt.getDateTime();
		}

		String previousValue = thisEntry.getPreviousValue();
		String currentValue = thisEntry.getCurrentValue();
		String managerName = "Manager Name";
		String egServer = thisEntry.getManagerName();
		boolean showDetails = true;
		boolean isPreviousValueAvailable = false;
		boolean isCurrentValueAvailable = false;

		if (showDetails)
		{
			if(previousValue != null && !previousValue.equalsIgnoreCase("null") && previousValue.trim().length() > 0)
			{
				isPreviousValueAvailable = true;
				previousValue = previousValue.trim();
			}
			if(currentValue != null && !currentValue.equalsIgnoreCase("null") && currentValue.trim().length() > 0)
			{
				isCurrentValueAvailable = true;
				currentValue = currentValue.trim();
			}
		}

		String currentModule = thisEntry.getModule();
		String currentActivity = thisEntry.getActivity();

		boolean convertAsHTMLCode = false;
		if (auditModules.indexOf(currentModule) != -1 && auditActivities.indexOf(currentActivity) != -1)
		{
			convertAsHTMLCode = true;
		}

		Hashtable ht = new Hashtable();
		String selected_hash = EgConstants.EG_HASH;
		if(isPreviousValueAvailable)
		{
			String separator1 = EgConstants.EG_PIPE;
			String separator2 = EgConstants.EG_HASH;
			if(previousValue.indexOf(separator1) == -1)
			{
				separator1 = EgConstants.PIPE;
				separator2 = EgConstants.HASH;
				selected_hash=EgConstants.HASH;
			}
			String keyWithValues[] = StringUtils.getTokens(previousValue,separator2);
			for(int i=0;i<keyWithValues.length;i++)
			{
				ArrayList values = new ArrayList();
				if(keyWithValues[i].indexOf(separator1) != -1)
				{
					String key = keyWithValues[i].substring(0,keyWithValues[i].indexOf(separator1));
					String value = keyWithValues[i].substring(keyWithValues[i].indexOf(separator1)+separator1.length());
					values.add(value);
					ht.put(key,values);
				}
			}
		}
		
		if(isCurrentValueAvailable)
		{
			String separator1 = EgConstants.EG_PIPE;
			String separator2 = EgConstants.EG_HASH;
			if(currentValue.indexOf(separator1) == -1)
			{
				separator1 = EgConstants.PIPE;
				separator2 = EgConstants.HASH;
				selected_hash=EgConstants.HASH;
			}
			String keyWithValues[] = StringUtils.getTokens(currentValue,separator2);
			for(int i=0;i<keyWithValues.length;i++)
			{
				ArrayList values = new ArrayList();
				if(keyWithValues[i].indexOf(separator1) != -1)
				{
					String key = keyWithValues[i].substring(0,keyWithValues[i].indexOf(separator1));
					String value = keyWithValues[i].substring(keyWithValues[i].indexOf(separator1)+separator1.length());

					if(ht != null && ht.containsKey(key))
					{
						ArrayList al = (ArrayList)ht.get(key);
						al.add(value);
						ht.put(key,al);
					}
					else
					{
						values.add("-");
						values.add(value);
						ht.put(key,values);
					}
				}
			}
		}

		ArrayList listObj = new ArrayList(ht.keySet());
		Collections.sort(listObj);
		//end

		String description = thisEntry.getDescription();
		StringTokenizer stm=new StringTokenizer(description," ");
		StringBuffer sb_desc=new StringBuffer();
		
		while(stm.hasMoreTokens())
		{
			String thisDesc = (String)stm.nextToken();
			thisDesc = databagObj.getMappingStr(thisDesc);
			String ar[] = StringUtils.getTokens(thisDesc," ");
			thisDesc="";
			for(int k=0;k<ar.length;k++)
			{
				thisDesc += StringUtils.format(ar[k], 22, "_");
			}
			sb_desc.append(thisDesc);
			sb_desc.append(" ");
		}

	String displayIPAddress = thisEntry.getHostIp();
	if(displayHostname)
	{
		displayIPAddress=dnsManager.getAuditLogHostName(displayIPAddress);
	}
	String realUser = thisEntry.getRealUser();
	String userName = thisEntry.getUserId();
	String displayUser = "";
	if (realUser != null && !realUser.equalsIgnoreCase("null") && !userName.equalsIgnoreCase(realUser))
	{
		if (userName != null && userName.indexOf("/Grp/") != -1)
		{
			String temp_Usr = iniFile.getValue("DBUSER_USER_MAP",userName);
			if (temp_Usr != null && temp_Usr.length() > 0)
			{
				userName = temp_Usr;
			}
			String grpDelimiter = "/Grp/";
			int idx = userName.indexOf(grpDelimiter);
			String str_uname_A = userName.substring(0,idx);
			int nextIdx = idx + grpDelimiter.length();
			String str_uname_B = userName.substring(nextIdx);
			userName = str_uname_A + "/" + str_uname_B + " (Group)";
		}
		displayUser = realUser + " of " +userName;
		displayUser = StringUtils.replace(displayUser,"<","&lt;");
		displayUser = StringUtils.replace(displayUser,">","&gt;");
	}
	else
	{
		displayUser = userName;
		String temp_Usr = iniFile.getValue("DBUSER_USER_MAP",userName);
		if (temp_Usr != null && temp_Usr.length() > 0)
		{
			displayUser = temp_Usr;
		}
		displayUser = StringUtils.replace(displayUser,"<","&lt;");
		displayUser = StringUtils.replace(displayUser,">","&gt;");
	}
	String desc = sb_desc.toString().trim();
	if (desc.startsWith("User") && desc.indexOf("has") != -1)
	{
		if (desc.startsWith("User profile has been updated for") || desc.startsWith("User  profile  has  been  updated  for"))
		{
			String tmp = desc.substring(desc.indexOf("for")+3);
			tmp = tmp.trim();
			if (tmp.indexOf("^") != -1)
			{
				String temp_usr = iniFile.getValue("DBUSER_USER_MAP",tmp);
				if (temp_usr != null && temp_usr.length() > 0)
				{
					desc = StringUtils.replace(desc,tmp,temp_usr);
				}
			}
		}
		else
		{
			String tmp = desc.substring(desc.indexOf("User")+5,desc.indexOf("has"));
			tmp = tmp.trim();
			String mapUser = "";
			if (tmp.indexOf("^") != -1)
			{
				if (tmp.indexOf("(Group)") != -1)
				{
					int idx = tmp.indexOf("/");
					int nextIdx = tmp.indexOf("(Group)");
					String strtempuname = tmp.substring(0,idx);
					strtempuname = strtempuname + "/Grp/";
					String strtempuname_A = tmp.substring(idx + 1 ,nextIdx);
					tmp = strtempuname + strtempuname_A;
					tmp = tmp.trim();
				}
				mapUser = tmp;
				String temp_usr = iniFile.getValue("DBUSER_USER_MAP",tmp);
				if (temp_usr != null && temp_usr.length() > 0)
				{
					if (temp_usr.indexOf("/Grp/") != -1)
					{
						String grpDelimiter = "/Grp/";
						int idx = temp_usr.indexOf(grpDelimiter);
						String str_uname_A = temp_usr.substring(0,idx);
						int nextIdx = idx + grpDelimiter.length();
						String str_uname_B = temp_usr.substring(nextIdx);
						temp_usr = str_uname_A + "/" + str_uname_B + " (Group)";
					}
					desc = StringUtils.replace(desc,tmp,temp_usr);
				}
			}
			if (desc.indexOf("existing user") != -1)
			{
				String existingUser = desc.substring(desc.lastIndexOf("existing user")+14);
				existingUser = existingUser.trim();
				String tmpData = iniFile.getValue("DBUSER_USER_MAP",existingUser);
				if (tmpData != null && tmpData.length() > 0)
				{
					desc = StringUtils.replace(desc,existingUser,tmpData);
				}
			}
		}
	}
	else if (desc.startsWith("Group") && desc.indexOf("has") != -1)
	{
		String tmp = desc.substring(desc.indexOf("Group")+5,desc.indexOf("has"));
		tmp = tmp.trim();
		if (tmp.indexOf("^") != -1)
		{
			String tmpData1 = tmp.substring(0,tmp.indexOf("/")+1);
			String tmpData2 = tmp.substring(tmp.indexOf("/")+1);
			tmpData1 = tmpData1 + "Grp/" +tmpData2;
			String temp_usr = iniFile.getValue("DBUSER_USER_MAP",tmpData1);
			if (temp_usr != null && temp_usr.length() > 0)
			{
				tmpData1 = temp_usr.substring(0,temp_usr.indexOf("/")+1);
				tmpData2 = temp_usr.substring(temp_usr.indexOf("/Grp/")+5);
				tmpData1 = tmpData1 + tmpData2;
				desc = StringUtils.replace(desc,tmp,tmpData1);
			}
		}
	}

	String tempDesc = desc;
	if (convertAsHTMLCode)
	{
		if (tempDesc.indexOf("<br>") != -1)
		{
			tempDesc = StringUtils.replace(tempDesc,"<br>","|LineBreak|");
		}
		else if (tempDesc.indexOf("<BR>") != -1)
		{
			tempDesc = StringUtils.replace(tempDesc,"<BR>","|LineBreak|");
		}
		tempDesc = StringUtils.replace(tempDesc,"<","&lt;");
		tempDesc = StringUtils.replace(tempDesc,">","&gt;");
		if (tempDesc.indexOf("|LineBreak|") != -1)
		{
			tempDesc = StringUtils.replace(tempDesc,"|LineBreak|","<br>");
		}
	}
%>
													<tr>
														<td class="audit_bg <%=fontStyle%>"><%=displaydate%></td>
														<td class="audit_bg <%=fontStyle%>"><%=StringUtils.format(displayUser,16,"_")%></td>
														<td class="audit_bg <%=fontStyle%>" title="<%=displayIPAddress%>"><%=StringUtils.format(displayIPAddress,16,"_")%></td>
														<td class="audit_bg <%=fontStyle%>"><%=thisEntry.getModule()%></td>
														<td class="audit_bg <%=fontStyle%>"><%=thisEntry.getActivity()%> </td>
														<td class="audit_bg <%=fontStyle%>"><%=tempDesc%> </td>
													</tr>
<%
		if(showBoth && (isPreviousValueAvailable || isCurrentValueAvailable))
		{
			String csvHeading = "";
			boolean colNameFlag = false;
			String previousColName = "";
			String currentColName = "";
			Iterator itrObj = listObj.iterator();
			while(itrObj.hasNext())
			{
				String key = (String)itrObj.next();
				if(key != null && key.equals("ColumnName"))
				{
					ArrayList alTemp = (ArrayList)ht.get(key);
					if(alTemp != null && alTemp.size() > 0)
					{
						previousColName = (String)alTemp.get(0);
					}
					if(alTemp != null && alTemp.size() == 2)
					{
						currentColName = (String)alTemp.get(1);
					}
					colNameFlag = true;
				}
			}
			if(isClusterSupported || auditLogEnabledForCLI)
			{
%>
													<tr>
														<td>&nbsp;</td>
														<td colspan="5" style="padding-left:0px">
															<table width="100%" cellpadding="4" cellspacing="0" border="0" id="linesquare" style="table-layout:fixed">
<%
				if(isClusterSupported)
				{
%>
																<tr>
																	<td width="25%" align="left" class="cell_border3 <%=fontStyle%>"><egui:intnl text="admin.auditlog.Manager Name/IP Address"/></td>
																	<td width="75%" align="left" class="cell_border3 <%=fontStyle%>"><%=egServer.substring(0, egServer.indexOf(selected_hash))%></td>
																</tr>
<%
				}
				if(auditLogEnabledForCLI)
				{
					//upgrade to work
					String display = "admin.auditlog.";
					int indexOfHashSymbol=egServer.indexOf(selected_hash);
					if(indexOfHashSymbol==-1)
					{
						display += "Web";
					}
					else
					{
						display += egServer.substring((indexOfHashSymbol+selected_hash.length()));
					}
%>
																<tr>
																	<td width="25%" align="left" class="cell_border3 <%=fontStyle%>"><egui:intnl text="admin.auditlog.Interface"/></td>
																	<td width="75%" align="left" class="cell_border3 <%=fontStyle%>"><egui:intnl text="<%=display%>"/></td>
																</tr>
<%
				}
%>
															</table>
														</td>
													</tr>
<%
			}
%>
													<!--starts here // by ahamed-->
													<tr>
														<td>&nbsp;</td>
														<td colspan="5" style="padding-left:0px">
<%
			if(isClusterSupported || auditLogEnabledForCLI)
			{
%>
															<table width="100%" cellpadding="4" cellspacing="0" border="0">
																<tr>
																	<th align="left" class="<%=fontStyle%>"><egui:intnl text="admin.auditlog.Activity Details"/>
																	</th>
																</tr>
															</table>
<%
			}
			String width1="width=\"24%\"";
			String width2="width=\"38%\"";
			if(isCurrentValueAvailable && !isPreviousValueAvailable || isPreviousValueAvailable && !isCurrentValueAvailable)
			{
				width1="width=\"25%\"";
				width2="width=\"75%\"";
			}
%>
															<table width="100%" cellpadding="4" cellspacing="0" border="5" id="linesquare" style="table-layout:fixed"><!-- <col width="240"><col width="278"><col width="257"> -->
																<tr>
																	<td <%=width1%> align="left" class="cell_border3">&nbsp;</td>
<%
			String colspan = "colspan='2'";
			if(isPreviousValueAvailable && isCurrentValueAvailable)
			{
				colspan = "";
			}
			if(isPreviousValueAvailable)
			{
%>
<%
				if(colNameFlag)
				{
%>
																	<td <%=width2%> align="left" class="cell_border3 <%=fontStyle%>" <%=colspan%>><egui:intnl text='<%="admin.auditlog."+previousColName%>'/>&nbsp;</td>
<%
				}
				else
				{
%>
																	<td <%=width2%> align="left" class="cell_border3 <%=fontStyle%>" <%=colspan%>><egui:intnl text="admin.auditlog.Previous settings"/>&nbsp;</td>
<%
				}
			}
			if(isCurrentValueAvailable){
				if(colNameFlag)
				{
%>
																	<td <%=width2%> align="left" class="cell_border3 <%=fontStyle%>" <%=colspan%>><egui:intnl text='<%="admin.auditlog."+currentColName%>'/>&nbsp;</td>
<%
				}
				else
				{
%>
																	<td <%=width2%> align="left" class="cell_border3 <%=fontStyle%>" <%=colspan%>><egui:intnl text="admin.auditlog.Current settings"/>&nbsp;</td>
<%
				}	
			}
%>
																</tr>
<%
			ArrayList currentKeys = new ArrayList();
			currentKeys.add("New User ID");
			currentKeys.add("User ID");
			currentKeys.add("User");
			currentKeys.add("User name");
			currentKeys.add("User Name");
			currentKeys.add("Sharing Users");
			currentKeys.add("Deleted Users");
			currentKeys.add("Associated Users");
			itrObj = listObj.iterator();
			while(itrObj.hasNext())
			{
				int prevCount = 0;
				int currentCount = 0;
				String key = (String)itrObj.next();
				if(key == null || key.equals("ColumnName"))
				{
					continue;
				}
				String previous = "-";
				String current = "-";
				ArrayList al = (ArrayList)ht.get(key);
				if(al != null && al.size() > 0)
				{
					previous = (String)al.get(0);
				}
				if(al != null && al.size() == 2)
				{	
					current = (String)al.get(1);
				}

				//checking for sort.
				int sortKeyIndex = key.indexOf("~~");
				if(sortKeyIndex > -1)
				{
					key = key.substring(sortKeyIndex+2);
				}

				if(isPreviousValueAvailable && (previous.indexOf(EgConstants.COMMA) != -1 || previous.indexOf(EgConstants.EG_COMMA) != -1) && key.indexOf("Date")==-1 && key.indexOf("Database column size")==-1)
				{
					String prevTokens[] = null;
					if(previous.indexOf(EgConstants.EG_COMMA) >-1)
						prevTokens=StringUtils.getTokens(previous,EgConstants.EG_COMMA);
					else if(previous.indexOf(EgConstants.COMMA) >-1)
						prevTokens=StringUtils.getTokens(previous,EgConstants.COMMA);
					if(prevTokens != null && prevTokens.length>0)
						prevCount = prevTokens.length;
					if(prevCount >= commaCount)
					{
						prevCount = 1;
					}
					
				}
				if(isCurrentValueAvailable && (current.indexOf(EgConstants.COMMA) != -1 || current.indexOf(EgConstants.EG_COMMA) != -1) && key.indexOf("Date")==-1 && key.indexOf("Database column size")==-1)
				{
					String curTokens[] = null;
					if(current.indexOf(EgConstants.EG_COMMA) >-1)
						curTokens=StringUtils.getTokens(current,EgConstants.EG_COMMA);
					else if(current.indexOf(EgConstants.COMMA) >-1)
						curTokens=StringUtils.getTokens(current,EgConstants.COMMA);

					if(curTokens != null && curTokens.length>0)
						currentCount = curTokens.length;
					if(currentCount >= commaCount)
					{
						currentCount = 1;
					}
				}
				int trCount = 0;
				if(prevCount > currentCount)
				{
					trCount = prevCount;
				}
				else
				{
					trCount = currentCount;
				}
				key = databagObj.getMappingStr(key);
%>
																<tr>
																	<td id="linebottomright" class="<%=fontStyle%>"><%=key%>
																	</td>
<%
				boolean multiple_tr_flag = true;
				if(prevCount == 1 || currentCount ==1)
				{
					multiple_tr_flag = false;
				}

				boolean ignoreLineBreak = false;
				if (currentKeys.indexOf(key) != -1)
				{
					ignoreLineBreak = true;
				}

				if(isPreviousValueAvailable)
				{
					String currentKey = key.trim();
					if(!isCurrentValueAvailable)
					{
						wrapLengthInt = 60;
					}
					else wrapLengthInt = 35;
					
					if((previous.indexOf(EgConstants.COMMA) != -1 || previous.indexOf(EgConstants.EG_COMMA) != -1) && key.indexOf("Date")==-1 && key.indexOf("Database column size")==-1 && multiple_tr_flag && !currentKey.equalsIgnoreCase("New User ID") && !currentKey.equalsIgnoreCase("User ID") && !currentKey.equalsIgnoreCase("User name") && !currentKey.equalsIgnoreCase("Sharing Users") && !currentKey.equalsIgnoreCase("Deleted Users"))
					{
						
%>
																	<td <%=colspan%> class="eg_morelight" style="padding:0px;border-left-width:0px;" valign="top" id="linebottomright">
																		<table width="100%" border='0' cellspacing="0" cellpadding="0">
<%
						String preTokens[] = null;
						//dont change the order of if else if condition
						if(previous.indexOf(EgConstants.EG_COMMA) > -1)
						{
							preTokens = StringUtils.getTokens(previous,EgConstants.EG_COMMA);
						}
						else if(previous.indexOf(EgConstants.COMMA) > -1)
						{
							preTokens = StringUtils.getTokens(previous,EgConstants.COMMA);
						}
						if(preTokens == null)
							preTokens = new String[0];
						int count = 0;
						if(preTokens != null && preTokens.length>0)
							count = preTokens.length;
						boolean slno = false;
						int slNo = 1;
						if(count>slCount)
							slno = true;
						for(int j=0;j<preTokens.length;j++)
						{
							String temp = preTokens[j];
							if(temp == null || temp.equalsIgnoreCase("null") || temp.trim().length()==0)
								continue;
							temp=databagObj.getMappingStr(temp);
							temp = StringUtils.format(temp, wrapLengthInt, "_");
							if (temp.indexOf("^") != -1)
							{
								if (temp.indexOf("(Group)") != -1 && !currentKey.equalsIgnoreCase("Problem Fixed by"))
								{
									int idx = temp.indexOf("/");
									int nextIdx = temp.indexOf("(Group)");
									String strtempuname = temp.substring(0,idx);
									strtempuname = strtempuname + "/Grp/";
									String strtempuname_A = temp.substring(idx + 1 ,nextIdx);
									temp = strtempuname + strtempuname_A;
									temp = temp.trim();

									String temp_user = iniFile.getValue("DBUSER_USER_MAP",temp.trim());
									if (temp_user != null && temp_user.length() > 0)
									{
										temp = temp_user;
										String grpDelimiter = "/Grp/";
										int idx1 = temp.indexOf(grpDelimiter);
										String str_uname_A = temp.substring(0,idx);
										int nextIdx1 = idx1 + grpDelimiter.length();
										String str_uname_B = temp.substring(nextIdx1);
										temp = str_uname_A + "/" + str_uname_B + " (Group)";
									}
								}
								else
								{
									String temp_user = iniFile.getValue("DBUSER_USER_MAP",temp.trim());
									if (temp_user != null && temp_user.length() > 0)
									{
										temp = temp_user;
									}
								}
							}

							if (ignoreLineBreak)
							{
								if (temp.indexOf("<br>") != -1)
								{
									temp = StringUtils.replace(temp,"<br>","|LineBreak|");
								}
								else if (temp.indexOf("<BR>") != -1)
								{
									temp = StringUtils.replace(temp,"<BR>","|LineBreak|");
								}

								temp = StringUtils.replace(temp,"<","&lt;");
								temp = StringUtils.replace(temp,">","&gt;");
								if (temp.indexOf("|LineBreak|") != -1)
								{
									temp = StringUtils.replace(temp,"|LineBreak|","<br>");
								}
							}
%>			
																			<tr>
																				<td align ='left' id="linebottomright" class="<%=fontStyle%>" style="padding:4px">
<%
										if(slno)
										{
%>
																<%=slNo%>) <%=temp%>
<%
										}
										else
										{
%>
															<%=temp%>
<%
										}
%>
																				</td>
																			</tr>
<%
										boolean hasMore = (j+1)<preTokens.length;
										for(int i=count; (i<trCount && !hasMore);i++)
										{
%>
																				<tr>
																					<td align ='left' id="linebottomright" style="padding:4px">&nbsp;</td>
																				</tr>
<%
										}
							slNo++;
						}
%>
																		</table>
																	</td>
<%
					}
					else
					{
						if(previous.indexOf(EgConstants.EG_COMMA) > -1)
						{
							previous = StringUtils.replace(previous,EgConstants.EG_COMMA,",");
						}
						previous=databagObj.getMappingStr(previous);
						if (previous.indexOf("^") != -1)
						{
							if (previous.indexOf("(Group)") != -1 && !currentKey.equalsIgnoreCase("Problem Fixed by"))
							{
								int idx = previous.indexOf("/");
								int nextIdx = previous.indexOf("(Group)");
								String strtempuname = previous.substring(0,idx);
								strtempuname = strtempuname + "/Grp/";
								String strtempuname_A = previous.substring(idx + 1 ,nextIdx);
								previous = strtempuname + strtempuname_A;
								previous = previous.trim();

								String temp_user = iniFile.getValue("DBUSER_USER_MAP",previous.trim());
								if (temp_user != null && temp_user.length() > 0)
								{
									previous = temp_user;
									String grpDelimiter = "/Grp/";
									int idx1 = previous.indexOf(grpDelimiter);
									String str_uname_A = previous.substring(0,idx);
									int nextIdx1 = idx1 + grpDelimiter.length();
									String str_uname_B = previous.substring(nextIdx1);
									previous = str_uname_A + "/" + str_uname_B + " (Group)";
								}
							}
							else
							{
								String temp_user = iniFile.getValue("DBUSER_USER_MAP",previous.trim());
								if (temp_user != null && temp_user.length() > 0)
								{
									previous = temp_user;
								}
							}
						}

						if (ignoreLineBreak)
						{
							if (previous.indexOf("<br>") != -1)
							{
								previous = StringUtils.replace(previous,"<br>","|LineBreak|");
							}
							else if (previous.indexOf("<BR>") != -1)
							{
								previous = StringUtils.replace(previous,"<BR>","|LineBreak|");
							}

							previous = StringUtils.replace(previous,"<","&lt;");
							previous = StringUtils.replace(previous,">","&gt;");
							if (previous.indexOf("|LineBreak|") != -1)
							{
								previous = StringUtils.replace(previous,"|LineBreak|","<br>");
							}
						}
%>
																	
																	<td <%=colspan%> class="eg_morelight <%=fontStyle%>" style="padding:4px" id="linebottomright">
																	<%=StringUtils.format(previous, wrapLengthInt, ",")%>
																	</td>
<%
					}
				}
				if(isCurrentValueAvailable)
				{
					String currentKey = key.trim();
					if(!isPreviousValueAvailable)
					{
						wrapLengthInt = 60;
					}
					else wrapLengthInt = 35;

					if((current.indexOf(EgConstants.COMMA) != -1 || current.indexOf(EgConstants.EG_COMMA) != -1) && key.indexOf("Date")==-1 && key.indexOf("Database column size")==-1 && multiple_tr_flag && !currentKey.equalsIgnoreCase("New User ID") && !currentKey.equalsIgnoreCase("User ID") && !currentKey.equalsIgnoreCase("User name") && !currentKey.equalsIgnoreCase("Sharing Users") && !currentKey.equalsIgnoreCase("Deleted Users"))
					{
%>
																	<td <%=colspan%> class="eg_morelight" style="padding:0px;border-left-width:0px;">
																		<table width="100%" border='0' cellspacing="0" cellpadding="0">
<%
						String curTokens[] = null;
						//dont change the order of if else if condition
						if(current.indexOf(EgConstants.EG_COMMA) > -1)
						{
							curTokens = StringUtils.getTokens(current,EgConstants.EG_COMMA);
						}
						else if(current.indexOf(EgConstants.COMMA) > -1)
						{
							curTokens = StringUtils.getTokens(current,EgConstants.COMMA);
						}
						if(curTokens == null)
							curTokens = new String[0];
						int count=0;
						if(curTokens != null && curTokens.length>0)
							count=curTokens.length;
						boolean slno = false;
						int slNo = 1;
						if(count>slCount)
							slno = true;
						for(int j=0;j<curTokens.length;j++)
						{
							String temp = curTokens[j];
							if(temp == null || temp.equalsIgnoreCase("null") || temp.trim().length()==0)
								continue;
							temp=databagObj.getMappingStr(temp);
							temp = StringUtils.format(temp, wrapLengthInt, "_");
							if (temp.indexOf("^") != -1)
							{
								if (temp.indexOf("(Group)") != -1 && !currentKey.equalsIgnoreCase("Problem Fixed by"))
								{
									int idx = temp.indexOf("/");
									int nextIdx = temp.indexOf("(Group)");
									String strtempuname = temp.substring(0,idx);
									strtempuname = strtempuname + "/Grp/";
									String strtempuname_A = temp.substring(idx + 1 ,nextIdx);
									temp = strtempuname + strtempuname_A;
									temp = temp.trim();

									String temp_user = iniFile.getValue("DBUSER_USER_MAP",temp.trim());
									if (temp_user != null && temp_user.length() > 0)
									{
										temp = temp_user;
										String grpDelimiter = "/Grp/";
										int idx1 = temp.indexOf(grpDelimiter);
										String str_uname_A = temp.substring(0,idx);
										int nextIdx1 = idx1 + grpDelimiter.length();
										String str_uname_B = temp.substring(nextIdx1);
										temp = str_uname_A + "/" + str_uname_B + " (Group)";
									}
								}
								else
								{
									String temp_user = iniFile.getValue("DBUSER_USER_MAP",temp.trim());
									if (temp_user != null && temp_user.length() > 0)
									{
										temp = temp_user;
									}
								}
							}
							if (ignoreLineBreak)
							{
								if (temp.indexOf("<br>") != -1)
								{
									temp = StringUtils.replace(temp,"<br>","|LineBreak|");
								}
								else if (temp.indexOf("<BR>") != -1)
								{
									temp = StringUtils.replace(temp,"<BR>","|LineBreak|");
								}

								temp = StringUtils.replace(temp,"<","&lt;");
								temp = StringUtils.replace(temp,">","&gt;");
								if (temp.indexOf("|LineBreak|") != -1)
								{
									temp = StringUtils.replace(temp,"|LineBreak|","<br>");
								}
							}
%>
																			<tr>
																				<td align ='left' id="linebottom" class="<%=fontStyle%>" style="padding:4px">
<%
										if(slno)
										{
%>
													<%=slNo%>) <%=temp%>
<%
										}
										else
										{
%>
													<%=temp%>
<%
										}
%>
																				</td>
																			</tr>
<%
										boolean hasMore = (j+1)<curTokens.length;
										for(int i=count; (i<trCount && !hasMore);i++)
										{
%>
																				<tr><td align ='left' id="linebottom" style="padding:4px">&nbsp;</td></tr>
<%
										}
							slNo++;
						}
%>
																		</table>
																	</td>
<%
					}
					else
					{
						if(current.indexOf(EgConstants.EG_COMMA) > -1)
						{
							current = StringUtils.replace(current,EgConstants.EG_COMMA,",");
						}
						current=databagObj.getMappingStr(current);
						if (current.indexOf("^") != -1)
						{
							if (current.indexOf("(Group)") != -1 && !currentKey.equalsIgnoreCase("Problem Fixed by"))
							{
								int idx = current.indexOf("/");
								int nextIdx = current.indexOf("(Group)");
								String strtempuname = current.substring(0,idx);
								strtempuname = strtempuname + "/Grp/";
								String strtempuname_A = current.substring(idx + 1 ,nextIdx);
								current = strtempuname + strtempuname_A;
								current = current.trim();

								String temp_user = iniFile.getValue("DBUSER_USER_MAP",current.trim());
								if (temp_user != null && temp_user.length() > 0)
								{
									current = temp_user;
									String grpDelimiter = "/Grp/";
									int idx1 = current.indexOf(grpDelimiter);
									String str_uname_A = current.substring(0,idx);
									int nextIdx1 = idx1 + grpDelimiter.length();
									String str_uname_B = current.substring(nextIdx1);
									current = str_uname_A + "/" + str_uname_B + " (Group)";
								}
							}
							else
							{
								String temp_user = iniFile.getValue("DBUSER_USER_MAP",current.trim());
								if (temp_user != null && temp_user.length() > 0)
								{
									current = temp_user;
								}
							}
						}

						if (ignoreLineBreak)
						{
							if (current.indexOf("<br>") != -1)
							{
								current = StringUtils.replace(current,"<br>","|LineBreak|");
							}
							else if (current.indexOf("<BR>") != -1)
							{
								current = StringUtils.replace(current,"<BR>","|LineBreak|");
							}

							current = StringUtils.replace(current,"<","&lt;");
							current = StringUtils.replace(current,">","&gt;");
							if (current.indexOf("|LineBreak|") != -1)
							{
								current = StringUtils.replace(current,"|LineBreak|","<br>");
							}
						}
%>
																	<td <%=colspan%> class="eg_morelight <%=fontStyle%>" style="padding:4px" id="linebottom" wrap>
																	<%=StringUtils.format(current, wrapLengthInt, ",")%>
																	
																	</td>
<%
					}
				}
%>
																</tr>
<%
			}	
%>
															</table>
														</td>
													</tr>
													<!-- End here // by ahamed-->
<%
		}
	}// End of while
%>
												</table>
											</td>
										</tr>
<%
}
%>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td>
						<table cellpadding='0' cellspacing='0' border='0' align='center' width = "100%">
							<tr>
								<td>&nbsp; </td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
<%
	if(pdfpage.equals("false"))
	{
%>
<script language="JavaScript">
	printPage();
</script>
</form>
<%
	}
}
else
{
	String label = "admin.auditlog."+category+" AUDITLOG REPORT DETAILS";
%>
<form action='auditlogPrint.jsp'>
	<table align="center" cellspacing="0" cellpadding="0" border="0" width="70%">
		<tr>
			<td height="50">&nbsp;</td>
		</tr>
		<tr>
			<td align="center">
				<table cellpadding='4' cellspacing='0' border='0' align='center' width = "100%" id="linesquare2">
					<tr>
						<td id="eg_subheadbg" colspan="3" align='center' class="<%=fontStyle%>">
							<egui:intnl text="<%=label%>"/>
						</td>
					</tr>
					<tr>
						<td class="cell_border3 <%=fontStyle%>"><egui:intnl text="admin.auditlog.Please provide auditlog report name"/></td>
						<td class="cell_border3" width="10">:</td>
						<td class="cell_border3"><input type="text" name="heading" value="<%=category%> AUDITLOG REPORT DETAILS" style="width: 250px;" maxlength="50"></td>
					</tr>
					<tr>
						<td class="cell_border3" align="center" colspan="3">
							<input type="button" value='<egui:intnl text = "admin.auditlog.SUBMIT "/>' class = "eg_back" style="width: 80px;" onClick="javascript:callPrint()">
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</table>
	<input type='hidden' name='reloaded' value='true'>
</form>
<%
}
%>
</body>
</html>


