<%
/*
	Author			:	James Thomas P.
	Creation Date	:	27th October 2006
	Purpose			:	UI to display/modify values in eg_services.ini file
	Design Changes	:	Jaiwin
*/
%>

<%@ page errorPage = "EgProbs.jsp"%>
<%@ include file = "EgTrackerA.jsp" %>
<%@ taglib prefix = "egui" uri="../WEB-INF/eg-taglib.tld" %> 
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgCrypt" %>
<%@ page import = "com.eg.EgMemInfo"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.egurkha.EgConstants"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<%!
	String subject = "MISC_ARGS";
%>
<jsp:useBean id="transBean" scope="page" class="egurkha.TransactionBean"/> 
<%
	transBean.createFile("eg_services.ini");
%>
<%
	String heartbeatFreq = transBean.getStrValue(subject,"HeartbeatFreq");
	if (StringUtils.isNull(heartbeatFreq))
	{
		heartbeatFreq = EgConstants.BLANK_STRING;
	}
%>

<html>
<head>
<title>Manager Settings</title>
<egui:skin ui="admin"/>

<!-- <link rel="stylesheet" href="eg_styles/eg_adminstyle.css">  -->
<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>
<script language="JavaScript">
function showAlarmCbox()
{
	var thisForm = document.adoptfrm;
	val = thisForm.AlarmEscalationPeriod.value;
	var check = (/^[1-9][0-9]*$/).test(val);
	if(check)
	{
		document.getElementById("ast1").style.display = '';
		document.getElementById("ast2").style.display = '';
	}
	else
	{
		document.getElementById("ast1").style.display = "none";
		document.getElementById("ast2").style.display = "none";
	}
}

function setFrequecy(val)
{
	document.adoptfrm.HeartbeatFreq.value=val;
}
function showHeartBeatList()
{
	var thisForm = document.adoptfrm;
	var freValue = thisForm.HeartbeatFreq.value;
	var check = (/^[1-9][0-9]*$/).test(freValue);
	if(check)
	{
		document.getElementById("heartAlways").style.display='';
		document.getElementById("heartMailID").style.display='';
		document.getElementById("heartMode").style.display='';
	}
	else
	{
		document.getElementById("heartAlways").style.display="none";
		document.getElementById("heartMailID").style.display="none";
		document.getElementById("heartMode").style.display="none";
	}
}

function showMailLogDetails()
{
	var thisForm = document.adoptfrm;
	var isMailLogEnabled = thisForm.maildebug[0].checked;
	if(isMailLogEnabled)
	{
		document.getElementById("maillogsize").style.display = '';
		document.getElementById("maillogfile").style.display = '';
		document.getElementById("maillogprefer").style.display = '';
	}
	else
	{
		document.getElementById("maillogsize").style.display = 'none';
		document.getElementById("maillogfile").style.display = 'none';
		document.getElementById("maillogprefer").style.display = 'none';
	}
}

function showMailAlertsDetails()
{
	var thisForm = document.adoptfrm;
	var isMailAlertEnabled = thisForm.mailalerts[0].checked;
	if(isMailAlertEnabled)
	{
		document.getElementById("mailConfigForNonAdmins").style.display = '';
	}
	else
	{
		document.getElementById("mailConfigForNonAdmins").style.display = 'none';
	}
}

function isNetscape()
{
	// get browser info.
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1); 
	
	// check for Navigator ver 4+. 
	if ((appName == "Netscape") && (appVer >= 4)) return true;
	return false;
}

function isIE()
{
	// get browser info.
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1);

	// check for IE ver 4+.
	if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
	return false;
}

function isValid(val)
{
	if(val.length==0||val.indexOf('0')==0)
	{
		return "false";
	}
	if(parseInt(val)<=0)
	{
		return "false";
	}
}

/* Validation for all the field in the Form */
function validateTextBoxes()
{
	var thisForm = document.adoptfrm;
	var res = "true";
	var val=thisForm.MailHomeUrl.value;
	if(val.length==0)
	{
		alert('<egui:intnl text=" admin.mail.Enter the valid home page URL"/>');
		thisForm.MailHomeUrl.focus();
		res="false";
		return;
	}

	/* validation for MailCheckPeriod*/
	val=thisForm.MailCheckPeriod.value;
	if(isNaN(val))
	{
		alert("' "+val+" '  " + '<egui:intnl text=" admin.mail.is not a valid number"/>');
		thisForm.MailCheckPeriod.focus();
		res="false";
		return;
	}
	if(isValid(val))
	{
		alert("<egui:intnl text='admin.mail.\'Maximum time between email alert checks\' should be a valid positive integer'/>");
		thisForm.MailCheckPeriod.focus();
		res="false";
		return;
	}

	/* validation for MailRcvPort*/
	val=thisForm.MailRcvPort.value;
	if(isNaN(val))
	{
		alert("' "+val+" '  " + '<egui:intnl text=" admin.mail.is not a valid number"/>');
		thisForm.MailRcvPort.focus();
		res="false";
		return;
	}
	if(isValid(val))
	{
		alert("<egui:intnl text='admin.mail.\'Port used for receiving mails\' should be a valid positive integer'/>");
		thisForm.MailRcvPort.focus();
		res="false";
		return;
	}
	
	if(!validateSingleByte(thisForm.MailReceiver.value))
	{
		alert('<egui:intnl text="admin.mail.Mail receiver ID is not allowed in DBL(Chinese,Korean,Japanese)"/>');
		thisForm.MailReceiver.focus();
		res="false";
		return;
	}
	if(!validateSingleByte(thisForm.MailRcvProtocol.value))
	{
		alert('<egui:intnl text="admin.mail.Protocol for receiving mails is not allowed in DBL(Chinese,Korean,Japanese)"/>');
		thisForm.MailRcvProtocol.focus();
		res="false";
		return;
	}
	/*if (!checkmultiplemailid(thisForm.MailRcvServer))
	{
		alert('<egui:intnl text="admin.mail.Please enter a valid receiving mail ID"/>');
		thisForm.MailRcvServer.focus();
		res="false";
		return;
	}*/
	if(!validateSingleByte(thisForm.MailRcvServer.value))
	{
		alert('<egui:intnl text="admin.mail.Server for receiving mails is not allowed in DBL(Chinese,Korean,Japanese)"/>');
		thisForm.MailRcvServer.focus();
		res="false";
		return;
	}
	/* validation for HeartbeatFreq*/
	val = thisForm.HeartbeatFreq.value;
	if(val.length!=0)
	{
		if(isNaN(val))
		{
			alert("' "+val+" '  " + '<egui:intnl text=" admin.mail.is not a valid number"/>');
			thisForm.HeartbeatFreq.focus();
			res="false";
			return;
		}
		if(isValid(val)=="false")
		{
			alert("<egui:intnl text='admin.mail.\'Heartbeat mail frequency\' should be a valid positive integer'/>");
			thisForm.HeartbeatFreq.focus();
			res="false";
			return;
		}
		if(val.indexOf(".")>-1)
		{
			alert("<egui:intnl text='admin.mail.\'Heartbeat mail frequency\' should be a valid positive whole number'/>");
			thisForm.HeartbeatFreq.focus();
			res="false";
			return;
		}
		val=val*60;
		if(!(val>=thisForm.MailCheckPeriod.value))
		{
			alert("<egui:intnl text='admin.mail.\'Heartbeat mail frequency\' should be greater than or equal to \'Maximum time between email alert checks\''/>");
			thisForm.HeartbeatFreq.focus();
			res="false";
			return;
		}
		email=thisForm.HeartbeatTo.value;
		var regExp=/([a-zA-Z0-9]+[\_\.\-]?)*[a-zA-Z0-9]\@[a-zA-Z0-9]+\.(([a-zA-z0-9]{3}\.[a-zA-z0-9]{2})|([a-zA-z0-9]{3})|([a-zA-z0-9]{2}\.[a-zA-z0-9]{2})|([a-zA-z0-9]{2}))/g;
		result=email.match(regExp);
		if(result==null||result!=email)
		{
			alert("<egui:intnl text='admin.mail.Enter valid mail IDs for \'Send heartbeats To\''/>");
			thisForm.HeartbeatTo.focus();
			res="false";
			return;
		}
	}
	else
	{
		thisForm.HeartbeatAlways[1].checked=true;
		thisForm.HeartbeatTo.value="";
		thisForm.HeartbeatMailMode[1].checked=true;
	}

	/* validation for Mail Log Details */
	var isMailLogEnabled = thisForm.maildebug[0].checked
	if(isMailLogEnabled)
	{
		var size = thisForm.LogMaxSize.value;
		if (size == null || size == "")
		{
			alert("<egui:intnl text='admin.mail.Enter the value for \' Maximum size of log file \''/>");
			thisForm.LogMaxSize.focus();
			res = "false";
			return;
		}
		var regExp = /^[0-9.]+$/;
		if(!regExp.test(size))
		{
			alert('<egui:intnl text="admin.mail.Maximum size of log file should be a numeric value"/>');
			thisForm.LogMaxSize.focus();
			res = "false";
			return;
		}

		var file = thisForm.LogMaxFile.value;
		if (file == null || file == "")
		{
			alert("<egui:intnl text='admin.mail.Enter the value for \' Maximum number of log files \''/>");
			thisForm.LogMaxFile.focus();
			res = "false";
			return;
		}
		regExp = /^[0-9]+$/;
		if(!regExp.test(file))
		{
			alert('<egui:intnl text="admin.mail.Maximum number of log files should be an integer"/>');
			thisForm.LogMaxFile.focus();
			res = "false";
			return;
		}
	}

	/* validation for AlarmEscalationPeriod*/
	val = thisForm.AlarmEscalationPeriod.value;
	if(val.length!=0)
	{
		if(isNaN(val))
		{
			alert("' "+val+" '  " + '<egui:intnl text=" admin.mail.is not a valid number"/>');
			thisForm.AlarmEscalationPeriod.focus();
			res="false";
			return;
		}
		if(isValid(val)=="false")
		{
			alert("<egui:intnl text='admin.mail.\'Escalate alarms after\' should be a valid positive integer'/>");
			thisForm.AlarmEscalationPeriod.focus();
			res="false";
			return;
		}
		if(val.indexOf(".")>-1)
		{
			alert("<egui:intnl text='admin.mail.\'Escalate alarms after\' should be a valid positive whole number'/>");
			thisForm.AlarmEscalationPeriod.focus();
			res="false";
			return;
		}
		val=val*60;
		if(!(val>=thisForm.MailCheckPeriod.value))
		{
			alert("<egui:intnl text='admin.mail.\'Escalate alarms after\' should be greater than or equal to \'Maximum time between email alert checks\''/>");
			thisForm.AlarmEscalationPeriod.focus();
			res="false";
			return;
		}
		var countin=0;
		for(i=0;i<thisForm.AlarmEscalationType.length;i++)
		{
			if(thisForm.AlarmEscalationType.options[i].selected==true)
			{
				countin=1;
				break;
			}
		}
		if(countin==0)
		{
			alert('<egui:intnl text="admin.mail.Atleast one alarm priority should be selected"/>');
			thisForm.AlarmEscalationType.focus();
			res="false";
			return;
		}
	}
	else
	{
		for(i=0;i<thisForm.AlarmEscalationType.length;i++)
		{
			thisForm.AlarmEscalationType.options[i].selected=true;
		}
	}

	if(res=="true")
	{
		setSelectAlarmEscalationType();
	}
}

function selectAlarmEscalationType(types)
{
	var alarms=new Array();
	var thisForm = document.adoptfrm;
	alarms[0]= "High";
	alarms[1]= "Medium";
	alarms[2]= "Low";
	
	thisForm.$_AlarmEscalationType.value = "Escalate alarms of these priorities$"+types;
	for(i=0;i<thisForm.AlarmEscalationType.length;i++)
	{
		if(types.indexOf(alarms[i])>=0)
		{
			thisForm.AlarmEscalationType.options[i].selected=true;
		}
	}
	if(types=='')
		thisForm.AlarmEscalationType.options[0].selected=true;

}

function setSelectAlarmEscalationType()
{
	var thisForm = document.adoptfrm;
	var escalationTypes = "";
	for(i=0;i<3;i++)
	{
		if(thisForm.AlarmEscalationType.options[i].selected==true)
		{
		escalationTypes+=thisForm.AlarmEscalationType.options[i].value+",";
		}
	}
	if(escalationTypes.length>0)
		escalationTypes=escalationTypes.substr(0,escalationTypes.length-1);
	if(escalationTypes.length>0)
	{
		thisForm.selectedAlarms.value=escalationTypes;
		thisForm.submit();
	}
	else
	{
		thisForm.selectedAlarms.value='';
		thisForm.submit();
	}
}

function shiftsDisplay()
{
	if(document.adoptfrm.shiftPeriodConfig[1].checked)
	{
		document.getElementById('dayshiftcombination1').style.visibility = 'hidden';
		document.getElementById('dayshiftcombination1').style.display = 'none';
		document.getElementById('dayshiftcombination2').style.visibility = 'hidden';
		document.getElementById('dayshiftcombination2').style.display = 'none';
	}
	else
	{
		document.getElementById('dayshiftcombination1').style.visibility = 'visible';
		document.getElementById('dayshiftcombination2').style.visibility = 'visible';
		if (isNetscape())
		{
			document.getElementById('dayshiftcombination1').style.display = 'table-row';
			document.getElementById('dayshiftcombination2').style.display = 'table-row';
		}
		else if (isIE())
		{
			document.getElementById('dayshiftcombination1').style.display = 'block';
			document.getElementById('dayshiftcombination2').style.display = 'block';
		}
	}
}

function selectDayShiftCombination(shift)
{
	if(document.adoptfrm.shiftPeriodConfig[0].checked)
	{
		var thisForm = document.adoptfrm;
		for(var j=1;j<=thisForm.MaximumShifts.length;j++)
		{
			if(shift == j)
			{
				thisForm.MaximumShifts.options[shift-1].selected = true;
				break;
			}
		}
	}
}
</script>
</head>
<!-- <body leftmargin="0" topmargin="20" marginwidth="0" marginheight="20" bgcolor="#FFFFFF"> -->
<body scroll="auto" id="space6">
<form name="adoptfrm" method="POST" action="advancedOptionsp.jsp" style="margin:0px">
<input type='hidden' name='$_AlarmEscalationType' value="">
<!-- HEADER STARTS HERE -->
<table border="0" align="center" cellspacing="0" cellpadding="0" width="100%" >
	<jsp:include page="listSearch.jsp?title=MAIL SERVER - ADVANCED OPTONS&leftString=Add User&backButton=true&subtitle=false"/>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top" >		
			<table align="center" cellspacing="0" cellpadding="2" width="85%" border="0">
				<!-- <tr>
					<td align="center" height="10">&nbsp;</td>
				</tr> -->
				<tr>
					<td align="center">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="eg_subcontentbg" style="table-layout:fixed"><col width="10"><col width="300"><col width="20"><col width="400"><col width="7">
							<tr>
								<td colspan="5">
									<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
										<tr>
											<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
											<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%"><strong><egui:intnl text="admin.mail.Mail Alert Configuration"/></strong></td>
											<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
										</tr>
									</table>
								</td>
							</tr>
							<!-- <tr>
								<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td height="6" id="eg_subcontentbg" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
								<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr> -->
<%
	String mailHomeUrl = transBean.getStrValue(subject,"MailHomeUrl");
	if (StringUtils.isNull(mailHomeUrl))
	{
		mailHomeUrl = EgConstants.BLANK_STRING;
	}
%>
							<tr>
								<th width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></th>
								<td class="form_border" nowrap  id="paddingleft" nowrap ><egui:intnl text="admin.mail.Home page URL in mail messages"/></td>
								<td class="form_border" nowrap >:</td>
								<td class="form_border" nowrap><input type='text' name='MailHomeUrl'  value="<%=mailHomeUrl%>" maxlength="256" style="width: 300px;"></td>
								<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<input type='hidden' name='$_MailHomeUrl' value='Home page URL in mail messages$<%=mailHomeUrl%>'>
							<!-- <tr>
								<td nowrap colspan="3" height="10" id="eg_blankspace">&nbsp;</td>
							</tr> -->
<%
	String mailCheckPeriod = transBean.getStrValue(subject,"MailCheckPeriod");
	if (StringUtils.isNull(mailCheckPeriod))
	{
		mailCheckPeriod = EgConstants.BLANK_STRING;
	}
%>
							<tr>
								<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td class="form_border" nowrap id="paddingleft" nowrap ><egui:intnl text="admin.mail.Maximum time between email alert checks (secs)"/></td>
								<td class="form_border" nowrap >:</td>
								<td class="form_border" nowrap><input type='text' name='MailCheckPeriod'  value="<%=mailCheckPeriod%>" maxlength="256" style="width: 300px;" onChange="javascript:"></td>
								<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<input type='hidden' name='$_MailCheckPeriod' value='Maximum time between email alert checks (secs)$<%=mailCheckPeriod%>'>
							<!-- <tr>
								<td nowrap colspan="3" height="10" id="eg_blankspace">&nbsp;</td>
							</tr> -->
							<tr>
								<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td class="form_border" nowrap id="paddingleft"><egui:intnl text="admin.mail.Allow monitor users to edit their mail IDs"/></td>
								<td class="form_border" nowrap > :</td>
								<td class="form_border" nowrap>
<%
	String editMailId = transBean.getStrValue(subject,"EditMailId");
%>
									<table  width="30%" border="0" cellspacing="0" cellpadding="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="10">
												<input type="radio"class="eg_input" name="EditMailId" value="Yes" <%=editMailId.equalsIgnoreCase("Yes") ? "checked":""%>>
											</td>
											<td><egui:intnl text="admin.common.Yes"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="10">
												<input type="radio"class="eg_input" name="EditMailId" value="No" <%=editMailId.equalsIgnoreCase("No") ? "checked":""%>>
											</td>
											<td><egui:intnl text="admin.common.No"/></td>
										</tr>
									</table>
								</td>
								<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<input type='hidden' name='$_EditMailId' value='Allow monitor users to edit mail IDs$<%=editMailId.equalsIgnoreCase("Yes") ? "Yes":"No"%>'>
							<!-- <tr>
								<td nowrap colspan="3" height="10" id="eg_blankspace">&nbsp;</td>
							</tr> -->
							<tr>
								<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td class="form_border"id="paddingleft" nowrap ><egui:intnl text="admin.mail.Alert if an agent is not running"/></td>
								<td class="form_border" nowrap >:</td>
								<td class="form_border" nowrap>
<%
	String alertAgentsNotRunning = transBean.getStrValue(subject,"AlertAgentsNotRunning");
%>
									<table  width="30%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="10" align="left">
												<input type="radio"class="eg_input" name="AlertAgentsNotRunning" value="Yes" <%=alertAgentsNotRunning.equalsIgnoreCase("Yes") ? "checked":""%>>
											</td>
											<td><egui:intnl text="admin.common.Yes"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="10">
												<input type="radio"class="eg_input" name="AlertAgentsNotRunning" value="No" <%=alertAgentsNotRunning.equalsIgnoreCase("No") ? "checked":""%>>
											</td>
											<td><egui:intnl text="admin.common.No"/></td>
										</tr>
									</table>
								</td>
								<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<input type='hidden' name='$_AlertAgentsNotRunning' value='Alert if agent is not running$<%=alertAgentsNotRunning.equalsIgnoreCase("Yes") ? "Yes":"No"%>'>
							<!-- <tr>
								<td nowrap colspan="3" height="10" id="eg_blankspace">&nbsp;</td>
							</tr> -->
							<tr>
								<td width="7" class="eg_subcontentbg" id="form_spacing"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td class="form_spacing" id="paddingleft" nowrap ><egui:intnl text="admin.mail.Show last measure value in alerts"/></td>
								<td  class="form_spacing" nowrap >:</td>
								<td  class="form_spacing" nowrap>
<%
	String mailLastValue = transBean.getStrValue(subject,"MailLastValue");
%>
									<table  width="30%" cellspacing="0" cellpadding="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="10">
												<input type="radio"class="eg_input" name="MailLastValue" value="Yes" <%=mailLastValue.equalsIgnoreCase("Yes") ? "checked":""%>>
											</td>
											<td><egui:intnl text="admin.common.Yes"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="10">
												<input type="radio"class="eg_input" name="MailLastValue" value="No" <%=mailLastValue.equalsIgnoreCase("No") ? "checked":""%>>
											</td>
											<td><egui:intnl text="admin.common.No"/></td>
										</tr>
									</table>
								</td>
								<td width="7" class="eg_subcontentbg" id="form_spacing"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<input type='hidden' name='$_MailLastValue' value='Show last measure value in alerts$<%=mailLastValue.equalsIgnoreCase("Yes") ? "Yes":"No"%>'>
							<!-- <tr>
								<td nowrap colspan="3" height="10" id="eg_blankspace">&nbsp;</td>
							</tr> -->
							<tr>
								<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  width="100%"  valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
							<!-- <tr>
								<td nowrap colspan="3" height="10" id="eg_blankspace">&nbsp;</td>
							</tr> -->
						</table>
					</td>
				</tr>
			</table>
			<br>
			<table align="center" cellspacing="0" cellpadding="2" width="85%" border="0">
				<!-- <tr>
					<td align="left" id="eg_title">Mail Receiver Information</td>
				</tr> -->
				<!-- <tr>
					<td align="center" height="10">&nbsp;</td>
				</tr> -->
				<tr>
					<td align="center">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="eg_subcontentbg" style="table-layout:fixed"><col width="10"><col width="300"><col width="20"><col width="400"><col width="7">
							<tr>
								<td colspan="5">
									<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
										<tr>
											<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
											<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%"><strong><egui:intnl text="admin.mail.Mail Receiver Information"/></strong></td>
											<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
										</tr>
									</table>
								</td>
							</tr>
							<!-- <tr>
								<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td height="6" id="eg_subcontentbg" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
								<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr> -->
<%
	String mailReceiver = transBean.getStrValue(subject,"MailReceiver");
	if (StringUtils.isNull(mailReceiver))
	{
		mailReceiver = EgConstants.BLANK_STRING;
	}
%>
							<tr>
								<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td class="form_border" id="paddingleft" nowrap><egui:intnl text="admin.mail.Mail receiver ID"/></td>
								<td class="form_border" nowrap >:</td>
								<td class="form_border" nowrap><input type='text' name='MailReceiver'  value="<%=mailReceiver%>" maxlength="256" style="width: 300px;"></td>
								<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<input type='hidden' name='$_MailReceiver' value='Mail receiver ID$<%=mailReceiver%>'>
							<!-- <tr>
								<td nowrap colspan="3" height="10" id="eg_blankspace">&nbsp;</td>
							</tr> -->
<%
	String mailReceiverPasswd = transBean.getStrValue(subject,"MailReceiverPasswd");
	if (StringUtils.isNull(mailReceiverPasswd))
	{
		mailReceiverPasswd = EgConstants.BLANK_STRING;
	}
%>
							<tr>
								<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td class="form_border" id="paddingleft" nowrap><egui:intnl text="admin.mail.Mail receiver password"/></td>
								<td class="form_border" nowrap width="20"> :</td>
								<td class="form_border" nowrap><input type='password' name='MailReceiverPasswd'  value="<%=mailReceiverPasswd%>" maxlength="256" style="width: 300px;"></td>
								<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<input type='hidden' name='$_MailReceiverPasswd' value='Mail receiver password$<%=mailReceiverPasswd%>'>
							<!-- <tr>
								<td nowrap colspan="3" height="10" id="eg_blankspace">&nbsp;</td>
							</tr> -->
<%
	String mailRcvPort = transBean.getStrValue(subject,"MailRcvPort");
	if (StringUtils.isNull(mailRcvPort))
	{
		mailRcvPort = EgConstants.BLANK_STRING;
	}
%>
							<tr>
								<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td class="form_border" id="paddingleft" nowrap><egui:intnl text="admin.mail.Port used for receiving mails"/></td>
								<td class="form_border" nowrap >:</td>
								<td class="form_border" nowrap><input type='text' name='MailRcvPort'  value="<%=mailRcvPort%>" maxlength="256" style="width: 300px;"></td>
								<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<input type='hidden' name='$_MailRcvPort' value='Port used for receiving mails$<%=mailRcvPort%>'>
							<!-- <tr>
								<td nowrap colspan="3" height="10" id="eg_blankspace">&nbsp;</td>
							</tr> -->
<%
	String mailRcvProtocol = transBean.getStrValue(subject,"MailRcvProtocol");
	if (StringUtils.isNull(mailRcvProtocol))
	{
		mailRcvProtocol = EgConstants.BLANK_STRING;
	}
%>
							<tr>
								<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td class="form_border" id="paddingleft" nowrap><egui:intnl text="admin.mail.Protocol for receiving mails"/></td>
								<td class="form_border" nowrap >:</td>
								<td class="form_border" nowrap><input type='text' name='MailRcvProtocol'  value="<%=mailRcvProtocol%>" maxlength="256" style="width: 300px;"></td>
								<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<input type='hidden' name='$_MailRcvProtocol' value='Protocol for receiving mails$<%=mailRcvProtocol%>'>
							<!-- <tr>
								<td nowrap colspan="3" height="10" id="eg_blankspace">&nbsp;</td>
							</tr> -->
<%
	String mailRcvServer = transBean.getStrValue(subject,"MailRcvServer");
	if (StringUtils.isNull(mailRcvServer))
	{
		mailRcvServer = EgConstants.BLANK_STRING;
	}
%>
							<tr>
								<td width="7" class="eg_subcontentbg" id="form_spacing"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td class="form_spacing" id="paddingleft" nowrap><egui:intnl text="admin.mail.Server for receiving mails"/></td>
								<td class="form_spacing" nowrap >:</td>
								<td class="form_spacing" nowrap><input type='text' name='MailRcvServer'  value="<%=mailRcvServer%>" maxlength="256" style="width: 300px;"></td>
								<td width="7" class="eg_subcontentbg" id="form_spacing"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<input type='hidden' name='$_MailRcvServer' value='Server for receiving mails$<%=mailRcvServer%>'>
							<tr>
								<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
							<!-- <tr>
								<td nowrap colspan="3" height="10" id="eg_blankspace">&nbsp;</td>
							</tr> -->
						</table>
					</td>
				</tr>
			</table>
			<br>
			<table align="center" cellspacing="0" cellpadding="2" width="85%" border="0">
				<tr>
					<td align="center">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="eg_subcontentbg" style="table-layout:fixed"><col width="10"><col width="300"><col width="20"><col width="400"><col width="7">
							<tr>
								<td colspan="5">
									<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
										<tr>
											<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
											<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%"><strong><egui:intnl text="admin.mail.Heartbeat"/></strong></td>
											<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<th width="7" class="eg_subcontentbg" id="form_border" style="border-bottom-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></th>
								<td class="form_border" id="paddingleft"  nowrap style="border-bottom-width:0px" ><egui:intnl text="admin.mail.Heartbeat mail frequency (mins)"/></td>
								<td class="form_border" nowrap style="border-bottom-width:0px" >:</td>
								<td class="form_border" nowrap style="border-bottom-width:0px"><input type='text' name='HeartbeatFreq'  value="<%=heartbeatFreq%>" maxlength="256" style="width: 300px;" onkeyup="javascript:showHeartBeatList()" ></td>
								<td width="7" class="eg_subcontentbg" id="form_border" style="border-bottom-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<input type='hidden' name='$_HeartbeatFreq' value='Heartbeat mail frequency (mins)$<%=heartbeatFreq%>'>
							<tr id="heartAlways" style="display:none">
								<td width="7" class="eg_subcontentbg" id="form_border" style="border-top-width:1px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td class="form_border" id="paddingleft" nowrap valign="top" style="border-top-width:1px"><egui:intnl text="admin.mail.Always send heartbeats"/></td>
								<td class="form_border" nowrap style="border-top-width:1px">:</td>
								<td class="form_border" nowrap style="border-top-width:1px">
<%
	String heartbeatAlways = transBean.getStrValue(subject,"HeartbeatAlways");
	if(StringUtils.isNull(heartbeatAlways))
	{
		heartbeatAlways="false";
	}
%>
								<table  width="30%" cellspacing="0" cellpadding="0">
									<tr>
										<td id="eg_subcontentbg" class="eg_subcontent"  width="10">
										<input type="radio" class="eg_input" name="HeartbeatAlways" value="True" <%=heartbeatAlways.equalsIgnoreCase("True") ? "checked":""%>></td>
										<td ><egui:intnl text="admin.common.Yes"/></td>
										<td id="eg_subcontentbg" class="eg_subcontent" width="10" ><input type="radio"class="eg_input" name="HeartbeatAlways" value="False" <%=heartbeatAlways.equalsIgnoreCase("False") ? "checked":""%>></td>
										<td ><egui:intnl text="admin.common.No"/></td>
									</tr>
								</table></td>
								<td width="7" class="eg_subcontentbg" id="form_border" style="border-top-width:1px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
<%
	if(heartbeatAlways.equalsIgnoreCase("True"))
	{
%>
	<input type='hidden' name='$_HeartbeatAlways' value='Always send heartbeats$True'>
<%
	}

	if(heartbeatAlways.equalsIgnoreCase("False"))
	{
%>
	<input type='hidden' name='$_HeartbeatAlways' value='Always send heartbeats$False'>
<%
	}
%>
							<!-- <tr>
								<td nowrap colspan="3" height="10" id="eg_blankspace">&nbsp;</td>
							</tr> -->
<%
	String heartbeatTo = transBean.getStrValue(subject,"HeartbeatTo");
	if (StringUtils.isNull(heartbeatTo))
	{
		heartbeatTo = EgConstants.BLANK_STRING;
	}
%>
							<tr id="heartMailID" style="display:none"><!--MAIL ID-->
								<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6" ></td>
								<td class="form_border" id="paddingleft" nowrap><egui:intnl text="admin.mail.Send heartbeats to"/></td>
								<td class="form_border" nowrap>:</td>
								<td class="form_border" nowrap><input type='text' name='HeartbeatTo'  value="<%=heartbeatTo%>" maxlength="256" style="width: 300px;"></td>
								<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<input type='hidden' name='$_HeartbeatTo' value='Send heartbeats to$<%=heartbeatTo%>'>
							<!-- <tr>
								<td nowrap colspan="3" height="10" id="eg_blankspace">&nbsp;</td>
							</tr> -->
<%
	String heartbeatMailMode = transBean.getStrValue(subject,"HeartbeatMailMode");
	if (StringUtils.isNull(heartbeatMailMode))
	{
		heartbeatMailMode = "html";
	}
%>
							<tr id="heartMode" style="display:none">
								<td width="7" class="eg_subcontentbg" id="form_spacing"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td class="form_spacing"  id="paddingleft" nowrap><egui:intnl text="admin.mail.Mode of heartbeat mails"/></td>
								<td class="form_spacing"  nowrap >:</td>
								<td class="form_spacing"  nowrap>
								<table  width="30%" cellspacing="0" cellpadding="0">
									<tr>
										<td id="eg_subcontentbg" class="eg_subcontent"  width="10">
										<input type="radio" class="eg_input" name="HeartbeatMailMode" value="Text" <%=heartbeatMailMode.equalsIgnoreCase("Text") ? "checked":""%>> </td>
										<td width="52"><egui:intnl text="admin.mail.Text"/></td>
										<td id="eg_subcontentbg" class="eg_subcontent"  width="10"> <input type="radio" class="eg_input" name="HeartbeatMailMode" value="Html" <%=heartbeatMailMode.equalsIgnoreCase("Html") ? "checked":""%>></td>
										<td><egui:intnl text="admin.mail.Html"/></td>
									</tr>
								</table>
								<td width="7" class="eg_subcontentbg" id="form_spacing"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
<%
	if(heartbeatMailMode.equalsIgnoreCase("Text"))
	{
%>
	<input type='hidden' name='$_HeartbeatMailMode' value='Mode of heartbeat mails$Text'>
<%
	}

	if(heartbeatMailMode.equalsIgnoreCase("Html"))
	{
%>
	<input type='hidden' name='$_HeartbeatMailMode' value='Mode of heartbeat mails$Html'>
<%
	}
%>
							<script language="Javascript">
							setFrequecy('<%=heartbeatFreq%>');
							showHeartBeatList();
							</script>
							<tr>
								<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  width="100%"  valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
							<!-- <tr>
								<td nowrap colspan="3" height="10" id="eg_blankspace">&nbsp;</td>
							</tr> -->
						</table>
					</td>
				</tr>
			</table>
			<br>
			<table align="center" cellspacing="0" cellpadding="2" width="85%" border="0" >
				<tr>
					<td align="center">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="eg_subcontentbg" style="table-layout:fixed"><col width="10"><col width="300"><col width="20"><col width="400"><col width="7">
							
							<tr>
								<td colspan="5">
									<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
										<tr>
											<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
											<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%"><strong><egui:intnl text="admin.mail.Alarm Escalation"/></strong></td>
											<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
<%
	String alarmEscalationPeriod = transBean.getStrValue(subject,"AlarmEscalationPeriod");
	if (StringUtils.isNull(alarmEscalationPeriod))
	{
		alarmEscalationPeriod = EgConstants.BLANK_STRING;
	}
	if (alarmEscalationPeriod.length() > 0)
		alarmEscalationPeriod = String.valueOf(Long.parseLong(alarmEscalationPeriod)/60);
%>
								<th width="7" class="eg_subcontentbg" id="form_border" style="border-bottom-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></th>
								<td class="form_border" id="paddingleft"  nowrap style="border-bottom-width:0px"><egui:intnl text="admin.mail.Escalate alarms after (mins)"/></td>
								<td class="form_border"  nowrap  style="border-bottom-width:0px"> :</td>
								<td class="form_border"  nowrap style="border-bottom-width:0px"><input type='text' name='AlarmEscalationPeriod'  value="<%=alarmEscalationPeriod%>" maxlength="256" style="width: 300px;" onkeyup="showAlarmCbox();"></td>
								<td width="7" class="eg_subcontentbg" id="form_border" style="border-bottom-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<input type='hidden' name='$_AlarmEscalationPeriod' value='Escalate alarms after (mins)$<%=alarmEscalationPeriod%>'>
							<!-- <tr>
								<td nowrap colspan="3" height="10" id="eg_blankspace">&nbsp;</td>
							</tr> -->
<%
	String alarmEscalationType = transBean.getStrValue(subject,"AlarmEscalationType");					
	if (StringUtils.isNull(alarmEscalationType))
	{
		alarmEscalationType ="High,Medium,Low";
	}
%>
							<tr id="ast1" style="display:'';">
								<td width="7" class="eg_subcontentbg" id="form_border" style="border-top-width:1px;border-bottom-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td class="form_border" id="paddingleft" nowrap valign="top" style="border-top-width:1px;border-bottom-width:0px"><egui:intnl text="admin.mail.Escalate alarms of these priorities"/></td>
								<td class="form_border"  nowrap valign="top" style="border-top-width:1px;border-bottom-width:0px">:</td>
								<td class="form_border"  nowrap style="border-top-width:1px;border-bottom-width:0px">
									<select id="ast2" name="AlarmEscalationType" multiple size="3"> 
										<option value='High' <%=alarmEscalationType.indexOf("High")!=-1?"selected":""%>><egui:intnl text="admin.common.Critical"/></option>
										<option value="Medium" <%=alarmEscalationType.indexOf("Medium")!=-1?"selected":""%>><egui:intnl text="admin.common.Major"/></option>
										<option value="Low" <%=alarmEscalationType.indexOf("Low")!=-1?"selected":""%>><egui:intnl text="admin.common.Minor"/></option>
									</select>
								</td>
								<td width="7" class="eg_subcontentbg" id="form_border" style="border-top-width:1px;border-bottom-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<script language="JavaScript">
								selectAlarmEscalationType('<%=alarmEscalationType%>');
								showAlarmCbox();
							</script>
							<tr>
								<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
							<!-- <tr>
								<td nowrap colspan="3" height="10" id="eg_blankspace">&nbsp;</td>
							</tr> -->
						</table>
					</td>
				</tr>
			</table>
			<br>
<%
	String shiftPeriodConfig = transBean.getStrValue(subject,"ShiftPeriodsEnabled");
	String maximumShifts = transBean.getStrValue(subject,"NoOfShiftPeriods");
%>
			<table align="center" cellspacing="0" cellpadding="2" width="85%" border="0">
				<tr>
					<td align="center">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="eg_subcontentbg" style="table-layout:fixed"><col width="10"><col width="300"><col width="20"><col width="400"><col width="7">
							<tr>
								<td colspan="5">
									<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
										<tr>
											<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
											<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%"><strong><egui:intnl text="admin.mail.Shift Periods Configuration"/></strong></td>
											<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td width="7" class="eg_subcontentbg" id="form_border"style="border-bottom-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td class="form_border" nowrap id="paddingleft"style="border-bottom-width:0px"><egui:intnl text="admin.mail.Allow shift period configuration"/></td>
								<td class="form_border" nowrap style="border-bottom-width:0px"> :</td>
								<td class="form_border" nowrap style="border-bottom-width:0px">
									<table width="30%" border="0" cellspacing="0" cellpadding="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="10">
												<input type="radio"class="eg_input" name="shiftPeriodConfig" value="Yes" <%=shiftPeriodConfig.equalsIgnoreCase("true") ? "checked":""%> onclick="javascript:shiftsDisplay()">
											</td>
											<td><egui:intnl text="admin.common.Yes"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="10">
												<input type="radio"class="eg_input" name="shiftPeriodConfig" value="No" <%=shiftPeriodConfig.equalsIgnoreCase("false") ? "checked":""%> onclick="javascript:shiftsDisplay()">
											</td>
											<td><egui:intnl text="admin.common.No"/></td>
										</tr>
									</table>
								</td>
								<td width="7" class="eg_subcontentbg" id="form_border"style="border-bottom-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<input type='hidden' name='$_shiftPeriodConfig' value='Allow shift period configuration$<%=shiftPeriodConfig.equalsIgnoreCase("true") ? "Yes":"No"%>'>
							<tr id="dayshiftcombination1">
								<td width="7" class="eg_subcontentbg" id="form_border" style="border-top-width:1px;border-bottom-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td class="form_border" nowrap id="paddingleft" style="border-top-width:1px;border-bottom-width:0px"><egui:intnl text="admin.mail.Maximum number of day-shift combinations"/></td>
								<td class="form_border" nowrap  style="border-top-width:1px;border-bottom-width:0px"> :</td>
								<td class="form_border" nowrap style="border-top-width:1px;border-bottom-width:0px">
									<select name="MaximumShifts" id="dayshiftcombination2">
										<option value ="1" <%=maximumShifts.equalsIgnoreCase("1") ? "selected":""%>>1</option>
										<option value ="2" <%=maximumShifts.equalsIgnoreCase("2") ? "selected":""%>>2</option>
										<option value ="3" <%=maximumShifts.equalsIgnoreCase("3") ? "selected":""%>>3</option>
										<option value ="4" <%=maximumShifts.equalsIgnoreCase("4") ? "selected":""%>>4</option>
										<option value ="5" <%=maximumShifts.equalsIgnoreCase("5") ? "selected":""%>>5</option>
										<option value ="6" <%=maximumShifts.equalsIgnoreCase("6") ? "selected":""%>>6</option>
										<option value ="7" <%=maximumShifts.equalsIgnoreCase("7") ? "selected":""%>>7</option>
										<option value ="8" <%=maximumShifts.equalsIgnoreCase("8") ? "selected":""%>>8</option>
										<option value ="9" <%=maximumShifts.equalsIgnoreCase("9") ? "selected":""%>>9</option>
										<option value ="10" <%=maximumShifts.equalsIgnoreCase("10") ? "selected":""%>>10</option>
									</select>
									<script language="JavaScript">
										selectDayShiftCombination('<%=maximumShifts%>');
										shiftsDisplay();
									</script>
								</td>
								<td width="7" class="eg_subcontentbg" id="form_border" style="border-top-width:1px;border-bottom-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<input type='hidden' name='$_MaximumShifts' value='Maximum number of day-shift combinations$<%=maximumShifts%>'>
							<tr>
								<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
			<br>
<%
	String mailLogDebug = transBean.getStrValue(subject,"MailManagerDebug");

	String mailLogDebugEnabled = "";
	String mailLogDebugDisabled = "";

	if(mailLogDebug == null || mailLogDebug.length() == 0)
	{
		mailLogDebug = "No";
	}
	if(mailLogDebug.equalsIgnoreCase("true") || mailLogDebug.equalsIgnoreCase("yes"))
	{
		mailLogDebugEnabled = "checked";
	}
	else
	{
		mailLogDebugDisabled = "checked";
	}

	String mailLogMaxSize = transBean.getStrValue(subject,"MailmanagerLogMaxRollSize");
	if(mailLogMaxSize == null || mailLogMaxSize.length() == 0)
	{
		mailLogMaxSize = "";
	}
	String mailLogMaxRollFile = transBean.getStrValue(subject,"Mailmanager_log_max_files");
	if(mailLogMaxRollFile == null || mailLogMaxRollFile.length() == 0)
	{
		mailLogMaxRollFile = "";
	}

	String logPreference = transBean.getStrValue(subject,"MailManagerLogPreference");
	if(logPreference == null || logPreference.length() == 0)
	{
		logPreference = "cname,ctype,layer,test";
	}
	StringTokenizer strToken = new StringTokenizer(logPreference,",");
	ArrayList aListToken = new ArrayList();
	while(strToken.hasMoreTokens())
	{
		String tok = strToken.nextToken();
		aListToken.add(tok.toLowerCase());
	}
%>
			<table align="center" cellspacing="0" cellpadding="2" width="85%" border="0">
				<tr>
					<td align="center">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="eg_subcontentbg" style="table-layout:fixed"><col width="10"><col width="300"><col width="20"><col width="400"><col width="7">
							<tr>
								<td colspan="5">
									<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
										<tr>
											<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
											<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%"><strong><egui:intnl text="admin.mail.Mail Log Details"/></strong></td>
											<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
										</tr>
									</table>
								</td>
							</tr>
							<tr id="maillog" style="">
								<td width="7" class="eg_subcontentbg" id="form_border" style="border-bottom-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td class="form_border" id="paddingleft" nowrap valign="top" style="border-bottom-width:0px"><egui:intnl text="admin.mail.Log mail manager activity"/></td>
								<td class="form_border" nowrap style="border-bottom-width:0px">:</td>
								<td class="form_border" nowrap style="border-bottom-width:0px">
									<table width="30%" cellspacing="0" cellpadding="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent"  width="10"><input type="radio" class="eg_input" name="maildebug" value="Yes" <%=mailLogDebugEnabled%> onClick="javascript:showMailLogDetails()"></td>
											<td><egui:intnl text="admin.common.Yes"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="10"><input type="radio"class="eg_input" name="maildebug" value="No" <%=mailLogDebugDisabled%> onClick="javascript:showMailLogDetails()"></td>
											<td ><egui:intnl text="admin.common.No"/></td>
										</tr>
										<input type='hidden' name='$_maildebug' value='Log mail manager activity$<%=mailLogDebugEnabled.equalsIgnoreCase("checked") ? "Yes":"No"%>'>
									</table>
								</td>
								<td width="7" class="eg_subcontentbg" id="form_border" style="border-bottom-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<tr id="maillogsize" style="display:none">
								<td width="7" class="eg_subcontentbg" id="form_border" style="border-top-width:1px" >
								<img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td class="form_border" id="paddingleft" nowrap valign="top" style="border-top-width:1px"><egui:intnl text = "admin.mail.Maximum size of log file (MB)"/>
								</td>
								<td class="form_border" nowrap style="border-top-width:1px">:</td>
								<td class="form_border"  nowrap style="border-top-width:1px"><input type="text" name="LogMaxSize" size="15" maxlength="" value="<%=mailLogMaxSize%>"></td>
								<td width="7" class="eg_subcontentbg" id="form_border" style="border-top-width:1px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<input type='hidden' name='$_LogMaxSize' value='Maximum size of log file (MB)$<%=mailLogMaxSize%>'>
							<tr id="maillogfile" style="display:none">
								<td width="7" class="eg_subcontentbg" id="form_border" style="border-top-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td class="form_border" id="paddingleft" nowrap valign="top" style="border-top-width:0px"><egui:intnl text = "admin.mail.Maximum number of log files"/>
								</td>
								<td class="form_border" nowrap style="border-top-width:0px">:</td>
								<td class="form_border"  nowrap style="border-top-width:0px">
								<input type="text" name="LogMaxFile" size="15" maxlength="" value="<%=mailLogMaxRollFile%>"></td>
								<input type='hidden' name='$_LogMaxFile' value='Maximum number of log files$<%=mailLogMaxRollFile%>'>
								<td width="7" class="eg_subcontentbg" id="form_border" style="border-top-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<!-- component name,component type,layer,test checkboxes are disabled by default.If u want to make the above fields configurable,just remove disabled for the corresponding fields. No need to write any coding in the background -->
							<tr id="maillogprefer" style="display:none">
								<td width="7" class="eg_subcontentbg" id="form_spacing" style="border-top-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td class="form_spacing" id="paddingleft" nowrap valign="top" style="border-top-width:0px"><egui:intnl text = "admin.common.Alarm details to be logged"/>
								</td>
								<td class="form_spacing" nowrap style="border-top-width:0px" valign="top" nowrap>:</td>
								<td class="form_spacing" valign="top" style="border-top-width:0px">
									<table width="100%" cellspacing="0" cellpadding="2"  border="0"><col width="5%"><col width="95%">
										<tr>
											<td class="eg_subcontent" nowrap style="border-top-width:0px"><input type="checkbox" name="LogPreferance" value="cName" class="eg_input" disabled <%=aListToken.contains("cname")?"checked":""%>></td>
											<td><egui:intnl text="admin.common.Component name"/></td>
										</tr>
										<tr>
											<td class="eg_subcontent" nowrap style="border-top-width:0px"><input type="checkbox" name="LogPreferance" value="cType" class="eg_input" disabled <%=aListToken.contains("ctype")?"checked":""%>></td>
											<td><egui:intnl text="admin.common.Component type"/></td>
										</tr>
										<tr>
											<td class="eg_subcontent" nowrap style="border-top-width:0px">
											<input type="checkbox" name="LogPreferance" value="layer" class="eg_input" disabled <%=aListToken.contains("layer")?"checked":""%>></td>
											<td><egui:intnl text="admin.common.Layer"/></td>
										</tr>
										<tr>
											<td class="eg_subcontent"  nowrap style="border-top-width:0px">
											<input type="checkbox" name="LogPreferance" value="test" class="eg_input" disabled <%=aListToken.contains("test")?"checked":""%>></td>
											<td><egui:intnl text="admin.common.Test"/></td>
										</tr>
										<tr>
											<td class="eg_subcontent"  nowrap style="border-top-width:0px">
											<input type="checkbox" name="LogPreferance" value="desc" class="eg_input" <%=aListToken.contains("desc")?"checked":""%>></td>
											<td><egui:intnl text="admin.common.Description"/></td>
										</tr>
										<tr>
											<td class="eg_subcontent"  nowrap style="border-top-width:0px">
											<input type="checkbox" name="LogPreferance" value="alarmdate" class="eg_input" <%=aListToken.contains("alarmdate")?"checked":""%>></td>
											<td><egui:intnl text="admin.common.Start date & time"/></td>
										</tr>
									</table>
								</td>
								<input type='hidden' name='$_LogPreferance' value='Alarm details to be logged$<%=logPreference%>'>
								<td width="7" class="eg_subcontentbg" id="form_spacing"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<tr>
								<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  width="100%"  valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
							<script>
								showMailLogDetails();
							</script>
						</table>
					</td>
				</tr>
			</table>
<%
	String filter_mailalerts = transBean.getStrValue(subject,"FilterMailAlerts");
	String filterconfig_nonadmins = transBean.getStrValue(subject,"AllowedForNonAdmins");

	String mailFilterAlertEnabled = "";
	String mailFilterAlertDisabled = "";
	String mailconfig_NonAdminsEnabled = "";
	String mailconfig_NonAdminsDisabled = "";

	if(filter_mailalerts == null || filter_mailalerts.length() == 0)
	{
		filter_mailalerts = "No";
	}
	if(filter_mailalerts.equalsIgnoreCase("true") || filter_mailalerts.equalsIgnoreCase("yes"))
	{
		mailFilterAlertEnabled = "checked";
	}
	else
	{
		mailFilterAlertDisabled = "checked";
	}

	if(filterconfig_nonadmins == null || filterconfig_nonadmins.length() == 0)
	{
		filterconfig_nonadmins = "No";
	}
	if(filterconfig_nonadmins.equalsIgnoreCase("true") || filterconfig_nonadmins.equalsIgnoreCase("yes"))
	{
		mailconfig_NonAdminsEnabled = "checked";
	}
	else
	{
		mailconfig_NonAdminsDisabled = "checked";
	}
%>
			<br>
			<table align="center" cellspacing="0" cellpadding="2" width="85%" border="0">
				<tr>
					<td align="center">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="eg_subcontentbg" style="table-layout:fixed"><col width="10"><col width="300"><col width="20"><col width="400"><col width="7">
							<tr>
								<td colspan="5">
									<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
										<tr>
											<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
											<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%"><strong><egui:intnl text="admin.mail.Filter Mail Alerts"/></strong></td>
											<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td width="7" class="eg_subcontentbg" id="form_border"style="border-bottom-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td class="form_border" nowrap id="paddingleft"style="border-bottom-width:0px"><egui:intnl text="admin.mail.Allow mail filter configuration"/></td>
								<td class="form_border" nowrap style="border-bottom-width:0px"> :</td>
								<td class="form_border" nowrap style="border-bottom-width:0px">
									<table width="30%" border="0" cellspacing="0" cellpadding="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="10">
												<input type="radio" class="eg_input" name="mailalerts" value="Yes" <%=mailFilterAlertEnabled%> onClick="javascript:showMailAlertsDetails()">
											</td>
											<td><egui:intnl text="admin.common.Yes"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="10">
												<input type="radio"class="eg_input" name="mailalerts" value="No"<%=mailFilterAlertDisabled%> onClick="javascript:showMailAlertsDetails()">

											</td>
											<td><egui:intnl text="admin.common.No"/></td>
										</tr>
									</table>
								</td>
								<td width="7" class="eg_subcontentbg" id="form_border"style="border-bottom-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<input type='hidden' name='$_mailalerts' value='Allow mail/sms filter configuration $<%=mailFilterAlertEnabled.equalsIgnoreCase("checked") ? "Yes":"No"%>'>

							<tr id="mailConfigForNonAdmins" style="display:none">
								<td width="7" class="eg_subcontentbg" id="form_border" style="border-top-width:1px;border-bottom-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td>
									<table border="0" width="100%" cellspacing="0" cellpadding="0">
										<tr><td class="form_border" nowrap id="paddingleft" style="border-top-width:1px;border-bottom-width:0px"><egui:intnl text = "admin.mail.Allow non-admins* to update"/></td></tr>
										<tr><td id="paddingleft" class ="eg_7" style="border-top-width:1px;border-bottom-width:0px;"><strong>*</strong><egui:intnl text="admin.common.limited admins and monitor users"/></td></tr>
									</table>
								</td>
								<td class="form_border" nowrap style="border-top-width:1px;border-bottom-width:0px"> :</td>
								<td class="form_border" nowrap style="border-top-width:1px;border-bottom-width:0px">
									<table width="30%" border="0" cellspacing="0" cellpadding="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent"  width="10"><input type="radio" class="eg_input" name="mail_NonAdmins" value="Yes"<%=mailconfig_NonAdminsEnabled%>> </td>
											<td><egui:intnl text="admin.common.Yes"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="10"><input type="radio"class="eg_input" name="mail_NonAdmins" value="No" <%=mailconfig_NonAdminsDisabled%> ></td>
											<td ><egui:intnl text="admin.common.No"/></td>
										</tr>
									</table>
								</td>
								<td width="7" class="eg_subcontentbg" id="form_border" style="border-top-width:1px;border-bottom-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<input type='hidden' name='$_mail_NonAdmins' value='Allow non-admins to update  $<%=mailconfig_NonAdminsEnabled.equalsIgnoreCase("checked") ? "Yes":"No"%>'>
							<tr>
								<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
							<script>
								showMailAlertsDetails();
							</script>
						</table>
					</td>
				</tr>
			</table>

			<table align="center" cellspacing="0" cellpadding="2" width="90%" border="0">
				<tr>
					<td colspan="3" align="center" height="60" nowrap><input type="button" value='<egui:intnl text="admin.common.Update"/>' style="width: 90px;" id="eg_back" onClick="javascript:validateTextBoxes()"></td>
				</tr>
			</table>
		</td>
	</tr>
</table>
<!-- CONFIGURE MESSAGE ENDS HERE -->
<input type="hidden" name="selectedAlarms">
</form>
</body>
</html>

<%
	if(request.getQueryString()!=null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/advancedOptions.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/advancedOptions.jsp");
	}
%>



