<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ page import="com.egurkha.util.StringUtils" %>
<%@ page import="com.egurkha.ini.IniUI" %>
<%@ page import="net.sf.json.JSONObject" %>
<%@ page import="net.sf.json.JSONArray" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	String selectedCType = request.getParameter("selectedCType");
	String selectedTestTypes = request.getParameter("selectedTestTypes");
	
	JSONObject componentObj = new JSONObject();
	JSONArray componentTypeArr = new JSONArray();
	JSONObject testTypeObj = new JSONObject();
	JSONArray testTypeArr = new JSONArray();
	JSONObject rootObj = new JSONObject();
	ArrayList testTypeValue = new ArrayList();
	testTypeValue.add("performance");
	testTypeValue.add("configuration");
	
	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	boolean isConfigSupported = EgInstallInfo.isConfigSupported;
	EgMgrUpgradeInfo egUpgrade = new EgMgrUpgradeInfo();
	HashMap testListMap = new HashMap();
	testListMap = egUpgrade.getUpgradeTestsDetails(selectedCType,selectedTestTypes);

	if (_user != null && isConfigSupported)
	{
		EgUserRole userRole = _user.getUserRole();
		isConfigSupported = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
	}

	ArrayList compTypeList = new ArrayList();
	compTypeList = egUpgrade.getComponentTypes(isConfigSupported);
	
	componentObj.put("displayField","Choose a component type");
	componentObj.put("valueField","none");
	componentTypeArr.add(componentObj);
	rootObj.put("initCompSelect","Choose a component type");

	rootObj.put("initTestType","Performance");
	testTypeObj.put("displayField","Performance");
	testTypeObj.put("valueField","PerformanceTest");
	testTypeArr.add(testTypeObj);
	testTypeObj.put("displayField","Configuration");
	testTypeObj.put("valueField","ConfigurationTest");
	testTypeArr.add(testTypeObj);

	ArrayList serverList = null;
	if (compTypeList != null)
	{
		serverList = sorter.getSortedCompTypeList(compTypeList);
	}
	for (int j=0;j<serverList.size();j++)
	{
		EgName nameObj = (EgName)serverList.get(j);
		String tmpVal = nameObj.getActualName();
		String tmpDis = nameObj.getLocalName();

		componentObj.put("displayField",tmpDis);
		componentObj.put("valueField",tmpVal);
		componentTypeArr.add(componentObj);
	}
	
	JSONObject newTestObj = new JSONObject();
	JSONObject delTestObj = new JSONObject();
	
	JSONArray newTestArr = new JSONArray();
	JSONArray delTestArr = new JSONArray();

	Iterator it = testListMap.keySet().iterator();
	while (it.hasNext())
	{
		String compType = (String)it.next();
		if(compType.equalsIgnoreCase("NEW_TESTS"))
		{
			ArrayList test = (ArrayList)testListMap.get(compType);
			serverList = sorter.getSortedTestList(test);
			for (int j=0;j<serverList.size();j++)
			{
				EgName nameObj = (EgName)serverList.get(j);
				String tmpVal = nameObj.getActualName();
				String tmpDis = nameObj.getLocalName();

				newTestObj.put("displayField",tmpDis);
				newTestObj.put("valueField",tmpVal);
				newTestArr.add(newTestObj);
			}
		}
		else if(compType.equalsIgnoreCase("DELETED_TESTS"))
		{
			ArrayList delTestList = (ArrayList)testListMap.get(compType);
			serverList = sorter.getSortedTestList(delTestList);
			for (int j=0;j<serverList.size();j++)
			{
				EgName nameObj = (EgName)serverList.get(j);
				String tmpVal = nameObj.getActualName();
				String tmpDis = nameObj.getLocalName();

				delTestObj.put("displayField",tmpDis);
				delTestObj.put("valueField",tmpVal);
				delTestArr.add(delTestObj);
			}
		}
	}
	
	rootObj.put("isConfigSupported", isConfigSupported);
	rootObj.put("componentTypeArr", componentTypeArr);
	rootObj.put("newTestArr", newTestArr);
	rootObj.put("delTestArr", delTestArr);
	rootObj.put("testTypeArr", testTypeArr);
	rootObj.put("infoMsg", "No Test Found");

	out.println(rootObj.toString());
%>

