
<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page errorPage="../../EgProbs.jsp"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgTenantInfoAdmin"%>
<%@ page import = "com.eg.EgURLDecoder"%>
<%@ page import = "com.eg.EgAutoTopologyPreview"%>
<%@ page import = "com.egurkha.admin.Rename"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "java.util.*"%>
<%@ page import="net.sf.json.*"%>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	response.setContentType("application/json;charset=UTF-8");
	JSONObject rootJson = new JSONObject();

	String rename = request.getParameter("rename");
	String old_name = EgURLDecoder.decode(request.getParameter("old_name"),"UTF-8");
	String new_name = EgURLDecoder.decode(request.getParameter("new_name"),"UTF-8");
	EgAutoTopologyPreview autoTopoPreview = new EgAutoTopologyPreview();
	EgTenantInfoAdmin tenantInfo = new EgTenantInfoAdmin();


	String message = null;
	boolean renameStatus = true;

	if(StringUtils.isNull(old_name) || StringUtils.isNull(new_name) || StringUtils.isNull(rename))
	{
		renameStatus = false;
		if(StringUtils.isNull(rename))
		{
			message = _mapping.getTextDescription("admin.error.Operation is not defined")+".";
		}
		else
		{
			if(StringUtils.isNull(new_name))
			{
				message = _mapping.getTextDescription("admin.error.You can not proceed renaming with new name as empty or null")+".";
			}
			else
			{
				message = _mapping.getTextDescription("admin.error.You can not proceed renaming as current name is empty or null")+".";
			}
		}
	}
	else
	{
		rename = rename.trim();
		old_name = old_name.trim();
		new_name = new_name.trim();

		if(IniUI.isEgReservedKeyword(new_name))
		{
			renameStatus = false;
			message = "'"+new_name.toUpperCase() +"' "+_mapping.getTextDescription("admin.error.is an eG defined keyword")+". "+_mapping.getTextDescription("admin.error.Choose another name")+".";
		}
		else
		{
			boolean oldNameExist = false;
			boolean isSite = false;
			String auditlogLabel = null;
			String nameConflictLabel = null;
			String update_msmt_table = "true";
			Vector nameConflict = new Vector();//dont add anything into this vector

			AuditLogThread auditLogThread = new AuditLogThread();
			auditLogThread.setValue("Category","Admin");
			auditLogThread.setValue("User_id",_user.getLoginID());
			auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Activity","Rename Tenant");

			String targetPageURL = null;
			
			HashMap allMsComps = (HashMap) session.getAttribute("allMsComps");
			ArrayList allTenantNameList = new ArrayList();

			if (allMsComps == null)
			{
				allMsComps = tenantInfo.getAllConfiguredCompsOfTenants(_user);
			}

			auditLogThread.setValue("Module","Microsoft O365 Tenants");
			oldNameExist = Rename.doesOldnameExist(tenantInfo.getTenantNames(),old_name,new_name,nameConflict);
			nameConflictLabel="admin.error.You are trying to rename a tenant with a name which is already assigned to some other tenant";
			auditlogLabel=old_name + " tenant can not be renamed to "+new_name +" as this name is already assigned to some other tenant";
			
			if(!nameConflict.isEmpty())
			{
				renameStatus = false;
				auditLogThread.setValue("Description",auditlogLabel);
				auditLogThread.sendItToDB();
				message = _mapping.getTextDescription(nameConflictLabel)+".";
			}
			else
			{
				if (allMsComps != null )
				{
					ArrayList managedHostsForSelectedTenant = new ArrayList();
					Hashtable allTenants = (Hashtable) allMsComps.get("tenantNameBasedCompNamesList");
					IniFile tenantIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_msdashboard.ini", true);
					String existTenantName = (String) tenantIni.getValue("LIST_OF_TENANTS", old_name);

					if (allTenants != null && com.egurkha.util.StringUtils.isNull(existTenantName))
					{
						if (!com.egurkha.util.StringUtils.isNull(old_name))
						{
							managedHostsForSelectedTenant = (ArrayList) allTenants.get(old_name);
						}

						oldNameExist = true;

						tenantIni.setValue("LIST_OF_TENANTS", old_name, old_name);
						int len = managedHostsForSelectedTenant.size();
						for (int e=0;e < len; e++) 
						{
							String xx = (String) managedHostsForSelectedTenant.get(e);
							if (xx!=null) xx=xx.trim();
							tenantIni.setValue("TENANT_DETAILS", xx + "#" + old_name, old_name);
						}
					}
					tenantIni.saveFile();
					EgConfigFilesSync.releaseInstance(tenantIni);
				}

				if(oldNameExist)
				{
					boolean success = false;
					tenantInfo.renameTenant(old_name,new_name);
					auditLogThread.setPreviousValue("Tenant name",old_name);
					auditLogThread.setCurrentValue("Tenant name",new_name);
					auditLogThread.setValue("Description","Tenant has been renamed");
					auditLogThread.sendItToDB();
					String label = "admin.common."+rename.toLowerCase()+" has been renamed successfully to";
					message = old_name + " " + _mapping.getTextDescription(label) + " " + new_name + ".";
					autoTopoPreview.autoTopology();
					
				}
				else
				{
					renameStatus = false;
					String errorLabel = rename + " name";
					auditLogThread.setPreviousValue(errorLabel,old_name);
					auditLogThread.setCurrentValue(errorLabel,new_name);
					auditLogThread.setValue("Description",rename+" was not renamed as it had already been deleted");
					auditLogThread.sendItToDB();
					String label = "admin.common."+rename.toLowerCase()+" was not renamed to";
					message = old_name + " " +_mapping.getTextDescription(label) + " " + new_name +".";
				}
			}
		}
	}
	rootJson.put("message",message);
	rootJson.put("renamed",renameStatus);
	rootJson.put("rename",_mapping.getTextDescription("admin.common.Rename"));
	rootJson.put("success","true");
	out.println(rootJson.toString());
%>



