<%@ include file = "../../EgTrackerAJSON.jsp" %>

<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "net.sf.json.JSONObject"%>
<%@ page import = "com.eg.EgCorrectiveScripts"%>
<%@ page import = "com.eg.EgServicesInfo"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>

<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	JSONObject rootJson = new JSONObject();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
	
	String componentType = request.getParameter("componentType");
	String testName = request.getParameter("testName");
	String reqFrom = request.getParameter("reqFrom");
	
	if (componentType != null && !componentType.equals("") && !componentType.equals("-1"))
	{
		EgServicesInfo egServicesInfo = new EgServicesInfo("manager");
		boolean isAuditLogEnabled = egServicesInfo.isAuditlogEnabled();
		AuditLogThread auditLogThread = null;
	
		EgCorrectiveScripts correctiveScripts = new EgCorrectiveScripts();
		if (!StringUtils.isNull(reqFrom) && reqFrom.equals("enableCsLink"))
		{
			ArrayList enableCSList = new ArrayList();
			if (!StringUtils.isNull(testName))
			{
				enableCSList.add(testName);
			}

			if (enableCSList != null && enableCSList.size() > 0)
			{
				correctiveScripts.enableCorrectiveScript(componentType, enableCSList);
				if (isAuditLogEnabled)
				{
					auditLogThread = new AuditLogThread();
					auditLogThread.setValue("Category","Admin");
					auditLogThread.setValue("User_id",_user.getLoginID());
					auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
					auditLogThread.setValue("Session_id",session.getId());
					auditLogThread.setValue("Module","Test Specific Configuration");
					auditLogThread.setValue("Activity","Enable Corrective Script");
					auditLogThread.setValue("Description","Corrective Script have been Enabled");
					for (int i=0; i<enableCSList.size(); i++)
					{
						String csTestName = (String) enableCSList.get(i);
						String displayTestName = _mapping.getTestDescription(csTestName);
						auditLogThread.setCurrentValue("Enabled Tests", displayTestName);
					}
					auditLogThread.sendItToDB();
				}
			}
		}

		if (!StringUtils.isNull(reqFrom) && reqFrom.equals("disableCsLink"))
		{
			ArrayList disableCSList = new ArrayList();
			if (!StringUtils.isNull(testName))
			{
				disableCSList.add(testName);
			}

			if (disableCSList != null && disableCSList.size() > 0)
			{
				correctiveScripts.disableCorrectiveScript(componentType, disableCSList);
				if (isAuditLogEnabled)
				{
					auditLogThread = new AuditLogThread();
					auditLogThread.setValue("Category","Admin");
					auditLogThread.setValue("User_id",_user.getLoginID());
					auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
					auditLogThread.setValue("Session_id",session.getId());
					auditLogThread.setValue("Module","Test Specific Configuration");
					auditLogThread.setValue("Activity","Disable Corrective Script");
					auditLogThread.setValue("Description","Corrective Script have been Disabled");
					for (int i=0; i<disableCSList.size(); i++)
					{
						String csTestName = (String) disableCSList.get(i);
						String displayTestName = _mapping.getTestDescription(csTestName);
						auditLogThread.setCurrentValue("Disabled Tests",displayTestName);
					}
					auditLogThread.sendItToDB();
				}
			}
		}
		rootJson.put("requestStatus","success");
	}
	out.println(rootJson.toString());
%>



