<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "java.net.InetAddress"%>
<%@ page import = "com.eg.RemoteControlTaskHelper"%>
<%@ page import = "java.io.*"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	JSONObject rootJson = new JSONObject(); 

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	rootJson.put("success","false");
%>

<%
try
{
	String hostIP		=request.getParameter("snmphost");
	String portNumber	=request.getParameter("snmpport");
	String version		=request.getParameter("snmpversion");
	String communityStr	=request.getParameter("snmpcommunity");
	String context		=request.getParameter("context");
	String userName		=request.getParameter("username");
	String authPwd		=request.getParameter("authpass");
	String authType		=request.getParameter("authtype");
	String encrptType	=request.getParameter("encrypttype");
	String encryptPwd	=request.getParameter("encryptpassword");
	String oidValue		=request.getParameter("oidvalue");	
	String transProtocol=request.getParameter("dataovertcp");
	String isEncrptEnbl	=request.getParameter("encryptflag");
	String extAgentIP	=request.getParameter("installedagent");

	int timeOut=300;
	boolean isEncryptionEnabled=false;
	boolean isDefaultAgentUsed=true;
	boolean isDefaultSameAsExternal=false;
	if(hostIP == null || hostIP.equalsIgnoreCase("none"))
	{
		hostIP="none";
	}
	if(portNumber == null || portNumber.equalsIgnoreCase("none"))
	{
		portNumber="none";
	}
	if(version == null || version.equalsIgnoreCase("none"))
	{
		version="none";
	}
	if(communityStr == null || communityStr.equalsIgnoreCase("none"))
	{
		communityStr="none";
	}
	if(context == null || context.equalsIgnoreCase("none") || context.length() == 0)
	{
		context="";
	}
	if(userName == null || userName.equalsIgnoreCase("none"))
	{
		userName="none";
	}
	if(authPwd == null || authPwd.equalsIgnoreCase("none"))
	{
		authPwd="none";
	}
	if(authType == null || authType.equalsIgnoreCase("none"))
	{
		authType="none";
	}
	if(encrptType == null || encrptType.equalsIgnoreCase("none"))
	{
		encrptType="none";
	}
	if(encryptPwd == null || encryptPwd.equalsIgnoreCase("none"))
	{
		encryptPwd="none";
	}
	if(oidValue == null || oidValue.equalsIgnoreCase("none"))
	{
		oidValue="none";
	}
	if (oidValue.endsWith(".0"))
	{
		oidValue = oidValue.substring(0, oidValue.lastIndexOf(".0"));
	}

	if(StringUtils.isNull(extAgentIP))
	{
		extAgentIP="";
	}

	if(transProtocol == null || transProtocol.equalsIgnoreCase("none"))
	{
		transProtocol="none";
	}
	else
	{
		if(transProtocol.equals("1"))
		{
			transProtocol="tcp";
		}
		else
		{
			transProtocol="udp";
		}
	}

	if(isEncrptEnbl == null || isEncrptEnbl.equalsIgnoreCase("none"))
	{
		isEncrptEnbl="none";
	}

	if(isEncrptEnbl.equals("1"))
	{
		isEncryptionEnabled=true;
	}
	else
	{
		isEncryptionEnabled=false;
	}

	String[] ag = null;
	if(version.equalsIgnoreCase("v1") || version.equalsIgnoreCase("v2"))
	{
		ag = new String[10];
		ag[0] = "-p";
		ag[1] = portNumber;
		ag[2] = "-c";
		ag[3] = communityStr;
		ag[4] = "-o";
		ag[5] = "-v";
		if (version.equalsIgnoreCase("v1"))
			ag[6] = "1";
		else
			ag[6] = "2";
		ag[7] = hostIP;
		ag[8] = oidValue;
		ag[9] = transProtocol;
	}
	else if(version.equalsIgnoreCase("v3"))
	{
		if(!isEncryptionEnabled)
		{
			ag = new String[18];
			ag[0] = "-o";
			ag[1] = "-w";
			ag[2] = "2";
			ag[3] = "-v";
			ag[4] = "3";
			ag[5] = "-p";
			ag[6] = portNumber;
			ag[7] = "-u";
			ag[8] = userName;
			ag[9] = "-a";
			ag[10]= authType;
			ag[11]= "-A";
			ag[12]= authPwd;
			ag[13]= hostIP;
			ag[14]= oidValue;
			ag[15]= "-n";
			ag[16]= context;
			ag[17]= transProtocol;	
		}
		else
		{
			ag = new String[22];
			ag[0] = "-o";
			ag[1] = "-w";
			ag[2] = "2";
			ag[3] = "-v";
			ag[4] = "3";
			ag[5] = "-p";
			ag[6] = portNumber;
			ag[7] = "-u";
			ag[8] = userName;
			ag[9] = "-a";
			ag[10]= authType;
			ag[11]= "-A";
			ag[12]= authPwd;
			ag[13]= "-x";
			ag[14]= encrptType;
			ag[15]= "-X";
			ag[16]= encryptPwd;
			ag[17]= hostIP;
			ag[18]= oidValue;
			ag[19]= "-n";
			ag[20]= context;
			ag[21]= transProtocol;
		}
	}

	ArrayList ipList=new ArrayList();
	InetAddress addr = InetAddress.getLocalHost();
	String hostName = addr.getHostName();
	boolean installedWithHostName=false;

	if (!StringUtils.isNull(extAgentIP) && extAgentIP.equalsIgnoreCase(hostName))
	{
		installedWithHostName=true;
		isDefaultSameAsExternal=true;
	}


	if (!installedWithHostName)
	{
		try 
		{
			InetAddress[] addr1 = InetAddress.getAllByName(hostName);
			for (int l=0;l<addr1.length;l++)
			{
				ipList.add(addr1[l].getHostAddress());
			}
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
		}

		boolean localIPFound=false;
		if(ipList != null && ipList.size() > 0)
		{			
			for(int i=0; i < ipList.size(); i++)
			{
				String locIPAddr=(String)ipList.get(i);
				if(locIPAddr != null && locIPAddr.equals(extAgentIP))
				{
					localIPFound=true;
				}
				else
				{
					continue;
				}
			}
		}

		if(localIPFound)
			isDefaultSameAsExternal=true;
		else
			isDefaultSameAsExternal=false;

	}

	if(isDefaultSameAsExternal)
	{
		snmpgetsubtree s = new snmpgetsubtree (ag,timeOut);
		ArrayList al = s.getSubTree();
		
		if (al != null && al.size() > 0)
		{
			JSONArray resultSubTreeArr = new JSONArray();
			for (int a= 0; a<al.size();a++)
			{
				JSONObject resultSubTreeObj = new JSONObject();
				String strSnmpSubtree = (String) al.get(a);
				resultSubTreeObj.put("displayField",strSnmpSubtree);
				resultSubTreeObj.put("valueField",strSnmpSubtree);
				resultSubTreeArr.add(resultSubTreeObj);
			}
			rootJson.put("resultSubTreeArr",resultSubTreeArr);
		}
		rootJson.put("success","true");
		out.println(rootJson.toString());
	}
	else
	{
		if(context.trim().length() == 0)
			context="context_null";
		String agentID =extAgentIP;
		String subtreeInput=null;
		ArrayList subtreeListFromExternal=new ArrayList();
		if(version.equalsIgnoreCase("v1") || version.equalsIgnoreCase("v2"))
		{
			if(version.equalsIgnoreCase("v1"))
			{
				subtreeInput="-p"+"~|~"+portNumber+"~|~"+"-c"+"~|~"+communityStr+"~|~"+"-o"+"~|~"+"-v"+"~|~"+"1"+"~|~"+hostIP+"~|~"+oidValue+"~|~"+transProtocol;
			}
			else if(version.equalsIgnoreCase("v2"))
			{
				subtreeInput="-p"+"~|~"+portNumber+"~|~"+"-c"+"~|~"+communityStr+"~|~"+"-o"+"~|~"+"-v"+"~|~"+"2"+"~|~"+hostIP+"~|~"+oidValue+"~|~"+transProtocol;
			}
		}
		
		else if(version.equalsIgnoreCase("v3"))
		{
			if(!isEncryptionEnabled)
			{
				subtreeInput="-o"+"~|~"+"-w"+"~|~"+"2"+"~|~"+"-p"+"~|~"+portNumber+"~|~"+"-v"+"~|~"+"3"+"~|~"+"-u"+"~|~"+userName+"~|~"+"-a"+"~|~"+authType+"~|~"+"-A"+"~|~"+authPwd+"~|~"+hostIP+"~|~"+oidValue+"~|~"+"-n"+"~|~"+context+"~|~"+transProtocol;
			}
			else
			{
				subtreeInput="-o"+"~|~"+"-w"+"~|~"+"2"+"~|~"+"-p"+"~|~"+portNumber+"~|~"+"-v"+"~|~"+"3"+"~|~"+"-u"+"~|~"+userName+"~|~"+"-a"+"~|~"+authType+"~|~"+"-A"+"~|~"+authPwd+"~|~"+"-x"+"~|~"+encrptType+"~|~"+"-X"+"~|~"+encryptPwd+"~|~"+hostIP+"~|~"+oidValue+"~|~"+"-n"+"~|~"+context+"~|~"+transProtocol;
			}
		}
		String cmd=subtreeInput+"@#@Y";
		if(!agentID.equals("none") && agentID.trim().length()>0)
		{
			RemoteControlTaskHelper helper = new RemoteControlTaskHelper();
			if(helper.setAgentIntoControlMode(agentID))
			{
				helper.executeTask("SNMP_Utility", session.getId(), cmd);
				if(helper.isOutputAvailable())
				{
					subtreeListFromExternal = helper.getOutput();
				}
			}
		}
		if (subtreeListFromExternal != null && subtreeListFromExternal.size() > 0)
		{
			JSONArray resultSubTreeArr = new JSONArray();
			for (int a= 0; a<subtreeListFromExternal.size();a++)
			{
				JSONObject resultSubTreeObj = new JSONObject();
				String strSnmpSubtree = (String) subtreeListFromExternal.get(a);
				resultSubTreeObj.put("displayField",strSnmpSubtree);
				resultSubTreeObj.put("valueField",strSnmpSubtree);
				resultSubTreeArr.add(resultSubTreeObj);
			}
			rootJson.put("resultSubTreeArr",resultSubTreeArr);
		}
		rootJson.put("success","true");
		out.println(rootJson.toString());
	}
}
catch(Throwable ex)
{
	rootJson.put("success","false");
	ex.printStackTrace();
}
%>



