<%
/**
 *	File name	:	EgconfigremoteagentspJson.jsp
 *	Modified	:	16/07/2004	Arun	Allows an associated host to be associated to another remote agent and removed existing association from the DB.
 */
 %>

<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgExternalInfo" %>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import = "com.eg.IniHelper" %>
<%@ page import = "com.eg.EgConfigFilesSync" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "java.sql.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "com.eg.UnmanagedAgentsInfo"%>
<%@ page import = "com.eg.UpdateAndTransmitTrendInfo" %>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.eg.EgDiscInfo" %>
<%@ page import = "net.sf.json.*"%>

<jsp:useBean id="trans" scope="page" class="egurkha.TransactionBean"/>
<jsp:useBean id="servicer" scope="page" class="egurkha.ServiceBean"/>

<%!
	String newValues = "None,None,None,None,22";
%>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	/*
	 * Will contain hosts to be disassociated.
	 */
	String s_eghosts = request.getParameter("fmanage");
	/*
	 * Will contain hosts to be associated.
	 */
	String s_newagenthosts = request.getParameter("funmanage");
	String existingAgents = request.getParameter("existingAgents");
	/*
	 * The selected remote agent.
	 */
	String selectedRemAgent = request.getParameter("eagent");

	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Remote Agent Configuration");
	auditLogThread.setValue("Activity","Assign Remote Agent");

	EgExternalInfo externalInfo = new EgExternalInfo("manager");
	EgDiscInfo egDiscInfo = new EgDiscInfo("manager");
	ArrayList selectedCompList = new ArrayList();
	ArrayList lostComponentsList = null;
	String lostComponents[] = null;
	lostComponents = StringUtils.getTokens(s_eghosts,",");
	if(lostComponents != null && lostComponents.length>0)
		lostComponentsList = new ArrayList(Arrays.asList(lostComponents));
	else
		lostComponentsList = new ArrayList();

	ArrayList lostList = new ArrayList();
	for (int r=0; r<lostComponentsList.size(); r++)
	{
		String me = (String) lostComponentsList.get(r);
		if (me == null || me.trim().length() == 0)
			continue;
		if (!lostList.contains(me))
		{
			lostList.add(me);
			List compTypeList = egDiscInfo.getServerTypesForNick(me);
			if (compTypeList != null && compTypeList.size() > 0)
			{
				if (compTypeList.contains("MS_Azure_Cloud"))
				{
					selectedCompList.add(me);
				}
			}
		}
	}

	ArrayList newlyAddedComponentsList = null;
	String newlyAddedComponents[] = null;
	newlyAddedComponents = StringUtils.getTokens(s_newagenthosts,",");
	if(newlyAddedComponents != null && newlyAddedComponents.length>0)
		newlyAddedComponentsList = new ArrayList(Arrays.asList(newlyAddedComponents));	
	else
		newlyAddedComponentsList = new ArrayList();
		
	ArrayList newList = new ArrayList();
	for (int r=0; r<newlyAddedComponentsList.size(); r++)
	{
		String me = (String) newlyAddedComponentsList.get(r);
		if (me == null || me.trim().length() == 0)
			continue;
		if (!newList.contains(me))
		{
			newList.add(me);
			List compTypeList = egDiscInfo.getServerTypesForNick(me);
			if (compTypeList != null && compTypeList.size() > 0)
			{
				if (compTypeList.contains("MS_Azure_Cloud"))
				{
					selectedCompList.add(me);
				}
			}
		}
	}
	
	List disAssocHosts = new LinkedList();
	//String[] disAssocHostTokens = StringUtils.getTokens(s_eghosts, EgConstants.COMMA);
	String[] disAssocHostTokens = StringUtils.getTokens(s_newagenthosts, EgConstants.COMMA);

	disAssocHosts.addAll(Arrays.asList(disAssocHostTokens));

	List assocHosts = new LinkedList();
	String[] assocHostTokens = StringUtils.getTokens(s_newagenthosts, EgConstants.COMMA);
	assocHosts.addAll(Arrays.asList(assocHostTokens));

	//trans.createFile("eg_external.ini");
	IniFile externalWr = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_external.ini");
	/*
	 * Go through list of associated hosts and see if any of them are associated to
	 * any other remote agent. If so, add that host to the disassociated list also.
	 */
	Map agtlessDiscMap = new HashMap();
	Map oldConfig = new HashMap();
	Map oldAgents = new HashMap();
	for (Iterator i=assocHosts.iterator(); i.hasNext(); )
	{
		String host = (String)i.next();
		String prevAgent = externalWr.getValue("Remote_Agent_Mapping_Section", host);
		String prevConfig = externalWr.getValue("Agentless_Infos_Section", host);
		if (!StringUtils.isNull(prevConfig))
			oldConfig.put(host, prevConfig);
		if (!StringUtils.isNull(prevAgent))
			oldAgents.put(host, prevAgent);
	}

	if (assocHosts.indexOf(selectedRemAgent) > -1)
	{
		rootJson.put("requestStatus","failed");
		JSONObject errorMsg = new JSONObject();
		errorMsg.put("title",_mapping.getTextDescription("admin.common.Remote Agents Configuration"));
		errorMsg.put("message1",_mapping.getTextDescription("admin.common.A host cannot be associated to a remote agent of the same name")+"-<br>"+selectedRemAgent);
		rootJson.put("error",errorMsg);
	}

	/*
	 * Now disassociate hosts from eg_external.ini and the DB.
	 */
	//IniFile externalWr = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_external.ini");
	Vector delHost = new Vector();
	for (Iterator i=disAssocHosts.iterator(); i.hasNext(); )
	{
		String host = (String)i.next();
		delHost.add(host);
		//externalWr.deleteValue("Remote_Agent_Mapping_Section", host);
		//externalWr.deleteValue("Agentless_Infos_Section", host);
	}
	externalWr.deleteValues("Remote_Agent_Mapping_Section", delHost);
	externalWr.deleteValues("Agentless_Infos_Section", delHost);
	externalWr.saveFile();
	EgConfigFilesSync.releaseInstance(externalWr);

	/*
	 * Stop discovery so that eg_agents.ini is not overwritten while db activity takes place
	 */
	//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
	IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
	servicer.stopDiscovery();
	boolean completed = false;
	Vector v_pair = new Vector();
	Vector pair = new Vector();
	try
	{
		EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
		com.eg.IniFile iniFile = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_testinfo.ini",true);
		for (Iterator i=disAssocHosts.iterator(); i.hasNext(); )
		{
			String host = (String)i.next();
			String prevAgent = (String)oldAgents.get(host);

			/*
			 * If a previous agent does not exist,
			 * disassociate from the currently selected remote agent
			 */
			if (StringUtils.isNull(prevAgent))
			{
				prevAgent = selectedRemAgent;
			}
			String[] disabledInfos = iniFile.getVariables(prevAgent);
			if (disabledInfos!=null)
			{
				for (int zz = 0; zz < disabledInfos.length; zz++ )
				{
					String var = disabledInfos[zz];
					String testName = var.substring(0,var.indexOf(":"));

					if (var.indexOf(host) < 0 || specsInfo.isExternalTest(testName))
					{
						continue;
					}
					String val=iniFile.getValue(prevAgent,var);
					var = var.substring(0,var.indexOf("#")+1);
					
					ArrayList tokens = StringUtils.egTokenizer(var,":");
					int size =tokens.size();
					if (size == 3)
					{
						if (var.endsWith(":"+host+"#"))
						{
							iniFile.setValue(selectedRemAgent,disabledInfos[zz],val);
							iniFile.deleteValue(prevAgent,disabledInfos[zz]);
						}
					}else if (size == 4 || size == 5)
					{
						String hostName=(String)tokens.get(2);
						if (hostName.equals(host))
						{
							iniFile.setValue(selectedRemAgent,disabledInfos[zz],val);
							iniFile.deleteValue(prevAgent,disabledInfos[zz]);
						}
					}
				}
			}
			iniFile.saveFile();
			EgConfigFilesSync.releaseInstance(iniFile);
			pair.add(prevAgent);
			pair.add(host);
			v_pair.add(pair);
		}
		UpdateAndTransmitTrendInfo trendInfo = new UpdateAndTransmitTrendInfo();
		Vector param = new Vector();
		param.add("Egconfigremoteagentsp");
		param.add(v_pair);
		completed = trendInfo.removeAgentForTarget(param);
	}
	catch(Exception e)
	{
		e.printStackTrace();
	}

	if (completed)
	{
		/*
		 * Now associate the new hosts
		 */
		//IniFile agentsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini");
		IniFile agentsFileWr  = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini");
		List iniEntriesList = new ArrayList();
		IniFile extWr = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_external.ini");
		for (Iterator i=assocHosts.iterator(); i.hasNext(); )
		{
			String host = (String)i.next();
			// Fix starts to retain the test configuration details while changing the remoteagent
			//String remAgent = externalInfo.getRemoteAgentForHost(host);
			String remAgent = (String)oldAgents.get(host);
			String vars[] = agentsFileWr.getVariables(remAgent);

			boolean configureHyperVisors = false;
			List compTypeList = egDiscInfo.getServerTypesForNick(host);
			if (compTypeList != null && !compTypeList.isEmpty())
			{
				if (compTypeList.contains("Virtual_center") || 
					compTypeList.contains("Nutanix_Cluster") ||
					compTypeList.contains("Redhat_linux_mgr") ||
					compTypeList.contains("hmc_server") ||
					compTypeList.contains("VmEsx_i_server") ||
					compTypeList.contains("VmVdi_i_server") ||
					compTypeList.contains("pSeries_server") ||
					compTypeList.contains("Nutanix_Acropolis") ||
					compTypeList.contains("Nutanix_Acropolis_Vdi") ||
					compTypeList.contains("Redhat_linux_hpv") ||
					compTypeList.contains("Redhat_linux_vdi"))
				{
					configureHyperVisors = true;
				}
			}

			for (int v=0;v < vars.length; v++)
			{
				String variable = vars[v];
				if (variable.indexOf(":"+host+":") > -1 || variable.endsWith(":"+host))
				{
					String value = agentsFileWr.getValue(remAgent,variable);
					if (configureHyperVisors)
					{
						int vcIdx = value.toLowerCase().indexOf("-vc_user");
						int esxIdx = value.toLowerCase().indexOf("-virtual_center");
						int prsmIdx = value.toLowerCase().indexOf("-nutanix_prism_user");
						int nutIdx = value.toLowerCase().indexOf("-prism_ip");
						int hmcIdx = value.toLowerCase().indexOf("-hmc_user");
						int hmcHvIdx = value.toLowerCase().indexOf("-management_server");
						int rhevIdx = value.toLowerCase().indexOf("-rhel_manager_user");
						int rhevHvIdx = value.toLowerCase().indexOf("-rhel_mgr_host");
						String agtlessVar = "";
						if (hmcIdx > -1 || 
							hmcHvIdx > -1 || 
							nutIdx > -1 || 
							prsmIdx > -1 || 
							vcIdx > -1 || 
							esxIdx > -1 ||
							rhevHvIdx > -1 ||
							rhevIdx > -1)
						{
							if (vcIdx > -1 || esxIdx > -1) 
							{

								String tmpStr2 = value.substring(esxIdx + "-virtual_center".length() +1).trim();
								if (vcIdx > -1)
								{
									tmpStr2 = value.substring(vcIdx + "-host".length() +1).trim();
								}
								String virtual_center = tmpStr2.substring(0,tmpStr2.indexOf(" ")).trim();

								agtlessVar = "vcenter#"+virtual_center;
								ArrayList hvVarList = new ArrayList();
								hvVarList.add(agtlessVar);
								String thisSubject = selectedRemAgent+"~|~"+remAgent;
								if(agtlessDiscMap.containsKey(thisSubject))
								{
									ArrayList lst = (ArrayList) agtlessDiscMap.get(thisSubject);
									if(!lst.contains(agtlessVar))
										lst.add(agtlessVar);
									agtlessDiscMap.put(thisSubject, lst);
								}
								else
								{
									agtlessDiscMap.put(thisSubject, hvVarList);
								}
							}
							else if (prsmIdx > -1 || nutIdx > -1) 
							{
								String tmpStr2 = value.substring(nutIdx + "-Prism_IP".length() +1).trim();
								if (prsmIdx > -1)
								{
									tmpStr2 = value.substring(prsmIdx + "-host".length() +1).trim();
								}
								String prismIP = tmpStr2.substring(0,tmpStr2.indexOf(" ")).trim();

								agtlessVar = "nutanix#"+prismIP;
								ArrayList hvVarList = new ArrayList();
								hvVarList.add(agtlessVar);
								String thisSubject = selectedRemAgent+"~|~"+remAgent;
								if(agtlessDiscMap.containsKey(thisSubject))
								{
									ArrayList lst = (ArrayList) agtlessDiscMap.get(thisSubject);
									if(!lst.contains(agtlessVar))
										lst.add(agtlessVar);
									agtlessDiscMap.put(thisSubject, lst);
								}
								else
								{
									agtlessDiscMap.put(thisSubject, hvVarList);
								}
							}
							else if (hmcIdx > -1 || hmcHvIdx > -1)  
							{
								String tmpStr2 = value.substring(hmcHvIdx + "-management_server".length() +1).trim();
								if (hmcIdx > -1)
								{
									tmpStr2 = value.substring(hmcIdx + "-host".length() +1).trim();
								}
								String mgmtServer = tmpStr2.substring(0,tmpStr2.indexOf(" ")).trim();

								agtlessVar = "hmc#"+mgmtServer;
								ArrayList hvVarList = new ArrayList();
								hvVarList.add(agtlessVar);
								String thisSubject = selectedRemAgent+"~|~"+remAgent;
								if(agtlessDiscMap.containsKey(thisSubject))
								{
									ArrayList lst = (ArrayList) agtlessDiscMap.get(thisSubject);
									if(!lst.contains(agtlessVar))
										lst.add(agtlessVar);
									agtlessDiscMap.put(thisSubject, lst);
								}
								else
								{
									agtlessDiscMap.put(thisSubject, hvVarList);
								}
							}
							else if (rhevIdx > -1 || rhevHvIdx > -1) 
							{
								String tmpStr2 = value.substring(rhevHvIdx + "-Rhel_mgr_host".length() +1).trim();
								if (rhevIdx > -1)
								{
									tmpStr2 = value.substring(rhevIdx + "-host".length() +1).trim();
								}
								String rhevMgrHost = tmpStr2.substring(0,tmpStr2.indexOf(" ")).trim();

								agtlessVar = "rhev#"+rhevMgrHost;
								ArrayList hvVarList = new ArrayList();
								hvVarList.add(agtlessVar);
								String thisSubject = selectedRemAgent+"~|~"+remAgent;
								if(agtlessDiscMap.containsKey(thisSubject))
								{
									ArrayList lst = (ArrayList) agtlessDiscMap.get(thisSubject);
									if(!lst.contains(agtlessVar))
										lst.add(agtlessVar);
									agtlessDiscMap.put(thisSubject, lst);
								}
								else
								{
									agtlessDiscMap.put(thisSubject, hvVarList);
								}
							}
						}
					}
					if (value.startsWith("-manual"))
					{
						iniEntriesList.add(new IniHelper(selectedRemAgent,variable,value));
					}
				}
			}
			// Fix ends
			extWr.setValue("Remote_Agent_Mapping_Section", host, selectedRemAgent);

			String prevConfig = (String)oldConfig.get(host);
			if (StringUtils.isNull(prevConfig))
			{
				prevConfig = newValues;
			}
			
			extWr.setValue("Agentless_Infos_Section", host, prevConfig);
			extWr.deleteValue("Internal_Agent_Mapping", host);
		}
		extWr.saveFile();
		EgConfigFilesSync.releaseInstance(extWr);
		if (iniEntriesList.size() > 0)
		{
			//IniFile agentsFileWr  = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini",true);
			//IniFile agentsFileWr  = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini");
			for(int ii=0; ii<iniEntriesList.size(); ii++)
			{
				IniHelper iniHr = (IniHelper)iniEntriesList.get(ii);
				String sub = iniHr.getSubject();
				String var = iniHr.getVariable();
				String val = iniHr.getValue();
				agentsFileWr.setValue(sub,var,val);
			}
			agentsFileWr.saveFile();
			//EgConfigFilesSync.releaseInstance(agentsFileWr);
		}
		EgConfigFilesSync.releaseInstance(agentsFileWr);
		boolean done = false;
		if (lostList.size() > 0)
		{
			String s = "";
			for (int i=0; i<lostList.size(); i++)
			{ 
				String me = (String) lostList.get(i);
				s+=me+",";
			}
			if (s.length() > 0)
				s = s.substring(0,s.length()-1);
			done = true;
			auditLogThread.setCurrentValue("Disassociated component(s)",s);
		}
		if (newList.size() > 0)
		{
			String s = "";
			for (int i=0; i<newList.size(); i++)
			{ 
				String me = (String)newList.get(i);
				String old = (String) oldAgents.get(me);
				s+=me;
				if (old != null)
					s +=" (Previous remote agent:"+ old+")";
				s+=",";
			}
			if (s.length() > 0)
				s = s.substring(0,s.length()-1);
			done = true;
			auditLogThread.setCurrentValue("Associated component(s)",s);
		}
		auditLogThread.setValue("Description","Hosts are associated to remote agent " + selectedRemAgent);
		if (done)
			auditLogThread.sendItToDB();
		/* code for auditlog ends */

		//trans.saveFile();
		//iniFile.saveFile();
		servicer.startDiscovery("1");

		rootJson.put("requestStatus","success");
		screenLabels.put("SucessfullyUpdated",_mapping.getTextDescription("admin.test.The remote agent")+" "+"'"+selectedRemAgent+"'"+" "+_mapping.getTextDescription("admin.test.has been assigned successfully")+".");
		rootJson.put("screenLabels",screenLabels);

		JSONObject resultMsg = new JSONObject();
		resultMsg.put("title",_mapping.getTextDescription("admin.test.ASSIGN - REMOTE AGENTS"));
		resultMsg.put("message1",_mapping.getTextDescription("admin.test.The remote agent")+" "+"'"+selectedRemAgent+"'"+" "+_mapping.getTextDescription("admin.test.has been assigned successfully")+".");
		rootJson.put("result",resultMsg);

		UnmanagedAgentsInfo unmanagedagent = new UnmanagedAgentsInfo();
		String remoteAgentIP = externalInfo.getIpForRemoteAgent(selectedRemAgent);
		unmanagedagent.updateAgentDetail(remoteAgentIP);

		//adding remote agent to the sub-org and users
		if (done)
		{
			EgUuidInfo uuidInfo = new EgUuidInfo();
			EgUserElementsInfo elemInfo = new EgUserElementsInfo();
			EgCertUsage certUsage = new EgCertUsage();
			String user_id = _user.getLoginID();
			String superOrgName = (!uuidInfo.isSuperOrg(user_id)) ? uuidInfo.getSuperOU(user_id) : user_id;
			String eg_uuid = EgConfigInfo.egMgrConfigDir + "eg_uuid.ini";
			IniFile uuidIniObj = new IniFile(eg_uuid);
			ArrayList limAdminUsersList = certUsage.getAllLimitedCompAccessUsers(true);
			ArrayList defOrgDefUsersList = User.getDefaultUsers();
			TreeSet allSubOrgsAndUsers = uuidInfo.getAllUsersUnderOrg(superOrgName);
			allSubOrgsAndUsers.removeAll(defOrgDefUsersList);
			ErUserData erUser;
			if (allSubOrgsAndUsers != null)
			{
				Iterator itr = allSubOrgsAndUsers.iterator();
				while (itr.hasNext())
				{
					String orgUser = (String)itr.next();
					if (!limAdminUsersList.contains(orgUser))
					{
						continue;
					}
					erUser = new ErUserData(orgUser,false);
					Vector nickList = erUser.getAllUserComponents(1);
					if (checkContainsAnyNicks(nickList,newList))
					{
						//have to check whether it has this remote agent or not
						ArrayList userRemAgnts = elemInfo.getRemoteAgentsForUser(orgUser);
						if (userRemAgnts.contains(selectedRemAgent))//if present then skip otherwise add to the user_elements table
						{
							continue;
						}
						elemInfo.updateUserElements(orgUser,"RemoteAgent",selectedRemAgent);
					}
				}
			}
		}
		
		if (selectedCompList != null && selectedCompList.size() > 0)
		{
			String otherRemoteAgent = request.getParameter("otherRmtAgent");
			if (StringUtils.isNull(otherRemoteAgent))
			{
				otherRemoteAgent = "";
			}
			ArrayList compToModifyList = new ArrayList();
			IniFile msAzureConfig = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_msazureconfig.ini");
			
			String[] tenantIdArr = msAzureConfig.getVariables(otherRemoteAgent);
			if (tenantIdArr != null && tenantIdArr.length > 0)
			{
				int tntIdLen = tenantIdArr.length;
				for (int b=0; b<tntIdLen; b++)
				{
					String tenantId = tenantIdArr[b];
					String tenantNameStr = msAzureConfig.getValue(otherRemoteAgent,tenantId);
					if (!StringUtils.isNull(tenantNameStr))
					{
						ArrayList tenantNameList = new ArrayList(Arrays.asList(StringUtils.getTokens(tenantNameStr,"^#^")));
						for (int c=0; c<tenantNameList.size(); c++)
						{
							String tenantName = (String) tenantNameList.get(c);
							
							String[] subscriptionWithNickArr =msAzureConfig.getVariables(otherRemoteAgent+"^#^"+tenantId+"^#^"+tenantName);
							if (subscriptionWithNickArr != null && subscriptionWithNickArr.length > 0)
							{
								int tmpLen = subscriptionWithNickArr.length;
								for (int d=0; d<tmpLen; d++)
								{
									ArrayList tempList = null;
									String subscriptionWithNick = subscriptionWithNickArr[d];
									String subscriptionId = subscriptionWithNick.substring(0, subscriptionWithNick.indexOf("^#^"));
									String nickNameStr = subscriptionWithNick.substring(subscriptionWithNick.indexOf("^#^")+3);
									if (selectedCompList != null && selectedCompList.contains(nickNameStr))
									{
										String subscriptionDetail = msAzureConfig.getValue(otherRemoteAgent+"^#^"+tenantId+"^#^"+tenantName,subscriptionWithNick);
										tempList = new ArrayList();
										tempList.add(otherRemoteAgent);
										tempList.add(tenantId);
										tempList.add(tenantName);
										tempList.add(subscriptionWithNick);
										tempList.add(subscriptionDetail);
										compToModifyList.add(tempList);
									}
								}
							}
						}
					}
				}
			}
			
			if (compToModifyList != null && compToModifyList.size() > 0)
			{
				IniFile msAzureConfigWrt = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_msazureconfig.ini");
				int size = compToModifyList.size();
				for (int l=0; l<size; l++)
				{
					ArrayList selectedList = (ArrayList) compToModifyList.get(l);
					String remoteAgent = (String) selectedList.get(0);
					String tenantId = (String) selectedList.get(1);
					String tenantName = (String) selectedList.get(2);
					String subscriptionWithNick= (String) selectedList.get(3);
					String subscriptionDetail = (String) selectedList.get(4);
					
					String tenantNameStr = msAzureConfigWrt.getValue(selectedRemAgent,tenantId);
					if (!StringUtils.isNull(tenantNameStr))
					{
						ArrayList tenantNameList = new ArrayList(Arrays.asList(StringUtils.getTokens(tenantNameStr,"^#^")));
						if (!tenantNameList.contains(tenantName))
						{
							tenantNameStr += "^#^"+tenantName;
						}
					}
					else
					{
						tenantNameStr = tenantName;
					}
					msAzureConfigWrt.setValue(selectedRemAgent, tenantId, tenantNameStr);
					msAzureConfigWrt.setValue(selectedRemAgent+"^#^"+tenantId+"^#^"+tenantName, subscriptionWithNick, subscriptionDetail);
					
					String[] subscriptionArr =  msAzureConfigWrt.getVariables(otherRemoteAgent+"^#^"+tenantId+"^#^"+tenantName);
					if (subscriptionArr != null && subscriptionArr.length > 0)
					{
						int subscriptionLen = subscriptionArr.length;
						msAzureConfigWrt.deleteValue(otherRemoteAgent+"^#^"+tenantId+"^#^"+tenantName,subscriptionWithNick);
						if (subscriptionLen == 1)
						{
							String tenantNames = msAzureConfigWrt.getValue(otherRemoteAgent,tenantId);
							if (tenantNames != null && tenantNames.length() > 0)
							{
								ArrayList tenantNamesList = new ArrayList(Arrays.asList(StringUtils.getTokens(tenantNames,"^#^")));
								int tenantSize = tenantNamesList.size();
								if (tenantSize == 1)
								{
									msAzureConfigWrt.deleteValue(otherRemoteAgent, tenantId);
								}
								else
								{
									String remTenantName = "";
									for (int j=0; j<tenantSize; j++)
									{
										String tempTenantName = (String) tenantNamesList.get(j);
										if (!tempTenantName.equals(tenantName))
										{
											remTenantName += "^#^"+tempTenantName;
										}
									}
									
									if (!StringUtils.isNull(remTenantName))
									{
										remTenantName = remTenantName.substring(remTenantName.indexOf("^#^")+3);
									}
									msAzureConfigWrt.setValue(otherRemoteAgent, tenantId, remTenantName);
								}
							}
						}
					}
				}
				msAzureConfigWrt.saveFile();
				EgConfigFilesSync.releaseInstance(msAzureConfigWrt);	
			}
		}
	}
	else
	{
		servicer.startDiscovery("1");

		rootJson.put("requestStatus","failed");
		JSONObject errorMsg = new JSONObject();
		errorMsg.put("title",_mapping.getTextDescription("admin.common.Remote Agents Configuration"));
		errorMsg.put("message1",_mapping.getTextDescription("admin.common.The association/disassociation of hosts could not be completed")+".");
		rootJson.put("error",errorMsg);
	}
	EgConfigFilesSync.releaseInstance(infraIni);
	rootJson.put("success","true");
	out.println(rootJson.toString());
%>

<%!
	public boolean checkContainsAnyNicks(Vector nickList, ArrayList newList)
	{
		boolean result = false;
		if (nickList == null || newList == null)
		{
			return result;
		}
		nickList = getRefinedNicks(nickList);
		for (int i=0; i<newList.size(); i++)
		{
			String agentNick = newList.get(i).toString().trim();
			if (!nickList.contains(agentNick))
			{
				continue;
			}
			else
			{
				result = true;
				break;
			}
		}
		return result;
	}

	public Vector getRefinedNicks(Vector nickList)
	{
		Vector result = new Vector();
		if(nickList != null)
		{
			for(int n=0; n<nickList.size(); n++)
			{
				String nickName = (String)nickList.get(n);
				int pos = nickName.indexOf(":");
				if(pos > 0)
				{
					nickName = nickName.substring(0,pos);
				}
				if(!result.contains(nickName))
				{
					result.add(nickName);
				}
			}
		}
		return result;
	}
%>



