<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "egurkha.TransactionBean"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.eg.EgCrypt"%>
<%@ page import = "java.io.File"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
/*
*	Processing page for Advance Settings node in Manager Settings tree.
*	ini File : eg_service.ini, subject : MISC_ARGS
*/
%>

<%
	response.setContentType("application/json");
	JSONObject rootJson = new JSONObject();
	try
	{

		TransactionBean transBean = new TransactionBean();
		transBean.createSyncFile("eg_services.ini","Write");
	
		String subject = "MOBILE_APP_SETTINGS";
		String displayName = "";
		boolean isAuditChange = false;

		String prevRestrictMobileAppAccess = transBean.getStrValue(subject,"restrictMobileAppAccess");
		String prevEnablePushNotification = transBean.getStrValue(subject,"enablePushNotification");
		String prevUseProxyforPushGW = transBean.getStrValue(subject,"useProxyforPushGW");
		String prevProxyHost = transBean.getStrValue(subject,"proxyHost");
		String prevProxyPort = transBean.getStrValue(subject,"proxyPort");
		String prevProxyAuthentication = transBean.getStrValue(subject,"proxyAuthentication");
		String prevProxyUserName = transBean.getStrValue(subject,"proxyUserName");
		String prevProxyPassword = transBean.getStrValue(subject,"proxyPassword");
		String prevEnableMobileAccessLog = transBean.getStrValue(subject,"enableMobileAccessLog");
		String prevEnablePushNotificationLog = transBean.getStrValue(subject,"enablePushNotificationLog");
		String prevMobilelogMaxSize = transBean.getStrValue(subject,"mobilelogMaxSize");
		String prevMobilelogMaxFiles = transBean.getStrValue(subject,"mobilelogMaxFiles");

		String restrictMobileAppAccess = request.getParameter("restrictMobileAppAccess");
		String enablePushNotification = request.getParameter("enablePushNotification");
		String useProxyforPushGW = request.getParameter("useProxyforPushGW");
		String proxyHost = request.getParameter("proxyHost");
		String proxyPort = request.getParameter("proxyPort");
		String proxyAuthentication = request.getParameter("proxyAuthentication");
		String proxyUserName = request.getParameter("proxyUserName");
		String proxyPassword = request.getParameter("proxyPassword");
		String enableMobileAccessLog = request.getParameter("enableMobileAccessLog");
		String enablePushNotificationLog = request.getParameter("enablePushNotificationLog");
		String mobilelogMaxSize = request.getParameter("mobilelogMaxSize");
		String mobilelogMaxFiles = request.getParameter("mobilelogMaxFiles");

		restrictMobileAppAccess=StringUtils.decodeSecurityChar(restrictMobileAppAccess);
		enablePushNotification=StringUtils.decodeSecurityChar(enablePushNotification);
		useProxyforPushGW=StringUtils.decodeSecurityChar(useProxyforPushGW);
		proxyHost=StringUtils.decodeSecurityChar(proxyHost);
		proxyPort=StringUtils.decodeSecurityChar(proxyPort);
		proxyAuthentication=StringUtils.decodeSecurityChar(proxyAuthentication);
		proxyUserName=StringUtils.decodeSecurityChar(proxyUserName);
		proxyPassword=StringUtils.decodeSecurityChar(proxyPassword);
		enableMobileAccessLog=StringUtils.decodeSecurityChar(enableMobileAccessLog);
		enablePushNotificationLog=StringUtils.decodeSecurityChar(enablePushNotificationLog);
		mobilelogMaxSize=StringUtils.decodeSecurityChar(mobilelogMaxSize);
		mobilelogMaxFiles=StringUtils.decodeSecurityChar(mobilelogMaxFiles);

		AuditLogThread auditLogThread = new AuditLogThread();
		auditLogThread.setValue("Category","Admin");
		auditLogThread.setValue("User_id",_user.getLoginID());
		auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
		auditLogThread.setValue("Session_id",session.getId());
		auditLogThread.setValue("Module","Manager Settings");
		auditLogThread.setValue("Activity","Configure");

		int count=0;

		if (prevRestrictMobileAppAccess.trim().length() == 0)
		{
			prevRestrictMobileAppAccess = "-";
		}
		if (prevEnablePushNotification.trim().length() == 0)
		{
			prevEnablePushNotification = "-";
		}
		if (prevProxyHost.trim().length() == 0)
		{
			prevProxyHost = "-";
		}
		if (prevProxyPort.trim().length() == 0)
		{
			prevProxyPort = "-";
		}
		if (prevProxyAuthentication.trim().length() == 0)
		{
			prevProxyAuthentication = "-";
		}
		if (prevProxyUserName.trim().length() == 0)
		{
			prevProxyUserName = "-";
		}
		if (prevProxyPassword.trim().length() == 0)
		{
			prevProxyPassword = "-";
		}
		else
		{
			prevProxyPassword=EgCrypt.decrypt(prevProxyPassword);
		}
		if (prevEnableMobileAccessLog.trim().length() == 0)
		{
			prevEnableMobileAccessLog = "-";
		}
		if (prevEnablePushNotificationLog.trim().length() == 0)
		{
			prevEnablePushNotificationLog = "-";
		}
		if (prevMobilelogMaxSize.trim().length() == 0)
		{
			prevMobilelogMaxSize = "-";
		}
		if (prevMobilelogMaxFiles.trim().length() == 0)
		{
			prevMobilelogMaxFiles = "-";
		}

		if(proxyPort==null)
		{
			proxyPort="";
		}

		if (!prevRestrictMobileAppAccess.equalsIgnoreCase(restrictMobileAppAccess))
		{
			displayName = "Restrict Mobile Application Access";
			isAuditChange = true;
			auditLogThread.setPreviousValue(displayName,prevRestrictMobileAppAccess);
			auditLogThread.setCurrentValue(displayName,restrictMobileAppAccess);
			count++;
		}
		if (!prevEnablePushNotification.equalsIgnoreCase(enablePushNotification))
		{
			displayName = "Enable Push Notification";
			isAuditChange = true;
			auditLogThread.setPreviousValue(displayName,prevEnablePushNotification);
			auditLogThread.setCurrentValue(displayName,enablePushNotification);
			count++;
		}
		if (!prevUseProxyforPushGW.equalsIgnoreCase(useProxyforPushGW))
		{
			displayName = "Enable Proxy";
			isAuditChange = true;
			auditLogThread.setPreviousValue(displayName,prevUseProxyforPushGW);
			auditLogThread.setCurrentValue(displayName,useProxyforPushGW);
			count++;
		}
		if (!prevProxyHost.equalsIgnoreCase(proxyHost) && !StringUtils.isNull(proxyHost))
		{
			displayName = "Proxy Host";
			isAuditChange = true;
			auditLogThread.setPreviousValue(displayName,prevProxyHost);
			auditLogThread.setCurrentValue(displayName,proxyHost);
			count++;
		}
		if (!prevProxyPort.equalsIgnoreCase(proxyPort) && !StringUtils.isNull(proxyPort))
		{
			displayName = "Proxy Port";
			isAuditChange = true;
			auditLogThread.setPreviousValue(displayName,prevProxyPort);
			auditLogThread.setCurrentValue(displayName,proxyPort);
			count++;
		}
		if (!prevProxyAuthentication.equalsIgnoreCase(proxyAuthentication))
		{
			displayName = "Enable Proxy Authentication";
			isAuditChange = true;
			auditLogThread.setPreviousValue(displayName,prevProxyAuthentication);
			auditLogThread.setCurrentValue(displayName,proxyAuthentication);
			count++;
		}
		if (!prevProxyUserName.equalsIgnoreCase(proxyUserName) && !StringUtils.isNull(proxyUserName))
		{
			displayName = "Proxy User name";
			isAuditChange = true;
			auditLogThread.setPreviousValue(displayName,prevProxyUserName);
			auditLogThread.setCurrentValue(displayName,proxyUserName);
			count++;
		}
		if (!prevProxyPassword.equalsIgnoreCase(proxyPassword) && !StringUtils.isNull(proxyPassword))
		{
			displayName = "Proxy Password";
			isAuditChange = true;
			String encodePrevPassword=prevProxyPassword;
			if(!prevProxyPassword.equalsIgnoreCase("-"))
				encodePrevPassword = EgCrypt.encrypt(prevProxyPassword);

			auditLogThread.setPreviousValue(displayName,encodePrevPassword);
			auditLogThread.setCurrentValue(displayName,EgCrypt.encrypt(proxyPassword));
			count++;
		}
		if (!prevEnableMobileAccessLog.equalsIgnoreCase(enableMobileAccessLog))
		{
			displayName = "Enable Mobile API Log";
			isAuditChange = true;
			auditLogThread.setPreviousValue(displayName,prevEnableMobileAccessLog);
			auditLogThread.setCurrentValue(displayName,enableMobileAccessLog);
			count++;
		}
		if (!prevEnablePushNotificationLog.equalsIgnoreCase(enablePushNotificationLog))
		{
			displayName = "Enable Push Notification Log";
			isAuditChange = true;
			auditLogThread.setPreviousValue(displayName,prevEnableMobileAccessLog);
			auditLogThread.setCurrentValue(displayName,enablePushNotificationLog);
			count++;
		}
		if (!prevMobilelogMaxSize.equalsIgnoreCase(mobilelogMaxSize))
		{
			displayName = "Log file maximum size(MB)";
			isAuditChange = true;
			auditLogThread.setPreviousValue(displayName,prevMobilelogMaxSize);
			auditLogThread.setCurrentValue(displayName,mobilelogMaxSize);
			count++;
		}
		if (!prevMobilelogMaxFiles.equalsIgnoreCase(mobilelogMaxFiles))
		{
			displayName = "Number of log files allowed";
			isAuditChange = true;
			auditLogThread.setPreviousValue(displayName,prevMobilelogMaxFiles);
			auditLogThread.setCurrentValue(displayName,mobilelogMaxFiles);
			count++;
		}

		if (proxyPassword.trim().length()>0)
		{
			proxyPassword=EgCrypt.encrypt(proxyPassword);
		}

		transBean.setValue(subject,"restrictMobileAppAccess",restrictMobileAppAccess);
		transBean.setValue(subject,"enablePushNotification",enablePushNotification);
		transBean.setValue(subject,"useProxyforPushGW",useProxyforPushGW);
		transBean.setValue(subject,"proxyHost",proxyHost);
		transBean.setValue(subject,"proxyPort",proxyPort);
		transBean.setValue(subject,"proxyAuthentication",proxyAuthentication);
		transBean.setValue(subject,"proxyUserName",proxyUserName);
		transBean.setValue(subject,"proxyPassword",proxyPassword);
		transBean.setValue(subject,"enableMobileAccessLog",enableMobileAccessLog);
		transBean.setValue(subject,"enablePushNotificationLog",enablePushNotificationLog);
		transBean.setValue(subject,"mobilelogMaxSize",mobilelogMaxSize);
		transBean.setValue(subject,"mobilelogMaxFiles",mobilelogMaxFiles);

		if(count>0)
		{
			auditLogThread.setValue("Description","Mobile Application settings have been configured successfully");
			auditLogThread.sendItToDB();
		}
		transBean.saveFileAndReleaseInstance();

	}
	catch(Exception e)
		{
			e.printStackTrace();
		}
		rootJson.put("success","true");
		out.println(rootJson.toString());
	
%>





