<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "egurkha.TransactionBean"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
/*
*	Processing page for Account Lockout node in Manager Settings tree.
*	ini File : eg_services.ini, subject : MISC
*/
%>

<%
	response.setContentType("application/json");

	JSONObject rootJson = new JSONObject();

	TransactionBean transBeanService = new TransactionBean();
	TransactionBean transBeanAccLock = new TransactionBean();

	transBeanService.createSyncFile("eg_services.ini","Write");
	transBeanAccLock.createSyncFile("eg_acclock.ini","Write");

	String miscArgs = "MISC_ARGS";
	String strALS = "ALS";

	String[] keys = {"nofAttmpt","timeperiod","msgTypeRadio","lckStrategyRadio","lckTypeRadio"};

	ArrayList keysList = new ArrayList(java.util.Arrays.asList(keys));

	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Manager Settings");
	auditLogThread.setValue("Activity","Account Lockout");

	int count = 0;
	boolean setAuditLog = false;
	boolean isAccLockEnabled = false;
	String accLockValue = request.getParameter("lckTypeRadio");
	if(!com.egurkha.util.StringUtils.isNull(accLockValue) && (accLockValue.equalsIgnoreCase("yes") || accLockValue.equalsIgnoreCase("true")))
	{
		isAccLockEnabled = true;
	}

	Enumeration enumeration = request.getParameterNames();
	while(enumeration.hasMoreElements())
	{
		String variable = ((String) enumeration.nextElement()).toString();
		String value = request.getParameter(variable);
		if(variable.startsWith("$"))
		{
			setAuditLog = false;
			if(value != null && value.length() > 0 && value.indexOf("$") > -1)
			{
				StringTokenizer st = new StringTokenizer(value,"$");
				if(st.countTokens() == 2)
				{
					String displayName = st.nextToken();
					String displayValue = st.nextToken();
					String currentValue = "";
					if(displayValue != null && displayValue.length() > 0)
					{
						if(variable.equals("$_msgTypeRadio"))
						{
							currentValue = request.getParameter("msgTypeRadio");
							if(currentValue.equalsIgnoreCase("G"))
								currentValue = "Generic";
							else
								currentValue = "Specific";
							if(!displayValue.equalsIgnoreCase(currentValue))
							{
								setAuditLog = true;
								count++;
							}
						}
						else if(isAccLockEnabled && variable.equals("$_timeperiod"))
						{
							currentValue = request.getParameter("timeperiod");
							if(!com.egurkha.util.StringUtils.isNull(currentValue) && !displayValue.equalsIgnoreCase(currentValue))
							{
								setAuditLog = true;
								count++;
							}
						}
						else if(isAccLockEnabled && variable.equals("$_lckStrategyRadio"))
						{
							currentValue = request.getParameter("lckStrategyRadio");
							if(currentValue.equalsIgnoreCase("R"))
								currentValue = "Reset";
							else
								currentValue = "Time";
							if(!displayValue.equalsIgnoreCase(currentValue))
							{
								setAuditLog = true;
								count++;
							}
						}
						else if(variable.equals("$_lckTypeRadio"))
						{
							currentValue = request.getParameter("lckTypeRadio");
							if(!displayValue.equalsIgnoreCase(currentValue))
							{
								setAuditLog = true;
								count++;
							}
						}
						else if(isAccLockEnabled && variable.equals("$_nofAttmpt"))
						{
							currentValue = request.getParameter("nofAttmpt");
							if (!com.egurkha.util.StringUtils.isNull(currentValue) && !displayValue.equalsIgnoreCase(currentValue))
							{
								setAuditLog = true;
								count++;
							}
						}
						if(setAuditLog)
						{
							auditLogThread.setPreviousValue(displayName,displayValue);
							auditLogThread.setCurrentValue(displayName,currentValue);
						}
					}
				}
			}
		}
		if(variable.startsWith("$") || !keysList.contains(variable))
			continue;
		if(variable.equals("msgTypeRadio"))
			transBeanService.setValue(miscArgs,"InvalidLoginMsg",value);
		else if(variable.equals("lckTypeRadio"))
			transBeanAccLock.setValue(strALS,"AL",value);
		else if(isAccLockEnabled && variable.equals("nofAttmpt"))
		{
			if (!com.egurkha.util.StringUtils.isNull(value))
			{
				transBeanAccLock.setValue(strALS,"NA",value);
			}
		}
		else if(isAccLockEnabled && variable.equals("lckStrategyRadio"))
			transBeanAccLock.setValue(strALS,"LS",value);
		else if(isAccLockEnabled && variable.equals("timeperiod"))
		{
			if (!com.egurkha.util.StringUtils.isNull(value))
			{
				transBeanAccLock.setValue(strALS,"TP",value);
			}
		}
	}
	if(count > 0)
	{
		auditLogThread.setValue("Description","Manager settings have been configured successfully");
		auditLogThread.sendItToDB();
	}
	transBeanService.saveFileAndReleaseInstance();
	transBeanAccLock.saveFileAndReleaseInstance();

	// getting updated values to refill the JSON object
	String iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/"; 
	IniFile serviceIni = new IniFile(iniFile_dir+"eg_services.ini");
	IniFile accLckIni = new IniFile(iniFile_dir+"eg_acclock.ini");

	String InvalidLoginMsg = serviceIni.getValue(miscArgs,"InvalidLoginMsg");
	String userAL = accLckIni.getValue(strALS,"AL");
	String userNA = accLckIni.getValue(strALS,"NA");
	String userLS = accLckIni.getValue(strALS,"LS");
	String userTP = accLckIni.getValue(strALS,"TP");

	InvalidLoginMsg = (InvalidLoginMsg != null && InvalidLoginMsg.length() > 0) ? InvalidLoginMsg : "Specific";
	userAL = (userAL != null && userAL.length() > 0) ? userAL : "yes";
	userNA = (userNA != null && userNA.length() > 0) ? userNA : "3";
	userLS = (userLS != null && userLS.length() > 0) ? userLS : "Reset";
	userTP = (userTP != null && userTP.length() > 0) ? userTP : "30";

	rootJson.put("InvalidLoginMsg",InvalidLoginMsg);
	rootJson.put("userAL",userAL);
	rootJson.put("userNA",userNA);
	rootJson.put("userLS",userLS);
	rootJson.put("userTP",userTP);

	rootJson.put("success","true");
	out.println(rootJson.toString());
%>




