<%
/**
 *  File         : 	EgDefault.jsp
 *  Purpose      : 	To get the default thresholds for a particular test 
 *  Version      : 	0.1
 *  Creation Date: 	21/11/2000
 *  Last Modified:	
 *		25/03/2006	Thirumal Azhagan - UI changes for MIX policy.
 *		23/07/2004	Arun	Allows factors of SQC to be set for relative thresholds
 *		21/07/2004	Arun	Optimise use of EgThresholdInfo, allows SQC to have factors
		11/12/2003 //Saravanan - Medium priority Added for Single thresholds
		28/10/2003 //Saravanan - Multiple threshold changes
		30/11/2001  - 	Bharath G Display of server type 
		18/06/2001 //Sandhya - To check for space in absolute values.	
		12/06/2001 kk to check validity of numbers.
		21/12/2000 
 *  Author       :	Lavanya.T.K 
 *	Design Changes	:	Jaiwin
 */
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="java.sql.*" %>
<%@ page import="java.util.*" %>
<%@ page import="java.lang.*" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.EgThresholdInfo" %>
<%@ page import="com.eg.EgTesterInfo" %>
<%@ page import="com.egurkha.ini.*" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="com.egurkha.util.StringUtils" %>
<%@ page import="net.sf.json.*"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");

%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	JSONObject rootJson = new JSONObject(); 
	JSONObject hiddenObj = new JSONObject(); 
	JSONObject screenLabels = new JSONObject(); 
	JSONObject measureDataObj = new JSONObject();
	JSONObject resultObj = new JSONObject();
	
	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}
	String loginId = _user.getLoginID();
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	String pg = request.getParameter("page");
	String backUrl = null;
	String updateParam = "";
	if (pg == null)
		backUrl="Javascript:call()";
	else
	{
		updateParam = "EgUDTest.jsp";
		backUrl="EgUDTest.jsp";
	}

	String testName = request.getParameter("t_name");
	String q_ctr=request.getParameter("qctr");
	String serverName=request.getParameter("server");
	session.setAttribute("server",serverName);
	com.eg.IniFile servicesIniFile = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
	String updateDefaultThreshToDb = servicesIniFile.getValue("MISC_ARGS","updateDefaultThreshToDb");

	hiddenObj.put("agg_test_name",request.getParameter("t_name"));
	hiddenObj.put("normalTestName",request.getParameter("normalTestName"));
	hiddenObj.put("updateparam",updateParam);

	String[] hostTests = egSpecs.getDefaultTestsForServer("Host_system");
	ArrayList hostTestsList = new ArrayList();
	ArrayList sessListHostLevelTests = new ArrayList();
	if (hostTests != null)
	{
		hostTestsList = new ArrayList(Arrays.asList(hostTests));
		sessListHostLevelTests = new ArrayList(hostTestsList);
	}
	if (hostTestsList.contains(testName))
	{
		rootJson.put("hosttest_title","* "+_mapping.getTextDescription("admin.threshold.Changes made to default thresholds will be applied to all component types to which this test is mapped"));

	}
		if(pg != null)
		{
			rootJson.put("tableTitle",_mapping.getTextDescription("admin.threshold.Default thresholds of")+" "+_mapping.getTestDescription(testName));
		}
		else
		{
			//if(egSpecs.isPortRelevantForTest(testName))
			if(!hostTestsList.contains(testName))
			{
				rootJson.put("tableTitle",_mapping.getTextDescription("admin.threshold.Default thresholds of")+" <b>"+_mapping.getTestDescription(testName)+"</b> &nbsp;"+_mapping.getTextDescription("admin.common.for")+"&nbsp;<b>"+_mapping.getComponentTypeDescription(serverName)+"</b>");
			}
			else
			{
				rootJson.put("tableTitle",_mapping.getTextDescription("admin.threshold.Default thresholds of")+" <b>"+_mapping.getTestDescription(testName)+"</b> &nbsp;"+_mapping.getTextDescription("admin.common.for")+"&nbsp;<b>"+_mapping.getTextDescription("admin.threshold.Operating System")+"</b>");
			}
		}

	com.eg.IniFile defaultIni = new com.eg.IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_thresholds.ini");
	if (!StringUtils.isNull(testName))
	{
		String defaultThreshold = defaultIni.getValue("DEFAULT_THRESHOLDS",testName);
		boolean heading_flag = false;
		ArrayList aListTestWithNoThresholds = new ArrayList();
		boolean cellFlag = false;
		StringTokenizer st = new StringTokenizer(defaultThreshold,",");
		JSONArray measureValArr = new JSONArray();
		JSONObject hiddenDataObj = new JSONObject();
		while (st.hasMoreTokens())
		{
			hiddenObj.put("testName",testName);
			JSONObject threshTableObj = new JSONObject();
			String strTok = st.nextToken();
			StringTokenizer st1 = new StringTokenizer(strTok,":");
			while (st1.hasMoreTokens())
			{
				JSONObject threshValObj = new JSONObject();
				String measure = st1.nextToken();
				String policy = st1.nextToken();
				String min = st1.nextToken();
				String max = st1.nextToken();
				String alarmPolicy = st1.nextToken();
				threshValObj.put("AlarmPolicy",alarmPolicy);
				hiddenObj.put("alarmPolicy", alarmPolicy);
				hiddenObj.put("measure", measure);

				String lastToken = st1.nextToken();
				String unit = tablesInfo.getUnitForMeasure(testName,measure);

				String absMinCritical = "-";
				String relMinCritical = "-";

				String absMinMajor = "-";
				String relMinMajor = "-";

				String absMinMinor = "-";
				String relMinMinor = "-";

				String absMaxCritical = "-";
				String relMaxCritical = "-";

				String absMaxMajor = "-";
				String relMaxMajor = "-";

				String absMaxMinor = "-";
				String relMaxMinor = "-";

				if (policy.equalsIgnoreCase("none"))
				{
					policy = "mix";
				}
				else if (policy.equalsIgnoreCase("absolute"))
				{
					if (!min.equals("-1"))
					{
						StringTokenizer stAbsMin = new StringTokenizer(min,"/");
						absMinCritical = stAbsMin.nextToken();
						absMinMajor = stAbsMin.nextToken();
						absMinMinor = stAbsMin.nextToken();
					}

					if (!max.equals("-1"))
					{
						StringTokenizer stAbsMax = new StringTokenizer(max,"/");
						absMaxCritical = stAbsMax.nextToken();
						absMaxMajor = stAbsMax.nextToken();
						absMaxMinor = stAbsMax.nextToken();
					}
				}
				else if (policy.equalsIgnoreCase("relative"))
				{
					if (!min.equals("-1"))
					{
						StringTokenizer stRelMin = new StringTokenizer(min,"/");
						relMinCritical = stRelMin.nextToken();
						relMinMajor = stRelMin.nextToken();
						relMinMinor = stRelMin.nextToken();
					}

					if (!max.equals("-1"))
					{
						StringTokenizer stRelMax = new StringTokenizer(max,"/");
						relMaxCritical = stRelMax.nextToken();
						relMaxMajor = stRelMax.nextToken();
						relMaxMinor = stRelMax.nextToken();
					}
				}
				else if (policy.equalsIgnoreCase("mix"))
				{
					Vector vec = getAbsAndRel(min);
					String absA = (String) vec.get(0);
					String relA = (String) vec.get(1);
					Vector vec1 = getAbsAndRel(max);
					String absB = (String) vec1.get(0);
					String relB = (String) vec1.get(1);

					if (!absA.equals("none"))
					{
						StringTokenizer stmixMin = new StringTokenizer(absA,"/");
						absMinCritical = stmixMin.nextToken();
						absMinMajor = stmixMin.nextToken();
						absMinMinor = stmixMin.nextToken();
					}

					if (!absB.equals("none"))
					{
						StringTokenizer stmixMax = new StringTokenizer(absB,"/");
						absMaxCritical = stmixMax.nextToken();
						absMaxMajor = stmixMax.nextToken();
						absMaxMinor = stmixMax.nextToken();
					}

					if (!relA.equals("none"))
					{
						StringTokenizer stRelMin = new StringTokenizer(relA,"/");
						relMinCritical = stRelMin.nextToken();
						relMinMajor = stRelMin.nextToken();
						relMinMinor = stRelMin.nextToken();
					}

					if (!relB.equals("none"))
					{
						StringTokenizer stmixMax = new StringTokenizer(relB,"/");
						relMaxCritical = stmixMax.nextToken();
						relMaxMajor = stmixMax.nextToken();
						relMaxMinor = stmixMax.nextToken();
					}
				}

				hiddenObj.put("absMinCritical", absMinCritical);
				hiddenObj.put("relMinCritical", relMinCritical);
				hiddenObj.put("absMinMajor", absMinMajor);
				hiddenObj.put("relMinMajor", relMinMajor);
				hiddenObj.put("absMinMinor", absMinMinor);
				hiddenObj.put("relMinMinor", relMinMinor);
				hiddenObj.put("absMaxCritical", absMaxCritical);
				hiddenObj.put("relMaxCritical", relMaxCritical);
				hiddenObj.put("absMaxMajor", absMaxMajor);
				hiddenObj.put("relMaxMajor", relMaxMajor);
				hiddenObj.put("absMaxMinor", absMaxMinor);
				hiddenObj.put("relMaxMinor", relMaxMinor);
				hiddenDataObj.put(measure,hiddenObj);
				String minCritical = getThresholdValue("min",absMinCritical,relMinCritical);
				String minMajor = getThresholdValue("min",absMinMajor,relMinMajor);
				String minMinor = getThresholdValue("min",absMinMinor,relMinMinor);

				String maxCritical = getThresholdValue("max",absMaxCritical,relMaxCritical);
				String maxMajor = getThresholdValue("max",absMaxMajor,relMaxMajor);
				String maxMinor = getThresholdValue("max",absMaxMinor,relMaxMinor);

				if (minCritical.equals("-")  && minMajor.equals("-") && minMinor.equals("-") && 
				maxCritical.equals("-") && maxMajor.equals("-") && maxMinor.equals("-"))
				{
					aListTestWithNoThresholds.add(measure);
					cellFlag = !cellFlag;
					continue;
				}

				String tempThresh = "";
				boolean isMinData = false;
				if(!minCritical.equals("-")  || !minMajor.equals("-") || !minMinor.equals("-"))
				{
					tempThresh += "Min|"+minCritical+"|"+minMajor+"|"+minMinor;
					isMinData = true;
				}

				if(!maxCritical.equals("-") || !maxMajor.equals("-") || !maxMinor.equals("-"))
				{
					if (isMinData)
					{
						tempThresh += "#Max|"+maxCritical+"|"+maxMajor+"|"+maxMinor;
					}
					else
					{
						tempThresh += "Max|"+maxCritical+"|"+maxMajor+"|"+maxMinor;
					}
				}
				measureDataObj.put(mappingInfo.getMeasureDescription(testName,measure),measure);
				threshValObj.put("Measure",mappingInfo.getMeasureDescription(testName,measure)+"  ("+unit+")");
				threshValObj.put("Threshold",tempThresh);

			measureValArr.add(threshValObj);

			}
			cellFlag = !cellFlag;
		}
		rootJson.put("hiddenDataObj",hiddenDataObj);
		rootJson.put("measureValArr",measureValArr);

		if (aListTestWithNoThresholds != null && !aListTestWithNoThresholds.isEmpty())
		{
			JSONArray noMeasureValArr = new JSONArray();
			int d=0;
			while(d<aListTestWithNoThresholds.size())
			{
				JSONObject noMeasureThreshValObj = new JSONObject();
				String strMeasure1 = "";
				String strMeasure2 = "";
				String strMeasure = (String)aListTestWithNoThresholds.get(d);
				int count = d;
				if(!StringUtils.isNull(strMeasure))
				{
					measureDataObj.put(mappingInfo.getMeasureDescription(testName,strMeasure),strMeasure);
					strMeasure = mappingInfo.getMeasureDescription(testName,strMeasure);
				}
				else
					strMeasure = "";
				count = d+1;
				if(count < aListTestWithNoThresholds.size())
				{
					strMeasure1 = (String)aListTestWithNoThresholds.get(count);
					if(!StringUtils.isNull(strMeasure1))
					{
						measureDataObj.put(mappingInfo.getMeasureDescription(testName,strMeasure1),strMeasure1);
						strMeasure1 = mappingInfo.getMeasureDescription(testName,strMeasure1);
					}
				}
				count = d+2;
				if(count < aListTestWithNoThresholds.size())
				{
					strMeasure2 = (String)aListTestWithNoThresholds.get(count);
					if(!StringUtils.isNull(strMeasure2))
					{
						measureDataObj.put(mappingInfo.getMeasureDescription(testName,strMeasure2),strMeasure2);
						strMeasure2 = mappingInfo.getMeasureDescription(testName,strMeasure2);
					}
				}

				noMeasureThreshValObj.put("Measure1",strMeasure);
				noMeasureThreshValObj.put("Measure2",strMeasure1);
				noMeasureThreshValObj.put("Measure3",strMeasure2);
				noMeasureValArr.add(noMeasureThreshValObj);
				d = count+1;
			}
			rootJson.put("noMeasureValArr",noMeasureValArr);
		}
	}

	//if (request.getQueryString() != null)
		//session.setAttribute("adminLastAccessedURL","/final/admin/ICTest.jsp?"+request.getQueryString());
	session.setAttribute("sessListHostLevelTests",sessListHostLevelTests);

	rootJson.put("hiddenObj",hiddenObj);
	rootJson.put("measureDataObj",measureDataObj);
	rootJson.put("screenLabels",screenLabels);
	out.println(rootJson.toString());
%>

<%!
	// T.Thirumal Azhagan    3/7/2006
	public Vector getAbsAndRel(String format) // for mix format in threshold ,introduced by BOSS(MIX)
	{
		Vector vect = new Vector();	// [absolute,relative]
		StringTokenizer stok1 = new StringTokenizer(format,"/");
		if (!format.equals("-1") && stok1.countTokens() == 3)
		{
			String h;
			String m;
			String l;
			String H = stok1.nextToken();
			String M = stok1.nextToken();
			String L = stok1.nextToken();
			if (!(H.equals("-")))
			{
				if (H.indexOf("&") > -1)
				{
					StringTokenizer st = new StringTokenizer(H,"&");
					H = st.nextToken();
					h = st.nextToken();
				}else
				{
					if (H.indexOf("sqc") > -1)
					{
						h = H;
						H = "-";
					}else
						h = "-";
				}
			}else
			{
				h = "-";
			}
			if (!(M.equals("-")))
			{
				if (M.indexOf("&") > -1)
				{
					StringTokenizer st = new StringTokenizer(M,"&");
					M = st.nextToken();
					m = st.nextToken();
				}else
				{
					if (M.indexOf("sqc") > -1)
					{
						m = M;
						M = "-";
					}else
						m = "-";
				}
			}else
			{
				m = "-";
			}
			if (!(L.equals("-")))
			{
				if (L.indexOf("&") > -1)
				{
					StringTokenizer st = new StringTokenizer(L,"&");
					L = st.nextToken();
					l = st.nextToken();
				}else
				{
					if (L.indexOf("sqc") > -1)
					{
						l = L;
						L = "-";
					}else
						l = "-";
				}
			}else
			{
				l = "-";
			}
			StringBuffer sb2 = new StringBuffer();
			StringBuffer sb1 = new StringBuffer();
			String s1 = null;
			if (H.equals("-") && M.equals("-") && L.equals("-"))
			{
				s1 = "none";
			}else
			{
				sb1.append(H);
				sb1.append("/");
				sb1.append(M);
				sb1.append("/");
				sb1.append(L);
				s1 = sb1.toString();
			}
			String s2 = null;
			if (h.equals("-") && m.equals("-") && l.equals("-"))
			{
				vect.add(s1);
				vect.add("none");
			}else
			{
				sb2.append(h);
				sb2.append("/");
				sb2.append(m);
				sb2.append("/");
				sb2.append(l);
				s2 = sb2.toString();
				vect.add(s1);
				vect.add(s2);
			}
		}else
		{
			vect.add("none");
			vect.add("none");
		}
		return vect;
	}


		private String getThresholdValue(String grpFunction, String absValue,String relValue)
	{
		String strValue = "-";

		if (absValue.equals("-") && relValue.equals("-"))
		{
			strValue = "-";
		}
		else if (!absValue.equals("-") && !relValue.equals("-"))
		{
			strValue = grpFunction+"("+absValue+", "+getRelativeThreshold(relValue)+")";
		}
		else if (!absValue.equals("-"))
		{
			strValue = absValue;
		}
		else if (!relValue.equals("-"))
		{
			strValue = getRelativeThreshold(relValue);
		}

		return strValue;
	}

	private String getRelativeThreshold(String relValue)
	{
		//relValue: 3*sqc
		String strValue = "";
		if (relValue.indexOf("*") != -1)
		{
			int idx = relValue.indexOf("*");
			String s1 = relValue.substring(0,idx);
			double d_value = Double.valueOf(s1.trim()).doubleValue();
			d_value = d_value * 100;
			int i_value = (new Double(d_value)).intValue();
			strValue = Integer.toString(i_value) + "% of auto";
		}
		else
		{
			strValue = "auto";
		}
		return strValue;
	}
%>




