<%
/******************************************************************************
*		Process page for EgUnmanageServers.jsp
*
*       File name       :       Egunmanageserversp.jsp
*       Version         :       3.1.9
*       CreationDate    :       2/16/2006
*       Author          :       T.Thirumal Azhagan
*******************************************************************************/
%>
<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "com.eg.EgServerGroupBean" %>
<%@ page import = "com.eg.EgDiscInfo" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.eg.EgGroupInfo"%>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import="com.eg.DeleteMailFilterElements" %>
<%@ page import="com.eg.EgRoleInfo"%>
<%@ page import ="com.eg.EgConfigFilesSync"%>
<%@ page import = "com.eg.UpdateAndTransmitUserInfo" %>
<%@ page import = "com.eg.EgTopoInfo" %>
<%
     response.setHeader("Cache-Control","no-store");
     response.setHeader("Pragma","no-cache");
     response.setDateHeader("Expires", -1);
%>
<jsp:useBean id="manager" scope="request" class="egurkha.ConfigBean"/>
<!-- <jsp:useBean id="trans" scope="request" class="egurkha.TransactionBean"/> -->
<!-- <jsp:useBean id="trans1" scope="request" class="egurkha.TransactionBean"/> -->
<jsp:useBean id="user" scope="request" class="egurkha.UserBean"/>
<jsp:useBean id="servicer" scope="request" class="egurkha.ServiceBean"/>
<%
	manager.createFile("eg_services.ini");
	int compSize = Integer.parseInt(manager.getValue("MISC_ARGS","MaxManagedComponentsForDisc"));
	EgRoleInfo egRoleInfo = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	String[] sTypes = egRoleInfo.getServerTypes();
	boolean hasLimitExceeded=false;
	int count=0;
	if (sTypes != null && sTypes.length > 0)
	{
		for (int st=0;st<sTypes.length;st++)
		{
			String[] strComps = egRoleInfo.getAllServersOfType(sTypes[st]);
			if (strComps.length > 0)
			{
				count = count + strComps.length;
				if (count > compSize)
				{
					hasLimitExceeded = true;
					break;
				}
			}
		}
	}
	EgGroupInfo groupinfo = new EgGroupInfo();
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	String showOnly = request.getParameter("showOnly");
	String treeViewSrc = request.getParameter("treeViewSrc");
	if(showOnly == null || !showOnly.equals("aggregate_types"))
	{
		showOnly="non_aggregate_types";
	}
	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Manage/Unmanage");
	auditLogThread.setValue("Activity","Manage/Unmanage Systems");		
	/* code for auditlog ends */
	boolean removeUnmanage = false;	
	Vector sess_vec = new Vector();
	Vector v_servers = new Vector();
	Vector newUnmanServers = new Vector();
	Hashtable ht = new Hashtable();
	ArrayList threshList = new ArrayList();

	String s_res;
	Vector v_sites;

	String selectedNicks = request.getParameter("selectedNicks");
	if (selectedNicks != null && selectedNicks.length() > 0)
	{
		String[] tokens = StringUtils.getTokens(selectedNicks, ",");
		v_servers.addAll(Arrays.asList(tokens));
		ArrayList aggregateComponents = null;
		ArrayList unmanagedAggComponents = null;
		// change on 8 Feb 2008
		boolean zoneAssociated = false;
		boolean grpAssociated = false;
		String zoneDisplay = "";
		String grpDisplay = "";
		for(int inc=0; inc<v_servers.size(); inc++)
		{
			String compName = (String) v_servers.get(inc);
			String zoneStr = groupinfo.getZoneNameForComponent(compName);	
			String grpStr = groupinfo.getGroupNameForComponent(compName);
			if(zoneStr != null)
			{
				zoneDisplay = zoneStr;
				zoneAssociated = true;
				break;
			}
			if(grpStr != null)
			{
				grpDisplay = grpStr; 
				grpAssociated = true;
				break;
			}
		}

		if(zoneAssociated || grpAssociated)
		{
			String key = "";
			String tempDisplay = "";
			if(zoneAssociated){
				tempDisplay = zoneDisplay;
				key = "zone";
			}
			else if(grpAssociated){
				tempDisplay = grpDisplay;
				key = "group";
			}
			

			Vector ses_vec = new Vector();
			ses_vec.add(_mapping.getTextDescription("admin.error.Manage / Unmanage"));
			ses_vec.add("EgManageServers.jsp?backButton=true&showOnly="+showOnly);
			ses_vec.add(_mapping.getTextDescription("admin.error.Component(s) cannot be unmanaged")+".");
			ses_vec.add(_mapping.getTextDescription("admin.error.The selected component(s) is associated to the "+key)+":");
			ses_vec.add(tempDisplay);
			ses_vec.add(". "+_mapping.getTextDescription("admin.error.The component(s) can be unmanaged only after disassociate it from the "+key)+".");
			session.setAttribute("vec_Errors",ses_vec);
			/* code for auditlog starts */
			auditLogThread.setValue("Description","The component(s) can be unmanaged only after disassociate it from the "+key);
			if(zoneAssociated)
			{
				auditLogThread.setCurrentValue("Zone associated",zoneDisplay);
			}
			else if(grpAssociated)
				auditLogThread.setCurrentValue("Group associated",grpDisplay);
			auditLogThread.sendItToDB();
			/* code for auditlog ends */
%>
			<jsp:forward page="EgErrors.jsp" />
<%
		}
		//End

		s_res = manager.unmanageTopoServers(v_servers);
		v_sites = manager.unmanageIndServers(v_servers);
		if(s_res != null && s_res.length() > 0)
		{
			s_res = s_res.trim();
			String element = s_res.substring(0,s_res.indexOf(" contains"));
			sess_vec.add(_mapping.getTextDescription("admin.error.Manage / Unmanage"));
			sess_vec.add("EgManageServers.jsp?backButton=true"); 
			sess_vec.add(_mapping.getTextDescription("admin.error.Component(s) cannot be unmanaged")+".");
			sess_vec.add(_mapping.getTextDescription("admin.error.The selected component(s) is associated to the following")+" ");
			sess_vec.add(element+".");
			sess_vec.add(_mapping.getTextDescription("admin.error.The component(s) can be unmanaged only after deleting the segment(s) associated to it or removing the association of the component(s) from the segment(s)")+".");
			session.setAttribute("vec_Errors",sess_vec);
			/* code for auditlog starts */			
			auditLogThread.setCurrentValue("Segment Name(s)",s_res);
			auditLogThread.setValue("Description","Component(s) can not be unmanaged from the eG system as the components are present in the segments");
			auditLogThread.sendItToDB();
			/* code for auditlog ends */			
			%>
			<jsp:forward page="EgErrors.jsp" />
			<%
		}
		else if(v_sites.size() > 0)
		{
			sess_vec.add(_mapping.getTextDescription("admin.error.Manage / Unmanage"));
			sess_vec.add("EgManageServers.jsp?backButton=true&showOnly="+showOnly);
			sess_vec.add(_mapping.getTextDescription("admin.error.Component(s) cannot be unmanaged")+".");
			sess_vec.add(_mapping.getTextDescription("admin.error.The selected component(s) is associated to the following service(s)")+".");
			sess_vec.addAll(v_sites);
			sess_vec.add(_mapping.getTextDescription("admin.error.The component(s) can be unmanaged only after deleting the service(s) associated to it or removing the association of the component(s) from the service(s)")+".");
			session.setAttribute("vec_Errors",sess_vec);
			/* code for auditlog starts */			
			for(int i=0;i<v_sites.size();i++)
			auditLogThread.setCurrentValue("Service Name(s)",v_sites.get(i).toString());
			auditLogThread.setValue("Description","Component(s) can not be unmanaged from the eG system as the components are present in the service(s)");
			auditLogThread.sendItToDB();
			/* code for auditlog ends */			
			%>
			<jsp:forward page="EgErrors.jsp" />
			<%
		}
		else
		{
			servicer.stopDiscovery();

			//manager.createFileTopology("eg_topology.ini","save"); 
			//trans.createFile("eg_disable.ini","save");
			//trans1.createFile("eg_testinfo.ini","save");
			manager.createSyncFile("eg_discover.ini","save");

			String temp;
			String s_type;
			String s_compWithPort;
 			String nick = (String) session.getAttribute("_nick");
			TreeMap cn = (TreeMap) session.getAttribute("nicks");
			Hashtable e = (Hashtable) cn.get(nick);
			StringTokenizer _ss = null;
			for (int i=0;i<v_servers.size();i++)
			{
				temp = (String) v_servers.get(i);
				_ss = new StringTokenizer(temp,":");
				String _serv = _ss.nextToken();
				_ss.nextToken();
				String _port = _ss.nextToken();
				String tmp = _serv+"#"+_port;
				if (e.containsKey(tmp))
					e.remove(tmp);
				s_type = (temp.substring(0,temp.indexOf(":"))).trim();
				s_compWithPort = (temp.substring(temp.indexOf(":")+1)).trim();
				threshList.add(s_compWithPort);
				manager.setSrvrUnm(s_type,s_compWithPort);
				removeUnmanage = manager.removeUnmanage(s_type,s_compWithPort);
					//To UnManage Aggregate Components
				//if(s_type!=null &&s_compWithPort!=null && s_type.startsWith("Agg_"))
				//	aggregateInfo.unmanageAggregateComponent(s_type+":"+s_compWithPort);
				/* code for auditlog starts */			
				auditLogThread.setCurrentValue("$ctype$:"+s_type,s_compWithPort);
				/* code for auditlog ends */			
			}
			manager.saveFile();
			manager.releaseInstance();
			
			if(threshList != null && threshList.size() >0)
			{
				EgServerGroupBean descGrp = new EgServerGroupBean();

				for(int g=0; g<threshList.size(); g++)
				{
					String serverName = Server.getServerNameWithoutPort((String)threshList.get(g));
					List arr = discInfo.getServerTypesForNick(serverName);
					if(arr.size() > 0)
						continue;
					String str = (String)threshList.get(g);
					user.deleteSpecificThresholds(str);
					descGrp.deleteUnmanagedComponentFromInfoGroup(str);
				}
				//descGrp.saveFile();
			}

			UserRegistry userRegistry = UserRegistry.getInstance();
			userRegistry.updateAllUserMaps();
		
			//manager.saveFileTopology();

			//mail filter - start
			DeleteMailFilterElements delMailFilterElements = new DeleteMailFilterElements();
			delMailFilterElements.removeElementsFromMailFilter(null,v_servers);
			//end
			if(showOnly != null && showOnly.equals("aggregate_types"))
			{
				sess_vec.removeAllElements();
				sess_vec.addElement(_mapping.getTextDescription("admin.server.Unmanage Aggregate Component"));
				sess_vec.addElement("EgManageServers.jsp?backButton=true&showOnly="+showOnly);
				sess_vec.addElement(_mapping.getTextDescription("admin.server.Unmanage Aggregate Component"));
				sess_vec.addElement(_mapping.getTextDescription("admin.server.Aggregate component(s) unmanaged successfully from the eG system")+".");
			}
			else
			{
				sess_vec.removeAllElements();
				sess_vec.addElement(_mapping.getTextDescription("admin.server.Unmanage Component"));
				if(!StringUtils.isNull(treeViewSrc))
				{
					sess_vec.addElement("EgManageServers.jsp?backButton=true&treeViewSrc="+treeViewSrc);
				}
				else 
					sess_vec.addElement("EgManageServers.jsp?backButton=true");

				sess_vec.addElement(_mapping.getTextDescription("admin.server.Unmanage Component"));
				sess_vec.addElement(_mapping.getTextDescription("admin.server.Component(s) unmanaged successfully from the eG system")+".");
			}
			session.putValue("vec_Results",sess_vec);
			/* code for auditlog starts */
			auditLogThread.setValue("Description","Component(s) unmanaged from the eG system");
			auditLogThread.sendItToDB();
			/* code for auditlog ends */
			// don't remove , its redirect the session
			session.setAttribute("adminLastAccessedURL","/final/admin/EgManageServers.jsp?backButton=true&showOnly="+showOnly);

			if (hasLimitExceeded)
			{
				servicer.startDiscovery("1");
			}
			else
			{
				servicer.startDiscovery("1",true);
			}
			String tempUrl="EgResults.jsp";
			if(!StringUtils.isNull(treeViewSrc))
			{
				tempUrl="EgResults.jsp?from=ManUnMan";
			}
%>

			<jsp:forward page='<%=tempUrl%>' />
<%
		}
	}
%>