<%
/*************************************************************************************************/
/*                 Name          : EgTopologyMainPage.jsp                                        */
/*                 Purpose       : This is the main page for Auto Topology Generation            */
/*                 Version       : 5.4                                                           */
/*                 Created On    : 05-08-2011                                                    */
/*************************************************************************************************/
%>
<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ taglib prefix ="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>
<%
try
{
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	boolean isMSIE6 = ( ua != null && ua.indexOf( "MSIE 6.0" ) != -1 );

	String zone = request.getParameter("zone");
	String segment = request.getParameter("segment");
	String loginID = _user.getLoginID();

	//Delete Previous INCOMPLETE_SEGMENT if any exists"
	String INCOMPLETE_SEGMENT = "INCOMPLETE_SEGMENT";
	String SESSION_DETAILS = "SESSION_DETAILS";
	String iniFileName = EgInstallInfo.getInstallDir()+"/manager/config/eg_autotopology.ini";
	IniFile autoTopoIni  = EgConfigFilesSync.getInstance(iniFileName,true);
	Vector sessionVariables = autoTopoIni.getVariables(SESSION_DETAILS, false);
	if(sessionVariables!=null && sessionVariables.size() > 0)
	{
		// Delete Previous invalid session details & its corresponding segments
		for(int k=0;k<sessionVariables.size();k++)
		{
			String thisVariable = (String) sessionVariables.get(k);
			boolean isValid = registry.isSessionValid(thisVariable);
			if(isValid)
				continue;

			String sessionValue = autoTopoIni.getValue(SESSION_DETAILS, thisVariable);
			autoTopoIni.deleteValue(SESSION_DETAILS, thisVariable);
			StringTokenizer myTokenizer = new StringTokenizer(sessionValue,",");
			while(myTokenizer.hasMoreTokens())
			{
				String thisToken = myTokenizer.nextToken();
				autoTopoIni.deleteValue(INCOMPLETE_SEGMENT, thisToken);
				autoTopoIni.deleteSubject(thisToken);
			}
		}
		autoTopoIni.saveFile();
	}
	//Check if the segment is already used by any other user, If "yes" Dn't allow 
	Vector varVec = autoTopoIni.getVariables(INCOMPLETE_SEGMENT, false);
	boolean proceed = false;
	if(varVec!=null && varVec.contains(segment))
	{
		String inCompleteValue = autoTopoIni.getValue(INCOMPLETE_SEGMENT, segment);
		String createdUser = inCompleteValue.substring(0,inCompleteValue.indexOf(":"));
		String createdSessId = inCompleteValue.substring(inCompleteValue.indexOf(":")+1);
		if(createdUser.equals(loginID) && createdSessId.equals(sessionID))
		{
			proceed = true;
		}
		else
		{
			proceed = false;
		}
	}
	else
	{
		String valueString = loginID+":"+sessionID;
		String previous_segment = autoTopoIni.getValue(SESSION_DETAILS,sessionID);
		if(previous_segment!=null && previous_segment.length() > 0)
		{
			previous_segment = previous_segment +","+segment;
			autoTopoIni.setValue(SESSION_DETAILS,sessionID,previous_segment);
		}
		else
		{
			autoTopoIni.setValue(SESSION_DETAILS,sessionID,segment);
		}
		autoTopoIni.setValue(INCOMPLETE_SEGMENT,segment,valueString);
		proceed = true;
	}
	autoTopoIni.saveFile();
	EgConfigFilesSync.releaseInstance(autoTopoIni);
	// To Remover Previous session entries
	session.removeAttribute("AllLinesInSegment");
	session.removeAttribute("sessionGroupTable");
	session.removeAttribute("GroupCompHashtable");
	session.removeAttribute("zoneLines");
	session.removeAttribute("THISSEGMENT");
	String from = request.getParameter("fromPage");
	if(from==null) from="";
	if(from!=null && from.equals("modifySegment"))
	{
		String iniFilePath= EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		
		String autoiniFileName = EgInstallInfo.getInstallDir()+"/manager/config/eg_autotopology.ini";
		IniFile autoTopoIni1  = EgConfigFilesSync.getInstance(autoiniFileName,true);
		
		String[] topoLines = iniFile.getLinesUnderSubject(segment);
		String[] autoTopoLines = autoTopoIni1.getLinesUnderSubject(segment);
		
		if(topoLines!=null && topoLines.length>0)
		{
			if(autoTopoLines==null)
			{			
				for(int k=0;k<topoLines.length;k++)
				{
					String line = topoLines[k];
					String lineVar = line.substring(0,line.indexOf("="));
					String lineVal = line.substring(line.indexOf("=")+1);
					autoTopoIni1.setValue(segment , lineVar , lineVal);
				}			
			}
			else if(autoTopoLines!=null && autoTopoLines.length>0)
			{
				autoTopoIni1.deleteSubject(segment);
				for(int k=0;k<topoLines.length;k++)
				{
					String line = topoLines[k];
					String lineVar = line.substring(0,line.indexOf("="));
					String lineVal = line.substring(line.indexOf("=")+1);
					autoTopoIni1.setValue(segment , lineVar , lineVal);
				}			
			}
			autoTopoIni1.saveFile();
		}
		EgConfigFilesSync.releaseInstance(autoTopoIni1);
	}
	
%>

<html>
<head>
<title>Create Auto Topology</title>
<egui:skin ui="admin"/>
<script  src="/final/jquery/jquery.js"></script>
<script  src="/final/jquery/ui/jquery.ui.core.js"></script>
<script  src="/final/jquery/ui/jquery.ui.widget.js"></script> 
<script  src="/final/jquery/ui/jquery.ui.mouse.js"></script>
<script  src="/final/jquery/ui/jquery.ui.draggable.js"></script>
<script  src="/final/jquery/ui/jquery.ui.resizable.js"></script>


<script type="text/javascript">

var $j = jQuery.noConflict();

$j(document).ready(function(){
	/*   JQuery Drag & Drop Functionality  (Begin)   */
	$j.globalVars = {
		maxHeight: $j(window).height(),
		maxWidth:  $j(window).width()
	};

	centerScreen('#userDiv');
	/*$j("#groupDiv").resizable({
		start: function(e, ui) {
			//alert('resizing started');
		},
		resize: function(e, ui) {
		},
		stop: function(e, ui) {
		//alert('resizing stopped');
		}
	});*/

	$j( "#groupDiv" ).draggable({ 
		cancel: "tr.ui-widget-header-temp",
		cursor: "move",
		scroll: false,
		containment: [-parseInt($j.globalVars.maxWidth),0, parseInt($j.globalVars.maxWidth), parseInt($j.globalVars.maxHeight)]
	});

	$j( "#connectDiv" ).draggable({ 
		cancel: "tr.ui-widget-header-temp",
		cursor: "move",
		scroll: false,
		containment: [-parseInt($j.globalVars.maxWidth),0, parseInt($j.globalVars.maxWidth), parseInt($j.globalVars.maxHeight)]
	});

	$j( "#manageDiv" ).draggable({ 
		cancel: "tr.ui-widget-header-temp",
		cursor: "move",
		scroll: false,
		containment: [-parseInt($j.globalVars.maxWidth),0, parseInt($j.globalVars.maxWidth), parseInt($j.globalVars.maxHeight)]
	});

	$j( "#manageAllDiv" ).draggable({ 
		cancel: "tr.ui-widget-header-temp",
		cursor: "move",
		scroll: false,
		containment: [-parseInt($j.globalVars.maxWidth),0, parseInt($j.globalVars.maxWidth), parseInt($j.globalVars.maxHeight)]
	});

	$j( "#settingsDiv" ).draggable({ 
		cancel: "tr.ui-widget-header-temp",
		cursor: "move",
		scroll: false,
		containment: [-parseInt($j.globalVars.maxWidth),0, parseInt($j.globalVars.maxWidth), parseInt($j.globalVars.maxHeight)]
	});
	/*   JQuery Drag & Drop Functionality  (End)   */
});

function ShowGroupDetails(gname)
{
	var href = 'EgTopologyGroupPage.jsp?title='+gname;
	var maxInd = maxIndex();
	$j("#groupDiv").css({"display":"block" , "position":"absolute" });
	$j("#groupDiv").css({"z-index":maxInd+1});
	$j("#groupDiv").show('slow');
	$j('#innerGroupDiv').load(href);
}

function maxIndex()
{
	var index_highest = 0;
	$j('div').each(function(){
		var index_current = parseInt($j(this).css("z-index"), 10);
		if(index_current > index_highest) {
			index_highest = index_current;
		}
	});
	return index_highest.toString();
}

function hideDivs(divId)
{
	$j("#"+divId).hide("slow");
}

function hideUserDiv(action)
{
	$j("#userDiv").hide("slow");
	var myUrl = '';
	if(action=='modifySegment')
		myUrl = "/final/admin/EgDispSegments.jsp";
	else
		myUrl = "/final/admin/EgAddSegment.jsp";
	window.location = myUrl;
}

function centerScreen(selector) 
{
	var newTop =   $j("#topoTable").height() - $j(selector).height() / 2;
	var newLeft =  ($j("#topoTable").width()  - $j(selector).width()) / 2;
	$j(selector).css({
		'position': 'absolute',
		'left': newLeft,
		'top': newTop / 2
	});
}

/* Drag- Scripts  (Begin) */
function agent(v){ 
	return(Math.max(navigator.userAgent.toLowerCase().indexOf(v),0)); 
}

function xy(e,v){ 
	return(v?(agent('msie')?event.clientY+document.body.scrollTop:e.pageY):(agent('msie')?event.clientX+document.body.scrollTop:e.pageX)); 
}

function dragOBJ(d,e){
	var divId = d.id;
	function drag(e){ 
		if(!stop){ 
			tX = xy(e,1)+oY-eY; 
			tY = xy(e)+oX-eX; 
			setOpacity(d, 4);
			d.style.top= ((tX <= windowHeight)? tX : windowHeight)+'px';
			d.style.left=((tY <=windowWidth) ? tY : windowWidth)+'px';
		}
	}

	var oX=parseInt(d.style.left),oY=parseInt(d.style.top),eX=xy(e),eY=xy(e,1),tX,tY,stop;
	var windowWidth = document.body.clientWidth;
	var	windowHeight = document.body.clientHeight;

	document.onmousemove=drag; 
	document.onmouseup=function(){ 
		stop=1; 
		document.onmousemove=''; 
		document.onmouseup=''; 
		setOpacity(d, 10);
		bringToFront(d);
	};
}

function setOpacity(testObj, value) 
{
	testObj.style.opacity = value/10;
	testObj.style.filter = 'alpha(opacity=' + value*10 + ')';
}

/* Drag- Scripts  (End) */

function getAbsoluteDivs(){
	var arr = new Array();
	var all_divs = document.body.getElementsByTagName("DIV");
	var j = 0;
	for (i = 0; i < all_divs.length; i++)
		if (all_divs.item(i).style.position=='absolute'){
			arr[j] = all_divs.item(i);
			j++;
		}
	return arr;
}

function bringToFront(obj){
	if (!document.getElementsByTagName)
		return;

	var divs = getAbsoluteDivs();
	var max_index = 0;  
	var cur_index;

	for (i = 0; i < divs.length; i++){
		var item = divs[i];
		if (item == obj || item.style.zIndex == '')
			continue;
		cur_index = parseInt(item.style.zIndex);
		if (max_index < cur_index){
			max_index = cur_index;
		}
	}
	obj.style.zIndex = max_index + 1;
}

function hideDivAndRefresh(id)
{
	var dragValue= $j('#enableDrag').val();
	$j("#"+id).hide("slow");
	if(id == 'manageAllDiv' || id == 'manageDiv')
	{
		var zoomLevel = $j("#zoomValue").attr("value");
		var srcUrl = 'EgAutoMainPage.jsp?segment=<%=EgURLEncoder.encode(segment,"UTF-8")%>&zone=<%=EgURLEncoder.encode(zone,"UTF-8")%>'+'&zoom='+zoomLevel+'&enableDrag='+dragValue;
		$j("#myFrame").attr('src',srcUrl);
	}
}

/*function hide_centered_box(id)
{
	var closediv = document.getElementById(id);
	if (closediv != null)
	{
		closediv.style.display='none';
	}
	
	//If manageDiv is Closed Reload the frame Url to reflect the change
	if(id == 'manageDiv')
	{
		var myFrame = document.getElementById('myFrame');
		var zoomLevel = document.getElementById('zoomValue').value;
		if(myFrame!=null)
		{
			myFrame.src = 'EgAutoMainPage.jsp?segment=<%//=EgURLEncoder.encode(segment,"UTF-8")%>&zone=<%//=EgURLEncoder.encode(zone,"UTF-8")%>'+'&zoom='+zoomLevel;
		}
	}
}*/

// To set width and height based on window size
documentView ={
		getObject: function(){
			if(typeof( window.innerWidth) == 'number'){//Firefox
				this.height = window.innerHeight;
				this.width = window.innerWidth;
				this.fireFox = true;
			}
			else if( document.documentElement && ( document.documentElement.clientWidth
				|| document.documentElement.clientHeight )){//IE 6 + in 'standards compliant mode'
				this.height = document.documentElement.clientHeight;
				this.width = document.documentElement.clientWidth;
				this.ie = true;
			}else if(document.body && document.body.clientHeight){ //IE 4 compatible
				this.height = document.body.clientHeight;
				this.width = document.body.clientWidth;
				this.ie = true;
			}
			return this;
		},
		getHeight: function(){
			return this.getObject().height;
		},
		getWidth: function(){
			return this.getObject().width;
		},
		isIE: function(){
				return this.getObject().ie;
		},
		isFireFox: function(){
				return this.getObject().fireFox;
		}
};
window.onresize=pageHeightWidth;

function pageHeightWidth()
{
	var myFrame = document.getElementById("myFrame");
	if (myFrame!=null)
	{
		myFrame.style.height = documentView.getHeight()- 36;
		myFrame.style.width = documentView.getWidth()-4;
	}
}

function createRequestObject()
{
	var request_o;
	var browser = navigator.appName;
	if(browser == "Microsoft Internet Explorer")
		request_o = new ActiveXObject("Microsoft.XMLHTTP");
	else
		request_o = new XMLHttpRequest();
	return request_o;
}


</script>
</head>
<body onLoad="javascript:pageHeightWidth();" leftmargin="0px" topmargin="0px" marginwidth="0px" marginheight="0px" style="overflow:hidden">

<%
	String popup_topright = isMSIE6?"popup_topright_noshade":"popup_topright";
	String popup_rightbg = isMSIE6?"popup_rightbg_noshade":"popup_rightbg";
	String popup_bottomleft = isMSIE6?"popup_bottomleft_noshade":"popup_bottomleft";
	String popup_bottombg = isMSIE6?"popup_bottombg_noshade":"popup_bottombg";
	String popup_bottomright = isMSIE6?"popup_bottomright_noshade":"popup_bottomright";
%>

<input type="hidden" name="toolBoxOnOff" id="toolBoxOnOff" value="off">
<!-- Connect / Uses Div  -->
<div id="connectDiv" name="connectDiv" class="ui-widget-content" style="display:none;width:280px;height:330px;border:0px solid #ff0000; position:absolute;left:657px;top:94px;"> 
	<table border="0" bordercolor="blue" cellpadding="0" cellspacing="0">
		<tr>
			<td colspan="3" width="100%">
				<table border="0"  cellpadding="0" cellspacing="0" width="100%" >
					<tr>
						<td width="10" height="27" class="popup_topleft"><img src="/final/monitor/eg_images/spacer.gif" width="10" height="27" border="0"></td>
						<td id="connectTitle" class="popup_topbg eg_75bold whitefont" height="27px">
							<egui:intnl text='monitor.layermodel.Connects'/>
						</td>
						<td align="right" class="popup_topbg"><img class="png" src="/final/monitor/eg_images/<%=admin_Skin%>/popup_close.png" border="0" class="mouse" title="close" onclick="javascript:hideDivs('connectDiv');"> </td>
						<td width="17" height="27" class="<%=popup_topright%>"><img src="/final/monitor/eg_images/spacer.gif" width="17" height="27" border="0"></td>
					</tr>
				</table>
			</td>
		</tr>
		<tr class="ui-widget-header-temp">
			<td class="popup_leftbg"  width="7px"><img src="/final/monitor/eg_images/spacer.gif" width="7"></td>
			<td align="center" valign="top" >
				<div  class="div_scroll" style="overflow-x:hidden;border:0px solid green height:100%; width:100% ">
					<table border="0" bordercolor="green" cellpadding="0" cellspacing="0" width="100%" height="100%">
						<tr>
							<td class="white_bg">
							<div class="div_scroll" id="innerConnectDiv"  name="innerConnectDiv" style="left:0px;top:0px;width:260px;height:278px;border:0px solid #ff0000;"> </div>
							</td>
						</tr>
					</table>
				</div>
			</td>
			<td class="<%=popup_rightbg%>" width="14px"><img src="/final/monitor/eg_images/spacer.gif" width="14"></td>
		</tr>
		<tr class="ui-widget-header-temp">
			<td class="<%=popup_bottomleft%>"><img src="/final/monitor/eg_images/spacer.gif" width="7" height="16"></td>
			<td  class="<%=popup_bottombg%>" height="16"><img src="/final/monitor/eg_images/spacer.gif"></td>
			<td class="<%=popup_bottomright%>"><img src="/final/monitor/eg_images/spacer.gif" width="14" height="16"></td>
		</tr>
	</table>
</div>

<!-- Group Details Div -->
<div id="groupDiv" name="groupDiv" class="ui-widget-content" style="display:none;left:10px;top:50px;width:460px;height:353px;border:0px solid #ffff00; position:absolute;">
<table border="0" bordercolor="blue" cellpadding="0" cellspacing="0">
	<tr>
		<td colspan="3" width="100%">
			<table border="0"  cellpadding="0" cellspacing="0" width="100%" >
				<tr>
					<td width="10" height="27" class="popup_topleft"><img src="/final/monitor/eg_images/spacer.gif" width="10" height="27" border="0"></td>
					<td id="GroupTitle" class="popup_topbg eg_75bold whitefont"  height="27px"><egui:intnl text='monitor.layermodel.Group Details'/></td>
					<td align="right" class="popup_topbg"><img class="png" src="/final/monitor/eg_images/<%=admin_Skin%>/popup_close.png" border="0" class="mouse" title="close" vspace="2" onclick="javascript:hideDivs('groupDiv');"> </td>
					<td width="17" height="27" class="<%=popup_topright%>"><img src="/final/monitor/eg_images/spacer.gif" width="17" height="27" border="0"></td>
				</tr>
			</table>
		</td>
	</tr>
	<tr class="ui-widget-header-temp">
		<td class="popup_leftbg"  width="7px"><img src="/final/monitor/eg_images/spacer.gif" width="7"></td>
		<td align="center" valign="top" >
				<table border="0" bordercolor="green" cellpadding="0" cellspacing="0" width="100%" height="100%">
					<tr>
						<td class="white_bg">
							<div class="div_scroll" id="innerGroupDiv" name="innerGroupDiv" style="left:0px;top:0px;width:440px;height:310px;border:0px solid #ff0000;"> </div>
						</td>
					</tr>
				</table>
		</td>
		<td class="<%=popup_rightbg%>" width="14px"><img src="/final/monitor/eg_images/spacer.gif" width="14"></td>
	</tr>
	<tr class="ui-widget-header-temp">
		<td class="<%=popup_bottomleft%>"><img src="/final/monitor/eg_images/spacer.gif" width="7" height="16"></td>
		<td class="<%=popup_bottombg%>" height="16"><img src="/final/monitor/eg_images/spacer.gif"></td>
		<td class="<%=popup_bottomright%>"><img src="/final/monitor/eg_images/spacer.gif" width="14" height="16"></td>
	</tr>
</table>
</div>

<!-- ManageAll / SAVE Topology Div -->
<div id="manageAllDiv" name="manageAllDiv" style="display:none;left:10px;top:100px;width:670px;height:250px;border:0px solid #ffff00; position:absolute;">
<table border="0" bordercolor="blue" cellpadding="0" cellspacing="0">
	<tr>
		<td colspan="3" width="100%">
			<table border="0"  cellpadding="0" cellspacing="0" width="100%" >
				<tr>
					<td width="10" height="27" class="popup_topleft"><img src="/final/monitor/eg_images/spacer.gif" width="10" height="27" border="0"></td>
					<td id="manageAllDivTitle" class="popup_topbg eg_75bold whitefont"  height="27px"><egui:intnl text='admin.server.Manage Discovered / Unmanaged  Components'/></td>
					<td align="right" class="popup_topbg"><img class="png" src="/final/monitor/eg_images/<%=admin_Skin%>/popup_close.png" border="0" class="mouse" title="close" vspace="2" onclick="javascript:hideDivs('manageAllDiv');"> </td>
					<td width="17" height="27" class="<%=popup_topright%>"><img src="/final/monitor/eg_images/spacer.gif" width="17" height="27" border="0"></td>
				</tr>
			</table>
		</td>
	</tr>
	<tr class="ui-widget-header-temp">
		<td class="popup_leftbg"  width="7px"><img src="/final/monitor/eg_images/spacer.gif" width="7"></td>
		<td align="center" valign="top" >
				<table border="0" bordercolor="green" cellpadding="0" cellspacing="0" width="100%" height="100%">
					<tr>
						<td class="white_bg">
							<div class="div_scroll" id="innerManageAllDiv" name="innerManageAllDiv" style="left:0px;top:0px;width:650px;height:230px;border:0px solid green;"> </div>
						</td>
					</tr>
				</table>
		</td>
		<td class="<%=popup_rightbg%>" width="14px"><img src="/final/monitor/eg_images/spacer.gif" width="14"></td>
	</tr>
	<tr class="ui-widget-header-temp">
		<td class="<%=popup_bottomleft%>"><img src="/final/monitor/eg_images/spacer.gif" width="7" height="16"></td>
		<td class="<%=popup_bottombg%>" height="16"><img src="/final/monitor/eg_images/spacer.gif"></td>
		<td class="<%=popup_bottomright%>"><img src="/final/monitor/eg_images/spacer.gif" width="14" height="16"></td>
	</tr>
</table>
</div>

<!-- Manage Div  -->
<div id="manageDiv" name="manageDiv" style="display:none;width:756px;height:430px;border:0px solid #ff0000; position:absolute;left:20px;top:94px;" class="ui-widget-content" > 
	<table border="0" bordercolor="blue" cellpadding="0" cellspacing="0">
		<tr>
			<td colspan="3" width="100%">
				<table border="0"  cellpadding="0" cellspacing="0" width="100%" >
					<tr>
						<td width="10" height="27" class="popup_topleft"><img src="/final/monitor/eg_images/spacer.gif" width="10" height="27" border="0"></td>
						<td class="popup_topbg eg_75bold whitefont"  height="27px"><egui:intnl text='admin.server.Manage components'/></td>
						<td align="right" class="popup_topbg"><img class="png" src="/final/monitor/eg_images/<%=admin_Skin%>/popup_close.png" border="0" class="mouse" title="close" onclick="javascript:hideDivs('manageDiv');"> </td>
						<td width="17" height="27" class="<%=popup_topright%>"><img src="/final/monitor/eg_images/spacer.gif" width="17" height="27" border="0"></td>
					</tr>
				</table>
			</td>
		</tr>
		<tr class="ui-widget-header-temp">
			<td class="popup_leftbg"  width="7px"><img src="/final/monitor/eg_images/spacer.gif" width="7"></td>
			<td align="center" valign="top" >
				<div class="div_scroll" style="overflow-x:hidden;border:0px solid green height:100%; width:100% " >
					<table border="0" bordercolor="green" cellpadding="0" cellspacing="0" width="100%" height="100%">
						<tr>
							<td width="100%"> 
								<iframe frameborder="0" src="" width="735px" height="390px"  id="manageFrame" name="manageFrame" align="center"> 
								</iframe>
							</td>
						</tr>
					</table>
				</div>
			</td>
			<td class="<%=popup_rightbg%>" width="14px"><img src="/final/monitor/eg_images/spacer.gif" width="14"></td>
		</tr>
		<tr class="ui-widget-header-temp">
			<td class="<%=popup_bottomleft%>"><img src="/final/monitor/eg_images/spacer.gif" width="7" height="16"></td>
			<td class="<%=popup_bottombg%>" height="16"><img src="/final/monitor/eg_images/spacer.gif"></td>
			<td class="<%=popup_bottomright%>"><img src="/final/monitor/eg_images/spacer.gif" width="14" height="16"></td>
		</tr>
	</table>
</div>

<!-- Setting Div -->
<div id="settingsDiv" name="settingsDiv" style="display:none;width:450px;height:200px;border:0px solid #ff0000; position:absolute;left:20px;top:94px;" class="ui-widget-content"> 
	<table border="0" bordercolor="blue" cellpadding="0" cellspacing="0">
		<tr>
			<td colspan="3" width="100%">
				<table border="0"  cellpadding="0" cellspacing="0" width="100%" >
					<tr>
						<td width="10" height="27" class="popup_topleft"><img src="/final/monitor/eg_images/spacer.gif" width="10" height="27" border="0"></td>
						<td class="popup_topbg eg_75bold whitefont"  height="27px"><egui:intnl text='admin.server.Topology settings'/></td>
						<td align="right" class="popup_topbg"><img class="png" src="/final/monitor/eg_images/<%=admin_Skin%>/popup_close.png" border="0" class="mouse" title="close" onclick="javascript:hideDivs('settingsDiv');" onmousemove=document.body.style.cursor="default"> </td>
						<td width="17" height="27" class="<%=popup_topright%>"><img src="/final/monitor/eg_images/spacer.gif" width="17" height="27" border="0"></td>
					</tr>
				</table>
			</td>
		</tr>
		<tr class="ui-widget-header-temp">
			<td class="popup_leftbg"  width="7px"><img src="/final/monitor/eg_images/spacer.gif" width="7"></td>
			<td align="center" valign="top" >
				<table border="0" bordercolor="green" cellpadding="0" cellspacing="0" width="100%" height="100%">
					<tr>
						<td width="100%"> 
							<div id="innerSettingDiv" name="innerSettingDiv" style="left:0px;top:0px;width:435px;height:160px;border:0px solid green;"> </div>
						</td>
					</tr>
				</table>
			</td>
			<td class="<%=popup_rightbg%>" width="14px"><img src="/final/monitor/eg_images/spacer.gif" width="14"></td>
		</tr>
		<tr class="ui-widget-header-temp">
			<td class="<%=popup_bottomleft%>"><img src="/final/monitor/eg_images/spacer.gif" width="7" height="16"></td>
			<td class="<%=popup_bottombg%>" height="16"><img src="/final/monitor/eg_images/spacer.gif"></td>
			<td class="<%=popup_bottomright%>"><img src="/final/monitor/eg_images/spacer.gif" width="14" height="16"></td>
		</tr>
	</table>
</div>

<table border="0" align="center" cellspacing="0" cellpadding="0" width="100%" height="100%" id="topoTable" name ="topoTable">
<jsp:include page="listSearch.jsp?title=AUTO TOPOLOGY&leftString=Add User&backButton=true&subtitle=false"/>
<%
	if(proceed)
	{
%>
<tr>
	<td valign="top" style="padding:0px">
	<!-- <div id ="loading_image" style = "position:absolute;top:610px;left:480px;visibility:visible;display:block;"> 
		<table height="100%">
			<tr>
				<td height="100%" valign="middle"> 
					<img src='/final/admin/eg_images/indicator_medium.gif'>
				</td>
			</tr>
		</table>
	</div> -->
	
		<iframe width="100%" height="100%" id="myFrame" name="myFrame" src="EgAutoMainPage.jsp?segment=<%=EgURLEncoder.encode(segment,"UTF-8")%>&zone=<%=EgURLEncoder.encode(zone,"UTF-8")%>&modify=<%=EgURLEncoder.encode(from,"UTF-8")%>" border="0" scrolling="no" marginwidth="0px" marginheight="0px" frameborder="0" color="blue" style="border-width:0px; border-style:solid; border-color:yellow;"></iframe>
	</td>
</tr>
<%
	}
	else
	{
%>
	<tr>
		<td width="90%" height="100%" class="topoBg linesquare">
			<div id="userDiv" name="userDiv" style="display:block;width:400px;height:300px;border:0px solid #ff0000; position:absolute;">
			<table  border="0" cellspacing="0" cellpadding="0" width="100%">
				<tr>
					<td class="pop2_lefttop_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
					<td class="pop2_top_bg" width="100%"><img src="/final/admin/eg_images/spacer.gif" width="2" height="11"></td>
					<td class="pop2_righttop_curve" ><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
				</tr>
				<tr>
					<td class="pop2_left_bg"><img src="/final/admin/eg_images/spacer.gif" width="11" height="50px"></td>
					<td class="eg_whitebg" align="center">
						<div style="height:125px;border:1px solid black;">
							<table border="0" cellspacing="0" cellpadding="4" align="center" width="100%">
								<tr align="center">
									<tr>
										<td width="100%" height="100%" align="center" valign="middle"> <img src="eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br>
<%
	String line1 = "";
	String line2 = "";
	String line3 = "";

	if(from!=null && from.equalsIgnoreCase("modifySegment"))
	{
		line1 = "Segment <b>"+segment+"</b> cannot be modifed !";
		line2 = "Some other user is modifying a segment with the same name";
		line3 = "Please choose a different name !";
	}
	else
	{
		line1 = "Segment <b>"+segment+"</b> cannot be created !";
		line2 = "Some other user is creating a segment with the same name";
		line3 = "Please choose a different name !";
	}
%>
										<egui:intnl text="<%=line1%>"/> <br> 
										<egui:intnl text="<%=line2%>"/> <br> 
										<egui:intnl text="<%=line3%>"/> <br>
										</td>
									</tr>
								</tr>
								<tr align="center">
									<td><input type="button" class="eg_lightbutton" name="bkButton" id="bkButton" value=" OK " onclick="javascript:hideUserDiv('<%=from%>');"style="width:60px;padding-left:4px;padding-right:4px"></td>
								</tr>
							</table>
						</div>
					</td>
					<td class="pop2_right_bg"><img src="/final/admin/eg_images/spacer.gif" width="11" height="50px"></td>
				</tr>
				<tr>
					<td class="pop2_leftbottom_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
					<td class="pop2_bottom_bg"><img src="/final/admin/eg_images/spacer.gif" width="2" height="11"></td>
					<td class="pop2_rightbottom_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
				</tr>
			</table>
			</div>
		</td>
	</tr>
	
<%
	}
%>
</table>
</body>
<input type="hidden" id="zoomValue" name="zoomValue" value="100">
<%
}
catch(Exception e)
{
	System.out.println("Exception Occured.... in the JSP :- EgTopologyMainPage");
	e.printStackTrace();
}
%>