<%
/*****************************************************************************************************
*	Name			:	EgThreshDetail.jsp
*	Version			:	eG 4.0
*	Purpose			:	To display threshold details
*	Creation Date	:	01-02-2005.
*	Author			:	Thirumal Azhagan .T
*	Modifid			:	Monday, March 27, 2006 T.Thirumal Azhagan - UI Changes related to MIX policy.
*	Last Modified	:	Friday, March 31,2006 by James Thomas. P
*	Design Changes	:	Jaiwin
  *****************************************************************************************************/
%>

<%@ page errorPage = "EgProbs.jsp" %>
<%@ include file = "EgTrackerA.jsp" %>

<%@ page import = "java.io.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "egurkha.*" %>
<%@ page import = "egurkha.reporter.*" %>
<%@ page import = "com.eg.EgName" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgDiscInfo" %>
<%@ page import = "com.eg.EgDateInfo" %>
<%@ page import = "com.eg.EgRoleInfo" %> <!-- JJ -->
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import = "com.eg.EgTesterInfo" %>
<%@ page import = "com.eg.EgTablesInfo" %>
<%@ page import = "com.eg.EgMappingInfo" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgThresholdInfo" %>
<%@ page import = "com.eg.MappingNameSorter" %>
<%@ page import = "com.eg.EgServerGroupBean" %>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "com.egurkha.pdfmaker.*" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.egurkha.util.StringUtils" %>

<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	EgDateInfo egDate = new EgDateInfo();
	EgServerGroupBean descGrp = new EgServerGroupBean();
	EgTesterInfo testerInfo=new EgTesterInfo("manager");
	ArrayList globalThresholds=testerInfo.getGlobalThresholds();
	//String date = egDate.egetDate();

	Vector v_con = new Vector();
	Vector contForparamAndData = new Vector();
	Hashtable h_container = new Hashtable();
	Hashtable hashForPDF = new Hashtable();
	String s_ForCmd = "Threshold";
	String s_forPdfTitle="";
	String defValue = "none";
	String[] val = new String[5];

	EgThresholdInfo threshInfo = new EgThresholdInfo("manager"); 
	EgDiscInfo disc_info = new EgDiscInfo("manager");
	EgSpecsInfo specs_info = new EgSpecsInfo("manager");
	EgTablesInfo tables_info=new EgTablesInfo("manager");
	List defaultPolicies=new ArrayList();
	defaultPolicies.add("immediate");
	defaultPolicies.add("shortterm");
	defaultPolicies.add("standard");
	defaultPolicies.add("longterm");
	defaultPolicies.add("not applicable");

	String uiFile = "eg_ui.ini";
	String iniFileDir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(iniFileDir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	Date date = new Date(System.currentTimeMillis());
	String currentDateTime = DateUtil.formatDate(date,currentDateFormat+" HH:mm:ss");
	EgTimeZoneConverter converter = new EgTimeZoneConverter(currentDateTime,_user);
	currentDateTime = converter.getDateTime();

	String userLanguage = _user.getLanguage();
	IniUI iniUI = IniUI.getInstance();
	if (userLanguage == null)
	{
		userLanguage = iniUI.getDefaultLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	EgRoleInfo egRoleInfo=EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));//by JJ

	String s_threshType = request.getParameter("eg_threshType");
	String s_compType = request.getParameter("eg_compType");
	String s_host = request.getParameter("eg_host");
	String req_test = request.getParameter("eg_test");
	String fromCompType = request.getParameter("fromCT");
	fromCompType=(fromCompType==null?"true":fromCompType);

	if(fromCompType.equalsIgnoreCase("true"))
	{
		s_threshType = "All";
	}

	if(s_threshType==null)
	{
		s_threshType = "All";
	}
	if(req_test==null)
	{
		req_test="All";
	}

	String s_pdf = request.getParameter("PDF");
	String arr_threshTypes[] = {"All","Default","Specific","Descriptor","Fixed"};
	ArrayList thresholdTypes = new ArrayList(Arrays.asList(arr_threshTypes));
	Vector v_allComps = new Vector(disc_info.getAllManagedComponents());
	Vector v_compTypes = new Vector();
	Vector v_components = new Vector();
	Vector v_matchTypes = new Vector();
	ArrayList commonList = null;

	boolean isGlobalContainTest = false;
	boolean isGlobalContainAllTest = false;
	boolean isGlobalConSpecificTest = false;
	boolean isReqTestAll = req_test.equalsIgnoreCase("All");
	boolean global = (globalThresholds!=null && globalThresholds.size()>0);
	ArrayList serverList = null;
	
	String[] compTypes = egRoleInfo.getServerTypes();
	if (compTypes != null && compTypes.length >0)
	{
		for (int i=0;i<compTypes.length;i++)
		{
			ArrayList aListEnabledPTestForCompType = new ArrayList();
			aListEnabledPTestForCompType = specs_info.getEnabledTests(compTypes[i],false);
			if (aListEnabledPTestForCompType.size()>0 && !v_compTypes.contains(compTypes[i]))
			{
				v_compTypes.add(compTypes[i]);
			}
		}
	}

	if (v_compTypes != null && v_compTypes.size() > 0)
	{
		serverList = new ArrayList(v_compTypes);
		serverList = sorter.getSortedCompTypeList(serverList);
	}

	if (s_compType == null)
	{
		if (v_compTypes != null && v_compTypes.size() > 0)
		{
			EgName nameObj = (EgName)serverList.get(0);
			s_compType = nameObj.getActualName();
		}
		else
		{
			s_compType = "All";
		}
	}

	boolean isCompTypeAll = (s_compType != null && s_compType.equalsIgnoreCase("All"));

	if(global)
	{
		if(!isCompTypeAll)
		{
			if(isReqTestAll)
			{
				String tests[] = specs_info.getTestsForServer(s_compType);
				commonList = new ArrayList(Arrays.asList(tests));
				isGlobalContainAllTest = globalThresholds.containsAll(commonList);
				isGlobalConSpecificTest = isListContainsTest(globalThresholds,commonList);
				isGlobalConSpecificTest = !isGlobalConSpecificTest;
			}
			else
			{
				isGlobalContainTest = globalThresholds.contains(req_test);
				isGlobalConSpecificTest = !isGlobalContainTest;
			}
			if(isGlobalContainAllTest || isGlobalContainTest)
			{
				thresholdTypes.clear();
				thresholdTypes.add("Fixed");
			}
			if(isGlobalConSpecificTest)
			{
				thresholdTypes.remove(thresholdTypes.indexOf("Fixed"));
			}
		}
	}
	else
	{
		thresholdTypes.remove(thresholdTypes.indexOf("Fixed"));
	}

	if (s_compType.equalsIgnoreCase("ALL"))
	{
		commonList = egRoleInfo.getAllServers();
	}
	else
	{
		String[] compsforType = egRoleInfo.getAllServersOfType(s_compType);
		commonList = new ArrayList(Arrays.asList(compsforType));
	}
	for(int i = 0;i < commonList.size();i++)
	{
		String temp = (String)commonList.get(i);
		int ind = temp.indexOf(":");
		String s_compTy = temp.substring(0,ind);
		String s_compName = temp.substring(ind+1);
		v_components.add(s_compName);
		v_matchTypes.add(s_compTy+'#'+s_compName);
	}

	Collections.sort(v_components,String.CASE_INSENSITIVE_ORDER);

	if (s_host == null)
	{
		if (v_components != null && v_components.size() > 0)
		{
			s_host = (String)v_components.get(0);
		}
		else
		{
			s_host = "All";
		}
	}
	
	// Updated by JJ
	Vector v_allTests = new Vector();
	boolean isAllCompType = false;

	if (s_compType.equalsIgnoreCase("All"))
	{
		isAllCompType = true;
		for (int i=0; i<v_compTypes.size();i++)
		{
			String arr_tests[]= specs_info.getTestsForServer((String)v_compTypes.get(i));
			if (arr_tests !=null && arr_tests.length > 0)
			{
				for(int j=0;j<arr_tests.length;j++)
				{
					if(!v_allTests.contains(arr_tests[j]))
					{
						v_allTests.add(arr_tests[j]);
					}
				}
			}
		}
	}
	else
	{
		String arr_tests[]= specs_info.getTestsForServer(s_compType);
		if (arr_tests !=null && arr_tests.length > 0)
		{
			for(int j=0;j<arr_tests.length;j++)
			{
				if(!v_allTests.contains(arr_tests[j]))
				{
					v_allTests.add(arr_tests[j]);
				}
			}
		}
	}

	//remove config tests
	TestBean testBean = new TestBean(true);
	ArrayList configTests = testBean.getAllConfigTests();
	v_allTests.removeAll(configTests);

	TreeMap tm_threshData = new TreeMap();

	/*boolean isAllThresh = s_threshType.equalsIgnoreCase("All");
	boolean isDefaultThresh = isAllThresh || s_threshType.equalsIgnoreCase("Default");
	boolean isSpecificThresh = isAllThresh || s_threshType.equalsIgnoreCase("Specific");
	boolean isDescThresh = isAllThresh || s_threshType.equalsIgnoreCase("Descriptor");
	boolean isFixedThresh = isAllThresh || s_threshType.equalsIgnoreCase("Fixed");*/
	
	boolean isAllThresh = s_threshType.equalsIgnoreCase("All");
	boolean isDefaultThresh = s_threshType.equalsIgnoreCase("Default");
	boolean isDefThreshTemp = isDefaultThresh;
	boolean isSpecificThresh = s_threshType.equalsIgnoreCase("Specific");
	boolean isDescThresh = s_threshType.equalsIgnoreCase("Descriptor");
	boolean isFixedThresh = s_threshType.equalsIgnoreCase("Fixed");
	boolean isFixThreshTemp =isFixedThresh;

	//***************For PDF Sub Title*****************

	boolean isCompTypeEnabled = !s_compType.equalsIgnoreCase("All");
	boolean isCompNameEnabled = !s_host.equalsIgnoreCase("All") && isCompTypeEnabled;
	boolean isTestNameEnabled = !req_test.equalsIgnoreCase("All") && isCompNameEnabled;

	if (isAllThresh)
	{
		if(isCompNameEnabled && isCompTypeEnabled && isTestNameEnabled)
			s_forPdfTitle = _mapping.getComponentTypeDescription(s_compType)+ ":" + removeNull(s_host) +": "+_mapping.getTestDescription(req_test)+" ("+ currentDateTime +")";
		else if (isCompNameEnabled && isCompTypeEnabled)
			s_forPdfTitle = _mapping.getComponentTypeDescription(s_compType)+ ":" +removeNull(s_host) +" ("+ currentDateTime +")";
		else if(isCompNameEnabled)
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.Component")+"  : " +removeNull(s_host) +" ("+ currentDateTime +")";
		else if(isCompTypeEnabled)
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.Component Type")+"  : " +_mapping.getComponentTypeDescription(s_compType) +" ("+ currentDateTime +")";
		else
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.All Components")+" ("+ currentDateTime +")";
	}
	else if(isDefaultThresh)
	{
		if(isCompNameEnabled && isCompTypeEnabled && isTestNameEnabled)
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.Default Settings for")+" "+_mapping.getComponentTypeDescription(s_compType)+ ":" + removeNull(s_host) +": "+_mapping.getTestDescription(req_test)+" ("+ currentDateTime +")";
		else if (isCompNameEnabled && isCompTypeEnabled)
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.Default Settings for")+" "+_mapping.getComponentTypeDescription(s_compType)+ ":" + removeNull(s_host) +" ("+ currentDateTime +")";
		else if(isCompNameEnabled)
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.Default Settings for Component")+" "+ removeNull(s_host) +" ("+ currentDateTime +")";
		else if(isCompTypeEnabled)
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.Default Settings for Component Type")+" "+ _mapping.getComponentTypeDescription(s_compType) +" ("+ currentDateTime +")";
		else
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.Default Settings")+" ("+ currentDateTime +")";
	}
	else if(isSpecificThresh)
	{
		if(isCompNameEnabled && isCompTypeEnabled && isTestNameEnabled)
			s_forPdfTitle = _mapping.getComponentTypeDescription(s_compType)+ ":" + removeNull(s_host) +": "+_mapping.getTestDescription(req_test)+" ("+ currentDateTime +")";
		else if (isCompNameEnabled && isCompTypeEnabled)
			s_forPdfTitle = _mapping.getComponentTypeDescription(s_compType)+":"+ removeNull(s_host) +" ("+ currentDateTime +")";
		else if(isCompNameEnabled)
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.Component")+"  : "+ removeNull(s_host) +" ("+ currentDateTime +")";
		else if(isCompTypeEnabled)
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.Component Type")+"  : "+ _mapping.getComponentTypeDescription(s_compType) +" ("+ currentDateTime +")";
		else
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.All Specific Components")+" ("+ currentDateTime +")";
	}
	else if(isDescThresh)
	{
		if(isCompNameEnabled && isCompTypeEnabled && isTestNameEnabled)
			s_forPdfTitle = _mapping.getComponentTypeDescription(s_compType)+ ":" + removeNull(s_host) +": "+_mapping.getTestDescription(req_test)+" ("+ currentDateTime +")";
		else if (isCompNameEnabled && isCompTypeEnabled)
			s_forPdfTitle = _mapping.getComponentTypeDescription(s_compType)+":"+ removeNull(s_host) +" ("+ currentDateTime +")";
		else if(isCompNameEnabled)
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.Component")+"  : "+ removeNull(s_host) +" ("+ currentDateTime +")";
		else if(isCompTypeEnabled)
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.Component Type")+"  : "+ _mapping.getComponentTypeDescription(s_compType) +" ("+ currentDateTime +")";
		else
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.All Descriptor Components")+" ("+ currentDateTime +")";
	}
	else
		s_forPdfTitle =  _mapping.getTextDescription("admin.threshold.Threshold Report")+" ("+ currentDateTime +")";

	if(isCompNameEnabled && isCompTypeEnabled && isTestNameEnabled && s_forPdfTitle.length()>80)
		s_forPdfTitle=s_forPdfTitle.substring(0,s_forPdfTitle.lastIndexOf("("))+"\n ("+ currentDateTime +")";

	//new changes (13Jul2007)

	ArrayList selectedTests = new ArrayList(v_allTests);
	if(!req_test.equalsIgnoreCase("All"))
	{
		v_allTests.clear();
		v_allTests.add(req_test);
	}

	String[] userThreshvariables = null;
	if(isSpecificThresh || (isAllThresh))
	{
		userThreshvariables =  threshInfo.getUserThresholds();
		/*
		ArrayList userThreshTests = new ArrayList();
		for(int i=0; i<userThreshvariables.length; i++)
		{
			String variableLocal = userThreshvariables[i];
			if(variableLocal != null)
			{
				int pos = variableLocal.indexOf(":");
				if(pos >= 0)
				{
					String test = variableLocal.substring(0,pos);
					if(!userThreshTests.contains(test))
					{
						userThreshTests.add(test);
					}
				}
			}
		}
		v_allTests.retainAll(userThreshTests);
		*/
	}
	//end

	String finn = request.getParameter("fin");
	if (finn != null && finn.equals("yes"))
	{
		for(int i=0;i<v_allTests.size();i++)
		{
			String s_test = (String)v_allTests.get(i);
			boolean contain = global && globalThresholds.contains(s_test);
			
			Vector v_data= new Vector();
			if(isAllThresh)
			{
				if(contain)
				{
					isFixedThresh = true;
					isDescThresh = false;
					isDefaultThresh = false;
					isSpecificThresh = false;
				}
				else
				{
					isDescThresh = true;
					isDefaultThresh = true;
					isSpecificThresh = true;
					isFixedThresh = false;
				}
			}
			else if (!isFixedThresh && contain)
			{
				continue;
			}
			//for Global Threshold (17 Jul 2007)
			if(isFixedThresh)
			{
				if(contain)
				{
					String s_val = threshInfo.getDefaultThresholdValue(s_test);
					if(s_val !=null && !s_val.equals(""))
					{
						v_data.add("Fixed");
						v_data.add(s_val);
					}
				}
			}
			if(isDefaultThresh)
			{
				String s_val = threshInfo.getDefaultThresholdValue(s_test);
				if(s_val!=null && !s_val.equals(""))
				{
					v_data.add("Default");
					v_data.add(s_val);
				}
			}
			if(isSpecificThresh || isDescThresh)
			{
				Vector v_comps = null;
				if(!s_host.equalsIgnoreCase("All"))
				{
					v_comps = new Vector();
					v_comps.add(s_host);
				}
				else
				{
					v_comps =(Vector) v_components.clone();
				}
				Vector v_specData = new Vector();
				Vector v_descData = new Vector();
				Vector v_allData = new Vector();
				for(int j=0;j<v_comps.size();j++)
				{
					if (j>=v_matchTypes.size())
						break;
					if (isAllCompType)
					{
						String t = (String) v_matchTypes.get(j);
						int ind = t.indexOf('#');
						t = t.substring(0,ind);
						if (!specs_info.isTestRelevantForServer (t,s_test) ||contain)
						{
							continue;
						}
					}
					String s_component = (String)v_comps.get(j);
					String s_userThreshKey = s_test;
					String s_descThreshKey = s_test;

					StringTokenizer st = new StringTokenizer(s_component,":");
					String s_cmp = st.nextToken();
					String s_port = st.nextToken();

					String s_sid = null;
					if(st.hasMoreTokens())
						s_sid = st.nextToken();

					boolean isPortRelevantForTest =specs_info.isPortRelevantForTest(s_test);
					boolean isInfoRelevantForTest =false;

					if (s_compType.equalsIgnoreCase("All"))
					{
						isInfoRelevantForTest = (s_sid!=null && specs_info.isInfoRelevantForTest(s_test));
					}
					else
					{
						isInfoRelevantForTest = (s_sid!=null && specs_info.isInfoRelevantForTest(s_test,s_compType));
					}
					if(isSpecificThresh)
					{
						String s_key = s_cmp;
						if(isPortRelevantForTest)
							s_key += ":" + s_port;
						if(isInfoRelevantForTest)
							s_key += ":" + s_sid;

						String s_title = s_key;
						if(v_specData.contains(s_title))
							continue;
						s_key = s_test + ":" + s_key;
						//************june 24******
						String s_val = "";

						//new change
						boolean check = false;
						if(userThreshvariables != null)
						{
							for(int inc=0; inc <userThreshvariables.length; inc++)
							{
								String localvar = userThreshvariables[inc];
								if(localvar != null && localvar.equals(s_key))
								{
									check = true;
									break;
								}
							}
						}
						//end
						if(check)
						{
							s_val = threshInfo.getUserThresholdValue(s_key);
						}
						if(s_val == null || s_val.equals(""))
						{
							s_val = descGrp.getThresholdsFromInfoGroupIni(s_key,false);
						}
						//***********
						if(s_val!=null && !s_val.equals(""))
						{
							s_title = removeNull(s_title);
							if(isAllThresh)
							{
								s_title =s_title+" [Specific]" ;
							}
							v_specData.add(s_title);
							v_specData.add(s_val);
						}
					}

					if(isDescThresh)
					{
						String s_key = s_cmp;
						String all_key="";
						String all_val="";
						String all_title="";
						if(isPortRelevantForTest)
							s_key += ":" + s_port;
						else
							s_key += ":NULL";
						if(isInfoRelevantForTest)
							s_key += ":" + s_sid;
						String s_title = "";//s_key;
						String inf = "";
						all_title = s_key;
						Vector v_info = threshInfo.getInfosForThresholds(s_test, s_key);
						s_key = s_test + ":" + s_key;
						all_key = s_key;
						if(v_info!=null && v_info.size()>0)
						{
							for(int k=0;k<v_info.size();k++)
							{
								String s_info = (String)v_info.get(k);
								if(s_info.indexOf('+')!=-1)
									s_info = s_info.substring(s_info.indexOf('+')+1);

								String s_orgKey = s_key + "#" + s_info;
								String s_val = "";
								s_val = threshInfo.getDescThresholdValue(s_orgKey);
								if(s_val == null || s_val.equals(""))
								{
									s_val = descGrp.getThresholdsFromInfoGroupIni(s_orgKey,false);
								}
								if(s_val!=null && !s_val.equals(""))
								{
									s_title = s_key.substring(s_key.indexOf(":")+1);
									s_title = removeNull(s_title);
									String tmpInfo = s_info;
									if (tmpInfo.indexOf("0eGHash1") > -1)
									{
										tmpInfo = StringUtils.replace(tmpInfo,"0eGHash1","#");
									}
									s_title = s_title+"#" + tmpInfo;
									if(isAllThresh)
									{
										s_title =s_title+" [Descriptor]";
									}
									v_descData.add(s_title);
									v_descData.add(s_val);
								}
							}
						}
						if(v_allData.contains(all_title))
							continue;
						all_val = descGrp.getThresholdsFromInfoGroupIni(all_key,false);
						if(all_val!=null && !all_val.equals(""))
						{
							all_title = removeNull(all_title);
							all_title =all_title+" [All Descriptors]";
							v_allData.add(all_title);
							v_allData.add(all_val);
						}
					}// end of isDescThresh
				}
				if(v_specData.size()>0) v_data.addAll(v_specData);
				if(v_descData.size()>0) v_data.addAll(v_descData);
				if(v_allData.size()>0) v_data.addAll(v_allData);
			}
			if(v_data.size() > 0)
			{
				tm_threshData.put(s_test,v_data);
				for (int x=1;x<v_data.size();x+=2)
				{
					Vector v_tokens = new Vector();
					String tok = (String) v_data.get(x);
					StringTokenizer strToken = new StringTokenizer(tok,",");
					while (strToken.hasMoreTokens())
					{
						String tt = (String)strToken.nextToken();
						StringTokenizer st1 = new StringTokenizer(tt,":");
						v_tokens.add(st1.nextToken());
						String s_policy = st1.nextToken();
						v_tokens.add(st1.nextToken());
						v_tokens.add(st1.nextToken());
						v_tokens.add(s_policy);
						v_tokens.add(st1.nextToken());
					}
					v_data.setElementAt(v_tokens,x);
				}
			}
		}
	}
	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
%>
<egui:skin ui = "admin"/>
<html>
<title>Default Threshold</title>
<head>
<script language="JavaScript1.2" src="/final/admin/eg_scripts/validate.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script language="javascript">
	function saveMe()
	{
		getPdf('<%=admin_Skin%>');
	}

	function callMe()
	{
		var pdf = true;
		var thisForm = document.EgThresholdDetail;

		var comp_type = thisForm.eg_compType.options[thisForm.eg_compType.selectedIndex].value;
		var host = thisForm.eg_host.options[thisForm.eg_host.selectedIndex].value;
		var s_test = thisForm.eg_test.options[thisForm.eg_test.selectedIndex].value;
		var thresh = thisForm.eg_threshType.options[thisForm.eg_threshType.selectedIndex].value;

		thisForm.sub.value = '<egui:intnl text="admin.common.Submitting"/>...';
		thisForm.sub.disabled = true;

		window.location.href = "EgThreshDetail.jsp?fin=yes&eg_host="+encodeURI(host)+"&eg_compType="+encodeURI(comp_type)+"&eg_threshType="+encodeURI(thresh)+"&PDF="+pdf+"&eg_test="+encodeURI(s_test)+"&fromCT=false";
	}

	function goTo(op)
	{
		var thisForm = document.EgThresholdDetail;

		var comp_type = thisForm.eg_compType.options[thisForm.eg_compType.selectedIndex].value;
		var host = thisForm.eg_host.options[thisForm.eg_host.selectedIndex].value;
		var s_test = thisForm.eg_test.options[thisForm.eg_test.selectedIndex].value;
		var thresh = thisForm.eg_threshType.options[thisForm.eg_threshType.selectedIndex].value;

		window.location.href = "EgThreshDetail.jsp?eg_host="+encodeURI(host)+"&eg_compType="+encodeURI(comp_type)+"&eg_threshType=All&eg_test=All";
	}

	function printData()
	{
		parent.openWindow("/final/admin/EgPrintThreshDetail.jsp?","PrintWindow","width=1014,height=603,left=0,top=109,scrollbars=yes,resizable=no");
	}

	function call()
	{
		var sDownLoad = document.getElementById("download");
		if (sDownLoad != null && sDownLoad.style.display == 'block')
		{
			sDownLoad.style.display = 'none';
			sDownLoad.style.visibility = "hidden";
			document.EgThresholdDetail.sub.disabled = false;
		}
	}
	function csvData()
	{
<%
			if (tm_threshData == null || tm_threshData.size() == 0)
			{
%>
				alert('<egui:intnl text="configmgmt.common.No data available" />');
				return;
<%
			}
%>
			thisForm = document.forms[0];
			thisForm.action = '../servlet/com.eg.EgCSVController';
			thisForm.submit();
	}


	function savePdf(admin_Skin)
	{
<%
	session.setAttribute("PDF_URL",mngrIProc+"/final/admin/EgPrintThreshDetail.jsp;jsessionid="+session.getId()+"?forPDF=yes");
	session.setAttribute("REPORT_NAME","Thresholds_View");
	session.setAttribute("REPORT_LAYOUT","Portrait");
%>
		var blankPage = "";
		if(location.protocol=="https:") blankPage="/final/blank.html";
		var win=parent.openWindow(blankPage,"SaveWindow","width=400,height=150,left=300,top=200,scrollbars=no,resizable=no");
		win.document.write("<html>");
		win.document.write("<title>Downloading</title>");
		win.document.write("<frameset rows= '0%,0%,*' frameborter='NO' border='0' framespacing='0'>");
		win.document.write("<frame src='/final/servlet/com.eg.EgPdfDownloadC' frameborder=0 noresize scrolling=no name='Data'>");
		win.document.write("<frame src='/final/admin/EgSaveStatus.jsp' frameborder=0 noresize scrolling=auto>");
		win.document.write("<frame src='" + blankPage + "' frameborder=0 noresize scrolling=auto name='statusPanel'>");
		win.document.write("</frameset>");
		win.document.write("</html>");
		win.frames[2].document.open("text/html","replace");
		win.frames[2].document.write('<html><head>');
		win.frames[2].document.write('<link rel="stylesheet" href="/final/admin/eg_styles/adminstyle_'+admin_Skin+'.css" />');
		win.frames[2].document.write('</head><body id="eg_morelight"><br><br><h4 align="center" style="font-family: Verdana,Arial; font-size: 15px; color: #000000;"><img src="/final/reporter/images/load_round.gif"><br><br>Downloading! Please wait...</h4></body></html>');
		win.frames[2].document.close();
	}
</script>
</head>
<body style="overflow:auto" leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" onLoad="call();">
<form name="EgThresholdDetail" method="post" action="EgThreshDetail.jsp" style="margin:0px">
<input type="hidden" name="threshDisp" value="">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">

	<jsp:include page='<%="listSearch.jsp?title=THRESHOLDS VIEW&leftString=Add User&backButton=false&subtitle=false"%>'/>

	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
			<table align="center" cellspacing="0" cellpadding="0" width="85%" border="0">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%" colspan="6"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td class="eg_subcontentbg" id="form_border">&nbsp; </td> 
					<td align="left" width="130" class="eg_subcontentbg" nowrap height="20" id="form_border">&nbsp;<egui:intnl text="admin.threshold.Component type "/></td>
					<td width="5" class="eg_subcontentbg" id="form_border">:</td>
					<td class="eg_subcontentbg" id="form_border"> &nbsp;&nbsp;&nbsp;&nbsp; <select name="eg_compType" onChange ='javascript:goTo("comptype")' style='width:220px;'>
<%
	if(v_compTypes.size() == 0)
	{
%>
						<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
	}
	else
	{
		for(int i=0;i<serverList.size();i++)
		{
			EgName nameObj = (EgName)serverList.get(i);
			String tmpVal = nameObj.getActualName();
			String tmpDis = nameObj.getLocalName();
			if(tmpVal.equals(s_compType))
			{
%>
						<option value="<%=tmpVal%>" selected><%=tmpDis%></option>
<%
			}
			else
			{
%>
						<option value="<%=tmpVal%>"><%=tmpDis%></option>
<%
			}
		}
		if(v_compTypes.size() > 1)
		{
%>
						<option value="All" <%="All".equals(s_compType)?"selected":""%>><egui:intnl text="admin.common.All"/></option>

<%
		}
	}
%>
					</select>
					</td>
					<td align="left" class="eg_subcontentbg" nowrap height="20" id="form_border" width="130">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<egui:intnl text="admin.threshold.Component name"/></td>
					<td class="eg_subcontentbg" id="form_border">:</td>
					<td class="eg_subcontentbg" id="form_border">&nbsp;&nbsp;&nbsp;&nbsp;
					<select name="eg_host" style='width:190px;'>
<%
	String s_tmpname="";
	String s_tmpname1 = "";
	if(v_compTypes.size() == 0)
	{
%>
						<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
	}
	else
	{
		for(int i=0;i<v_components.size();i++)
		{
			s_tmpname=(String)v_components.get(i);
			//new change
			if(s_tmpname.lastIndexOf(":") >= 0)
			{
				s_tmpname1 = s_tmpname.substring(s_tmpname.lastIndexOf(":")+1);
				if(s_tmpname1 != null && s_tmpname1.equalsIgnoreCase("NULL"))
				{
					s_tmpname1 = s_tmpname.substring(0,s_tmpname.lastIndexOf(":"));
				}
				else
					s_tmpname1 = s_tmpname;
			}
			else
				s_tmpname1 = s_tmpname;
			if(s_tmpname.equals(s_host))
			{
%>
						<option value="<%=s_tmpname%>" selected><%=s_tmpname1%></option>
<%
			}
			else
			{
%>
						<option value="<%=s_tmpname%>"><%=s_tmpname1%></option>
<%
			}
		}
		if(v_components.size() > 1)
		{
%>
						<option value="All" <%=(s_host.equals("All"))?"selected":""%>><egui:intnl text="admin.common.All"/></option>
<%
		}
	}
%>
					</select>
					</td>
					<td class="eg_subcontentbg" id="form_border">&nbsp;</td>
				</tr>

				<tr>
					<td class="eg_subcontentbg" id="form_spacing">&nbsp;</td>
					<td align="left" width="130" class="eg_subcontentbg" nowrap height="20" id="form_spacing">&nbsp;<egui:intnl text="admin.threshold.Test name"/></td>
					<td width="5" class="eg_subcontentbg" id="form_spacing">:</td>
					<td class="eg_subcontentbg" id="form_spacing"> &nbsp;&nbsp;&nbsp;&nbsp; 
						<select name="eg_test" style='width:220px;'>
<%
	if(v_compTypes.size() == 0)
	{
%>
						<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
	}
	else if (!isAllCompType || v_components.size() == 1)
	{
		if(selectedTests.size()>0)
		{
%>
							<option value="All" <%=req_test.equalsIgnoreCase("All")?"selected":""%>><egui:intnl text="admin.threshold.All"/></option>
<%
		}
		else if(selectedTests.size() == 0)
		{
%>
							<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
		}
		ArrayList sortedTestList = new ArrayList(selectedTests);
		sortedTestList = sorter.getSortedTestList(sortedTestList);
		for(int i=0;i<sortedTestList.size();i++)
		{
			EgName nameObj = (EgName)sortedTestList.get(i);
			String tmpVal = nameObj.getActualName();
			String tmpDis = nameObj.getLocalName();
%>
							<option value="<%=tmpVal%>" <%=(req_test.equalsIgnoreCase(tmpVal))?"selected":""%>><%=tmpDis%></option>
<%
		}
	}
	else
	{
%>
							<option value="All"><egui:intnl text="admin.threshold.All"/></option>
<%
	}
%>
						</select>
					</td>
					<td align="left" width="130" class="eg_subcontentbg" nowrap height="20" id="form_spacing">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<egui:intnl text="admin.threshold.Threshold"/></td>
					<td class="eg_subcontentbg" id="form_spacing">:</td>
					<td class="eg_subcontentbg" id="form_spacing"> &nbsp;&nbsp;&nbsp;&nbsp;
						<select name="eg_threshType" style='width:190px;'>
<%
	if(v_compTypes.size() == 0)
	{
%>
						<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
	}
	else
	{
		arr_threshTypes = (String[])thresholdTypes.toArray(new String[0]);
		for (int x=0;x<arr_threshTypes.length;x++)
		{
			if(arr_threshTypes[x]!=null || arr_threshTypes[x].equals("null"))
			{
				if (thresholdTypes.contains(arr_threshTypes[x]))
				{
%>
							<option value="<%=arr_threshTypes[x]%>"  <%=(arr_threshTypes[x].equals(s_threshType))?"selected":""%> ><egui:intnl text='<%="admin.threshold."+arr_threshTypes[x]%>'/></option>
<%
				}
				else
				{
%>
							<option value="<%=arr_threshTypes[x]%>"  <%=(arr_threshTypes[x].equals(s_threshType))?"selected":""%> ><%=arr_threshTypes[x]%></option>
<%
				}
			}
		}
	}
%>
<%
						//out.println(HtmlUtils.setSelectOptions(arr_threshTypes, s_threshType));
%>
						</select>
					</td>
					<td class="eg_subcontentbg" id="form_spacing">&nbsp;</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%" colspan="6" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
				<tr>
					<td height="10" id="eg_blankspace">&nbsp;</td>
				</tr>
<%
	String disabled = "";
	if(selectedTests.size() == 0)
		disabled = "disabled";
%>
				<tr>
					<td colspan="8" align="center" id="eg_subhead"  nowrap height="20"><input type="button" name="sub" value='<egui:intnl text="admin.threshold.Submit"/>' style="width: 80px;" id="eg_back" onClick="javascript:callMe()" <%=disabled%> ></td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td id="eg_blankspace" height="10">&nbsp;</td>
	</tr>
<%
	if (finn != null && finn.equals("yes"))
	{
%>
	<tr>
		<td>
			<table border="0" bordercolor="red" id="cellbglight" cellpadding="0px" cellspacing="0px" width="100%">
				<tr>
					<td align="center" class="" valign="middle">
					<div id="download" style="border:0px solid #ff0000;display:block;visibility:visible;">
						<script language="JavaScript">
							var browserName = navigator.appName;
							var downLoadHide = document.getElementById("download");
							if (browserName == 'Netscape')
							{
								downLoadHide.style.display = 'none';
							}
							else
							{
								document.EgThresholdDetail.sub.disabled = true;
							}
						</script>
						<table id="cellbglight" align="center" width="90%" cellspacing="0" cellpadding="0" border="0">
							<tr height="130">
								<td align="center" id="blackcontent">&nbsp;</td>
							</tr>
							<tr>
								<td align="center" id="blackcontent">
									<img src='/final/admin/eg_images/indicator_medium.gif' alt="<egui:intnl text='admin.common.DOWNLOADING'/>" title="<egui:intnl text='admin.common.DOWNLOADING'/>">
								</td>
							</tr>
							<tr height="10">
								<td align="center" id="blackcontent">&nbsp;</td>
							</tr>
							<tr>
								<td align="center" id="blackcontent"><b><egui:intnl text="admin.common.Loading data"/>.&nbsp;<egui:intnl text="admin.common.Please wait"/>...<b></td>
							</tr>
							<tr>
								<td align="center" id="blackcontent">&nbsp;</td>
							</tr>
						</table>
						<br>
					</div>
					</td>
				</tr>
			</table>
		</td>
	</tr>
<%
	}
%>
</table>

<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
	<tr>
		<td>
			<table align="center" cellspacing="0" cellpadding="0" width="85%" border="0" style="table-layout:fixed">
<%
	if (s_pdf != null && s_pdf.equalsIgnoreCase("true") && tm_threshData.size()>0)
	{
%>
				<tr>
					<td width="100%">
						<table cellspacing="0" cellpadding="3" width="100%" border="0">
							<tr>
								<td align="left" width="100%" id="eg_title">&nbsp;</td>
								<td align="right" width="25" valign="middle"><a class="head"><img class="mouse" src="/final/admin/eg_images/<%=admin_Skin%>/icon_save.gif" border="0" title="SAVE" onClick="javascript:savePdf('<%=admin_Skin%>');"></a></td>
								<td nowrap width="25" align="center"><a class="head"><img class="mouse" src="/final/admin/eg_images/<%=admin_Skin%>/print_audit.gif" border="0" title="PRINT" onClick="javascript:printData();"></a></td>
								<td nowrap width="25"><a class="head"><img class="mouse" src="/final/admin/eg_images/<%=admin_Skin%>/csv_audit.gif" border="0" title="CSV" onClick="javascript:csvData();"></a></td>
							</tr>
						</table>
					</td>
				</tr>
<%
	}

	ArrayList printData = new ArrayList();
	printData.add(s_forPdfTitle);
	if (finn != null && finn.equals("yes"))
	{
		if(tm_threshData.size() > 0)
		{
			// pdf work
			ArrayList tableList = new ArrayList();
			EgPdfData pdfData = new EgPdfData();
			EgReportAttributes reportAttributes = new EgReportAttributes();
			reportAttributes.setMainTitle(mappingInfo.getTextDescription("admin.threshold.Threshold Report"));
			reportAttributes.setSubTitle(s_forPdfTitle);
			reportAttributes.setReportName("Threshold");
			reportAttributes.setModule("ADMIN");
			reportAttributes.setPortrait(true);
			pdfData.setAttributes(reportAttributes);
			Iterator itr = tm_threshData.keySet().iterator();
			while(itr.hasNext())
			{
				String key = (String) itr.next();
				String HYPHEN = "";
				Vector v_title =(Vector) tm_threshData.get(key);
				//recent change
				if(v_title.size() == 2)
				{
					HYPHEN = " - ";
				}
%>
				<tr>
					<td colspan="6" nowrap>
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
							<tr>
								<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
								<td width="100%" align="left" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px"> <b><egui:intnl test="<%=key%>" />
<%
				if(!isDefThreshTemp && !isFixThreshTemp)
				{
					if(v_title.size() == 2) /*thresholdTypes.contains(v_title.get(0)) ||*/
					{
						out.println(HYPHEN+_mapping.getTextDescription("admin.threshold."+v_title.get(0)));
					}
					//else
					//out.println(v_title.get(0));
				}
%>
								</b> </td>
								<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
							</tr>
						</table>
					</td>
				</tr>

				<tr>
					<td colspan="6" id="table_border" class="padding6 eg_morelight">
<%
				for (int x=0;x<v_title.size();x+=2)
				{
%>
						<table border="0" cellspacing="0" cellpadding="0" width="100%">
<%
					String title = (String) v_title.get(x);
					if(title.equalsIgnoreCase("Default"))
						title = mappingInfo.getTestDescription(key);
					else if (title.equalsIgnoreCase("Fixed"))
						title = mappingInfo.getTestDescription(key)+" ["+_mapping.getTextDescription("admin.threshold.Fixed")+"]";
					else
						title = mappingInfo.getTestDescription(key) + ":" +title;
					//pdf work
					ArrayList aListData = new ArrayList();

					//recent change
					if(v_title.size() > 2)
					{
						if (x > 0)
						{
%>
							<tr><td>&nbsp;</td></tr>
<%
						}
%>
							<tr>
								<td colspan="6" width="98%" nowrap style="border-bottom-width:0px;border-left-width:1px" class="space3"><b><%=((String)v_title.get(x)).toUpperCase()%></b></td>
							</tr>
<%
					}

					//Print work
					printData.add(title);
					// pdf work
					ArrayList aListColumnNames = new ArrayList();
					for(int k=0; k<6; k++) aListColumnNames.add("C"+k);

					ArrayList userColumnNames = new ArrayList();
					userColumnNames.add(_mapping.getTextDescription("admin.threshold.Measurements"));
					userColumnNames.add(_mapping.getTextDescription("admin.threshold.Min-Absolute"));
					userColumnNames.add(_mapping.getTextDescription("admin.threshold.Min-Relative"));
					userColumnNames.add(_mapping.getTextDescription("admin.threshold.Max-Absolute"));
					userColumnNames.add(_mapping.getTextDescription("admin.threshold.Max-Relative"));
					userColumnNames.add(_mapping.getTextDescription("admin.threshold.Alarm Policy"));

					//ArrayList groups = new ArrayList();
					//groups.add(_mapping.getTextDescription("admin.threshold.Measurements"));
					//groups.add(_mapping.getTextDescription("admin.threshold.Minimum"));
					//groups.add(_mapping.getTextDescription("admin.threshold.Maximum"));
					//groups.add(_mapping.getTextDescription("admin.threshold.Alarm Policy"));

					//ArrayList grpColumnMapping = new ArrayList();
					//grpColumnMapping.add("0");
					//grpColumnMapping.add("1#2");
					//grpColumnMapping.add("3#4");
					//grpColumnMapping.add("5");

					EgTableAttributes egTableAttributes = new EgTableAttributes();
					egTableAttributes.setTitle(title);
					egTableAttributes.setStartX(0);
					egTableAttributes.setColumnNames(userColumnNames);
					//egTableAttributes.setGroups(groups);//Table column Grouping Names
					//egTableAttributes.setGroupColumnMapping(grpColumnMapping); // Table column index for grouping
%>
						</table>

						<table align="center" width="100%" cellspacing="0" cellpadding="3" border="0" id="cell_border1"><col width="29%"><col width="29%"><col width="29%"><col width="13%">
							<tr>
								<td id="table_head" align="center" height="20"><b><egui:intnl text="admin.threshold.Measurements"/></b></td>
								<td id="table_head" class="lineleft" align="center"><b><egui:intnl text="admin.threshold.Minimum"/></b></td>
								<td id="table_head" class="lineleft" align="center"><b><egui:intnl text="admin.threshold.Maximum"/></b></td>
								<td id="table_head" class="lineleft" align="center"><b><egui:intnl text="admin.threshold.Alarm Policy"/></b></td>
							</tr>
							<tr>
								<td id="eg_cellbgmedium" class="eg_subcontent" align="left" Height="20">&nbsp;</td>
								<td id="eg_cellbgmedium" class="eg_subcontent" align="center">
									<table cellspacing="0" cellpadding="1" border="0" width="100%" >
										<tr>
											<td align="center" width="42%" class="eg_subcontent"><egui:intnl text="admin.threshold.Absolute"/></td>
											<td width="68%" align="center" class="eg_subcontent"><egui:intnl text="admin.threshold.Relative"/></td>
										</tr>
									</table>
								</td>
								<td id="eg_cellbgmedium" class="eg_subcontent" align="center">
									<table cellspacing="0" cellpadding="1" border="0" width="100%" >
										<tr>
											<td align="center" width="42%" class="eg_subcontent"><egui:intnl text="admin.threshold.Absolute"/></td>
											<td width="68%" align="center" class="eg_subcontent"><egui:intnl text="admin.threshold.Relative"/></td>
										</tr>
									</table>
								</td>
								<td id="eg_cellbgmedium" class="eg_subcontent" align="left">&nbsp;</td>
							</tr>
<%
					Vector v_data1 = (Vector)v_title.get(x+1);
					boolean cellFlag=false;
					for(int y=0;y<v_data1.size();y+=5)
					{
						val[0] = (String)v_data1.get(y);
						val[1] = (String)v_data1.get(y+1);
						val[2] = (String)v_data1.get(y+2);
						val[3] = (String)v_data1.get(y+3);
						val[4] = (String)v_data1.get(y+4);
						if(val[1].equals("-1"))
						{
							val[1]=defValue;
						}
						if(val[2].equals("-1"))
						{
							val[2]=defValue;
						}
						if(val[3].equalsIgnoreCase("none"))
						{
							val[3]=defValue;
						}
						/*if(val[1].equalsIgnoreCase(defValue) && val[2].equalsIgnoreCase(defValue) && val[3].equalsIgnoreCase(defValue))
						{
							val[4] = "not applicable";
						}*/
						if (globalThresholds!=null && globalThresholds.contains(key))
						{
							if (val[1].indexOf("sqc")>-1)
							{
								if(val[1].indexOf("&")>-1)
								{
									val[1]=val[1].substring(0,val[1].indexOf("&"));
								}
								else
								{
									val[1] = defValue;
								}
							}
							if (val[2].indexOf("sqc")>-1)
							{
								if(val[2].indexOf("&")>-1)
								{
									val[2]=val[2].substring(0,val[2].indexOf("&"));
								}
								else
								{
									val[2] = defValue;
								}
							}
							if (val[2].equals(defValue) && val[1].equals(defValue))
							{
								val[3] = "none";
								//val[4] = "not applicable" ;
							}
							//else
								//val[3]="absolute";
						}
						Vector _vecMin = getAbsAndRel(val[1]);
						Vector _vecMax = getAbsAndRel(val[2]);
%>
							<tr>
								<td id="<%=cellFlag?"cell_border3":"cell_border4"%>" height="22" class="space3"><egui:intnl measure='<%=key+":"+val[0]%>'/>&nbsp;&nbsp;(<%=tables_info.getUnitForMeasure(key,val[0])%>)</td>
								<td id="<%=cellFlag?"cell_border3":"cell_border4"%>" class="space3">
									<table cellspacing="0" cellpadding="0" border="0" width="100%">
										<tr>
											<td width="49%"> <%=_vecMin.get(0)%> </td>
											<td width="20">&nbsp;</td>
											<td width="49%"><%=_vecMin.get(1)%></td>
										</tr>
									</table>
								</td>
								<td id="<%=cellFlag?"cell_border3":"cell_border4"%>" class="space3">
									<table cellspacing="0" cellpadding="0" border="0" width="100%">
										<tr>
											<td width="49%"><%=_vecMax.get(0)%></td>
											<td width="20">&nbsp;</td>
											<td width="49%"><%=_vecMax.get(1)%></td>
										</tr>
									</table>
								</td>
<%
						if (defaultPolicies.contains(val[4]))
						{
%>
								<td id="<%=cellFlag?"cell_border3":"cell_border4"%>" class="space3"><egui:intnl text='<%="admin.threshold."+val[4]%>'/></td>
<%
						}
						else
						{
%>
								<td id="<%=cellFlag?"cell_border3":"cell_border4"%>" class="space3"><%=val[4]%></td>
<%
						}
%>
							</tr>
<%
						//pdf work
						String measurePdf = mappingInfo.getMeasureDescription(key,val[0]) + " (" + tables_info.getUnitForMeasure(key,val[0]) + ")";
						aListData.add(measurePdf);
						aListData.add(_vecMin.get(0));
						aListData.add(_vecMin.get(1));
						aListData.add(_vecMax.get(0));
						aListData.add(_vecMax.get(1));
						if (defaultPolicies.contains(val[4]))
							aListData.add(_mapping.getTextDescription("admin.threshold."+val[4]));
						else
							aListData.add(val[4]);

						cellFlag=!cellFlag;
					}

					//pdf work
					EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
					printData.add(aListData);
					EgTable egTable = new EgTable();
					egTable.setModel(egTableModel);
					egTable.setAttributes(egTableAttributes);

					tableList.add(egTable);
%>
						</table>
<%
				}
%>
					</td>
				</tr>
				<tr>
					<td id="eg_blnkspace" height="10">&nbsp;</td>
				</tr>
<%
			}
			//pdf work
			pdfData.setData(tableList);
			session.setAttribute("pdfData",pdfData);
			session.setAttribute("thPrData",printData);
		}
		else
		{
%>
				<tr>
					<td colspan="7" align="center" valign="middle"  height="200" class="eg_subhead">
						<img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br> &nbsp;&nbsp;&nbsp;<egui:intnl text="admin.threshold.No Data Available For The Combination Chosen"/>
					</td>
				</tr>
<%
		}
	}
%>
			</table>
		</td>
	</tr>
</table>
</form>
</body>
</html>
<%!
	// T.Thirumal Azhagan    Monday, March 27, 2006
	public Vector getAbsAndRel(String format) // for mix format in threshold ,introduced by BOSS(MIX)
	{
		Vector vect = new Vector();	// [absolute,relative]
		StringTokenizer stok1 = new StringTokenizer(format,"/");
		if (!format.equals("-1") && stok1.countTokens() == 3)
		{
			String h;
			String m;
			String l;
			String H = stok1.nextToken();
			String M = stok1.nextToken();
			String L = stok1.nextToken();
			if (!(H.equals("-")))
			{
				if (H.indexOf("&") > -1)
				{
					StringTokenizer st = new StringTokenizer(H,"&");
					H = st.nextToken();
					h = st.nextToken();
				}
				else
				{
					if (H.indexOf("sqc") > -1)
					{
						h = H;
						H = "-";
					}
					else
						h = "-";
				}
			}
			else
			{
				h = "-";
			}
			if (!(M.equals("-")))
			{
				if (M.indexOf("&") > -1)
				{
					StringTokenizer st = new StringTokenizer(M,"&");
					M = st.nextToken();
					m = st.nextToken();
				}
				else
				{
					if (M.indexOf("sqc") > -1)
					{
						m = M;
						M = "-";
					}
					else
						m = "-";
				}
			}
			else
			{
				m = "-";
			}
			if (!(L.equals("-")))
			{
				if (L.indexOf("&") > -1)
				{
					StringTokenizer st = new StringTokenizer(L,"&");
					L = st.nextToken();
					l = st.nextToken();
				}
				else
				{
					if (L.indexOf("sqc") > -1)
					{
						l = L;
						L = "-";
					}
					else
						l = "-";
				}
			}
			else
			{
				l = "-";
			}
			StringBuffer sb2 = new StringBuffer();
			StringBuffer sb1 = new StringBuffer();
			String s1 = null;
			if (H.equals("-") && M.equals("-") && L.equals("-"))
			{
				s1 = "none";
			}
			else
			{
				sb1.append(H);
				sb1.append("/");
				sb1.append(M);
				sb1.append("/");
				sb1.append(L);
				s1 = sb1.toString();
			}
			String s2 = null;
			if (h.equals("-") && m.equals("-") && l.equals("-"))
			{
				vect.add(s1);
				vect.add("none");
			}
			else
			{
				sb2.append(h);
				sb2.append("/");
				sb2.append(m);
				sb2.append("/");
				sb2.append(l);
				s2 = sb2.toString();
				vect.add(s1);
				vect.add(s2);
			}
		}
		else
		{
			vect.add("none");
			vect.add("none");
		}
		return vect;
	}

	public String removeNull(String component)
	{
		return (component.endsWith(":NULL"))?component.substring(0,component.indexOf(":NULL")):component;
	}

	public boolean isListContainsTest(ArrayList a1,ArrayList a2)
	{
		boolean b = false;
		for(int i=0;i<a2.size();i++)
		{
			String temp = (String)a2.get(i);
			if(a1.contains(temp))
			{
				b = true;
				break;
			}
		}
		return b;
	}
%>

<%
	if(request.getQueryString()!=null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgThreshDetail.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgThreshDetail.jsp");
	}
%>



