<%
/*
 *   File				:	EgMailAlertSuppress.jsp
 *   Purpose			:	Provide UI functionality for filter mail alerts configuration.
 *   Creation Date		:	15/02/2009
 *   Author				: 	Maruthu
 *   UI Design			:	Jaiwin
 */
%>

<%@ include file="EgTrackerA.jsp"%>
<%@ page errorPage = "EgProbs.jsp"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgMailAlertInfo"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<jsp:useBean id="userDetails" class="com.egurkha.admin.UserDetailsBean" scope="page"/>

<%
	String entry =(String)request.getParameter("entry");
	if(entry ==null || entry.equalsIgnoreCase("null"))
		entry = "admin";
	String userLanguage = _user.getLanguage();
	IniUI iniUI = IniUI.getInstance();
	if (userLanguage == null)
	{
		userLanguage = iniUI.getDefaultLanguage();
	}
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + "eg_ui.ini");
	String isHostSystem=egUI.getValue("HOST_SYSTEM","Show_HostSystem");
	isHostSystem=(isHostSystem==null || isHostSystem.trim().length()==0)?"CompType":isHostSystem;

	if(isHostSystem.equalsIgnoreCase("HostSystem"))
	{
		isHostSystem="Yes";
	}
	else if(isHostSystem.equalsIgnoreCase("OS"))
	{
		isHostSystem="No";
	}
	else
	{
		isHostSystem="No";
	}

	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	ArrayList excludedLayers = null;
	ArrayList excludedCompTypes = null;
	ArrayList excludedComponents = null;
	ArrayList allExcludedLayersByType = null;
	ArrayList excludedTests = null; // ALL
	ArrayList exculdedTestsForAllTypes = null; // By component type wise

	List types = null;
	ArrayList aListUserID = null;
	ArrayList aListCompTypes = null;
	ArrayList aListAssociatedValues = null;
	ArrayList aListDisAssociatedValues = null;

	String title = "";
	String width = "118";
	String previousExcVal = "";
	String showUser = null;
	String HOST_SYSTEM = "Host_system";
	String userID = request.getParameter("userID");
	String filterBy = request.getParameter("filterBy");
	String serverType = request.getParameter("serverType");
	String reqFrom = request.getParameter("reqfrom");

	userID = (userID == null ? "":userID);
	filterBy = (filterBy == null ? "":filterBy);
	serverType = (serverType == null ? "":serverType);
	reqFrom = (reqFrom == null ? "":reqFrom);

	EgUserRole role = _user.getUserRole();
	if(role != null)
	{
		String loginID = _user.getLoginID();
		long adminPerm = role.getAdminPerm();
		boolean hasAllCompAccess = role.hasAllComponentAccess();
		//show the selected user only when the new user is added or modifying existing user.
		if(reqFrom.equals("add") || reqFrom.equals("modify"))
		{
			aListUserID = new ArrayList();
			aListUserID.add(userID);
		}
		// if block -> for admin 
		// else block -> for other users.
		else if(hasAllCompAccess && adminPerm>0)
		{
			// Get the valid users. valid users means read below points..
			// mail id must be configured 
			// component must be associated
			// must be Non-expired users.
			aListUserID = userDetails.getAllValidUsersWithMonAccess(true,true);
			//pop the details of the user who is logging currently.
			if(aListUserID != null && aListUserID.size() > 0)
			{
				if(userID.equals(""))
				{
					userID = loginID;
				}
			}
		}
		else
		{
			showUser = request.getParameter("showUser");
			if(showUser == null || showUser.equals("0") || showUser.equals("yes"))
			{
				aListUserID = new ArrayList();
				aListUserID.add(loginID);
				userID = loginID;
			}
			else
			{
				aListUserID = null;
			}
		}
	}
	boolean isFilterByAllTest = false;
	boolean isFilterByAllLayer = false;
	boolean isFilterByLayer = filterBy.equals("filterByLayer");
	boolean isFilterByCName = filterBy.equals("filterByCName");
	boolean isFilterByCType = filterBy.equals("filterByCType");
	boolean isFilterByTest = filterBy.equals("filterByTest");
	if(isFilterByLayer)
	{
		isFilterByAllLayer = serverType.equals("filterByAll");
	}

	if (isFilterByTest)
	{
		isFilterByAllTest = serverType.equals("filterByAll");
	}

	/*only one user in the list*/
	if(aListUserID != null && aListUserID.size() == 1)
	{
		userID = (String)aListUserID.get(0);
	}
	/**/

	if(userID.length() > 0)
	{
%>
		<jsp:setProperty name="userDetails" property="userID" value="<%=userID%>"/>
<%
		userDetails.createUserObj();
		aListCompTypes = userDetails.getAllServerTypes();
		types = new ArrayList(aListCompTypes);
		if(aListCompTypes != null && aListCompTypes.size() > 0)
		{
			EgMailAlertInfo mailAlertInfo = new EgMailAlertInfo();
			mailAlertInfo.forceTheUpdateCheck();
			mailAlertInfo.createMemCopyForUser(userID);
			excludedLayers = mailAlertInfo.getExcludedLayersForUser(userID);
			excludedCompTypes = mailAlertInfo.getExcludedCompTypesForUser(userID);
			excludedComponents = mailAlertInfo.getExcludedCompNamesForUser(userID);
			allExcludedLayersByType = mailAlertInfo.getAllExcludedLayersByType(userID);
			excludedTests = mailAlertInfo.getExcludedTests(userID);
			exculdedTestsForAllTypes = mailAlertInfo.getExcludedTestsForAllTypes(userID);

			//Remove excluded comp types from all comp types list for the selected user
			if(excludedCompTypes != null && aListCompTypes != null)
			{
				aListCompTypes.removeAll(excludedCompTypes);
			}

			boolean isHostSysExculded = excludedCompTypes != null && excludedCompTypes.contains(HOST_SYSTEM);
			excludedComponents = userDetails.removeExcCompTypesElems1(excludedCompTypes,excludedComponents);
			excludedLayers = userDetails.removeExcCompTypesElems2(excludedLayers,aListCompTypes,isHostSysExculded);
			allExcludedLayersByType = userDetails.removeExcCompTypesElems3(excludedCompTypes,allExcludedLayersByType);

			if(isFilterByCName)
			{
				title = "COMPONENTS";
				width = "50";
				aListAssociatedValues = userDetails.getComponentsForServerType(serverType);
				aListDisAssociatedValues = mailAlertInfo.getExcludedCompNamesForType(userID,serverType);
			}
			else if(isFilterByCType)
			{
				title = "COMPONENT TYPES";
				aListAssociatedValues = aListCompTypes;
				aListDisAssociatedValues = excludedCompTypes;
			}
			else if(isFilterByLayer)
			{
				width = "50";
				title = "LAYERS";
				if(isFilterByAllLayer)
				{
					aListAssociatedValues = userDetails.getAllLayers(excludedCompTypes);
					aListDisAssociatedValues = excludedLayers;

					// Remove the layers thats exculded by Server type wise
					List excLayers = userDetails.getUniqueExcLayers(allExcludedLayersByType,aListCompTypes);
					if(excLayers != null && excLayers.size() > 0)
					{
						if(aListAssociatedValues != null)
						{
							aListAssociatedValues.removeAll(excLayers);
						}
					}
				}
				else
				{
					// Remove the all Host_system layers from the layers of the selected comp type incase Host_system type is excluded.
					aListAssociatedValues = userDetails.getLayersForServerType(serverType,isHostSysExculded);
					aListDisAssociatedValues = mailAlertInfo.getExcludedLayersByTypeForUser(userID,serverType);

					// Remove the Host_system layers from the layers of the selected comp type incase any layers from Host_system is excluded.
					if(isHostSysExculded == false)
					{
						List excLayers = mailAlertInfo.getExcludedLayersByTypeForUser(userID,HOST_SYSTEM);
						if(excLayers != null && excLayers.size() > 0)
						{
							if(aListAssociatedValues != null)
							{
								aListAssociatedValues.removeAll(excLayers);
							}
						}
					}
				}

				//Remove the excluded layers[through all layers] of type from associated box value
				if(aListAssociatedValues != null && excludedLayers != null)
				{
					aListAssociatedValues.removeAll(excludedLayers);
				}
			}
			else if (isFilterByTest)
			{
				width = "50";
				title = "TESTS";
				if (isFilterByAllTest)
				{
					aListAssociatedValues = userDetails.getAllTests(excludedCompTypes);
					aListDisAssociatedValues = excludedTests;
				}
				else
				{
					aListAssociatedValues = userDetails.getTestsForServerType(serverType,isHostSysExculded);
					aListDisAssociatedValues = mailAlertInfo.getExcludedTestsForType(userID,serverType);

					//Remove tests which are excluded by ALL from associated box value
					if(aListAssociatedValues != null && excludedTests != null)
					{
						aListAssociatedValues.removeAll(excludedTests);
					}
				}

				// Remove tests which are exculded by host system type from ALL and Component type.
				List excHostsTests = mailAlertInfo.getExcludedTestsForType(userID,HOST_SYSTEM);
				if (excHostsTests != null && excHostsTests.size() > 0)
				{
					if(aListAssociatedValues != null )
					{
						aListAssociatedValues.removeAll(excHostsTests);
					}
				}
			}

			if(aListDisAssociatedValues != null && aListDisAssociatedValues.size() > 0)
			{
				previousExcVal = aListDisAssociatedValues.toString();
				previousExcVal = previousExcVal.substring(1,previousExcVal.length()-1);
				previousExcVal = StringUtils.replace(previousExcVal,", ",",");
				if(aListAssociatedValues != null && aListAssociatedValues.size() > 0)
				{
					aListAssociatedValues.removeAll(aListDisAssociatedValues);
				}
			}
		}
	}
%>
<script language="javascript1.2">

function popUserDetails()
{
	var page = "";
	var userID = "";
	var thisForm = document.mailSuppress;
	if(thisForm.userID != null && thisForm.userID != "undefined")
	{
		if(thisForm.userID.type == "select-one")
			userID = thisForm.userID.options[thisForm.userID.selectedIndex].value;
		else
			userID = thisForm.userID.value;
	}
	if(userID != -1)
	{
		page = "EgMailAlertSuppress.jsp?userID="+encodeURIComponent(userID)+'&entry=<%=entry%>&reqfrom=<%=reqFrom%>';
	}
	else
	{
		page ="EgMailAlertSuppress.jsp"+'?entry=<%=entry%>&reqfrom=<%=reqFrom%>';
	}
	window.location.href = page;
}

function popFilterDetails()
{
	var userID = "";
	var thisForm = document.mailSuppress;
	var filterBy = thisForm.filter.options[thisForm.filter.selectedIndex].value;
	if(thisForm.userID != null && thisForm.userID != "undefined")
	{
		if(thisForm.userID.type == "select-one")
			userID = thisForm.userID.options[thisForm.userID.selectedIndex].value;
		else
			userID = thisForm.userID.value;
	}
	if(userID == -1)
	{
		alert('<egui:intnl text = "admin.filter.Please choose a user id"/>');
		thisForm.filter.options.selectedIndex = 0;
		thisForm.userID.focus();
		return;
	}
	var page ="EgMailAlertSuppress.jsp?userID="+encodeURIComponent(userID);
	if(filterBy != -1)
	{
		page = page+"&filterBy="+filterBy;
		if(filterBy == "filterByCName")
		{
			page = page + "&serverType=-1";
		}
		else if(filterBy == "filterByLayer" || filterBy == "filterByTest")
		{
			page = page + "&serverType=filterByAll";
		}
	}
	page = page+'&entry=<%=entry%>&reqfrom=<%=reqFrom%>';
	window.location.href = page;
}

function popCompTypes()
{
	var userID = "";
	var serverType = "-1";
	var thisForm = document.mailSuppress;
	var filterBy = thisForm.filter.options[thisForm.filter.selectedIndex].value;
	if(thisForm.userID != null && thisForm.userID != "undefined")
	{
		if(thisForm.userID.type == "select-one")
			userID = thisForm.userID.options[thisForm.userID.selectedIndex].value;
		else
			userID = thisForm.userID.value;
	}
	var compTypesBoxExist = (thisForm.CompTypes != null && thisForm.CompTypes != "undefined");
	if(compTypesBoxExist)
	{
		serverType = thisForm.CompTypes.options[thisForm.CompTypes.selectedIndex].value;
	}
	window.location.href = "EgMailAlertSuppress.jsp?userID="+encodeURIComponent(userID)+"&filterBy="+filterBy+"&serverType="+serverType+'&entry=<%=entry%>&reqfrom=<%=reqFrom%>';
}

function addToExcluded()
{
	var userID = "";
	var thisForm = document.mailSuppress;
	var filterBy = thisForm.filter.options[thisForm.filter.selectedIndex].value;
	if(thisForm.userID != null && thisForm.userID != "undefined")
	{
		if(thisForm.userID.type == "select-one")
			userID = thisForm.userID.options[thisForm.userID.selectedIndex].value;
		else
			userID = thisForm.userID.value;
	}
	var filterBy = thisForm.filter.options[thisForm.filter.selectedIndex].value;
	var includedList = thisForm.include;
	var excludedList = thisForm.exclude;
	var includedListLength = includedList.options.length;
	var excludedListLength = excludedList.options.length;
	var optChoosen = 0;
	for(var i=0;i<includedListLength;i++)
	{
		if(includedList.options[i].selected == true)
		{
			var text = includedList.options[i].text;
			var value = includedList.options[i].value;
			excludedList.options[excludedListLength++] = new Option(text,value);
			includedList.options[i] = null;
			includedListLength --;
			i--;
			optChoosen++;
		}
	}

	if (optChoosen == 0)
	{
		if (filterBy == "filterByCType")
		{
			alert('<egui:intnl text = "admin.filter.Please choose a component type to exclude"/>');
		}
		else if (filterBy == "filterByCName")
		{
			
			var compTypesVal = thisForm.CompTypes.options[thisForm.CompTypes.selectedIndex].value;
			if (compTypesVal == "-1")
			{
				alert('<egui:intnl text = "admin.filter.Please choose a component type"/>');
			}
			else
			{
				alert('<egui:intnl text = "admin.filter.Please choose a component name to exclude"/>');
			}
		}
		else if (filterBy == "filterByLayer")
		{
			alert('<egui:intnl text = "admin.filter.Please choose a layer to exclude"/>');
		}
		else if (filterBy == "filterByTest")
		{
			alert('<egui:intnl text = "admin.filter.Please choose a test to exclude"/>');
		}
		else
		{
			alert('<egui:intnl text = "admin.filter.Please choose a filter by option to exclude"/>');
		}
	}

	//var previousExcVal = "<%=previousExcVal%>";
	//var currentExcValues = new Array();
	//for(var j=0;j<excludedListLength;j++)
	//{
	//	currentExcValues[j] = excludedList.options[j].value;
	//}
	// ** Disable the assign button when no comp is associated
	//if(isEqualStr(previousExcVal,currentExcValues) == 0)
	//{
		// Enable the assign button
	//	if(thisForm.apply != null && thisForm.apply != "undefined")
	//		thisForm.apply.disabled = false;
	//}
	//else
	//{
		// Disable the assign button
	//	if(thisForm.apply != null && thisForm.apply != "undefined")
	//		thisForm.apply.disabled = true;
	//}
}

//return 1 : equal string 
//return 0 : not equal string

function isEqualStr(s1,s2)
{
	if(s1 == s2)
		return 1;
	if(s1 == "" && s2 != "")
		return 0;
	if(s1 != "" && s2 == "")
		return 0;

	var v1 = s1.split(",");
	var v2 = s2.toString().split(",");
	if(v1.length != v2.length)
		return 0;

	var result = "";
	for(var i=0;i<v1.length;i++)
	{
		var flag = false;
		for(var j=0;j<v2.length;j++)
		{
			if(v1[i] == v2[j])
			{
				flag = true;
				break;
			}
		}
		if(flag)
			result += "1"+",";
		else
			result += "0"+",";
	}
	result = result.substring(0,result.length-1);
	if(result.indexOf("0") >= 0)
		return 0;
	else
		return 1;
}

function addToIncluded()
{
	var userID = "";
	var thisForm = document.mailSuppress;
	var filterBy = thisForm.filter.options[thisForm.filter.selectedIndex].value;
	if(thisForm.userID != null && thisForm.userID != "undefined")
	{
		if(thisForm.userID.type == "select-one")
			userID = thisForm.userID.options[thisForm.userID.selectedIndex].value;
		else
			userID = thisForm.userID.value;
	}
	var includedList = thisForm.include;
	var excludedList = thisForm.exclude;
	var includedListLength = includedList.options.length;
	var excludedListLength = excludedList.options.length;
	//var currentExcValues = new Array();
	//var previousExcVal = "<%=previousExcVal%>";
	var optChoosen = 0;
	for(var i=0;i<excludedListLength;i++)
	{
		if(excludedList.options[i].selected == true)
		{
			var text = excludedList.options[i].text;
			var value = excludedList.options[i].value;
			includedList.options[includedListLength++] = new Option(text,value);
			excludedList.options[i] = null;
			excludedListLength --;
			i--;
			optChoosen++;
		}
		//else
		//{
		//	currentExcValues[i] = excludedList.options[i].value;
		//}
	}
	// ** Disable the assign button when no comp is associated
	//if(isEqualStr(previousExcVal,currentExcValues) == 0)
	//{
	//	// Enable the assign button
	//	if(thisForm.apply != null && thisForm.apply != "undefined")
	//		thisForm.apply.disabled = false;
	//}
	//else
	//{
		// Disable the assign button
	//	if(thisForm.apply != null && thisForm.apply != "undefined")
	//		thisForm.apply.disabled = true;
	//}

	if (optChoosen == 0)
	{
		if (filterBy == "filterByCType")
		{
			alert('<egui:intnl text = "admin.filter.Please choose a component type to include"/>');
		}
		else if (filterBy == "filterByCName")
		{
			var compTypesVal = thisForm.CompTypes.options[thisForm.CompTypes.selectedIndex].value;
			if (compTypesVal == "-1")
			{
				alert('<egui:intnl text = "admin.filter.Please choose a component type"/>');
			}
			else
			{
				alert('<egui:intnl text = "admin.filter.Please choose a component name to include"/>');
			}
		}
		else if (filterBy == "filterByLayer")
		{
			alert('<egui:intnl text = "admin.filter.Please choose a layer to include"/>');
		}
		else if (filterBy == "filterByTest")
		{
			alert('<egui:intnl text = "admin.filter.Please choose a test to include"/>');
		}
		else
		{
			alert('<egui:intnl text = "admin.filter.Please choose a filter by option to include"/>');
		}
	}
}

function update(action)
{
	var userID = "";
	var thisForm = document.mailSuppress;
	var filterBy = thisForm.filter.options[thisForm.filter.selectedIndex].value;
	if(thisForm.userID != null && thisForm.userID != "undefined")
	{
		if(thisForm.userID.type == "select-one")
			userID = thisForm.userID.options[thisForm.userID.selectedIndex].value;
		else
			userID = thisForm.userID.value;
	}
	if(userID == -1)
	{
		alert('<egui:intnl text = "admin.filter.Please choose a user id"/>');
		thisForm.userID.focus();
		return;
	}
	if(userID != -1 && filterBy != -1)
	{
		if("<%=reqFrom%>" == "profile")
		{
			var compTypesBoxExist = (thisForm.CompTypes != null && thisForm.CompTypes != "undefined");
			if(compTypesBoxExist)
			{
				if(thisForm.CompTypes.options[thisForm.CompTypes.selectedIndex].value == "-1")
				{
					alert('<egui:intnl text = "admin.filter.Please choose a type"/>');
					thisForm.CompTypes.focus();
					return;
				}
			}
		}
		var arrInc = new Array();
		var arrExc = new Array();
		for(var i=0;i<thisForm.include.options.length;i++)
		{
			arrInc[i] = thisForm.include.options[i].value
		}
		for(i=0;i<thisForm.exclude.options.length;i++)
		{
			arrExc[i] = thisForm.exclude.options[i].value
		}
		
		if(thisForm.excludedBoxHostVal!=null && thisForm.excludedBoxHostVal!=undefined)
		{
			var valueHost=thisForm.excludedBoxHostVal.value;
			if(valueHost!=null && valueHost!="")
			{
				arrExc[arrExc.length]=valueHost;
			}
		}
		thisForm.includedBoxVal.value=arrInc;
		thisForm.excludedBoxVal.value=arrExc;
	}
	else if(userID != -1)
	{
		if("<%=reqFrom%>" == "profile")
		{
			alert('<egui:intnl text = "admin.filter.Please choose a filter"/>');
			thisForm.filter.focus();
			return;
		}
	}
	if(action.name == 'apply' || action.name == 'updateC')
	{
		action.disabled = true;
		thisForm.control.value = "addMore";
		action.value = '<egui:intnl text="admin.filter.Updating"/>'+"...";
	}
	else
	{
		action.disabled = true;
		thisForm.control.value = "finish";
		action.value = "<egui:intnl text='admin.filter.Updating'/>"+"...";
	}
	thisForm.submit();
}

function goToBack()
{
	var backID = document.getElementById('backHref');
	if(backID != null)
	{
		var backPage = backID.getAttribute("value");
		var idx = backPage.indexOf("=")+1;
		var page = backPage.substring(idx+1,backPage.length-1);
		window.location.href = page;
	}
}

function showImage(index)
{
	var result="asc";
	var hide = new Array();
	hide = document.getElementsByTagName("img");
	for (i=0; i<hide.length; i++)
	{
		img_id = hide[i].id;
		if(img_id==null || img_id.length==0)
			continue;
		img_id = img_id.substring(3);
		if(img_id==index)
		{
			src = hide[i].src;
			if(src.indexOf("headarrow_up.gif")=="-1")
			{
				hide[i].src="/final/admin/eg_images/headarrow_up.gif";
				result = "des";
			}
			else
			{
				hide[i].src="/final/admin/eg_images/headarrow_down.gif";
				result = "asc";
			}
			hide[i].style.display = '';
		}
	}
	return result;
}

var reverseSort = new Array(false,false,false,false,false,false,false,false,false,false);
var previousColumn  = 1;
var currentColumn = 1;
var res = "";
function sortTable(col,pos)
{
	currentColumn = col;
	var tblEl = document.getElementById('rsTable'+pos);
	if(tblEl.rows.length >= 50)
	{
		return false;
	}
	if (col == previousColumn)
		previousColumn = col;

	var oldDsply = tblEl.style.display;
	tblEl.style.display = "none";
	res = showImage(pos);
	if(res=="des")
	{
		reverseSort[col] = true;
	}
	else
	{
		reverseSort[col] = false;
	}
	var tmpEl;
	var i, j;
	var minVal, minIdx;
	var testVal;
	var cmp;
	for (i = 0; i < tblEl.rows.length - 1; i++)
	{
		// Assume the current row has the minimum value.
		minIdx = i;
		minVal = getTextValue(tblEl.rows[i].cells[col]);
		// Search the rows that follow the current one for a smaller value.
		for (j = i + 1; j < tblEl.rows.length; j++)
		{
			testVal = getTextValue(tblEl.rows[j].cells[col]);
			cmp = compareValues(minVal,testVal);
			// Negate the comparison result if the reverse sort flag is set.
			if (reverseSort[col])
				cmp = -cmp;
			// Sort by the second column (team name) if those values are equal.
			if (cmp == 0 && col != 1)
				cmp = compareValues(getTextValue(tblEl.rows[minIdx].cells[1]),getTextValue(tblEl.rows[j].cells[1]));
			// If this row has a smaller value than the current minimum, remember its
			// position and update the current minimum value.
			if (cmp > 0)
			{
				minIdx = j;
				minVal = testVal;
			}
		}
		// By now, we have the row with the smallest value. Remove it from the
		// table and insert it before the current row.
		if (minIdx > i)
		{
			tmpEl = tblEl.removeChild(tblEl.rows[minIdx]);
			tblEl.insertBefore(tmpEl, tblEl.rows[i]);
		}
	}
	// Restore the table's display style.
	tblEl.style.display = oldDsply;
	return false;
}
//-----------------------------------------------------------------------------
// Functions to get and compare values during a sort.
//-----------------------------------------------------------------------------
// This code is necessary for browsers that don't reflect the DOM constants
// (like IE).
if (document.ELEMENT_NODE == null)
{
	document.ELEMENT_NODE = 1;
	document.TEXT_NODE = 3;
}

function getTextValue(el)
{
	var i;
	var s;
	// Find and concatenate the values of all text nodes contained within the  element.
	s = "";
	for (i = 0; i < el.childNodes.length; i++)
	{
		if (el.childNodes[i].nodeType == document.TEXT_NODE)
		{
			s += el.childNodes[i].nodeValue;
		}
		else if (el.childNodes[i].nodeType == document.ELEMENT_NODE && el.childNodes[i].tagName == "BR")
		{
			s += " ";
		}
		else
		{
			// Use recursion to get text within sub-elements.
			s += getTextValue(el.childNodes[i]);
		}
	}
	return normalizeString(s);
}

function compareValues(v1, v2)
{
	v1 = v1.toUpperCase();
	v2 = v2.toUpperCase();
	// Compare the two values.
	if (v1 == v2)
		return 0;
	if (v1 > v2)
		return 1

	return -1;
}

// Regular expressions for normalizing white space.
var whtSpEnds = new RegExp("^\\s*|\\s*$", "g");
var whtSpMult = new RegExp("\\s\\s+", "g");

function normalizeString(s)
{
	s = s.replace(whtSpMult, " ");  // Collapse any multiple whites space.
	s = s.replace(whtSpEnds, "");   // Remove leading or trailing white space.
	return s;
}
</script>

<egui:skin ui="<%=entry%>"/>
<html>
<head>
<title>Send specific alarm</title>
</head>
<body style="overflow:auto">
<form name="mailSuppress" method="post" action="EgMailAlertSuppressp.jsp">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" valign="middle">
<%
	if(entry.equalsIgnoreCase("admin"))
	{
%>
		<jsp:include page= "listSearch.jsp?title=Mail alerts Filtering&backButton=true&searchBox=false"/>
<%
	}
	else
	{
%>
	<tr>
		<td width="100%" id="body_headbg" style="height:23px;">
			<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" id="padding4">
				<tr>
					<td align="left" id="main_head" nowrap>&nbsp;<egui:intnl text="admin.title.MAIL ALERTS FILTERING"/></td>
					<td  nowrap  width="90%" align="right">
					<a id='mouse' onClick='javascript:history.back()'><img src='/final/admin/eg_images/back-arrow.gif' border='0'><b>&nbsp;<egui:intnl text="admin.header.Back"/>&nbsp;</b></a></td>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td height="10"><img src="/final/admin/eg_images/spacer.gif" height="10" border="0"></td>
	</tr>
<%
	}
	if(aListUserID != null && aListUserID.size() > 0)
	{
		// show filter mail alert configuration page if component(s) is/are associated
		// otherwise show the error message.
		if(types != null && types.size() > 0)
		{
%>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
			<table align="center" cellspacing="0" cellpadding="0" width="90%" border="0" class="tableborder">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="mail_bg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" class="mail_bg" width="100%" ><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="mail_bg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td align="left" class="mail_bg" nowrap colspan="3">
						<table cellspacing="0" cellpadding="0" border="0" width="100%">
							<tr>
								<td class="mail_bg" id="mail_form_border" width="25">&nbsp;</td>
								<td id="mail_form_border"><egui:intnl text="admin.user.User ID"/></td>
								<td width="10" class="mail_bg" id="mail_form_border">:</td>
<%

			String userid = "";
			if(aListUserID.size() == 1)
			{
				userid = (String)aListUserID.get(0);
%>
								<td class="mail_bg" id="mail_form_border" width="260" style="padding-bottom:6px"><input type="text" name="userID" value="<%=userid%>" readonly style='width:220px;font-weight:bold'></td>
<%
			}
			else
			{
%>
								<td class="mail_bg" id="mail_form_border" width="260">
								<select name="userID" style='width:220px;' onChange="javascript:popUserDetails()">
									<option value="-1"><egui:intnl text="admin.user.Choose a user"/></option>
<%
				for(int i=0;i<aListUserID.size();i++)
				{
					userid = (String)aListUserID.get(i);
%>
									<option value="<%=userid%>" <%=userid.equals(userID)?"selected":""%>><%=userid%></option>
<%
				}
%>
								</select></td>
<%
			}
%>
								<td class="mail_bg" id="mail_form_border" width="<%=width%>">&nbsp;</td>
								<td class="mail_bg" nowrap id="mail_form_border"><egui:intnl text="admin.filter.Filter by"/></td>
								<td class="mail_bg" id="mail_form_border" width="10">:</td>
								<td class="mail_bg" id="mail_form_border">
									<select name="filter" style='width:220px;' onChange="javascript:popFilterDetails()">
										<option value="-1"><egui:intnl text="admin.filter.Choose a filter"/></option>
										<option value="filterByCType" <%=isFilterByCType?"selected":""%>><egui:intnl text="admin.filter.Component type"/></option>
										<option value="filterByCName" <%=isFilterByCName?"selected":""%>><egui:intnl text="admin.filter.Component"/></option>
										<option value="filterByLayer" <%=isFilterByLayer?"selected":""%>><egui:intnl text="admin.filter.Layers"/></option>

										<option value="filterByTest" <%=isFilterByTest?"selected":""%>><egui:intnl text="admin.filter.Tests"/></option>

									</select>
								</td>
							</tr>
<%
			if(isFilterByCName || isFilterByLayer || isFilterByTest)
			{
%>
							<tr id="compTypeID">
								<td class="mail_bg" id="mail_form_border">&nbsp;</td>
								<td class="mail_bg" nowrap id="mail_form_border"><egui:intnl text="admin.filter.Component type"/></td>
								<td class="mail_bg" id="mail_form_border" width="10">:</td>
								<td class="mail_bg" id="mail_form_border" colspan="5">
								<select name="CompTypes" style='width:220px;' onChange="javascript:popCompTypes()">
<%
				if(aListCompTypes != null && aListCompTypes.size() > 0)
				{
					if(isFilterByLayer || isFilterByTest)
					{
%>
									<option value="filterByAll" <%=isFilterByAllLayer?"selected":""%>><egui:intnl text="admin.filter.All"/></option>
<%
					}
					else
					{
%>
									<option value="-1"><egui:intnl text="admin.filter.Choose a type"/></option>
<%
					}
					aListCompTypes = sorter.getSortedCompTypeList(aListCompTypes);
					for(int i=0;i<aListCompTypes.size();i++)
					{
						EgName nameObj = (EgName)aListCompTypes.get(i);
						String type = nameObj.getActualName();
						String disp = nameObj.getLocalName();
						if(isHostSystem!=null && isHostSystem.equalsIgnoreCase("No")||isHostSystem.equalsIgnoreCase("false"))
						{
							if(type!=null && type.equalsIgnoreCase("Host_system"))
								continue;
						}
%>
									<option value="<%=type%>" <%=type.equals(serverType)?"selected":""%>><%=disp%></option>
<%
					}
				}
				else
				{
%>
									<option value="-1"><egui:intnl text="admin.filter.Not Applicable"/></option>
<%
				}
%>
								</select>
								</td>
							</tr>
<%
			}
%>
						</table>
					</td>
				</tr>
				<tr>
					<td class="mail_bg" id="mail_form_spacing">&nbsp;</td>
						<td height="100%" width="100%" class="mail_bg" id="mail_form_spacing">
							<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
								<tr>
									<td height="100%" width="45%">
										<table align="center" cellspacing="0" cellpadding="0" border="0"  height="100%" width="90%" class="mail_border" style = "border-top:0px">
											<tr>
												<td class="mail_subhead padding4" align="center" valign='middle' style = "width:325px">
												<Strong><%=title%>&nbsp;<egui:intnl text="admin.filter.Excluded from alerts"/></Strong>
												</td>
											</tr>
											<tr>
												<td class="mail_bg"  valign="top" >
													<select name="exclude" size="14" multiple class="list" style="width:100%;border:0px">
<%
			boolean Host_systemRemovedUI=false;
			if(aListDisAssociatedValues != null && aListDisAssociatedValues.size() > 0)
			{
				if(isFilterByLayer)
				{
					aListDisAssociatedValues = sorter.getSortedLayerList(aListDisAssociatedValues);
				}
				else if(isFilterByCType)
				{
					aListDisAssociatedValues = sorter.getSortedCompTypeList(aListDisAssociatedValues);
				}
				else if (isFilterByTest)
				{
					aListDisAssociatedValues = sorter.getSortedTestList(aListDisAssociatedValues);
				}
				else
				{
					Collections.sort(aListDisAssociatedValues,String.CASE_INSENSITIVE_ORDER);
				}
				
				for(int i=0;i<aListDisAssociatedValues.size();i++)
				{
					Object obj = aListDisAssociatedValues.get(i);
					if(isFilterByCType || isFilterByLayer ||isFilterByTest )
					{
						EgName nameObj = (EgName)obj;
						String disp = nameObj.getLocalName();
						String value = nameObj.getActualName();
						if(isHostSystem!=null &&  isHostSystem.equalsIgnoreCase("No")|| isHostSystem.equalsIgnoreCase("False"))
						{
							if(value!=null && value.equalsIgnoreCase("Host_system"))
							{
								Host_systemRemovedUI=true;
								continue;
							}
						}
%>
														<option value="<%=value%>"><%=disp%></option>
<%
					}
					else
					{
						String value = (String)obj;
						String dispVal = value.substring(value.indexOf(":")+1);
						if(dispVal.indexOf(":NULL") > 0 )
						{
							dispVal=dispVal.substring(0,dispVal.indexOf(":NULL"));
						}
%>
														<option value="<%=value%>"><%=dispVal%></option>
<%
					}
				}
			}
%>
													</select>
<%
			if(Host_systemRemovedUI)
			{
%>
													<input type="hidden" name="excludedBoxHostVal" value="Host_system">
<%
			}
%>
												</td>
											</tr>
										</table>
									</td>
									<td align="center" valign="middle" width="10%">
										<input type="button" value='<egui:intnl text="admin.service.Include"/> &rsaquo;&rsaquo;' class="eg_back" onClick="javascript:addToIncluded()" style="width:100px;font-size:7.5pt"><br><br>
										<input type="button" value='&lsaquo;&lsaquo; <egui:intnl text="admin.service.Exclude"/> ' class="eg_back" onClick="javascript:addToExcluded()" style="width:100px;font-size:7.5pt">
									</td>
									<td height="100%" align="left" width="45%" >
										<table align="center" cellspacing="0" cellpadding="0" width="90%" border="0" class="mail_border" style = "border-top:0px">
											<tr>
												<td class="mail_subhead padding4"  align="center" valign='middle' style ="width:325px"> <Strong><%=title%>&nbsp;<egui:intnl text="admin.filter.Included for alerts"/></Strong>
												</td>
											</tr>
											<tr>
												<td class="mail_bg">
													<select name="include" size="14" multiple class="list" style="width:100%;border:0px">
<%
			if(aListAssociatedValues != null && aListAssociatedValues.size() > 0)
			{
				if(isFilterByLayer)
				{
					aListAssociatedValues = sorter.getSortedLayerList(aListAssociatedValues);
				}
				else if(isFilterByCType)
				{
					aListAssociatedValues = sorter.getSortedCompTypeList(aListAssociatedValues);
				}
				else if (isFilterByTest)
				{
					aListAssociatedValues = sorter.getSortedTestList(aListAssociatedValues);
				}
				else
				{
					Collections.sort(aListAssociatedValues,String.CASE_INSENSITIVE_ORDER);
				}
				for(int i=0;i<aListAssociatedValues.size();i++)
				{
					Object obj = aListAssociatedValues.get(i);
					if(isFilterByCType || isFilterByLayer || isFilterByTest)
					{
						EgName nameObj = (EgName)obj;
						String disp = nameObj.getLocalName();
						String value = nameObj.getActualName();
						if(isHostSystem!=null && (isHostSystem.equalsIgnoreCase("No")||isHostSystem.equalsIgnoreCase("false")))
						{
							if(value!=null && value.equalsIgnoreCase("Host_system"))
								continue;
						}
%>
														<option value="<%=value%>"><%=disp%></option>
<%
					}
					else
					{
						String value = (String)obj;
						String dispVal = value.substring(value.indexOf(":")+1);
						if(dispVal.indexOf(":NULL") > 0 )
						{
							dispVal=dispVal.substring(0,dispVal.indexOf(":NULL"));
						}
%>
														<option value="<%=value%>"><%=dispVal%></option>
<%
					}
				}
			}
%>
													</select>
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					<td class="mail_bg" id="mail_form_spacing">&nbsp;</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="mail_bg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td class="mail_bg"  width="100%" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="mail_bg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td id="eg_blankspace" height="10">&nbsp;</td>
	</tr>
	<tr>
		<td width="80%"  colspan="5" align="center" class="eg_whitebg">
<%
			if(reqFrom.equalsIgnoreCase("add") || reqFrom.equalsIgnoreCase("modify"))
			{
%>
				<!-- <input type="button" name="apply" value="<egui:intnl text='admin.service.Assign and Exclude More'/>" style="width: 200px;" class="eg_back" onClick="javascript:update(this)" disabled> &nbsp; -->
				<input type="button" name="apply" value="<egui:intnl text='admin.service.Assign and Exclude More'/>" style="width: 160px;font-size:7.5pt" class="eg_back" onClick="javascript:update(this)">&nbsp;
				<input type="button" name="finish" value='<egui:intnl text="admin.service.Finish"/>' style="width: 70px;font-size:7.5pt" class="eg_back" onClick="javascript:update(this)" >
<%
			}
			else
			{
%>
				<input type="button" name="updateC" value="<egui:intnl text='admin.service.Update'/>" style="width: 100px;font-size:7.5pt" class="eg_back" onClick="javascript:update(this)">
<%
			}
%>
		</td>
	</tr>
	<tr>
		<td colspan="5" id="eg_blankspace" height="10" nowrap class="eg_whitebg">&nbsp;</td>
	</tr>
<%
			if(userID.length() > 0 && (aListUserID != null && aListUserID.contains(userID)))
			{
%>
	<tr>
		<td colspan="5">
			<table align="center" cellspacing="0" cellpadding="0" width="90%" border="0">
				<tr>
					<td width="100%" colspan="2" class="tableborder_mail">
						<table cellspacing="0" cellpadding="0" border="0" width="100%">
							<tr>
								<td class="mail_head padding3" height="22"><egui:intnl text="admin.filter.EXCLUDED ELEMENTS FOR"/> : <%=userID%></td>
							</tr>
<%
				int column = 4;
				boolean nothing = true;

				if(excludedCompTypes != null && excludedCompTypes.size() > 0)
				{
					nothing = false;
					excludedCompTypes = sorter.getSortedCompTypeList(excludedCompTypes);
					boolean showCType=true;
					if(isHostSystem!=null && (isHostSystem.equalsIgnoreCase("No") || isHostSystem.equalsIgnoreCase("false")) && excludedCompTypes!=null && excludedCompTypes.size()==1)
					{
						EgName nameObj = (EgName)excludedCompTypes.get(0);
						String compTypeValue = nameObj.getActualName();
						if(compTypeValue!=null && compTypeValue.equalsIgnoreCase("Host_system"))
							showCType=false;
					}
					if(showCType)
					{
%>
							<tr>
								<td class="padding6">
									<table cellspacing="0" cellpadding="0" border="0" width="100%">
										<tr>
											<td>
												<table cellspacing="0" cellpadding="0" border="0" width="100%">
													<tr>
														<td class="mailtabbg" nowrap><egui:intnl text ="admin.service.Component types"/></td>
														<td class="mailtab" style="width:18px">&nbsp;</td>
													</tr>
												</table>
											</td>
											<td width="80%" class="eg_blankspace">&nbsp;</td>
										</tr>
										<tr>
											<td colspan="2" >
												<table cellspacing="0" cellpadding="2" border="0" width="100%" class="tableborder_mail2">
<%
					int count = column;
					int size = excludedCompTypes.size();
					for(int i=0;i<size;i++)
					{
%>
													<tr>
<%
						for(int c=0;c<count;c++)
						{
							if((c+i) < size)
							{
								EgName nameObj = (EgName)excludedCompTypes.get(c+i);
								String compType = nameObj.getLocalName();
								String compTypeValue = nameObj.getActualName();

								if(isHostSystem!=null && (isHostSystem.equalsIgnoreCase("No") || isHostSystem.equalsIgnoreCase("false")))
								{
									if(compTypeValue!=null && compTypeValue.equalsIgnoreCase("Host_system"))
										continue;
								}
%>
														<td width = "25%" class="tdborder_mail" valign="top"> <%=compType%></td>
<%
							}
							else
							{
%>
														<td width = "25%" class="tdborder_mail" valign="top">&nbsp;</td>
<%
							}
						}
%>
													</tr>
												
<%
						i = i+count-1;
					}
%>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
					}
				}

				if(excludedComponents != null && excludedComponents.size() > 0)
				{
					nothing = false;
					types = new ArrayList();
					Hashtable cnames = new Hashtable();
					for(int i=0;i<excludedComponents.size();i++)
					{
						String comp1 = (String)excludedComponents.get(i);
						String compType = comp1.substring(0,comp1.indexOf(":"));
						if(types.contains(compType))
							continue;
						comp1 = comp1.substring(comp1.indexOf(":")+1);
						for(int j =i+1;j<excludedComponents.size();j++)
						{
							String comp2 = (String)excludedComponents.get(j);
							if(!comp2.startsWith(compType+":"))
								continue;
							comp2 = comp2.substring(comp2.indexOf(":")+1);
							comp1 = comp1 +","+comp2;
						}
						if(comp1.endsWith(","))
							comp1 = comp1.substring(0,comp1.length()-1);
						types.add(compType);
						cnames.put(compType,comp1);
					}
					types = sorter.getSortedCompTypeList(types);

					boolean showCType=true;
					if(isHostSystem!=null && (isHostSystem.equalsIgnoreCase("No") || isHostSystem.equalsIgnoreCase("false")) && types!=null && types.size()==1)
					{
						EgName nameObj = (EgName)types.get(0);
						String compTypeValue = nameObj.getActualName();
						if(compTypeValue!=null && compTypeValue.equalsIgnoreCase("Host_system"))
							showCType=false;
					}

					if(showCType)
					{
%>
							<tr>
								<td class="padding6">
									<table cellspacing="0" cellpadding="0" border="0" width="100%">
										<tr>
											<td>
												<table cellspacing="0" cellpadding="0" border="0" width="100%">
													<tr>
														<td class="mailtabbg" nowrap> <egui:intnl text ="admin.filter.Components"/></td>
														<td class="mailtab" style="width:18px">&nbsp;</td>
													</tr>
												</table>
											</td>
											<td width="80%" class="eg_blankspace">&nbsp;</td>
										</tr>
										<tr>
											<td colspan="2">
												<table cellspacing="0" cellpadding="2" border="0" width="100%" class="tableborder_mail2" style="border-bottom-width:0px">
													<tr>
<%
					if(types.size() == 1)
					{
%>
														<td valign="top" width="30%" class="cell_border3" style="border-right-width:0px"><b><egui:intnl text="admin.service.Component type"/></b>&nbsp;</td>
<%
					}
					else
					{
%>
														<td valign="top" width="30%" class="cell_border3" style="border-right-width:0px"><b><egui:intnl text="admin.service.Component type"/></b>&nbsp;<img id="img0" src="/final/admin/eg_images/headarrow_down.gif" style="display:''" align="absmiddle" onclick="this.blur();return sortTable(0,0);"></td>
<%
					}
%>
														<td valign="top" width="70%" align="center" class="cell_border3" style="border-left-width:0px"><b><egui:intnl text="admin.service.Components"/></b> </td>
													</tr>
													<tr>
														<td colspan="2" style="padding:0px">
															<table cellpadding="2" cellspacing="0" border="0" width="100%" >
																<tbody id="rsTable0">
<%
					int count = column - 1;
					for(int i=0;i<types.size();i++)
					{
						EgName nameObj = (EgName)types.get(i);
						String compType1 = nameObj.getLocalName();
						String compType2 = nameObj.getActualName();
						String strComps = (String)cnames.get(compType2);
						ArrayList comps = StringUtils.myTokenizer(strComps,",");
						Collections.sort(comps,String.CASE_INSENSITIVE_ORDER);

						if(isHostSystem!=null && (isHostSystem.equalsIgnoreCase("No") || isHostSystem.equalsIgnoreCase("false")) && compType2!=null && compType2.equalsIgnoreCase("Host_system"))
							continue;
%>
																	<tr>
																		<td width="30%" class="mail_bottomright2" valign="top"><%=compType1%></td>
																		<td width="70%"  valign="top" style="padding:0px" class="mail_bottom2">
																			<table cellpadding="2" cellspacing="0" border="0" width="100%" >
<%
						int size = comps.size();
						String classV = "mail_bottomright";
						int size1 = size;
						for(int j=0;j<size;j++)
						{
							int q = size1/count;
							int r = size1%count;
							if(q == 0 || (q == 1 && r == 0))
							{
								classV = "mail_right";
							}
%>
																				<tr>
<%
							for(int c=0;c<count;c++)
							{
								if(c == count-1)
								{
									if(q == 0 || (q == 1 && r == 0))
										classV = "";
									else
										classV = "mail_bottom";
								}
								if((c+j) < size)
								{
									String disp = (String)comps.get(c+j);
									if(disp.endsWith(":NULL"))
										disp = disp.substring(0,disp.lastIndexOf(":NULL"));
%>
																					<td width = "30%" class="<%=classV%>"><%=disp%></td>
<%
								}
								else
								{
%>
																					<td width = "30%" class="<%=classV%>" >&nbsp;</td>
<%
								}
							}
							j = j+count-1;
%>
																				</tr>
<%
							size1 = size1 - count;
							classV = "mail_bottomright";
						}
%>
																			</table>
																		</td>
																	</tr>
<%
					}
%>
																</tbody> 
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
					}
				}

				if(excludedLayers != null && excludedLayers.size() > 0)
				{
					nothing = false;
					excludedLayers = sorter.getSortedLayerList(excludedLayers);
%>
							<tr>
								<td class="padding6">
									<table cellspacing="0" cellpadding="0" border="0" width="100%">
										<tr>
											<td>
												<table cellspacing="0" cellpadding="0" border="0" width="100%">
													<tr>
														<td class="mailtabbg" nowrap> <egui:intnl text ="admin.filter.Layers across component types"/></td>
														<td class="mailtab" style="width:18px">&nbsp;</td>
													</tr>
												</table>
											</td>
											<td width="70%" class="eg_blankspace">&nbsp;</td>
										</tr>
											<td colspan="2" >
												<table cellspacing="0" cellpadding="2" border="0" width="100%" class="tableborder_mail2">
<%
					int count = column;
					int size = excludedLayers.size();
					for(int i=0;i<excludedLayers.size();i++)
					{
%>
													<tr>
<%
						for(int c=0;c<count;c++)
						{
							if((c+i) < size)
							{
								EgName nameObj = (EgName)excludedLayers.get(c+i);
								String layer = nameObj.getLocalName();
%>
														<td width = "20%" class="tdborder_mail" valign="top"> <%=layer%></td>
<%
							}
							else
							{
%>
														<td width = "20%" class="tdborder_mail" valign="top">&nbsp;</td>
<%
							}
						}
%>
													</tr>
<%
						i = i+count-1;
					}
%>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
				}


				if(allExcludedLayersByType != null && allExcludedLayersByType.size() > 0)
				{
					nothing = false;
%>
							<tr>
								<td class="padding6">
									<table cellspacing="0" cellpadding="0" border="0" width="100%">
										<tr>
											<td>
												<table cellspacing="0" cellpadding="0" border="0" width="100%">
													<tr>
														<td class="mailtabbg" nowrap> <egui:intnl text ="admin.filter.Layers by component type"/> </td>
														<td class="mailtab" style="width:18px">&nbsp;</td>
													</tr>
												</table>
											</td>
											<td width="70%" class="eg_blankspace">&nbsp;</td>
										</tr>
										<tr>
											<td colspan="2">
												<table cellspacing="0" cellpadding="2" border="0" width="100%" class="tableborder_mail2" style="border-bottom-width:0px">
													<tr>
<%
					if(allExcludedLayersByType.size() == 1)
					{
%>
														<td valign="top" width="30%" class="cell_border3" style="border-right-width:0px"><b><egui:intnl text="admin.service.Component type"/></b>&nbsp;</td>

<%
					}
					else
					{
%>
														<td valign="top" width="30%" class="cell_border3" style="border-right-width:0px"><b><egui:intnl text="admin.service.Component type"/></b>&nbsp;<img id="img1" src="/final/admin/eg_images/headarrow_down.gif" style="display:''" align="absmiddle" onclick="this.blur();return sortTable(0,1);"></td>
<%
					}
%>
														<td valign="top" width="70%" align="center" class="cell_border3" style="border-left-width:0px"><b><egui:intnl text="admin.service.Layers"/></b> </td>
													</tr>
													<tr>
														<td colspan="2" style="padding:0px">
															<table cellpadding="2" cellspacing="0" border="0" width="100%" >
																<tbody id="rsTable1">
<%
					HashMap layersByType = new HashMap();
					for(int i=0;i<allExcludedLayersByType.size();i++)
					{
						String entries = (String)allExcludedLayersByType.get(i);
						String compType = entries.substring(0,entries.indexOf(":"));
						entries = entries.substring(entries.indexOf(":")+1);
						layersByType.put(compType,entries);
					}
					allExcludedLayersByType = new ArrayList(layersByType.keySet());
					allExcludedLayersByType = sorter.getSortedCompTypeList(allExcludedLayersByType);
					int count = column - 1;

					for(int i=0;i<allExcludedLayersByType.size();i++)
					{
						EgName nameObj = (EgName)allExcludedLayersByType.get(i);
						String compType = nameObj.getActualName();
						String dispVal = nameObj.getLocalName();
						String entries = (String)layersByType.get(compType);
						ArrayList layers = StringUtils.myTokenizer(entries,",");
						if(layers == null || layers.size() == 0)
							continue;
						layers = sorter.getSortedLayerList(layers);

%>
																	<tr>
																		<td width="30%" class="mail_bottomright2" valign="top"><%=dispVal%></td>
																		<td width="70%"  valign="top" style="padding:0px" class="mail_bottom2">
																			<table cellpadding="2" cellspacing="0" border="0" width="100%" >
<%
						int size = layers.size();
						String classV = "mail_bottomright";
						int size1 = size;
						for(int j=0;j<size;j++)
						{
							int q = size1/count;
							int r = size1%count;
							if(q == 0 || (q == 1 && r == 0))
								classV = "mail_right";
%>
																				<tr>
<%
							for(int c=0;c<count;c++)
							{
								if(c == count-1)
								{
									if(q == 0 || (q == 1 && r == 0))
										classV = "";
									else
										classV = "mail_bottom";
								}
								if((c+j) < size)
								{
									nameObj = (EgName)layers.get(c+j);
									String disp = nameObj.getLocalName();
%>
																					<td width = "30%" class="<%=classV%>"><%=disp%></td>
<%
								}
								else
								{
%>
																					<td width = "30%" class="<%=classV%>" >&nbsp;</td>
<%
								}
							}
							j = j+count-1;
%>
																				</tr>
<%
							size1 = size1 - count;
							classV = "mail_bottomright";
						}
%>
																			</table>
																		</td>
																	</tr>
<%
					}
%>
																</tbody>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
				}

				if(excludedTests != null && excludedTests.size() > 0)
				{
					nothing = false;
					excludedTests = sorter.getSortedTestList(excludedTests);
%>
							<tr>
								<td class="padding6">
									<table cellspacing="0" cellpadding="0" border="0" width="100%">
										<tr>
											<td>
												<table cellspacing="0" cellpadding="0" border="0" width="100%">
													<tr>
														<td class="mailtabbg" nowrap> <egui:intnl text ="admin.filter.Tests across component types"/></td>
														<td class="mailtab" style="width:18px">&nbsp;</td>
													</tr>
												</table>
											</td>
											<td width="70%" class="eg_blankspace">&nbsp;</td>
										</tr>
											<td colspan="2" >
												<table cellspacing="0" cellpadding="2" border="0" width="100%" class="tableborder_mail2">
<%
					int count = column;
					int size = excludedTests.size();
					for(int i=0;i<excludedTests.size();i++)
					{
%>
													<tr>
<%
						for(int c=0;c<count;c++)
						{
							if((c+i) < size)
							{
								EgName nameObj = (EgName)excludedTests.get(c+i);
								String test = nameObj.getLocalName();
%>
														<td width = "20%" class="tdborder_mail" valign="top"> <%=test%></td>
<%
							}
							else
							{
%>
														<td width = "20%" class="tdborder_mail" valign="top">&nbsp;</td>
<%
							}
						}
%>
													</tr>
<%
						i = i+count-1;
					}
%>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
				}

				if(exculdedTestsForAllTypes != null && exculdedTestsForAllTypes.size() > 0)
				{
					nothing = false;
%>
							<tr>
								<td class="padding6">
									<table cellspacing="0" cellpadding="0" border="0" width="100%">
										<tr>
											<td>
												<table cellspacing="0" cellpadding="0" border="0" width="100%">
													<tr>
														<td class="mailtabbg" nowrap> <egui:intnl text ="admin.filter.Tests by component type"/> </td>
														<td class="mailtab" style="width:18px">&nbsp;</td>
													</tr>
												</table>
											</td>
											<td width="70%" class="eg_blankspace">&nbsp;</td>
										</tr>
										<tr>
											<td colspan="2">
												<table cellspacing="0" cellpadding="2" border="0" width="100%" class="tableborder_mail2" style="border-bottom-width:0px">
													<tr>
<%
					if(exculdedTestsForAllTypes.size() == 1)
					{
%>
														<td valign="top" width="30%" class="cell_border3" style="border-right-width:0px"><b><egui:intnl text="admin.service.Component type"/></b>&nbsp;</td>

<%
					}
					else
					{
%>
														<td valign="top" width="30%" class="cell_border3" style="border-right-width:0px"><b><egui:intnl text="admin.service.Component type"/></b>&nbsp;<img id="img1" src="/final/admin/eg_images/headarrow_down.gif" style="display:''" align="absmiddle" onclick="this.blur();return sortTable(0,1);"></td>
<%
					}
%>
														<td valign="top" width="70%" align="center" class="cell_border3" style="border-left-width:0px"><b><egui:intnl text="admin.service.Tests"/></b> </td>
													</tr>
													<tr>
														<td colspan="2" style="padding:0px">
															<table cellpadding="2" cellspacing="0" border="0" width="100%" >
																<tbody id="rsTable1">
<%
					HashMap testsByType = new HashMap();
					for(int i=0;i<exculdedTestsForAllTypes.size();i++)
					{
						String entries = (String)exculdedTestsForAllTypes.get(i);
						String compType = entries.substring(0,entries.indexOf(":"));
						entries = entries.substring(entries.indexOf(":")+1);
						testsByType.put(compType,entries);
					}
					exculdedTestsForAllTypes = new ArrayList(testsByType.keySet());
					exculdedTestsForAllTypes = sorter.getSortedCompTypeList(exculdedTestsForAllTypes);
					int count = column - 1;

					for(int i=0;i<exculdedTestsForAllTypes.size();i++)
					{
						EgName nameObj = (EgName)exculdedTestsForAllTypes.get(i);
						String compType = nameObj.getActualName();
						String dispVal = nameObj.getLocalName();
						String entries = (String)testsByType.get(compType);
						ArrayList tests = StringUtils.myTokenizer(entries,",");
						if(tests == null || tests.size() == 0)
							continue;
						tests = sorter.getSortedTestList(tests);

%>
																	<tr>
																		<td width="30%" class="mail_bottomright2" valign="top"><%=dispVal%></td>
																		<td width="70%"  valign="top" style="padding:0px" class="mail_bottom2">
																			<table cellpadding="2" cellspacing="0" border="0" width="100%" >
<%
						int size = tests.size();
						String classV = "mail_bottomright";
						int size1 = size;
						for(int j=0;j<size;j++)
						{
							int q = size1/count;
							int r = size1%count;
							if(q == 0 || (q == 1 && r == 0))
								classV = "mail_right";
%>
																				<tr>
<%
							for(int c=0;c<count;c++)
							{
								if(c == count-1)
								{
									if(q == 0 || (q == 1 && r == 0))
										classV = "";
									else
										classV = "mail_bottom";
								}
								if((c+j) < size)
								{
									nameObj = (EgName)tests.get(c+j);
									String disp = nameObj.getLocalName();
%>
																					<td width = "30%" class="<%=classV%>"><%=disp%></td>
<%
								}
								else
								{
%>
																					<td width = "30%" class="<%=classV%>" >&nbsp;</td>
<%
								}
							}
							j = j+count-1;
%>
																				</tr>
<%
							size1 = size1 - count;
							classV = "mail_bottomright";
						}
%>
																			</table>
																		</td>
																	</tr>
<%
					}
%>
																</tbody>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
				}

				if(nothing)
				{
%>
							<tr>
								<td class="padding6">
									<table cellspacing="0" cellpadding="0" border="0" width="100%">
										<tr>
											<td width="100%" height="75" align="center" >
											<img src="/final/admin/eg_images/exclamation-icon.gif"><br><br><egui:intnl text="admin.filter.No elements are excluded for this user"/>.</td>
										</tr>
									</table>
								</td>
							</tr>
<%
				}
%>
						</table>
					</td>
				</tr>
				<tr>
					<td id="eg_blankspace" height="20" nowrap class="eg_whitebg">&nbsp;</td>
				</tr>
			</table>
		</td>
	</tr>
<%
			}
		}
		else
		{
%>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="middle"><br><br><br><br><br><br><br>
			<table align="center" cellspacing="0" cellpadding="0" width="80%" border="0" class="tableborder" height="220">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="mail_bg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" class="mail_bg" width="100%" ><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="mail_bg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr> 
				<tr>
					<td align="center" colspan="3" class="mail_bg">
						<table border="0" align="center" width="100%"  height="100%">
							<tr>
								<td align="center">
									<table border="0" align="center" width="52%" class="body_text">
										<tr>
											<td align="center" valign="bottom">
												<img src="/final/admin/eg_images/exclamation-icon.gif">
											</td>
										</tr>
										<tr>
											<td align="center"><b><egui:intnl text="admin.filter.No components have been associated for"/> '<%=userID%>'</b></td>
										</tr>
<%
			if(entry.equalsIgnoreCase("admin")&&(reqFrom.equals("add") || reqFrom.equals("modify")))
			{
%>
										<tr>
											<td align="center">&nbsp;</td>
										</tr>
										<tr>
											<td align="center">
											<a class="body_link" href="javascript:goToBack()" class="artext" style="padding-left:15px"><egui:intnl text="admin.filter.Click here"/>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a>
											<egui:intnl text="admin.filter.to associate the components for this user"/>.</td>
										</tr>
<%
			}
%>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="mail_bg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td class="mail_bg"  width="100%" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="mail_bg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
		</td>
	</tr>
<%
		}
	}
	else
	{
%>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="middle"><br><br><br><br><br><br><br>
			<table align="center" cellspacing="0" cellpadding="0" width="80%" border="0" class="tableborder" height="220">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="mail_bg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" class="mail_bg" width="100%" ><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="mail_bg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td align="center" colspan="3" class="mail_bg">
						<table border="0" align="center" width="100%"  height="100%">
							<tr>
								<td align="center">
									<table border="0" align="center" width="60%" class="body_text">
										<tr>
											<td align="center" valign="bottom">
												<img src="/final/admin/eg_images/exclamation-icon.gif">
											</td>
										</tr>
										<tr>
											<td align="left"><b><egui:intnl text="admin.filter.This feature is currently unavailable"/>. <egui:intnl text="admin.filter.Possible reasons could be"/> :</b></td>
										</tr>
										<tr>
											<td align="left">&nbsp;</td>
										</tr>
										<tr>
											<td align="left">&#149;&nbsp;<egui:intnl text="admin.filter.User(s) may not have been configured in the eG system"/>.</td>
										</tr>
										<tr>
											<td align="left">&#149;&nbsp;<egui:intnl text="admin.filter.Component(s) may not have been associated with user(s)"/>.</td>
										</tr>
										<tr>
											<td align="left">&#149;&nbsp;<egui:intnl text="admin.filter.Mail ID or Command may not have been configured for user(s)"/>.</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="mail_bg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td class="mail_bg"  width="100%" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="mail_bg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
		</td>
	</tr>
<%
	}
%>
	<input type="hidden" name="previousExcVal" value="<%=previousExcVal%>">
	<input type="hidden" name="excludedBoxVal" value="">
	<input type="hidden" name="includedBoxVal" value="">
	<input type="hidden" name="control" value="">
	<input type="hidden" name="reqfrom" value="<%=reqFrom%>">
	<input type="hidden" name="entry" value="<%=entry%>">

</table>
</form>
</body>
<%
	if (aListUserID != null && aListUserID.size() > 0)
	{
		if (entry != null && entry.equalsIgnoreCase("admin"))
		{
			if (request.getQueryString() != null)
			{
				session.setAttribute("adminLastAccessedURL","/final/admin/EgMailAlertSuppress.jsp?userID="+EgURLEncoder.encode(userID,"UTF-8"));
			}
			else
			{
				session.setAttribute("adminLastAccessedURL","/final/admin/EgMailAlertSuppress.jsp");
			}
		}
	}
%>



