<%
/*************************************************************************************************************
 *      File name               :       EgLogin.jsp
 *      Purpose                 :       This page uses LoginBean to check the login info provided by the user 
					and sends the user to Admin Home or Monitor Home according to the
					profile.  A bad login will causer EgError.jsp to be displayed.
 *      Version                 :       AspLite 0.0
 *      Creation Date           :       21-05-2001
 *      Last Date               :      	12/02/2002 // kk to change user_id to
					lower case and add it in the session.
					24/10/2001 //sandhya - 'monitor' users are not allowed into monitor module if sid is not configured(Check for the comment New code in this page).
					06-09-2000
 *      Author                  :       BalaMurugan. V
 ************************************************************************************************************/
%>
<%@ page import = "com.eg.EgDateInfo" %>
<%@ page import = "com.eg.EgMemCheck" %>
<%@ page import = "com.eg.EgMemInfo" %>
<%@ page import="com.eg.SidCheck" %>
<%@ page import="java.util.*" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%! 
	String syncString = "me";
%>
<%
	String s_loginstatus = "";
%>

<jsp:useBean id="login" scope ="page" class ="egurkha.LoginBean"/>
<jsp:useBean id="egasp" scope="page" class="egurkha.EgAspLite" />

<%
	SidCheck check = new SidCheck();
	String str = "";
	Vector sess_vec = new Vector();
	String str_uname = request.getParameter("uname");
	str_uname = str_uname.toLowerCase();

	try
	{
		str = login.setConnection();
		if(str.equals("CONNECTED"))
		{
			s_loginstatus = login.validate(str_uname, request.getParameter("upass"));
			s_loginstatus = s_loginstatus.toUpperCase();
			login.releaseConnection(false);
		}
		else
		{
			out.println("Connection with the database could not be established!");
		}

		//New code
		synchronized (syncString)
		{
			EgMemCheck info = new EgMemCheck();
			synchronized(EgMemInfo.setInfo(info))
			{
				//System.out.println("Variables Initialised");
			}
		}
		//End of New Code

		if(s_loginstatus.equals("ADMIN"))
		{
			session.putValue("sess_auserid",str_uname);
		//	response.sendRedirect("EgLoginTrackerA.jsp?l_mode=login");
			%>
			<jsp:forward page="EgLoginTrackerA.jsp?l_mode=login" />
			<%
		}
		else if(s_loginstatus.equals("MONITOR"))
		{
			long l_validdays = 1000;
			EgDateInfo egdt = new EgDateInfo();
			long l_currdt = egdt.egetUTCDate();
			long l_usrdt = 0;

			if(!str_uname.equals("supermonitor"))
			{
				String s_date = login.getValidDate();
				l_usrdt = egdt.egetUTCDate(s_date);
				long l_diff = l_usrdt - l_currdt;
				boolean b_v = false;
				if(l_diff > 0)
				{
					l_validdays = l_diff/(1000*60*60*24);
				}
				else
				{
					l_validdays = -1;
				}
			}	  	
		
			//New code
                	if(check.sidNotConfigured)
                	{
						sess_vec.addElement("Login");
						sess_vec.addElement("EgHome.jsp");
						sess_vec.addElement("Misconfiguration!");
						sess_vec.addElement("The administrator has not configured the eG system properly.");
						sess_vec.addElement("Please contact your eG administrator for details.");
						session.putValue("vec_Errors",sess_vec);
						egasp.releaseConnection(false);
						//response.sendRedirect("EgErrors.jsp");
						%>
						<jsp:forward page="EgErrors.jsp" />
						<%
                	}//end of New code
			else
			{
				session.putValue("sess_userid",str_uname);	
				session.putValue("sess_usersite",egasp.userSiteInfo(str_uname));
				session.putValue("sess_usertime",new Long(l_currdt));
				session.putValue("sess_uservalidtill",new Long(l_validdays));
				session.putValue("sess_l_usrdt",new Long(l_usrdt));
				egasp.releaseConnection(false);
		//		response.sendRedirect("../monitor/EgMonitorHome.jsp");
				%>
				<jsp:forward page="../monitor/EgMonitorHome.jsp" />
				<%
			}
		}
		else if(s_loginstatus.equals("INVALID"))
		{
			sess_vec.addElement("Login");
                	sess_vec.addElement("EgHome.jsp");
                	sess_vec.addElement("Invalid User!");
                	sess_vec.addElement("You have either typed the incorrect user id or ");
                	sess_vec.addElement("incorrect password.");
                	sess_vec.addElement("So please try again.");
                	session.putValue("vec_Errors",sess_vec);
		//	response.sendRedirect("EgErrors.jsp");
			%>
			<jsp:forward page="EgErrors.jsp" />
			<%
		}
		login.releaseConnection(false);	
	}// End Of Try block
	catch(Exception e)
 	{
 		if(!(str.equals("CONNECTED")))
 		{
 			out.println("Connection could not established");
        	}
        	else
        	{
			out.println(e.toString());
        	}

		try
		{
			login.releaseConnection(true);
			egasp.releaseConnection(true);
		}
		catch(Exception e1)
		{}
	}
%>