<%
/*
 *   File		:	EgEnableAndDisableDDp.jsp
 *   Purpose	:	Processing page
 *   Author		:	Vaathsalya (2008)
*/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.egurkha.admin.AuditLogThread" %>
<%@ page import="com.eg.EgServicesInfo"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<jsp:useBean id="prgBean" class="egurkha.EgTestParamBean" scope="page" />

<%
	//prgBean.createFile("eg_testinfo.ini","save");

	String componentType = request.getParameter("componentType");
	String DDenabledTestList = request.getParameter("DDenabledTestList");
	String DDdisabledTestList = request.getParameter("DDdisabledTestList");

	DDenabledTestList = (DDenabledTestList != null)?DDenabledTestList:"";
	DDdisabledTestList = (DDdisabledTestList != null)?DDdisabledTestList:"";
	
	ArrayList aListDDenabledTest = new ArrayList();
	StringTokenizer stoken = new StringTokenizer(DDenabledTestList,",");
	while (stoken.hasMoreTokens())
	{
		String strEnabledTest = stoken.nextToken();
		aListDDenabledTest.add(strEnabledTest);
	}
	
	ArrayList aListDDdisabledTest = new ArrayList();
	StringTokenizer token = new StringTokenizer(DDdisabledTestList,",");
	while (token.hasMoreTokens())
	{
		String strDisabledTest = token.nextToken();
		aListDDdisabledTest.add(strDisabledTest);
	}

	prgBean.createSyncFile("eg_testinfo.ini","save");
	for (int i=0;i<aListDDenabledTest.size();i++)
	{
		prgBean.deleteValues("Disable_DD",(String)aListDDenabledTest.get(i));
	}

	String[] disabledTests = prgBean.getVariables("Disable_DD");
	ArrayList aListDisabledTests = new ArrayList(Arrays.asList(disabledTests));

	for (int i=0;i<aListDDdisabledTest.size();i++)
	{
		String strTest = (String)aListDDdisabledTest.get(i);
		if (aListDisabledTests.contains(strTest)) continue;
		prgBean.setValues("Disable_DD",strTest,"true");
	}

	prgBean.saveFile();
	prgBean.releaseInstance();

	//for auditlog - starts
	EgServicesInfo egserInfo = new EgServicesInfo("manager");
	boolean isAuditLogEnabled = egserInfo.isAuditlogEnabled();

	if (isAuditLogEnabled)
	{
		String strPreviouslyDisabled = request.getParameter("prevDisabledDDTests");
		String strPreviouslyEnabled = request.getParameter("prevEnabledDDTests");

		strPreviouslyDisabled = (strPreviouslyDisabled != null)?strPreviouslyDisabled:"";
		strPreviouslyEnabled = (strPreviouslyEnabled != null)?strPreviouslyEnabled:"";

		strPreviouslyEnabled = strPreviouslyEnabled.substring(1,strPreviouslyEnabled.length()-1);
		strPreviouslyDisabled = strPreviouslyDisabled.substring(1,strPreviouslyDisabled.length()-1);

		ArrayList aListPreviouslyEnabled = new ArrayList();
		ArrayList aListPreviouslyDisabled = new ArrayList(); 
		
		StringTokenizer iTok = new StringTokenizer(strPreviouslyEnabled,",");
		while (iTok.hasMoreTokens())
		{
			String prevEnabled = iTok.nextToken().trim();
			aListPreviouslyEnabled.add(prevEnabled);
		}

		StringTokenizer eTok = new StringTokenizer(strPreviouslyDisabled,",");
		while (eTok.hasMoreTokens())
		{
			String prevDisabled = eTok.nextToken().trim();
			aListPreviouslyDisabled.add(prevDisabled);
		}

		ArrayList newlyEnabledDDTests = (ArrayList)aListPreviouslyDisabled.clone();
		newlyEnabledDDTests.removeAll(aListDDdisabledTest);
		ArrayList newlyDisabledDDTests = (ArrayList)aListPreviouslyEnabled.clone();
		newlyDisabledDDTests.removeAll(aListDDenabledTest);

		boolean allowAuditLogOperation = true;

		if (newlyEnabledDDTests.isEmpty() && newlyDisabledDDTests.isEmpty())
		{
			allowAuditLogOperation = false;
		}

		if (allowAuditLogOperation)
		{
			AuditLogThread auditLogThread = new AuditLogThread();
			auditLogThread.setValue("Category","Admin");
			auditLogThread.setValue("User_id",_user.getLoginID());
			auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Module","Detailed Diagnosis");
			auditLogThread.setValue("Description","DD configuration has been modified successfully");

			if (!newlyEnabledDDTests.isEmpty() && !newlyDisabledDDTests.isEmpty())
			{
				auditLogThread.setValue("Activity","Enable/Disable DD");
			}
			else if (!newlyEnabledDDTests.isEmpty() && newlyDisabledDDTests.isEmpty())
			{
				auditLogThread.setValue("Activity","Enable DD");
			}
			else if (newlyEnabledDDTests.isEmpty() && !newlyDisabledDDTests.isEmpty())
			{
				auditLogThread.setValue("Activity","Disable DD");
			}

			for(int i=0; i<newlyEnabledDDTests.size(); i++)
			{
				String testTmp = (String)newlyEnabledDDTests.get(i);
				if(testTmp != null && !testTmp.equalsIgnoreCase("null") && testTmp.trim().length()>0)
				{
					auditLogThread.setCurrentValue("DD ENABLED TEST(S)",_mapping.getTestDescription(testTmp));
				}
			}

			for(int i=0; i<newlyDisabledDDTests.size(); i++)
			{
				String testTmp = (String)newlyDisabledDDTests.get(i);
				if(testTmp != null && !testTmp.equalsIgnoreCase("null") && testTmp.trim().length()>0)
				{
					auditLogThread.setCurrentValue("DD DISABLED TEST(S)",_mapping.getTestDescription(testTmp));
				}
			}

			auditLogThread.sendItToDB();
		}
	}
	//for auditlog - ends
	

	Vector sess_vec = new Vector();
	sess_vec.addElement(_mapping.getTextDescription("admin.test.ENABLE / DISABLE DETAILED DIAGNOSIS (DD)"));
	sess_vec.addElement("EgEnableAndDisableDD.jsp?componentType="+componentType);
	sess_vec.addElement(_mapping.getTextDescription("admin.test.ENABLE / DISABLE DETAILED DIAGNOSIS (DD)"));
	sess_vec.addElement(_mapping.getTextDescription("admin.test.Detailed Diagnosis feature for choosen test(s) has been configured successfully across component types")+"...");
	session.setAttribute("vec_Results",sess_vec);
%>

<jsp:forward page="EgResults.jsp" />



