<%
/*******************************************************************************
 *	File name       :	EgDispExtAgents.jsp
 *  Purpose			:	To display the list of external agents in the system.
 *  Version         :   1.0
 *  Creation Date   :   29-06-2001
 *  Last Date       :	10/07/2001 //sandhya - To display message "No external agents..." 
 *  Author          :	Krishna Kumar. C
 *	Design Changes	:	Jaiwin
 ******************************************************************************/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "com.eg.EgExternalInfo" %>
<%@ taglib prefix = "egui" uri= "../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	EgExternalInfo extInfo = new EgExternalInfo("manager");
	String egTitleSearchStr = request.getParameter("egTitleSearchStr");
	boolean isSearchResult =egTitleSearchStr!=null;
	ArrayList searchList = new ArrayList();
	if (isSearchResult)
	{
		StringTokenizer st = new StringTokenizer(egTitleSearchStr);
		while (st.hasMoreTokens())
		{
			String thisToken = st.nextToken().trim();
			if (thisToken.equals(""))
				continue;
			searchList.add(thisToken);
		}
	}
%>

<html>
<head>
<title>External Agents</title>
<!-- <link rel="stylesheet" href="eg_styles/eg_adminstyle.css">  -->
<egui:skin ui="admin"/>
<script language="JavaScript">

function populate()
{
	//action="Egnewextagentsp.jsp"
	document.list.submit();
}

function egTitleSearch()
{
	var thisForm=document.ExternalAgents;
	var searchSt=thisForm.egTitleSearchStr.value;
	if (searchSt==null || searchSt=="")
	{
		window.location.href = "EgDispExtAgents.jsp";
	}
	else if(searchSt!=null)
	{
		window.location.href = "EgDispExtAgents.jsp?egTitleSearchStr="+encodeURI(searchSt);
	}
}
function deleteExtAgent(agent)
{
	if(confirm("<egui:intnl text='admin.external.Are you sure you want to delete the External agent'/>, '"+agent+"'?"))
	window.location.href='Egnewextagentsp.jsp?mode=del&eagent='+encodeURI(agent);
}
</script>
</head>

<jsp:useBean id="trans" scope="page" class="egurkha.TransactionBean"/>

<%
	trans.createFile("eg_external.ini");
	String[] s_eagents = trans.getVariables("Eg_External_Agents");
%>

<!-- <body bgcolor="#FFFFFF"leftmargin="0" topmargin="20" marginwidth="0" marginheight="20"> -->

<body style="overflow:auto" id="space6" >
<form name="ExternalAgents" method="post"  style="margin:0px" action="javascript:egTitleSearch();">
<table border="0" align="center" cellspacing="0" cellpadding="0" width="100%" >
<%
	session.setAttribute("egPageDesc","EgDispExtAgents.jsp");
	session.setAttribute("egBackComplete","/final/admin/EgDispExtAgents.jsp");
	session.setAttribute("egTitlehref", "/final/admin/EgNewExtAgents.jsp?Btype=NewAgnt&action=add");
%>
	<jsp:include page="listSearch.jsp?title=EXTERNAL AGENT CONFIGURATION&leftString=Add New Agent&backButton=false&subtitle=true&searchBox=true"/>

	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%"><br>
			<table align="center" width="85%" cellspacing="0" cellpadding="0" border="0" >
			<!---
			Row to be repeated starts here
			-->
<%
	if(s_eagents.length > 0)
	{
		EgSpecsInfo specs = new EgSpecsInfo("manager");
		Arrays.sort(s_eagents,String.CASE_INSENSITIVE_ORDER);
		List tmpList = new ArrayList();
		String defaultExtAgent = "";
		for (int j=0; j <s_eagents.length;j++)
		{
			String tmpExtagent = s_eagents[j];
			if (specs.getEGServer().equals(tmpExtagent))
			{
				defaultExtAgent = tmpExtagent;
			}
			else
			{
				tmpList.add(tmpExtagent);
			}
		}
		if(!defaultExtAgent.equals(""))
		{
			tmpList.add(0,defaultExtAgent);
		}
		s_eagents = (String[])tmpList.toArray(new String[0]);
		boolean searchItemFound = false;
		for(int i=0;i < s_eagents.length;i++)
		{
			if (isSearchResult && !doesExist(searchList, s_eagents[i]))
				continue;
			searchItemFound=true;
%>
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>

				
				<tr>
					<th class="form_spacing" id="eg_subcontentbg">&nbsp;</th>
					<td width="74%" class="form_spacing" id="eg_subcontentbg" height="35"><strong><%=s_eagents[i]%></strong></td>
<%
			String hostIp = extInfo.getIpForAgent(s_eagents[i]);
		    if (EgInstallInfo.isClientEmulationEnabled ||  !hostIp.equals(s_eagents[i]))
			{
%>
					<td width="13%" class="form_spacing"  align="center" id="eg_subcontentbg"> <input type="button" value='<egui:intnl text="admin.common.Modify"/>' style="width:80px;height: 20px;" class="eg_lightbutton" onClick="javascript:window.location.href='EgNewExtAgents.jsp?Btype=bmod&modify=true&eagent=<%=EgURLEncoder.encode(s_eagents[i],"UTF-8")%>'"> </td>
<%
			}
			else
			{
%>
					 <td width="13%" class="form_spacing" align="center" id="eg_subcontentbg">&nbsp;</td>  
<%
			}
			if(!specs.getEGServer().equals(s_eagents[i]))
			{
%>
					<td width="13%" class="form_spacing"  align="center" id="eg_subcontentbg"> <input type="button" value='<egui:intnl text="admin.common.Delete"/>' style="width: 80px;height: 20px;" class="eg_lightbutton" onClick="javascript:deleteExtAgent('<%=s_eagents[i]%>')"> </td>
<%
			}
			else
			{
%>
					<td width="13%" class="form_spacing" align="center" id="eg_subcontentbg">&nbsp;</td>
<%
			}
%>
					<td class="form_spacing" id="eg_subcontentbg">&nbsp;</td>
				</tr>
				<!---  Row to be repeated ends here  -->
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
				<tr>
					<td colspan="5" id="eg_blankspace" class="eg_whitebg" height="10" nowrap>&nbsp;</td> 
				</tr>
<%
		}
		if (!searchItemFound&&egTitleSearchStr!=null&&!egTitleSearchStr.equals(""))
		{
%>
				<tr>
					<td colspan="5" height="300">
						<table border="0" cellspacing="0" cellpadding="4" width="100%" >
							<tr> 
								<td width="100%" align="center">
								<img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif">
								</td>
							</tr>
							<tr>
								<td width="100%" align="center" id="eg_errorsmall">
								<egui:intnl text="admin.external.No external agent(s) found for your current search"/>,&nbsp;"<%=egTitleSearchStr%>"
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
		}
	}
	else
	{
%>
				<tr>
					<td colspan="5" id="eg_blankspace" height="10" nowrap>&nbsp;</td> 
				</tr>
				<tr>
					<td class="form_border">&nbsp;</td>
					<td width="70%" class="form_border" colspan="2"><egui:intnl text="admin.external.No external agents present in the system"/></td>
					<td width="30%" class="form_border">&nbsp;</td>
					<td class="form_border">&nbsp;</td>
				</tr>
<%
	}
%>
			</table>
			<br>
		</td>
	</tr>
</table>
</form>
</html>



<%!
	private boolean doesExist(List searchList, String thisGroup)
	{
		Iterator i = searchList.iterator();
		while(i.hasNext())
		{
			String nextStr = (String) i.next();
			if (thisGroup.indexOf(nextStr)!=-1||(thisGroup.toUpperCase().indexOf(nextStr.toUpperCase()))!=-1)
				return true;
		}
		return false;
	}
%>
<%
	if(request.getQueryString()!=null)
	session.setAttribute("adminLastAccessedURL","/final/admin/EgDispExtAgents.jsp?"+request.getQueryString());
	else session.setAttribute("adminLastAccessedURL","/final/admin/EgDispExtAgents.jsp");
%>


