<%@ include file="../../EgTrackerAJSON.jsp"%>

<%@ page import = "java.net.InetAddress"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "net.sf.json.*"%>

<%!
	public ArrayList getIPAddressesByDomainName(String domainName)
	{
		ArrayList ipAddresses = new ArrayList();
		try
		{
			InetAddress ina[] = InetAddress.getAllByName(domainName);
			for (int i=0;i<ina.length;i++)
			{
				String strIP = ina[i].getHostAddress();
				ipAddresses.add(strIP);
			}
		}
		catch(Exception e)
		{
			System.out.println("Error: "+ e.getMessage());
		}
		return ipAddresses;
	}
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
	
	JSONObject rootObj = new JSONObject();
	JSONArray actArray = new JSONArray();
	JSONArray ipAddrsArray = new JSONArray();
	
	String domName = request.getParameter("domName");
	String domAliasName = request.getParameter("domAliasName");
	
	if (!StringUtils.isNull(domName))
	{
		domName = egurkha.EgUIUtils.decodeSecurityChar(domName);
		HashSet ipAddresses = new HashSet();
		ArrayList domIPAddresses = new ArrayList();

		domIPAddresses = getIPAddressesByDomainName(domName);
		if (domIPAddresses !=  null && !domIPAddresses.isEmpty())
		{
			ipAddresses.addAll(domIPAddresses);
		}
		
		if (!StringUtils.isNull(domAliasName))
		{
			domAliasName = egurkha.EgUIUtils.decodeSecurityChar(domAliasName);
			ArrayList domAliasIPAddresses = new ArrayList();

			domAliasIPAddresses = getIPAddressesByDomainName(domAliasName);
			if (domAliasIPAddresses !=  null && !domAliasIPAddresses.isEmpty())
			{
				ipAddresses.addAll(domAliasIPAddresses);
			}
		}
		
		if (ipAddresses !=  null && ipAddresses.size() > 0)
		{
			ArrayList ipAddrList = new ArrayList(ipAddresses);
			String ipAddrsString = StringUtils.getString(ipAddrList);
			for (int i=0;i<ipAddrList.size();i++)
			{
				String ip = (String)ipAddrList.get(i);
				JSONObject ipAddrsObj = new JSONObject();
				ipAddrsObj.put("displayField",ip);
				ipAddrsObj.put("valueField",ip);
				ipAddrsArray.add(ipAddrsObj);
			}
			rootObj.put("success","true");
			rootObj.put("ipAddrsArray",ipAddrsArray);
			rootObj.put("selectedIPAddrs",ipAddrsString);			
		}
		else
		{
			rootObj.put("success","false");
			rootObj.put("resultMsg","Unable to fetch the domain controllers IPs");
		}

	}
	else
	{
		JSONObject tmpObj = new JSONObject();
		tmpObj.put("displayField",_mapping.getTextDescription("admin.user.Is this domain reachable?"));
		tmpObj.put("valueField","1");
		actArray.add(tmpObj);

		tmpObj = new JSONObject();
		tmpObj.put("displayField",_mapping.getTextDescription("admin.user.Is this domain connection credential valid?"));
		tmpObj.put("valueField","2");
		actArray.add(tmpObj);

		tmpObj = new JSONObject();
		tmpObj.put("displayField",_mapping.getTextDescription("admin.user.Does the user exist in this domain?"));
		tmpObj.put("valueField","3");
		actArray.add(tmpObj);

		tmpObj = new JSONObject();
		tmpObj.put("displayField",_mapping.getTextDescription("admin.user.Is the user able to login to domain?"));
		tmpObj.put("valueField","4");
		actArray.add(tmpObj);

		tmpObj = new JSONObject();
		tmpObj.put("displayField",_mapping.getTextDescription("admin.user.Enumerate domain user groups"));
		tmpObj.put("valueField","5");
		actArray.add(tmpObj);

		tmpObj = new JSONObject();
		tmpObj.put("displayField",_mapping.getTextDescription("admin.user.Troubleshoot communication with domain controller"));
		tmpObj.put("valueField","6");
		actArray.add(tmpObj);
	}

	rootObj.put("validationActions",actArray);
	
	
	
	
	
	
	
	out.println(rootObj.toString());
%>



