<%
/**********************************************************************************
*	Name			:	EgConfigZone.jsp
*	Purpose			:	Modifying zones
*	design Changes	:	Jaiwin
*	Last Modified	:	July-23-2007		N.Gokulanand	For zone map changes.
***********************************************************************************/
%>
<%@ taglib prefix = "egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="java.util.StringTokenizer"%>
<%@ page import="java.util.ArrayList"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgTopoInfo" %>
<%@ page import = "com.eg.EgGroupInfo" %>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgViewInfo" %>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	EgViewInfo egviewinfo = new EgViewInfo("manager");
	String zoneName = request.getParameter("zone");
	String latitude = "null";
	String longitude = "null";
	boolean mapEnabled = false;
	IniFile uiIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String mapLicense = uiIni.getValue("ZONE_MAP","mapEnabled");
	mapEnabled = (mapLicense != null && mapLicense.equalsIgnoreCase("yes"));
	IniFile topoIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
	String coordinate = topoIni.getValue("ZONE_LOCATION",zoneName);
	StringTokenizer st = new StringTokenizer(coordinate, "|");
	int tokenCount = 0;
	while(st.hasMoreTokens())
	{
		String thisToken = st.nextToken();
		switch(tokenCount)
		{
			case 0:
				latitude = thisToken;
			break;
			case 1:
				longitude = thisToken;
			break;
		}
		tokenCount++;
	}
	if(request.getParameter("latitude") != null && request.getParameter("longitude") != null)
	{
		latitude = request.getParameter("latitude");
		longitude = request.getParameter("longitude");
	}
%>
<jsp:useBean id="zoneinfo" scope="page" class="egurkha.ZoneInfoBean"/>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<META HTTP-EQUIV="expires" CONTENT="0">
<egui:skin ui="admin"/>
<script language="JavaScript1.2" src="eg_scripts/eg_map.js"></script>
<script language="JavaScript">
var ev='';

function popupmap(event)
{
	var thisForm = document.configureZone;
	var j = thisForm.managedHosts.options.length;
	if(j > 0)
	{
		event=event?event:window.event;
		ev=event;
		setTimeout("openMapWindow('EgMap', ev)",1);
	}
	else
	{
		alert('<egui:intnl text="admin.zone.Please associate an element and try again"/>');
	}
}

function isNetscape() 
{
	// get browser info. 
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1); 

	// check for Navigator ver 4+. 
	if ((appName == "Netscape") && (appVer >= 4)) return true;
	return false;
}

function isIE() 
{
	// get browser info. 
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1); 

	// check for IE ver 4+. 
	if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
	return false;
}

function goHome() 
{
	window.location.href = "EgDispZones.jsp";
}

function associate()
{
	var thisForm = document.configureZone;
	var serverselected = "false";
	manunmanage = true;

	//getting list size
	var j = thisForm.managedHosts.options.length;

	//gettin list vars
	var list = thisForm.otherHosts;
	var mlist = thisForm.managedHosts;
	for(var i = 0 ; i < list.options.length ; i++)
	{
		//browsing through to find selected items
		if(list.options[i].selected == true)
		{
			serverselected = "true";
			var txt=list.options[i].text;
			var val=list.options[i].value;
			var flag = 0;
			//to check if it already exists
			for(k = 0; k < mlist.options.length; k++)
			{
				if(val == mlist.options[k].value)
				{
					flag = 1;
				}
			}
			//addin the new name
			if(flag == 0)
			{
				mlist.options[j++] = new Option (txt,val) ;
			}
		}
	}
	for(var x = list.options.length; x > 0 ; x--)
	{
		if(list.options[x-1].selected == true )
			list.options[x-1] = null;
	}
	
	if(serverselected == "false")
	{
		alert('<egui:intnl text="admin.zone.No component(s) selected"/>.');
		return;
	}
	updateChanges();
}

function changeAssociation(value)
{
	var thisForm = document.configureZone;
	if(value==true)
	{
		thisForm.association.value="checked";
	}
	else
	{
		thisForm.association.value=null;
	}
	thisForm.action = "EgConfigZone.jsp?modifyassociate=true";
	thisForm.submit();	
}
function disassociate()
{
	var thisForm = document.configureZone;
	var serverselected = "false";
	manunmanage = true;

	//getting list size
	var j = thisForm.otherHosts.options.length;
	    var countin=0;
	//gettin list vars
	var list = thisForm.managedHosts;
	var mlist = thisForm.otherHosts;	

	 for(var y = 0 ; y < list.options.length ; y++)
	 {
	   if(list.options[y].selected == true)
		   countin++;
	 }
	 if(countin==list.options.length)
	 {
		if(thisForm.viewpresent.value=='Yes')
		{
			 var ans =confirm('<egui:intnl text="admin.zone.Disassociating all components will remove the corresponding zone views"/>.<egui:intnl text="admin.zone.Do you want to continue?"/>');
			 if(ans==false)
			 {
				return;
			 }
			thisForm.delview.value="yes"; 
		}
	}

	var disAssElems = "";
	for(var i = 0 ; i < list.options.length ; i++)
	{
		//browsing through to find selected items
		if(list.options[i].selected == true)
		{
			serverselected = "true";
			var txt=list.options[i].text;
			var val=list.options[i].value;
			var flag = 0;
			//to check if it already exists
			for(k = 0; k < mlist.options.length; k++)
			{
				if(val == mlist.options[k].value)
				{
					flag = 1;
				}
			}
			//addin the new name
			if(flag == 0)
			{
				disAssElems += val + ",";
				mlist.options[j++] = new Option (txt,val) ;
			}
		}
	}
	for(var x = list.options.length; x > 0 ; x--)
	{
		if(list.options[x-1].selected == true )
			list.options[x-1] = null;
	}
	
	if(serverselected == "false")
	{
		alert('<egui:intnl text="admin.zone.No component(s) selected"/>.');
		return;
	}

	if(thisForm.managedHosts.options.length > 0)
	{
		thisForm.disAssociatedElems.value = disAssElems;
		updateChanges();
	}
	else
	{
		window.location.href = "EgErrors.jsp";
	}
}

function listselect(x)
{
	var comp_type = document.configureZone.ComponentsType.options[document.configureZone.ComponentsType.selectedIndex].value;
	var zoneName = document.configureZone.zone.value;
	if(x == '1')
	{
		var thisForm = document.configureZone;
		thisForm.action = "EgConfigZone.jsp?comptype=" +encodeURI(comp_type) + "&qctr=1&zone=" + encodeURI(zoneName)+"&association="+document.configureZone.association.value;
		thisForm.submit();
	}
}

function updateChanges()
{
	var thisForm = document.configureZone;
	var j = thisForm.managedHosts.options.length;
	var mlist = thisForm.managedHosts;
	var marray = new Array();
	var comp_type = document.configureZone.ComponentsType.options[document.configureZone.ComponentsType.selectedIndex].value;
	var zoneName = document.configureZone.zone.value;
	for(var i=0; i<j; i++)
	{
		if(mlist.options[i].value == null)
			continue;
		marray[i] = mlist.options[i].value;
	}
	thisForm.chosenHosts.value = marray;
	if (isNetscape()) targetObj = thisForm.up;
	if (isIE()) targetObj = thisForm.up;
	thisForm.add.disabled=true;
	thisForm.remove.disabled=true;
	thisForm.action = "Egconfigzonep.jsp";
	thisForm.submit();	
}
</script>
</head>

<%
	EgGroupInfo groupinfo = new EgGroupInfo();
	EgTopoInfo topoinfo = groupinfo.getTopoInfoObject();//new EgTopoInfo("manager");
	EgDiscInfo discinfo = new EgDiscInfo("manager");
	IniFile topologyIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini");
	ArrayList managedHosts = new ArrayList();
	ArrayList managedZones = new ArrayList();
	ArrayList managedServices = new ArrayList();
	ArrayList managedSegments = new ArrayList();
	ArrayList managedGroups = new ArrayList();
	ArrayList allComponentTypes = new ArrayList();
	ArrayList minusHosts = new ArrayList();
	ArrayList allComponents = new ArrayList();

	String [] zones = groupinfo.getZoneNames();
	String [] groups = groupinfo.getGroupNames();
	String mode = request.getParameter("mode");
	String q_ctr = request.getParameter("qctr");
	String association = request.getParameter("association"); //this is the association flag
	String comp_type = "";
	String [] services = topoinfo.getWebSites();
	String [] allSegments = topoinfo.getSegmentNames();
	String modifyassociate=request.getParameter("modifyassociate");
	IniFile topoIniWr = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
	if(modifyassociate!=null && modifyassociate.equals("true"))
	{
		AuditLogThread auditLogThread = new AuditLogThread();	
		auditLogThread.setValue("Category","Admin");
		auditLogThread.setValue("User_id",_user.getLoginID());
		auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
		auditLogThread.setValue("Session_id",session.getId());
		auditLogThread.setValue("Module","Zones");
		auditLogThread.setValue("Activity", "Zone Configuration");
		if(association!=null && association.equals("checked"))
		{
			auditLogThread.setPreviousValue("Auto association","Disabled");
			auditLogThread.setCurrentValue("Auto association","Enabled");
			topoIniWr.setValue("ZONE_ASSOCIATION",zoneName,"checked");
		}
		else
		{
			auditLogThread.setPreviousValue("Auto association","Enabled");
			auditLogThread.setCurrentValue("Auto association","Disabled");
			topoIniWr.setValue("ZONE_ASSOCIATION",zoneName, "null");
		}
		auditLogThread.setValue("Description","Zone "+zoneName+" has been modified");
		auditLogThread.sendItToDB();
		topoIniWr.saveFile();
	}
	EgConfigFilesSync.releaseInstance(topoIniWr);
	topoIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
	String checking = topoIni.getValue("ZONE_ASSOCIATION", zoneName);
	if (!(checking==null) && !(checking.equals("")))
		association = checking;

	if(q_ctr!=null&&q_ctr.equals("1"))
	{
		comp_type=request.getParameter("comptype");
		allComponents = zoneinfo.getUnManagedZoneElements(zoneName, comp_type, true);
	}
%>

<body style="overflow:auto" id="space6"  scroll="auto" >

<form name="configureZone" method="post" action="Egconfigzonep.jsp" style="margin:0px">
<!-- Hidden field to store the association flag-->
<input type="hidden" name="association" value="<%=association%>">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" >

	<jsp:include page="listSearch.jsp?title=CONFIGURE ZONE&leftString=Add User&backButton=true&subtitle=false&searchBox=false"/>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
			<table align="center" cellspacing="0" cellpadding="0" width="95%" border="0" height="100%">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td id="eg_subcontentbg" class="form_spacing" >&nbsp;</td>
					<td id="eg_subcontentbg" valign="top" nowrap width="28%" class="form_spacing" style="padding-left:0px;padding-top:10px">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="cell_border1" >
							<tr>
								<th style="border-top-width:0px"  width="100%" id="eg_subheadbg" class="head_padding4">&nbsp;<egui:intnl text="admin.zone.TYPE OF ELEMENTS"/></th>
							</tr>
							<tr>
								<td id="eg_whitebg" align="center" nowrap width="250" height="28" class="space">
								<select name="ComponentsType" onchange="JavaScript:listselect('1')" style="width:250px;">
									<option value = "-1"> <egui:intnl text="admin.common.Choose One"/>  </option>
									<%
									allComponentTypes = zoneinfo.getAllCompTypes(zoneName);
									ArrayList serverList = new ArrayList(allComponentTypes);
									String userLanguage = _user.getLanguage();
									IniUI  iniUI = IniUI.getInstance();
									if (userLanguage == null)
										userLanguage = iniUI.getDefaultLanguage();
												
									MappingNameSorter sorter = new MappingNameSorter(userLanguage);
									serverList = sorter.getSortedCompTypeList(serverList);
																	

									for (int i=0; i<serverList.size(); i++)
									{
										//String thisType = (String) allComponentTypes.get(i);
										EgName nameObj = (EgName)serverList.get(i);
										String tmpVal = nameObj.getActualName();	
										String tmpDis = nameObj.getLocalName();	
										if (tmpVal.equals(comp_type))
										{
									%>
											<option value = "<%=tmpVal%>" selected><%=tmpDis%></option>
									<%
										}
										else
										{
									%>
											<option value = "<%=tmpVal%>"><%=tmpDis%></option>
									<%
										}
									}
									%>
								</select>
								</td>
							</tr>
						</table>
					</td>
					<td id="eg_subcontentbg" class="form_spacing" width="7">&nbsp;</td>
					<td id="eg_subcontentbg" class="form_spacing" valign="top" nowrap style="padding-right:0px;padding-top:10px">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="cell_border1">
							<tr>
								<th id="eg_subheadbg"  class="head_padding4" style="border-top-width:0px; text-align:left"> <egui:intnl text="admin.zone.ZONE SELECTED FOR CONFIGURATION"/></th>

								<td id="eg_subheadbg_lower" style="border-top-width:0px;text-align:right;" >
				<%
								String checked="";
								if(association!=null && association.equals("checked"))
									checked="checked";
				%>
								<egui:intnl text="Auto association "/></td>
								<td id="eg_subheadbg" style="border-top-width:0px;"><input type="checkbox" <%=checked%> name="associationmodified" value = "" class="eg_input" onclick="javascript:changeAssociation(this.checked);"></td>
				
								
							</tr>
							<tr>
								<td id="eg_whitebg" class="eg_subcontent" align="left" nowrap height="28"> &nbsp; <b><%=zoneName.toUpperCase()%></b>
								</td>
<%
						/** For map changes */
						if(mapEnabled)
						{
%>
								<td id="eg_whitebg" align="right" nowrap height="28">
								<a href="javascript:void(0)" class="eg_monlink" onclick="popupmap(event)">
<%
								if(latitude.equals("null") || longitude.equals("null"))
								{
%>
									<egui:intnl text="admin.zone.Add geographic location"/></a>
<%
								}
								else
								{
%>
									<egui:intnl text="admin.zone.Change / Remove geographic location"/></a> 
<%
								}
%>
								</td>
								<td id="eg_whitebg">&nbsp;</td>
<%
						}
						else
						{
%>
								<td id="eg_whitebg" align="right" nowrap height="28" colspan="2">&nbsp;</td>
<%
						}
%>
							</tr>
						</table>
					</td>
					<td id="eg_subcontentbg" class="form_spacing" width="5">&nbsp;</td>
				</tr>
				
				<tr>
					<td id="eg_subcontentbg" colspan="5" class="eg_blankspace" height="5px">&nbsp;</td>
				</tr>
				<iframe
  id="DivShim"
  src="javascript:false;"
  scrolling="no"
  frameborder="0"
  style="position:absolute; top:0px; left:0px; display:none;">
 </iframe>
				<tr>
					<td id="eg_subcontentbg" >&nbsp;</td>
					<td colspan="3"  id="eg_subcontentbg" width="100%" style="padding-left:0px;padding-bottom:8px">
						<table cellspacing="0" cellpadding="0" width="100%" border="0">
							<tr>
								<td align="right">
									<table align="right" cellspacing="0" cellpadding="0" border="0"  id="cell_border1">
										<tr>
											<th  id="eg_subheadbg" align='center' valign='middle' class="head_padding4" style="border-top-width:0px"><egui:intnl text="admin.zone.ELEMENTS ASSOCIATED"/></th>
										</tr>
										<tr>
											<td id="eg_subcontentbg" align="center" valign="top" height="300">
											<select name="managedHosts" id="managedHosts" size="25" multiple  style="width:370px;">
								<%
										String result = "";
										ArrayList mHosts = zoneinfo.getAllElementsUnderZone(zoneName);
											//getManagedZoneElements
											managedHosts = zoneinfo.getManagedZoneElements(zoneName, true);
										Collections.sort(managedHosts);
										StringBuffer prevVal = new StringBuffer();
										for(int x=0;x < managedHosts.size();x++)
										{
											String thisComponent = (String)managedHosts.get(x);
											result+=thisComponent;
											if (!((x+1)==managedHosts.size()))
												result+=",";

											String thisType = thisComponent.substring(0, thisComponent.indexOf(":"));
											String thisName = thisComponent.substring(thisComponent.indexOf(":")+1, thisComponent.lastIndexOf(":"));
											String thisPort = thisComponent.substring(thisComponent.lastIndexOf(":")+1);

											if (thisType.equals("Zone"))
											{
												managedZones.add(thisComponent);
												thisType = " ["+thisType+"] ";
											}
											else if (thisType.equals("Segment"))
											{
												managedSegments.add(thisComponent);
												thisType = " ["+thisType+"] ";
											}
											else if (thisType.equals("Service"))
											{
												managedServices.add(thisComponent);
												thisType = " ["+thisType+"] ";
											}
											else if (thisType.equals("Group"))
											{
												managedGroups.add(thisComponent);
												thisType = " ["+thisType+"] ";
											}else
											{
												thisType = ":"+_mapping.getComponentTypeDescription(thisType);
											}
											prevVal.append(thisComponent);
											if ((x+1)<managedHosts.size())
												prevVal.append(",");

											String thisDispString = thisName+(!thisPort.equals("NULL")?":"+thisPort:"")+thisType;
											out.println("<option value=" + thisComponent + ">" + thisDispString + "</option>");
										}
								%>
											</select>
											</td>
										</tr>
									</table>
								</td>
								<td align="center" valign="middle">
								<input type="button" value='<egui:intnl text="admin.common.Disassociate"/>  &rsaquo;&rsaquo;' class="eg_lightbutton" onClick="JavaScript:disassociate()" name="remove" style="width: 100px; letter-spacing: 0px;">
								<br><br><br>
								<input type="button" value='&lsaquo;&lsaquo; <egui:intnl text="admin.common.Associate"/>' class="eg_lightbutton" onClick="JavaScript:associate()" name="add" id="add" style="width: 100px; letter-spacing: 0px;">
								</td>
								<td align="left" >
									<table cellspacing="0" cellpadding="0" border="0"  id="cell_border1">
										<tr>
											<th id="eg_subheadbg" align='center' valign='middle' class="head_padding4" style="border-top-width:0px"><egui:intnl text="admin.zone.ELEMENTS AVAILABLE"/></th>
										</tr>
										<tr>
											<td id="eg_subcontentbg" align="center" valign="top" >
											<select name="otherHosts" size="25" multiple  style="width:370px; ">
								<%
									if (allComponents != null && !allComponents.isEmpty())
									{
										Collections.sort(allComponents,String.CASE_INSENSITIVE_ORDER);
									}
									for (int i=0; i<allComponents.size(); i++)
									{
										String thisComponent = (String)allComponents.get(i);
										String thisType = thisComponent.substring(0, thisComponent.indexOf(":"));
										String thisName = thisComponent.substring(thisComponent.indexOf(":")+1, thisComponent.lastIndexOf(":"));
										String thisPort = thisComponent.substring(thisComponent.lastIndexOf(":")+1);
										String thisDispString = thisName+(!thisPort.equals("NULL")?":"+thisPort:"");
								%>
											<option value = "<%=thisComponent%>"> <%=thisDispString%> </option>
								<%
									}
								%>
											</select>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
					<td id="eg_subcontentbg" class="padding4">&nbsp;</td>
				</tr>
				<tr>
					<td id="eg_subcontentbg" colspan="5" class="eg_blankspace" height="5px">&nbsp;</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg" colspan="3" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
				<tr>
					<td colspan="5" class="eg_blankspace" height="5px">&nbsp;</td>
				</tr>
				<tr>
					<td colspan="5" class="eg_blankspace" height="5px">&nbsp;</td>
				</tr>
				<!-- <tr>
					<td colspan="5" align="center" height="10">
						<SPAN ID="updateImg" STYLE="position:relative; visibility:visible;">
						<input type="hidden" name="mode" value="<%=mode%>">
						<input value='<egui:intnl text="admin.common.Update"/>' class="eg_back" onClick="javascript:updateChanges();" name="up" style="width: 90px;">
						</SPAN>
					</td>
				</tr> -->
			<%
			//to be used with javascript
				if (managedHosts.size() > 0)
				{
					managedHosts.removeAll(managedZones);
					managedHosts.removeAll(managedSegments);
					managedHosts.removeAll(managedServices);
					managedHosts.removeAll(managedGroups);
					ArrayList masters = groupinfo.getMainZoneList(zoneName, false);
					ArrayList slaves = groupinfo.getSubZoneList(zoneName, false);
			%>
				<tr>
					<td colspan= "5">
						<table width="100%" border=0 cellspacing="0" cellpadding="0">
						<tr>
							<td colspan= "3" id="table_header" style="text-align:left" height="22">
							&nbsp;&nbsp;<Strong><egui:intnl text="admin.zone.ASSOCIATED ELEMENTS"/>:</Strong>
							</td>
						</tr>
						<%
						if(masters != null)
							if (masters.size()>0)
							{
						%>
						<tr>
							<td id="cell_border1" align="left" width="20%" style="border-top-width:0px"	>
							<strong>&nbsp;<egui:intnl text="admin.zone.Main Zones"/></strong>
							</td>
							<td id="cell_border" align="left" width="80%">
							<%
								int size = masters.size();
								for(int x=0; x<size; x++)
								{
									//out.print(masters.get(x));
									%>
									<a class="dash_link" href= "EgConfigZone.jsp?qctr=0&mode=modify&zone=<%=EgURLEncoder.encode((String)masters.get(x),"UTF-8")%>" style="text-decoration:none"><%=masters.get(x)%><%=(size != (x+1)? ", ":"")%></a>
							<%
									//if(size != (x+1))
										//out.print(", ");
								}
							%>
							</td>
						</tr>
						<%
							}
						if(managedZones != null)
							if (managedZones.size()>0)
							{
						%>
						<tr>
							<td id="cell_border1" align="left" width="20%" style="border-top-width:0px">
							<strong>&nbsp;<egui:intnl text="admin.zone.SubZones"/></strong>
							</td>
							<td id="cell_border" align="left" width="80%">
							<%
								int size = managedZones.size();
								for(int x=0; x<size; x++)
								{
									String thisZone = (String)managedZones.get(x);
									String thisDispString = thisZone.substring(thisZone.indexOf(":")+1, thisZone.lastIndexOf(":"));
							%>
										<a class="dash_link" href= "EgConfigZone.jsp?qctr=0&mode=modify&zone=<%=EgURLEncoder.encode(thisDispString,"UTF-8")%>" style="text-decoration:none"><%=thisDispString%><%=(size != (x+1)? ", ":"")%></a>
							<%
									//if(size != (x+1))
										//out.print(", ");
								}
							%>
							</td>
						</tr>
						<%
							}
							if (managedServices.size()>0)
							{
						%>
						<tr>
							<td id="cell_border1" align="left" width="10%" style="border-top-width:0px">
							<strong>&nbsp;<egui:intnl text="admin.zone.Services"/></strong>
							</td>
							<td id="cell_border" align="left">
							<%
								int size = managedServices.size();
								int displayLength = 30;
								for(int x=0; x<size; x++)
								{
									String thisService = (String)managedServices.get(x);
									String thisDispString = thisService.substring(thisService.indexOf(":")+1, thisService.lastIndexOf(":"));
									%>
									<a class="dash_link" href= "EgConfigSites.jsp?site=<%=EgURLEncoder.encode(thisDispString,"UTF-8")%>&modify=true" style="text-decoration:none"><%=StringUtils.egSubString(thisDispString,displayLength)%><%=(size != (x+1)? ", ":"")%></a>
									<%
									//if(size != (x+1))
										//out.print(", ");
								}
							%>
							</td>
						</tr>
						<%
							}
							if (managedSegments.size()>0)
							{
						%>
						<tr>
							<td id="cell_border1" align="left" width="10%" style="border-top-width:0px">
							<strong>&nbsp;<egui:intnl text="admin.zone.Segments"/></strong>
							</td>
							<td id="cell_border" align="left">
							<%
								int size = managedSegments.size();
								int displayLength = 30;
								for(int x=0; x<size; x++)
								{
									String thisSegment = (String)managedSegments.get(x);
									String thisDispString = thisSegment.substring(thisSegment.indexOf(":")+1, thisSegment.lastIndexOf(":"));
									%>
									<a class="dash_link" href= "EgAdminTopology.jsp?qctr=0&segment=<%=EgURLEncoder.encode(thisDispString,"UTF-8")%>" style="text-decoration:none"><%=StringUtils.egSubString(thisDispString,displayLength)%><%=(size != (x+1)? ", ":"")%></a>
									<%
									//if(size != (x+1))
										//out.print(", ");
								}
							%>
							</td>
						</tr>
						<%
							}
							if (managedGroups.size()>0)
							{
						%>
						<tr>
							<td id="cell_border1" align="left" width="10%" style="border-top-width:0px">
							<strong>&nbsp;<egui:intnl text="admin.zone.Groups"/></strong>
							</td>
							<td id="cell_border" align="left">
							<%
								int size = managedGroups.size();
								for(int x=0; x<size; x++)
								{
									String thisSrv =(String)managedGroups.get(x);
									String thisDispString=thisSrv.substring(thisSrv.indexOf(":")+1, thisSrv.lastIndexOf(":"));
							%>
									<a class="dash_link" href="EgConfigGroup.jsp?qctr=0&mode=modify&group=<%=EgURLEncoder.encode(thisDispString,"UTF-8")%>" style="text-decoration:none"><%=thisDispString + "" + (size != (x+1)? ", ":"")%></a>
							<%
									//if(size != (x+1))
									//	out.print(", ");
								}
							%>
							</td>
						</tr>
					<%
						}
						if (managedHosts.size()>0)
						{
					%>
						<tr>
							<td id="cell_border1" align="left" width="10%" style="border-top-width:0px">
							<strong>&nbsp;<egui:intnl text="admin.zone.Components"/></strong>
							</td>
							<td id="cell_border" align="left">
						<%
							int size = managedHosts.size();
							for(int x=0; x<size; x++)
							{
								String thisHost = (String)managedHosts.get(x);
								String thisType = thisHost.substring(0, thisHost.indexOf(":"));
								String thisName = thisHost.substring(thisHost.indexOf(":")+1, thisHost.lastIndexOf(":"));
								String thisPort = thisHost.substring(thisHost.lastIndexOf(":")+1);
								String thisDispString = thisName+(!thisPort.equals("NULL")?":"+thisPort:"")+":"+thisType;
								String finalDisplayString=thisName+(!thisPort.equals("NULL")?":"+thisPort:"")+":";
								if(thisType.startsWith("Agg_"))
								{
						%>
								<a class="dash_link" href="EgAggregateTree.jsp?qctr=1&server=<%=EgURLEncoder.encode(thisType,"UTF-8")%>&reqfrom=home&isAggregateLink=true" style="text-decoration:none"><%=finalDisplayString%>
								<egui:intnl type="<%=thisType%>"/><%=(size != (x+1)? ", ":"")%></a>
						<%
								}
								else
								{
%>
								<a class="dash_link" href="EgDispServer.jsp?qctr=1&server=<%=EgURLEncoder.encode(thisType,"UTF-8")%>" style="text-decoration:none"><%=finalDisplayString%>
								<egui:intnl type="<%=thisType%>"/><%=(size != (x+1)? ", ":"")%></a>
<%
								}
								//if(size != (x+1))
									//out.print(", ");
							}
						%>
							</td>
						</tr>
					<%
						}
					%>
					</table>
				</td>
			</tr>
			<tr>
				<td height=10></td>
			</tr>
			<%
				}
					else
					{
			%>
			<tr>
				<td colspan= "5">
					<table width="100%" border=0 bgcolor = white>
					<tr>
						<td align="center"><img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif">
						</td>
					</tr>
					<tr>
						<td align="center" id="eg_errorsmall">
						<egui:intnl text="admin.zone.No components have been associated with this zone"/>
						</td>
					</tr>
					</table>
				</td>
			</tr>
			<%
					}
			%>
		</table>
	</td>
</tr>
</table>

<!-- Hidden field to store all hosts associated to the chosen zone -->
<input type="hidden" name="chosenHosts" value="" id="chosenHosts">
<!-- Hidden field to store all hosts associated previosly to the chosen zone -->
<input type="hidden" name="previousHosts" value="<%=prevVal.toString()%>" id="previousHosts">
<%
   String viewpresent="no";
   Vector viewzone=egviewinfo.getviewsforzone(zoneName);
   if(viewzone.isEmpty())
      viewpresent="no";
      else
	     viewpresent="Yes";

%>
<!-- Hidden field to store the zoneName -->
<input type="hidden" name="viewpresent" value="<%=viewpresent%>">
<input type="hidden" name="zone" id="zone" value="<%=zoneName%>">
<input type="hidden" name="comp_type" value=<%=comp_type%>>
<input type="hidden" name="latitude" id="latitude" value="<%=latitude%>">
<input type="hidden" name="longitude" id="longitude" value="<%=longitude%>">
<input type="hidden" name="latitude_prev" id="latitude_prev" value="<%=latitude%>">
<input type="hidden" name="longitude_prev" id="longitude_prev" value="<%=longitude%>">
<input type="hidden" name="delview" value="no">
<input type="hidden" name="mode" value="<%=mode%>">
<input type="hidden" name="disAssociatedElems" value="">

</form>
</div>
</body>
</html>

<%
	Vector sess_vec = new Vector();
	sess_vec.addElement("Configure zones");
	sess_vec.addElement("EgConfigZone.jsp?comptype=" +EgURLEncoder.encode(comp_type,"UTF-8") + "&qctr=1&zone="+EgURLEncoder.encode(zoneName,"UTF-8"));
	sess_vec.addElement("All elements cannot be removed from the zone");	
	sess_vec.addElement("All elements cannot be removed from the zone.");
	sess_vec.addElement("Hence this operation cannot be performed.");
	session.putValue("vec_Errors",sess_vec);
%>
<%
	String queryString = request.getQueryString();

	String Qstring="";
	if(queryString!=null)
	{
		StringTokenizer strtok = new StringTokenizer(queryString,"&");
		while(strtok.hasMoreTokens())
		{
			String param = strtok.nextToken();
			int ind = param.indexOf("=");
			if (ind < 0)
				continue;
			String reqparam =param.substring(0,ind);
			String value = param.substring(ind+1);
			if(reqparam!=null&&reqparam.equals("zone"))
			{
				value=com.eg.EgURLEncoder.encode(request.getParameter(reqparam), "UTF-8");
			}
			
			Qstring=Qstring+reqparam+"="+value+"&";
		}
	}
	if(Qstring!=null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgConfigZone.jsp?"+Qstring+"&zone="+zoneName+"&association="+association);
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgConfigZone.jsp");
	}
%>



