<%
/*******************************************************************************
 *	Name            :	EgConfigSnmpMeasure.jsp
 *	Author          :	Sandhya.K
 *	Version         :   2.3
 *	CreationDate    :   23/09/2002
 *	LastModified	:   15/10/2002 //sandhya - Modify measure details	  
 *						24/09/2002	
 *						25/05/2004	Arun	Fixed StringOutBoundsException
*******************************************************************************/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.EgTesterInfo" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import="java.util.*" %>
<%@ page import="egurkha.*" %>

<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%!
	private int getConfigTestSizeIndex(int dbsize)
	{
		int val=-1;
		switch(dbsize)
		{
			case 32: val=1;break;
			case 64: val=2;break;
			case 128: val=3;break;
			case 256: val=4;break;
			case 512: val=5;break;
			case 1024: val=6;break;
		}
		return val;
	}

	private String [] processes = {
									"UNALTERED",
									"PERCENT_INCREASE",
									"PERCENT_DECREASE",
									"PERCENT_CHANGE",
									"RATIO",
									"RATE",
									"DIFFERENCE"
								};

	private boolean isFirst = true;
	private Hashtable factorsMapping = new Hashtable();
	IniFile iniUI = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String factors [] = iniUI.getVariables("CONVERSION_FACTORS");

	String helpuploadDir=EgInstallInfo.getInstallDir()+	"/manager/tomcat/webapps/final/eghelp";
	helpuploadDir=StringUtils.replace(helpuploadDir,"\\","/");
	
	if(isFirst)
	{
		if(factors != null && factors.length > 0)
		{
			for (int i=0;i<factors.length;i++)
			{
				String var = (String) factors[i];
				String val = iniUI.getValue("CONVERSION_FACTORS", var);
				factorsMapping.put(val, var);
			}
			isFirst = false;
		}
	}
%>


<jsp:useBean id="trans" class="egurkha.TransactionBean" scope="page" />
<%
	boolean isDouble=EgDbInfo.doubleByteEnabled;
	IniFile iniFile=new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_udtests.ini");
	String test = request.getParameter("test");
	String mname = request.getParameter("measure");
	String dbsize = request.getParameter("dbsize");
	String unitValue = request.getParameter("unit");
	String index = request.getParameter("index");
	String process = request.getParameter("process");
	String oid = request.getParameter("oid");
	if(oid == null )
		oid = "";
	String factor = request.getParameter("factor");
	if(factor == null || factor.length() == 0 || factor.equals("null"))
		factor = "1";

	String scrollPosition = request.getParameter("position");
	scrollPosition = scrollPosition == null?"0":scrollPosition;

	session.setAttribute("factorsMapping", factorsMapping);

	String  oid_fileName=request.getParameter("fileName");
	String fieldName=request.getParameter("fieldName");
	if(oid_fileName==null || oid_fileName.equals(""))
		oid_fileName=iniFile.getValue("TEST_MIBFILE_MAPPING",test+"#"+mname+":ObjectOID");
	String  element_fileName=iniFile.getValue("TEST_MIBFILE_MAPPING",test+":ElementOID");
	String  status_fileName=iniFile.getValue("TEST_MIBFILE_MAPPING",test+":StatusOID");

	TestBean testBean = new TestBean(true);
	String single = "";
	String multiple = "";
	String elementOid = "";
	String validOid = "";
	String validValue = "";
	String rediscPeriod = "60";
	boolean isConfigTest = EgInstallInfo.isConfigTest(test);
	int iConfigFieldSize=new EgTesterInfo("manager").getConfigTestFieldSize(test);
	String display = request.getParameter("display");
	String snmpOID = testBean.getSnmpOID(test);
	//If no snmp info, enable single element
	if(snmpOID == null || snmpOID.equals("") || snmpOID.length() == 0)
	{
		/*
		display is null when "single element" is not clicked
		display is false when "single element" is clicked
		display is true when "multiple elements" are clicked
		*/						
		if(display == null || display.equals("null") 
			|| display.equals("false")) 
		{
			single = "checked";
		}
		else if(display.equals("true"))
		{
			multiple = "checked";
		}
	}
	//If snmp info is available, enable multiple elements
	else
	{
		trans.createFile("eg_udtests.ini");
		String isMultipleEnabled = trans.getStrValue("MULTIPLE",test);
		
		if(isMultipleEnabled != null && isMultipleEnabled.equals("true") 
			&& (display == null || display.equals("true")))
		{
			multiple = "checked";
			display = "true";
		}
		else if(display != null && display.equals("false"))
			single = "checked";
		
		StringTokenizer st =  new StringTokenizer(snmpOID,",");
		while(st.hasMoreTokens())
		{
			elementOid = st.nextToken();
			elementOid = elementOid.substring(elementOid.indexOf(":")+1);
			validOid = st.nextToken();
			validOid = validOid.substring(validOid.indexOf(":")+1);
			validValue = st.nextToken();
			validValue = validValue.substring(validValue.indexOf(":")+1);
			rediscPeriod = st.nextToken();
			rediscPeriod = rediscPeriod.substring(rediscPeriod.indexOf(":")+1);
		}
	}

	ArrayList units = testBean.getAllUnits();
	Collections.sort(units);
	ArrayList measures_list = testBean.getMeasuresForTest(test);
	int i_mes_count = 0;
	if(measures_list != null)
	{
		i_mes_count = measures_list.size();
	}
	String size1 = "";
	String size2 = "";
	String size3 = "";
	String size4 = "";
	String size5 = "";

	if(mname == null || mname.length() == 0)
		mname = "";

	if(dbsize != null && dbsize.length() != 0)
	{
		if(dbsize.equals("1"))
			size1 = "selected";
		else if(dbsize.equals("2"))
			size2 = "selected";
		else if(dbsize.equals("3"))
			size3 = "selected";

	}

	String [] factorSel = new String[factors.length];
	for(int i=0; i<factorSel.length; i++)
	{
		if(iniUI.getValue("CONVERSION_FACTORS",(String)factors[i]).equals(factor))
			factorSel[i] = "selected";
		else
			factorSel[i] = "";
	}

	boolean isFactorEnabled = false;
	if(process == null)
	{
		isFactorEnabled = true;
	}
	else if(process.equals("UNALTERED") || process.equals("DIFFERENCE"))
	{
		isFactorEnabled = true;
	}
	
	String [] procSel = new String[processes.length];
	for(int i=0; i<procSel.length; i++)
		if(processes[i].equals(process))
			procSel[i] = "selected";
		else
			procSel[i] = "";

	Hashtable procVals = testBean.getProcesses(test);
	Hashtable factVals = testBean.getFactors(test);

	String testType = iniFile.getValue("TYPE",test);
	String snmpElement = "";
	if (testType != null && testType.equalsIgnoreCase("Snmp"))
	{
		snmpElement = iniFile.getValue("MULTIPLE",test);
	}
%>

<html>
<head>
<title>SNMP</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<!-- <link rel="stylesheet" href="eg_styles/eg_adminstyle.css" /> -->
<egui:skin ui="adminindex"/>
<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script language="JavaScript">

var keyArr = new Array("other","none","null","all");

var snmpElement = '<%=snmpElement%>';
function isNetscape() 
{
   // get browser info. 
   appName= navigator.appName;
   appLongVer = navigator.appVersion;
   appVer = appLongVer.substring(0, 1); 

   // check for Navigator ver 4+. 
   if ((appName == "Netscape") && (appVer >= 4)) return true;
   return false;
}

function isIE() 
{
   // get browser info. 
   appName= navigator.appName;
   appLongVer = navigator.appVersion;
   appVer = appLongVer.substring(0, 1); 

   // check for IE ver 4+. 
   if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
   return false;
}


function addMeasure1(val)
{
	var thisForm = document.addMeasure;
	var isConfigTest=new Boolean(thisForm.configtestflag.value).valueOf();

	var textareaval;
	var disp_String =true;
	if(!isConfigTest)
	{
		textareaval = thisForm.alarmdescription.value;
		if(!checkspecial(thisForm.alarmdescription,"~!@#$%^&*():,;'<>"))
		{
			return;
		}
		if('<%=isDouble%>'=="false")
		{
			disp_String = validateSingleByte(thisForm.alarmdescription.value);
		}
	}

	var meas = thisForm.measure.value;
	meas = meas.toUpperCase();
	if(meas == "TRGT_HOST" || meas == "PORT_NO"
	|| meas == "SITE_NAME" || meas == "INFO"
	|| meas == "MSMT_HOST" || meas == "MSMT_TIME")
	{
		alert('<egui:intnl text="admin.ic.Database keyword(s) cannot be entered as measure name(s)"/>');
		return;
	}

	ch = meas.charAt(0);
	var un = thisForm.un.options[thisForm.un.selectedIndex].value;
	var flag = "true";

	if(!checkblank(thisForm.measure))
	{
		alert('<egui:intnl text="admin.ic.Please enter a measure"/>');
		thisForm.measure.focus();
		if(val == "formsubmit")
		{
			return false;
		}
		else
		{
			flag = "false";
		}
	}
	else if(!checkspace(thisForm.measure))
	{
		thisForm.measure.focus();
		if(val == "formsubmit")
		{
			return false;
		}
		else
		{
			flag = "false";
		}
	}
	else if(!checkspecialnomess(document.addMeasure.measure, "`~!@#$%^&*()+=-/?'\"]{}[\\|;:.,><"))
	{
		alert('<egui:intnl text="admin.ic.No special characters allowed"/>');
		thisForm.measure.focus();
		if(val == "formsubmit")
		{
			return false;
		}
		else
		{
			flag = "false";
		}
	}
	else if(ch >= '0' && ch <= '9')
	{
		alert('<egui:intnl text="admin.ic.Number not allowed as the first character"/>');
		thisForm.measure.focus();
		if(val == "formsubmit")
		{
			return false;
		}
		else
		{
			flag = "false";
		}
	}
	else if(ch == '_')
	{
		alert('<egui:intnl text="admin.ic.Underscore not allowed as the first character"/>');
		thisForm.measure.focus();
		if(val == "formsubmit")
		{
			return false;
		}
		else
		{
			flag = "false";
		}
	}
	else if(!validateSingleByte(thisForm.measure.value))
	{
		alert('<egui:intnl text="admin.ic.Measure name is not allowed in DBL(Chinese,Korean,Japanese)"/>');
		thisForm.measure.focus();
		return false
	}
	else if(un == "-1")
	{
		alert('<egui:intnl text="admin.ic.Please select a unit"/>');
		if(val == "formsubmit")
		{
			return false;
		}
		else
		{
			flag = "false";
		}
	}
	else if(un == "other")
	{
		if(!checkblank(thisForm.otherunit))
		{
			alert('<egui:intnl text="admin.ic.Please enter a unit"/>');
			thisForm.otherunit.focus();
			if(val == "formsubmit")
			{
				return false;
			}
			else
			{
				flag = "false";
			}
		}
		else if(!checkspace(thisForm.otherunit))
		{
			thisForm.otherunit.focus();
			if(val == "formsubmit")
			{
				return false;
			}
			else
			{
				flag = "false";
			}
		}
		else if(!checkspecialnomess(thisForm.otherunit, "`~!@#^&*()+=-?'\"]{}[\\|;:.,><"))
		{
			alert('<egui:intnl text="admin.ic.No Special Characters allowed"/>');
			thisForm.otherunit.focus();
			if(val == "formsubmit")
			{
				return false;
			}
			else
			{
				flag = "false";
			}
		}
		else if (!checkKeywords(thisForm.otherunit,keyArr))
		{
			alert('<egui:intnl text ="admin.ic.Please enter a valid unit"/>');
			thisForm.otherunit.focus();
			if(val == "formsubmit")
			{
				return false;
			}
			else
			{
				flag = "false";
			}
		}
		else if (!checkblank(thisForm.oid))
		{
			alert('<egui:intnl text="admin.ic.Please enter an object oid"/>');
			thisForm.oid.focus();
			if (val == "formsubmit")
			{
				return false;
			}
			else
			{
				flag = "false";
			}
		}
		else if(checkAlpha(thisForm.oid.value))
		{
			alert('<egui:intnl text="admin.ic.Alphabets are not allowed"/>');
			thisForm.oid.focus();
			if (val == "formsubmit")
			{
				return false;
			}
			else
			{
				flag = "false";
			}
		}
	}
	else if(!disp_String)
	{
		alert('<egui:intnl text="admin.ic.Alarm display string is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"/>');
		thisForm.alarmdescription.focus();
		return false;
	}
	else if(!checkblank(thisForm.oid))
	{
		alert('<egui:intnl text="admin.ic.Please enter an object oid"/>');
		thisForm.oid.focus();
		if(val == "formsubmit")
		{
			return false;
		}
		else
		{
			flag = "false";
		}
	}
	else if(!checkspecialnomess(thisForm.oid, "`~!@#$%^&*()+=-_?\'\"]{}[\\|;:,><"))
	{
		alert('<egui:intnl text="admin.ic.No Special Characters allowed"/>');
		thisForm.oid.focus();
		if(val == "formsubmit")
		{
			return false;
		}
		else
		{
			flag = "false";
		}
	}
	else if(checkAlpha(thisForm.oid.value))
	{
		alert('<egui:intnl text="admin.ic.Alphabets are not allowed"/>');
		thisForm.oid.focus();
		if(val == "formsubmit")
		{
			return false;
		}
		else
		{
			flag = "false";
		}
	}
	else if(!validateSingleByte(thisForm.oid.value))
	{
		alert('<egui:intnl text="admin.ic.Object OID is not allowed in DBL(Chinese,Korean,Japanese)"/>');
		thisForm.oid.focus();
		return false
	}

	if(flag == "true")
	{
//		if (isNetscape()) targetObj = document.updateImg;
//		if (isIE()) targetObj = updateImg.style;
//		targetObj.visibility = "hidden";
		thisForm.submit();
	}
}

function genTest()
{
	var thisForm = document.genMeasure;
	var validate = thisForm.validate.value;
	if(validate == "true")
	{
		if(!checkblank(thisForm.elementOid))
		{
			alert('<egui:intnl text="admin.ic.Please enter element OID"/>');
			thisForm.elementOid.focus();
			return;
		}
		else if(!checkspecialnomess(thisForm.elementOid, "`~!@#$%^&*()+=-_?\'\"]{}[\\|;:,><"))
		{
			alert('<egui:intnl text="admin.ic.No Special Characters allowed"/>');
			thisForm.elementOid.focus();
			return;
		}
		else if(checkAlpha(thisForm.elementOid.value))
		{
			alert('<egui:intnl text="admin.ic.Alphabets are not allowed"/>');
			thisForm.elementOid.focus();
			return;
		}
		else if(!validateSingleByte(thisForm.elementOid.value))
		{
			alert('<egui:intnl text="admin.ic.Element ID(OID) is not allowed in DBL(Chinese,Korean,Japanese)"/>');
			thisForm.elementOid.focus();
			return;
		}
		else if(!validateSingleByte(thisForm.validOid.value))
		{
			alert('<egui:intnl text="admin.ic.Element status (OID) is not allowed in DBL(Chinese,Korean,Japanese)"/>');
			thisForm.validOid.focus();
			return;
		}
		else if(!validateSingleByte(thisForm.validValue.value))
		{
			alert('<egui:intnl text="admin.ic.Element valid status is not allowed in DBL(Chinese,Korean,Japanese)"/>');
			thisForm.validValue.focus();
			return;
		}
		else if(!checkblank(thisForm.rediscPeriod))
		{
			alert('<egui:intnl text="admin.ic.Please enter rediscovery period"/>');
			thisForm.rediscPeriod.focus();
			return;
		}
		else if(!checkspecialnomess(thisForm.rediscPeriod, "`~!@#$%^&*()+=-_?\'\"]{}[\\|;.:,><"))
		{
			alert('<egui:intnl text="admin.ic.No Special Characters allowed"/>');
			thisForm.rediscPeriod.focus();
			return;
		}
		else if(checkAlpha(thisForm.rediscPeriod.value))
		{
			alert('<egui:intnl text="admin.ic.Alphabets are not allowed"/>');
			thisForm.rediscPeriod.focus();
			return;
		}
		else if(thisForm.rediscPeriod.value == 0)
		{
			alert('<egui:intnl text="admin.ic.Only valid integers are allowed"/>');
			thisForm.rediscPeriod.focus();
			return;
		}
		else if(!validateSingleByte(thisForm.rediscPeriod.value))
		{
			alert('<egui:intnl text="admin.ic.Rediscovery period is not allowed in DBL(Chinese,Korean,Japanese)"/>');
			thisForm.rediscPeriod.focus();
			return;
		}
		else
		{
			if (snmpElement != "")
			{
				alert('<egui:intnl text ="admin.ic.You are modifying an existing test"/>'+". "+'<egui:intnl text ="admin.ic.Please note that data already collected for this test will no longer be available after the modification"/>'+".");
			}

			if (isNetscape()) targetObj = document.genMeasure.genImg;
			if (isIE()) targetObj = document.genMeasure.genImg;
			targetObj.disabled = true;
			thisForm.submit();
		}
	}
	else
	{
		if (snmpElement != "")
		{
			alert('<egui:intnl text ="admin.ic.You are modifying an existing test"/>'+". "+'<egui:intnl text ="admin.ic.Please note that data already collected for this test will no longer be available after the modification"/>'+".");
		}

		if (isNetscape()) targetObj = document.genMeasure.genImg;
		if (isIE()) targetObj = document.genMeasure.genImg;
		targetObj.disabled = true;
		thisForm.submit();
	}
}

function callElements(element)
{
	var thisForm = document.addMeasure;
	var test = thisForm.test.value;
	var isConfigTest=new Boolean(thisForm.configtestflag.value).valueOf();
	var unit = thisForm.un.options[thisForm.un.selectedIndex].value;
	var dbsize = !isConfigTest?thisForm.dbsize.options[thisForm.dbsize.selectedIndex].value:null;
	//var dbsize = thisForm.dbsize.options[thisForm.dbsize.selectedIndex].value;
	var mname = thisForm.measure.value;
	var process = thisForm.process.value;
	//var dbsize = thisForm.dbsize.value;
	var index = thisForm.index.value;
	var oid = thisForm.oid.value;
	scrollPosition = document.body.scrollTop;
	thisForm.position.value = scrollPosition;

	var factor = null;
	if(thisForm.cFactor != null)
	{
		factor = thisForm.cFactor.options[thisForm.cFactor.selectedIndex].value;
	}

	var str = "";
	if(element == "single")
	{
		str = "EgConfigSnmpMeasure.jsp?display=false&test="+ test + "&unit=" + unit + 
			                    "&measure=" + mname + "&process=" + process + "&factor=" + factor + "&dbsize=" + dbsize +
                                "&index=" + index +"&oid="+ oid+ "&position=" + scrollPosition;
	}
	else
	{
		str = "EgConfigSnmpMeasure.jsp?display=true&test=" + test + "&unit=" + unit + 
								"&measure=" + mname + "&process=" + process + "&factor=" + factor + "&dbsize=" + dbsize +
                                "&index=" + index +"&oid="+ oid+ "&position=" + scrollPosition;
	}
	window.location.href= str;
}

var scrollPosition = '<%=scrollPosition%>';

function listSelect(callFrom)
{       
	var thisForm = document.addMeasure;
	var isConfigTest=new Boolean(thisForm.configtestflag.value).valueOf();
    var unit = thisForm.un.options[thisForm.un.selectedIndex].value;
	var test = thisForm.test.value;
	var mname = thisForm.measure.value;
	var dbsize = !isConfigTest?thisForm.dbsize.options[thisForm.dbsize.selectedIndex].value:null;
	//var dbsize = (!isConfigTest)?thisForm.dbsize.value:value;
	var process = thisForm.process.value;
	var oid = thisForm.oid.value;

	scrollPosition = document.body.scrollTop;
	thisForm.position.value = scrollPosition;

	var factor = null;
	if(thisForm.cFactor != null)
	{
		factor = thisForm.cFactor.options[thisForm.cFactor.selectedIndex].value;
	}
		
	var fileName=document.genMeasure.fileName.value;
	if(fileName=="")
	{
		fileName='<%=oid_fileName%>';
	}
	var  fieldName=document.addMeasure.oid_fieldName.value;
	if(unit == "-1" && callFrom == "unit")
	{
		alert('<egui:intnl text="admin.ic.Please select a unit"/>');
	}
        else
	{
		var index = thisForm.index.value;

		var str = "EgConfigSnmpMeasure.jsp?test=" + 
				test + "&unit=" + unit + "&measure=" + mname +
				"&process=" + process + "&factor=" + factor + "&dbsize=" + dbsize +
				"&index=" + index +"&oid="+ oid+"&fileName="+fileName+"&fieldName="+fieldName+"&flag1="+"true" +"&oidFlag=" + "true"+ "&position=" + scrollPosition;
		window.location.href = str;

	}
} 

function factorSelect()
{
	var thisForm = document.addMeasure;
	if(document.getElementById("factor") != null)
	{
		document.getElementById("factor").value = thisForm.cFactor.options[thisForm.cFactor.selectedIndex].value;
	}
}

function del(test,key)
{
	var a=confirm('<egui:intnl text="admin.ic.Do you want to delete this measure?"/>');
	if(a)
		window.location.href="Egconfigsnmpmeasurep.jsp?add=del&test="+test+"&measure="+key;
}
function openWin(event,from,fieldName)
{
		var fileName="";
		var oid="";
		var elementId='<%=elementOid%>';
		var statusId='<%=validOid%>';
		if(fieldName=="ObjectOID")
		{
				fileName=document.genMeasure.fileName.value;
				oid=document.addMeasure.oid.value;
				if(fileName=="")
				{
					fileName='<%=oid_fileName%>';
				}

				document.getElementById("bug_select1").style.visibility = 'hidden';
				document.getElementById("bug_select2").style.visibility = 'hidden';
				document.getElementById("bug_select3").style.visibility = 'hidden';
		}
		else if(fieldName=="ElementOID")
		{
				fileName=document.genMeasure.element_fileName.value;
				oid=document.genMeasure.elementOid.value
				if(fileName=="")
				{
					fileName='<%=element_fileName%>';
				}
				if(oid=="")
				{
						oid='<%=elementOid%>';
				}
		}
		else if(fieldName=="StatusOID")
		{
				fileName=document.genMeasure.status_fileName.value;
				oid=document.genMeasure.validOid.value
				if(oid=="")
				{
						oid='<%=validOid%>';
				}
				if(fileName=="")
				{
					fileName='<%=status_fileName%>';
				}
				if(fileName=="")
				{
					fileName=document.genMeasure.element_fileName.value;
				}
		}
		if(fileName=="")
		{	
				fileName=document.genMeasure.fileName.value;
				if(fileName=="")
				{
					fileName='<%=oid_fileName%>';
				}
		}

		var url="/final/admin/showMibFiles.jsp?from="+from+"&fieldName="+fieldName+"&fileList="+fileName+"&oid="+oid;
	
		event=event?event:window.event;
		
		openMapWindow('EgMap',event,url,fileName,fieldName);
		
}
var isMinNS4;
var isMinIE4;
var isMinIE5;
var mapW;
var mapH;


function openMapWindow(screenname, event,url,fileName,fieldName)
{
		mapW = 800;
		mapH = 460;
		event=event?event:window.event;
		if (event==null)
		{
			event=window.event;
		}
		var s;
		// Set global flags based on browser type and version.
		isMinNS4 = (navigator.appName.indexOf("Netscape") >= 0 &&
		parseFloat(navigator.appVersion) >= 4) ? (browser="netscape") : 0;
		isMinIE4 = (document.all) ? 1 : 0;
		if (isMinIE4)
		{
				s = navigator.appVersion;
				s = s.substr(s.indexOf("MSIE")).substr(5);
				isMinIE5 = parseFloat(s) >= 5 ? (browser="ie") : 0;
		}
		destroyMapWindow('egmap');
		var mapDiv = document.createElement("div");
		if (mapDiv!=null)
		{
			mapDiv.setAttribute("id", "egmap");
			mapDiv.id="egmap";
			mapDiv.name="egmap";
			//mapDiv.style.background="white";
			mapDiv.style.position="absolute";
			mapDiv.style.zIndex="100";
			mapDiv.style.visibility="visible";
			if(screenname=='EgMap')
			{
				var scrW = document.body.clientWidth;
				var scrH = document.body.clientHeight;
				var mouseposY=event.clientY + document.body.scrollTop;
				mapX = ((scrW/2)-(mapW/2))+10;
				mapY=mouseposY-380;
				
				if(fieldName=="ElementOID")
				{
					mapY=mapY+160;
				}
				else if(fieldName=="StatusOID")
				{
					mapY=mapY+133;
				}
				mapDiv.style.pixelLeft=	mapX;
				mapDiv.style.left=mapX+"px";
				mapDiv.style.pixelTop=mapY;
				mapDiv.style.top=mapY+"px";
			}
				mapDiv.style.pixelWidth=mapW;
				mapDiv.style.pixelHeight=mapH;
				document.forms[0].appendChild(mapDiv);
				execute(url,fileName);
		}
		else
		{
			alert("Could not open TimeFilter window");
		}
	return;
}

var httpRequest=false;
function  execute(url,fileName)
{
	if (window.XMLHttpRequest)
	{
		httpRequest = new XMLHttpRequest();
		if (httpRequest.overrideMimeType)
		{
			httpRequest.overrideMimeType('text');
		}
	}
	else if (window.ActiveXObject)
	{
		try
		{
			httpRequest = new ActiveXObject("Msxml2.XMLHTTP");
		}
		catch (e)
		{
			try
			{
				httpRequest = new ActiveXObject("Microsoft.XMLHTTP");
			}
			catch (e)
			{
			}
		}
	}
	if (!httpRequest)
	{
		alert('<egui:intnl text="monitor.home.Giving up -Cannot create an XMLHTTP instance"/>');
		return false;
	}
	httpRequest.onreadystatechange = function() {  writeResponse(fileName); };
	httpRequest.open('GET',url, true);
	httpRequest.send(null);
}

function writeResponse(fileName)
{
	if (httpRequest.readyState == 4 || httpRequest.readyState=="complete")
	{
		if (httpRequest.status == 200)
		{
			document.getElementById("egmap").innerHTML=httpRequest.responseText;
			//if(fileName!=null && fileName!="")
				showTree("");

		}
	}
}
function loading()
{
	var log1=document.getElementById("Tree");
	var myhtml = "<table border='0' height='100%'><tr><td align='center' valign='middle'><img src='/final/admin/eg_images/loading1.gif'></td><td align='center'>loading....</td></tr></table>";
	log1.innerHTML=myhtml;
}

function openWindow()
{
	var remoteWin = window.open("EgRemoteUpload.jsp?page=EgUploadMIB&mibBrowser=true","DataWindow","width=400,height=150,left=320,top=300,screenX=320,screenY=300,scrollbars=no,scrollbars=0,resizable=no");
	remoteWin.focus();
}
function sortAvailable(selectbox,fileName)
{
	var ai = document.getElementById(selectbox);
	var tmp = "",val="";
	// first we create an string from all of the text and
	// values of the list box.  In this example I use the
	// tilde (~) symbol to seperate the text and value and
	// use a comma to seperate the options from each other.
	for (i=0;i<ai.options.length;i++)
	{
		if(ai.options[i].text!=null && ai.options[i].value!=null && ai.options[i].text!="null" && ai.options[i].value!="null" && ai.options[i].text!="" && ai.options[i].value!="" && ai.options[i].text!="Please Choose a MIB File" && ai.options[i].value!="-1")
		{
			if (tmp > "") tmp +=",";
			tmp += ai.options[i].text;
			if(val>"") val+=",";
			val+=ai.options[i].value;
		}
	}
	// now we split the string into an array using the Javascript
	// split function.
	var atmp = tmp.split(",");
	var valarr=val.split(",");
	// sort the array
	atmp = atmp.sort();
	valarr=valarr.sort();
	// Clear the list box
	ai.options.length = 0;
	// Add the sorted options to the list box.
	ai.options[0]=new Option("Please Choose a MIB File","-1");
	for (i=0;i<atmp.length;i++) 
	{
		var opt = atmp[i];
		var valu=valarr[i];
		ai.options[i+1] = new Option(opt,valu);
		if(valu==fileName)
		{
			ai.options[i+1].selected = true;
		}		
	}
}

function openUploadedMibFile(fileName)
{
	if(fileName!=null && fileName!="null" && fileName!="")
	{
		var mibFileList=document.genMeasure.fileList;
		var mibFileListLength=mibFileList.options.length;
		var fname="";
		var flag=0;
		var mibFileListIndex=mibFileListLength;
		for(var i=0;i<mibFileList.options.length;i++)
		{
			fname=document.genMeasure.fileList.options[i].value;
			if(fname==fileName)
			{
				mibFileListIndex=i;
				flag=1;
			}

		}
		if(flag==0)
		{
			mibFileList.options[mibFileListIndex]=new Option(fileName,fileName);
		}
		sortAvailable("fileList",fileName);
		showTree('select');
	}
	
}

var httpReq=false;
function  showTree(opt)
{
	
	var fileName=document.genMeasure.fileList.options[document.genMeasure.fileList.selectedIndex].value;
	
	var fieldName=document.genMeasure.fieldName.value;
	var from=document.genMeasure.from.value;
	var oid=""; 
	
	if(fieldName=="ObjectOID")
	{
			oid=document.addMeasure.oid.value;
	}
	if(fieldName=="ElementOID")
	{
		oid=document.genMeasure.elementOid.value
		if(oid=="")
		{
				oid='<%=elementOid%>';
		}
	}
	if(fieldName=="StatusOID")
	{
		oid=document.genMeasure.validOid.value
		if(oid=="")
		{
				oid='<%=validOid%>';
		}
	}
	var refreshURL = 'mibTree.jsp?MibFileName='+fileName+"&fieldName="+fieldName+"&from="+from+"&oid="+oid;
	if(opt=="select")
	{
		refreshURL = 'mibTree.jsp?MibFileName='+fileName+"&fieldName="+fieldName+"&from="+from;
	}
	if(fileName!="-1" || fileName!="")
	{
		loading();
	}
	if (window.XMLHttpRequest)
	{
		httpReq = new XMLHttpRequest();
		if (httpReq.overrideMimeType)
		{
			httpReq.overrideMimeType('text');
		}
	}
	else if (window.ActiveXObject)
	{
		try
		{
			httpReq = new ActiveXObject("Msxml2.XMLHTTP");
		}
		catch (e)
		{
			try
			{
				httpReq = new ActiveXObject("Microsoft.XMLHTTP");
			}
			catch (e)
			{
			}
		}
	}
	if (!httpReq)
	{
		alert('<egui:intnl text="monitor.home.Giving up -Cannot create an XMLHTTP instance"/>');
		return false;
	}
	httpReq.onreadystatechange = writeRes;
	httpReq.open('GET',refreshURL, true);
	httpReq.send(null);
}

function writeRes()
{
	if (httpReq.readyState == 4 || httpReq.readyState=="complete")
	{
		if (httpReq.status == 200)
		{
			document.getElementById("Tree").innerHTML=httpReq.responseText;
		}
	}
}


function setOIDField(oidValue,from,fieldName,fileName)
{
		if(oidValue!=null && (oidValue=="null" || oidValue==""))
		{
			if(fieldName=="ObjectOID")
			{
				alert("<egui:intnl text='admin.ic.Please select an Object OID'/>");
			}
			else if(fieldName=="ElementOID")
			{
				alert("<egui:intnl text='admin.ic.Please select an Element OID'/>");
			}
			else if(fieldName=="StatusOID")
			{
				alert("<egui:intnl text='admin.ic.Please select a Status OID'/>");
			}
			return;
		}
		if(document.addMeasure)
		{
					document.addMeasure.fileName.value=fileName;
		}
		document.genMeasure.fileName.value=fileName;
		if(fieldName=="ObjectOID")
		{
				document.genMeasure.oid_fieldName.value=fieldName
				if(document.addMeasure)
				{
					document.addMeasure.oid_fieldName.value=fieldName
				}

		}
		if(fieldName=="ElementOID")
		{
				document.genMeasure.element_fileName.value=fileName;
				document.genMeasure.element_fieldName.value=fieldName
		}
		else if(fieldName=="StatusOID")
		{
				document.genMeasure.status_fileName.value=fileName;
				document.genMeasure.status_fieldName.value=fieldName
		}
		if(from=="config")
		{
			if(fieldName=="ObjectOID")
			{	
					document.getElementById("oid").value=oidValue;
			}
			else if(fieldName=="ElementOID")
			{
					document.getElementById("elementOid").value=oidValue;
			}
			else
			{
					document.getElementById("validOid").value=oidValue;
			}
		}
		else
		{
					document.getElementById("s_oid").value=oidValue;
		}


		if(fieldName=="ObjectOID")
		{
			closeWindow();
		}
		else
		{
			destroyMapWindow('egmap');
		}
		
}
function destroyMapWindow(elementId)
{
	var thisEle  = document.getElementById(elementId);
	var thisEle2 = window.parent.document.getElementById(elementId);
	if(thisEle2!=null)
	{
		try
		{
			window.parent.document.forms[0].removeChild(thisEle2);
		}
		catch (error)
		{			
			var thisDiv = window.parent.document.getElementById("egmap");
			var thisDivParent = thisDiv.parentElement;
			if (thisDiv!=null & thisDivParent!=null)
			{
				//IE should close here
				thisDivParent.removeChild(thisDiv);
			}
		}
	}
	if(thisEle!=null)
	{
		try
		{
			document.forms[0].removeChild(thisEle);
		}
		catch (error)
		{			
			try
			{
				var thisDiv = document.getElementById("egmap");
				var thisDivParent = thisDiv.parentElement;
				if (thisDiv!=null & thisDivParent!=null)
				{
					thisDivParent.removeChild(thisDiv);
				}
			}
			catch(e)
			{
			}
		}
	}
	else
	{
		return;
	}
}

function closeWindow()
{
			document.getElementById("bug_select1").style.visibility = 'visible';
			document.getElementById("bug_select2").style.visibility = 'visible';
			document.getElementById("bug_select3").style.visibility = 'visible';
			destroyMapWindow('egmap');
}

 function destroyMapWindow(elementId)
{
	var thisEle  = document.getElementById(elementId);
	var thisEle2 = window.parent.document.getElementById(elementId);
	if(thisEle2!=null)
	{
		try
		{
			window.parent.document.forms[0].removeChild(thisEle2);
		}
		catch (error)
		{			
			var thisDiv = window.parent.document.getElementById("egmap");
			var thisDivParent = thisDiv.parentElement;
			if (thisDiv!=null & thisDivParent!=null)
			{
				//IE should close here
				thisDivParent.removeChild(thisDiv);
			}
		}
		
	}
	if(thisEle!=null)
	{
		try
		{
			//firefox closes the window here!
			document.forms[0].removeChild(thisEle);
			
		}
		catch (error)
		{			
			
			try
			{
				var thisDiv = document.getElementById("egmap");
				var thisDivParent = thisDiv.parentElement;
				if (thisDiv!=null & thisDivParent!=null)
				{
					thisDivParent.removeChild(thisDiv);
				}
			}
			catch(e)
			{
			}
		}
	}
	else
	{
		return;
	}
}

function setPosition()
{
	document.body.scrollTop = scrollPosition;
}
function templatewindow(test)
{
	var dir='<%=helpuploadDir%>';
	if(!window.remotewin)
	{
		remotewin = window.open("EgTemplateUpload.jsp?uploadFile=true&test="+test+"&dir="+dir+"&addormodify=add&seldivhid=usetemplate&ftype=Admin","DataWin","width=900,height=600,left=50,top=150,scrollbars=0,scrollbars=yes,resizable=no");
	}
	else
	{
		if(!remotewin.closed)
		{
			remotewin = null;
			remotewin = 	remotewin = window.open("EgTemplateUpload.jsp?uploadFile=true&test="+test+"&dir="+dir+"&addormodify=add&seldivhid=usetemplate&ftype=Admin","DataWin","width=900,height=600,left=50,top=150,scrollbars=0,scrollbars=yes,resizable=no");
		}
		else
		{
				remotewin = window.open("EgTemplateUpload.jsp?uploadFile=true&test="+test+"&dir="+dir+"&addormodify=add&seldivhid=usetemplate&ftype=Admin","DataWin","width=900,height=600,left=50,top=150,scrollbars=0,scrollbars=yes,resizable=no");
		}
	}
}

</script>
</head>

<body style="overflow:auto" id="space6" scroll="auto" onload="setPosition()">
<form name="genMeasure" method="POST" action="Egconfigsnmpmeasurep.jsp" style="margin:0px">
<input type="hidden" name="fileName" value='<%=oid_fileName%>'>
<input type="hidden" name="element_fileName" value="<%=element_fileName%>">
<input type="hidden" name="status_fileName" value="<%=status_fileName%>">
<input type="hidden" name="oid_fieldName" value="<%=fieldName%>">
<input type="hidden" name="element_fieldName" value="">
<input type="hidden" name="status_fieldName" value="">
<input type="hidden" name="position" id="position" value="<%=scrollPosition%>"/>

<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
<%
String urlStr = "listSearch.jsp?title= ADD MEASURES FOR "+test+" TEST&leftString=false&backButton=true&subtitle=false";
%>
	<jsp:include page="<%=urlStr%>"/>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
			
<%
	ArrayList measures = testBean.getMeasuresForTest(test);
	if(measures == null || measures.size() == 0)
	{
%>

<!-- FOR 'NO MEASURES' code starts here -->
			<table cellspacing='0' cellpadding='0' align='center' width='85%' border='0'>
				<tr>
						<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
						<td height="6" id="eg_subcontentbg" width="100%"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
						<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					</tr>
					<tr> 
							<td width="100%" align="center" colspan="3" id="eg_subcontentbg"><img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif"></td>
					</tr>
					<tr>
							<td colspan="3" width='100%' align='center' valign='middle' id="eg_subcontentbg" class="eg_subcontent" height='22'><b><egui:intnl text="admin.ic.No measures have been added for this test"/></b></td>
					</tr>
					<tr>
						<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
						<td id="eg_subcontentbg"  width="100%"  valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
						<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
					</tr>

			</table>
			<br>
</form>
<!-- FOR 'NO MEASURES' code ends here -->
<%
	}
	else
	{
		String key = null;
		String value = null;
		String unit = null;
		String tmpInd = null;
		String alarm_msg = null;
		Integer idx;
		String temp = null;
		String procVal = null;
		String factVal = null;
		String org_factor = null;
		String org_measure = null;
		String org_process = null;
		String org_oid = null;
		String tmpUnit = null;
		int ind = 0;
		int count = 0;

		for(int i=0; i<measures.size(); i++)
		{
			temp = (String) measures.get(i);

			ind = temp.indexOf(":");
			if(ind < 0)
					continue;

			if(!isConfigTest)
			{
				key = temp.substring(0, ind);
				temp = temp.substring(ind+1);
				ind = temp.indexOf(":");
				if(ind < 0)
						continue;

				value = temp.substring(0, ind);
				temp = temp.substring(ind + 1);
				ind = temp.indexOf(":");
				if(ind < 0)
						continue;

				unit = temp.substring(0, ind);
				temp = temp.substring(ind + 1);

				//out.println("NEW TEMP is " + temp);
				//new code to effect alarm display string starts
				ind = temp.indexOf(":");
				//out.println("NEW IND is " + ind);
				if(ind < 0)
				{
					alarm_msg = "";
					idx = new Integer(temp.substring(ind + 1));
					//out.println("INDEX is " + index);
				}
				else
				{
					alarm_msg = temp.substring(0, ind);//alarm msg
					idx = new Integer(temp.substring(ind + 1));
				}

				//new code to effect alarm display string ends
				tmpInd = idx.toString();
			}
			else
			{
				key = temp.substring(0, ind);       // measure name

				//out.println("<br>measure name="+key);

				temp=temp.substring(ind+1);			
				ind=temp.indexOf(":");
				if(ind < 0)
					continue;

				unit = temp.substring(0, ind);
				//out.println("<br>unit="+unit);
				temp = temp.substring(ind + 1);
				
				idx = new Integer(temp.substring(0));
				tmpInd = idx.toString();
			}
			tmpUnit = "";
			if(unit.equals("%"))
			{
				tmpUnit = unit;
				for(int x=0;x<tmpUnit.length();x++)
				{
					if(tmpUnit.charAt(x) == '%')
						tmpUnit = tmpUnit.replace('%','|');
					else
						continue;
				}
			}
			else
			{
				tmpUnit = unit;
			}

			count++;
			if(procVals.containsKey(key))
				procVal = (String) procVals.get(key);

			if(factVals.containsKey(key))
				factVal = (String) factVals.get(key);
					
			snmpOID = testBean.getCounterOrOID(test,key,"oid");

			String s_tmpInd = "";
			if(alarm_msg != null)
				s_tmpInd = alarm_msg+":"+tmpInd;
			else
				s_tmpInd = tmpInd;
			
			if(!isConfigTest)
			{
				if(tmpUnit.equals("|"))
					org_measure = key+":"+value+":"+tmpUnit+":"+s_tmpInd;
				else
					org_measure = key+":"+value+":"+unit+":"+ s_tmpInd;
			}
			else
			{
				if(tmpUnit.equals("|"))
					org_measure = key+":"+tmpUnit+":"+s_tmpInd;
				else
					org_measure = key+":"+unit+":"+ s_tmpInd;
			}
			org_process = key+":"+procVal;
			org_factor = key+":"+factVal;
			org_oid = key+":"+snmpOID;
%>

<!-- FOR 'THE RECORDS TO BE REPEATED' code starts here -->
			<table align="center" cellspacing="0" cellpadding="2" width="85%" border="0" id="cell_border1" style="border-top-width:0px">
				<tr id="eg_subheadbg">
					<td  width='100%' align='left' height='22' valign='middle' NOWRAP><div style="float:left;padding:2px"><strong>&nbsp;<%= tmpInd %>.&nbsp;&nbsp;<%= key %></strong></div><div style="float:right;padding-right:10px">
					<input type="button" name="ad" class="eg_lightbutton" value='<egui:intnl text="admin.common.Modify"/>' onClick="javascript:window.location.href='EgModifyMeasures.jsp?org_measure=<%=org_measure%>&org_process=<%=org_process%>&org_factor=<%=org_factor%>&org_oid=<%=org_oid%>&test=<%=test%>&measure=<%=key%>&dbsize=<%=value%>&unit=<%=tmpUnit%>&index=<%=tmpInd%>&process=<%=procVal%>&factor=<%=factVal%>&oid=<%=snmpOID%>&from=EgConfigSnmpMeasure.jsp&alarmdescription=<%=alarm_msg%>'" style="width:60px;">
					&nbsp;&nbsp;<input type="button" name="ad" class="eg_lightbutton" value='<egui:intnl text="admin.common.Delete"/>' onClick="javascript:del('<%=test%>','<%=key%>')" style="width:60px;"></div>
					</td>
				</tr>
				<tr>
					<td id="eg_blankspace" nowrap height="10">&nbsp;</td>
				</tr>
				<tr>
					<td align='left' valign='middle' >
						<table align="center" cellspacing="0" cellpadding="2" width="100%" border="0" style="table-layout:fixed"><col width="35"><col width="270"><col width="20"><col width="450">
<%
		if(!isConfigTest)
		{
%>
							<tr>
								<td>&nbsp;</td>
								<td align='left' height='20'><egui:intnl text="admin.ic.Database column size"/> </td>
								<td>:</td>
								<td align='left'  height='20'> <%= value %></td>
							</tr>
							<tr>
								<td colspan="4" id="eg_blankspace" nowrap height="10">&nbsp;</td>
							</tr>
<%
		}
%>
							<tr>
								<td>&nbsp;</td>
								<td  align='left' valign='middle' height='20'><egui:intnl text="admin.ic.Unit"/></td>
								<td>:</td>
								<td  align='left' valign='middle' height='20'><%= unit %></td>
							</tr>
							<tr>
								<td colspan="2" id="eg_blankspace" nowrap height="5">&nbsp;</td>
							</tr>
							<tr>
								<td>&nbsp;</td>
								<td  align='left' valign='middle' height='20'><egui:intnl text="admin.ic.Process method"/></td>
								<td>:</td>
								<td  align='left' valign='middle' height='20'><%= procVal %></td>
							</tr>
<%
	if(factVal != null && factVal.length() > 0 && !factVal.equals("none"))
	{
%>
							<tr>
								<td colspan="2" id="eg_blankspace" nowrap height="5">&nbsp;</td>
							</tr>
							<tr>
								<td>&nbsp;</td>
								<td  align='left' valign='middle' height='20'><egui:intnl text="admin.ic.Conversion Factor"/></td>
								<td  align='left' valign='middle' height='20'>:</td>
								<td><%= (String) factorsMapping.get(factVal) %></td>
							</tr>
<%
	}
		if(!isConfigTest)
		{
%>
							<tr>
								<td colspan="4" id="eg_blankspace" nowrap height="10">&nbsp;</td>
							</tr>
			<%
					if((alarm_msg != null && alarm_msg.length()>0) )
					{
				%>
							<tr>
								<td>&nbsp;</td>
								<td align='left' valign='middle' height='20'><egui:intnl text="admin.ic.Alarm display string"/></td>
								<td>:</td>
								<td  align='left' valign='middle' height='20'><%= alarm_msg %></td>
							</tr>
							<tr>
								<td colspan="4" id="eg_blankspace" nowrap height="10">&nbsp;</td>
							</tr>
<%
					}
		}
%>
							
							<tr>
								<td>&nbsp;</td>
								<td  align='left' valign='middle' height='20'><egui:intnl text="admin.ic.Object OID"/></td>
								<td>:</td>
								<td align='left' height='20'><%= snmpOID %></td>
							</tr>
							<tr>
								<td colspan="4" id="eg_blankspace" nowrap height="10">&nbsp;</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
			<br>
		<!-- FOR 'THE RECORDS TO BE REPEATED' code ends here -->
		<%
				}
		%>
			<br>
			<table  align="center" cellspacing="0" cellpadding="2" width="85%" border="0" id="cell_border1" style="border-top-width:0px">
				<tr id="eg_subheadbg_lower">
					<td  colspan="2"  width="100%" align = "center" height='20' >
					<input id="eg_input" type="radio" name="elements" value="M" size="60" <%=multiple%> onClick="javascript:callElements('multiple')">&nbsp;<b><egui:intnl text="admin.ic.Multiple elements"/></b>
					<input id="eg_input" type="radio" name="elements" value="S" size="60" <%=single%> onClick="javascript:callElements('single')">&nbsp;<b><egui:intnl text="admin.ic.Single element"/></b>
					</td>
				</tr>
		<%
			if(display != null && !display.equals("null")
				&& display.equals("true"))
			{
		%>
				<tr>
					<td width="100%"  align="center" style="padding:0px">
						<table cellspacing="0" cellpadding="0" width="100%" border="0" style="table-layout:fixed"><col width="35"><col width="270"><col width="20"><col width="450">
							<tr>
								<td id="eg_blankspace" nowrap height="10" colspan="4">&nbsp;</td>
							</tr>
							<tr>
								<td>&nbsp;</td>
								<td  height='20'><egui:intnl text="admin.ic.Element ID(OID)"/> </td>
								<td >:</td>
								<td>
									<table border="0" cellpadding="0" cellspacing="0">
										<tr>
											<td><input type="text" name="elementOid" id ="elementOid" value="<%= elementOid %>" size="60">&nbsp;</td>
											<td><img id='mouse' border="0" onclick="openWin(event,'config','ElementOID')"   title="Tree" src="/final/admin/eg_images/<%=admin_Skin%>/tree.gif" width="16" height="14"/></td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td id="eg_blankspace" nowrap height="10" colspan="4">&nbsp;</td>
							</tr>
							<tr>
								<td>&nbsp;</td>
								<td  height='20'><egui:intnl text="admin.ic.Element status (OID)"/></td>
								<td >:</td>
								<td >
									<table border="0" cellpadding="0" cellspacing="0">
										<tr>
											<td> <input type="text" name="validOid"  id="validOid" value="<%= validOid %>" size="60">&nbsp;</td>
											<td><img id='mouse' border="0" onclick="openWin(event,'config','StatusOID')"  title="Tree" src="/final/admin/eg_images/<%=admin_Skin%>/tree.gif" width="16" height="14" /></td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td id="eg_blankspace" nowrap height="10" colspan="4">&nbsp;</td>
							</tr>
							<tr>
								<td>&nbsp;</td>
								<td><egui:intnl text="admin.ic.Element valid status (Value)"/></td>
								<td >:</td>
								<td ><input type="text" name="validValue" value="<%= validValue %>" size="60"></td>
							</tr>
							<tr>
								<td id="eg_blankspace" nowrap height="10" colspan="4">&nbsp;</td>
							</tr>
							<tr>
								<td>&nbsp;</td>
								<td><egui:intnl text="admin.ic.Rediscovery period(In mins)"/></td>
								<td >:</td>
								<td ><input type="text" name="rediscPeriod" value="<%= rediscPeriod %>" size="60">
								</td>
							</tr>
							<!-- <tr>
								<td id="eg_blankspace" nowrap height="10" colspan="4">&nbsp;</td>
							</tr> -->
						</table>
					</td>
				</tr>
				

<%
	}

	   if(isConfigTest)
	   {
			int ss=getConfigTestSizeIndex(iConfigFieldSize);
%>
				<tr>
					<td id="eg_blankspace" nowrap height="10" colspan="4">&nbsp;</td>
				</tr>

				<tr>
					<td  width="100%" align="left" height='20' style="padding:0px"> 
						<table cellspacing="0" cellpadding="0" width="100%" border="0" style="table-layout:fixed"><col width="35"><col width="270"><col width="20"><col width="450">
							<tr>
								<td>&nbsp;</td>
								<td ><egui:intnl text="admin.ic.Database column size"/></td>
								<td >:</td>
								<td  nowrap align="left">
								<select name="dbsize" style='width:70;' id="bug_select1">
								<option value="1" <%= ss==1?"selected":"" %>>32</option>
								<option value="2" <%= ss==2?"selected":"" %>>64</option>
								<option value="3" <%= ss==3?"selected":"" %>>128</option>
								<option value="4" <%= ss==4?"selected":"" %>>256</option>
								<option value="5" <%= ss==5?"selected":"" %>>512</option>
								<option value="6" <%= ss==6?"selected":"" %>>1024</option>
								</select>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td id="eg_blankspace" nowrap height="5" >&nbsp;</td>
				</tr>

<%
	 }
%>
				<tr>
					<td id="eg_blankspace" nowrap height="10" >&nbsp;</td>
				</tr>
				<tr>
					<td  width="100%" colspan="2" align="center" height='20'>
	<!--
	<SPAN ID="genImg" STYLE="position:relative; visibility:visible;">
	-->
					<input type="button" name="AddHelp" value='<egui:intnl text="admin.ic.Add Help"/>' class="eg_back" onClick="templatewindow('<%=test%>')" style="width: 80px;">
					<input type="button" name="genImg" class="eg_back" value='<egui:intnl text="admin.ic.Generate"/>' onClick="JavaScript:genTest();" style="width: 80px;">
	<!--
	</SPAN>
	-->
					</td>
				</tr>
				<tr>
					<td id="eg_blankspace" nowrap height="10" colspan="2">&nbsp;</td>
				</tr>
				
			</table>
			<br><br>
			
				
			
				<input type="hidden" name="add" value="gen">
				<input type="hidden" name="test" value="<%= test %>">
				<input type="hidden" name="validate" value="<%=display%>">

</form>
<%
	}	
%>
<form name="addMeasure" method="get" action="Egconfigsnmpmeasurep.jsp" onSubmit="return addMeasure1('formsubmit')">
<input type="hidden" name="position" id="position" value="<%=scrollPosition%>"/>
<input type="hidden" name="fileName" value='<%=oid_fileName%>'>
<input type="hidden" name="element_fileName" value="<%=element_fileName%>">
<input type="hidden" name="status_fileName" value="<%=status_fileName%>">
<input type="hidden" name="oid_fieldName" value="<%=fieldName%>">
<input type="hidden" name="element_fieldName" value="">
<input type="hidden" name="status_fieldName" value="">
	<input type=hidden name=configtestflag value=<%= isConfigTest?"true":"" %>>
			<table align="center" cellspacing="0" cellpadding="0" width="85%"  border="0" name="Add Transaction Table" >
				<tr>
					<th  nowrap height="22" align="left" id="eg_subheadbg">&nbsp;<egui:intnl text="admin.ic.New measure details"/></th>
				</tr>
				<tr>
					<td id="cell_border1">
						<table cellspacing="0" cellpadding="2" width="100%" border="0" style="table-layout:fixed"><col width="35"><col width="270"><col width="20"><col width="450">
							<tr>
								<td id="eg_blankspace" nowrap height="10" colspan="4">&nbsp;</td>
							</tr>
							<tr>
								<td>&nbsp;</td>
								<td  align='left' ><egui:intnl text="admin.ic.Measure index"/></td>
								<td >:</td>
								<td align='left'>
								<input type="text" name="index" value="<%=++i_mes_count%>" style="width:180px" onfocus="this.blur()">
								</td>
							</tr>
							<tr>
								<td id="eg_blankspace" nowrap height="10" colspan="3">&nbsp;</td>
							</tr>
							<tr>
								<td>&nbsp;</td>
								<td  align='left' ><egui:intnl text="admin.ic.Measure name"/></td>
								<td >:</td>
								<td align="left">
<%
								String flag1 = request.getParameter("flag1");
								if (flag1 !=null && flag1.equals("true"))
								{
%>
								<input type="text" name="measure" value="<%= mname %>" size="20" maxlength="24" style='width:180;'>
<%
								}
								else
								{
									mname = "";
%>
								<input type="text" name="measure" value="<%= mname %>" size="20" maxlength="24" style='width:180;'>
<%
								}
%>
								
								</td>
							</tr>
							<tr>
								<td id="eg_blankspace" nowrap height="10" colspan="4">&nbsp;</td>
							</tr>
<%
		if(!isConfigTest)
		{
%>
							<tr>
								<td>&nbsp;</td>
								<td  valign="middle" align='left' ><egui:intnl text="admin.ic.Database column size"/></td>
								<td >:</td>
								<td  align="left" >
<!--     		<% if(!isConfigTest)
				{%>
-->
								<select name="dbsize" style='width:180;' id="bug_select1">
								<option value="2" <%= size2 %>><egui:intnl text="admin.ic.Number"/>(20,4)</option>
								<option value="1" <%= size1 %>><egui:intnl text="admin.ic.Number"/>(7,4)</option>
								<option value="3" <%= size3 %>><egui:intnl text="admin.ic.Number"/>(16)</option>
								</select>
<!--				<%}else{%>
				<select name="dbsize" style='width:180;'>
					<option value="1" <%= size1 %>>Varchar2(32)</option>
					<option value="2" <%= size2 %>>Varchar2(64)</option>
					<option value="3" <%= size3 %>>Varchar2(128)</option>
				</select>
		     <%}%>
-->
								</td>
							</tr>
							<tr>
								<td id="eg_blankspace" nowrap height="10" colspan="4">&nbsp;</td>
							</tr>
		<%
		}
			if(unitValue == null || unitValue.length() == 0)
			{
		%>
							<tr>
								<td>&nbsp;</td>
								<td align="left"><egui:intnl text="admin.ic.Unit"/></td>
								<td >:</td>
								<td  align="left">
								<select name="un" onchange='Javascript:listSelect("unit")' style='width:180;' id="bug_select2">
								<option value="-1"><egui:intnl text="admin.ic.Please select a unit"/></option>
					<%
							if(units != null && units.size() > 0)
							{
								for(int i=0; i<units.size(); i++)
								{
									String un = (String) units.get(i);
									if(un.equals("%"))
										continue;
					%>
								<option value="<%= un %>"><%= un %></option>
					<%
								}
							}
					%>
								<option value="other"><egui:intnl text="admin.ic.Other"/></option>
								</select>
								</td>
							</tr>
							<tr>
								<td id="eg_blankspace" nowrap height="10" colspan="4">&nbsp;</td>
							</tr>
		<%
			}
			else if(!unitValue.equals("other"))
			{
		%>
							<tr>
								<td>&nbsp;</td>
								<td  align="left" ><egui:intnl text="admin.ic.Unit"/></td>
								<td >:</td>
								<td  align="left" >
								<select name="un" onchange='Javascript:listSelect("unit")' style='width:180;' id="bug_select2">
								<option value="-1"><egui:intnl text="admin.ic.Please select a unit"/></option>
				<%
						if(units != null && units.size() > 0)
						{
							for(int i=0; i<units.size(); i++)
							{
								String selected = "";
								String un = (String) units.get(i);
								if(un.equals("%"))
									continue;
								if(un.equals(unitValue))
									selected = "selected";
				%>
								<option <%= selected %> value="<%= un %>"><%= un %></option>
				<%
							}
						}
				%>
								<option value="other"><egui:intnl text="admin.ic.Other"/></option>
								</select>
								</td>
							</tr>
							<tr>
								<td id="eg_blankspace" nowrap height="10" colspan="3">&nbsp;</td>
							</tr>
		<%
			}
			else
			{
		%>
							<tr>
								<td>&nbsp;</td>
								<td align="left" ><egui:intnl text="admin.ic.Unit"/></td>
								<td nowrap >:</td>
								<td align="left" >
								<select name="un" onchange='Javascript:listSelect("unit")' style='width:180;' id="bug_select2">
								<option value="-1"><egui:intnl text="admin.ic.Please select a unit"/></option>
					<%
							if(units != null && units.size() > 0)
							{
								for(int i=0; i<units.size(); i++)
								{
									String un = (String) units.get(i);
									if(un.equals("%"))
										continue;
					%>
								<option value="<%= un %>"><%= un %></option>
					<%
								}
							}
					%>
								<option selected value="other"><egui:intnl text="admin.ic.Other"/></option>
								</select>
								</td>
							</tr>
							<tr>
								<td id="eg_blankspace" nowrap height="10" colspan="4">&nbsp;</td>
							</tr>
							<tr>
								<td>&nbsp;</td>
								<td align="left" ><egui:intnl text="admin.ic.Other"/></td>
								<td  nowrap>:</td>
								<td align="left" >
								<input type="text" name="otherunit" size="20" maxlength="64" style='width:180;'>
								</td>
							</tr>
							<tr>
								<td id="eg_blankspace" nowrap height="10" colspan="4">&nbsp;</td>
							</tr>
			<%
				}
			%>
							<tr>
								<td>&nbsp;</td>
								<td  align="left" ><egui:intnl text="admin.ic.Process method"/></td>
								<td >:</td>
								<td  align="left"  ><select name="process" style='width:180;' id="bug_select3" onchange='Javascript:listSelect("process")'>
			<%
				for(int i=0; i<processes.length; i++)
				{
					String tmpProc = processes[i];
					String tmpSel = procSel[i];
			%>
								<option value="<%= tmpProc %>" <%= tmpSel %>><%= tmpProc %>
			<%
				}
			%>
								</select>
								</td>
							</tr>
<%
		if(isFactorEnabled)
		{
%>
							<tr>
								<td id="eg_blankspace" nowrap height="10" colspan="4">&nbsp;</td>
							</tr>
							<tr id="tr2">
								<td>&nbsp;</td>
								<td align="left"  nowrap ><egui:intnl text="admin.ic.Conversion Factor"/></td>
								<td nowrap>:</td>
								<td  align="left"  nowrap  >
								<select name="cFactor" style="width:180px" onchange="javascript:factorSelect()" >
<%
			String tmpFact = "none";
			for(int i=0; i<factors.length; i++)
			{
				String fact = iniUI.getValue("CONVERSION_FACTORS", factors[i].toString());
				String tmpSel = factorSel[i];
				if(tmpSel.equals("selected"))
				{
					tmpFact = fact;
				}
%>
									<option  value="<%= fact %>" <%= tmpSel %>><%= factors[i].toString() %></option>
<%
			}
%>
								</select>
								<input type="hidden" name="factor" id="factor" value="<%= tmpFact %>"/>
								</td>
							</tr>
<%
		}
		if(!isConfigTest)
		{
%>
							<tr>
								<td id="eg_blankspace" nowrap height="10" colspan="4">&nbsp;</td>
							</tr>
							<tr>
								<td>&nbsp;</td>
								<td  align='left'><egui:intnl text="admin.ic.Alarm display string"/></td>
								<td >:</td>
								<td  align='left'>
								<input type="text" name="alarmdescription" maxlength="75" style='width:180;'></td>
							</tr>
							
<%
		}
%>
							<tr>
									<td id="eg_blankspace" nowrap height="10" colspan="4">&nbsp;</td>
							</tr>
							<tr>
								<td>&nbsp;</td>
								<td  align='left'><egui:intnl text="admin.ic.Object OID"/></td>
								<td >:</td>
								<td   align="left">
									<table border="0" cellpadding="0" cellspacing="0">
										<tr>
											<td> 
											<%
											String oidFlag = request.getParameter("oidFlag");
											if (oidFlag != null && oidFlag.equals("true"))
											{
											%>
											<input type="text" name="oid"  id="oid" value="<%= oid %>" size="20" maxlength="100" style='width:180;'>&nbsp;
											<%
											}
											else
											{
												oid = "";
											%>
											<input type="text" name="oid"  id="oid" value="<%= oid %>" size="20" maxlength="100" style='width:180;'>&nbsp;
											<%
											}
											%>
											</td>
											<td><img id='mouse' border="0" onclick="openWin(event,'config','ObjectOID')"   title="Tree" src="/final/admin/eg_images/<%=admin_Skin%>/tree.gif"  width="16" height="14"/></td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
									<td id="eg_blankspace" nowrap height="10" colspan="4">&nbsp;</td>
							</tr>
							
							
						</table>
					</td>
				</tr>
				<tr>
									<td id="eg_blankspace" nowrap height="10" >&nbsp;</td>
							</tr>
				<tr>
								<td width="100%" align="center"  nowrap>
					<!--
									<SPAN ID="updateImg" STYLE="position:relative; visibility:visible;">
					-->
									<input type="button" name="ad" class="eg_back" value='<egui:intnl text="admin.common.Add"/>' onClick="JavaScript:addMeasure1('buttonsubmit');" style="width: 80px;">
					<!--
									</SPAN>
					-->
								</td>
							</tr>
							<tr>
									<td id="eg_blankspace" nowrap height="10" >&nbsp;</td>
							</tr>
			</table><br>
		</td>
	<!-- <td width="2" id="eg_inborder" background="eg_images/in_rightbg.gif" nowrap>&nbsp;</td> -->
	</tr>
<!-- <tr>
	<td width="2" id="eg_inborder" background="eg_images/in_leftbg.gif" nowrap>
		<img src="eg_images/in_botleft.gif" width="2" height="2" hspace="0" vspace="0">
	</td>
	<td width="100%" id="eg_inborder" background="eg_images/in_botbg.gif">&nbsp;</td>
	<td width="2" id="eg_inborder" background="eg_images/in_rightbg.gif" nowrap><img src="eg_images/in_botright.gif" width="2" height="2" hspace="0" vspace="0"></td>
</tr> -->
</table>
<input type="hidden" name="add" value="add">
<input type="hidden" name="test" value="<%= test %>">
</form>
<a name="kk">&nbsp;</a>
</body>
</html>
<%
	if(request.getQueryString()!=null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgConfigSnmpMeasure.jsp?"+request.getQueryString());
	}
%>



